/*
 * SPDX-License-Identifier: MIT
 *
 * Copyright (c) 2019 Philippe Proulx <pproulx@efficios.com>
 */

#ifndef BABELTRACE_LIB_FUNC_STATUS_H
#define BABELTRACE_LIB_FUNC_STATUS_H

#define __BT_IN_BABELTRACE_H
#include <babeltrace2/func-status.h>

/*
 * Aliases without a `__` prefix for internal code: this is just easier
 * to read.
 */
#define BT_FUNC_STATUS_AGAIN		__BT_FUNC_STATUS_AGAIN
#define BT_FUNC_STATUS_END		__BT_FUNC_STATUS_END
#define BT_FUNC_STATUS_USER_ERROR	__BT_FUNC_STATUS_USER_ERROR
#define BT_FUNC_STATUS_ERROR		__BT_FUNC_STATUS_ERROR
#define BT_FUNC_STATUS_INTERRUPTED	__BT_FUNC_STATUS_INTERRUPTED
#define BT_FUNC_STATUS_UNKNOWN_OBJECT	__BT_FUNC_STATUS_UNKNOWN_OBJECT
#define BT_FUNC_STATUS_MEMORY_ERROR	__BT_FUNC_STATUS_MEMORY_ERROR
#define BT_FUNC_STATUS_NO_MATCH		__BT_FUNC_STATUS_NO_MATCH
#define BT_FUNC_STATUS_NOT_FOUND	__BT_FUNC_STATUS_NOT_FOUND
#define BT_FUNC_STATUS_OK		__BT_FUNC_STATUS_OK
#define BT_FUNC_STATUS_OVERFLOW_ERROR	__BT_FUNC_STATUS_OVERFLOW_ERROR

#endif /* BABELTRACE_LIB_FUNC_STATUS_H */
