/*******************************************************************************
 * Copyright (c) 2000, 2019 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.aspectj.org.eclipse.jdt.internal.compiler.parser;

/**
 * IMPORTANT NOTE: These constants are dedicated to the internal Scanner implementation.
 * It is mirrored in org.aspectj.org.eclipse.jdt.core.compiler public package where it is API.
 * The mirror implementation is using the backward compatible ITerminalSymbols constant
 * definitions (stable with 2.0), whereas the internal implementation uses TerminalTokens
 * which constant values reflect the latest parser generation state.
 */
/**
 * Maps each terminal symbol in the java-grammar into a unique integer.
 * This integer is used to represent the terminal when computing a parsing action.
 *
 * Disclaimer : These constant values are generated automatically using a Java
 * grammar, therefore their actual values are subject to change if new keywords
 * were added to the language (for instance, 'assert' is a keyword in 1.4).
 */
public interface TerminalTokens {

	// special tokens not part of grammar - not autogenerated
	int TokenNameNotAToken = 0,
							TokenNameWHITESPACE = 1000,
							TokenNameCOMMENT_LINE = 1001,
							TokenNameCOMMENT_BLOCK = 1002,
							TokenNameCOMMENT_JAVADOC = 1003;

    int TokenNameIdentifier = 2,
    	      TokenNameabstract = 36,
    	      TokenNameassert = 79,
    	      TokenNameboolean = 115,
    	      TokenNamebreak = 80,
    	      TokenNamebyte = 116,
    	      TokenNamecase = 103,
    	      TokenNamecatch = 104,
    	      TokenNamechar = 117,
    	      TokenNameclass = 70,
    	      TokenNamecontinue = 81,
    	      TokenNameconst = 137,
    	      TokenNamedefault = 110,
    	      TokenNamedo = 82,
    	      TokenNamedouble = 118,
    	      TokenNameelse = 111,
    	      TokenNameenum = 76,
    	      TokenNameextends = 102,
    	      TokenNamefalse = 57,
    	      TokenNamefinal = 37,
    	      TokenNamefinally = 107,
    	      TokenNamefloat = 119,
    	      TokenNamefor = 83,
    	      TokenNamegoto = 138,
    	      TokenNameif = 84,
    	      TokenNameimplements = 113,
    	      TokenNameimport = 105,
    	      TokenNameinstanceof = 31,
    	      TokenNameint = 120,
    	      TokenNameopens = 124,
    	      TokenNameinterface = 73,
    	      TokenNamelong = 121,
    	      TokenNamenative = 38,
    	      TokenNamenew = 39,
    	      TokenNamenull = 58,
    	      TokenNamepackage = 101,
    	      TokenNameprivate = 40,
    	      TokenNameprotected = 41,
    	      TokenNamepublic = 42,
    	      TokenNamereturn = 85,
    	      TokenNameshort = 122,
    	      TokenNamestatic = 33,
    	      TokenNamestrictfp = 43,
    	      TokenNamesuper = 50,
    	      TokenNameswitch = 67,
    	      TokenNamesynchronized = 34,
    	      TokenNamethis = 51,
    	      TokenNamethrow = 77,
    	      TokenNamethrows = 108,
    	      TokenNametransient = 44,
    	      TokenNametrue = 59,
    	      TokenNametry = 86,
    	      TokenNamevoid = 123,
    	      TokenNamevolatile = 45,
    	      TokenNamewhile = 78,
    	      TokenNamemodule = 125,
    	      TokenNameopen = 126,
    	      TokenNamerequires = 127,
    	      TokenNametransitive = 131,
    	      TokenNameexports = 128,
    	      TokenNameto = 133,
    	      TokenNameuses = 129,
    	      TokenNameprovides = 130,
    	      TokenNamewith = 134,
    	      TokenNameaspect = 9,
    	      TokenNamepointcut = 12,
    	      TokenNamearound = 16,
    	      TokenNamebefore = 13,
    	      TokenNameafter = 14,
    	      TokenNamedeclare = 15,
    	      TokenNameprivileged = 11,
    	      TokenNameIntegerLiteral = 60,
    	      TokenNameLongLiteral = 61,
    	      TokenNameFloatingPointLiteral = 62,
    	      TokenNameDoubleLiteral = 63,
    	      TokenNameCharacterLiteral = 64,
    	      TokenNameStringLiteral = 65,
    	      TokenNameTextBlock = 66,
    	      TokenNamePLUS_PLUS = 5,
    	      TokenNameMINUS_MINUS = 6,
    	      TokenNameEQUAL_EQUAL = 52,
    	      TokenNameLESS_EQUAL = 55,
    	      TokenNameGREATER_EQUAL = 56,
    	      TokenNameNOT_EQUAL = 32,
    	      TokenNameLEFT_SHIFT = 53,
    	      TokenNameRIGHT_SHIFT = 25,
    	      TokenNameUNSIGNED_RIGHT_SHIFT = 29,
    	      TokenNamePLUS_EQUAL = 88,
    	      TokenNameMINUS_EQUAL = 89,
    	      TokenNameMULTIPLY_EQUAL = 90,
    	      TokenNameDIVIDE_EQUAL = 91,
    	      TokenNameAND_EQUAL = 92,
    	      TokenNameOR_EQUAL = 93,
    	      TokenNameXOR_EQUAL = 94,
    	      TokenNameREMAINDER_EQUAL = 95,
    	      TokenNameLEFT_SHIFT_EQUAL = 96,
    	      TokenNameRIGHT_SHIFT_EQUAL = 97,
    	      TokenNameUNSIGNED_RIGHT_SHIFT_EQUAL = 98,
    	      TokenNameOR_OR = 30,
    	      TokenNameAND_AND = 28,
    	      TokenNamePLUS = 10,
    	      TokenNameMINUS = 20,
    	      TokenNameNOT = 71,
    	      TokenNameREMAINDER = 22,
    	      TokenNameXOR = 47,
    	      TokenNameAND = 24,
    	      TokenNameMULTIPLY = 19,
    	      TokenNameOR = 46,
    	      TokenNameTWIDDLE = 74,
    	      TokenNameDIVIDE = 23,
    	      TokenNameGREATER = 48,
    	      TokenNameLESS = 21,
    	      TokenNameLPAREN = 3,
    	      TokenNameRPAREN = 17,
    	      TokenNameLBRACE = 49,
    	      TokenNameRBRACE = 54,
    	      TokenNameLBRACKET = 4,
    	      TokenNameRBRACKET = 99,
    	      TokenNameSEMICOLON = 18,
    	      TokenNameQUESTION = 26,
    	      TokenNameCOLON = 72,
    	      TokenNameCOMMA = 35,
    	      TokenNameDOT = 1,
    	      TokenNameEQUAL = 68,
    	      TokenNameAT = 27,
    	      TokenNameELLIPSIS = 109,
    	      TokenNameARROW = 114,
    	      TokenNameCOLON_COLON = 7,
    	      TokenNameBeginLambda = 69,
    	      TokenNameBeginIntersectionCast = 75,
    	      TokenNameBeginTypeArguments = 106,
    	      TokenNameElidedSemicolonAndRightBrace = 135,
    	      TokenNameAT308 = 8,
    	      TokenNameAT308DOTDOTDOT = 132,
    	      TokenNameBeginCaseExpr = 136,
    	      TokenNameRestrictedIdentifierYield = 112,
    	      TokenNameRestrictedIdentifierrecord = 87,
    	      TokenNameEOF = 100,
    	      TokenNameERROR = 139;
}
