// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __JPAdvice_h__
#define __JPAdvice_h__

#include <iostream>
using namespace std;

#include "Puma/Array.h"
#include "Puma/ACTree.h"
using namespace Puma;

#include "ThisJoinPoint.h"
#include "BackEndProblems.h"

class AdviceInfo;
class Condition;

class JPAdvice
 {
      int _depth;
      Array<AdviceInfo*> _before;
      JPAdvice *_next;
      JPAdvice *_parent;
      AdviceInfo *_around;
      bool _conditional_around;
      Array<AdviceInfo*> _after;
      ThisJoinPoint _tjp;
   public:
      JPAdvice () : _depth (0), _next ((JPAdvice*)0), _parent ((JPAdvice*)0),
        _around((AdviceInfo*)0) {}
      ~JPAdvice () { if (_next) delete _next; }
      void do_before (AdviceInfo *ai, const Condition &cond);
      void do_after (AdviceInfo *ai, const Condition &cond);
      void do_around (AdviceInfo *ai, const Condition &cond);
      int depth () { return _depth; }
      JPAdvice *next () { return _next; }
      int before () { return _before.length (); }
      AdviceInfo *before (int n) { return _before[n]; }
      AdviceInfo *around () { return _around; }
      int after () { return _after.length (); }
      AdviceInfo *after (int n) { return _after[n]; }
      friend ostream &operator << (ostream &out, JPAdvice &ejp);
      
      void mergeTJPFlags();
      const ThisJoinPoint &tjp () const { return _tjp; }
      void gen_binding_templates (ostream &out, const char *jpname,
                                  const BackEndProblems &bep);
      JPAdvice *parent () { return _parent; }
      JPAdvice *root () { return _parent ? _parent->root () : this; }
      int max_depth () { return root ()->depth (); }

 private:
      void addTJPFlags(AdviceInfo &advice);
      void next_level ();
 };

ostream &operator << (ostream &out, JPAdvice &ejp);

#endif // __JPAdvice_h__
