/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 13:15:14 GMT 2018
 */

package uk.ac.sanger.artemis.sequence;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerChangeEvent;
import uk.ac.sanger.artemis.sequence.MarkerChangeListener;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class Marker_ESTest extends Marker_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      Bases bases1 = mock(Bases.class, new ViolatedAssumptionAnswer());
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn("5", "5", "Fn;NQ?/vS[R^-x", "5").when(strand0).toString();
      doReturn(bases0, bases1).when(strand0).getBases();
      doReturn((-5), 1, (-3396)).when(strand0).getRawPosition(anyInt());
      doReturn(1937, 100).when(strand0).getSequenceLength();
      Marker marker0 = new Marker(strand0, 1);
      marker0.getRawPosition();
      Marker marker1 = marker0.moveBy(1);
      Marker marker2 = Marker.getRawLowest(marker1, marker0);
      assertEquals(2, marker1.getPosition());
      assertSame(marker2, marker0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      Bases bases1 = mock(Bases.class, new ViolatedAssumptionAnswer());
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn("", "", "").when(strand0).toString();
      doReturn(bases0, bases1).when(strand0).getBases();
      doReturn(1423, 107).when(strand0).getSequenceLength();
      Marker marker0 = new Marker(strand0, 58);
      Marker marker1 = marker0.moveBy(0);
      boolean boolean0 = marker0.equals(marker1);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      Bases bases1 = mock(Bases.class, new ViolatedAssumptionAnswer());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      Bases bases1 = mock(Bases.class, new ViolatedAssumptionAnswer());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      // Undeclared exception!
      try { 
        Marker.getRawLowest((Marker) null, (Marker) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Marker", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      doReturn((Sequence) null).when(bases0).getSequence();
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(0).when(strand0).getSequenceLength();
      Marker marker0 = null;
      try {
        marker0 = new Marker(strand0, 2);
        fail("Expecting exception: Exception");
      
      } catch(Throwable e) {
         //
         // position: 2
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Marker marker0 = null;
      try {
        marker0 = new Marker((Strand) null, (-1313));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      Bases bases1 = mock(Bases.class, new ViolatedAssumptionAnswer());
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn("").when(strand0).toString();
      doReturn(bases0, bases1).when(strand0).getBases();
      doReturn(1423, 107).when(strand0).getSequenceLength();
      Marker marker0 = new Marker(strand0, 58);
      Marker marker1 = marker0.moveBy(7);
      boolean boolean0 = marker0.equals(marker1);
      assertEquals(65, marker1.getPosition());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(1423).when(strand0).getSequenceLength();
      Marker marker0 = new Marker(strand0, 58);
      int int0 = marker0.getPosition();
      assertEquals(58, int0);
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      doReturn((Sequence) null).when(bases0).getSequence();
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(0).when(strand0).getSequenceLength();
      Marker marker0 = null;
      try {
        marker0 = new Marker(strand0, 58);
        fail("Expecting exception: Exception");
      
      } catch(Throwable e) {
         //
         // position: 58
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }
}
