/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 10:25:57 GMT 2018
 */

package uk.ac.sanger.artemis.chado;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.FileDescriptor;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.JPasswordField;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.homol.SimilarityPairFeature;
import org.biojava.bio.seq.impl.SimpleFeature;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFileReader;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.chado.ArtemisUtils;
import uk.ac.sanger.artemis.chado.IBatisDAO;
import uk.ac.sanger.artemis.chado.JdbcDAO;
import uk.ac.sanger.artemis.components.SelectionViewer;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.ChadoCanonicalGene;
import uk.ac.sanger.artemis.io.DatabaseInferredFeature;
import uk.ac.sanger.artemis.io.DatabaseStreamFeature;
import uk.ac.sanger.artemis.io.EmblStreamFeature;
import uk.ac.sanger.artemis.io.GFFStreamFeature;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.util.LinePushBackReader;
import uk.ac.sanger.artemis.util.StringVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class ArtemisUtils_ESTest extends ArtemisUtils_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Key key0 = new Key("");
      Range range0 = new Range(125, 125);
      Location location0 = new Location(range0);
      QualifierVector qualifierVector0 = new QualifierVector();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(gFFStreamFeature0);
      // Undeclared exception!
      try { 
        ArtemisUtils.getAnalysisFeature("", "", databaseStreamFeature0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.chado.ArtemisUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      StringVector stringVector0 = SelectionViewer.getBaseSummary("%2C");
      ArtemisUtils.getString(stringVector0, "%2C");
      Key key0 = new Key("%2C");
      Range range0 = new Range(2894);
      Location location0 = new Location(range0);
      Location location1 = location0.copy();
      Location location2 = location1.changeRange(range0, range0);
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      DatabaseInferredFeature databaseInferredFeature0 = new DatabaseInferredFeature(key0, location2, (QualifierVector) null, chadoCanonicalGene0);
      // Undeclared exception!
      try { 
        ArtemisUtils.getMatchFeatureWithFeatureRelations("%2C", "", "", databaseInferredFeature0, true);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // Array index out of range: 0
         //
         verifyException("java.util.Vector", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      StringVector stringVector0 = new StringVector();
      StringVector stringVector1 = new StringVector(stringVector0);
      stringVector1.retainAll(stringVector0);
      stringVector1.add("MH`rS");
      stringVector0.add(stringVector1);
      ArtemisUtils.getString(stringVector1, "");
      JPasswordField jPasswordField0 = new JPasswordField("  -> ", 0);
      JdbcDAO jdbcDAO0 = null;
      try {
        jdbcDAO0 = new JdbcDAO("MH`rS", jPasswordField0);
        fail("Expecting exception: SQLException");
      
      } catch(Throwable e) {
         //
         // No suitable driver found for jdbc:postgresql:/null?
         //
         verifyException("java.sql.DriverManager", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      Key key0 = Key.CDS;
      blastEntryInformation0.getValidQualifierNames(key0);
      String string0 = "~B+`P#%pi;\\u";
      // Undeclared exception!
      try { 
        ArtemisUtils.getString((StringVector) null, string0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.chado.ArtemisUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      StringVector stringVector0 = SelectionViewer.getBaseSummary("h$@k.x\"-[f*VP5U3");
      stringVector0.add("");
      ArtemisUtils.getString(stringVector0, "AoV=/#e1b\"Hft");
      FileDescriptor fileDescriptor0 = new FileDescriptor();
      MockFileReader mockFileReader0 = new MockFileReader(fileDescriptor0);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(mockFileReader0);
      // Undeclared exception!
      try { 
        EmblStreamFeature.readFromStream(linePushBackReader0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      // Undeclared exception!
      try { 
        ArtemisUtils.getMatchFeatureWithFeatureRelations((String) null, "", (String) null, (GFFStreamFeature) null, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.chado.ArtemisUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      // Undeclared exception!
      try { 
        ArtemisUtils.getCurrentSchema();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.chado.ArtemisUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      StringVector stringVector0 = null;
      try {
        stringVector0 = new StringVector((String[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.StringVector", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      String[] stringArray0 = new String[4];
      stringArray0[0] = "rank";
      stringArray0[1] = "oCH";
      stringArray0[2] = "feature_id";
      stringArray0[3] = "FeatureCvTermDbXRefs not the same - ignore ";
      StringVector stringVector0 = new StringVector(stringArray0);
      String string0 = ArtemisUtils.getString(stringVector0, "feature_id");
      assertEquals("feature_id", string0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      String string0 = "org.biojava.bio.seq.FeatureFilter$OverlapsLocation";
      String string1 = "KqY*W1)Z}YHJ}?y\\";
      SimilarityPairFeature.Template similarityPairFeature_Template0 = new SimilarityPairFeature.Template();
      SimpleFeature simpleFeature0 = null;
      try {
        simpleFeature0 = new SimpleFeature((Sequence) null, (FeatureHolder) null, similarityPairFeature_Template0);
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // Location can not be null. Did you mean Location.EMPTY_LOCATION? class org.biojava.bio.seq.homol.SimilarityPairFeature$Template: score=0.0 source=null type=null annotation=null strand=null sibling=null alignment=null location=null sourceTerm=null typeTerm=null
         //
         verifyException("org.biojava.bio.seq.impl.SimpleFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      String string0 = "P<)M!Zn|4OX";
      String string1 = "";
      String string2 = "Features have been added or removed";
      String string3 = "zgHxNbr";
      GFFStreamFeature gFFStreamFeature0 = null;
      try {
        gFFStreamFeature0 = new GFFStreamFeature("zgHxNbr");
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // invalid GFF line: 8 fields needed (got 1 fields) from: zgHxNbr
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      ArtemisUtils artemisUtils0 = new ArtemisUtils();
      String string0 = "";
      StringVector stringVector0 = new StringVector("");
      ArtemisUtils.getString(stringVector0, "");
      ArtemisUtils.getString(stringVector0, "");
      int int0 = 2211;
      JPasswordField jPasswordField0 = new JPasswordField("", 2211);
      IBatisDAO iBatisDAO0 = null;
      try {
        iBatisDAO0 = new IBatisDAO(jPasswordField0);
       //  fail("Expecting exception: RuntimeException");
       // Unstable assertion
      } catch(RuntimeException e) {
         //
         // Error initializing DbSqlConfig class.  Cause: org.evosuite.runtime.mock.java.lang.MockThrowable: Error occurred.  Cause: org.evosuite.runtime.mock.java.lang.MockThrowable: Error parsing XML.  Cause: org.evosuite.runtime.mock.java.lang.MockThrowable: Error parsing XPath '/sqlMapConfig/transactionManager/dataSource/end()'.  Cause: org.evosuite.runtime.mock.java.lang.MockThrowable: Error initializing DataSource.  Could not instantiate DataSourceFactory.  Cause: java.lang.ClassCastException: com.ibatis.sqlmap.engine.datasource.SimpleDataSourceFactory cannot be cast to com.ibatis.sqlmap.engine.datasource.DataSourceFactory
         //
         verifyException("uk.ac.sanger.artemis.chado.DbSqlConfig", e);
      }
  }
}
