/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument.pass3;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.cobertura.coveragedata.LightClassmapListener;
import net.sourceforge.cobertura.coveragedata.TouchCollector;
import net.sourceforge.cobertura.instrument.pass3.CodeProvider;
import net.sourceforge.cobertura.instrument.tp.ClassMap;
import net.sourceforge.cobertura.instrument.tp.JumpTouchPointDescriptor;
import net.sourceforge.cobertura.instrument.tp.LineTouchPointDescriptor;
import net.sourceforge.cobertura.instrument.tp.SwitchTouchPointDescriptor;
import net.sourceforge.cobertura.instrument.tp.TouchPointDescriptor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public abstract class AbstractCodeProvider
implements CodeProvider {
    public static final int FAKE_COUNTER_ID = 0;
    final String CLASSMAP_LISTENER_INTERNALNAME = Type.getInternalName(LightClassmapListener.class);

    @Override
    public void generateCodeThatSetsJumpCounterIdVariable(MethodVisitor nextMethodVisitor, int new_value, int lastJumpIdVariableIndex) {
        nextMethodVisitor.visitLdcInsn((Object)new_value);
        nextMethodVisitor.visitVarInsn(54, lastJumpIdVariableIndex);
    }

    @Override
    public void generateCodeThatZeroJumpCounterIdVariable(MethodVisitor nextMethodVisitor, int lastJumpIdVariableIndex) {
        this.generateCodeThatSetsJumpCounterIdVariable(nextMethodVisitor, 0, lastJumpIdVariableIndex);
    }

    @Override
    public void generateCodeThatIncrementsCoberturaCounterIfVariableEqualsAndCleanVariable(MethodVisitor nextMethodVisitor, Integer neededJumpCounterIdVariableValue, Integer counterIdToIncrement, int lastJumpIdVariableIndex, String className) {
        nextMethodVisitor.visitLdcInsn((Object)neededJumpCounterIdVariableValue);
        nextMethodVisitor.visitVarInsn(21, lastJumpIdVariableIndex);
        Label afterJump = new Label();
        nextMethodVisitor.visitJumpInsn(160, afterJump);
        this.generateCodeThatIncrementsCoberturaCounter(nextMethodVisitor, counterIdToIncrement, className);
        this.generateCodeThatZeroJumpCounterIdVariable(nextMethodVisitor, lastJumpIdVariableIndex);
        nextMethodVisitor.visitLabel(afterJump);
    }

    protected void generateRegisterClass(MethodVisitor mv, String className) {
        mv.visitLdcInsn((Object)className);
        mv.visitMethodInsn(184, Type.getInternalName(TouchCollector.class), "registerClass", "(Ljava/lang/String;)V");
    }

    @Override
    public void generateCoberturaClassMapMethod(ClassVisitor cv, ClassMap classMap) {
        LinkedList<TouchPointDescriptor> touchPointDescriptors = new LinkedList<TouchPointDescriptor>(classMap.getTouchPointsInLineOrder());
        int parts = 0;
        int j = 0;
        while (touchPointDescriptors.size() > 0) {
            LinkedList<TouchPointDescriptor> bufor = new LinkedList<TouchPointDescriptor>();
            for (int i = 0; i < 1000 && touchPointDescriptors.size() > 0; ++i) {
                bufor.add(touchPointDescriptors.removeFirst());
            }
            this.classMapContent(cv, j, bufor);
            ++parts;
            ++j;
        }
        MethodVisitor mv = cv.visitMethod(9, "__cobertura_classmap", "(" + Type.getType(LightClassmapListener.class).toString() + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)classMap.getClassName());
        mv.visitMethodInsn(185, this.CLASSMAP_LISTENER_INTERNALNAME, "setClazz", "(Ljava/lang/String;)V");
        if (classMap.getSource() != null) {
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)classMap.getSource());
            mv.visitMethodInsn(185, this.CLASSMAP_LISTENER_INTERNALNAME, "setSource", "(Ljava/lang/String;)V");
        }
        for (int i = 0; i < parts; ++i) {
            mv.visitInsn(89);
            mv.visitMethodInsn(184, classMap.getClassName(), "__cobertura_classmap_" + i, "(" + Type.getType(LightClassmapListener.class).toString() + ")V");
        }
        mv.visitInsn(87);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void classMapContent(ClassVisitor cv, int nr, List<TouchPointDescriptor> touchPointDescriptors) {
        MethodVisitor mv = cv.visitMethod(9, "__cobertura_classmap_" + nr, "(" + Type.getType(LightClassmapListener.class).toString() + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        for (TouchPointDescriptor tpd : touchPointDescriptors) {
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)tpd.getLineNumber());
            if (tpd instanceof LineTouchPointDescriptor) {
                mv.visitLdcInsn((Object)((LineTouchPointDescriptor)tpd).getCounterId());
                mv.visitLdcInsn((Object)((LineTouchPointDescriptor)tpd).getMethodName());
                mv.visitLdcInsn((Object)((LineTouchPointDescriptor)tpd).getMethodSignature());
                mv.visitMethodInsn(185, this.CLASSMAP_LISTENER_INTERNALNAME, "putLineTouchPoint", "(IILjava/lang/String;Ljava/lang/String;)V");
                continue;
            }
            if (tpd instanceof JumpTouchPointDescriptor) {
                mv.visitLdcInsn((Object)((JumpTouchPointDescriptor)tpd).getCounterIdForTrue());
                mv.visitLdcInsn((Object)((JumpTouchPointDescriptor)tpd).getCounterIdForFalse());
                mv.visitMethodInsn(185, this.CLASSMAP_LISTENER_INTERNALNAME, "putJumpTouchPoint", "(III)V");
                continue;
            }
            if (!(tpd instanceof SwitchTouchPointDescriptor)) continue;
            SwitchTouchPointDescriptor stpd = (SwitchTouchPointDescriptor)tpd;
            String enum_sign = ((SwitchTouchPointDescriptor)tpd).getEnumType();
            if (enum_sign == null) {
                mv.visitLdcInsn((Object)Integer.MAX_VALUE);
            } else {
                mv.visitMethodInsn(184, enum_sign, "values", "()[L" + enum_sign + ";");
                mv.visitInsn(190);
            }
            Collection<Integer> ci = stpd.getCountersForLabels();
            mv.visitLdcInsn((Object)ci.size());
            mv.visitIntInsn(188, 10);
            int i = 0;
            for (Integer counterId : ci) {
                mv.visitInsn(89);
                mv.visitLdcInsn((Object)i);
                mv.visitLdcInsn((Object)counterId);
                mv.visitInsn(79);
                ++i;
            }
            mv.visitMethodInsn(185, this.CLASSMAP_LISTENER_INTERNALNAME, "putSwitchTouchPoint", "(II[I)V");
        }
        mv.visitInsn(87);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected abstract void generateCINITmethod(MethodVisitor var1, String var2, int var3);

    @Override
    public void generateCoberturaInitMethod(ClassVisitor cv, String className, int countersCnt) {
        MethodVisitor mv = cv.visitMethod(9, "__cobertura_init", "()V", null, null);
        mv.visitCode();
        this.generateCINITmethod(mv, className, countersCnt);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    @Override
    public void generateCallCoberturaInitMethod(MethodVisitor mv, String className) {
        mv.visitCode();
        mv.visitMethodInsn(184, className, "__cobertura_init", "()V");
    }

    static enum Abcd {
        A,
        B,
        C;

    }
}

