# -*- coding: utf-8 -*-
#####################################################################
#  Rafael Proença <cypherbios@ubuntu.com>
#  Laudeci Oliveira <laudeci@gmail.com> 
#
#  Copyright 2007 APTonCD DevTeam.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published
#  by the Free Software Foundation; version 2 only.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#####################################################################
import gtk
import re
import os
import datetime
from APTonCD.core import *
from APTonCD.core import gui 
from APTonCD.core import constants
from APTonCD.widgets import *

WINDOW_NAME = 'dlgAddCDInfo'

class AddMediaDialog(controller.IController):
	"""
		This class will show/ask/handle the adding media dialog
	"""
	def __init__(self, controller = None):
		"""
			Constructor
		"""
		self.controller = controller
		self.glade = gui.get_glade(constants.PROPERTY_GUI, WINDOW_NAME)

		#Main widget
		self.window = gui.get_widget(self.glade, WINDOW_NAME)
		self.window.set_icon_name(constants.APP_ICON_NAME)

		#get glade widgets
		self.chkShowAgain = gui.get_widget(self.glade, 'chkShowAgain')
		self.cmdOK = gui.get_widget(self.glade, 'cmdOK')
		self.cmdCancel = gui.get_widget(self.glade, 'cmdCancel')
		
		if self.controller:
			self.window.set_transient_for(self.controller.get_main_window())
			self.window.set_position(gtk.WIN_POS_CENTER_ON_PARENT)

		# connect signals
		self.connect_signals()
		self.window.set_modal(True)

	def run(self):
		return self.window.run()

	def destroy(self):
		self.window.destroy()

	def get_main_window(self):
		"""
			implements IController interface method.
			for access the class windows object.
		"""
		if self.controller:
			return self.controller.get_main_window()
		else:
			return self.window

	def get_parent_widget(self):
		"""
			implements IController interface method.
			for container widget
		"""
		if self.controller:
			self.controller.get_parent_widget()
		else:
			return self.window.get_children()[0]

	def connect_signals(self):
		"""
			This procedure will connect widgets to its signal handler.
		"""
		gui.connect(self.cmdOK, 'clicked', self.on_clicked)
		gui.connect(self.cmdCancel, 'clicked', self.on_clicked)

	def on_clicked(self, widget):
		if widget == self.cmdCancel:
			self.window.destroy()
	
	def get_showagain(self):
		return self.chkShowAgain.get_active()
