(* File generated from mpf.idl *)

type mpf_ptr

(** GMP multiprecision floating-point numbers *)


(** The following operations are mapped as much as possible to their C counterpart. In case of imperative functions (like [set], [add], ...) the first parameter of type [t] is an out-parameter and holds the result when the function returns. For instance, [add x y z] adds the values of [y] and [z] and stores the result in [x].

 These functions are as efficient as their C counterpart: they do not imply additional memory allocation. *)



(** {2 Pretty printing} *)

val print : Format.formatter -> t -> unit

(** {2 Initialization Functions} *)
(** {{:http://gmplib.org/manual/Initializing-Floats.html#Initializing-Floats}C documentation} *)

external mpf_set_default_prec : int -> unit
	= "camlidl_mpf_mpf_set_default_prec"

external mpf_get_default_prec : unit -> int
	= "camlidl_mpf_mpf_get_default_prec"

external mpf_init : unit -> mpf_ptr
	= "camlidl_mpf_mpf_init"

external mpf_init2 : int -> mpf_ptr
	= "camlidl_mpf_mpf_init2"

external mpf_get_prec : mpf_ptr -> int
	= "camlidl_mpf_mpf_get_prec"

external mpf_set_prec : mpf_ptr -> int -> unit
	= "camlidl_mpf_mpf_set_prec"

external mpf_set_prec_raw : mpf_ptr -> int -> unit
	= "camlidl_mpf_mpf_set_prec_raw"


(** {2 Assignement Functions} *)
(** {{:http://gmplib.org/manual/Assigning-Floats.html#Assigning-Floats}C documentation} *)

external mpf_set : mpf_ptr -> mpf_ptr -> unit
	= "camlidl_mpf_mpf_set"

external mpf_set_si : mpf_ptr -> int -> unit
	= "camlidl_mpf_mpf_set_si"

external mpf_set_d : mpf_ptr -> float -> unit
	= "camlidl_mpf_mpf_set_d"

external mpf_set_z : mpf_ptr -> Mpz.mpz_ptr -> unit
	= "camlidl_mpf_mpf_set_z"

external mpf_set_q : mpf_ptr -> Mpq.mpq_ptr -> unit
	= "camlidl_mpf_mpf_set_q"

external mpf__set_str : mpf_ptr -> string -> int -> unit
	= "camlidl_mpf_mpf__set_str"

val set_str : t -> string -> base:int -> unit
external mpf_swap : mpf_ptr -> mpf_ptr -> unit
	= "camlidl_mpf_mpf_swap"


(** {2 Combined Initialization and Assignement Functions} *)
(** {{:http://gmplib.org/manual/Simultaneous-Float-Init-_0026-Assign.html#Simultaneous-Float-Init-_0026-Assign}C documentation} *)

external mpf_init_set : mpf_ptr -> mpf_ptr
	= "camlidl_mpf_mpf_init_set"

external mpf_init_set_si : int -> mpf_ptr
	= "camlidl_mpf_mpf_init_set_si"

external mpf_init_set_d : float -> mpf_ptr
	= "camlidl_mpf_mpf_init_set_d"

external mpf__init_set_str : string -> int -> mpf_ptr
	= "camlidl_mpf_mpf__init_set_str"

val init_set_str : string -> base:int -> t

(** {2 Conversion Functions} *)
(** {{:http://gmplib.org/manual/Converting-Floats.html#Converting-Floats}C documentation} *)

external mpf_get_d : mpf_ptr -> float
	= "camlidl_mpf_mpf_get_d"

external mpf_get_d_2exp : mpf_ptr -> float * int
	= "camlidl_mpf_mpf_get_d_2exp"

external mpf_get_si : mpf_ptr -> nativeint
	= "camlidl_mpf_mpf_get_si"

external mpf_get_int : mpf_ptr -> int
	= "camlidl_mpf_mpf_get_int"


 (* Replace Mpz.set_f: t -> Mpz.t -> unit *)
external mpf_get_z : Mpz.mpz_ptr -> mpf_ptr -> unit
	= "camlidl_mpf_mpf_get_z"


 (* Replace Mpq.set_f: t -> Mpq.t -> unit *)
external mpf_get_q : Mpq.mpq_ptr -> mpf_ptr -> unit
	= "camlidl_mpf_mpf_get_q"

external mpf__get_str : int -> int -> mpf_ptr -> string * int
	= "camlidl_mpf_mpf__get_str"

val get_str : base:int -> digits:int -> t -> string * int

(** {2 User Conversions} *)

(** These functionss are additions to or renaming of functions offered by the C library. *)

val to_string : t -> string
val to_float : t -> float
val of_string : string -> t
val of_float : float -> t
val of_int : int -> t
val of_mpz : Mpz.t -> t
val of_mpq : Mpq.t -> t
val is_integer : t -> bool

(** {2 Arithmetic Functions} *)
(** {{:http://gmplib.org/manual/Float-Arithmetic.html#Float-Arithmetic}C documentation} *)

external mpf_add : mpf_ptr -> mpf_ptr -> mpf_ptr -> unit
	= "camlidl_mpf_mpf_add"

external mpf_add_ui : mpf_ptr -> mpf_ptr -> int -> unit
	= "camlidl_mpf_mpf_add_ui"

external mpf_sub : mpf_ptr -> mpf_ptr -> mpf_ptr -> unit
	= "camlidl_mpf_mpf_sub"

external mpf_ui_sub : mpf_ptr -> int -> mpf_ptr -> unit
	= "camlidl_mpf_mpf_ui_sub"

external mpf_sub_ui : mpf_ptr -> mpf_ptr -> int -> unit
	= "camlidl_mpf_mpf_sub_ui"

external mpf_mul : mpf_ptr -> mpf_ptr -> mpf_ptr -> unit
	= "camlidl_mpf_mpf_mul"

external mpf_mul_ui : mpf_ptr -> mpf_ptr -> int -> unit
	= "camlidl_mpf_mpf_mul_ui"

external mpf_mul_2exp : mpf_ptr -> mpf_ptr -> int -> unit
	= "camlidl_mpf_mpf_mul_2exp"

external mpf_div : mpf_ptr -> mpf_ptr -> mpf_ptr -> unit
	= "camlidl_mpf_mpf_div"

external mpf_ui_div : mpf_ptr -> int -> mpf_ptr -> unit
	= "camlidl_mpf_mpf_ui_div"

external mpf_div_ui : mpf_ptr -> mpf_ptr -> int -> unit
	= "camlidl_mpf_mpf_div_ui"

external mpf_div_2exp : mpf_ptr -> mpf_ptr -> int -> unit
	= "camlidl_mpf_mpf_div_2exp"

external mpf_sqrt : mpf_ptr -> mpf_ptr -> unit
	= "camlidl_mpf_mpf_sqrt"

external mpf_pow_ui : mpf_ptr -> mpf_ptr -> int -> unit
	= "camlidl_mpf_mpf_pow_ui"

external mpf_neg : mpf_ptr -> mpf_ptr -> unit
	= "camlidl_mpf_mpf_neg"

external mpf_abs : mpf_ptr -> mpf_ptr -> unit
	= "camlidl_mpf_mpf_abs"


(** {2 Comparison Functions} *)
(** {{:http://gmplib.org/manual/Float-Comparison.html#Float-Comparison}C documentation} *)

external mpf_cmp : mpf_ptr -> mpf_ptr -> int
	= "camlidl_mpf_mpf_cmp"

external mpf_cmp_d : mpf_ptr -> float -> int
	= "camlidl_mpf_mpf_cmp_d"

external mpf_cmp_si : mpf_ptr -> int -> int
	= "camlidl_mpf_mpf_cmp_si"

external mpf_sgn : mpf_ptr -> int
	= "camlidl_mpf_mpf_sgn"

external mpf__equal : mpf_ptr -> mpf_ptr -> int -> bool
	= "camlidl_mpf_mpf__equal"

val equal : t -> t -> bits:int -> bool
external mpf_reldiff : mpf_ptr -> mpf_ptr -> mpf_ptr -> unit
	= "camlidl_mpf_mpf_reldiff"


(** {2 Input and Output Functions: not interfaced} *)


(** {2 Random Number Functions: see {!Gmp_random} module} *)


(** {2 Miscellaneous Float Functions} *)
(** {{:http://gmplib.org/manual/Miscellaneous-Float-Functions.html#Miscellaneous-Float-Functions}C documentation} *)

external mpf_ceil : mpf_ptr -> mpf_ptr -> unit
	= "camlidl_mpf_mpf_ceil"

external mpf_floor : mpf_ptr -> mpf_ptr -> unit
	= "camlidl_mpf_mpf_floor"

external mpf_trunc : mpf_ptr -> mpf_ptr -> unit
	= "camlidl_mpf_mpf_trunc"

external mpf_integer_p : mpf_ptr -> bool
	= "camlidl_mpf_mpf_integer_p"


(* Does it fit in an OCaml integer *)
external mpf_fits_int_p : mpf_ptr -> bool
	= "camlidl_mpf_mpf_fits_int_p"


(* Limited relevance here *)
external mpf_fits_ulong_p : mpf_ptr -> bool
	= "camlidl_mpf_mpf_fits_ulong_p"

external mpf_fits_slong_p : mpf_ptr -> bool
	= "camlidl_mpf_mpf_fits_slong_p"

external mpf_fits_uint_p : mpf_ptr -> bool
	= "camlidl_mpf_mpf_fits_uint_p"

external mpf_fits_sint_p : mpf_ptr -> bool
	= "camlidl_mpf_mpf_fits_sint_p"

external mpf_fits_ushort_p : mpf_ptr -> bool
	= "camlidl_mpf_mpf_fits_ushort_p"

external mpf_fits_sshort_p : mpf_ptr -> bool
	= "camlidl_mpf_mpf_fits_sshort_p"

