# - Look for GNU xsltproc, the lexer generator.
# Defines the following:
#  XSLTPROC_EXECUTABLE - path to the xsltproc executable
#  XSLTPROC_FILE - parse a file with xsltproc
#  XSLTPROC_PREFIX_OUTPUTS - Set to true to make XSLTPROC_FILE produce outputs of
#                        lex.${filename}.c, not lex.yy.c . Passes -P to xsltproc.

IF(NOT XSLTPROC_EXECUTABLE)
  FIND_PROGRAM(XSLTPROC_EXECUTABLE xsltproc)
  IF (XSLTPROC_EXECUTABLE)
    MESSAGE (STATUS "Found xsltproc -- ${XSLTPROC_EXECUTABLE}")
  ELSE (XSLTPROC_EXECUTABLE)
    MESSAGE (ERROR "xsltproc not found")
  ENDIF(XSLTPROC_EXECUTABLE)
ENDIF(NOT XSLTPROC_EXECUTABLE)

IF(XSLTPROC_EXECUTABLE)
  MACRO(XSLTPROC OUT_FILE XSL_FILE XML_FILE)
    GET_FILENAME_COMPONENT(PATH "${XSL_FILE}" PATH)

    SET(FULL_OUT_FILE "${CMAKE_CURRENT_SOURCE_DIR}/${OUT_FILE}")
    SET(FULL_XSL_FILE "${CMAKE_CURRENT_SOURCE_DIR}/${XSL_FILE}")
    SET(FULL_XML_FILE "${CMAKE_CURRENT_SOURCE_DIR}/${XML_FILE}")

    ADD_CUSTOM_COMMAND(
      OUTPUT  "${FULL_OUT_FILE}"
      COMMAND "${XSLTPROC_EXECUTABLE}"
      ARGS    -o "${FULL_OUT_FILE}"
              "${FULL_XSL_FILE}"
              "${FULL_XML_FILE}"
      DEPENDS "${FULL_XSL_FILE}" "${FULL_XML_FILE}")

    SET_SOURCE_FILES_PROPERTIES("${FULL_OUT_FILE}" PROPERTIES GENERATED TRUE)
  ENDMACRO(XSLTPROC)
ENDIF(XSLTPROC_EXECUTABLE)
