/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package org.apache.tools.ant.taskdefs;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildFileRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

/**
 * @since Ant 1.6
 */
public class AntLikeTasksAtTopLevelTest {

    @Rule
    public BuildFileRule buildRule = new BuildFileRule();

    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testAnt() {
        thrown.expect(BuildException.class);
        thrown.expectMessage("ant task at the top level must not invoke its own build file.");
        buildRule.configureProject("src/etc/testcases/taskdefs/toplevelant.xml");
    }

    @Test
    public void testSubant() {
        thrown.expect(BuildException.class);
        thrown.expectMessage("subant task at the top level must not invoke its own build file.");
        buildRule.configureProject("src/etc/testcases/taskdefs/toplevelsubant.xml");
    }

    @Test
    public void testAntcall() {
        thrown.expect(BuildException.class);
        thrown.expectMessage("antcall must not be used at the top level.");
        buildRule.configureProject("src/etc/testcases/taskdefs/toplevelantcall.xml");
    }

}
