# Reply to errors and distortions in David McNally's pamphlet _"Socialism from
Below"_

In chapter three of his pamphlet _[Socialism from
David McNally decides to expose (what he calls) _"The Myth Of Anarchist
Libertarianism."_ In reality, his account is so distorted and, indeed,
dishonest that all it proves is that Marxists will go to extreme lengths to
attack anarchist ideas. As Brain Morris points out, defending the Leninist
tradition and ideology _"implies . . . a compulsive need to rubbish
anarchism."_ [**Ecology &amp; Anarchism**, p. 128] McNally's pamphlet is a
classic example of this. As we will prove, his "case" is a mishmash of
illogical assertions, lies and, when facts do appear, their use is almost
always a means of painting a false picture of reality.

It must be stressed that there is nothing new or original in McNally's
pamphlet. It is simply an unthinking repetition of previous Marxists attacks
on anarchism, starting with Marx's dishonest diatribe against Proudhon **The
Poverty of Philosophy**, and is mostly based on Hal Draper's **The Two Souls
of Socialism** (McNally states he _"should also record here a debt of
inspriation of [this] now-out-of-print pamphlet by Draper"_). While McNally's
errors are commonplace within what passes for Marxist scholarship, this does
not excuse his repeating of them without first checking their accuracy (or,
more correctly, their inaccuracy). If more Marxists took the time to validate
their prejudices and assumptions against what Proudhon, Bakunin and other
anarchists wrote then it would be possible to have a real discussion on what
**genuine** socialism (one, as Proudhon and Bakunin stressed long before
Marxists appropriated the term, _"from below"_) entails.

It must be noted that since this appendix was first written in 2000, David
McNally has distanced himself from his pamphlet's critique of anarchism. In an
end-note in a book written in 2006 he described this welcome rethink:

> _"I dissent from Draper's one-sided critique of anarchism . . . Draper is
not fair to some of the currents within social anarchism. I also reject my own
restatement of Draper's interpretation in the first edition of my booklet
**Socialism from Below**"_ [**Another World Is Possible: Globalization &amp;
Anti-Capitalism**, p. 393]

While it seems unlikely this was in response to reading our critique, it does
show that it was correct. Unfortunately it took McNally over 20 years to
acknowledge that his essay from 1984 gave a distinctly distorted account of
anarchism (a distortion originally circulated in Marxist circles in the 1960s
with Draper's pamphlet). Perhaps significantly, McNally no longer seems to be
associated with the sister organisations of the British **Socialist Workers
Party** (a group whose distortions of anarchism are many and infamous). Sadly,
the damage has been done and his and Draper's flawed account of anarchism (and
Marxism) has become all-too-commonplace within radical circles -- even in
libertarian circles, some take these assertions on Proudhon and Bakunin at
face value and do not seek to verify the claims made. This is unfortunate for,
as we will see, while sometimes correct (for example, Proudhon's disgusting
anti-feminism) most of the claims are false or, at best, half-truths turned
into full-lies by ignoring context or other relevant facts.

We hope that this reply will ensure today's radicals will gain a fuller
understanding of the ideas -- and limitations! -- of Proudhon and Bakunin and,
more importantly, how they influenced subsequent anarchists and the
development of libertarian ideas. It will also allow an informed discussion
between Marxists and Anarchists on their areas of agreement and disagreement.
McNally now argues that _"it may be more helpful to try and defend a common
political vision -- such as socialism from below or libertarian socialism --
as a point of reference"_ rather than fixate over labels like "Marxism" or
"anarchism." [**Op. Cit.**, p. 347] As we noted in our critique of his
pamphlet, the term _"socialism from below"_ has a distinctly anarchist feel to
it, a feel distinctly at odds with Leninist ideology and practice. Moreover,
as shown below, Lenin explicitly denounced _"from below"_ as an anarchist idea
-- and his practice once in power showed that _"from above"_ is part and
parcel of Leninism in action. Sadly, most Leninists are unaware of this.

Finally, many Marxists reject Leninism: some for the original ideas of
Marxism, such as the **Socialist Party of Great Britain** and its sister
parties and some, like the council communists, for extension of them in the
direction of revolutionary anarchist conclusions. As such, this critique
should not be taken for a blanket rejection of all Marxists but rather a
specific form of it, namely Leninism. Nor should it be taken for a blanket
rejection of everything Marx or Marxists have argued. There any many forms of
anarchism and many forms of Marxism, some of which are closer than others.

Many of the issues discussed in this appendix are also explored in [section
H](secHcon.md) of the FAQ and that should also be consulted.

## 1\. Introduction

McNally begins by noting that _"Anarchism is often considered to represent [a]
current of radical thought that is truly democratic and libertarian. It is
hailed in some quarters as the only true political philosophy [of] freedom."_
Needless to say, he thinks that the _"reality is quite different"_ and argues
that _"[f]rom its inception anarchism has been a profoundly anti-democratic
doctrine. Indeed the two most important founders of anarchism, Pierre-Joseph
Proudhon and Michael Bakunin, developed theories that were elitist and
authoritarian to the core."_ We will discover the truth of this assertion
later.

First we must note that McNally uses the typical Marxist approach to attacking
anarchism -- namely to attack anarchists rather than anarchism as such.
British Anarchist Albert Meltzer summarised the flaws in this perspective
well:

> _"Marxist-Leninists, faced with Anarchism, find that by its nature it
undermines all the suppositions basic to Marxism. Marxism was held out to be
the basic working class philosophy (a belief which has utterly ruined the
working class movement everywhere). It holds that the industrial proletariat
cannot owe its emancipation to anyone but themselves alone. It is hard to go
back on that and say that the working class is not yet ready to dispense with
authority placed over it . . . Marxism normally tries to refrain from
criticising anarchism as such -- unless driven to doing so, when it exposes
its own authoritarianism . . . and concentrates its attacks not on Anarchism,
but on Anarchists."_ [**Anarchism: Arguments for and Against**, p. 62]

So when reading this or any critique of anarchism always remember that few
people are completely consistent libertarians and determine whether the words
written reflect a flaw in anarchism **as such** or whether they reflect a
personal flaw of the thinker in question. Once this common-sense position is
taken it quickly becomes clear that anything valid in McNally's critique
highlights the flaws of individuals who did not consistently rise to the
levels implied by their ideas. This, most obviously, is the case with
Proudhon's sexism which is in contradiction with his support for liberty,
equality and federalism. Unsurprisingly, his contemporary Joseph Déjacque
wrote a critique of Proudhon's sexist views in 1857, urging him to renounce
_"this gender aristocracy that would bind us to the old regime"_ and _"speak
out against man's exploitation of woman."_: _"Do not describe yourself as an
anarchist, or be an anarchist through and through"_ [_"On Being Human"_, pp.
68-71, **Anarchism: A Documentary History of Libertarian Ideas**, Vol. 1,
Robert Graham (ed.), p. 71] Later anarchists like Bakunin and Kropotkin
likewise applied anarchist principles consistently on this issue, a fact
McNally cannot bring himself to admit.

Second, McNally lamely notes that _"[w]hile later anarchists may have
abandoned some of the excesses of their founding fathers their philosophy
remains hostile to ideas of mass democracy and workers' power."_ Thus, we have
the acknowledgement that not all anarchists share the same ideas and that
anarchist theory has developed since 1876 (the year of Bakunin's death). This
is to be expected as anarchists are not Proudhonists or Bakuninists -- we do
not name ourselves after one person, rather we take what is useful from
libertarian writers and ignore the rubbish. Malatesta's words are applicable
here: _"We follow ideas and not men, and rebel against this habit of embodying
a principle in a man."_ [**Errico Malatesta: His Life and Ideas**, p. 199]
However, this is beside the point as McNally's account of the ideas of
Proudhon and Bakunin is simply false -- indeed, so false as to make you wonder
if he is simply incompetent as a scholar or seeks to present a patchwork of
lies as fact and "theory."

Third, McNally's approach rests on selective quoting, lack of context and an
unwillingness to research the assertions he is making. This is important as we
are discussing thinkers who wrote over a period of many decades and whose
works and letters reflected the highs and lows of a person's life as well as
the social movement they were part of. This means that in the depths of
personal crisis or the repression of popular movements even the most
consistent thinker can write passages which are in contradiction to the thrust
of the works they are best known for. To quote such words from, say, private
letters and ignore the books and articles which reflect a thinker's ideas best
and which influenced others presents a false picture, particularly if the
context within which the letters were written are unmentioned. So it would be
a distortion of the ideas of Marx and Engels to quote the numerous anti-
Semitic insults against specific individuals from their private letters. As
would be expected, they were men of their age and expressed themselves in ways
which today are, rightly, considered unacceptable (for those interested in
such matters, Peter Fryer's essay _"Engels: A Man of his Time"_ should be
consulted [John Lea and Geoff Pilling (eds.), **The condition of Britain:
Essays on Frederick Engels**]). However, their few **public** racist comments
could be considered worthy of note -- although, if so, then they should, like
those of Proudhon and Bakunin, be placed in the context of their other ideas
and the culture they lived in rather than being used as an excuse to ignore
their contributions to socialism. Sadly, McNally -- like many Marxists --
fails to do this, preferring dismissive finger-pointing instead.

Lastly, McNally ignores the anti-democratic, authoritarian and elitist aspects
of his own political tradition. Given that leading Bolsheviks like Lenin,
Trotsky and Zinoviev publicly advocated party dictatorship and one-man
management of production, it is a distortion to ignore this when discussing
_"Socialism from Below"_. Simply put, while anarchists have consistently
advocated communal and industrial self-management since 1840 to today, the
Marxist tradition has not.

McNally's pamphlet, as will become clear, does not present anything new. It
simply repeats what is sadly all-to-often the received wisdom about anarchists
and anarchism in Marxist circles. As such, it is worth the time and effort to
reply to. Not only will it show the limitations of the Marxist position on
anarchism, it will also afford us the opportunity to show that not only is
anarchism a more genuine _"Socialism from Below"_ than Leninism but also that
many of the ideas Marxists consider as their own were first argued by Proudhon
and Bakunin.

In short, we will show why _"Anarchism is often considered to represent
current of radical thought that is truly democratic and libertarian"_ by
contrasting what McNally asserts about it and what anarchist thinkers actually
advocated. This will, unfortunately, produce a reply longer than the initial
claims but this is unavoidable. We need to provide extensive quotes and
arguments simply in order to show the weakness of McNally's assertions and to
indicate where his own tradition advocated notions he -- inaccurately --
attacks anarchism for.

## 2\. Is anarchism the politics of the _"small property owner"_?

McNally does start out by acknowledging that _"anarchism developed in
opposition to the growth of capitalist society. What's more, anarchist
hostility to capitalism centred on defence of the liberty of the individual."_
However, he then distorts this actual historical development by arguing that
_"the liberty defended by the anarchists was not the freedom of the working
class to make collectively a new society. Rather, anarchism defended the
freedom of the small property owner -- the shopkeeper, artisan and tradesman
-- against the encroachments of large-scale capitalist enterprise."_

Such a statement is, to say the least, a total distortion of the facts of the
situation. Nor is it original. McNally is simply repeating Marx's assertions
against Proudhon who, Marx claimed, _"wants to soar as the man of science
above the bourgeois and the proletarians"_ but _"is merely the petty
bourgeois, continually tossed back and forth between capital and labour,
political economy and communism."_ [**Collected Works**, vol. 6, p. 178] It
should be noted that Marx had not always thought this of the Frenchman:



> _"Not only does Proudhon write in the interest of the proletarians he is
himself a proletarian, an **ouvrier** [worker]. His work [**What is
Property?**] is a scientific manifesto of the French proletariat."_ [**Op.
Cit.**, vol. 4, p. 41]

The change in perspective is unsurprising given that Marx thought his own
ideology was that of the proletariat (whether the proletariat knew it or not)
and, given his disagreements with Proudhon, the Frenchman had to represent
some other class. However, if we reject the assumption that classes only have
one theory associated with them, then the weakness of the Marxist assertion
becomes clear -- particularly given that today there are no mass Marxist
parties in spite of the fact that now, unlike in Marx's day, the proletariat
is the majority of the working class in most of the world's countries.

It is important to remember that at the end of the 1840s over 80% of the
population of France and Germany were peasants or artisans -- what Marxists
term the "petit-bourgeois". As Marx and Engels admitted in **The Communist
Manifesto**, in _"countries like France"_ the peasants _"constitute far more
than half of the population."_ This remained the case well after Proudhon's
death in 1865, with Marx commenting in the early 1870s that _"the peasant . .
. forms a more of less considerable majority . . . in the countries of the
West European continent."_ [**The Marx-Engels Reader**, p. 493 and p. 543] As
Proudhon himself noted in 1851, in _"a population of 36 millions, there are 24
millions occupied with agriculture"_ and of the remaining 12 million there
where only 6 million _"composing in part the wage-working class"_ [**Property
is Theft!**, p. 558]

This social context is important and it is difficult to understand the
positions thinkers took unless it taken into account. In the words of
anarchist Gustav Landauer, Proudhon's socialism _"of the years 1848 to 1851
was the socialism of the French people in the years 1848 to 1851. It was the
socialism that was possible and necessary at that moment. Proudhon was not a
Utopian and a prophet; not a Fourier and not a Marx. He was a man of action
and realisation."_ [**For Socialism**, p. 108] Historian K. Steven Vincent
makes the same point, arguing that Proudhon's _"social theories may not be
reduced to a socialism for only the peasant class, nor was it a socialism only
for the petite bourgeois; it was a socialism of and for French workers. And in
the mid-nineteenth century . . . most French workers were still artisans. . .
French labour ideology largely resulted from the real social experiences and
aspirations of skilled workers . . . Proudhon's thought was rooted in the same
fundamental reality, and therefore understandably shared many of the same
hopes and ideals."_ [**Pierre-Joseph Proudhon and the Rise of French
Republican Socialism**, pp. 5-6] It is no coincidence, therefore, that when he
was elected to the French Parliament in 1848 most of the votes cast for him
were from _"working class districts of Paris -- a fact which stands in
contrast to the claims of some Marxists, who have said he was representative
only of the petite bourgeoisie."_ [Robert L. Hoffman, **Revolutionary
Justice**, p. 136]

Proudhon's position was a distinctly sensible and radical position to take:

> _"While Marx was correct in predicting the eventual predominance of the
industrial proletariat vis-à-vis skilled workers, such predominance was
neither obvious nor a foregone conclusion in France during the nineteenth
century. The absolute number of small industries even increased during most of
the century. . ._

> _"Nor does Marx seem to have been correct concerning the revolutionary
nature of the industrial proletariat. It has become a cliché of French labour
history that during the nineteenth century artisans were much oftener radical
than industrial workers. Some of the most militant action of workers in late
nineteenth century France seems to have emerged from the co-operation of
skilled, urbanised artisanal workers with less highly skilled and less
urbanised industrial workers."_ [Vincent, **Op. Cit.**, pp. 282-3]

The fruits of this union included the Paris Commune, an event in which the
followers of Proudhon played an important role and which both McNally and Marx
praise (see [section 12](append31.md#app12) for more discussion on this).

In short, Marx's earlier summation of Proudhon was correct -- his ideas
reflected the ideas and interests of the French working class. Proudhon
addressed himself to both the peasant/artisan and the proletariat. This is to
be expected from a **libertarian** form of socialism as, at the time of his
writing, the majority of working people **were** peasants and artisans and, as
noted above, this predominance of artisan/peasant workers in the French
economy lasted well after his (and Marx's) death. Not to take into account the
artisan/peasant would have meant the dictatorship of a minority of working
people over the rest of them (as we discuss in [section
H.1.1](secH1.md#sech11) this was also a key reason for Bakunin's rejection
of Marx's _"dictatorship of the proletariat"_). Given that in chapter 4 of his
pamphlet McNally states that Marxism aims for a _"democratic and collective
society . . . based upon the fullest possible political democracy"_ his attack
on Proudhon's concern for the artisan and peasant is doubly strange. Either
you support the _"fullest possible political democracy"_ and so your theory
must take into account artisans and peasants or you restrict political
democracy and replace it with rule by the few.

Unsurprisingly, then, Proudhon argued in 1841 that he _"preach[ed]
emancipation to the proletarians; association to the workers."_ [**Op. Cit.**,
p. 157] However, as McNally notes, he _"oppose[d] trade unions."_ and did not
see them as the means of achieving this for it was _"not by such methods that
the workingmen will attain to wealth and -- what is a thousand times more
precious than wealth -- liberty."_ [Proudhon, **System of Economical
Contradictions**, p. 150] However, this did not mean that he was rejected the
idea that the working class (in its three sections of wage-workers, artisan
and peasants) would liberate itself. While fundamentally a reformist, Proudhon
recognised that self-liberation was only genuine form of liberation and so had
_"always thought that the proletariat must emancipate itself without the help
of the government."_ [**Property is Theft!**, 306] Given this, it is
unsurprising that Proudhon saw social change as coming from _"below"_ by the
collective action of the working class:

> _"If you possess social science, you know that the problem of association
consists in organising . . . the producers, and by this organisation
subjecting capital and subordinating power. Such is the war that you have to
sustain: a war of labour against capital; a war of liberty against authority;
a war of the producer against the non-producer; a war of equality against
privilege . . . to conduct the war to a successful conclusion . . . it is of
no use to change the holders of power or introduce some variation into its
workings: an agricultural and industrial combination must be found by means of
which power, today the ruler of society, shall become its slave."_ [**Op.
Cit.**, p. 225]

During the 1848 revolution he urged _"a provisional committee be set up to
orchestrate exchange, credit and commerce between workers"_ which would
_"liaise with similar committees set up in the main cities of France"_ and
_"under the aegis of these committees, a body representative of the
proletariat be formed in Paris . . . in opposition to the bourgeoisie's
representation."_ This ensured that _"a new society be founded in the heart of
the old society"_. He later stressed the _"organisation of popular societies
was the pivot of democracy, the cornerstone of republican order"_ and these
_"clubs . . . assemblies, popular societies"_ would ensure _"the organisation
of universal suffrage in all its forms, of the very structure of Democracy
itself."_ [**Op. Cit.**, p. 321, p. 407 and p. 461] As Daniel Guérin
summarised, _"in the midst of the 1848 Revolution,"_ Proudhon _"sketched out a
minimum libertarian program: progressive reduction in the power of the State,
parallel development of the power of the people from below, through what he
called clubs"_ which today we _"would call councils."_ [**Anarchism**, pp.
152-3]

Clearly, even if he (wrongly) rejected trade unionism Proudhon **did**
support, to quote McNally, the _"the freedom of the working class to make
collectively a new society."_ Indeed, as one historian notes, there was
_"close similarity between the associational ideal of Proudhon . . . and the
program of the Lyon Mutualists"_ and that there was _"a remarkable convergence
[between these ideas], and it is likely that Proudhon was able to articulate
his positive program more coherently because of the example of the silk
workers of Lyon. The socialist ideal that he championed was already being
realised, to a certain extent, by such workers."_ [Vincent, **Op. Cit.**, p.
164] Proudhon simply rejected revolution, trade unions or state-backed reforms
as the means of achieving socialism and instead argued for a reformist
strategy based primarily on the creation of co-operative workplaces and banks.
He linked his politics to workers self-activity and argued that _"the proof"_
of his mutualist ideas was shown in the _"current practice, revolutionary
practice"_ of _"those labour associations . . . which have spontaneously . . .
been formed in Paris and Lyon"_ during the 1848 revolution which show that the
_"organisation of credit and organisation of labour amount to one and the
same."_ If all workers _"organise themselves along similar lines, it is
obvious that, as masters of labour, constantly generating fresh capital
through work, they would soon have wrested alienated capital back again,
through their organisation and competition."_ This would apply to _"small-
scale"_ as well as _"large-scale property and large industries"_. [**Op.
Cit.**, pp. 374-5] Thus Proudhon places his ideas firmly in the actions of
working people resisting wage slavery (i.e. the proletariat) and **not**
exclusively in the _"small property owner"_ (i.e., artisans and peasants).

So regardless of McNally's claims, Proudhon was not fixated upon _"small
property"_. As we discuss in [section 4](append31.md#app4), Proudhon's
recognition of differences in the working class was reflected in his position
on property. His proposals for a libertarian society included social
ownership, workers' self-management of large scale workplaces as well as
artisan and peasant production and **explicitly** and **repeatedly** argued
for _"the complete emancipation of the worker . . . the abolition of the wage
worker."_ [quoted by Vincent, **Op. Cit.**, p. 222] Rather than being backward
looking and aiming exclusively at the artisan/peasant, Proudhon's ideas looked
to the present and the future by looking at both the artisan/peasant **and**
proletariat (i.e. to the **whole** of the working class in France at the
time). As Daniel Guérin summarised:

> _"Proudhon really moved with the times and realised that it is impossible to
turn back the clock. He was realistic enough to understand that 'small
industry is as stupid as petty culture" . . . With regard to large-scale
modern industry requiring a large workforce, he was resolutely collectivist:
'In future, large-scale industry and wide culture must be the fruit of
association.' 'We have no choice in the matter,' he concluded, and waxed
indignant that anyone had dared to suggest that he was opposed to technical
progress . . . Property must be abolished . . . The means of production and
exchange must be controlled neither by capitalist companies nor by the State .
. . they must be managed by associations of workers"_ [**Anarchism**, p. 45]

The notion that anarchism is the politics of the _"small property owner"_ is
even harder to maintain when we move from Proudhon's reformist anarchism to
the revolutionary anarchism of Bakunin and Kropotkin. While there is a similar
commitment to a decentralised, federal socialism _"from below"_ rooted in
social and economic self-management, the means are different: revolution is
embraced, along with labour unions and direct action. Where Proudhon differs
from later anarchists like Bakunin, Kropotkin, Malatesta and Goldman is that
this working class self-activity is reformist in nature, that is seeking
alternatives to capitalism which can reform it away rather than alternatives
that can fight and destroy it. However, this embrace of social revolution and
class struggle by anarchists like Bakunin rests on the same principle of
working class self-emancipation.

Hence we find Bakunin arguing that _"revolution is only sincere, honest and
real in the hands of the masses"_ and so socialism can be achieved _"by the
development and organisation, not of the political but of the social (and, by
consequence, anti-political) power of the working masses"_ who must _"organise
and federate spontaneously, freely, from the bottom up, by their own momentum
according to their real interest, but never according to any plan laid down in
advance and imposed upon the **ignorant masses** by some superior
intellects."_ Social change would be achieved only by _"the complete
solidarity of individuals, sections and federations in the economic struggle
of the workers of all countries against their exploiters."_ [**Michael
Bakunin: Selected Writings**, p. 237, pp. 197-8 and p. 177] Unlike Proudhon,
he saw the means for achieving the social revolution in the labour movement as
trade unions (organised from the bottom up, of course) were _"the natural
organisation of the masses"_ as _"workers' solidarity in their struggle
against the bosses"_ was the means by which workers could emancipate itself
_"**through practical action.**"_ Thus the key to working-class self-
liberation was _"**trades-unions, organisation, and the federation of
resistance funds**"_ [**The Basic Bakunin**, p. 139 and p. 103] In short, what
became known as a syndicalist position (see [section 9](append31.md#app9)
for a discussion of McNally's false counterpoising of anarchism and
syndicalism) as the _"organisation of the trade sections and their
representation by the Chambers of Labour . . . bear in themselves the living
seeds of the new society which is to replace the old world. They are creating
not only the ideas, but also the facts of the future itself."_ [**Bakunin on
Anarchism**, p. 255] Moreover, as we show in the [next
section](append31.md#app3), like Proudhon, Bakunin argued that an anarchist
society would be based on _"the collective ownership of producers'
associations, freely organised and federated in the communes, and by the
equally spontaneous federation of these communes."_ [**Michael Bakunin:
Selected Writings**, p. 197] As Kropotkin summarised:

> _"the chief aim of Anarchism is to awaken those constructive powers of the
labouring masses . . . since the times of the International Working Men’s
Association, the Anarchists have always advised taking an active part in those
workers’ organisations which carry on the **direct** struggle of Labour
against Capital and its protector, -- the State_

> _"Such a struggle . . . better than any other indirect means, permits the
worker to obtain some temporary improvements in the present conditions of
work, while it opens his eyes to the evil that is done by Capitalism and the
State that supports it, and wakes up his thoughts concerning the possibility
of organising consumption, production, and exchange without the intervention
of the capitalist and the State."_ [**Direct Struggle Against Capital**, p.
189]

And McNally asserts that _"the liberty defended by the anarchists was not the
freedom of the working class to make collectively a new society"_! Only
someone ignorant of anarchist theory or with a desire to deceive could make
such an assertion. Needless to say, McNally's claim that anarchism is the
politics of the _"small property owner"_ would be even harder to justify if he
mentioned Kropotkin's **communist** anarchism. However, like Proudhon's and
Bakunin's support for collective ownership by workers associations it goes
unmentioned -- for obvious reasons.

## 3\. Does anarchism _"glorify values from the past"_?

McNally asserts, regardless of the facts, that anarchism _"represented the
anguished cry of the small property owner against the inevitable advance of
capitalism. For that reason, it glorified values from the past: individual
property, the patriarchal family, racism."_ The reality is very different. We
will take each issue in turn.

First, we should note that unlike Marx, anarchists did not think that
capitalism was inevitable or an essential phase society had to go through
before we could reach a free society. Neither Proudhon nor Bakunin shared
Marx's viewpoint that socialism (and the struggle for socialism) had to be
postponed until capitalism had developed sufficiently so that the
_"centralisation of the means of production and the socialisation [sic!] of
labour reach a point at which they become incompatible with their capitalist
integument."_ [**Capital**, vol. 1, p. 929] As McNally states, socialism was
once the _"banner under which millions of working people resisted the horrors
of the factory system and demanded a new society of equality, justice, freedom
and prosperity."_ Unfortunately, the Marxist tradition viewed such horrors as
essential, unavoidable and inevitable and any form of working class struggle
-- such as the Luddites -- which resisted the development of capitalism was
denounced. So much for Marxism being in favour of working class _"self-
emancipation"_ \-- if working class resistance to oppression and exploitation
which does not fit into its scheme for "working class self-emancipation" then
it is the product of ignorance or non-working class influences. This can be
seen from McNally's position on anarchism.

Thus, rather than representing _"the anguished cry of the small property owner
against the inevitable advance of capitalism"_ anarchism is rather the cry of
the oppressed against capitalism and the desire to create a free society in
the here and now and not some time in the future once "the proletariat" was
the majority of the working classes. To quote German Anarchist Gustav
Landauer:

> _"Karl Marx and his successors thought they could make no worse accusation
against the greatest of all socialists, Proudhon, than to call him a petit-
bourgeois and petit-peasant socialist, which was neither incorrect nor
insulting, since Proudhon showed splendidly to the people of his nation and
his time, predominately small farmers and craftsmen, how they could achieve
socialism immediately without waiting for the tidy process of big
capitalism."_ [**For Socialism**, p. 61]

As noted in the [previous section](append31.md#app2), Proudhon's theory
reflected both artisan/peasant interests and those of wage workers -- as would
be expected from a socialist aiming to transform his society to a free one.
The disastrous results of Bolshevik rule in Russia should indicate the dangers
of ignoring the vast bulk of a nation (i.e. the peasants) when trying to
create a revolutionary change in society. McNally confuses a desire to achieve
socialism **now** with backward looking opposition to capitalism. Proudhon
looked at the current state of society, not backwards, as McNally suggests.
Indeed, he lambasted those radicals during the 1848 who sought to repeat the
glories of the Great French Revolution rather than look to the future:

> _"It is by '93 and all of its discord that we are being ruled . . . The
democrats of '93, conjuring up a republic with their high school memories [of
Ancient Rome], after devouring one another, set the revolution back by half a
century . . . The democrats of 1848, building the republic on their
parliamentary memories, have also set the revolution back by half a century .
. . they are only imitators; they thought themselves statesmen because they
were following the old models!_

> _"So what is this queer preoccupation which, in time of revolution,
bedazzles the most steadfast minds, and, when their burning aspirations carry
them forward into the future, has them constantly harking back the past? How
does it come about that the People, just when it is making the break with
established institutions, takes another plunge and gets further immersed in
tradition? Society does not repeat itself: but one would have thought it was
walking backwards . . . Could it not turn its gaze in the direction in which
it is going?_

> _"[. . .]_

> _"In order to organise the future, a general rule confirmed by experience,
the reformers always start out with their gaze fixed upon the past. Hence the
contradiction forever discovered in their actions: hence also the immeasurable
danger of revolutions."_ [**Property is Theft!**, p. 308]

Secondly, it is not true that Proudhon or Bakunin _"glorified"_ individual
property. Proudhon, as is well know, argued that _"property is theft"_ and
that _"property is despotism."_ He was well aware of the negative side effects
of individual property and sought to end it: _"instead of inferring . . . that
property should be shared by all, I demand, in the name of general security,
its entire abolition."_ However, just as he was against capitalism, Proudhon
was also against state socialism: _"Either competition, -- that is, monopoly
and what follows; or exploitation by the State, -- that is, dearness of labour
and continuous impoverishment; or else, in short, a solution based upon
equality, -- in other words, the organisation of labour, which involves the
negation of political economy and the end of property."_ [**Property is
Theft!**, p. 87, p. 133, p. 91 and p. 202]

He was well aware that replacing private property by state property would not
liberate the working class for what he termed _"Community"_ (usually, if not
accurately, translated as "communism"), would enserf the worker to the state.
Instead, Proudhon wanted to abolish property and replace it with possession.
As he put it in 1840's **What is Property?**, while property had to be
_"collective and undivided"_ its use could be divided by means of
_"possession"_. [**Op. Cit.**, p. 137] Thus workers would control the means of
production they used as well as the goods they created:

> _"property in product . . . does not carry with it property in the means of
production; that seems to me to need no further demonstration. There is no
difference between the soldier who possesses his arms, the mason who possesses
the materials committed to his care, the fisherman who possesses the water,
the hunter who possesses the fields and forests, and the cultivator who
possesses the lands: all, if you say so, are proprietors of their products --
not one is proprietor of the means of production. The right to product is
exclusive . . . the right to means is common"._ [**Op. Cit.**, p. 112]

As we discuss in the [section 4](append31.md#app4), Proudhon repeatedly
noted his position and refuted those who claimed he supported individual
property. He also recognised that private property was not completely without
merit as it gave its holder a measure of autonomy and protection against the
state and other social forces. It was precisely this autonomy which he wished
all to share rather than under capitalism where workers _"sold their arms and
parted with their liberty"_ to the capitalist or landlord. [**Op. Cit.**, p.
212] However, recognising this -- and the dangers of state socialism -- hardly
equates to glorification of private property.

It is true that Proudhon did oppose the forced socialisation of artisan
workplaces and peasant land. He considered having control over the means of
production, housing, etc. by those who use it as a key means of maintaining
freedom and independence. Thus we find him arguing in 1851 that _"it is
evident that if the peasants think well to associate, they will associate"_.
[**Op. Cit.**, p. 584] However, the issue was different for modern industry:

> _"In such cases, it is one of two things; either the worker, necessarily a
piece-worker, will be simply the employee of the proprietor-capitalist-
entrepreneur; or he will participate in the chances of loss or gain of the
establishment, he will have a voice in the council, in a word, he will become
an associate._

> _"In the first case the worker is subordinated, exploited: his permanent
condition is one of obedience and poverty. In the second case he resumes his
dignity as a man and citizen, he may aspire to comfort, he forms a part of the
producing organisation, of which he was before but the slave; as, in the town,
he forms a part of the sovereign power, of which he was before but the
subject."_ [**Op. Cit.**, p. 583]

Thus capitalism had to be replaced with associations _"due to the immorality,
tyranny and theft suffered"_. [**Op. Cit.**, p. 584] This aspect of his ideas
is continual throughout his political works and played a central role in his
social theory. Thus to say that Proudhon _"glorified"_ individual property
distorts his position. As he argued in 1848:

> _"under universal association, ownership of the land and of the instruments
of labour is **social** ownership . . . We want the mines, canals, railways
handed over to democratically organised workers' associations . . . We want
these associations to be models for agriculture, industry and trade, the
pioneering core of that vast federation of companies and societies woven into
the common cloth of the democratic and social Republic."_ [**Op. Cit.**, pp.
377-8]

As the experience of workers under Lenin indicates (see [section
H.3.13](secH3.md#sech13)), collective ownership by the state does **not**
end wage labour, exploitation and oppression and so Proudhon's arguments in
favour of socialisation and possession and against capitalist **and** state
ownership were proven right. As the forced collectivisation of the peasantry
under Stalin shows, Proudhon's respect for artisan/peasant possessions was a
very sensible and humane position to take. Unless McNally supports the forced
collectivisation of peasants and artisans, Proudhon's solution is the only
position a socialist can take.

We doubt that McNally wants to socialise **all** _"property"_ (including
individual possessions and such like). We are sure that he, like Marx and
Engels, wants to retain individual possessions in a socialist society. Thus
they stated that the _"distinguishing feature of Communism is not the
abolition of property generally, but the abolition of bourgeois property"_ and
that _"Communism deprives no man of the power to appropriate the products of
society; all that it does is to deprive him of the power to subjugate the
labour of others by means of such appropriation."_ Later Marx argued that the
Paris Commune _"wanted to make individual property a truth by transforming the
means of production, land and capital . . . into mere instruments of free and
associated labour."_ [**Selected Writings**, p. 47, p. 49 and pp. 290-1] This
echoes Proudhon's position that property _"changed its nature"_ when it _"the
usufructuary converted his right to personally use the thing into the right to
use it by his neighbour's labour"_. Thus support for _"individual property"_
is not confined to Proudhon and, as noted, he desired to turn capital over to
associated labour as well and this association he considered _"the
annihilation of property"_. [**Op. Cit.**, p. 155 and p. 148] It should also
be stressed, as we note in [section A.5.1](secA5.md#seca51), the followers
of Proudhon played a key role in the Paris Commune and its attempts to create
co-operatives reflected his ideas. Moreover, initially Marx had nothing but
praise for Proudhon's critique of property contained in his classic work
**What is Property?**:

> _"Proudhon makes a critical investigation -- the first resolute, ruthless,
and at the same time scientific investigation -- of the basis of political
economy, **private property**. This is the great scientific advance he made,
an advance which revolutionises political economy and for the first time makes
a real science of political economy possible. Proudhon's treatise **Qu'est-ce
que la propriété?** is as important for modern political economy as Sieyês'
work **Qu'est-ce que le tiers état?** for modern politics."_ [**Collected
Works**, vol. 4, p. 32]

As Rocker argued, Marx changed his tune to _"conceal from everyone just what
he owed to Proudhon and any means to that end was admissible."_ [**Marx and
Anarchism**] This can be seen from the comments we quote above which clearly
show a Proudhonian influence in their recognition that possession replaces
property in a socialist society and that associated labour is its economic
basis. However, it is still significant that Proudhon's analysis initially
provoked such praise by Marx -- an analysis which McNally obviously does not
understand.

Moving on from Proudhon, we discover Bakunin also opposing individual property
and arguing that _"the land, the instruments of work and all other capital
[will] become the collective property of society and by utilised only by the
workers, in other words by the agricultural and industrial associations."_
[**Michael Bakunin: Selected Writings**, p. 174] With regards to peasants and
artisans Bakunin also desired **voluntary** collectivisation. _"In a free
community,"_ he argued, _"collectivism can only come about through the
pressure of circumstances, not by imposition from above but by a free
spontaneous movement from below."_ Rather than being a defender of "individual
property" as McNally implies, Bakunin was a clear and consistent supporter of
**collective** property (as organised in workers' associations and communes)
and supported peasant and artisan property only in the sense of being against
forced collectivisation as this would result in _"propelling [the peasants]
into the camp of reaction."_ [**Bakunin on Anarchism**, p. 200 and p. 197]
Expropriation of capital was considered a key aspect of social revolution:

> _"let us suppose . . . it is Paris that starts [the revolution] . . . Paris
will naturally make haste to organise itself as best it can, in revolutionary
style, after the workers have joined into associations and made a clean sweep
of all the instruments of labour, every kind of capital and building; armed
and organised by streets and **quartiers**, they will form the revolutionary
federation of all the **quartiers**, the federative commune . . . All the
French and foreign revolutionary communes will then send representatives to
organise the necessary common services . . . and to organise common defence
against the enemies of the Revolution, together with propaganda, the weapon of
revolution, and practical revolutionary solidarity with friends in all
countries against enemies in all countries."_ [**Michael Bakunin: Selected
Writings**, pp. 178-9]

Given how often Bakunin stressed the need for union struggles and collective
labour property, it is easy to conclude that McNally did no research into
anarchism before writing about it. So we discover him arguing that
_"resistance funds and trade unions"_ are _"the only efficacious weapons"_ the
workers have against the bourgeoisie and this needed _"the organisation of the
international strength of the workers of all countries."_ This movement aimed
for a society _"based on equality"_ where _"all capital and every instrument
of labour, including the soil, belong to the people, by right of collective
property."_ States _"must be abolished, for their only mission is to protect
individual property, that is, to protect the exploitation by some privileged
minority, of the collective labour of the masses of the people"_ and a _"just
human society"_ must be created, one _"free of political domination and
economic exploitation, founded only on collective labour which is guaranteed
by collective property."_ He repeatedly proclaimed his support for _"the great
principle of **collective property**"_ and argued that _"the collective
property of capital"_ was one of _"the absolutely necessary conditions for the
emancipation **of labour and of the workers**"_. [**The Basic Bakunin**, p.
153, p. 196 and p. 85] The social revolution would see _"the passing of all
the land, capital and means of production into the hands of the international
federation of free workers' associations."_ Land _"belongs to those who have
cultivated it with their own hands -- to the rural communes"_ while _"capital
and all tools of labour belong to the city workers -- to the workers'
associations."_ Anarchism would be _"nothing else but a free federation of
workers -- agricultural workers as well as factory workers and associations of
craftsmen."_ [**The Political Philosophy of Bakunin**, p. 344 and p. 410]

Clearly neither Proudhon nor Bakunin _"glorified"_ individual property. Hence
Daniel Guérin's summary:

> _"Proudhon and Bakunin were 'collectivists,' which is to say they declared
themselves without equivocation in favour of the common exploitation, not by
the State but by associated workers of the large-scale means of production and
of the public services. Proudhon has been quite wrongly presented as an
exclusive enthusiast of private property . . . At the Bale congress [of the
First International] in 1869, Bakunin . . . all[ied] himself with the statist
Marxists . . . to ensure the triumph of the principle of collective
property."_ [_"From Proudhon to Bakunin"_, **The Radical Papers**, Dimitrios
I. Roussopoulos (ed.), p. 32]

Thirdly, while it is true that Proudhon **did** glorify the patriarchal
family, the same cannot be said of Bakunin. Unlike Proudhon, he argued that
_"[e]qual rights must belong to both men and women,"_ that women must _"become
independent and free to forge their own way of life"_ and that _"[o]nly when
private property and the State will have been abolished will the authoritarian
juridical family disappear."_ He opposed the _"absolute domination of the
man"_ in marriage, urged _"the full sexual freedom of women"_ and argued that
the cause of women's liberation was _"indissolubly tied to the common cause of
all the exploited workers -- men and women."_ An anarchist society's
organisations would be populated by people elected _"by the universal suffrage
of both sexes"_ and so it would be based on _"**[e]qual political, social, and
economic rights, as well as equal obligations, for women.**"_ [**Bakunin on
Anarchism**, pp. 396-7, p. 78 and p. 93] In short:

> _"Abolition of the patriarchal family law, based exclusively upon the right
to inherit property and also upon the equalisation of man and women in point
of political, economic, and social rights."_ [**The Political Philosophy of
Bakunin**, p. 343]

It should be redundant to note that Bakunin's position was shared by the likes
of Kropotkin, Malatesta, Berkman, Chomsky and Ward but, clearly, it is not --
and best not ponder where such noted anarchists as Emma Goldman, Lucy Parsons,
Voltairine de Cleyre and Louise Michel _"glorified . . . the patriarchal
family"_! André Léo, a feminist libertarian and future Communard, pointed out
the obvious contradiction in Proudhon's position in 1869 which these
anarchists also saw:

> _"These so-called lovers of liberty, if they are unable to take part in the
direction of the state, at least they will be able to have a little monarchy
for their personal use, each in his own home . . . Order in the family without
hierarchy seems impossible to them -- well then, what about in the state?"_
[quoted by Carolyn J. Eichner, _"'Vive La Commune!' Feminism, Socialism, and
Revolutionary Revival in the Aftermath of the 1871 Paris Commune"_, **Journal
of Women's History**, vol. 15, No. 2, p. 75]

These anarchists, and many others, extended anarchist ideas to the one area of
life where Proudhon excluded liberty: the family. Unsurprisingly, both during
and after his lifetime, anarchists subjected it to an immanent critique (i.e.,
using Proudhon's own concepts against his own position) and so while
repulsive, Proudhon's anti-feminism should not be used for a blanket rejection
of all his ideas given the otherwise appealing nature of his vision of a
federated self-managed society -- nor anarchism **as such**. So to state, as
McNally does, that "anarchism" glorifies the patriarchal family simply
staggers belief. Only someone ignorant of both logic and anarchist theory
could make such an assertion.

Finally, we turn to the claim that anarchism _"glorified . . . racism"_. While
it is undoubtedly true that both Proudhon and Bakunin made a few racist
comments, it does not follow that anarchism as a political theory is racist.
Few would suggest that because Marx and Engels made racist comments that this
makes Marxism inherently racist (see [section 6](append31.md#app6) for a few
examples of racist comments by the founders of Marxism). The same with
anarchism -- particularly given that both Proudhon and Bakunin made anti-
racist statements in their writings. Thus we find Proudhon arguing in 1851
that in an anarchist society there will _"no longer be nationality, no longer
fatherland, in the political sense of the words: they will mean only places of
birth. Whatever a man's race or colour, he is really a native of the universe;
he has citizen's rights everywhere."_ [**Property is Theft!**, p. 567] Bakunin
echoed this in 1867, arguing that _"all collective and individual morality
rests essentially upon **respect for humanity**"_ and this meant _"the
recognition of human right and human dignity in every man, of whatever race,
colour, degree of intellectual development, or even morality."_ [**Bakunin on
Anarchism**, p. 146] That these comments, and others like them, are the ones
consistent with Anarchist principles is obvious.

So a few anti-Semitic and anti-German remarks, made in passing, does not
equate to people who _"glorified . . . racism"_ nor a theory which is
inherently racist. Rather, it means someone who expressed personal bigotries
which failed to live up to their stated ideals. Yet rather than admit the
obvious, McNally exaggerates Proudhon's and Bakunin's flaws while remaining
silent on similar ones in Marx and Engels as well as the lack of them in the
likes of Kropotkin, Malatesta, Rocker, Goldman, and so on. Ultimately, the
weakness of McNally's position can be seen from the very large Jewish
anarchist movement in both Europe and America which placed Proudhon and
Bakunin in their pantheon of influences.

## 4\. Why are McNally's comments on Proudhon a distortion of his ideas?

McNally does attempt to provide some evidence for his remarks. He turns to
Pierre-Joseph Proudhon, _"widely proclaimed 'the father of anarchism.'"_ As he
correctly notes, Proudhon was a _"printer by vocation"_ and _"strongly opposed
the emergence of capitalism in France."_ However, McNally claims that
Proudhon's _"opposition to capitalism was largely backward-looking in
character"_ as he _"did not look forward to a new society founded upon
communal property which would utilise the greatest inventions of the
industrial revolution. Instead, Proudhon considered small, private property
the basis of his utopia. His was a doctrine designed not for the emerging
working class, but for the disappearing petit bourgeoisie of craftsmen, small
traders and rich peasants."_ Unfortunately McNally has got his facts wrong.

To be fair to McNally, he is simply repeating what Marxists have been
asserting about Proudhon since Marx wrote **The Poverty of Philosophy**. In
that work, Marx claimed to be replying to Proudhon's **System of Economic
Contradictions** but, in reality, the bulk of the work is inaccurate diatribe
and its few valid points are swamped by selective quoting, false attribution
and the repeation of points Proudhon made but in such a way as to suggest he
argued the opposite. This last method of distortion can be seen when Marx
implies that Proudhon wished to return to a pre-industrial economy based on
small-scale private property:

> _"Those who, like Sismondi, wish to return to the correct proportions of
production, while preserving the present basis of society, are reactionary,
since, to be consistent, they must also wish to bring back all the other
conditions of industry of former times."_ [**Collected Works**, vol. 6, p.
137]

Compare this to Proudhon's position expounded with similar words in **System
of Economic Contradictions**:

> _"M. de Sismondi, like all men of patriarchal ideas, would like the division
of labour, with machinery and manufactures, to be abandoned, and each family
to return to the system of primitive indivision, -- **that is, to each one by
himself, each one for himself**, in the most literal meaning of the words.
That would be to retrograde; it is impossible."_ [**Property is Theft!**, p.
194]

As we will show, this was not an isolated statement: Proudhon consistently
supported not only large-scale industry but also socialised ownership. Indeed,
the Frenchman was critical of those socialists (whom he rightly labelled
"utopian") who replaced analysis of capitalism and its tendencies with visions
of an ideal system:

> _"It is important, then, that we should resume the study of economic facts
and practices, discover their meaning, and formulate their philosophy. Until
this is done, no knowledge of social progress can be acquired, no reform
attempted. The error of socialism has consisted hitherto in perpetuating
religious reverie by launching forward into a fantastic future instead of
seizing the reality which is crushing it; as the wrong of the economists has
been in regarding every accomplished fact as an injunction against any
proposal of reform._

> _"For my own part, such is not my conception of economic science, the true
social science. Instead of offering **a priori** arguments as solutions of the
formidable problems of the organisation of labour and the distribution of
wealth, I shall interrogate political economy as the depository of the secret
thoughts of humanity"_ [**System of Economical Contradictions**, p. 128]

It worthwhile noting that the **System of Economic Contradictions** Proudhon
was discussing was not some new utopian scheme, as Marx implied, but rather
capitalism: _"We will reserve this subject [the future organisation of labour]
for the time when, the theory of economic contradictions being finished, we
shall have found in their general equation the programme of association, which
we shall then publish in contrast with the practice and conceptions of our
predecessors"_. This analysis was essential in order to base ideas of social
transformation on current tendencies. So rather than abstractly contrast a
_"utopia"_ to capitalism, Proudhon stressed the need to first analyse and
understand the current system and so _"to unfold the system of economical
contradictions is to lay the foundations of universal association."_ [**Op.
Cit.**, p. 311 and p. 132]

While Marx asserted that Proudhon wished _"to take us back to the journeymen
or, at most, to the master craftsman of the Middle Ages"_ there is nothing in
his work to support such claims. Unsurprisingly, then, rather than provide a
quote from Proudhon confirming this aspiration Marx makes many an assertion
such as that individual exchange _"is consistent only with the small-scale
industry of past centuries . . . or else with large-scale industry and all its
train of misery and anarchy."_ [**Op. Cit.**, p. 190, p. 138] Yet this forgets
that under capitalism, workers do not own or control their work but in a
mutualist society they would do both. As Proudhon argued, _"the pace of
mechanical progress"_ under capitalism has _"no other effect"_ than to _"make
the chains of serfdom heavier, render life more and more expensive, and deepen
the abyss which separates the class that commands and enjoys from the class
that obeys and suffers."_ This was because people _"work under a master"_ and
so _"[u]nder the regime of property, the surplus of labour, essentially
collective, passes entirely, like the revenue, to the proprietor"_.
[**Property is Theft!**, p. 195, p. 248, p. 253] Would this _"misery"_ happen
if workers managed their own work? Of course not.

Marx ignored this, proclaiming that there is _"no individual exchange without
the antagonism of classes."_ Yet a system of worker-managed workplaces
exchanging the product of their labour with peasant farmers would not be
marked by classes for these _"relations are not relations between individual
and individual, but between worker and capitalist, between farmer and
landlord, etc."_ Marx ignores the nature of Proudhon's ideas, favouring the
assertion he _"borrows from economists the necessity of eternal relations"_
and forgets that economic relations _"are **historical and transitory
products**."_ [**Op. Cit.**, p. 144, p. 159, p. 178 and p. 166] Strangely,
Marx forgot to quote Proudhon arguing that the _"present form"_ of how labour
was organised _"is inadequate and transitory"_ and that _"the radical vice of
political economy, consists, in general terms, in affirming as a definitive
state a transitory condition, -- namely, the division of society into
patricians and proletarians"_. [**Op. Cit.**, p. 170 and p. 174]

So McNally, like Marx, distorts Proudhon's position. While many later
anarchists -- the communist-anarchists -- rejected Proudhon's market socialism
in favour of libertarian communism, the notion that his _"opposition to
capitalism was largely backward-looking in character"_ and that _"small,
private property the basis of his utopia"_ is just nonsense. To quote Proudhon
from 1841: _"We must apply on a large scale the principle of collective
production"_ [**Op. Cit.**, p. 140] As K. Steven Vincent correctly summarises:

> _"On this issue, it is necessary to emphasise that, contrary to the general
image given on the secondary literature, Proudhon was not hostile to large
industry. Clearly, he objected to many aspects of what these large enterprises
had introduced into society. For example, Proudhon strenuously opposed the
degrading character of . . . work which required an individual to repeat one
minor function continuously. But he was not opposed in principle to large-
scale production. What he desired was to humanise such production, to
socialise it so that the worker would not be the mere appendage to a machine.
Such a humanisation of large industries would result, according to Proudhon,
from the introduction of strong workers' associations. These associations
would enable the workers to determine jointly by election how the enterprise
was to be directed and operated on a day-to-day basis."_ [**Pierre-Joseph
Proudhon and the Rise of French Republican Socialism**, p. 156]

So if you look at Proudhon's writings rather than what Marx and Engels
**claimed** he wrote, it will soon be discovered that Proudhon in fact
**favoured** collective ownership and for workers' associations to manage the
means of production. Thus we find Proudhon arguing in 1840 that _"the land is
indispensable to our existence, -- consequently a common thing"_ and _"all
accumulated capital being social property"_ so _"no one can be its exclusive
proprietor"_. Property becomes _"collective and undivided"_ and managers
_"must be chosen from the workers by the workers themselves."_ [**Property is
Theft!**, p. 105, p. 118, p. 137 and p. 119] Interestingly, Marx himself noted
how the Frenchman in this work, **What is Property?**, _"abolishes property in
order to abolish poverty. Proudhon did even more. He proved in detail **how**
the movement of capital produces poverty"_. [**Collected Works**, vol. 4, p.
35]

Property would be owned collectively and so access would be free -- as we
discuss in [section I.3.3](secI3.md#seci33) there would be no more bosses
and wage-workers but simply associates. However, unlike under Marxism, there
would be no central planning and the associates would decide what to produce.
So _"the use of [workplaces], like that of the land, may be divided, but which
as property remains **undivided**."_ This _"non-appropriation of the
instruments of production"_ would be _"a destruction of property."_ Ten years
later, in 1851, he argued that _"[e]very industry, operation or enterprise
which by its nature requires the employment of a large number of workers of
different specialities, is destined to become a society or company of
workers."_ Thus _"every individual employed in the association . . . has an
undivided share in the property of the company"_ as well as _"the right to
fill any position"_ for _"all positions are elective, and the by-laws subject
to the approval of the members."_ This means that _"the collective force,
which is a product of the community, ceases to be a source of profit to a
small number of managers and speculators: it becomes the property of all the
workers."_ Thus there would be a new form of economic organisation based on
_"the co-operation of all who take part in the collective work"_ with _"equal
conditions for all members_ [**Op. Cit.**, p. 153, p. 149, p. 583, pp. 585-6]

Public utilities would be under the _"initiative of communes and departments"_
with _"workers companies . . . carrying the works out."_ This
decentralisation, this _"direct, sovereign initiative of localities, in
arranging for public works that belong to them, is a consequence of the
democratic principle and the free contract."_ Land and housing would see
rental payments being _"carried over to the account of the purchase"_ of the
resource used and once the property _"has been entirely paid for, it shall
revert immediately to the commune."_ In the case of housing, such payments
would result in _"a proportional undivided share in the house [the tenant]
lives in, and in all buildings erected for rental, and serving as a habitation
for citizens."_ The land and housing would become socialised as the property
_"thus paid for shall pass under the control of the communal administration"_
and for _"repairs, management, and upkeep of buildings, as well as for new
constructions, the communes shall deal with bricklayers companies or building
workers associations."_ In short: _"Capitalist and landlord exploitation
stopped everywhere, wage labour abolished, equal and just exchange
guaranteed."_ [**Op. Cit.**, pp. 594-5, p. 576, p. 578, p. 576 and p. 596]

Proudhon termed this vision of a self-managed economy _"an industrial
democracy"_ or _"the industrial republic"_ and argued that _"Workers'
Associations are the locus of a new principle and model of production that
must replace present-day corporations"_. When _"in an industry, all the
workers, instead of working for an owner who pays them and keeps their
product, work for one another and thereby contribute to a common product from
which they share the profit"_ then, when you _"extend the principle of
mutuality that unites the workers of each group to all the Workers'
Associations as a unit, and you will have created a form of civilisation that,
from all points of view -- political, economic, aesthetic -- differs
completely from previous civilisations"_ [**Op. Cit.**, p. 610 and p. 616]
Compare this, the anarchist position, on industrial democracy with Lenin's
who, in 1921 went so far as to suggest, somewhat disingenuously given the
reality of party dictatorship at the time, that _"Democracy is a category
proper only to the political sphere"_. [**Collected Works**, vol. 32, p. 26]

As can be seen, rather than base his _"utopia"_ on _"small, private property"_
Proudhon based it on the actual state of the French economy -- one marked by
both artisan and large-scale production. The latter he desired to see
transformed from the individual property of the few (capitalists) into the
collective property of workers' associations and placed under workers' self-
management. The former, as it did not involve wage-labour, was non-capitalist
and was compatible with a system of undivided (collective) ownership and
divided use (possession). While Proudhon's vision may be considered as (in
part or in whole) undesirable, contradictory and unstable, it is **not** _
"backward-looking in character"_ nor based on _"small, private property"_.
That Proudhon himself publicly rejected the assertion he stood for private
ownership is of note:

> _"You have me saying, and I really do not know where you could have found
this, that **ownership of the instruments of labour must forever stay vested
in the individual and remain unorganised**. These words are set in italics, as
if you had lifted them from somewhere in my books. And then, on the back of
this alleged quotation, you set about answering me that society, or the State
that stands for it, has the right to **buy back** all property assets . . .
But it does not follow at all from my speaking on the basis of socialism in
order to reject the buy back of such assets as nonsensical, illegitimate and
poisonous that I want to see individual ownership and non-organisation of the
instruments of labour endure for all eternity. I have never penned nor uttered
any such thing: and have argued the opposite a hundred times over. I make no
distinction . . . between real ownership and phoney ownership . . . I deny all
kinds of proprietary domain. I deny it, precisely because I believe in an
order wherein the instruments of labour will cease to be appropriated and
instead become shared; where the whole earth will be depersonalised . . ."_

> _"There is a more straightforward, more effective and infinitely less
onerous and less risky way of transferring ownership, of achieving Liberty,
Equality and Fraternity . . ._

> _"Capital having been divested of its power of usury, economic solidarity is
gradually created, and with it, an equality of wealth._

> _"Next comes the spontaneous, popular formation of groups, workshops or
workers’ associations;_

> _"Finally, the last to be conjured and formed is the over-arching group,
comprising the nation in its entirety, what you term the State because you
invest it in a representative body outside of society, but which, to me, is no
longer the State."_ [**Property is Theft!**, pp. 498-500]

Clearly McNally distorts Proudhon's ideas on the question of property. That he
may have been aware of the actual facts in shown by his qualification that
Proudhon's critique of capitalism was _"largely backward-looking in
character."_ The utility of which qualification is clear -- it allows him to
ignore the substantial evidence against his assertion by muttering that he
never said that Proudhon was **always** _"backward-looking"_...

McNally goes too far when he asserts that Proudhon _"so feared the organised
power of the developing working class that he went so far as to oppose trade
unions and support police strike-breaking."_ There is, of course, a deep irony
in McNally attacking Proudhon on this matter given that the Bolshevik regime
he supports and considers as a _"workers' state"_ repeatedly used not only its
political police (the infamous Cheka) but also the Red Army to break strikes
(see [section H.6.3](secH6.md#sech63)). This was done to secure Bolshevik
power **over** the working class (see [section 8](append31.md#app8)).

It must also be stressed that while Proudhon did oppose trade unions (as we
noted in [section 2](append31.md#app2) he argued the working class would be
better served using other means to liberate itself) it was not the case he
supported police strike-breaking. As the editor of a collection of Marx's
works had to admit that _"[t]o give Proudhon his due, he was not so much
justifying the actions of the French authorities as exposing the
‘contradictions' he saw as an inevitable evil of the present social order"_
[quoted by Iain McKay, _"Introduction"_, **Property is Theft!**, p. 65] As
Proudhon himself put it:

> _"workers' strikes are ILLEGAL. And it is not only the penal code which says
this, but the economic system, the necessity of the established order. As long
as labour is not sovereign, it must be a slave; society is possible only on
this condition. That each worker individually should have the free disposition
of his person and his arms may be tolerated; but that the workers should
undertake, by combinations, to do violence to monopoly society cannot permit.
Authority, in shooting down the miners, found itself in the position of Brutus
placed between his paternal love and his consular duties: he had to sacrifice
either his children or the republic. The alternative was horrible, I admit;
but such is the spirit and letter of the social compact, such is the tenor of
the charter . . . the police function, instituted for the defence of the
proletariat, is directed entirely against the proletariat."_ [**Property is
Theft!**, pp. 221-2]

The key words here are _"[a]s long as labour is not sovereign"_ and,
unsurprisingly, when Marx quoted this passage in **Poverty of Philosophy** he
omitted it, so changing Proudhon's meaning completely. So while Proudhon
opposed trade unions in favour of other forms of working class self-
organisation (co-operatives) it does not follow that he supported the breaking
of strikes when he reported when it happened. Rather he was noting that such
things were inevitable under capitalism and that this system had to be
replaced by one based on workers' self-management of production.

It is significant that the French syndicalists whom McNally is so keen to
praise and differentiate from _"classical anarchists"_ considered Proudhon
(like Bakunin) one of their influences. Similarly, the French trade unionists
who joined with their British counterparts to create the International Working
Men's Association were followers of the French anarchist. Both groups of trade
unionists saw the state repress their strikes so this would be a strange
paradox indeed if McNally's account of Proudhon's position on police strike-
breaking were correct. As it is not, there is no paradox.

McNally correctly states that Proudhon _"oppose[d] trade unions"_ but rather
than it being because he _"feared the organised power of the developing
working class"_ it was for the **opposite** reason: _"As things are at
present, which do you think will win [in a strike]? . . . [the bosses as] the
match is clearly unequal"_. At best strikes would _"lead to a general price
increase"_. [**Selected Writings of Pierre-Joseph Proudhon**, p. 182 and p.
181] Worse, as well as distorting Proudhon's position McNally fails to mention
that Proudhon opposition to trade unions and strikes as counter-productive was
**not** shared by subsequent anarchists like Bakunin, Kropotkin, Malatesta,
Goldman, and so on (see [section 9](append31.md#app9)). Why should Proudhon
(the odd man out in anarchist theory with regards to this issue) be taken as
defining that theory? Such an argument is simply dishonest and presents a
false picture of the facts.

Next McNally states that Proudhon _"violently opposed democracy"_ and presents
a series of non-referenced quotes to prove his case. Such a technique is
useful for McNally as it allows him quote Proudhon without regard to when and
where Proudhon made these comments and so their context. It also makes it
difficult, if not impossible, for the reader to discover both. This is a
deeply problematic technique, particularly given the seriousness of the
charges being made. However, the reasons why he pursued this approach become
understandable when the statements **are** tracked down as it becomes clear
that McNally is quoting Proudhon completely out of context and so twisting his
words into the opposite of what he meant.

He suggests that Proudhon's _"notes for an ideal society involved the
suppression of elections, of a free press, and of public meetings of more than
20 people."_ The word _"notes"_ gives the game way, as he is not referring to
any work produced in Proudhon's lifetime but rather his notebooks which were
published a hundred years after his death, in the 1960s, and unknown until
then. Private notebooks are hardly the best source for determining a person's
ideas as they are the means by which a thinker explores ideas, some of which
he may later conclude are deeply flawed. Moreover, as we note in [section
6](append31.md#app6), neither Proudhon nor Bakunin were not anarchists
throughout their lives nor consistently libertarian when they were. Nor was
anarchism born complete and ready made in 1840 when Proudhon proclaimed
himself an anarchist in **What is Property?**. He developed his libertarian
ideas over time and, unsurprisingly, we would discover passages in his
published works at odds with his subsequent, better developed, ideas. This
applies even more to his private notebooks in which we would expect ideas to
be sketched which he later rejected -- perhaps sketching ideas he disagreed
with precisely to clarify his thoughts.

While difficult to be completely sure, it seems likely that McNally is
selectively referring Proudhon's Notebooks from 1845 when he was clarifying
his ideas on the idea of universal association. As one historian notes,
Proudhon did envision some kind of national council at this time and the
passages on how it would be selected _"are not consistent. In some sections he
suggested that the leaders of the association were to be chosen by the
members, presumably by election . . . In yet other passages, Proudhon rather
immodestly pictured himself in the director's role. One must be extremely
cautious not to draw too many implications from these infrequent references to
the council and its method of selection. Proudhon did not . . . have any
designs for a small dictatorial elite"_ as this would _"fly in the face of his
sincere concern for individual liberty"_. So it is to his published works we
must turn to see how the conclusions of these private notes and speculations.
Interestingly, in a book published in 1843 Proudhon _"referred to the
important role that government was to perform"_ but in the introduction to a
later edition he indicated that _"he had changed his mind on this issue on the
role of government"_ and _"he insisted that reform should not -- could not --
come 'from above'; rather it could only 'from below, from the spontaneity of
the masses, and not from the initiative of the government' . . . this change
had already occurred by 1846"_ when he was _"vehemently attacking other
socialists such as Blanc for trumpeting reform initiated 'from above'"_.
[Vincent, **Op. Cit.**, p. 146 and pp. 143-4]

The same applies to when McNally suggested that Proudhon _"looked forward to a
'general inquisition' and the condemnation of 'several million people' to
forced labour"_. With no means to see whether this is selective quoting or
not, McNally disarms his readers. However, we must note a certain irony here
as he does not, of course, mention that Marx and Engels advocated _"industrial
armies, especially for agriculture"_ to ensure the _"[e]qual liability of all
to labour"_ in the **Communist Manifesto**. [**Selected Writings**, p. 53] Nor
does McNally mention the Bolshevik's introduction of the _"militarisation of
labour"_ in 1919 and 1920 with Trotsky its leading advocate. The _"very
principle of compulsory labour service is for the Communist quite
unquestionable . . . The only solution of economic difficulties from the point
of view of both principle and of practice is to treat the population of the
whole country as the reservoir of the necessary labour power . . . and to
introduce strict order into the work of its registration, mobilisation and
utilisation."_ The _"introduction of compulsory labour service is unthinkable
without the application . . . of the methods of militarisation of labour"_.
This is the _"State compulsion without which the replacement of capitalist
economy by the Socialist will for ever remain an empty sound."_ The _"Labour
State considers itself empowered to send every worker to the place his work is
necessary"_ and had _"the right to lay its hand upon the worker who refuses to
execute his labour duty"_. This _"presents the inevitable method of
organisation and disciplining of labour-power during the period of transition
from capitalism to Socialism."_ [Trotsky, **Terrorism and Communism**, p. 135,
p. 137, p. 141, p. 142 and p. 143] As can be seen Trotsky did not, as McNally
would wish to suggest, think this was a result of the Civil War but rather a
matter of principle.

McNally also fails to note that in December 1917 the Bolshevik regime created
the Cheka, a political police force, to repress opposition to it from both the
left and right as well as from reactionary forces and workers . At its worse,
it even utilised torture and the shooting of unarmed prisoners. However, its
main task was repression of opposition organisations -- including other
socialists (the anarchists were its first victims in early 1918) -- and
breaking strikes and other forms of labour protest in association with the Red
Army.

If Proudhon's one-off, never repeated, scribbles in a private notebook mean
anarchism is _"elitist and authoritarian to the core"_ and _"hostile to ideas
of mass democracy and workers' power"_ what does it mean for Bolshevism which
actually **created** a regime based on party dictatorship, political police
and the militarisation of labour which its leading thinkers defended and
justified at length in books and articles written to influence the
international workers' movement? McNally, of course, does not mention these
awkward facts so does not raise, never mind answer, the question.

However, reading the context of quotes McNally provides which **can** be
tracked down, it is difficult to take his summary seriously. We turn to this
now and will show that his readers would be justified in questioning his
claims on Proudhon. Simply put, once the context of the quotes he provides is
understood then it becomes clear McNally is quoting selectively in order to
attribute ideas to Proudhon he did not, in fact, hold. The dishonesty is
shocking.

This can be seen when McNally presents another unattributed quote: _"The
masses, he wrote are 'only savages . . . whom it is our duty to civilise, and
without making them our sovereign.'"_ Let us provide both the source and the
context McNally is keen to avoid. First, the quote is from a letter written by
Proudhon on the 11th of December 1852 and it is quoted by J. Hampden Jackson
who also helpfully presents the context which McNally strips, namely a few
days after the plebiscite which saw an overwhelming majority of French men
vote to end the Second Republic, create the Second Empire and convert the
President into an Emperor. This was exactly one year on from the President's
military coup which saw him impose a new constitution and extend his tenure by
ten years, an act again endorsed by a vast majority in a plebiscite. As
Hampden notes: _"The people of France had spoken. It remained for Proudhon to
point the moral"_. [**Marx, Proudhon and European Socialism**, p. 103]

This is the context for this quote -- a cry of despair at a people which so
willingly voted to destroy a republic and their own freedom. These two
plebiscites in favour of Louis-Napoleon's coup and autocratic rule resulted in
_"Proudhon's faith in the people"_ falling _"to its lowest level"_ and _"no
epithet was too severe for the classes in whom he had seen the great hope of
humanity."_ [George Woodcock, **Pierre-Joseph Proudhon**, p. 184] This becomes
obvious when you read the full context of the words McNally quotes:

> _"You still worship the people . . . you should absolutely demolish this
false religion. It is necessary to serve freedom and morals for themselves . .
. without scorning the people, which is only uncivilised [**sauvage**] and
that we have to civilise, do not make it your sovereign. I saw, on December
7th, 1851, when paving stones of the boulevard were still red with blood,
these honest people rush to small theatres, content, merry, without regret nor
remorse. That once I had surprised it, for five years, in red-handed
indifference, immorality, imperialist plot, ingratitude for its initiators!
Ah! admittedly, it did not mislead me; but cowardice, even when predicted, is
always hideous to see. I will strike these people, I warn you, until I made
them embarrassed of the alleged dogma of its sovereignty; because it is not
enough for us to re-examine the incompetents of '48, we must re-examine their
idol . . ."_ [**Correspondance de P-J Proudhon**, vol. V, p. 111]

Is McNally really suggesting that Proudhon's position was incorrect and that
he should have proclaimed popular support of the military coup and its
repression of those defending the Republic as an example of civilised
behaviour and the people's sovereignty? As Proudhon lamented, _"the truth"_
was that _"**the people have the government which it prefers, and the
bourgeoisie the government that it deserves**"_ and _"Napoleon III is the
legitimate, authentic expression of the middle-class and proletarian masses.
If it is not precisely the product of the national **will**, it is undoubtedly
that of the national **permission**."_ [**Op. Cit.**, p. 110] McNally for all
his talk of democracy does not tackle -- does not even raise! -- the question
of what happens if the majority make authoritarian and repressive decisions,
as it did in December 1851 and 1852. If, as the Republicans of Proudhon's time
argued, the voice of the people is the voice of God did that make Louis-
Napoleon's Presidency, coup and then Empire all legitimate? Proudhon argued no
and, moreover, placed the underlying principle of democracy -- freedom --
above its expression within the (bourgeois) state. His writings explored how
to secure mass participation in social life while minimising the possibility
of tyranny. Thus the _"federative system puts a stop to the agitation of the
masses, to all the ambitions and incitements of demagogy"_ [**Property is
Theft!**, p. 708]

By stripping away the context, McNally turns his lament for the destruction of
political freedom into a demand for it. The dishonesty is striking. It also
raises some problems for McNally's stated political position of being in
favour of _"democracy"_ \-- if anarchists are to be denounced because they
_"reject any decision-making process in which the majority of people
democratically determine the policies they will support"_ then McNally is in a
bind. The French people democratically determined to create an Empire and
destroy what was left of their Republic. Presumably it would be _"elitism"_
for him, like Proudhon, to denounce the decision and despair at those who made
it? As we discuss in [section 7](append31.md#app7), the anarchist position
on democracy is driven precisely by the obvious fact that majorities can be
wrong and oppressive. This does not imply _"elitism"_, quite the reverse.

We should also note that Marx dismissed the peasants as _"a class of
barbarians standing half outside of society"_ [**Capital**, vol. 3, p. 949]
_"In countries like France"_ the peasants _"constitute far more than half of
the population"_ but, he argued, they _"cannot represent themselves, they must
be represented. Their representative must at the same time appear as their
master, as an authority over them, as an unlimited governmental power"_. Thus
_"the Bonaparte who dispersed [the National Assembly in 1851] is the chosen of
peasantry."_ [**The Marx-Engels Reader**, p. 493, p. 608 and pp. 607-8] Marx
does not ponder the implications of these comments nor what they mean for
democracy and the so-called _"dictatorship of the proletariat"_.

The second quote McNally provides as evidence for his case is _"All this
democracy disgusts me"_. Again, no reference is provided for obvious reasons
for when it is tracked down it becomes clear that McNally is again quoting the
Frenchman completely out-of-context in order to attribute to him ideas he did
not hold, indeed was arguing against. This sentence comes from a private
letter written in 1861 bemoaning how others on the left were attacking him as
_"a false **democrat**, a false friend of progress, a false republican"_ due
to his critical position on Polish independence. Unlike most of the rest of
the left (including Bakunin, it should be noted), Proudhon opposed the
creation of a Polish state as it would be run by the _"nobility
[**nobiliarie**], [and so] catholic, aristocratic, [and] divided into
castes"_. In other words, **not** a democracy. He then proclaims: _"All this
democracy disgusts me"_. [**Correspondance de Pierre-Joseph Proudhon**, vol.
XI, p. 196-7] Once this context is provided, it becomes clear that using his
justly famous talent for irony against those on the left who violate their own
stated democratic principles by supporting the creation of a feudal regime --
if **this** is democracy, Proudhon was saying, then it disgusts him (_"All
this [so-called] democracy disgusts me"_). By quoting out-of-context McNally
turns a letter by Proudhon in which he wished the left would be
**consistently** in favour of democracy into an anti-democratic rant. His
dishonesty is clear.

This, it must be noted, is also relevant to McNally's politics. While
proclaiming that Leninism is the only consistently democratic socialist theory
and that to _"talk of a workers' state is necessarily to talk of workers'
power and workers' democracy"_, he makes an exception to the party
dictatorship ruled by Lenin and Trotsky from 1918 to 1923. Then it becomes the
case that socialism no longer _"depends upon the existence of democratic
organisation that can control society from below"_ nor _"presupposes that
workers are running the state."_ If, in 1861, Proudhon expressed his
frustration at those on the left who made exceptions to democracy for
illogical reasons (the creation of a feudal Poland) what would have been his
views of socialists who made exceptions for the Bolshevik regime?

Even without the context for the quotes McNally presents, anyone with a basic
grasp of anarchist ideas would know that he fails to quote the many statements
Proudhon made in favour of democracy. Why should the apparently anti-
democratic quotes represent anarchism and not the pro-democratic ones? Which
ones are more in line with anarchist theory and practice? Surely the pro-
democratic ones. Hence we find Proudhon arguing that _"[i]n democratising us,
revolution has launched us on the path of industrial democracy"_ and that his
People's Bank _"embodies the financial and economic aspects of modern
democracy, that is, the sovereignty of the People, and of the republican
motto, **Liberty, Equality, Fraternity.**"_ We have already mentioned
Proudhon's support for workers' self-management of production and his People's
Bank was also democratic in nature: _"A committee of thirty representatives
shall be set up to see to the management of the Bank . . . They will be chosen
by the General Meeting . . . [which] shall consist of not more than one
thousand nominees of the general body of associates and subscribers . . .
elected according to industrial categories and in proportion to the number of
subscribers and representatives there are in each category."_ [**Selected
Writings of Pierre-Joseph Proudhon**, p. 63, p. 75 and p. 79] Thus, instead of
bourgeois democracy Proudhon proposes industrial and communal democracy:

> _"every industry needs . . . leaders, instructors, superintendents, etc. . .
. they must be chosen from the workers by the workers themselves, and must
fulfil the conditions of eligibility. It is the same with all public
functions, whether of administration or instruction."_ [**Property is
Theft!**, p. 118]

> _"In order that association may be real, he who participates in it must do
so . . . as an active factor; he must have a deliberative voice in the council
. . . everything regarding him, in short, should be regulated in accordance
with equality. But these conditions are precisely those of the organisation of
labour."_ [**Op. Cit.**, p. 2156]

> _"In the republic, everyone reigns and governs . . . Representatives are
plenipotentiaries with the imperative mandate and are recallable at will . . .
Here is the republic! Here is the People's sovereignty!_ [**Op. Cit.**, p.
279]

> _"At present we are a quasi-democratic Republic: all the citizens are
permitted, every third or fourth year, to elect, first, the Legislative Power,
second, the Executive Power. The duration of this participation in the
Government for the popular collectivity is brief; forty-eight hours at the
most for each election. For this reason the correlative of the Government
remains nearly the same as before, almost the whole Country. The President and
the Representatives, once elected, are the masters; all the rest obey. They
are **subjects**, to be **governed** . . ."_ [**Op. Cit.**, p. 573]

> _"In place of laws, we will put contracts [i.e. free agreement]. -- No more
laws voted by a majority, nor even unanimously; each citizen, each commune or
corporation [i.e., self-managed industry], makes its own laws."_ [**Op.
Cit.**, p. 591]

> _"Unless democracy is a fraud, and the sovereignty of the People a joke, it
must be admitted that each citizen in the sphere of his industry, each
municipal, district or provincial council within its own territory, is the
only natural and legitimate representative of the Sovereign, and that
therefore each locality should act directly and by itself in administering the
interests which it includes, and should exercise full sovereignty in relation
to them."_ [**Op. Cit.**, p. 595]

> _"Workers' Associations are the locus of a new principle and model of
production that must replace present-day corporations . . . The principle that
prevailed there, in place of that of employers and employees . . . is
participation, that is, the MUTUALITY of services supplementing the force of
division and the force of collectivity._

> _"There is mutuality, in fact, when in an industry, all the workers, instead
of working for an owner who pays them and keeps their product, work for one
another . . . extend the principle of mutuality that unites the workers of
each group to all the Workers' Associations as a unit, and you will have
created a form of civilisation that, from all points of view -- political,
economic, aesthetic -- differs completely from previous civilisations . . ."_
[**Op. Cit.**, p. 616]

> _"groups that comprise the confederation. . . would be . . . self-governing,
self-judging and self-administering in complete sovereignty. . . universal
suffrage form its basis"_ [**Op. Cit.**, p. 716]

> _"under the democratic constitution, insofar we can judge from its most
salient ideas and most authentic aspirations, the political and the economic
are one and the same, a sole and single system based upon a single principle,
mutuality . . . no longer do we have the abstraction of people's sovereignty
as in the '93 [French] Constitution and the others that followed it, and in
Rousseau's **Social Contract**. Instead it becomes an effective sovereignty of
the labouring masses . . . the labouring masses are actually, positively and
effectively sovereign: how could they not be when the economic organism --
labour, capital, property and assets -- belongs to them entirely"_ [**Op.
Cit.**, pp. 760-1]

> _"If political right is inherent in man and citizen, consequently if
suffrage ought to be direct, the same right is inherent as well, so much the
more so, for each corporation [i.e. self-managed industry], for each commune
or city, and the suffrage in each of these groups, ought to be equally
direct."_ [quoted by Vincent, **Op. Cit.**, p. 219]

So, clearly, McNally is hardly presenting a fair summary of either Proudhon's
private notebooks, letters or his published works. This can be seen from his
justly famous manifesto issued during the 1848 revolution which presents a
better notion of his _"ideal society"_. It advocated _"democratically
organised workers' associations"_ along with _"universal suffrage and as a
consequence of universal suffrage, we want implementation of the imperative
mandate"_ otherwise _"the people, in electing representatives, does not
appoint mandatories but rather abjure their sovereignty!"_ This _"is assuredly
not socialism: it is not even democracy"_. He also demanded: _"Freedom of
association"_, _"Freedom of assembly"_ and _"Freedom of the press"_.
[**Property is Theft!**, p. 377 and p. 379]

Do all these quotes suggest a man who _"violently opposed democracy"_? Of
course not. Proudhon opposed certain types of democracy (centralised,
hierarchical, top-down, statist democracy) and was in favour of another kind
(decentralised, federal, bottom-up, libertarian democracy). So when looking at
quotes by Proudhon ripped from their context it is important to ask whether he
is attacking the centralised, hierarchical democracy of the state or the
decentralised, participatory democracy of federated self-managed workplaces
and communes? By taking of "democracy" in the abstract and not indicating that
there are different forms of it (reflecting different class interests),
McNally is confusing the issue. He fails to inform his readers that while
Proudhon repeatedly attacked the former he advocated the latter. To use terms
McNally should be familiar with, Proudhon attacked bourgeois democracy in
favour of working-class democracy rooted in mandates, recall, decentralisation
and federalism -- what would be better termed "self-management" but which
Proudhon came to call _"labour democracy"_ which would be _"the IDEA of the
new Democracy."_ In the state, _"universal suffrage is the strangulation of
the public conscience, the suicide of popular sovereignty, the apostasy of the
Revolution"_ and to _"make the vote for all intelligent, moral, democratic, it
is necessary. . . to make the citizens vote by categories of functions, in
accordance with the principle of the collective force"_. This federative
democracy would be applied in the community (communes) and industry (_"the
agricultural-industrial federation"_), indeed all areas including the military
where it was necessary to _"abolish military conscription, organise a
citizens' army"_ based on _"the right of the citizens to appoint the hierarchy
of their military chiefs, the simple soldiers and national guards appointing
the lower ranks of officers, the officers appointing their superiors."_ [**Op.
Cit.**, pp. 724-5, pp. 676-7, p. 711, p. 407 and p. 443]

As can be seen, Proudhon's position on democracy is not quite what McNally
suggests. Under a centralised social system it simply meant the people _"is
confined to choosing its bosses and its charlatans every three or four
years."_ The issue for Proudhon was to create a system which allowed the
people to govern itself and not hand power over to a few leaders --
particularly when the majority often pass that power to demagogues like Louis-
Napoleon. It was the case _"that the only way to organise democratic
government is to abolish government"_ for the State _"is the external
constitution of the social power. . . the people does not govern itself . . .
We affirm . . . that the people, that society, that the mass, can and ought to
govern itself by itself . . . We deny government and the State, because we
affirm that which the founders of States have never believed in, the
personality and autonomy of the masses."_ [**Op. Cit.**, p. 437, p. 485 and
pp. 482-483]

Thus McNally presents a distorted picture of Proudhon's ideas and thus leads
the reader to conclusions about anarchism violently at odds with its real
nature. It is somewhat ironic that McNally attacks Proudhon for being anti-
democratic. After all, as we indicate in [section 8](append31.md#app8)
below, the Leninist tradition in which he places himself has a distinct
contempt for democracy and, in practice, destroyed it in favour of party
dictatorship.

There is an addition irony. McNally praises the Paris Commune and states that
_"to secure their rule, the Parisian workers took a series of popular
democratic measures. They suppressed the standing army and replaced it with a
popular militia; they established the right of the people to recall and
replace their elected representatives"_ and _"universal male suffrage"_. He
does not mention that, as can be seen, all these were advocated by Proudhon
nor that his followers played a key role in the 1871 revolt. Clearly it is
simply **not** the case that Marx's _"work signalled an entirely new direction
in socialist thought and socialist politics"_ if he _"insisted"_ that _"the
abolition of the standing army"_, _"universal suffrage"_ and _"the right to
recall representatives"_ were _"all essential elements of any workers'
state."_ Proudhon advocated all these over a decade before his followers made
Marx belatedly see their benefit in 1871. Where Proudhon differed from Marx
was his awareness that a federated society organised from the bottom-up was no
state and to confuse the two opened the door to centralisation and the
creation of a new class system -- as happened in Russia under the Bolsheviks.

After distorting Proudhon's ideas on democracy and his desired society,
McNally moves onto more secure ground, namely his sexism. He **is** correct to
note that Proudhon _"denounced women's liberation"_ and so right to quote
Lichtheim that Proudhon had _"a firmly patriarchal view of family life"_ and
_"regarded women as inferior beings."_ However, while correct to attack the
Frenchman for this, it is incorrect to extend this to a rejection of anarchism
**as such** \-- particularly given the obvious contradiction of this position
with the rest of his ideas. As noted in [section 3](append31.md#app3), other
anarchists rejected these reactionary ideas and consistently applied
libertarian principles to within the family.

Lastly, McNally states that Proudhon _"was a rabid racist reserving his
greatest hatred for Jews, whose 'extermination' he advocated. He opposed
emancipation for the American blacks and backed the cause of the southern
slave owners during the American Civil War."_ To support his claims, he quotes
George Lichtheim (whom he considers as having _"written quite accurately"_)
stating that Proudhon expressed _"tolerance for slavery (he publicly sided
with the South during the American civil war)"_ and _"he believed in inherent
inequalities among the races"_. It will come as no surprise that this is
either completely false or not entirely true.

Let us take the question of Proudhon's anti-Semitism. It is true that Proudhon
made the occasional anti-Semitic remark in his writings but as Robert Graham
correctly summarises _"anti-semitism formed no part of Proudhon's
revolutionary programme."_ [_"Introduction"_, **General Idea of the
Revolution**, p. xxxvi] In terms of the claim that he advocated the
_"extermination"_ of the Jews what McNally does not mention is that this comes
from a single entry in his private Notebooks and was unknown until a hundred
years after his death. The intellectual dishonesty of this should be clear
and, unsurprisingly, he does not prove that this was anything more than a
passing rant nor that Proudhon held this view before 1847 or after, either
publicly or privately. In terms of the former, it is the case that Proudhon's
anti-Semitism is limited to a few passing Jewish stereotypes (which, sadly,
reflected French culture at the time) in a few of his minor articles and
books. A reader consulting his most important works would not come across a
single anti-Semitic remark and many proclamations in favour of racial
equality.

This does not mean that this private remark should not be condemned -- it
should -- but it does not follow that we reject everything wrote before or
after it. That this was a one-off rant suggests that when it was written
something caused Proudhon's (culturally reflective, but still inexcusable)
anti-Semitic feelings to intensify so resulting in this rant. Significantly,
Proudhon's beloved mother died that very month (December 1847) which suggests
that it reflected an outlet for the deep despair he must have been feeling.
Given that he never expressed this view before 1847 nor afterwards it should
be considered as a quickly forgotten aberration produced by the pressures of a
family crisis rather than something indicative of his politics.

So quoting a single rant from his private notebook presents a false impression
of Proudhon's ideas on race. To imply that a never repeated comment made in a
private notebook and completely unknown until over a century later was part of
his public work or a central aspect of Proudhon's ideas presents a completely
false impression of both them and their influence -- particularly given his
discussion of race in **The Federative Principle**, to which we now turn.

McNally and Lichtheim proclaim that Proudhon _"publicly"_ expressed
_"tolerance for slavery"_, _"opposed emancipation for the American blacks and
backed the cause of the southern slave owners"_ because he was a racist. This
is not the case, as can be seen from the extended discussion on slavery in the
only major work written during the American Civil War, **The Federative
Principle**. First, though, it must be stressed that the American Civil War
had very little to do with slavery and far more to do with conflicts within
the US ruling class. As Howard Zinn noted, the war _"was not over slavery as a
moral institution . . . It was not a clash of peoples . . . but of elites. The
northern elite wanted economic expansion -- free land, free labour, a free
[national] market, a high protective tariff for manufacturers, a bank of the
United States. The slave interests opposed all that"_ [**A People's History of
the United States**, pp. 188-9] Slavery was never the driver for the war,
regardless of how this has retroactively become the main cause (because this
fits into the self-image and rhetoric of America far better than the grim
reality). Indeed, abolition of slavery was raised as a war aim only in 1862 as
a way of boosting the North's chances of winning.

Proudhon recognised this obvious fact, arguing consistently applying the
federal principle would mean _"progressively raising the Black peoples'
condition to the level of the Whites."_ However, the North _"cares no more
than the South about a true emancipation, which renders the difficulty
insoluble even by war and threatens to destroy the confederation."_ Rather
than express _"tolerance"_ for slavery he wrote _"the enslaving of one part of
the nation is the very negation of the federative principle."_ [**Property is
Theft!**, pp. 698-9f] Both sides were _"fighting only over the type of
servitude"_ and so both must _"be declared equally guilty blasphemers and
betrayers of the federative principle and banned from all nations."_ The union
could only be saved if the North _"grants the blacks their civil rights"_ and
pursues radical economic reform by _"providing possessions for the wage-
workers and organising, alongside political guarantees, a system of economic
guarantees."_ This last was key, for the slaves had _"acquired the right of
use and habitation on American soil."_ Justice demanded that both the freed
slaves and wage workers must be given means of production (land, tools,
workplaces) and other economic guarantees as _"the conversion of black slaves
to the proletariat"_ would mean that _"black servitude will only change its
form"_ rather than ended. Both _"slavery and the proletariat are incompatible
with republican values."_ [quoted by Iain McKay, _"Neither Washington nor
Richmond: Proudhon on Racism &amp; the Civil War"_, **Anarcho-Syndicalist
Review**, no. 60, pp. 25-6]

Proudhon stressed _"with regard to **black workers**, that physiologists and
ethnographers recognise them as part of the same species as whites; that
religion declares them, along with the whites, the children of God and the
church, redeemed by the blood of the same Christ and therefore spiritual
brothers; that psychology sees no difference between the constitution of the
Negro conscience and that of the white, no more than between the comprehension
of one and the other."_ This meant that blacks should be _"as free as the
whites by nature and human dignity."_ Therefore _"the principle of equality
before the law must have as corollaries: 1) the principle of equality of
races, 2) the principle of equal conditions and 3) the principle of
increasingly similar, although never completely equal, fortunes."_ This meant
that _"[i]n a federal republic, the proletariat and slavery both seem
unacceptable; the tendency must be to abolish them both"_. So, Proudhon
argued, _"grant equal political rights to both the emancipated blacks and
those kept in servitude until now"_ and proclaim them _"fellow citizens and
equals"_. _"The federative principle,"_ he summarised, _"here appears closely
related to that of the social equality of races and the equilibrium of
fortunes. The political problem, the economic problem and the problem of races
are one and the same problem, and the same theory and jurisprudence can
resolve that problem."_ [quoted by McKay, **Op. Cit.**, p. 25]

As can be seen, McNally and Lichtheim completely distort Proudhon's actual
position. A more accurate account of this is given by academic Ralph Nelson:

> _"But it would be naive to think that it is just the peculiar institution of
slavery that Proudhon detests. He finds in the North also the principle of
inequality and class distinction. If he is critical of both sides in the war,
it is because the federative principle is incompatible with inequality,
whether the agrarian variety of master and slave or the modern version of
capital and labour . . ._

> _"Proudhon didn't really believe that the Union side would emancipate the
Negro, but would fix on deportation as the solution to the problem. The union
could be saved only by the liberation of the Negroes, granting them full
citizenship, and by a determination to stop the growth of the proletariat. For
what is gained for the former slaves, if emancipation means that they will
become members of the proletariat? He notes that the situation in Russia after
the emancipation of the serfs (1861) is analogous. Liberated serfs without
land would be helpless. Economic guarantees must be developed alongside
political ones. The corollaries of equality before the law are racial
equality, equality of condition, and an approach toward equality of
fortunes."_ [_"The Federal Idea in French Political Thought"_, **Publius**,
vol. 5, No. 3, p. 41]

There is an obvious flaw in his position, namely that _"Proudhon suggests that
nothing will have been gained if the blacks were freed only to become wage
earners, as if the condition of the wage-earner were not closer to the
realisation of personal autonomy than the condition of a well-treated slave."_
[Nelson, **Op. Cit.**, p. 43] Yet his fears should not be ignored as the
Southern states _"enacted 'black codes' which made the freed slaves like
serfs"_ after the end of the Civil War. [Zinn, **Op. Cit.**, p. 199] As one
Black newspaper put it: _"The slaves were made serfs and chained to the soil .
. . Such was the boasted freedom acquired by the coloured man at the hands of
the Yankees."_ [quoted by Zinn, **Op. Cit.**, pp. 196-7] However, these
reservations about Proudhon's arguments -- which did contain relevant concerns
-- do not make McNally's comments any more accurate. That he repeats someone
else's mistakes do not matter as he should have taken the time to verify the
claims by consulting Proudhon's own works -- particularly given the serious
nature of the assertions being made.

As can be seen, the notion that Proudhon was _"a rabid racist"_ cannot be
supported. While he undoubted made the occasion racist remark (usually anti-
Jewish), this was not reflected in his political ideas. Similarly, if, as
Lichtheim suggests _"dislike of Germans, Italians, Poles"_ is considered
important, then why are similar dislikes of other nationalities by Marx and
Engels not worthy of note? Neither was free from anti-Semitic and other racist
comments but anarchists consider these as relatively unimportant as they are
understandable given the culture they lived in. In other words, Proudhon, Marx
and Engels were people of their times and so it is unsurprising that certain
of their opinions shock and disgust us. The question is, are these views at
the core of their politics or do they reflect personal bigotries in
contradiction with them? In all three cases, the answer is obvious and so such
attacks on Proudhon fail to convince – particularly if they are generalised to
all anarchists, as if Proudhon's opposition to strikes or his sexism were
remotely applicable to the likes of Bakunin, Kropotkin or Goldman!

Also, it is somewhat ironic that McNally mentions Proudhon's alleged "support"
for the South as the Leninist tradition he places his own politics is renown
for supporting various dictatorships during wars. For example, during the
Vietnam war the various Leninist groups called for victory to North Vietnam, a
Stalinist dictatorship while during both Gulf Wars they called for victory to
Iraq, another dictatorship. In other words, they "tolerated" and "supported"
anti-working class regimes, dictatorships and repression of democracy. They
stress that they do not politically support these regimes, rather they wish
these states to win in order to defeat the greater evil of imperialism. In
practice, of course, such a division is hard to defend -- for a state to win a
war it must repress its own working class and so, in calling for a victory for
a dictatorship, they must support the repression and actions that state
requires to win the war (as an explosion of resistance, class struggle and
revolt in the "lesser imperialist power" will undermine its war machine and so
lead to its defeat). The notion that such calls do not mean support for the
regime is false and so McNally's comments against Proudhon as well as being
inaccurate also smack of hypocrisy -- his political tradition has sided with
repressive dictatorships during wars in the name of wider political aims and
theory. In contrast, anarchists have consistently raised the idea of _**"No
war but the class war"**_ in such conflicts (see [section
A.3.4](secA3.md#seca34)). Proudhon's position of refusal to side with either
the North or the South during the American Civil War is related to the
revolutionary anarchist position.

To conclude, with the exception of his sexism McNally's account of Proudhon's
ideas is either completely false (on small-scale property, democracy, racial
equality) or, at best, half-truths turned into full-lies (his anti-Semitism
and position of strikes). The scale of the distortion is simply staggering,
suggesting he never consulted a single book by Proudhon. In terms of
Proudhon's sexism and anti-Semitism, dismissing a theory based on the personal
failings of those who advocate it only convinces the superficial. Proudhon
rejected many of the assumptions of his times, yet he did not rise above all
of them. As George Lichtheim suggests (in a passage McNally could not bring
himself to quote), _"[i]n all these respects Proudhon simply reflected the
milieu from which he had sprung. His mental crudities were commonplace and not
peculiar to him. Half peasant, half townsman, he was the embodiment of the
average French workingman of his day"_. [**The Origins of Socialism**, p. 87]
Subsequent anarchists (including Bakunin) overcame the limitations of Proudhon
**the man** by using Proudhon **the theorist**. McNally, by personalising the
matter, seeks to deny the significant contributions Proudhon made to socialism
(as can be seen by the Paris Commune). If he were more confident in his own
political tradition he would not have to do this as Leninism should be able to
convince by presenting an accurate account of the ideas of others and showing
their weaknesses. That McNally did not do this for Proudhon shows that, for
all his flaws, his argument that socialism needs to be decentralised, federal
and self-managed still rings true. The failure of the Bolshevik regime
confirms this.

## 5\. Why are McNally's comments on Bakunin a distortion of his ideas?

McNally then moves on to Bakunin whom he states _"shared most of Proudhon's
views."_ The truth is somewhat different. Unlike Proudhon, Bakunin supported
trade unions and strikes, equality for women and revolution as well as being
far more explicit in support for the collectivisation of property.

This can be seen from Bakunin's last book in which he argued that the
International Working Men's Association _"has shown the proletariat the
objective it must achieve and at the same time has indicated to it the ways
and means of organising a popular force"_, namely _"a voluntary alliance of
agricultural and factory worker associations, communes, provinces and
nations"_ organised _"from below upwards"_. Socialism would be created _"only
through concerted action by the proletariat of all countries, whose
organisation first on an economic basis is precisely the object of the
International"_, by means of _"factory, artisan, and agrarian sections"_. A
_"federal organisation, from below upwards, of workers' associations, groups,
communes, districts, and, ultimately, regions and nations"_ was needed _"for
real as opposed to fictitious freedom"_. This _"popular federation"_ would be
_"based on emancipated labour and collective property"_ as the _"mode of
future production"_ would be _"producers' cooperatives"_ and _"all forms of
land and capital must become collective property"_. He also _"demand[ed],
along with liberty, the equality of rights and obligations for men and
women."_ [**Statism and Anarchy**, p. 32, p. 33, p. 49, p. 51, p. 13, p. 22,
p. 201 and p. 219]

So Bakunin disagreed with Proudhon on many subjects. He did share Proudhon's
support for industrial self-management, self-organisation in workers'
associations, his hatred of capitalism and his vision of a decentralised,
libertarian, federal, "from below" socialist society. It is true that, as
McNally notes, _"Bakunin shared [Proudhon's] anti-semitism"_ but he fails to
mention Marx and Engels' many racist remarks against Slavs and other peoples.
Also it is not true that Bakunin _"was a Great Russian chauvinist convinced
that the Russians were ordained to lead humanity into [the] anarchist
utopia."_ Rather, Bakunin (being Russian) hoped Russia would have a
libertarian revolution, but he also hoped the same for France, Spain, Italy
and all countries in Europe (indeed, the world). He opposed the Russian Empire
and he wished _"the destruction of the Empire of All the Russias"_ and
supported national liberation struggles of nationalities oppressed by Russia
(and any other imperialist nation). [**The Basic Bakunin**, p. 162] Unlike
Proudhon, he supported Polish National liberation although he recognised that
_"its leading parties, which are still drawn primarily from the gentry. have
been unable to renounce their state-centred program"_ and hoped that the
national movement would embrace economic change and seek the _"liberation and
renewal of their homeland in social revolution"_. [**Statism and Anarchy**, p.
40]

McNally moves on to _"Bakunin's organisational methods"_, stating that they
_"were overwhelmingly elitist and authoritarian."_ This assertion completely
misunderstands Bakunin's ideas on how revolutionaries should organise and
influence working class organisations as well as the revolutionary process.
Before turning to these, we must discuss Bakunin's views on social
organisation as these indicate what his _"utopia"_ (to use McNally's word)
would be like and place his ideas on how anarchists should organise into
context. If this is not done then Bakunin cannot be understood nor how later
anarchists revised his ideas.

We must start by pointing out that Bakunin's viewpoints on the organisational
methods of mass working class organisations and those of political groupings
were somewhat different. As we show in [section 9](append31.md#app9),
Bakunin had what would now be termed a syndicalist position on the labour
movement and so he rejected organising political parties and electioneering
(_"political action"_) in favour of _"the development and organisation… of the
social (and, by consequence, anti-political) power of the working masses as
much in the towns as in the countryside."_ [**Michael Bakunin: Selected
Writings**, pp. 197-8] This was reflected in his ideas on social revolution as
expressed in 1868:

> _"the federative Alliance of all working men's associations… will constitute
the Commune . . . by the creation of a Revolutionary Communal Council composed
of one or two delegates… vested with plenary but accountable and removable
mandates . . . all provinces, communes and associations… [would send] their
representatives to an agreed meeting place . . . vested with similar mandates
to constitute the federation of insurgent associations, communes and
provinces… to organise a revolutionary force capable of defeating reaction… it
is the very fact of the expansion and organisation of the revolution for the
purpose of self-defence among the insurgent areas that will bring about the
triumph of the revolution . . . Since revolution everywhere must be created by
the people, and supreme control must always belong to the people organised in
a free federation of agricultural and industrial associations . . . organised
from the bottom upwards by means of revolutionary delegation"_ [**Op. Cit.**,
pp. 170-2]

How is this federation of workers councils based on elected, mandated and
recallable delegates organised from the bottom-up _"elitist and
authoritarian"_? Compare this to McNally's own words on the soviets of the
Russian Revolution:

> _"The Russian revolution was based upon a wholly new kind of social
organisation, the workers' council or soviet. These councils, based on elected
delegates from the workplace and the neighbourhoods, became the new decision-
making bodies of Russia. They were organs of direct democracy whose delegates,
like those of the Paris Commune, could be recalled by the electors. The
soviets represented a new form of mass democracy. It was for this reason that
Lenin and Trotsky made the demand for 'All power to the soviets!' the central
slogan of the Russian revolution."_

As noted in [section 4](append31.md#app4), Proudhon had already raised the
idea of recallable delegates in the 1848 revolution and it was his followers
who applied them in 1871. Given McNally's praise of the Paris Commune and the
Russian soviets, it seems strange that Bakunin's comments with regards to
revolutionary social organisation with its obvious parallels to both should
not be mentioned. Perhaps because to do so would totally undermine his case?
Thus rather than being _"overwhelmingly elitist and authoritarian"_ Bakunin's
ideas on a future society have marked similarities to the actual structures
created by working people in struggle and are marked by libertarian and self-
managed visions and concepts -- as anyone familiar with Bakunin's work would
know.

The key difference between Bakunin and Lenin is that for the former turning
the soviets into a state (even a so-called "workers' state") as desired by the
latter would mean that power moved from the bottom to the top, empowering the
few at the expense of the many. Given that Lenin's aim was the creation of a
Bolshevik government it comes as no surprise that this _"central slogan"_ of
the revolution was quickly violated (see [section H.1.7](secH1.md#sech17)).
As Bakunin once put it, there is the _"Republic-State"_ and there is _"the
system of the Republic-Commune, the Republic-Federation, i.e. the system of
**Anarchism**. This is the politics of the Social Revolution, which aims at
the abolition of the **State** and establishment of the economic, entirely
free organisation of the people -- organisation from bottom to top by means of
federation."_ [**The Political Philosophy of Bakunin**, p. 314] The difference
is fundamental and not simply a question of words (see [section
H.2.1](secH2.md#sech21)).

The question now arises of how Bakunin thought revolutionaries should
influence both working class struggle and revolution. While not completely
libertarian, Bakunin's ideas on this issue are different than McNally's
summary would suggest.

The aim of the political grouping was to exercise a _"natural influence"_ on
the members of unions and associations, seeking to convince them of the
validity of anarchist ideas. The political group did not aim to seize
political power (unlike Marxists) and so it _"rule[d] out any idea of
dictatorship and custodial control."_ All it could do was to _"assist the
birth of the revolution by sowing ideas corresponding to the instincts of the
masses"_ and act _"as intermediaries between the revolutionary idea and the
popular instinct."_ It _"help[s] the people towards self-determination on the
lines of the most complete equality and the fullest freedom in every
direction, without the least interference from any sort of domination."_
[**Michael Bakunin: Selected Writings**, p. 172 and p. 191] The _"sole aim of
a secret society must be, not the creation of an artificial power outside the
people, but the rousing, uniting and organising of the spontaneous power of
the people"_. It _"does not foist upon the people any new regulations, orders,
styles of life, but merely unleashes its will and gives wide scope to its
self-determination and social organisation, which must be created by itself
from below and not above. The organisation must accept in all sincerity the
idea that it is a servant and a helper, but never a commander, of the people,
never under any pretext its manager, not even under the pretext of the
people's welfare."_ The secret society _"acts on the people only by the
natural personal influence of its members who are not invested with any
power"_ and so this _"does not threaten the liberty of the people because it
is free from all official character. It is not placed above the people like
state power because its whole aim, defined by its programme, consists of the
fullest realisation of the liberty of the people."_ [quoted by Michael
Confino, **Daughter of a Revolutionary**, p. 250, pp. 258-9 and p. 261]

As we discuss in more detail in [section J.3.7](secJ3.md#secj37), the key to
understanding the role of Bakunin's secret societies is to recognise that
rather than seek to be elected into positions of power, they would work within
popular organisations at the base and argue their ideas and win others over to
them (i.e., their _"natural personal influence"_). This is why Bakunin
considered such organisations as being no danger to popular liberty -- by not
having power they could not force their ideas onto others, unlike a new state
regime. All this is ignored by McNally.

McNally then quotes _"one historian"_ on Bakunin. It should be noted that not
even providing a name makes evaluating the accuracy of the historian's work
impossible and so leaves the reader in the dark as to whether the historian
does provide a valid account of Bakunin's ideas. However, after investigation
the historian in question is George Lichtheim whom McNally feels provides
_"the most reliable guides to early socialist thought"_ presumably because his
account chimes with all the standard Marxist prejudices, assumptions and
errors about anarchism (significantly McNally ignores Lichtheim's statement
that Bakunin's supported _"anti-authoritarian collectivism"_). A socialist,
Lichtheim opposed Marxist-Leninism while presenting a sceptical but
superficial account of anarchism. This can be seen from the words McNally
quotes:

> _"The International Brotherhood he founded in Naples in 1865-66 was as
conspiratorial and dictatorial as he could make it, for Bakunin's
libertarianism stopped short of the notion of permitting anyone to contradict
him. The Brotherhood was conceived on the Masonic model, with elaborate
rituals, a hierarchy, and a self-appointed directory consisting of Bakunin and
a few associates."_ [**A Short History of Socialism**, p. 126]

First, it should be noted that Bakunin considered secret societies as
necessary because, at the time, most countries were monarchies and did not
have basic civil liberties. Bakunin had been imprisoned by the Tsar for his
activities during the 1848 revolution and so had personal experience of the
fate of revolutionaries who were caught by these regimes. As Murray Bookchin
argues, _"Bakunin's emphasis on conspiracy and secrecy can be understood only
against the social background of Italy, Spain, and Russia the three countries
in Europe where conspiracy and secrecy were matters of sheer survival."_
[**The Spanish Anarchists**, p. 24] McNally ignores the historical context --
and the awkward fact that Marxists have also favoured secret groupings in the
face of similar regimes.

Second, it should be noted that in 1865-6 Bakunin was just becoming an
anarchist and this period _"represents the transition from the revolutionary
nationalism of his middle-years to the revolutionary anarchism of his last
period."_ The _"rituals"_ of the International Brotherhood were not reflected
in later organisations because, as Bakunin admitted to a recruit, _"they
aren't necessary. We invented that for the Italians"_. In other words, they
reflected the revolutionary traditions of the democratic conspiracies of that
country rather than his own ideas, something confirmed by James Guillaume, his
associate in the Alliance of Social Democracy, who recounted this, Bakunin's
group in the First International, _"had little resemblance to 'the classic
type of secret society where one had to obey orders coming from above.'
Bakunin's organisation was nothing more than a 'free association of men who
were uniting for collective action, without formalities, without ceremonies or
mysterious rites.'"_ As for the Brotherhood, _"the constitution thus laid down
was to be regarded as provisional; for when the Brotherhood attained a
membership of seventy, a constituent assembly was to be convened which would
determine the definite rules and programme of the organisation."_ [E.H. Carr,
**Michael Bakunin**, p. 320, p. 316, p. 357 and p. 315]

Third, this summary is simply inaccurate. To show this, we shall quote from
Bakunin's letter to the Russian Nihilist Sergy Nechayev in which he explains
the differences in their ideas. He discusses the _"principles and mutual
conditions"_ for a _"new society"_ of revolutionaries in Russia (noting that
this was an _"outline of a plan"_ which _"must be developed, supplemented, and
sometimes altered according to circumstances"_):

> _"Equality among all members and the unconditional and absolute solidarity
-- one for all and all for one -- with the obligation for each and everyone to
help each other, support and save each other. . . Complete frankness among
members and proscription of any Jesuitical methods in their relationships . .
. When a member has to say anything against another member, this must be done
at a general meeting and in his presence. **General fraternal control** of
each other . . . Everyone's personal intelligence vanished like a river in the
sea in the collective intelligence and all members obey unconditionally the
decisions of the latter._

> _"All members are equal; they know all their comrades and discuss and decide
with them all the most important and essential questions bearing on the
programme of the society and the progress of the cause. The decision of the
general meeting is absolute law. . . The society chooses an Executive
Committee from among their number consisting of three or five members who
should organise the branches of the society and manage its activities in all
the regions of the [Russian] Empire on the basis of the programme and general
plan of action adopted by the decision of the society as a whole. . . This
Committee is elected for an indefinite term. If the society . . . the People's
Fraternity is satisfied with the actions of the Committee, it will be left as
such; and while it remains a Committee each member . . . and each regional
group have to obey it unconditionally, except in such cases where the orders
of the Committee contradict either the general programme of the principle
rules, or the general revolutionary plan of action, which are known to
everybody as all . . . have participated equally in the discussion of them. .
. In such a case members of the group must halt the execution of the
Committee's orders and call the Committee to judgement before the general
meeting . . . If the general meeting is discontented with the Committee, it
can always substitute another one for it. . . Any member or any group is
subject to judgement by the general meeting . . . No new Brother can be
accepted without the consent of all or at the very least three-quarters of all
the members. . ._

> _"The Committee divides the members . . . among the Regions and constitutes
Regional groups of leaderships from them . . . Regional leadership is charged
with organising the second tier of the society -- the **Regional Fraternity**,
on the basis of the same programme, the same rules, and the same revolutionary
plan . . . Each Regional Committee will set up **District** Committees from
members of the **Regional Fraternity** . . . District Committees can, if
necessary and only with the consent of the Regional Committee, set up a third
tier of the organisation -- **District Fraternity** with a programme and
regulations as near as possible to the general programme and regulations of
the People's Fraternity. The programme and regulations of the District
Fraternity will not come into force until they are discussed and passed by the
general meeting of the Regional Fraternity and have been confirmed by the
Regional Committee. . ._

> _"Jesuitical control . . . are totally excluded from all three tiers of the
secret organisation . . . The strength of the whole society, as well as the
morality, loyalty, energy and dedication of each member, is based exclusively
and totally on the shared truth, sincerity and trust, and on the open
fraternal control of all over each one."_ [quoted by Confino, **Op. Cit.**,
pp. 264-6]

As can be seen, while there is much in Bakunin's ideas that few anarchists
would agree with today, it cannot be said that it was _"dictatorial"_ as
McNally and Lichtheim wish to suggest. Ironically, as we note in [section
H.2.14](secH2.md#sech214), there are distinct similarities to Lenin's (and
Marx's during the 1848 revolution) ideas on how revolutionaries should
organise. Thus we find Lenin arguing in **What is to be Done?** for _"a
powerful and strictly secret organisation, which concentrates in its hands all
the threads of secret activities, an organisation which of necessity must be a
centralised organisation"_ because the revolutionary movement would _"benefit
by the fact that a 'dozen' experienced revolutionaries, no less professionally
trained than the police, will centralise all the secret side of the work --
prepare leaflets, work out approximate plans and appoint bodies of leaders for
each urban district, for each factory district and for each educational
institution, etc."_ Under Tsarism, the _"only serious organisational principle
the active workers of our movement can accept is strict secrecy, strict
selection of members, and the training of professional revolutionaries."_
[**The Essential Lenin**, p. 158, p. 149 and p. 162]

The parallels with Bakunin's system are clear and are predominately the result
of the identical political conditions both revolutionaries experienced. While
anarchists are happy to indicate and oppose the non-libertarian aspects of
Bakunin's ideas, it is hard for the likes of the McNally to attack Bakunin
while embracing Lenin's ideas on the party, justifying their more
"undemocratic" aspects as a result of the objective conditions of Tsarism.
Worse, in 1920 these principles were agreed by the Communist International,
including the necessity of both legal and illegal structures within the party
for _"the Communist parties must learn to combine legal and illegal activity
in a planned way. However, the legal work must be placed under the actual
control of the illegal party at all times."_ [**Proceedings and Documents of
the Second Congress 1920**, vol. 1, p. 198-9] Anarchists have, since Bakunin's
death, rejected his ideas that anarchists should organise in a centralised
fashion (see [section J.3](secJ3.md)).

Therefore, McNally has a problem. On the one hand, he denounces Bakunin's
ideas of a centralised, secret top-down organisation of revolutionaries. On
the other, the party structure that Lenin recommends is also a tightly
disciplined, centralised, top-down structure with a membership limited to
those who are willing to be professional revolutionaries. So if he attacks
Bakunin, he must also attack Lenin, not to do so is hypocrisy. And, unlike
Bakunin, Lenin wished his party to seize state power -- which then used it to
build a system in its own image (see [section H.5.9](secH5.md#sech59)).

At this point it will be objected that Lenin's party was more democratic and
he allowed people to disagree with him. Yet Lichtheim's summation leaves a lot
to be desired. To point to just three examples: the historian T.R.
Ravindranathan indicates that _"Bakunin wanted the Alliance to become a branch
of the International [Working Men's Association] and at the same time preserve
it as a secret society. The Italian and some French members wanted the
Alliance to be totally independent of the IWA and objected to Bakunin's
secrecy. Bakunin's view prevailed on the first question as he succeeded in
convincing the majority of the harmful effects of a rivalry between the
Alliance and the International. On the question of secrecy, he gave way to his
opponents"_. [**Bakunin and the Italians**, p. 83]; while other Bakunin
influenced sent delegates to the Hague Congress of the First International in
1872, the Italian sections decided not to; The Spanish section of the Alliance
_"survived Bakunin . . . yet with few exceptions it continued to function in
much the same way as it had done during Bakunin's lifetime."_ [George R.
Esenwein, **Anarchist Ideology and the Working Class Movement in Spain**, p.
43] Hardly what you would expect if Lichtheim's comments were accurate.

The evidence suggests that the Alliance _"was not a compulsory or
authoritarian body."_ In Spain, it _"acted independently and was prompted by
purely local situations. The copious correspondence between Bakunin and his
friends . . . was at all times motivated by the idea of offering advice,
persuading, and clarifying. It was never written in a spirit of command,
because that was not his style, nor would it have been accepted as such by his
associates."_ Moreover, there _"is no trace or shadow or hierarchical
organisation in a letter from Bakunin to [Spanish anarchist] Mora . . . On the
contrary, Bakunin advises 'direct' relations between Spanish and Italian
Comrades."_ The Spanish comrades also wrote a pamphlet which _"ridiculed the
fable of orders from abroad."_ [Juan Gomez Casa, **Anarchist Organisation**,
p. 25 and p. 40] This is confirmed by George R. Esenwein, who argues that
_"[w]hile it is true that Bakunin's direct intervention during the early days
of the International's development in Spain had assured the pre-dominance of
his influence in the various federations and sections"_ of the organisation,
_"it cannot be said that he manipulated it or otherwise used the Spanish
Alliance as a tool for his own subversive designs."_ Thus, _"though the
Alliance did exist in Spain, the society did not bear any resemblance to the
nefarious organisation that the Marxists depicted."_ [**Op. Cit.**, p. 42]
Indeed, as Max Nettlau points out, those Spaniards who did break with the
Alliance were persuaded of its _"hierarchical organisation . . . not by their
own direct observation, but by what they had been told [by Marxists] about the
conduct of the organisation"_ in other countries. [quoted by Casa, **Op.
Cit.**, pp. 39-40]

In summary, McNally's comments are a distortion of Bakunin's ideas and
activities. He misrepresents one aspect of Bakunin's ideas while ignoring
those aspects which support working class self-organisation and self-
management. Ironically, he ignores the awkward fact that Bakunin's and Lenin's
ideas on how revolutionaries should organise were similar (as to be expected
given similar circumstances) but with the key difference that Lenin, unlike
Bakunin, sought state power for the professional revolutionaries (see [section
H.3.11](secH3.md#sech311)).

## 6\. Are these _"quirks of personality"_ or _"rooted in the very nature of
anarchist doctrine"_?

After chronicling the failings of, and distorting the facts about, two
individuals, McNally tries to generalise. _"These characteristics of Bakunin
and Proudhon,"_ he argues, _"were not mere quirks of personality. Their
elitism, authoritarianism and support for backward-looking and narrow-minded
causes are rooted in the very nature of anarchist doctrine."_ Thus McNally
claims that these failings of Proudhon and Bakunin are not personal failings
but rather political. They, he suggests, represent the reactionary core of
anarchist politics but makes no attempt to show that this is the case. Worse,
many of his claims about _"anarchist doctrine"_ are simply untrue and, once
corrected, leave little left other than _"quirks of personality"_.

Take, for example, Proudhon's position on the American Civil War. Let us
assume that McNally's assertion is correct (as shown in [section
4](append31.md#app4) it is not) and he supported the South. Bakunin
_"supported the Union in the struggle between the states"_. [Paul Avrich,
**Anarchist Portraits**, p. 20] What does this mean for _"anarchist
doctrine"_? Which of the two represented the "real" anarchist position? So the
question remains why Proudhon's refusal to support either side during the
American Civil War (his actual position) is an example of _"anarchist
doctrine"_ while Bakunin's support of the North is not. Proudhon, to raise
another obvious example, did not share Bakunin's interest in secret societies
(nor did Kropotkin, Goldman, etc.). What does this tell us about _"the very
nature of anarchist doctrine"_? Could Bakunin's position not be better
explained by him being imprisoned in a Tsarist dungeon? Could it be that
rather than attack anarchism, McNally simply attacks the failings of
individual anarchists?

Unlike Proudhon, Bakunin and other revolutionary anarchists supported both
unions and strikes and, as Kropotkin summarised, anarchists _"do not seek to
constitute, and invite the working men not to constitute, political parties in
the parliaments. Accordingly, since the foundation of the International
Working Men's Association in 1864-1866, they have endeavoured to promote their
ideas directly amongst the labour organisations and to induce those unions to
a direct struggle against capital, without placing their faith in
parliamentary legislation"_. How can Proudhon's position represent _"the very
nature of anarchist doctrine"_ when he was the only one to hold it? Similarly,
Kropotkin simply (and rightly) dismissed Proudhon's position on women's
equality as one _"which most modern writers will, of course, not agree."_
[**Direct Struggle Against Capital**, p. 165 and p. 218] If McNally is right
then we can only conclude that only Proudhon amongst all anarchist thinkers
understood what anarchism stood for. That is, needless to say, unlikely and so
we can only conclude that Proudhon's sexism and opposition to strikes were
_"quirks of personality"_ which later anarchists rejected in favour of a more
consistent libertarian position (in the case of Proudhon's anti-feminism) or
as inadequate (in the case of Proudhon's reformism). Neither, in short, is
inherent to anarchist theory and it would be silly to suggest they were.

It should also be noted that Marx and Engels took positions which modern
readers would consider strange at best. In the case of slavery, Marx suggested
in his polemic against Proudhon that if you _"[c]ause slavery to disappear and
you will have wiped America off the map of nations"_. [**Collected Works**,
vol. 6, p. 167] Engels, unsurprisingly, after the American Civil War added a
note suggesting that this obvious tolerance of slavery was only valid in 1847.
A few years later, in the early 1850s, Marx argued that slavery in Jamaica had
been marked by _"freshly imported BARBARIANS"_ in contrast to the United
States where _"the present generation of Negroes"_ was _"a native product,
more or less Yankeefied"_ and _"hence capable of being emancipated."_ {**Op.
Cit.**, vol. 39, p. 346] The many comments by Marx and Engels on the
progressive role of imperialism in replacing traditional societies by
capitalist social relationships are also relevant in this context as are the
many racists comments on Slavs and other peoples (including Jews). In other
words, Proudhon and Bakunin were not the only major socialist thinkers to
express racist views and if they are to be dismissed as a result then why not
Marx and Engels as well?

We will draw upon Roman Rosdolsky's important work _"Engels and the
‘Nonhistoric' Peoples: The National Question in the Revolution of 1848."_
(**Critique: Journal of Socialist Theory**, No. 18/19) to sketch the bigotries
of Marx and Engels (unless otherwise indicated all quotes in this section come
from Rosdolsky's work). As will be seen, on almost every issue McNally raises
against Proudhon and Bakunin we find similar comments by Marx and Engels.

Unsurprisingly, given the times, Marx and Engels made numerous anti-Semitic
remarks both in private and public. During the 1848 revolution, the paper Marx
edited (**Neue Rheinische Zeitung**) published the reports of Müller-Tellering
who expressed _"an all too maniacal hatred"_ of Jews. Engels wrote _"very
unpleasant passages on the (Polish) Jews"_ [193, 116], describing them as
_"the very incarnation of haggling, avarice and sordidness"_ and _"the meanest
of all races"_ with _"its lust for profit."_ The Austrian Jews had
_"**exploited the revolution** and are now being punished for it"_ while
_"anyone who knows how powerful"_ they were. He generalised by suggesting that
_"Jews are known to be cheated cheats everywhere"_ and, according to Marx,
they had put themselves _"at the **head of the counter-revolution**"_ and so
the revolution had _"to throw them back into their ghetto"_. [quoted 192,
203,196] Marx's paper _"did not dissociate itself from the anti-Semitic
'popular opinion'"_ and its articles resulted in some of its backers who were
Jewish demanding the return of their money as it preached _"religious
hatred."_ [201, 191]

Yet the despicable attitude expressed against Jews in **Neue Rheinische
Zeitung** is the least of the issues of concern here given the opinions
expressed over Slavs by the founders of Marxism. Thus we find Engels asserting
that the Slavs have been _"forced to attain the first stage of civilisation
only by means of a foreign yoke, are not viable and will never be able to
achieve any kind of independence"_ and that the conquered should be grateful
to the Germans for _"having given themselves the trouble of civilising the
stubborn Czechs and Slovenes, and introducing among them trade, industry, a
tolerable degree of agriculture, and culture!"_ [**Marx-Engels Collected
Works**, vol. 8, p 238] Worse, Engels proclaimed that _"one day we shall
**take a bloody revenge on the Slavs** for this cowardly and base betrayal of
the revolution"_ and _"hatred of the Russians was, and still is, the first
revolutionary passion of the Germans"_. The revolution could only be secured
_"against these Slavs peoples by the most decisive acts of terrorism"_ and
_"**a war of annihilation and ruthless terrorism**, not in the interests of
Germany but in the interests of the revolution!"_ There would be _"a **bloody
revenge in the Slav barbarians**"_ and a war which will _"**annihilate all
these small pig-headed nations even to their very names**"_ and _"will not
only cause reactionary classes and dynasties **to disappear from the face of
the earth, but also entire reactionary peoples.** And that too is an
advance."_ [quoted, 85, 86]

In short, Engels advocated ethnic cleansing in the name of the revolution
against those whom he considered _"nonhistoric"_ peoples. This was recognised
by leading Marxist Karl Kautsky who, rightly, denounced him for advocating
that _"they had to be exterminated"_ [quoted 90] Regardless of what drove
these rants, as Rosdolsky rightly states _"it no way nullifies the fact that
they made entire peoples the object of this hatred and proclaimed a 'war of
annihilation' against them."_ [87]

Ignoring the genocidal ethnic cleansing proclaimed against the Slavs (bar
Poles) and other _"nonhistoric"_ people, Engels wrote of the war which _"broke
out over Texas"_ between Mexico and the USA and how it was good that _"that
magnificent California was snatched from the lazy Mexicans, who did not know
what to do with it"_ by _"the energetic Yankees."_ [quoted, 159] He failed to
mention that the revolt of 1836 over Texas which was the root of the 1846 war
was conducted by _"**planters, owners of Negro slaves**, and their main reason
for revolting was that **slavery had been abolished in Mexico in 1829**."_
[160] In fact in 1845 a majority of voters in the Republic of Texas approved a
proposed constitution that specifically endorsed slavery and the slave trade
and was later accepted by the U.S. Congress. Unlike Engels, Northern
abolitionists attacked this war as an attempt by slave-owners to strengthen
the grip of slavery and ensure their influence in the federal government and
publicly declared their wish for the defeat of the American forces. Henry
David Thoreau was jailed for his refusal to pay taxes to support the war,
penning his famous essay **Civil Disobedience**. [Howard Zinn, **A People's
History of the United States**, pp. 155-7] Rosdolsky rightly comments on how
_"inappropriate, in fact perverse, was Engels' illustration."_ [160]

So we find distinct parallels between McNally's attacks on Proudhon and the
many racist and anti-Semitic remarks by Marx and Engels (as listed by Peter
Fryer in his _"Engels: A Man of his Time"_ [John Lea and Geoff Pilling (eds.),
**The condition of Britain: Essays on Frederick Engels**]) as well as their
siding with slave states against abolitionist ones. Nor did Marx, it must be
noted, denounce Proudhon's racism or sexism (he also failed to comment on the
Paris Commune being elected by **male** universal suffrage, thinking nothing
of the exclusion of half the population while proclaiming its democratic
nature). Strangely, most Marxists (rightly) condemning Proudhon for his
bigotries are silent about this -- as silent as they are on the awkward facts
that Proudhon did not actually support the Southern States in the American
Civil War and that a one-off, never repeated, comment made in a private
notebook simply cannot be taken as expressing his political ideas (see
[section 4](append31.md#app4) for details).

The fact is, once we correct McNally's errors, we discover that the vast
majority of Proudhon's and Bakunin's positions are **not** _"backward-looking
and narrow-minded"_, quite the reverse. Where a position **is** so (Proudhon's
position to trade unions and feminism being the most obvious examples) then we
quickly discover that subsequent anarchists publicly rejected it. Most of the
position's McNally paints as _"anarchist doctrine"_ were not actually held by
either Proudhon or Bakunin (such as, opposition to industry and collectively-
owned and managed property). Rather than take examples which are common to
most anarchist theorists -- and so actually reflective of _"anarchist
doctrine"_ \-- McNally takes only a few positions held by one, at most two,
major anarchist thinkers. Worse, these positions are tangential to the core of
their ideas and, indeed, directly opposed to them (such as infrequently
expressed bigotries against specific peoples being in obvious conflict to
their other, more common, support for racial equality). From this minority of
examples McNally generalises a theory -- and so violates the basic principles
of the scientific method!

So McNally's position leaves something to be desired. Why is Proudhon's
opposition to trade unions and strikes is an example _"anarchist doctrine"_
while Bakunin's (and Kropotkin's, Malatesta's, Berkman's, Goldman's, etc.)
support for both is not? Why is Proudhon's sexism _"anarchist doctrine"_ but
Bakunin's (and Kropotkin's, Goldman's, Malatesta's, etc.) support for women's
liberty and equality is not? Why proclaim Bakunin _"shared most of Proudhon's
views"_ when anyone who did the most basic research would quickly conclude
that in these two issues (and others!) Bakunin rightly rejected the positions
McNally raises with regards to Frenchman's ideas? Worse, many of the positions
McNally attacks Proudhon for are simply inaccurate -- he simply did not hold
the ideas McNally so confidently asserts he did.

Moreover, as Daniel Guérin notes _"[m]any of these masters were not anarchists
throughout their lives and their complete works include passages which have
nothing to do with anarchism."_ Bakunin, for example, was only an anarchist
from around 1864 to his death in 1876 while _"in the second part of his career
Proudhon's thinking took a conservative turn"_. [**Anarchism**, p. 6] As such,
the positions McNally, rightly, attacks (once his errors are corrected!) are
clearly _"quirks of personality"_ rather than somehow _"rooted in the very
nature of anarchist doctrine."_ This can be seen from the awkward fact that no
later anarchists advocated them. Not to mention the awkward fact that Marx and
Engels shared similar views as those McNally attacks Proudhon and Bakunin for
having (even if, in reality, they did not hold the positions McNally claims
they did).

These examples in themselves prove the weakness of McNally's claims and the
low levels of scholarship which lay behind them. Indeed, it is amazing that
the SWP/ISO printed this diatribe -- it obviously shows their contempt for
facts, history and the intelligence of their desired audience.

## 7\. Are anarchists against democracy?

McNally asserts the following:

> _"Originating in the revolt of small property owners against the
centralising and collectivising trends in capitalist development (the tendency
to concentrate production in fewer and fewer large workplaces), anarchism has
always been rooted in a hostility to democratic and collectivist practices.
The early anarchists feared the organised power of the modern working class.
To this day, most anarchists defend the 'liberty' of the private individual
against the democratically made decisions of collective groups."_

As indicated in [section 3](append31.md#app3), the notion that anarchists
are against large-scale industry or collective property is simply an
invention. Both Proudhon and Bakunin, for example, argued for collective
management and ownership of the means of production by the workers themselves.
Indeed, workers' self-management of production and collective ownership were
raised in the very first anarchist book, Proudhon's **What is Property?** and
both have remained an key aspect of anarchism ever since. Proudhon put it
well: _"Large industry and high culture come to us by big monopoly and big
property: it is necessary in the future to make them rise from the
association."_ [quoted by [K. Steven Vincent, **Pierre-Joseph Proudhon and the
Rise of French Republican Socialism**, p. 156] So workers' associations
running workplaces is at the heart of anarchism, an easy fact to discover if
you bother to read Proudhon and Bakunin -- as is the fact that Bakunin
supported revolutionary trade unionism as the means of producing a social
revolution (see [section 9](append31.md#app9)). So much for _"fear[ing] the
organised power of the modern working class"_!

So the premise of his assertion is factually incorrect. What of the
conclusion, the idea that anarchists support the liberty to ignore _"the
democratically made decisions of collective groups"_? Here McNally takes a
grain of truth to create a lie.

First, however, we need to ask an obvious question: what does "democracy"
mean? Or, more correctly, what kind of democracy are we talking about? If
quoting Lenin is not **too** out of place, in a section of his pamphlet **The
Proletarian Revolution and the Renegade Kautsky** in section entitled _"How
Kautsky Turned Marx Into A Common Liberal"_, Lenin stated it was _"natural for
a liberal to speak of 'democracy' in general; but a Marxist will never forget
to ask: 'for what class?'"_ [**The Lenin Anthology**, p. 465] So the question
is not whether anarchists support "democracy" or not but what **kind** of
democracy and for whom. For if McNally is right (and he is) and there are two
kinds of socialism (one "from above" and one "from below") then there are
multiple kinds of democracy: centralised and decentralised; unitarian and
federal, top-down and bottom-up; bourgeois and workers. That is why Proudhon
talked of the workers democracy (_"Démocratie ouvrière"_) in his last work,
contrasting it to the democracy (the left-Jacobin bourgeois-republican
democracy which included the state socialists), but the elements of which he
had been expounding upon since the 1840s.

A close reading of Proudhon shows that his main opposition to "democracy" was
that it was, paradoxically, not democratic enough as it referred to the
Jacobin notion that the whole nation as one body should elect a government. In
such a regime _"**the People reigns and does not govern**, which is to deny
the Revolution."_ [**Property is Theft!**, p. 267] He sought a social
organisation in which people had meaningful control over their own lives -- as
individuals **and** as groups, collectives. This was not possible under a
centralised democracy and so _"universal suffrage provides us, . . . in an
embryonic state, with the complete system of future society. If it is reduced
to the people nominating a few hundred deputies who have no initiative . . .
social sovereignty becomes a mere fiction and the Revolution is strangled at
birth."_ [**Selected Writings of Pierre-Joseph Proudhon**, p. 123] Nor was it
possible as long as workers did not control their work and workplaces. This
meant, as discussed in [section 4](append31.md#app4), he argued for a
decentralised, federal bottom-up system of communal and workplace associations
based on elected, mandated and recallable delegates:

> _"we are all voters; we can choose the most worthy . . . we can follow them
step-by-step in their legislative acts and their votes; we will make them
transmit our arguments and our documents; we will suggest our will to them,
and when we are discontented, we will recall and dismiss them._

> _"The choice of talents, the imperative mandate . . . and permanent
revocability are the most immediate and incontestable consequences of the
electoral principle. It is the inevitable program of all democracy._
[**Property is Theft!**, p. 273]

As we noted in [section 5](append31.md#app5), Bakunin had identical ideas on
the need for a decentralised, federal, bottom-up social organisation based on
elected, mandated and recallable delegates. Rather than express _"hostility to
democratic and collectivist practices"_, anarchists have always sought to
discover which social forms allow **genuine** democratic and collectivist
practices to flourish -- a "democracy" which reduces the masses to simply
picking their masters every few years while workers were employed by bosses
would not promote libertarian values. Hence the support for workers' self-
management of production by democratic associations, communal self-government
and social-economic federalism even the casual reader would find in the works
of Proudhon and Bakunin but which McNally fails to mention.

Anarchists are well aware that support for democratic collectives in the
workplace and community is a necessary but not sufficient condition for
individual freedom (to quote McNally, the _"challenge is to restore to
socialism its democratic essence, its passionate concern with human
freedom"_). This is because collectives can make bad decisions, the majority
can -- and does -- act oppressively towards the minority. For example, the
United States has seen numerous votes on the issue of homosexual rights which
saw the majority of voters or their representatives reject equality. That the
majority are against equality for gays does not make it right -- anymore than
previous majorities against equality for women and blacks were right. If a
majority vote for a right-wing party which promises to make strikes illegal
would McNally accept that decision and urge trade unionists to obey the
democratic decisions of the collectivity? Would a referendum result make it
any more just and worthy of respect? What if the majority vote to ban the
teaching of evolution in all schools? And, finally, what if the majority vote
in favour of authoritarian regimes? This is no idle question, it happened in,
for example, France in 1851 and 1852 (much to Proudhon's disgust).

Perhaps it is not surprising, then, that the right often invoke the _"silent
majority"_ against the progressive minorities seeking change. The term was
popularised (though not first used) by U.S. President Richard Nixon in 1969
when he asked for the support of _"the great silent majority of my fellow
Americans"_, those who felt threatened by attacks on "traditional values"
during the 1960s -- the civil rights, women's and peace movements as well as
student rebellions, the counter-culture, wildcat strikes, and so on. Nixon, it
should be noted, won a landslide victory in the 1972 Presidential election and
took 49 of 50 states. The Thatcher government, likewise, invoked its
democratic credentials (in spite of never receiving an actual majority of
support) when launching state repression against strikes (particularly the
1984-85 miners' strike) and imposing the most draconian anti-union laws in the
Western World. Their trade union "reforms" included forcing a paper ballot of
members before taking strike action, so replacing the mass union meeting with
the atomised democracy of the bourgeois state. Many Tory politicians wish to
go further and impose yet more legislation which would outlaw strikes unless a
majority of trade union members take part in the ballot as well as the
majority voting for strike action (rather than just the majority of those
voting in the ballot) -- in the interests of "democracy", of course, as it
would stop "unrepresentative" minorities disrupting the (non-union) majority.

Needless to say, this is a condition they never suggest for the electing of
politicians for good reason: "democratic" government usually means government
by those elected by a minority of a population. For example, in the 2012
London Mayor election the successful candidate received just over 50% of a 38%
turn-out, meaning that the successful candidate represented a mere 20% of the
city's population. It should also be stressed that this minority of voters did
not actually make decisions -- that rested in the hands of one person, the
mayor. In other words, power over a city of ten million rested in the hands a
person elected by 20% of those eligible to vote. The same can be said of U.S.
elections, particularly Presidential ones. So democracy can easily mean
government by the largest minority although, in practice, it means government
of the few elected by the largest minority of the minority who bother to vote.
None of which is very democratic and confirms Proudhon's critique that
_"nothing resembles a monarchy more than a **république unitaire**"_. [quoted
by Vincent, **Op. Cit.**, p. 211]

So invoking "democracy" is problematic, given its wide number of uses. At its
most basic, the majority can be wrong (as can be seen from the numerous
crooks, incompetents, authoritarians and demagogues who have managed to win
the popular vote). The aim, of course, is to change the views of the majority
but that cannot be done by simply obeying its unjust opinions but rather
challenging them by direct action -- or _"ignoring"_ them to use McNally's
term. As we note in [section H.2.11](secH2.md#sech211), all progressive
movements -- whether trade unionism, civil rights activism, feminism and gay
rights -- started out as minorities (and sometimes remained so!) but managed,
by direct action and protest (i.e., ignoring the wishes of the majority) to
change perspectives and make society more freedom and just (see Kropotkin's
essay _"Revolutionary Minorities"_ in **Words of a Rebel** for further
discussion). Malatesta put it well:

> _"We do not recognise the right of the majority to impose the law on the
minority, even if the will of the majority in somewhat complicated issues
could really be ascertained. The fact of having the majority on one's side
does not in any way prove that one must be right. Indeed, humanity has always
advanced through the initiative and efforts of individuals and minorities . .
. [W]e are even more opposed to domination of the majority by a minority. It
would be absurd to maintain that one is right because one is in a minority . .
. [I]t is not a question of being right or wrong; it is a question of freedom,
freedom for all, freedom for each individual so long as he does not violate
the equal freedom of others . . . it is necessary that majority and minority
should succeed in living together peacefully and profitably by mutual
agreement and compromise, by the intelligent recognition of the practical
necessities of communal life and of the usefulness of concessions which
circumstances make necessary."_ [**Errico Malatesta: His Life and Ideas**, p.
72]

So, yes, anarchists **do** defend the liberty of individuals to rebel against
the decisions of collective groups (we should point out that Marxists usually
use such expressions as a euphemism for the state, but here we will take it at
face value). This is for two very good reasons. Firstly, the majority is not
always right. Secondly, simply because progress is guaranteed by individual
liberty -- by **dissent.** That is what McNally is attacking here -- the right
of individuals and groups to dissent, to express themselves and live their own
lives. As we argue in [section A.2.11](secA2.md#seca211), most anarchists
are in favour of direct democracy in free associations. However, we agree with
Carole Pateman when she argues:

> _"The essence of liberal social contract theory is that individuals ought to
promise to, or enter an agreement to, obey representatives, to whom they have
alienated their right to make political decisions . . . Promising . . . is an
expression of individual freedom and equality, yet commits individuals for the
future. Promising also implies that individuals are capable of independent
judgement and rational deliberation, and of evaluating and changing their own
actions and relationships; promises may sometimes justifiably be broken.
However, to promise to obey is to deny or limit, to a greater or lesser
degree, individuals' freedom and equality and their ability to exercise these
capacities. To promise to obey is to state that, in certain areas, the person
making the promise is no longer free to exercise her capacities and decide
upon her own actions, and is no longer equal, but subordinate."_ [**The
Problem of Political Obligation**, p. 19]

She indicates an obvious truth which McNally ignores:

> _"Even if it is impossible to be unjust to myself, I do not vote for myself
alone, but along with everyone else. Questions about injustice are always
appropriate in political life, for there is no guarantee that participatory
voting will actually result in decisions in accord with the principles of
political morality."_ [**Op. Cit.**, p. 160]

Thus, for anarchists, a democracy which does not involve individual rights to
dissent, to disagree and to practice civil disobedience would violate freedom
and equality, the very values McNally claims to be at the heart of Marxism. He
is essentially arguing that the minority becomes the slave of the majority --
with no right of dissent when the majority is wrong or being unjust and
restricting the freedom democracy is meant to be based upon, reflect and
defend. In effect, he wishes the minority to be subordinate, not equal, to the
majority. Anarchists, in contrast, because we support self-management also
recognise the importance of dissent and individuality -- in essence, because
we are in favour of self-management ("democracy" does not do the concept
justice) we also favour the individual freedom that is its rationale. We
support the liberty of private individuals because we believe in self-
management ("democracy") so passionately.

Then there is the question of **which** _"collective groups"_ make the
democratic decision. This is a key issue for anyone concerned about freedom
for its answer determines what kind of democracy we are talking about -- a
meaningful one which empowers all or a formal one which restricts what
democracy is meant to be about?

For example, during debates on Scottish Independence some commentators suggest
that limiting the vote on whether Scotland should withdraw from the UK to just
those who lived there was "undemocratic" as the consequences impacted on those
who lived in England, Wales and Northern Ireland. However, expanding the vote
would have meant that the democratic decision of those in Scotland -- a small
minority of the total population of the UK -- would have been irrelevant to
the final decision. This can be generalised to all nation states which contain
distinct cultural or ethic groupings within it. Can it be considered
"democratic" to favour _"collective groups"_ which ensure the marginalisation
of minorities who wish to govern themselves?

This applies with equal force to the labour movement. In terms of strike
action, which _"collective groups"_ get to decide? Is it a sub-unit of a union
branch (for example, IT staff within a University facing a restructuring), the
branch (in which the IT staff may be a minority), the region or the national
union. The strike decision would impact on all these levels but McNally's
position gives no guidance for what is the correct level. Is it "democratic"
if the sub-unit of the branch has to face redundancies because the majority of
the branch does not support strike action? Is it "democratic" if the local
branch cannot strike because the majority of the national union considers it
harmful to the union as a whole?

This is no academic discussion as the answer has a significant impact on the
evolution of the labour movement. In the Marxist-influenced German unions, the
prejudice for centralisation meant that the whole union (in practice, a few
leaders at the top) was considered the key collective group and so _"every
local strike had first to be approved by the Central, which was often hundreds
of miles away and was not usually in a position to pass a correct judgement on
the local conditions"_ which lead to _"inertia of the apparatus of the
organisation [and] renders a quick attack quite impossible"_. The unions were
_"condemned . . . to stagnation"_ and the structure _"kills the spirit and the
vital initiative of its members."_ This _"turned over the affairs of everybody
in a lump to a small minority"_ and resulted in _"barren official routine"_
which _"crushed individual conviction, kills all personal initiative by
lifeless discipline and bureaucratic ossification and permits no independent
action."_ [**Anarcho-Syndicalism**, p. 61 and p. 60]

The anarchist position is clear -- the appropriate group makes the decision.
Thus federalism allows _"free combination from below upward, putting the right
of self-determination of every member above everything else and recognising
only the organic agreement of all on the basis of like interests and common
convictions."_ [Rocker, **Op. Cit.**, p. 60] Unsurprisingly, then, we discover
that the most militant British union was that of the miners which had, due to
syndicalist influence, a decentralised, federal structure based on autonomous
branches. And, as Rocker notes, while the German unions made no attempt to
resist the Nazi seizure of power, the anarcho-syndicalist CNT rose in
insurrection and stopped Franco across two-thirds of Spain in 1936.

Simply put, Marxism (as McNally presents it here) flies in the face of how
societies change and develop. New ideas start with individuals and minorities
and spread by argument and by force of example. McNally is urging the end of
the free expression of individuality. For example, who would seriously defend
a society that "democratically" decided that, say, homosexuals should not be
allowed the freedom to associate? Or that inter-racial marriage was against
"Natural Law"? Or that trade unions and strikes should be outlawed as the acts
of "selfish" minorities? Or that socialists were dangerous subversives and
should be banned? He would, we hope (like all sane people), recognise the
rights of individuals to rebel against the majority when the majority violate
the spirit of association, the spirit of freedom and equality which should
give democracy its rationale. However, if he did then he would have to also
admit the correctness of the anarchist position.

So McNally fails to understand the rationale for democratic decision making --
it is not based on the idea that the majority is always right but that
individual freedom requires democracy to express and defend itself. By placing
the collective above the individual, McNally undermines democracy and replaces
it with little more than tyranny by the majority -- or, more likely, those who
claim to represent the majority. It also, ironically, places him on the wrong
side within his own political tradition.

If we take McNally's comments seriously then we must conclude that those
members of the German Social Democratic Party who opposed their party's role
in supporting the First World War were acting inappropriately. Rather than
express their opposition to the war and act to stop it, according to McNally's
"logic", they should have remained in their party (after all, **leaving** the
party meant ignoring the democratic decision of a collective group), accepted
the democratic decision of the collective and supported the Imperialist
slaughter in the name of party democracy. Indeed, the minority of anti-war
Social-Democratic representatives in the German Parliament did precisely that,
refusing to vote against war credits in 1914 in the name of party discipline
(presumably because, as good Marxists, they thought only _"anarchists defend
the 'liberty' of the private individual against the democratically made
decisions of collective groups"_, to use McNally's words). It took until 1915
for Karl Liebknecht to do the right thing. If quoting Trotsky is not too out
of place: _"Do not fear to remain in a minority -- even a minority of one,
like Liebknecht's one against a hundred and ten"_. [**History of the Russian
Revolution**, vol. 1, p. 293] Common sense as well as political principle
indicates that Liebknecht's (belated) defence of socialist internationalism
against the democratically made decision of the Social-Democratic
representatives (and wider party) was right -- and his principled dissent
helped turn the tide against the jingoism of the majority.

Another obvious example is provided by Lenin who, just before the party's
seizure of power in 1917, was so frustrated with the conservativism of his own
party's central committee that he, _"by way of protest resigns from the
Central Committee"_ after his _"furious criticism"_ had no effect. Rather than
abide by the rules of his own party and the majority of its governing body
_"by announcing his resignation . . . Lenin obviously wanted to make it
possible to free himself in case of need from internal discipline of the
Central Committee"_. This meant the _"withdrawing completely beyond the limits
of party legality"_ and the threat of resigning gave him _"greater freedom to
develop his offensive along internal lines."_ [**Op. Cit.**, vol. 3, p. 131]
Perhaps McNally is of the opinion that a private individual should not ignore
the democratically made decisions of collective bodies -- unless the
individual in question is Lenin!

We are sure that McNally would reject the notion that Liebknecht and Lenin
were wrong -- in **these** cases the rights of minorities (even of one) take
precedence over the _"democratic decisions of collectives."_ This is because
the majority is not always right and it is only through the dissent of
individuals and minorities that the opinion of the majority can be moved
towards the right one. Thus his comments are fallacious.

Progress is determined by those who dissent and rebel against the status quo
and the decisions of the majority. That is why anarchists support the right of
dissent in self-managed groups -- in fact, dissent, refusal, revolt by
individuals and minorities is a key aspect of self-management. Given that
Leninists do not support self-management (rather they, at best, support the
Lockean notion of electing a government as being "democracy") it is hardly
surprising they, like Locke, view dissent as a danger and something to
denounce. Anarchists, on the other hand, recognising that self-management's
(i.e. direct democracy's) rationale and base is in individual freedom,
recognise and support the rights of individuals to rebel against what they
consider as unjust impositions (hence our recognition of the possibility of
"the tyranny of the majority" -- see [section I.5.6](secI5.md#seci56)). As
history shows, the anarchist position is the correct one -- without rebellion,
numerous minorities would never have improved their position. Indeed,
McNally's comments is just a reflection of the standard capitalist diatribe
against strikers and protestors -- they do not need to protest, for they live
in a "democracy."

So, yes, anarchists do support individual freedom to resist even
democratically made decisions simply because democracy **has to be** based on
individual liberty. Without the right of dissent, democracy becomes a joke and
little more than a numerical justification for tyranny (usually of the few who
make up the so-called "democratically elected" government). Thus McNally's
latter claim that the _"challenge is to restore to socialism its democratic
essence, its passionate concern with human freedom"_ seems farcical -- after
all, he has just admitted that Marxism aims to eliminate individual freedom in
favour of _"collective groups"_ (i.e. the government). Unless of course he
means freedom for the abstraction "humanity" rather than concrete freedom of
the individual to govern themselves as individuals and as part of freely
joined self-managed associations? For those who really seek to restore to
socialism its passionate concern for freedom the way it clear -- anarchism.
Hence Murray Bookchin's comments:

> _"Here is the nub of the problem [with] . . . Marxism . . . its perspectives
are orientated not towards concrete, existential freedom, but towards an
abstract freedom -- freedom for 'Society', for the 'Proletariat', for
**categories** rather than for people."_ [**Post Scarcity Anarchism**, p. 148]

Anarchism, on the other hand, favours freedom for people and that implies two
things -- individual freedom and self-management (direct democracy) in free
associations. Any form of "democracy" not based on individual freedom would be
so contradictory as to be useless as a means to human freedom (and vice versa,
any form of "individual freedom" -- such a liberalism -- which denies self-
management would be little more than a justification for minority rule and a
denial of human freedom). Ultimately, McNally's attack on anarchism fails
simply because the majority is not always right and dissent a key to progress.
That he forgets these basic facts of life indicates the depths to which
Marxists will sink to distort the truth about anarchism.

Not that those in the Bolshevik tradition have any problem with individuals
ignoring the democratic decisions of collective groups. The Bolsheviks were
very happy to let individuals ignore and revoke the democratic decisions of
collective groups -- **as long as the individuals in question were the leaders
of the Bolshevik Party**. As the examples we provide later (in [section
8](append31.md#app8)) indicate, leading lights in the Leninist tradition
happily placed the rights of the party before the rights of working people to
decide their own fate. Thus McNally comments are strange in the extreme. Both
anarchists and Leninists share a belief that individuals can and should have
the right to ignore decisions made by groups. However, Leninists seem to think
only the government and leadership of the Party should have that right while
anarchists think **all** should. Unlike the egalitarian support for freedom
and dissent for all anarchists favour, Leninists have an elitist support for
the right of those in power to ignore the wishes of those they govern. Thus
the history of Marxists parties in power expose McNally as a hypocrite and as
we argue in [section 14](append31.md#app14), Leninist ideology provides the
rationale for such action. Thus his attempt to portray anarchism as "anti-
democratic" is somewhat ironic.

McNally states that anarchists _"oppose even the most democratic forms of
collective organisation of social life. As the Canadian anarchist writer
George Woodcock explains: 'Even were democracy possible, the anarchist would
still not support it . . . Anarchists do not advocate political freedom. What
they advocate is freedom from politics . . .' That is to say, anarchists
reject any decision-making process in which the majority of people
democratically determine the policies they will support."_

It is perhaps understandable that McNally fails to provide a reference for
Woodcock's quote given that the two parts come from different chapters of the
pamphlet **Anarchy or Chaos**. The first part (_"Even were democracy possible,
the anarchist would still not support it"_) appears in chapter 3 on page 20
while the second (_"Anarchists do not advocate political freedom. What they
advocate is freedom from politics"_) comes from chapter 15, page 108. In other
words, McNally skips most of the pamphlet and ignores such trivial discussions
as anarchist support for organisation and so collective decision making, the
links between anarchism and syndicalism (including a chapter explaining
syndicalist ideas), revolutionary anarchist support for collective property in
the means of production and products (libertarian communism) as well as what
was meant by _"political freedom"_ and _"democracy"_.

It is useful, then, to present what Woodcock **actually** argued in order to
understand what anarchism stands for. First, it should be stressed that
Woodcock is very specific about what he meant by democracy: _"for democracy
puts forward the will of the majority as the supreme law, and declares that
society must be governed, and the individual, whether he agrees or not, be
coerced by that will."_ Thus he is not discussing democratic decision making
within free associations but rather the majority passing laws which all must
obey. As indicated above, this is not an unproblematic situation. Woodcock
indicates this by noting the _"laws against bigamy, abortion, homosexual
practices, transvestism, and other [so-called] sexual deviations, as well as
the semi-official persecution of the unmarried mother and the bastard child,
protect the institution of the family"_. Thus _"laws protecting the state [or
the wishes of the majority] find their way into every sphere of life, and
involve the prohibition of activities that, at first consideration, would
appear to have no bearing on the social structure."_ [**Op. Cit.**, p. 20 and
p. 107]

So it is essential to remember that democracy and freedom need not go hand-in-
hand -- majorities can, and do, restrict the freedom of individuals in
repressive and unjust ways. So while democracy is a necessary condition for
freedom it is not sufficient for, ultimately, the defining feature of
democracy is **not** that the majority is always right but rather that a
ruling minority cannot be trusted to not abuse its position and power. This is
why Woodcock states _"Anarchists seek neither the good of a minority, nor the
good of the majority, but the good of all."_ He also notes that in so-called
democracies it is usually the handful of people who make up the
"democratically elected" government who make the decisions and so it is _"not
even of the majority [who rule] but of the privileged few who forms its ruling
class"_. [**Op. Cit.**, p. 20] This awareness informs his comments on
political freedom which McNally shamefully ignores:

> _"Political freedom the right to vote, trial by jury, freedom of speech and
press -- does not constitute real freedom. Indeed it masks the unfree nature
of the society from which it springs. The right to vote means the right to
choose whether one will have a brewer or a lawyer for a master. It does not
mean the right to do without a master. Trial by jury means the right to be
judged by a handful of petty tradesmen, in accordance with the laws of a
society based on property and class . . . Political freedom in a class society
is virtually meaningless . . . it is strictly limited in the interests of the
controlling class, and its availability is in relation to the class and
economic position of the man concerned . . . Democratic freedoms, then, are
relative to wealth. But this is not the full measure of the relationship. In
reality the rich enjoy a far greater freedom than that . . . In a class
society the ruling class are always free owing to their control of the means
of production, of the money that in an acquisitive society is the way to all
enjoyment. The ruled are not free because lack of control of production, and
the benefits of money, liberal education, etc., proceeding there from . . .
Moreover, political freedom in a class society (and all political societies
are by definition class societies), is relative to the security of that
society. The ruling class give just so much political freedom as it is
worthwhile and possible to give to keep the people out of mischief . . .
Political freedom, at its best, can only be limited, as it maintains the power
of property, which, by conferring the right of exploitation, limits the
freedom of the exploited, who are the majority of the population . . ._

> _"Political freedom is thus, in fact, an ingenious delusion, by which the
governing classes give the people the comforting belief that they themselves
have made the chains that bind them and that for this reason the chains are
necessary and good. It gives men certain liberties that the ruling classes
find it wise to concede as a cheap way of buying security, but its very
retention of a political system, which means government, which means coercion,
must in the end destroy political freedom itself._

> _"Anarchists do not advocate political freedom. What they advocate is
freedom from politics, freedom from the institution of government, freedom
from coercion, freedom from the law's interference in the lives of individual
men and women, freedom from economic domination and inequality . . . Only a
society based on control from above has need of coercion. A society based on
co-operation can do without oppression and restriction because it is based on
the voluntary agreement between its members."_ [**Op. Cit.** pp. 105-8]

Ultimately, if you define political freedom as the freedom to elect a
government then, obviously, anarchists do not aim for it because we aim to end
all governments! As is clear from the pamphlet McNally shamefully rips quotes
from. The dishonesty is clear.

Given McNally's assertions about anarchism opposing collective property and
being undemocratic, it is useful to also quote Woodcock's words on what
anarchism is based on and what it logically implies. He stresses that _"few
anarchists contend that absolute individual freedom is possible, or, indeed,
desirable . . . man is a social being, depending for his well-being on working
and living together in society . . . The freedom anarchists seek, then, is a
reciprocal freedom, a freedom of men and women recognising each other's
rights, a freedom based on justice."_ [**Op. Cit.**, p. 105] Therefore:

> _"Anarchism . . . is based on the concepts of freedom and justice, justice
being that reciprocity of freedom without which no real individual freedom is
possible. The social principles that follow from these concepts are mutual
aid, or co-operation, and communism, or common ownership of the means of
production . . . In the anarchist view these principles are expressed
concretely in the administration of economic and functional affairs by
voluntary associations of the workers for the purpose of running the factories
and the farms and providing the necessary social services such as posts,
drainage, roads, etc. Each industry would be administered by its own workers
who are the most competent people for that purpose . . . who, having expert
knowledge of their professions, are obviously better fitted to do this than
politicians chosen according to the methods of parliamentary democracy."_
[**Op. Cit.**, p. 91]

The means used to create such a society would be _"prosecuting the economic
struggle . . . an organisation on an economic basis which will embrace all the
workers, according to their industries and workplaces . . . The syndicate
[union], organised and governed by the workers themselves . . . [also]
contain[s] the germ of the functional organisation upon which the new society
can be built after the revolution."_. Anarchists wish _"that the people
themselves take their destiny into their own hands and carry through the
social revolution."_ [**Op. Cit.**, p. 89]

All of which, to state the obvious, is at odds with McNally's claims about
anarchism.

To summarise: Anarchists are not opposed to people in free associations
democratically determining the policies they will support (see sections
[I.3.1](secI3.md#seci31) and [I.5.1](secI5.md#seci51) for more details on
this). The minority can then decide to abide by the decision, protest against
it or, if all else fails, to leave the association if they cannot tolerate the
decisions being made. What we **do** oppose is the assumption that the
majority is always right and that (non-repressive or non-oppressive)
minorities should submit to the decisions of the majority no matter how wrong
they are. We feel that history is on our side on this one -- it is only by the
freedom to dissent, by the direct action of minorities to defend and extent
their freedoms that society progresses. We also feel that theory is on our
side -- majority rule without individual and minority rights is a violation of
the principle of freedom and equality which democracy is said to be built on.
Democracy should be an expression of individual liberty but in McNally's hands
it is turned into bourgeois liberalism. Little wonder Marxism has continually
failed to produce a free society. It has no conception of the relationship of
individual freedom to democracy and vice versa.

Finally, we must point out a slight irony in McNally's claim, namely that
Marxists usually claim that they seek a society similar to that anarchists
seek but have different means to achieve it. In the words of Marx:

> _"What all socialists understand by anarchy is this: once the aim of the
proletarian movement, the abolition of classes, has been attained, the power
of the State . . . disappears, and the functions of government are transformed
into simple administrative functions."_ [Marx, Engels and Lenin, **Anarchism
and Anarcho-Syndicalism**, p. 76]

Or, as the **Communist Manifesto** put it, _"the free development of each is
the condition for the free development of all"_ [**The Marx-Engels Reader**,
p. 491] So, Marxists and anarchists seek the same society, one of individual
freedom which means that McNally's comments about anarchism also apply (once
the state "withers away", which it never will) to Marxism. But, of course,
McNally fails to mention this aspect of Marxism and its conflict with
anarchism -- but, then, he fails to discuss what anarchism actually stands for
nor does he present an accurate account of its views of democracy and
democratic decision making.

## 8\. Are Leninists in favour of democracy?

McNally's attack on anarchism for being anti-democratic, authoritarian and
elitist is somewhat ironic given that the Leninist tradition he places himself
in **did** destroy democracy during the Russian Revolution -- whether in the
soviet, the workplace, the union or the military -- and replaced it with party
dictatorship. This means that his attack on anarchism can be turned back on
his own politics, with much more justification and evidence.

We need to understand the importance of comparing the rhetoric of Bolshevism
to its reality as we can have repeated pronouncements about "democracy" made
while, at the same time, the necessity of party dictatorship is both being
practised **and** advocated. Thus Lenin repeatedly contrasted the higher form
of democracy expressed by the soviets to bourgeois democracy. In his in 1918
polemic against leading Social-Democrat Karl Kautsky who was accusing the
Bolsheviks of being undemocratic, Lenin argued that the _"only view that
corresponds to Marxism"_ was expounded by Plekhanov (the father of Russian
Marxism) at the Second Congress of the Russian Social Democratic Party in
1903, namely _"in the revolution the proletariat would, if necessary,
disenfranchise the capitalists and **disperse any parliament** that was found
to be counter-revolutionary."_ [**Collected Works**, vol. 28, p. 280] Which
raises the obvious question, found to be counter-revolutionary by whom? The
proletariat? No, according to Plekhanov it was **the party**:

> _"Every democratic principle must be considered not by itself, abstractly,
but in relation to . . . the success of the revolution [as this] is the
highest law. And if the success of the revolution demands a temporary
limitation on the working of this or that democratic principle, then it would
be criminal to refrain from such a limitation . . . the principle of universal
suffrage must be considered from the point of view of what I have designated
the fundamental principle of democracy. It is hypothetically possible that we
might . . . speak out against universal suffrage . . . If in a burst of
revolutionary enthusiasm the people chose a very fine parliament then we would
be bound to make it a **long parliament**; and if the elections turned out
unsuccessfully, then we would have to try to disperse it._ [quoted by Samuel
H. Baron, **Plekhanov: The Father of Russian Marxism**, p. 242]

As we will discover, the dispersing of elected bodies by the party was not
limited to bourgeois Parliaments: soviets were also subject to this policy.
Perhaps this is unsurprising, given that before seizing power Lenin had
repeatedly equated the power of the Bolsheviks with that of the proletariat.
Thus _"Bolshevik power"_ was _"one and the same thing"_ as _"proletarian
revolutionary power"_ and so the Second All-Russian Congress _"gave a majority
to the Bolshevik Party and put it in power."_ [**The Lenin Anthology**, p. 413
and p. 419] While problematic (it substitutes the party for the class), it
could be argued that as the party was supported by the majority of workers
(but not peasants) then the Bolshevik government was democratic. Which is
true, in the limited bourgeois sense. The question is what would happen if the
workers turned against the party -- would it give up its power as required by
a movement committed to democracy? Unfortunately for McNally, the answer was:
no.

Before discussing this, we must present some context and discuss the Bolshevik
regime from the democratic perspective of one-person, one-vote. **Before**
seizing power, Lenin protested that the Bolsheviks _"must pass a resolution
demanding **equal** suffrage (both in the Soviets and at trade union
congresses), branding the slightest departure from equality as a **fraud** . .
. We cannot tolerate a **fraud** of democracy if we call ourselves
'democrats'. We are not democrats but unprincipled people if we tolerate
this!!"_ [**Collected Works**, vol. 25, p. 304] After winning around 25% of
the votes in the elections to the Constituent Assembly he was happy with a
Soviet Constitution which saw the All-Russian Congress of Soviets being
composed of representatives of urban soviets (one delegate for 25,000 voters)
and of representatives of the rural congresses of soviets (one delegate for
125,000 inhabitants). In other words, a worker's vote was 5 times more
important than a peasant's vote. That this ensured a Bolshevik majority in the
Third and Fourth All-Russian Congresses may explain this embrace of
**unequal** suffrage in 1918 after the votes in the Constituent Assembly had
been counted.

Given that the Bolsheviks disbanded the Constituent Assembly in spite of it
being elected by universal suffrage (i.e., by democracy) McNally would,
undoubtedly, argue -- as Lenin did -- that soviet democracy was much superior.
Ignoring the awkward issue of unequal suffrage between workers and peasants,
the fact is that the Bolsheviks also disbanded soviets which elected non-
Bolshevik majorities. Martov, the leader of the left-Mensheviks, recounted in
June 1918 how in those _"places where we were in the majority, the soviets
will be liquidated"._ When _"workers demanded new elections"_ the demands were
_"stubbornly resisted"_ and the issue _"escalated to workers' strikes and the
suppression of workers' demonstrations by armed forces"_. If the protests
succeeded, then elections resulted in _"a majority to the Mensheviks and SRs"_
and in those cases Bolshevik Military Revolutionary Councils ensured _"the
soviets were disbanded by armed force or the opposition delegates were
**expelled** as 'counter-revolutionaries' from the soviets"_ (although
_"Bolshevik investigators themselves could not succeed in implicating even one
Menshevik in the conspiracy trials"_). The disbanding of soviets was _"applied
to the **uzed** congresses of peasant soviets."_ [_"Iulii Martov's Letter to
A.N. Stein"_, pp. 78-82, **The Structure of Soviet History**, Ronald Grigor
Suny (ed.), p. 78] Martov gave amongst many the example of Tula and a leading
Bolshevik there informed his Party's Central Committee in early 1918 about the
means being used there:

> _"After the transfer of power to the soviet, a rapid about-face began in the
mood of the workers. The Bolshevik deputies began to be recalled one after
another, and soon the general situation took on a rather unhappy appearance.
Despite the fact that there was a schism among the SRs, and the Left SRs were
with us, our situation became shakier with each passing day. We were forced to
block new elections to the soviet and even not to recognise them where they
had taken place not in our favour."_ [quoted by Scott Smith, _"The Socialists-
Revolutionaries and the Dilemma of Civil War"_, pp. 83-104, **The Bolsheviks
In Russian Society**, Vladimir N. Brovkin (ed.), p. 87]

_"The sum of this evidence from around the country,"_ summarises one
historian, _"makes clear that the majority of Russian workers were hostile to
the Bolsheviks by the spring of 1918 . . . the Bolsheviks simply dissolved
opposition-controlled soviets, disregarded workers' opinions, and cracked down
brutally on such manifestations of discontent as strikes."_ [Smith, **Op.
Cit.**, p. 94] This meant disbanding soviets which were elected with the wrong
majority and so in response to the _"great Bolshevik losses in the soviet
elections"_ during the spring and summer of 1918 _"Bolshevik armed force
usually overthrew the results of these provincial elections."_ For example, in
the city of Izhevsk in _"the May election [to the soviet] the Mensheviks and
SRs won a majority"_ and the following month _"these two parties also won a
majority of the executive committee of the soviet. At this point, the local
Bolshevik leadership refused to give up power"_ and by the use of the military
_"abrogated the results of the May and June elections and arrested the SR and
Menshevik members of the soviet and its executive committee."_ [Samuel Farber,
**Before Stalinism**, pp. 23-4]

As we summarise in [section H.6.1](secH6.md#sech61), the Bolsheviks applied
many tactics to secure their power: soviet elections were delayed, the soviets
themselves were packed with their representatives to secure their majority (so
making direct election from the workplace irrelevant) and, when all else
failed, the soviets themselves were simply, as noted, disbanded. This applied
at the national level as well, and _"electoral fraud gave the Bolsheviks a
huge majority of congress delegates"_ for the fifth All-Russian Soviet
Congress in July 1918. The _"number of legitimately elected Left SR delegates
was roughly equal to that of the Bolsheviks."_ The Left-SRs expected a
majority but did not include _"roughly 399 Bolsheviks delegates whose right to
be seated was challenged by the Left SR minority in the congress's credentials
commission."_ Without these dubious delegates, the Left SRs and SR Maximalists
would have outnumbered the Bolsheviks by around 30 delegates. This ensured
_"the Bolshevik's successful fabrication of a large majority in the Fifth All-
Russian Congress of Soviets."_ [Alexander Rabinowitch, **The Bolsheviks in
Power**, p. 396, p. 288, p. 442 and p. 308]

This was reflected in Lenin's 1917 argument that the _"Bolsheviks have no
right to await the Congress of Soviets. They ought to seize the power **right
now**"_ [quoted by Trotsky, **The History of the Russian Revolution**, vol. 3,
pp. 132-2] The important thing was party power and the soviets were seen as
only a means to that end and so perhaps their fate once the Bolsheviks had
reached their goal is unsurprising. Hence we see Lenin, in his polemic against
Kautsky, pointing with no apparent concerns to the fact that _"97 per cent of
the total number of delegates [to the Sixth All-Russian Soviet Congress] were
Bolsheviks"_ as an example of his party's popular support! [**Collected
Works**, vol. 28, p. 303] It should be noted that the delegates to the
congress were elected not by workers and peasants but rather by the
appropriate soviet body below it. In other words, Bolshevik gerrymandered and
packed soviets elected Bolsheviks to the national congress.

Perhaps unsurprisingly, given the reality of their regime, Bolshevik rhetoric
started to change. By the end of 1918 the necessity of party dictatorship
started to appear in party material and, as Victor Serge noted in the 1930s,
_"the degeneration of Bolshevism"_ was apparent by that time _"since at the
start of 1919 I was horrified to read an article by Zinoviev . . . on the
monopoly of the party in power"_. [**The Serge-Trotsky Papers**, p. 188] It
must be stressed that Serge's horror was well hidden and, as noted in [section
H.1.2](secH1.md#sech12) he joined the Bolsheviks and publicly defended this
monopoly of power as a necessity of revolution. Lenin admitted the reality in
1919:

> _"When we are reproached with having established a dictatorship of one party
and . . . . a united Socialist front is proposed, we say, 'Yes, it is a
dictatorship of one party! This is what we stand for and we shall not shift
from that position . . .'"_ [**Op. Cit.**, vol. 29, p. 535]

Not only did the Bolsheviks not shift from that position, they recommended
this position to the world revolutionary movement at the Second Congress of
the Second International in 1920. In the words of Zinoviev:

> _"Today, people like Kautsky come along and say that in Russia you do not
have the dictatorship of the working class but the dictatorship of the party.
They think this is a reproach against us. Not in the least! We have a
dictatorship of the working class and that is precisely why we also have a
dictatorship of the Communist Party. The dictatorship of the Communist Party
is only a function, an attribute, an expression of the dictatorship of the
working class . . . the dictatorship of the proletariat is at the same time
the dictatorship of the Communist Party."_ [**Proceedings and Documents of the
Second Congress 1920**, vol. 1, pp. 151-2]

_"We must have a state organisation"_ he argued, _"and only the party can
direct it, because a state political organisation is one that encompasses the
best working-class elements of the entire country."_ [**Op. Cit.**, p. 154]
Elsewhere that year he argued that _"soviet rule in Russia could not have been
maintained for three years -- not even three weeks -- without the iron
dictatorship of the Communist Party. Any class conscious worker must
understand that the dictatorship of the working class can be achieved only by
the dictatorship of its vanguard, i.e., by the Communist Party . . . All
questions of economic reconstruction, military organisation, education, food
supply -- all these questions, on which the fate of the proletarian revolution
depends absolutely, are decided in Russia before all other matters and mostly
in the framework of the party organisations . . . Control by the party over
soviet organs, over the trade unions, is the single durable guarantee that any
measures taken will serve not special interests, but the interests of the
entire proletariat."_ [quoted by Oskar Anweiler, **The Soviets**, pp. 239-40]
In short: _"The chief conclusion of the proletarian revolution is the need for
an iron, organised and monolithic Party."_ [Zinoviev, quoted by Robert
Service, **The Bolshevik Party in Revolution**, p. 144] Lenin dismissed the
notion that workers could govern themselves:

> _"In the transition to socialism the dictatorship of the proletariat is
inevitable, but it is not exercised by an organisation which takes in all
industrial workers . . . What happens is that the Party, shall we say, absorbs
the vanguard of the proletariat, and this vanguard exercises the dictatorship
of the proletariat . . . the dictatorship of the proletariat cannot be
exercised through an organisation embracing the whole of the class, because in
all capitalist countries (and not only over here, in one of the most backward)
the proletariat is still so divided, so degraded, and so corrupted in parts .
. . that an organisation taking in the whole proletariat cannot directly
exercise proletarian dictatorship. It can be exercised only by a vanguard . .
. Such is the basic mechanism of the dictatorship of the proletariat, and the
essentials of transition from capitalism to communism . . . for the
dictatorship of the proletariat cannot be exercised by a mass proletarian
organisation."_ [**Collected Works**, vol. 32, pp. 20-1]

This, of course, did not stop the Bolsheviks also claiming their regime was
far more democratic than any other. In 1920, Zinoviev as head of the Communist
International wrote a letter to the **Industrial Workers of the World**, a
revolutionary labour union, which stated that the _"Russian Soviet Republic .
. . is the most highly centralised government that exists. It is also the most
democratic government in history. For all the organs of government are in
constant touch with the working masses, and constantly sensitive to their
will."_ [**Proceedings and Documents of the Second Congress 1920**, vol. 2, p.
928] Lenin, in his diatribe against Left-Wing Communism made a similar claim
and proclaimed the soviets _"**democratic** institutions, the like of which
even the best democratic republics of the bourgeois have never known"_ while
also suggesting that it was _"ridiculously absurd, and stupid"_ to make _"a
contrast, **in general**, between the dictatorship of the masses and the
dictatorship of the leaders."_ He also pointed to _"non-Party workers' and
peasants' conferences"_ as means by which the party secured its rule and so
the Bolsheviks would have to _"support, develop and extend"_ non-Party
conferences _"to be able to observe the temper of the masses, come closer to
them, meet their requirements, promote the best among them to state posts"_.
[**The Lenin Anthology**, p. 573] Yet **if** the soviets were so democratic,
then why were the non-Party Congresses needed at all? Perhaps because _"the
dictatorship of the leaders"_ is **not** the same as _"dictatorship of the
masses"_ and so the Soviets were irrelevant due to the party dictatorship?

Perhaps unsurprisingly given the fate of the soviets in 1918, the Bolsheviks
disbanded these "non-Party" conferences because _"[d]uring the disturbances"_
of late 1920, _"they provided an effective platform for criticism of Bolshevik
policies."_ Their frequency was decreased and they _"were discontinued soon
afterward."_ [Richard Sakwa, **Soviet Communists in Power**, p. 203] Lenin
summarised the reasons for this policy:

> _"Non-Party conferences are not a fetish. They are valuable if they help us
to come closer to the impassive masses -- the millions of working people still
outside politics. They are harmful if they provide a platform for the
Mensheviks and Socialist Revolutionaries masquerading as 'non-party' men. They
are helping the mutinies, and the whiteguards. The place for Mensheviks and
Socialist-Revolutionaries, avowed or in non-party guise, is not at a non-Party
conference but in prison . . . We can and must find other methods of testing
the mood of the masses and coming closer to them. We suggest that those who
want to play the parliamentary, constituent assembly and non-Party conference
game, should go abroad . . . "_ [**Op. Cit.**, vol. 32, p. 362]

In other words, the conferences were used by the proletariat to express its
opinions and these were found to be lacking in the eyes of its vanguard. Like
soviet democracy, they threatened the rule of the party and as Lenin suggested
in 1920 _"[w]hoever brings about even the slightest weakening of the iron
discipline of the party of the proletariat (especially during its
dictatorship) is actually aiding the bourgeoisie against the proletariat."_
[**The Lenin Anthology**, p. 570] So any conflict between the vanguard and the
proletariat would, by this logic, necessitates the victory of the former over
the latter -- in the latter's interests, of course. As Trotsky put it in 1921:

> _"The Workers' Opposition has come out with dangerous slogans, making a
fetish of democratic principles! They place the workers' right to elect
representatives above the Party, as if the party were not entitled to assert
its dictatorship even if that dictatorship temporarily clashed with the
passing moods of the workers' democracy. It is necessary to create amongst us
the awareness of the revolutionary birthright of the party, which is obliged
to maintain its dictatorship, regardless of temporary wavering even in the
working classes. This awareness is for us the indispensable element. The
dictatorship does not base itself at every given moment on the formal
principle of a workers' democracy."_ [quoted by Farber, **Op. Cit.**, p. 209]

So, politically, the Bolsheviks systematically disbanded democratic
institutions -- whether bourgeois (the Constituent Assembly) or proletarian
(the soviets and non-Party Conferences). They proclaimed to the world the
necessity of party dictatorship and how mass working class organisations could
not exercise the so-called dictatorship of the proletariat. In March 1923 the
Central Committee of the Communist Party, in a statement issued to mark the
25th anniversary of the founding of the Party, summarised the lessons gained
from the Russian revolution: _"the party of the Bolsheviks proved able to
stand out fearlessly against the vacillations within its own class,
vacillations which, with the slightest weakness in the vanguard, could turn
into an unprecedented defeat for the proletariat."_ Vacillations, of course,
are expressed by workers' democracy. Little wonder the statement rejects it:
_"The dictatorship of the working class finds its expression in the
dictatorship of the party."_ [_"To the Workers of the USSR"_ in G. Zinoviev,
**History of the Bolshevik Party**, p. 213 and p. 214]

Bolshevik authoritarianism, needless to say, was not limited to the political
regime. In the workplace, they replaced workers' economic democracy with _
"one-man management"_ selected from above, by the state. These _"individual
executives"_ would have _"dictatorial powers (or 'unlimited' powers)"_ as
there was _"absolutely **no** contradiction in principle between Soviet
(**that is**, socialist) democracy and the exercise of dictatorial powers by
individuals."_ The applied also at the national level for _"our task is to
study the state capitalism of the Germans, to spare **no effort** in copying
it and not to shrink from adopting **dictatorial** methods to hasten the
copying of it."_ [**Collected Works**, vol. 27, p. 267, p. 268 and p. 340] He
suggested dictatorial power was universal fact of all revolutions:

> _"in the history of revolutionary movements the dictatorship of individuals
was very often the expression, the vehicle, the channel of the dictatorship of
the revolutionary classes has been shown by the irrefutable experience of
history."_ [**Op. Cit.**, p. 267]

It is churlish, but essential, to note that previous revolutionary movements
had transformed one form of class society into another and so we must note, as
well as refuting McNally's claim that Leninism is a democratic tradition,
Lenin's comments display a distinct confusion over the nature of a **social**
revolution (rather than a political one). Yes, **previous** revolutions may
have utilised the dictatorship of individuals but these revolutions have been
revolutions from one class system to another. The "revolutionary" classes in
question were **minority** classes and so elite rule would not in any way
undermine their class nature. Not so with a **socialist** revolution which
must be based on mass participation (in every aspect of society, economic,
political, social) if it is too achieve its goals -- namely a classless
society. Little wonder, with such theoretical confusion, that the Russian
revolution ended in Stalinism -- the means used determined the ends.
Unsurprisingly enough, the Bolshevik imposition of one-management simply
transformed private-capitalism into state-capitalism, that is one form of
class society into another (see [section H.3.13](secH3.md#h313)). After the
end of the Civil War Lenin summarised his position: _"Industry is
indispensable, democracy is not. Industrial democracy breeds some utterly
false ideas."_ [**Op. Cit.**, vol. 32, p. 27]

This system of state-appointed "one-man" managers armed with _"dictatorial"_
powers was not considered as opposed to socialism, as McNally implies. Lenin
stressed in 1919 that the _"organisation of the communist activity of the
proletariat and the entire policy of the Communists have new acquired a final,
lasting form."_ [**Op. Cit.**, vol. 30, p. 144] Moreover, after the end of the
civil war he combated the idea of workers' control as (rightly!) a syndicalist
and anarchist deviation within the party at odds with Marxism:

> _"Syndicalism hands over to the mass of non-Party workers . . . the
management of their industries . . . thereby making the Party superfluous. . .
Why have a Party, if industrial management is to be appointed . . . by trade
unions nine-tenths of whose members are non-Party workers?"_ [**Op. Cit.**,
vol. 32, p. 50]

He went so far as to admit that he thought _"the syndicalist deviation"_
(i.e., giving the proletariat economic democracy, the power to elect their own
workplace managers and economic conferences) _"leads to the collapse of the
dictatorship of the proletariat"_. [**Op. Cit.**, p. 86] This was a theme to
which he repeatedly returned:

> _"Does every worker know how to run the state? . . . this is not true . . .
If we say that it is not the Party but the trade unions that put up the
candidates and administrate, it may sound very democratic . . . It will be
fatal for the dictatorship of the proletariat . . . To govern you need an army
of steeled revolutionary Communists. We have it, and it is called the Party.
All this syndicalist nonsense about mandatory nominations of producers must go
into the wastepaper basket. To proceed on those lines would mean thrusting the
Party aside and making the dictatorship of the proletariat in Russia
impossible."_ [**Op. Cit.**, pp. 61-2]

In short, the economic relations favoured by the Bolsheviks were identical to
that of capitalism except that the boss was replaced by a state-appointed
bureaucrat, private-capitalism by state-capitalism (an awkward fact McNally
cannot bring himself to mention, never mind admit to). _"In the shops where
one-man management (Lenin's own preference) replaced collegial management,"_
notes Diane Koenker, _"workers faced the same kinds of authoritarian
management they thought existed only under capitalism."_ The _"overall
management of industry in 1921 was no more democratic than it had been in
1914; indeed, it was much more highly centralised, hierarchical, and
bureaucratic."_ [**Labour Relations in Socialist Russia**, p. 177 and p. 190]

Needless to say, the Bolsheviks also combated independent trade unions with
the same methods. As one historian summarises, _"Soviets and trade unions with
non-Bolshevik majorities, and there was a definite revival in the electoral
fortunes of the opposition in the spring of 1918, were dispersed"_ and by the
_"beginning of 1920 non-Bolshevik controlled trade union organisations no
longer existed at the national level"_. [Jonathan Aves, _"The Demise of Non-
Bolshevik Trade Unionism in Moscow: 1920-21"_, pp. 101-33, **Revolutionary
Russia**, vol. 2, no. 1, pp. 101-2 and p. 103] By the end of 1920, the
Bolsheviks had broken the both Menshevik-influenced printers and anarchist-
influenced bakers union, with the offices of the former _"occupied by
soldiers. Eleven members of the [union] board where arrested along with
twenty-nine members of the Council of Representatives, factory committees and
ordinary unionists . . . five were also members of the Moscow soviet. After
being held without trial most were sentenced to terms between six months and
two years in prison. The disbandment was approved by the plenum of the Moscow
trade union council"_ which _"also voted to disband the bakers' section. The
leading anarchist members of the section . . . and . . . an SR Maximalist . .
. and two other members . . . were barred from office and arrested to stand
trial."_ [Jonathan Aves, **Workers Against Lenin**, pp. 68-9] In May 1921, to
present another example, the All-Russian Congress of the Metalworkers' Union
met and the _"Central Committee of the [Communist] Party handed down to the
Party faction in the union a list of recommended candidates for **union**
(sic!) leadership. The metalworkers' delegates voted down the list, as did the
Party faction in the union . . . The Central Committee of the Party
disregarded every one of the votes and appointed a Metalworkers' Committee of
its own. So much for 'elected and revocable delegates.' Elected by the union
rank and file and revocable by the Party leadership!"_ [M. Brinton, _"The
Bolsheviks and Workers' Control"_, **For Workers' Power, **, p. 375] The same
year also saw the Bolshevik disperse provincial trade unions conferences in
Vologda and Vitebsk _"because they had anti-communist majorities."_ [Aves,
**Op. Cit.**, p. 176]

A similar onslaught by the party against democracy also occurred in the armed
forces. Trotsky simply abolished the soldier's committees and elected officers
in early 1918, stating that _"the principle of election is politically
purposeless and technically inexpedient, and it has been, in practice,
abolished by decree."_ This destruction of military democracy was compared to
the concurrent push by the Bolsheviks to introduce "one-man" management in
production, as workplace democracy _"is not the last word in the economic
constructive work of the proletariat"_. The _"next step must consist in self-
limitation of the collegiate principle"_ and its replacement by _"[p]olitical
collegiate control by the Soviets"_, i.e. the state control Lenin had
repeatedly advocated in 1917. Moreover _"for executive functions we must
appoint technical specialists."_ He ironically called this the working class
_"throwing off the one-man management principles of its masters of yesterday"_
and failed to recognise it was imposing the one-man management principles of
new masters. As with Lenin, the destruction of workers' power at the point of
production was of little concern for what mattered was that _"with power in
our hands, we, the representatives of the working class"_ would introduce
socialism. [_"Work, Discipline, and Order to save the Socialist Soviet
Republic"_, **How the Revolution Armed**, vol. 1, p. 47, p. 37 and p. 38]

Thus the Bolshevik tradition clearly placed the power of the party above the
ability of working people to elect their own representatives, managers and
officer. And McNally claims that his tradition aims at _"workers' power"_ and
a _"direct and active democracy"_!

Of course McNally tries to blame the destruction of democracy in Russia on the
Civil War: _"By 1920, the very face of Russia had changed. Workers' democracy,
in the meaningful sense of the term, had disappeared -- as had most of the
working class through death or retreat to the countryside."_ This meant the
rise of Stalinism for _"[a]s workers' democracy disintegrated, a new
bureaucracy rose to power."_ However, this is hard to accept, given that the
undermining of democracy began **before** the civil war started and continued
**after** it had finished (for example, the onslaught on soviet democracy and
attempts to impose one-man management in the workplace and armed forces
predate the start of the civil war at the end of May 1918). Moreover, as we
indicate in [section 13](append31.md#app13), the Bolshevik state was marked
by bureaucracy from the start.

Both these developments did not occur by accident, they were due to the nature
of Bolshevik ideology and the kind of centralised structures it favoured.
Trotsky is typical. In April 1918 he argued that once elected the government
was to be given total power to make decisions and appoint people as required
as it is _"better able to judge in the matter than"_ the masses. The sovereign
people were expected to simply obey their public servants until such time as
they _"dismiss that government and appoint another."_ Trotsky raised the
question of whether it was possible for the government to act _"against the
interests of the labouring and peasant masses?"_ And answered no! Yet it is
obvious that Trotsky's claim that _"there can be no antagonism between the
government and the mass of the workers, just as there is no antagonism between
the administration of the union and the general assembly of its members"_ is
just nonsense. [**Leon Trotsky Speaks**, p. 113] The history of trade unionism
is full of examples of committees betraying their membership. Needless to say,
the subsequent history Lenin's government showed that there can be
_"antagonism"_ between rulers and ruled and that appointments are always a key
way to further elite interests. Needless to say, the notion that the party
leaders are _"better able to judge in the matter than"_ has its roots in
Lenin's vanguardism, as discussed in [section 11](append31.md#app11).

McNally's claim that the working class had been destroyed by the civil war is
equally flawed and cannot explain the fact that attempts by working class
people to express themselves were systematically undermined by the Bolshevik
party. Nor does the notion of a _"disappeared"_ working class make much sense
when _"in the early part of 1921, a spontaneous strike movement . . . took
place in the industrial centres of European Russia"_ and strikes involving
around 43 000 per year took place between 1921 and 1925. [Samuel Farber, **Op.
Cit.**, p. 188 and p. 88] As we show in [section H.6.3](secH6.md#sech63),
while the number of workers **did** decrease from 1918 to 1921, there remained
substantial numbers who were able to and did take collective action before,
during and after the civil war. So rather than there being objective reasons
for the lack of democracy under Lenin we can suggest **political** reasons --
the awareness that, given the choice, the Russian working class would have
preferred someone else in power. Indeed, McNally's argument can be traced back
to Lenin who formulated it _"to justify a political clamp-down"_ in the face
of rising working class protest rather than its lack: _"As discontent amongst
workers became more and more difficult to ignore, Lenin . . . began to argue
that the consciousness of the working class had deteriorated . . . workers had
become 'declassed.'"_ However, there _"is little evidence to suggest that the
demands that workers made at the end of 1920 . . . represented a fundamental
change in aspirations since 1917."_ [Aves, **Op. Cit.**, p. 18, p. 90 and p.
91]

Also, we must point out a certain duplicity in McNally's comments that
Stalinism can be explained purely by the terrible civil war Russia
experienced. After all, Lenin himself before seizing power mocked those who
opposed revolution because _"the situation is exceptionally complicated"_ and
argued that _"the development of the revolution itself **always** creates an
**exceptionally** complicated situation"_ and that it was an _"incredibly
complicated and painful process."_ In fact, it was _"the most intense,
furious, desperate class war and civil war. Not a single great revolution in
history has taken place without civil war. And only a 'man in a muffler' can
think that civil war is conceivable without an 'exceptionally complicated
situation.'"_ _"If the situation were not exceptionally complicated there
would be no revolution."_ [**Op. Cit.**, vol. 26, pp. 118-9] Thus McNally's
assertion that for _"the germ cell of socialism to grow [in Russia], it
required several essential ingredients. One was peace. The new workers' state
could not establish a thriving democracy so long as it was forced to raise an
army and wage war to defend itself"_ is simply incredible. It also raises an
important question with regards Leninist ideas: if Bolshevik politics and its
organisational form cannot survive during a period of disruption and
complicated circumstances (i.e., a revolution) then it is clearly a theory to
be avoided at all costs.

The leading Bolsheviks all argued that the specific problems their latter day
followers blame for their authoritarianism were natural results of any
revolution and, consequently, unavoidable. In addition, there is a slight
irony in this standard but flawed excuse for Bolshevik authoritarianism as
Leninists like to suggest that anarchists do not recognise the possibility of
counter-revolution and so reject the idea of defending a revolution. As we
discuss in [section H.2.1](secH2.md#sech21), this is simply untrue -- the
anarchist rejection of "the dictatorship of the proletariat" has nothing to do
with defending revolution. As Bakunin stressed, _"the sole means of opposing
the reactionary forces of the state"_ was the _"organising of the
revolutionary force of the people."_ [**Statism and Anarchy**, p. 156] So
given that Leninists mock anarchists for their supposed naivety over the
dangers of counter-revolution, it seems ironic that McNally uses what he is
supposed to consider an inevitable aspect of revolution to explain (excuse
would be the better word) the degeneration of the Bolshevik revolution. Long
after 1917, Lenin repeated his earlier comments by stating _"history teaches
us that no big question has ever been settled and no revolution accomplished
without a series of wars."_ [**Op. Cit.**, vol. 31, p. 494] He was adamant
that _"were it not for this iron rule of the workers, of this workers'
vanguard, we should not have been able to hold out for two months, let alone
two years"_. [**Op. Cit.**, vol. 30, p. 498]

Simply put, if counter-revolution is considered inevitable by your ideology
then explaining Bolshevik authoritarianism by it is unconvincing --
particularly if that authoritarianism started **before** the start of the
civil war at the end of May 1918 and continued **after** its end. So _"the
effective conclusion of the Civil War at the beginning of 1920 was followed by
a more determined and comprehensive attempt to apply these so-called War
Communism policies rather than their relaxation"_ and so the _"apogee of the
War Communism economy occurred after the Civil War was effectively over."_
With the fighting over Lenin _"forcefully raised the introduction of one-man
management . . . Often commissars fresh from the Red Army were drafted into
management positions in the factories."_ By the autumn of 1920, one-man
management was in 82% of surveyed workplaces. This _"intensification of War
Communism labour policies would not have been a significant development if
they had continued to be applied in the same haphazard manner as in 1919, but
in early 1920 the Communist Party leadership was no longer distracted by the
Civil War from concentrating its thoughts and efforts on the formulation and
implementation of its labour policies."_ While the _" experience of the Civil
War was one factor predisposing communists towards applying military methods"_
to the economy in early 1920, _"ideological considerations were also
important."_ [Jonathan Aves, **Workers Against Lenin**, p. 2, p. 17, p. 15, p.
30, p. 17 and p. 11] Unsurprisingly, then, the defeat of Wrangel in November
1920 saw no changes in Bolshevik policy nor the Bolshevik use of coercion
against workers and peasants calling and protesting for the re-introduction of
freedom and democracy.

So there is a continuity between Bolshevik policies before, during and after
the civil war which McNally does not mention. Take one-man management, for
example. This was advocated by Lenin **before** the civil war started and when
he looked back at this time from April 1920, he reiterated his position
(_"Dictatorial powers and one-man management are not contradictory to
socialist democracy"_) while also stressing that this was not forced upon the
Bolsheviks by civil war. It was time to build socialism and the _"whole
attention of the Communist Party and the Soviet government is centred on
peaceful economic development, on problems of the dictatorship and of one-man
management"_. _"When we tackled them for the first time in 1918, there was no
civil war and no experience to speak of"_ and so it was _"not only
experience"_ of civil war, argued Lenin _"but something more profound . . .
that has induced us now, as it did two years ago, to concentrate all our
attention on labour discipline."_ Lenin stressed that we _"need more
discipline, more individual authority and more dictatorship"_. [**Collected
Works**, vol. 30, p. 503, p. 504 and p. 514]

The same can be said of the arguments for party dictatorship, which were
raised at the Second Congress of the Communist International and aimed to
influence the revolutionary movement across the globe. Trotsky wrote his
infamous **Terrorism and Communism** as part of this debate between socialists
and, to quote syndicalist-turned-Bolshevik Alfred Rosmer, it _"dealt with the
theoretical and practical problems posed by the revolution, the civil war and
the building of the new society"_ and it _"formed a sort of introduction and
commentary on the **Theses** prepared for the Congress."_ As we show in
[section 15](append31.md#app15), this work acknowledged that party
dictatorship was a necessity of a successful revolution, the need for one-man
management as well as the militarisation of labour (needless to say, we also
show how -- McNally's claims notwithstanding -- Trotsky did not reject these
positions in the 1920s and 1930s). In addition, the congress took place in
July 1920 when the civil war appeared to have been won, with Rosmer recalling
that when he had arrived in _"June 1920"_ in Russia _"the civil war was
virtually at an end"_ for _"[a]fter the triple blow struck at the
interventionist forces, after the destruction of Kolchak, Yudenich and
Denikin, the counter-revolution was defeated."_ [**Lenin's Moscow**, p. 58, p.
65, p. 128 and p. 101]

To stress the point, Lenin, Zinoviev and Trotsky were all clearly arguing for
party power, **not** workers' power, and that party dictatorship is inevitable
in **every** revolution. This position was **not** put in terms of the
problems facing the Russian Revolution but rather were expressed in universal
terms and unsurprisingly, then _"[f]rom the first days of Bolshevik power
there was only a weak correlation between the extent of 'peace' and the
mildness or severity of Bolshevik rule, between the intensity of the war and
the intensity of proto-war communist measures . . . Considered in ideological
terms there was little to distinguish the 'breathing space' (April-May 1918)
from the war communism that followed."_ Unsurprisingly, then, _"the breathing
space of the first months of 1920 after the victories over Kolchak and Denikin
. . . saw their intensification and the militarisation of labour"_ and, in
fact, _"no serious attempt was made to review the aptness of war communist
policies."_ Ideology _"constantly impinged on the choices made at various
points of the civil war . . . Bolshevik authoritarianism cannot be ascribed
simply to the Tsarist legacy or to adverse circumstances."_ [Richard Sakwa,
**Soviet Communists in Power**, p. 24, p. 27 and p. 30]

As we discuss in [section H.6.2](secH6.md#sech62), Bolshevik ideology and
the decisions it inspired helped make the difficult circumstances the
revolution was facing worse. Their centralised vision of socialism could not
help but produce economic mismanagement as well as a new class of bureaucrats.
The inherent tendencies of Bolshevism were revealed by the civil war, a war
which only accelerated the development of what was implicit (and, often, not
so implicit) in Bolshevik ideology and its vision of socialism, the state and
the role of the party. Therefore, in practice, Leninism has proven to be
profoundly anti-democratic. In terms of McNally's argument, to not discuss in
detail Bolshevik authoritarianism and blame it on the impact of the civil war
is dishonest, particularly given the awkward fact that their anti-democratic
activities started **before** its beginning at the end of May 1918.

Bolshevik authoritarianism had two main causes.

First, the obvious change in its social position -- it became part of the
state and, as a result, viewed society -- and the working class -- from above,
as rulers. So as Marxism is _"centralist"_ and aims for _"conscious,
democratic, proletarian centralism"_ it will inevitably lead to a new class
system being created. [**The Lenin Anthology**, p. 348] This is not
necessarily because Leninists seek dictatorship for themselves (although they
do aim for party power -- see [section H.3.11](secH3.md#sech311)) but rather
it is because of the nature of the state machine. In the words of Murray
Bookchin:

> _"Anarchist critics of Marx pointed out with considerable effect that any
system of representation would become a statist interest in its own right, one
that at best would work against the interests of the working classes
(including the peasantry), and that at worst would be a dictatorial power as
vicious as the worst bourgeois state machines. Indeed, with political power
reinforced by economic power in the form of a nationalised economy, a
'workers' republic' might well prove to be a despotism (to use one of
Bakunin's more favourite terms) of unparalleled oppression . . . _

> _"Republican institutions, however much they are intended to express the
interests of the workers, necessarily place policy-making in the hands of
deputies and categorically do not constitute a 'proletariat organised as a
ruling class.' If public policy, as distinguished from administrative
activities, is not made by the people mobilised into assemblies and
confederally co-ordinated by agents on a local, regional, and national basis,
then a democracy in the precise sense of the term does not exist. The powers
that people enjoy under such circumstances can be usurped without difficulty .
. . [I]f the people are to acquire real power over their lives and society,
they must establish -- and in the past they have, for brief periods of time
established -- well-ordered institutions in which they themselves directly
formulate the policies of their communities and, in the case of their regions,
elect confederal functionaries, revocable and strictly controllable, who will
execute them. Only in this sense can a class, especially one committed to the
abolition of classes, be mobilised as a class to manage society."_ [_"The
Communist Manifesto: Insights and Problems"_, pp. 14-17, **Black Flag**, no.
226, pp. 16-7]

As we discuss in [section H.3.9](secH3.md#sech39), anarchists argue that the
state cannot be considered as simply an instrument of economic class but,
rather, has interests of its own. As such, concentrations of political power
will produce a new class system and become independent of the masses of people
and even of economically dominant classes like capitalists. This is why
anarchists stress direct democracy (self-management) in free federations of
free associations. It is the only way to ensure that power remains in the
hands of the people and is not turned into an alien power above them. Thus
Marxist support for statist forms of organisation will inevitably undermine
the liberatory nature of the revolution. As we note in [section
14](append31.md#app14), that is anarchists have long argued for the need for
social transformation _"from below"_.

Second, as indicated in [section H.5](secH5.md), their idea of the party
being the "vanguard" of the working class, combined with its desire for
centralised power, makes the dictatorship of the party **over** the
proletariat inevitable. Lenin's belief that working class people could not
liberate themselves explains his continual emphasis on **representative**
democracy and centralism as well as the Bolshevik's easy slide into both
practicing and advocating party dictatorship -- simply put, the party must
have power **over** the working class as that class could not be trusted to
make the right decisions (i.e. know what its "real" interests were). At best
they would be allowed to vote for the government, but even this right could be
removed if they voted for the wrong people as shown above. For Leninists,
revolutionary consciousness is not generated by working class self-activity in
the class struggle, but is embodied in the party (_"Since there can there can
be no talk of an independent ideology being developed by the masses of the
workers in the process of their movement **the only choice is**: either
bourgeois or socialist ideology"_ [Lenin, **The Essential Works of Lenin**,
82]). The conclusions of this position are obvious: the important issues
facing the working class are to be determined not by the workers ourselves,
but by the leadership of the party, who are the (self-appointed) _"vanguard of
the proletariat"_.

The nature of the relationship between the party and the working class is
clear. We remain incapable of achieving revolutionary consciousness and have
to be led by the vanguard -- using state coercion, if need be. As Lenin
argued:

> _"it must he made clear that democracy under the Soviet system does not
contradict dictatorship . . . Unity of will must not be a catchword, a symbol.
We demand it in practice. This is how unity of will was expressed during the
[civil] war -- anybody who placed his own interests (or the interests of his
village or group) above the common interests, was branded as a self-seeker and
was shot; this was justified by the moral consciousness of the working class
that it must achieve victory. We spoke about these shootings openly; we said
that we made no secret of coercion, because we realised that we could not
emerge from the old society without resorting to compulsion as far as the
backward section of the proletariat was concerned . . ."_ [**Op. Cit.**, vol.
30 pp. 509-10]

This raises numerous questions, the most obvious is **who** (which individual
or group) decides which is and is not in the common interests? Another is,
what is to stop this pivileged person or group placing **their** interests
above _"the common interests"_ and repressing those who object in the name of
those very same _"common interests"_? Moreover, as **everyone** is -- by
definition! -- _"backward"_ in comparison to the vanguard in its own eyes,
Lenin's position ensures that _"compulsion"_ can be used by the party against
**all** who it considers an danger to its power -- including the proletariat
it claims to be the ruling class. Hence the destruction of soviet, workplace,
union and armed forces democracy and, of course, the creation of bodies of
armed men (such as the political police, the Cheka) separate from the people
(i.e., a state in the normal sense of the word -- see [section
H.3.8](secH3.md#sech38)).

In short, the notion that dictatorship does not contradict democracy is simply
nonsense -- self-serving nonsense, of course -- and which could have no other
impact than a negative one of socialism. What would stop, say, a Stalin
proclaiming that his regime was simply using coercion against the backward
sections of the masses in the common interest and that those who objected were
placing their own interests above it? It is the crudest form of idealism to
hope that the socialist principles of the ruling elite will overcome the
pressures of their position in the social hierarchy and, unsurprisingly, it
did not happen.

_"If we perish"_, Lenin said privately to Trotsky in 1921, _"it is all the
more important to preserve our ideological line and give a lesson to our
continuators. This should never be forgotten, even in hopeless
circumstances"_. [quoted by Brinton, _"The Bolsheviks and Workers' Control"_,
**For Workers' Power**, p. 372] Hence the comments made by Zinoviev at the
Second Congress of the Communist International, Trotsky in **Terrorism and
Communism** and Lenin in innumerable speeches and articles. Sadly for
McNally's case, the lesson that the Bolsheviks wanted to give to the world
revolutionary movement was not the importance of freedom and democracy but
rather that party dictatorship and one-man management were necessary to
achieve a successful revolution and that an economic regime which was obvious
**state-capitalism** was socialism. Little wonder Leninists had so much
difficulty in recognising Stalinism was a new class system -- to do so would
have been to raise awkward questions about the similar -- if less brutal --
regime under Lenin and Trotsky.

To conclude, both anarchism and Leninism have a critical position on
democracy. Lenin argued that _"formal democracy must be subordinate to the
revolutionary interest"_ and in a sense he was right. [**Collected Works**,
vol. 32, p. 86] As we indicated in [section 7](append31.md#app7), anarchists
argue that minorities should ignore (or rebel against) the majority if it is
oppressing the minority -- for progress to be achieved the _"revolutionary
interest"_ (freedom) must come first. Only in this way can the liberatory
promise of democracy can be secured in the face of any potential dictatorship
of the majority. The Leninist position is that a minority can ignore the
majority only if it is the party leadership for it is they, the vanguard, who
determine what the _"revolutionary interest"_ is and, as a result, Leninism --
for all its rhetoric -- is fundamentally an anti-democratic ideology simply
because this justifies party dictatorship as **everyone** is "backward"
compared to the vanguard. McNally distorts the anarchist position while
proclaiming the democratic credentials of Leninism. The facts are otherwise.

## 9\. Why is McNally wrong on the relation of syndicalism to anarchism?

After slandering anarchism, McNally turns towards another form of libertarian
socialism, namely syndicalism. It is worth quoting him in full as his comments
are truly ridiculous:

> _"There is . . . another trend which is sometimes associated with anarchism.
This is syndicalism. The syndicalist outlook does believe in collective
working class action to change society. Syndicalists look to trade union
action -- such as general strikes -- to overthrow capitalism. Although some
syndicalist viewpoints share a superficial similarity with anarchism --
particularly with its hostility to politics and political action --
syndicalism is not truly a form of anarchism. By accepting the need for mass,
collective action and decision-making, syndicalism is much superior to
classical anarchism."_

The weakness of McNally's position can be seen from comparing his summary of
syndicalism's key ideas with _"classical anarchism"_, namely Bakunin's
revolutionary anarchism. This passage by Bakunin expresses almost all the
ideas McNally ascribes to syndicalism:

> _"Toilers count no longer on anyone but yourselves. Do not demoralise and
paralyse your growing strength by being duped into alliances with bourgeois
Radicalism . . . Abstain from all participation in bourgeois Radicalism and
organise outside of it the forces of the proletariat. The bases of this
organisation . . . are the workshops and the federation of workshops . . .
instruments of struggle against the bourgeoisie, and their federation, not
only national, but international . . . when the hour of revolution sounds, you
will proclaim the liquidation of the State and of bourgeois society, anarchy,
that is to say the true, frank people's revolution."_ [quoted by K.J.
Kenafick, **Michael Bakunin and Karl Marx**, pp. 120-1]

Bakunin, therefore, stressed trade union action, arguing as _"strikes spread
from one place to another, they come close to turning into a general strike.
And with the ideas of emancipation that now hold sway over the proletariat, a
general strike can result only in a great cataclysm which forces society to
shed its old skin."_ He raised the possibility that this could _"arrive before
the proletariat is sufficiently organised"_ and dismissed it the _"necessities
of the struggle impel the workers to support one another"_ and the _"more
active the struggle becomes . . . the stronger and more extensive this
federation of proletarians must become."_ Thus strikes _"indicate a certain
collective strength already"_ and _"each strike becomes the point of departure
for the formation of new groups."_ [**The Basic Bakunin**, pp. 149-50]

For Bakunin, like the later syndicalists, _"the natural organisation of the
masses . . . is organisation based on the various ways that their various
types of work define their day-to-day life; it is organisation by trade
association"_ and once _"every occupation . . . is represented within the
International [Working-Men's Association], its organisation, the organisation
of the masses of the people will be complete."_ [**Op. Cit.**, p. 139] Thus
_"unions create that conscious power without which no victory is possible"_
while strikes _"create, organise, and form a workers' army, an army which is
bound to break down the power of the bourgeoisie and the State, and lay the
ground for a new world."_ [**The Political Philosophy of Bakunin**, p. 379 and
pp. 384-5] The _"organisation of the trade sections and their representation
by the Chambers of Labour . . . bear in themselves the living seeds of the new
society which is to replace the old world. They are creating not only the
ideas, but also the facts of the future itself."_ [**Bakunin on Anarchism**,
p. 255]

And yet McNally proclaims that Bakunin _"shared most of Proudhon's views"_ and
so, by implication, _"so feared the organised power of the developing working
class that he went so far as to oppose trade unions"_! Rather than be against
the _"freedom of the working class to make collectively a new society"_,
Bakunin repeatedly argued that _"the new social order"_ would be attained
_"through the social (and therefore anti-political) organisation and power of
the working masses of the cities and villages."_ This would see _"capital and
all tools of labour belong to the city workers -- to the workers associations.
The whole organisation of the future should be nothing but a free federation
of workers -- agricultural workers as well as factory workers and associations
of craftsmen."_ [**The Political Philosophy of Bakunin**, p. 300 an p. 410]
This position was common to all revolutionary anarchists (see sections
[H.2.2](secH2.md#sech22) and [H.2.7](secH2.md#sech27)).

What is ridiculous about McNally's comments is that all historians who take
the time to read Bakunin's works note the obvious links between his ideas and
syndicalism. Let us present a few examples here (many writers also point to
syndicalist aspects in Proudhon's ideas as well but we will concentrate on
Bakunin). Thus we discover Caroline Cahm pointing out _"the basic syndicalist
ideas of Bakunin"_ and that he _"argued that trade union organisation and
activity in the International [Working Men's Association] were important in
the building of working-class power in the struggle against capital . . . He
also declared that trade union based organisation of the International would
not only guide the revolution but also provide the basis for the organisation
of the society of the future."_ Indeed, he _"believed that trade unions had an
essential part to play in the developing of revolutionary capacities of the
workers as well as building up the organisation of the masses for
revolution."_ [**Kropotkin and the Rise of Revolutionary Anarchism**, p. 219,
p. 215 and p. 216] George R. Esenwein noted that syndicalism _"had deep roots
in the Spanish libertarian tradition. It can be traced to Bakunin's
revolutionary collectivism"_ and the class struggle was _"central to Bakunin's
theory."_ [**Anarchist Ideology and the Working Class Movement in Spain**, p.
209 and p. 20] The syndicalists _"viewed themselves as the descendants of the
federalist wing of the First International, personified above else by Mikhail
Bakunin."_ [Wayne Thorpe, **"The Workers Themselves"**, pp. xiii-xiv] _"Hardly
any of these ideas [associated with syndicalism] are new"_, stated Bertrand
Russell _"almost all are derived from the Bakunist [sic!] section of the old
International"_ and this was _"often recognised by Syndicalists themselves."_
[**Roads to Freedom**, p. 52] J. Romero Maura correctly summarised that for
the _"Bakuninists"_ in the First International, the _"anarchist revolution,
when it came, would be essentially brought about by the working class.
Revolutionaries needed to gather great strength and must beware of
underestimating the strength of reaction"_ and so they _"logically decided
that revolutionaries had better organise along the lines of labour
organisations."_ [_"The Spanish case"_, pp. 60-83, **Anarchism Today**, D.
Apter and J. Joll (eds.), p. 66]

We could go on but as leading syndicalist activist and thinker Rudolf Rocker
summarised:

> _"Modern Anarcho-syndicalism is a direct continuation of those social
aspirations which took shape in the bosom of the First International and which
were best understood and most strongly held by the libertarian wing of the
great workers' alliance."_ [**Anarcho-Syndicalism**, p. 54]

Perhaps, in the face of such evidence (and the writings of Bakunin himself!),
Marxists like McNally could claim that the sources we quote are either
anarchists or "sympathetic" to anarchism. To counter this we will quote Marx
and Engels. According to Marx, Bakunin's theory consisted of urging the
working class to _"only organise themselves by trades-unions"_ and _"not
occupy itself with **politics.**"_ Engels asserted that in the _"Bakuninist
programme a general strike is the lever employed by which the social
revolution is started"_ and that they admitted _"this required a well-formed
organisation of the working class"_. [Marx, Engels and Lenin, **Anarchism and
Anarcho-Syndicalism**, p. 48, p. 132 and p. 133] Ignoring the
misrepresentations of Marx and Engels about the theories of their enemies, we
can state that they got the basic point of Bakunin's ideas -- the centrality
of trade union organisation and struggle as well as the use of strikes as the
means of starting a social revolution.

(As an aside, ironically enough, Engels distorted diatribe against Bakunin and
the general strike was later used against more radical Marxists like Rosa
Luxemburg -- usually claimed by Leninists as part of their tradition -- by the
reformists in Social Democratic Parties. For orthodox Marxists, the mass
strike was linked to anarchism and Engels had proven that only political
action -- i.e. electioneering -- could lead to working class emancipation.
This appeal to authority lead Luxemburg to the innovative tactic of suggesting
Engels was correct against the anarchist **general** strike but not against
her **mass** strike! That this involved distorting the anarchist position --
as Engels had done -- should go without saying -- see [section
H.3.5](secH3.md#sech35).)

It should be stressed that Bakunin's position on revolutionary class struggle
waged by workers' organisations became the basis of revolutionary anarchism.
Thus we find, for example, Emma Goldman arguing that in the First
International _"Bakunin and the Latin workers"_ forged ahead _"along
industrial and Syndicalist lines"_ and so syndicalism _"is, in essence, the
economic expression of Anarchism"_ and _"[l]ike Anarchism, Syndicalism
prepares the workers along direct economic lines, as conscious factors in the
great struggles of to-day, as well as conscious factors in the task of
reconstructing society."_ The _"most powerful weapon"_ for liberation was
_"the conscious, intelligent, organised, economic protest of the masses
through direct action and the general strike."_ [**Red Emma Speaks**, p. 89,
p. 91 and p. 60] Kropotkin summarised the libertarian perspective well in
1907:

> _"Workmen's organisations are the real force capable of accomplishing the
social revolution -– after the awakening of the proletariat has been
accomplished, first by individual action, then by collective action, by
strikes and revolts extending more and more; and where workmen's organisations
have not allowed themselves to be dominated by the gentlemen who advocate 'the
conquest of political power', but have continued to walk hand in hand with
anarchists –- as they have done in Spain -– they have obtained, on the one
hand, immediate results (an eight-hour day in certain trades in Catalonia),
and on the other have made good propaganda for the social revolution -– the
one to come, not from the efforts of those highly-placed gentlemen, but from
below, from workmen's organisations."_ [_"Anarchists and Trade Unions"_,
**Direct Struggle Against Capital**, pp. 391-2]

We will leave the matter here and point interested readers to our extended
discussion of the links between anarchism and syndicalism in [section
H.2.8](secH2.md#sech28). However, the inaccuracy of McNally's statement
should be clear as we have shown that according to him _"syndicalism"_ (i.e.
Bakunin's ideas) is _"much superior to classical anarchism"_ (i.e. Bakunin's
ideas)! How spurious his argument actually is can be seen from his comments
about syndicalism and its relation to anarchism.

## 10\. Do syndicalists reject working class political action?

McNally, after getting the relationship between _"classical anarchism"_ and
syndicalism completely wrong (see [last section](append31.md#app9)), moves
on to an equally flawed argument against syndicalism. He states that _"by
rejecting the idea of working class political action, syndicalism has never
been able to give real direction to attempts by workers to change society."_
However, syndicalists (like all anarchists) are clear what kind of politics
they reject -- bourgeois politics (i.e. the running of candidates in
elections). It is worth quoting Rudolf Rocker at length on McNally's claim:

> _"It has often been charged against Anarcho-Syndicalism that it has no
interest in the political structure of the different countries, and
consequently no interest in the political struggles of the time, and confines
its activities to the fight for purely economic demands. This idea is
altogether erroneous and springs either from outright ignorance or wilful
distortion of the facts. It is not the political struggle as such which
distinguishes the Anarcho-Syndicalists from the modern labour parties, both in
principle and in tactics, but the form of this struggle and the aims which it
has in view. . ._

> _"The attitude of Anarcho-Syndicalism toward the political power of the
present-day state is exactly the same as it takes toward the system of
capitalist exploitation. . . [and so] Anarcho-Syndicalists pursue the same
tactics in their fight against that political power which finds its expression
in the state. . ._

> _"For just as the worker cannot be indifferent to the economic conditions of
his life in existing society, so he cannot remain indifferent to the political
structure of his country. . . It is, therefore, utterly absurd to assert that
the Anarcho-Syndicalists take no interest in the political struggles of the
time. . . But the point of attack in the political struggle lies, not in the
legislative bodies, but in the people. . . If they, nevertheless, reject any
participation in the work of bourgeois parliaments, it is not because they
have no sympathy with political struggles in general, but because they are
firmly convinced that parliamentary activity is for the workers the very
weakest and the most hopeless form of the political struggle. . ._

> _"But, most important of all, practical experience has shown that the
participation of the workers in parliamentary activity cripples their power of
resistance and dooms to futility their warfare against the existing system. .
._

> _"Anarcho-Syndicalists, then, are not in any way opposed to the political
struggle, but in their opinion this struggle, too, must take the form of
direct action, in which the instruments of economic power which the working
class has at its command are the most effective. . ._

> _"The focal point of the political struggle lies, then, not in the political
parties, but in the economic fighting organisations of the workers. It as the
recognition of this which impelled the Anarcho-Syndicalists to centre all
their activity on the Socialist education of the masses and on the utilisation
of their economic and social power. Their method is that of direct action in
both the economic and the political struggles of the time. That is the only
method which has been able to achieve anything at all in every decisive moment
in history."_ [**Op. Cit.**, pp. 73-78]

Rocker's work, **Anarcho-Syndicalism**, was written in 1938 and is considered
the standard introduction to that theory. McNally wrote his pamphlet in the
1980s and did not bother to consult the classic introduction to the ideas he
claims to be refuting. That in itself indicates the worth of his pamphlet and
any claims it has for being remotely accurate with respect to anarchism and
syndicalism.

Syndicalists, then, **do** reject working class _"political action"_ only if
you think "political action" means simply bourgeois politics -- that is,
electioneering, standing candidates for Parliament, local town councils and so
on. It does not reject "political action" in the sense of direct action to
effect political changes and reforms. As syndicalists Ford and Foster argued,
syndicalists use _"the term 'political action' . . . in its ordinary and
correct sense. Parliamentary action resulting from the exercise of the
franchise is political action. Parliamentary action caused by the influence of
direct action tactics . . . is not political action. It is simply a
registration of direct action."_ They also note that syndicalists _"have
proven time and again that they can solve the many so-called political
questions by direct action."_ [Earl C. Ford and William Z. Foster,
**Syndicalism**, p. 19f and p. 23] A historian of the British syndicalist
movement reiterates this point:

> _"Nor did syndicalists neglect politics and the state. Revolutionary
industrial movements were on the contrary highly 'political' in that they
sought to understand, challenge and destroy the structure of capitalist power
in society. They quite clearly perceived the oppressive role of the state
whose periodic intervention in industrial unrest could hardly have been
missed."_ [Bob Holton, **British Syndicalism: 1900-1914**, pp. 21-2]

This awareness that the state could not be ignored but had to be fought is
reflected in the 1909 French syndicalist novel _How We Shall Bring About the
Revolution_ which discussed how the Chamber of Deputies was _"invaded from all
sides"_ by the crowd during the revolution, which _"threatened with death any
deputies who should dare sit again."_ The _"General Strikers were on watch"_
and _"in order to guard against any aggressive action by the fallen power, or
any effort to re-establish Parliamentarianism, a certain number of their
comrades should remain permanently at the Palais Bourdon"_ and _"oppose by
force any counter-revolutionary measures."_ Guards were also used in _"the
Police Offices, the Government Offices, the Elysée, etc."_ after _"having
taken them by assault."_ The town hall _"was not neglected"_ and _"was
occupied"_ in a similar fashion. Thus there was a _"definite intention of
disorganising the State, of dismantling and thoroughly disabling it"_ to
ensure it was _"impossible for the Government to recover itself, or rally
around any point whatever."_ Thus the general strike _"very soon changed into
an insurrectional strike"_ and _“the General Strikers occupied the centres of
Government action, and expelled the representative of the State._ The state
would be replaced by _Bourses du Travail_ (local federation of unions) and the
Trades Unions Congress, with the latter being formed by delegates _"from all
parts of France"_ and _"from all trades, from all professions"_ and _"having
to decide upon points previously discussed by the comrades who had sent
them."_ The similarities to soviets -- and Bakunin's ideas (see [section
5](append31.md#app5)) -- are clear. Nor did they ignore the need to defend a
revolution and like revolutionary anarchists (see [section
H.2.1](secH2.md#sech21)) argued for the unions to form _"bands"_ to _"watch
over the security of the committees"_ and _"sought to arm themselves"_ in
order to _"counterbalance the military and other forces"_ which _"held them
under the yoke."_ The trade unions distributed arms and in each syndicate _"a
group for defence was formed"_ which entered _"into relation with like groups
in the same district, and with distant centres"_ by means of an _"organisation
of defence, with a Trade Union and Federal basis."_ These _"Syndicalist
battalions were not a force external to the people. They were the people
themselves"_ who _"had the common-sense to arm themselves in order to protect
their conquered liberty."_ [Emile Pataud and Emile Pouget, **How We Shall
Bring About the Revolution**, pp. 79-83, p. 94, pp. 128-9, p. 69 and pp.
155-7]

As we argued in [section J.2.10](secJ2.md#secj210), anarchist support for
direct action and opposition to taking part in elections does not mean we are
"apolitical" or reject political action. Anarchists have always been clear --
we reject "political action" which is bourgeois in nature in favour of
"political action" based on the organisations, action and solidarity of
working class people. This is because electioneering corrupts those who take
part, watering down their radical ideas and making them part of the system
they were meant to change. As Rocker summarised:

> _"Participation in the politics of the bourgeois States has not brought the
labour movement a hair's-breadth nearer to Socialism, but thanks to this
method, Socialism has almost been completely crushed and condemned to
insignificance . . . Participation in parliamentary politics has affected the
Socialist Labour movement like an insidious poison. It destroyed the belief in
the necessity of constructive Socialist activity, and, worse of all, the
impulse to self-help, by inoculating people with the ruinous delusion that
salvation always comes from above."_ [**Op. Cit.**, p. 54]

Rocker's last point is important, given that McNally seeks to appropriate the
idea of _"from below"_ for Marxism. He is well aware of the results of
socialist electioneering, reporting how by the start of the 20th century
_"most European socialists. . . came to the view that socialism would be
achieved gradually, through the slow transformation of capitalism into a kind
of welfare capitalism under which workers would prosper"_ and _"[g]one was
Marx's notion that socialism could only come into being through a
revolutionary transformation of society from below. In its place developed the
view that capitalism would slowly grow over into socialism."_ However, he
significantly fails to note that these parties considered themselves as
Marxist and had been following the strategy Marx and Engels had advocated.

It would have been informative to his readership if McNally had found time to
discuss this awkward fact. One of the key differences between Marx and Bakunin
in the First International was over _"political action"_: the forming of
political parties and standing in elections. Bakunin argued that _"it is
usually enough for these men of the people to enter government for them to
become members of the bourgeoisie in their turn, sometimes scorning the people
from whom they came more than do the natural-born members of the
bourgeoisie."_ The need was _"**the organisation of the might of the
workers**, the unification of the proletariat of the entire world"_ by
_"eliminat[ing] from its program all bourgeois political schemes"_ in favour
of _"workers' solidarity in their struggle against the bosses. It means
**trades unions, organisation, and the federation of resistance funds**."_
[**The Basic Bakunin**, p. 51, p. 93, p. 99 and p. 103] Marx and Engels, in
contrast, favoured _"political action"_ and completely failed, unlike Bakunin,
to recognise the dangers of reformism in the tactic. Indeed, in 1891 Engels
proudly announced that the Brussels Congress of the Second International
_"proved a brilliant success for us . . . And, best of all, the anarchists
have been shown the door, just as they were at the Hague Congress. The new,
incomparably larger and avowedly Marxist International is beginning again at
the precise spot where its predecessor ended."_ [**Collected Works**, vol. 49,
p. 238]

McNally, like most Leninists, is keen to distance Marx and Engels from Social
Democracy and so does not note their repeated comments -- both before **and**
after the Paris Commune that socialism **could** come about peacefully by
utilising elections (see [section H.3.10](secH3.md#sech310)). Engels in
1847, for example, argued that the _"first, fundamental condition for the
introduction of community of property is the political liberation of the
proletariat through a democratic constitution"_ and so the revolution's had to
_"inaugurate a **democratic constitution** and thereby . . . the political
rule of the proletariat"_ as in _"America, where a democratic constitution has
been introduced"_ [**Collected Works**, vol. 6, p. 102, p. 350 and p. 356] In
contrast, Proudhon had concluded the year before that the state could **not**
be captured and reformed and socialism could only be created by proletarian
self-organisation:

> _"Thus power [i.e. the state] . . . finds itself inevitably enchained to
capital and directed against the proletariat . . . The problem before the
labouring classes, then, consists, not in capturing, but in subduing both
power and monopoly -- that is, in generating from the bowels of the people,
from the depths of labour, a greater authority, a more potent fact, which
shall envelop capital and the State and subjugate them. Every proposition of
reform which does not satisfy this condition is simply one scourge more . . .
which threatens the proletariat."_ [**Property is Theft!**, p. 226]



The syndicalists, like Bakunin, argued the same -- although, unlike the
Frenchman, saw the trade union movement as the means of social transformation.
It is almost redundant to note that history has proven the validity of
anarchist anti-electioneering ideas. For example, as we argue in [section
J.2.6](secJ2.md#secj26), the net result of the Marxists use of
electioneering ("political action") was the de-radicalising of their movement
and theory and its becoming yet another barrier to working class self-
liberation. Rather than syndicalism not giving _"real direction to attempts by
workers to change society"_ it was Marxism in the shape of Social Democracy
which did that. Indeed, at the turn of twentieth century more and more
radicals turned to Syndicalism and Industrial Unionism as the means of by-
passing the dead-weight of Social Democracy (i.e. orthodox Marxism), its
reformism, its opportunism and its bureaucracy.

This was recognised by Lenin, if in his own way. Anarchism, he suggested,
_"was not infrequently a kind of penalty for the opportunist sins of the
working-class movement."_ [**Collected Works**, vol. 31, p. 32] His claim that
anarchist and syndicalist support in the working class is the result of the
opportunist nature of the Social Democratic Parties has an element of truth.
Obviously militants sick to death of the reformist, corrupt and bureaucratic
"working class" parties will seek a revolutionary alternative and find
libertarian socialism. However, Lenin seeks to explain the symptoms
(opportunism) and not the disease itself (Parliamentarianism) . Nowhere does
he see the rise of "opportunist" tendencies in the Marxist parties as the
result of the tactics and organisational struggles they used. Indeed, Lenin
desired the new Communist Parties to practice electioneering ("political
action"). Anarchists rather point out that given the nature of the means, the
ends surely follow. Working in a bourgeois environment (Parliament) will
result in bourgeoisifying and de-radicalising the party. Working in a
centralised environment will empower the leaders of the party over the members
and lead to bureaucratic tendencies. In short, the means urged inevitably
produced a _"from above"_ mentality and the descent into reformism -- a
descent Lenin only noticed with the outbreak of war in 1914 and the siding of
German Social Democracy with its state in the imperialist slaughter.

As Bakunin predicted, using bourgeois institutions will corrupt
"revolutionary" and radical parties and tie the working class to the current
system. Lenin's analysis of anarchist influence as being the off-spring of
opportunist tendencies in mainstream parties may be right, but if so it is a
natural development as the tactics supported by Marxists from Marx onwards
inevitably lead to opportunist tendencies developing. What Lenin could not
comprehend was that opportunism was the symptom and electioneering was the
disease -- using the same means (electioneering) with different
parties/individuals ("Communists" instead of "Social Democrats") and thinking
that opportunism would not return was idealistic nonsense.

Sadly for his readers, McNally did not discuss any of this and preferred to
present an inaccurate account of the syndicalist position on political
struggles. Perhaps this is understandable, for an accurate account would
mention the debates of the First International and have to draw the obvious
conclusion: Bakunin -- and the syndicalists -- were right.

## 11\. Why is McNally's claim that Leninism supports working class self-
emancipation wrong?

McNally claims that Marx _"was the first major socialist thinker to make the
principle of self-emancipation -- the principle that socialism could only be
brought into being by the self-mobilisation and self-organisation of the
working class -- a fundamental aspect of the socialist project."_ This is not
entirely true as _"Proudhon insisted that the revolution could only come from
below, through the action of the workers themselves."_ [K. Steven Vincent,
**Pierre-Joseph Proudhon and the Rise of French Republican Socialism**, p.
157] In his words:

> _"Workers, labourers, men of the people, whoever you may be, the initiative
of reform is yours. It is you who will accomplish that synthesis of social
composition which will be the masterpiece of creation, and you alone can
accomplish it."_ [quoted by George Woodcock, **Pierre-Joseph Proudhon: A
Biography**, p. 64]

As we indicated in [section 2](append31.md#app2), Proudhon stressed that the
working class had to free itself by its own means and its own organisations
for, as indicated in [section 10](append31.md#app10), the state was a
capitalist institution which could not be captured by the masses. So while
Proudhon placed his hopes in reformist tendencies (such as workers' co-
operatives and mutual banks) he clearly believed in working class self-
emancipation, even stating in 1848 that _"the proletariat must emancipate
itself"_ for _"the revolutionary power . . . is not in the National Assembly:
it is in you. The people alone, acting upon themselves without intermediary,
can achieve the economic Revolution begun in February. The people alone can
save civilisation and advance humanity!"_ [**Property is Theft!**, 306 and p.
366]

Marx's use of the famous expression -- _"the emancipation of the working class
is the task of the working class itself"_ \-- dates from 1865, 17 years after
Proudhon's comment that _"the proletariat must emancipate itself."_ Moreover,
as Libertarian Marxist Paul Mattick pointed out, Marx was not even the first
person to use the expression _"the emancipation of the working class is the
task of the working class itself"_ as Flora Tristan used it in 1843. [**Marx
and Keynes**, p. 333] Thus a case could be made that Marx was, in fact, the
**third** _"major socialist thinker to make the principle of self-emancipation
-- the principle that socialism could only be brought into being by the self-
mobilisation and self-organisation of the working class -- a fundamental
aspect of the socialist project."_

Similarly, Bakunin continually quoted Marx's (and so Tristan's) words from the
Preamble to the General Rules of the First International: _"That the
emancipation of the workers must be accomplished by the workers themselves."_
Far more than Marx, Bakunin argued that workers' can only free themselves by a
_"single path, that of **emancipation through practical action**"_ namely
_"workers' solidarity in their struggle against the bosses"_ by _"**trades-
unions, organisation, and the federation of resistance funds**"_. The
_"collective experience"_ workers gain in the _"collective struggle of the
workers against the bosses"_ will ensure they _"will necessarily come to
realise that there is an irreconcilable antagonism between the henchmen of
reaction and [their] own dearest human concerns. Having reached this point,
[the worker] will recognise [themselves] to be a revolutionary socialist."_
[**The Basic Bakunin**, p. 92 and p. 103]

In contrast Marx placed his hopes for working class self-emancipation on a
political party which would conquer "political power." As history soon proved,
Marx was mistaken on two levels. First, as Bakunin predicted, political action
by socialist parties resulted in the political system changing the party
rather than vice versa, that it _"inexorably enmeshes its adherents, under the
pretext of political tactics, in endless accommodations with governments and
the various bourgeois political parties -- that is, it thrusts them directly
into reaction."_ [**Statism and Anarchy**, p. 180] Second, "political power"
can only be seized by a minority (i.e. the party, **not** the class it claims
to represent) and if the few have the power, the rest are no longer free (i.e.
they no longer govern themselves). That the many elect the few who issue them
orders does **not** signify emancipation!

However, this is beside the point. McNally proudly places his ideas in the
Leninist tradition. It is thus somewhat ironic that McNally claims that
Marxism is based on self-emancipation of the working class while claiming
Leninism as a form of Marxism as Lenin explicitly stated the opposite, namely
that the working class **could not** liberate itself by its own actions. In
his 1902 book **What is to be Done?** Lenin argued that _"the working class,
exclusively by their own effort, is able to develop only trade union
consciousness . . . The theory of socialism [i.e. Marxism] . . . grew out of
the philosophic, historical and economic theories that were elaborated by the
educated representatives of the propertied classes, the intellectuals . . .
the theoretical doctrine of Social-Democracy arose quite independently of the
spontaneous growth of the labour movement; it arose as a natural and
inevitable outcome of ideas among the revolutionary socialist
intelligentsia."_ This meant that _"Social Democratic [i.e. socialist]
consciousness . . . could only be brought to them [the workers] from
without."_ Speaking on behalf of workers, he asked that the _"intellectuals
must talk to us, and tell us more about what we do not know and what we can
never learn from our factory and 'economic' experience, that is, you must give
us political knowledge."_ [**Essential Works of Lenin**, pp. 74-5 and p. 108]

Thus, rather than believe in working class self-emancipation, Lenin thought
the opposite. Without the radical bourgeois to provide the working class with
"socialist" ideas, a socialist movement, let along society, was impossible.
Hardly what you would consider self-emancipation. As Lenin put it:

> _"Since there can be no talk of an independent ideology being developed by
the masses of the workers in the process of their movement, **the only choice
is**: either bourgeois or socialist ideology. There is no middle course . . .
Hence, to belittle socialist ideology **in any way,** to **deviate from it in
the slightest degree** means strengthening bourgeois ideology. There is a lot
of talk about spontaneity, but the **spontaneous** development of the labour
movement leads to its becoming subordinated to bourgeois ideology . . . Hence
our task, the task of Social-Democracy, is to **combat spontaneity,** to
**divert** the labour movement from its spontaneous, trade unionist striving
to go under the wing of the bourgeoisie, and to bring it under the wing of
revolutionary Social-Democracy."_ [**Op. Cit.**, pp. 82-3]

As we discuss in [section H.5](secH5.md), this is a deeply anti-socialist
position which, due to its privileging of the party, creates the theoretical
justification for the anti-democratic actions of the Bolsheviks we sketched in
[section 8](append31.md#app8). This perspective states that the party has a
better understanding of what the interests of the people are than the people
themselves. If they reject the party then it means that they simply do not
understand their own class interests and so they have become _"declassed"_, to
use Lenin's term. The party, due to it being the repository of what socialism
is, then has the right -- the duty -- to ignore the masses for to do otherwise
_"means strengthening bourgeois ideology"_. That this is self-serving circular
logic is an understatement but it is self-serving circular logic which, in
revolutionary Russia, destroyed socialism in favour of state-capitalism and
party dictatorship.

For this notion of working class passivity is not confined to the "early"
Lenin of **What is to Be Done?** infamy (not that there is any evidence that
Lenin later repudiated the ideas expressed there -- see [section
H.5.4](secH5.md#sech54)). It can be found in his apparently more
"libertarian" work **The State and Revolution** which argues that _"we do not
indulge in 'dreams' of dispensing **at once** . . . with all subordination;
these anarchist dreams . . . are totally alien to Marxism . . . we want the
socialist revolution with human nature as it is now, with human nature that
cannot dispense with subordination, control and 'managers'"_ Nowhere is the
notion that working class people, during the process of mass struggle, direct
action and revolution, **revolutionises themselves** (see sections
[A.2.7](secA2.md#seca27) and [J.7.2](secJ7.md#secj72), for example).
Instead, we find a vision of people as they are under capitalism (_"human
nature as it is now"_) and no vision of self-emancipation of the working class
and the resulting changes that implies for those who are transforming society
by their own action. Perhaps it will be argued that Lenin sees
_"subordination"_ as being _"to the armed vanguard of all the exploited . . .
i.e., to the proletariat"_ and so there is no contradiction. However, this is
not the case as he confuses the rule of the party with the rule of the class:
_"We cannot imagine democracy, not even proletarian democracy, without
representative institutions."_ [**Op. Cit.**, p. 307 and p. 306]

Thus _"subordination"_ is **not** to the working class itself (i.e. direct
democracy or self-management). Rather it is the _"subordination"_ of the
majority to the minority, of the working class to "its" representatives. Thus
we have a vision of a "socialist" society in which the majority have not
revolutionised themselves and are subordinated to "their" party. Such a
subordination, however, ensures that a socialist consciousness **cannot**
develop as only the **process** of self-management generates the abilities
required for self-management (_"Only freedom or the struggle for freedom can
be the school for freedom."_ [Malatesta, **Errico Malatesta: His Life and
Ideas**, p. 59]). Lenin saw the revolution as the means by which the mass of
the people will recognise that the vanguard party represents their interests
and so vote it into power. However, as _"there can be no talk of an
independent ideology being developed by the masses of the workers in the
process of their movement"_ any clash between the party and masses simply mean
that the latter are wrong and _"the armed vanguard"_ needs _"to **combat
spontaneity**"_ \-- literally, as we showed in [section
H.6.3](secH6.md#sech63). As Lenin admitted in 1920:

> _"Without revolutionary coercion directed against the avowed enemies of the
workers and peasants, it is impossible to break down the resistance of these
exploiters. On the other hand, revolutionary coercion is bound to be employed
towards the wavering and unstable elements among the masses themselves."_
[**Collected Works**, vol. 42, p. 170]

As we indicate in [section H.3.8](secH3.md#sech38), this perspective meant
that Leninist theorists ended up arguing for a state separate from the working
class (a _"state in the proper sense of the word"_) rather than the semi-state
promised in such works as **The State and Revolution** (a work whose promises,
as we note in [section H.1.7](secH1.md#sech17), were forsaken completely
within six months of the Bolshevik seizure of power). This was required to
ensure that the party could _"combat"_ spontaneous movements in the working
class which questioned the privileged position of the party -- both
ideologically (in terms of its advanced ideas) and politically (its holding of
power). This privileged position for the party engenders a perspective which
can (and did) justify party dictatorship **over** the proletariat. Given
Lenin's position that the working class cannot formulate its own "ideology" by
its own efforts, of its incapacity to move beyond _"trade union
consciousness"_ independently of the party, the clear implication is that the
party could in no way be bound by the predominant views of the working class
as these are, **by definition** non-socialist, bourgeois even. As the party
embodies _"socialist consciousness"_ (and this arises outside the working
class and its struggles) then opposition of the working class to the party
signifies a failure of the class to resist alien influences, a failure that
the party must fight to ensure that this failure does not spread to the
revolution itself -- the proletariat, in short, must be repressed in its own
interests by the "proletarian" dictatorship.

Therefore McNally's comments that Leninism is a valid expression of Marx's
idea of proletarian self-emancipation is false. In reality, Lenin rejected the
idea that working class people can emancipate themselves and, therefore, any
claim that this tradition stands for proletarian self-emancipation is false.
Rather Leninism, for all its rhetoric, has no vision of working class self-
activity leading to self-liberation -- it denies it can happen and that is why
it stresses the role of the party and its need to take centralised power into
its own hands. Of course, it never entered Lenin's mind that if bourgeois
ideology imposes itself onto the working class it also imposes itself on the
party as well -- more so as they are bourgeois intellectuals in the first
place.

While anarchists are aware of the need for groups of like minded individuals
to influence the class struggle and spread anarchist ideas, we reject the idea
that such ideas have to be "injected" into the working class from outside.
Rather, as we argued in [section J.3](secJ3.md), anarchist ideas are
developed within the class struggle by working people themselves. Anarchist
groups exist because we are aware that there is an uneven development of ideas
within our class and to aid the spreading of libertarian ideas it is useful
for those with those ideas to work together. However, being aware that our
ideas are the product of working class life and struggle we are also aware
that we have to learn from that struggle. It is because of this that
anarchists stress self-management of working class struggle and organisation
from below (anarchists are, to use Bakunin's words, _"convinced that
revolution is only sincere, honest and real in the hands of the masses, and
that when it is concentrated in those of a few ruling individuals it
inevitably and immediately becomes reaction"_ [**Michael Bakunin: Selected
Writings**, p. 237]). Only when this happens can new ways of life be created
and truly develop freely. It also explains anarchist opposition to political
groups seizing power -- that will only result in old dogmas crushing the
initiative of people in struggle and the new forms of life they create. That
is why anarchists stress the importance of revolutionaries using _"natural
influence"_ (i.e. arguing their ideas in popular organisations and convincing
by reason) -- doing so allows new developments and ideas to be expressed and
enriched by existing ones and vice versa.

One last point. It could be argued that similar comments to Lenin's arguments
can be found in Marx and Engels and so Marxism **as such** rather than just
Leninism does not believe in proletarian self-emancipation. After all, had not
**The Manifesto of the Communist Party** proclaimed that _"a small section of
the ruling class cuts itself adrift, and joins the revolutionary class"_ and
this _"portion of the bourgeois ideologists"_ have _"raised themselves to the
level of comprehending theoretically the historical movement as a whole."_ In
addition, the Communists are _"the most advanced and resolute section of the
working-class parties"_ and _"they have over the great mass of the proletariat
the advantage of clearly understanding the line of march, the conditions, and
the general results of the proletarian movement"_. [**The Marx-Engels
Reader**, p. 481 and p. 484] This, needless to say, places _"bourgeois
ideologists"_ and party leaders (like Marx, Engels, Lenin and Trotsky) in a
privileged position within the party, labour movement and society as a whole.
Had not Marx and Engels argued in **The Holy Family** that the _"question is
not what this or that proletarian, or even the whole of the proletariat at the
moment **considers** as its aim. The question is **what the proletariat is**,
and what, consequent on that **being**, it will be compelled to do."_ [quoted
by Murray Bookchin, **The Spanish Anarchists**, p. 280] As Murray Bookchin
argued:

> _"These lines and others like them in Marx's writings were to provide the
rationale for asserting the authority of Marxist parties and their armed
detachments over and even against the proletariat. Claiming a deeper and more
informed comprehension of the situation than 'even the whole of the
proletariat at the given moment,' Marxist parties went on to dissolve such
revolutionary forms of proletarian organisation as factory committees and
ultimately to totally regiment the proletariat according to lines established
by the party leadership."_ [**Op. Cit.**, p. 289]

Unlike Lenin and Trotsky, Marx and Engels rarely drew the obvious conclusions
from their arguments (although their contempt for working class socialist
thinkers -- like Proudhon -- was legendary) but the elitism was there. It is
to Bakunin's merit that he recognised the danger long before the likes of
Lenin and Trotsky (see [section 15](append31.md#app15)) made it explicit.

## 12\. Why is Marxist "class analysis" of anarchism contradictory?

Another ironic aspect of McNally's pamphlet is its demonisation of anarchism
combined with praise for the Paris Commune and the Russian Soviets. This is
because key aspects of both revolutionary forms were predicted by Proudhon and
Bakunin. For example, McNally's and Marx's praise for revocable mandates in
the Commune was advocated by Proudhon in 1840s (see [section
4](append31.md#app4)). Bakunin also advocated this in the late 1860s along
with a federation of delegates from workplaces which showed a marked
similarity with the Russian soviets (see [section 5](append31.md#app5)).

Indeed, the Paris Commune (in both its economic and political aspects) showed
a clear inspiration from Proudhon's works. In the words of George Woodcock,
there are _"demands in the Commune's Manifesto to the French People of the
19th April, 1871, that might have been written by Proudhon himself."_
[**Pierre-Joseph Proudhon: A Biography**, p. 276] K. Steven Vincent also
points out that the declaration _"is strongly federalist in tone, and it has a
marked proudhonian flavour."_ [**Pierre-Joseph Proudhon and the Rise of French
Republican Socialism**, p. 232] Moreover, the desire to replace wage labour
with associated labour by the creation of co-operatives expressed during the
Commune clearly showed the influence of Proudhon. Marx mentions a _"rough
sketch of national organisation which the Commune had no time to develop"_ but
does not quote from it. [**The Marx-Engels Reader**, p. 633] This is perhaps
unsurprising as the Commune's declaration clearly shows its anarchist roots
and tendencies:

> _"The absolute autonomy of the Commune extended to all localities in France
and assuring to each one its full rights, and to every Frenchman the full
exercise of his faculties and abilities as man, citizen and producer._

> _"The only limit to the autonomy of the Commune should be the equal right to
autonomy for all communes adhering to the contract, whose association shall
insure French unity . . . The choice by election or competition of magistrates
and communal functionaries of all orders, as well as the permanent right of
control and revocation._

> _"The absolute guarantee of individual freedom and freedom of conscience._

> _"The permanent intervention of citizens in communal affairs by the free
manifestation of their ideas, the free defence of their interests . . . _

> _"The organisation of urban defence and the National Guard, which elects its
chiefs and alone watches over the maintenance of order in the city . . ._

> _"Paris wants nothing else as a local guarantee, on condition, of course, of
finding in the great central administration -- the delegation of federated
Communes -- the realisation and the practice of the same principles. But as an
element of its autonomy, and profiting by its freedom of action, within its
borders it reserves to itself the right to operate the administrative and
economic reforms called for by the populace as it wills; to create the
institutions needed to develop and spread instruction, production, exchange
and credit; to universalise power and property in keeping with the needs of
the moment, the wishes of those concerned and the facts furnished by
experience._

> _"Unity, as it has been imposed on us until today by the Empire, the
monarchy or parliamentarism is nothing but unintelligent, arbitrary or onerous
centralisation._

> _"Political unity, as Paris wants it, is the voluntary association of all
local initiatives, the spontaneous and free concourse of all individual
energies in view of a common goal: the well-being, the freedom and the
security of all._

> _"The communal revolution, begun by popular initiative on March 18, begins a
new era of experimental, positive, scientific politics._

> _"It is the end of the old governmental and clerical world, of militarism
and bureaucracy, of exploitation, speculation, monopolies and privileges to
which the proletariat owe their servitude and the Fatherland its misfortunes
and disasters."_ [_"Declaration to the French People"_, pp. 789-791,
**Property is Theft!**, pp. 789-790]

The links with Proudhon's ideas cannot be clearer. Little wonder, then, that
during the Commune anarchist James Guillaume stated that _"the Paris
Revolution is federalist . . . in the sense given it years ago by the great
socialist, Proudhon."_ It is _"above all the negation of the nation and the
State."_ [contained in **The Paris Commune of 1871: The View From the Left**,
Eugene Schulkind (ed.), p. 191] Bakunin, for his part, rightly argued that its
_"general effect was so striking that the Marxists themselves, who saw their
ideas upset by the uprising, found themselves compelled to take their hats off
to it. They went further, and proclaimed that its programme and purpose where
their own, in face of the simplest logic . . . This was a truly farcical
change of costume, but they were bound to make it, for fear of being overtaken
and left behind in the wave of feeling which the rising produced throughout
the world."_ [**Michael Bakunin: Selected Writings**, p. 261]

To see why, we need simply to compare Marx's reporting of the Commune with
Proudhon's words. Marx stated, correctly, that the Commune _"was formed of the
municipal councillors, chosen by universal suffrage in the various wards of
the town, responsible and revocable at short terms"_ and was _"a working, not
a parliamentary, body, executive and legislative at the same time"_. The
delegates would _"revocable and bound by the **mandat imperatif** (formal
instructions) of his constituents"_ [**The Marx-Engels Readers**, p. 632 and
p. 633] As well as arguing that _"federalism is the political form of
humanity"_, Proudhon also argued that the _"legislative power is not
distinguished from the executive power."_ [**Property is Theft!**, p. 678 and
p. 674] As he put it in 1848:

> _"It is up to the National Assembly, through organisation of its committees,
to exercise executive power, just the way it exercises legislative power . . .
Besides universal suffrage and as a consequence of universal suffrage, we want
implementation of the imperative mandate [**mandat impératif**]. Politicians
balk at it! Which means that in their eyes, the people, in electing
representatives, do not appoint mandatories but rather abjure their
sovereignty! That is assuredly not socialism: it is not even democracy."_
[**Op. Cit.**, pp. 378-9]

This applies to the economic goals of the Commune, with Marx suggesting that
it _"wanted to make individual property a truth by transforming the means of
production, land, capital, now chiefly the means of enslaving and exploiting
labour, into mere instruments of free and associated labour"_ and _"this is
Communism"_. Engels, twenty years later, painted a picture of Proudhon being
opposed to association (except for large-scale industry) and stated that _"to
combine all these associations in one great union"_ was _"the direct opposite
of the Proudhon doctrine"_ and so _"the Commune was the grave of the Proudhon
school of socialism."_ [**Op. Cit.**, p. 635 and p. 626] Yet they must have
been aware of Proudhon's support for large-scale industry and workers
associations ([section 4](append31.md)) as expressed, for example, in his
1863 call for an _"agricultural-industrial federation"_ or his 1846 comment
that _"to unfold the system of economic contradictions is to lay the
foundations of universal association"_ [**Op. Cit.**, p. 712 and p. 179] As he
put it in 1848:

> _"under universal association, ownership of the land and of the instruments
of labour is **social** ownership . . . We want the mines, canals, railways
handed over to democratically organised workers’ associations . . . We want
these associations to be models for agriculture, industry and trade, the
pioneering core of that vast federation of companies and societies woven into
the common cloth of the democratic and social Republic."_ [**Op. Cit.**, pp.
777-8]

Given that Marx described the Commune as _"essentially a working-class
government"_, _"the political form at last discovered under which to work out
the economic emancipation of labour"_ and _"will be for ever celebrated as the
glorious harbinger of a new society"_, it is strange that McNally terms
Proudhon's and Bakunin's ideas as those of the past. [**Op. Cit.**, pp. 634-5
and p. 652] It seems the height of hypocrisy for McNally to attack Proudhon
while praising the Paris Commune.

So the awkward fact is that anarchists had been advocating these forms since
Proudhon in the 1840s and they were developed by Bakunin in the 1860s. Nothing
similar can be found in Marx until the Commune which suggests, as Anarchist
K.J. Kenafick stated, _"that the programme [the Commune] set out is . . . the
system of Federalism, which Bakunin had been advocating for years, and which
had first been enunciated by Proudhon. The Proudhonists . . . exercised
considerable influence in the Commune. This 'political form' was therefore not
'at last' discovered; it had been discovered years ago; and now it was proven
to be correct by the very fact that in the crisis the Paris workers adopted it
almost automatically, under the pressure of circumstance, rather than as the
result of theory, as being the form most suitable to express working class
aspirations."_ [**Michael Bakunin and Karl Marx**, pp. 212-3]

Little wonder few Marxists (like Marx himself) directly quote from the
Commune's declaration. It would be difficult to attack anarchism (as "petty-
bourgeois") while proclaiming the Paris Commune as the first example of _"the
dictatorship of the Proletariat."_ The decentralised, federalist nature of the
Commune cannot be squared with the usual Marxist instance on centralisation
and the claim that federalism _"as a principle follows logically from the
petty-bourgeois views of anarchism. Marx was a centralist"_ and to _"confuse
Marx's views . . . with Proudhon's federalism is positively monstrous!"_ While
there may be _"not a trace of federalism"_ in Marx's _"observations on the
experience of the Commune"_, the Commune **itself** was distinctly federalist
in its aspirations. If Marx _"upheld democratic centralism, the republic --
one and indivisible"_ the same cannot be said of the Communards themselves.
[Lenin, _"The State and Revolution"_, **The Lenin Anthology**, p. 348, p. 347
and p. 361] As Paul Avrich noted, the _"influence of Proudhon --
unquestionably greater than that of Marx -- was reflected in the title of
'Federals' by which the Communards were known."_ [**Anarchist Portraits**, p.
232]

This is not to suggest that the Commune was a perfect example of anarchism in
action -- far from it. As we indicate in [section A.5.1](secA5.md#seca51),
while it wished federalism outside of Paris it was not federalist within its
boundaries. If, as Marx put it, _"the Paris Commune took the management of the
revolution in its own hands"_ then its structure simply was not up to its
tasks. [**Op. Cit.**, p. 636] As Bakunin put it, while the Commune was _"a
bold and outspoken negation of the State"_, the Communards had set up _"a
revolutionary government"_ within Paris and so organised _"themselves in
reactionary Jacobin fashion, forgetting or sacrificing what they themselves
knew were the first conditions of revolutionary socialism"_, rather than _"by
the free association or federation of workers, firstly in their unions, then
in the communes, regions, nations and finally in a great federation,
international and universal"_ organised _"solely from the bottom upwards."_
[**Michael Bakunin: Selected Writings**, p. 199, p. 202 and p. 206] Building
on Bakunin's comments, Kropotkin argued that while _"proclaiming the free
Commune, the people of Paris proclaimed an essential anarchist principle"_ but
_"they stopped mid-course"_ and gave _"themselves a Communal Council copied
from the old municipal councils."_ Thus the Paris Commune did not _"break with
the tradition of the State, of representative government, and it did not
attempt to achieve within the Commune that organisation from the simple to the
complex it inaugurated by proclaiming the independence and free federation of
the Communes."_ Kropotkin continually stressed that the revolutionaries were
isolated from the masses and shut-up in the town hall which lead to disaster
as the Commune council became _"immobilised . . . by red tape"_ and lost _"the
sensitivity that comes from continued contact with the masses . . . Paralysed
by their distancing from the revolutionary centre –- the people -– they
themselves paralysed the popular initiative."_ [**Words of a Rebel**, p. 97,
p. 93 and p. 97]

So the Commune applied aspects of anarchism but not all. However, the main
thrust of the revolt was federalist in nature -- something Marxists tend to
forget to mention. Anarchists argued that the Commune should have rejected the
Municipal Council and instead organised a workers' council. Anarchist ideas,
then, as can be seen from the Paris Commune and the soviets were the ideas
**of the future** \-- and of working class self-liberation and self-
organisation. And ones that Marx and his followers paid lip service to.

(We say lip service for Marx's praise for the Commune did not stop him
recommending the labour movement to stand candidates in national elections nor
did Lenin quoting Marx's statement that the future proletarian state, like the
Paris Commune, would abolish the distinction between executive and
administrative powers mean he honoured it. Immediately after the October
Revolution the Bolsheviks established an executive power **above** the
soviets, namely the Council of People's Commissars. Those who quote Lenin's
**The State and Revolution** as proof of his democratic nature usually fail to
mention this little fact. In practice that work was little more than an
election manifesto to be broken as required, as we shown in [section
H.1.7](secH1.md#sechh17))

In fact, the Paris Commune was primarily the work of artisans (the bulk of the
Parisian workers at the time). This is reflected in Marx's comments in 1866
that the French workers were _"corrupted"_ by Proudhon's _"sham criticism and
sham opposition to the Utopians (he himself is only a petty-bourgeois utopian
. . .)"_, _"particularly those of Paris, who as workers in luxury trades are
strongly attached, without knowing it [!], to the old rubbish."_ The
_"Parisian gentlemen had their heads full of the emptiest Proudhonist
phrases"_ and so _"Proudhon did enormous mischief."_ [Marx, Engels and Lenin,
**Anarchism and Anarcho-syndicalism**, pp. 45-6] Five years later, these
workers (still obviously influenced by _"the old rubbish"_ and their heads
still full of _"Proudhonist phrases"_) created _"the political form"_ of _"the
economic emancipation of labour."_ This is not explained by Marxists, who also
do not trouble themselves to explain how can the Paris Commune be the
_"Dictatorship of the Proletariat"_ when 35 members of the Commune's council
were artisans and only 4 or 5 were industrial workers (i.e. proletarians).

Can the fact that Proudhon-influenced artisans were, according to McNally and
Marx, social strata of the past, were backward looking, etc. be reconciled
with the claim that the Paris Commune was the political form of proletarian
emancipation? No, not from a Marxist class analysis. Hence Marxists ignoring
the real nature of the Parisian working class when discussing the commune.
However, from an anarchist perspective -- which sees the artisan, peasant and
proletariat forming a common class of working people -- the development of the
Paris Commune is no surprise. It is the work of people seeking to end wage
labour and the threat of wage labour **now** rather than sometime in the
future once capitalism has fully developed. Thus McNally's (and Marx's)
support for the Commune makes a mockery of his attacks on anarchism as the
theory of the artisans and peasants for it was the artisans who created the
first model of their _"proletarian"_ state and applied what they say they
consider the foundations of _"proletarian"_ democracy -- electing mandated and
recallable delegates. That the "petty-bourgeois" Proudhon advocated this 23
years before Marx did is, of course, left unsaid.

As indicated, McNally's arguments do not hold water. Ironically, if anarchism
was the death-cry of the artisan and peasant then it is strange, to say the
least, that this theory so influenced the Paris Commune which McNally praises
so much. We therefore suggest that rather than being a backward-looking cry of
despair for those disappearing under the wheels of rising capitalism,
anarchism was in fact a theory developed from the struggles and self-activity
of those currently suffering capitalist and state oppression -- namely the
artisans, peasants **and** industrial proletariat (i.e. the working class as a
whole). In other words, it is a philosophy and theory for the future, not of
the past. This can be seen from the libertarian aspects of the Paris Commune,
aspects Marx immediately tried to appropriate for his own theories (which,
unfortunately, were swamped by the authoritarian elements that existed
already).

In addition the _"old rubbish"_ the Parisian workers supported was very much
ahead of its time. In 1869 the delegate of the Parisian Construction Workers'
Trade Union argued that _"[a]ssociation of the different corporations [labour
unions] on the basis of town or country . . . leads to the commune of the
future . . . Government is replaced by the assembled councils of the trade
bodies, and by a committee of their respective delegates."_ In addition, _"a
local grouping which allows the workers in the same area to liaise on a day to
day basis"_ and _"a linking up of the various localities, fields, regions,
etc."_ (i.e. international trade or industrial union federations) would ensure
that _"labour organises for present and future by doing away with wage
slavery."_ [**No Gods, No Masters**, vol. 1, p. 184] Such a vision of workers'
councils and associated labour has obvious similarities with the spontaneously
created soviets of the 1905 Russian Revolution. These, too, were based on
assembled councils of workers' delegates. Of course they were differences but
the basic idea and vision are identical.

Therefore to claim that anarchism represents the past presents Marxists with a
few problems given the nature of the Paris Commune and its obvious libertarian
nature. If it is claimed that the Parisian artisans defended _"not their
present, but their future interests"_ and so _"desert[ed] their own standpoint
to place themselves at that of the proletariat"_ (the class they are being
_"tranfer[ed]"_ into by the rise of capitalism) then, clearly, anarchist ideas
are _"future,"_ proletarian, ideas as it is that class interest artisans serve
_"[i]f by chance they are revolutionary."_ [Marx and Engels, _"The Communist
Manifesto"_, **The Marx-Engels Reader**, p. 482]

Whichever way you look at it, McNally's claims on the class nature of
anarchism do not stand up to close analysis. Proudhon addressed both
artisan/peasant and wage-worker in his works. He addressed both the current
and the future working class. Bakunin did likewise. Moreover, both were part
of the workers movement. Proudhon was working class, the son of an artisan and
peasant who was a printer by trade, and took part in the debates and polemics
of the French socialist movement as well as the 1848 Revolution. Bakunin
joined the First International, taking an active part in its debates and
championing the syndicalist ideas which had evolved from Proudhon's mutualism
in France, Belgium, Spain and Italy. As Paul Avrich suggests, as _"early as
the 1860's and 1870's, the followers of Proudhon and Bakunin in the First
International were proposing the formation of workers' councils designed both
as a weapon of class struggle against capitalists and as the structural basis
of the future libertarian society"_ [**The Russian Anarchists**, p. 73]
Therefore it is not surprising that Proudhon and Bakunin predicted aspects of
the Paris Commune -- they were expressing the politics of the future. As is
clear from their writings, which still remain fresh today.

This is reflected in another comment by McNally, who writes that _"all major
trends in Russian socialism had believed that a bourgeois democratic
revolution -- a revolution against Czarism and for the establishment not of
socialism but merely of liberal capitalism -- would have to precede a workers'
revolution in Russia. In 1906, Leon Trotsky developed a dissenting view. Only
the working class of Russia, Trotsky argued, would be willing and able to
carry through the fight for democratic reforms and for a democratic republic.
But why, he asked, should the workers be expected to stop at that point? Why
should they not extend the fight for democratic rights into a struggle for
workers' control and socialist democracy?"_ In reality, the idea that working
people should extend a revolution from political to economic goals was raised
by both Proudhon and Bakunin long before Trotsky and, moreover, was advocated
by Kropotkin the year before Trotsky introduced it into Marxism.

Thus Proudhon argued that the 1848 revolution _"had been made 'without an
idea' and that it had unfortunately satisfied itself with the proclamation of
purely political palliatives"_ and _"he did not believe that such political
reforms would solve the social problem."_ [K. Steven Vincent, **Op. Cit.**, p.
169] Bakunin took up, as with so many other things, Proudhon's argument and,
as we discuss in [section H.1.1](secH1.md#sech11), a key part of Bakunin's
critique of Marxism was precisely that it looked to political change before
social and economic transformation, the latter coming as a result of
"political action" allowed by the previous political revolution. Thus _"[t]o
win political freedom first can signify no other thing but to win this freedom
only, leaving for the first days at least economic and social relations in the
same old state, -- that is, leaving the proprietors and capitalists with their
insolent wealth, and the workers with their poverty."_ [**The Political
Philosophy of Bakunin**, p. 294] This meant that anarchists aimed to ensure
any revolution was _"simultaneously universal, social, philosophical, economic
and political revolution"_. The _"revolution as we understand it will . . .
set about the . . . complete destruction of the State . . . The natural and
necessary upshot of that destruction"_ will include the _"[d]issolution of the
army, magistracy, bureaucracy, police and clergy"_ and _"[a]ll productive
capital and instruments of labour . . . be[ing] confiscated for the benefit of
toilers associations, which will have to put them to use in collective
production"_ as well as the _"[s]eizure of all Church and State properties."_
The _"federated Alliance of all labour associations . . . will constitute the
Commune."_ The people _"must make the revolution everywhere, and . . .
ultimate direction of it must at all times be vested in the people organised
into a free federation of agricultural and industrial associations . . .
organised from the bottom up."_ [**No Gods, No Masters**, vol. 1 pp. 152-6]
This was echoed by Kropotkin in 1905:

> _"The Russian people -- the working men -- having compelled the autocrat to
abdicate his despotic power, must compel him now to give body to his
abdication by sending away the troops upon which rest his power and the power
of bureaucracy, the power of unbridled capitalism._

> _"The people must arm itself; otherwise the Tsar, the bureaucrats and the
capitalists will crush it down . . . the Russian working men must not forget
**their own demands**. To guarantee the individual against police
arbitrariness is necessary for all. But he who works and produces riches with
his own hands requires something else. . . . If you are compelled tomorrow,
after the Constitution has been proclaimed, to return to the factories the
same slaves as you have been before, then you will have been betrayed . . ._

> _"Don't expect anything from would-be saviours. But in every factory, every
building yard, every workshop, and every mine, **establish yourselves the
order of things which, by common accord, you will find proper to establish**.
But remember this: Don't allow others to interfere! It is **your** affair, and
**you** have to settle it._

> _"**Accomplish yourselves a revolution in the organisation of labour as you
have accomplished it in the general administration of the Russian State.**_

> _"Don't trust those who will tell you: 'Not yet! It is too soon!' No, it is
not too soon; it is just the time for it."_ [_"The Revolution in Russia"_,
**Direct Struggle Against Capital**, pp. 456-7]

As with the Paris Commune and the soviets, yet another key aspect of McNally's
Marxism was first advocated by anarchists. As Emma Goldman noted in 1918, the
Bolsheviks where _"adopting Anarchist Revolutionary tactics"_ and, unlike in
1905, in 1917 they _"no longer believe"_ that _"the industrialisation of
Russia and the historic mission of the bourgeoisie as a necessary evolutionary
process before the Russian masses could come into their own"_ and now accepted
_"the point of view held by the Anarchists since Bakunin; namely, that once
the masses become conscious of their economic power, they make their own
history"_ and so revolution _"means a fundamental social and economic change,
something which has its roots in the needs and hopes of the people and which
must not end until the disinherited of the earth come into their own. In a
word, the Russian people saw in the overthrow of the autocracy the
**beginning** and not the **finale** of the Revolution."_ For the toiler, the
Russian Revolution _"can mean nothing . . . unless it sets the land fee and
joins to the dethroned Tsar his partner, the dethroned land-owner, the
capitalist."_ [_"The Truth About the Bolsheviki"_, **Writings of Emma
Goldman**, p. 163 and p. 165]

So when Victor Serge, like McNally, stated that by concluding the _"self-
evident truth"_ that _"the Russian Revolution cannot confine itself to
changing the political order"_ in 1917 but that it had to take in _"a social
character"_ by expropriating capital and land he was unknowingly _"on the
line"_ advocated by Lenin we must remember that this was not _"the line"_
pioneered by Trotsky but rather the one raised by Kropotkin and other
anarchists during the 1905 revolution (and rejected at the time by all
Marxists) **and** that this had been argued for since the late 1860s by
Bakunin and other libertarians. [**Memoirs of a Revolutionary**, p. 60]

This confusion associated with Marxist "class analysis" of anarchism was also
present in Lenin. Given that anarchism is apparently associated with the
petty-bourgeois we find a strange contradiction in Lenin's work. On the one
hand Lenin argued that Russia _"despite the more petty-bourgeois composition
of her population as compared with the other European countries"_ anarchist
influence was _"negligible during the two revolutions (of 1905 and 1917)"_.
The lack of influence in Russia, he claimed, was due to Bolshevism having
_"waged a most ruthless and uncompromising struggle against opportunism"_ for
anarchism was _"a penalty for the opportunist sins of the working-class
movement."_ On the other he admitted that, in the developed capitalist
nations, syndicalism was _"a profoundly proletarian and mass movement"_ and
that it is _"the duty of all Communists to do everything to help all
proletarian mass elements to abandon anarchism . . . the measure in which
genuinely Communist parties succeed in winning mass proletarian elements . . .
away from anarchism, is a criterion of the success of those Parties."_
[**Collected Works**, vol. 31, p. 31, p. 32, p. 200 and p. 201]

Thus, in the most capitalist nations, ones with a more widespread and
developed proletariat, the anarchist and syndicalist movements were more
firmly developed and had closer connections with the masses than in Russia.
Moreover, these movements were also quite revolutionary as well and should be
won to Bolshevism. But anarchism is the politics of the petit-bourgeois and so
should have been far smaller in Western countries than in Russia due to the
larger numbers of artisans and peasants in the latter. The opposite was the
case, thus suggesting that Lenin's analysis is wrong.

We can point to another explanation of these facts. Rather than the Bolsheviks
_"struggle against opportunism"_ being the reason why anarchism was
_"negligible"_ in 1917-18 in Russia (it was not, in fact) but had mass appeal
in Western Europe perhaps it was the fact that anarchism was a product of
working class struggle in advanced capitalist countries while Bolshevism was a
product of **bourgeois** struggle (for Parliament, a liberal republic, etc.)
in Tsarist Russia? Similarly, perhaps the reason why Bolshevism did not
develop the same opportunist tendencies as in other Social-Democratic
movements was because it did not work in an environment which encouraged them.
After all, unlike the German Social Democrats, the Bolsheviks were illegal for
long periods of time and worked in an absolutist monarchy. The influences that
corrupted the German Social Democrats were not at work in the Tsarist regime
simply because there was no genuine Parliamentarianism for the party to get
corrupted by. Thus, Bolshevism, perhaps at best, was applicable to Tsarist
conditions and anarchism to Western ones.

However, contrary to Lenin, Russian anarchism was far from _"negligible"_
during 1917-18 and was growing in influence within the Russian working class
which was the real reason why the Bolsheviks suppressed them **before** the
start of the civil war. As Emma Goldman noted, a claim such as Lenin's _"does
not tally with the incessant persecution of Anarchists which began in [April]
1918, when Leon Trotsky liquidated the Anarchist headquarters in Moscow with
machine guns. At that time the process of elimination of the Anarchists
began."_ [_Trotsky Protests Too Much"_, **Writings of Emma Goldman**, p. 265]
This fact of anarchist influence during the revolution does not contradict our
earlier analysis. This is because the Russian anarchists, rather than
appealing to the petit-bourgeois, were influencing exactly the same workers,
sailors and soldiers the Bolsheviks were. Indeed, the Bolsheviks often had to
radicalise their activities and rhetoric to counter anarchist influence. As
Alexander Rabinowitch in his study of the July uprising of 1917 notes:

> _"At the rank-and-file level, particularly within the [Petrograd] garrison
and at the Kronstadt naval base, there was in fact very little to distinguish
Bolshevik from Anarchist . . . The Anarchist-Communists and the Bolsheviks
competed for the support of the same uneducated, depressed and dissatisfied
elements of the population, and the fact is that in the summer of 1917, the
Anarchist-Communists, with the support they enjoyed in a few important
factories and regiments, possessed an undeniable capacity to influence the
course of events. Indeed, the Anarchist appeal was great enough in some
factories and military units to influence the actions of the Bolsheviks
themselves."_ [**Prelude to Revolution**, p. 64]

This is hardly what would be expected if anarchism was "petit-bourgeois" as
Marxists assert.

It could, in fact, be argued that the Bolsheviks gained the support of so many
workers during the summer of 1917 **because they sounded and acted like
anarchists** and **not** like Marxists and lost it, by the summer of 1918,
because, once in power, they reverted to acting like Marxists and their
centralised policies were simply not solving the problems facing the
revolution. At the time many considered the Bolsheviks as anarchists and one
fellow Marxist (an ex-Bolshevik turned Menshevik) thought Lenin had _"made
himself a candidate for one European throne that has been vacant for thirty
years -- the throne of Bakunin!"_ [quoted by Rabinowitch, **Op. Cit.**, p. 40]
As Alexander Berkman argued, the _"Anarchist mottoes proclaimed by the
Bolsheviks did not fail to bring results. The masses relied to their flag."_
[**What is Anarchism?**, p. 120] Indeed, as we note in [section
H.5.12](secH5.md#sech512), the Bolshevik party in the summer of 1917 was far
from the disciplined vanguard party of Leninist myth and far more like a
federation of local groups which could -- and did -- ignore the party's
central committee and its conservatism. It was in 1918, faced with the
realities of holding state power in the face of popular discontent and
counter-revolution that Lenin's long desired model of a centralised, top-down,
disciplined party came to be -- a development which contributed to the
degeneration of the regime away from socialism and towards state capitalism.

Moreover, this stealing of anarchist slogans and tactics in 1917 was
**forced** upon the Bolsheviks by the working class. On Lenin's own admission,
the masses of peasants and workers were _"a hundred times further to the
left"_ than the Bolsheviks. Trotsky himself notes that the Bolsheviks _"lagged
behind the revolutionary dynamic . . . The masses at the turning point were a
hundred times to the left of the extreme left party."_ [**History of the
Russian Revolution**, Vol. 1, p. 403f] Indeed, one leading Bolshevik stated in
June 1917 (in response to a rise in anarchist influence), _"[b]y fencing
ourselves off from the Anarchists, we may fence ourselves off from the
masses."_ [quoted by Rabinowitch, **Op. Cit.**, p. 102] That, in itself,
indicates the weakness of Lenin's class analysis of anarchism.

Rather than the Russian experience refute the claim that anarchism is a
working class theory, it reinforces it -- the Bolsheviks would not have
succeeded if they had used traditional Marxist slogans and tactics (as was the
fate of the Mensheviks). Instead, much to the dismay of their more orthodox
comrades, the Bolsheviks embraced traditional anarchist ideas and tactics and
thereby gained increased influence in the working class. After the Bolshevik
seizure of power in the name of the soviets, anarchist influence increased as
more working people recognised that what the Bolsheviks meant by their slogans
was different than what working people thought they meant (see [section
A.5.4](secA5.md#seca54)). So the experience of the Russian Revolution re-
enforces the fact that Marxist "class analysis" of anarchism fails to
convince. Far from proving that libertarian socialism is non-proletarian, that
Revolution proved that it was: just as it confirmed the prophetic correctness
of the views of the founders of anarchism and, in particular, their critique
of Marxism.

To conclude, the usual Marxist "class analysis" of anarchism is somewhat
confused. On the one hand, it claims that anarchism is backward looking and
the politics of the petit-bourgeois being destroyed by the rise and
development of capitalism. On the other hand Marxists point to events and
organisations created in working class struggle which were predicted and/or
influenced by **anarchist** ideas and ideals, **not** Marxist ones. That
indicates better than any other argument that Marxists are wrong about
anarchism and their "class analysis" nothing more than distortions and
bigotry. Based on the evidence and the contradictions it provokes in Marxist
ideology, we have to argue that McNally is simply wrong. Rather than being an
ideology of the petit-bourgeois anarchism is, in fact, a political theory of
the working class (artisans, peasants and proletariat). Rather than a backward
looking theory, anarchism is a theory of the present and future -- it has a
concrete and radical critique of current society, a vision of the future and a
theory how to get there which appeals to working people in struggle. Such is
obviously the conclusion when you read anarchist theory and see how Marxists
have appropriated aspects of it which they had previously denounced. Sadly, as
we note in [section H.3.5](secH3.md#sech35), this appropriation has been
selective and had not made Leninism any more libertarian, its pre-revolution
rhetoric aside.

## 13\. If Marxism is _"socialism from below,"_ why do anarchists reject it?

McNally claims that Marxism is _"socialism from below."_ In his text he
indicates support for the Paris Commune and the soviets of the Russian
Revolution. He states that the _"democratic and socialist restructuring of
society remains . . . the most pressing task confronting humanity. And such a
reordering of society can only take place on the basis of the principles of
socialism from below. Now more than ever, the liberation of humanity depends
upon the self-emancipation of the world working class. . . The challenge is to
restore to socialism its democratic essence, its passionate concern with human
freedom."_

So, if this is the case, why the hostility between anarchists and Marxists?
Surely it is a question of semantics? No, for while Leninists pay lip-service
to such developments of working class self-activity and self-organisation as
workers' councils (soviets), factory committees, workers' control, revocable
and mandated delegates they do so in order to ensure the election of their
party into positions of power (i.e. the government). Rather than see such
developments as working people's **direct** management of their own destinies
and as a means of creating a self-managed (i.e. free) society as anarchists
do, Leninists see them as a means for their party to take over state power.
Nor do they see them as a framework by which working class people can take
back control of their own lives. Rather, they see them, at best, as typical
bourgeois forms -- namely the means by which working people can delegate their
power to a new group of leaders, i.e. as a means to elect a socialist
government into power. The nature of the regimes they wish to create are
centralised in nature, so reducing meaningful democracy to picking a few
leaders and, even worse, producing the natural conditions under which a
bureaucracy can flourish -- both conditions for creating a new ruling elite
(the bureaucracy).

This attitude can be seen from Lenin's perspectives on the Russian soviets
during the 1905 Russian Revolution. Rather than seeing them as a means of
working class self-government, he saw them purely as a means of gaining
influence for his party:

> _"the Party . . . has never renounced its intention of utilising certain
non-party organisations, such as the Soviets of Workers' Deputies . . . to
extend Social-Democratic influence among the working class and to strengthen
the Social-Democratic labour movement . . . the incipient revival creates the
opportunity to organise or utilise non-party working-class institutions, such
as Soviets . . . for the purpose of developing the Social-Democratic movement;
at the same time the Social-Democratic Party organisations must bear in mind
if Social-Democratic activities among the proletarian masses are properly,
effectively and widely organised, such institutions may actually become
superfluous."_ [**Collected Works**, vol. 12, pp. 143-4]

Such a perspective indicates well the difference between anarchism and
Leninism. Anarchists do not seek power for their own organisations. Rather
they see self-managed organisation created by working class people in struggle
as a means of eliminating hierarchy within society, of directly involving the
mass of people in the decisions that affect them. In other words, as a means
of creating the organisations through which people can change both themselves
and the world by their own direct action and the managing of their own
struggles, lives, communities and workplaces. Leninists view working class
self-organisation as a means of gaining power for their own party (which they
identify with the power of the working class -- see [section
H.3.11](secH3.md#sech311)). Mass organisations, which could be schools for
self-management and freedom, are instead subjected to an elitist leadership of
intellectual ideologues. The party soon substitutes itself for the mass
movement, and the party leadership substitutes itself the party. This is the
inevitable result of a vision of socialism rooted in being _"fully and
unreservedly in favour of a strong state power and of centralism."_ [**Op.
Cit.**, vol. 26, p. 116]

Lenin's view of the soviets was instrumental: he regarded them merely as a
means of getting the workers to support the Bolshevik Party and ensuring his
party seized state power. Indeed, he constantly confused soviet power with
party power, seeing the former as the means to the latter and the latter as
the key to creating socialism (see [section H.3.11](secH3.md#sech311)).
Given his vanguardist ideology (see [section H.5](secH5.md)) this is
unsurprising and, indeed, understandable -- flawed assumptions will produce
incorrect conclusions. What is missing from his vision is the idea of
socialism as being based on working class self-activity, self-management,
self-government and, ultimately, self-emancipation ([section
11](append31.md#app11) refutes McNally's claims that Leninism is based on
working class self-emanicipation). _"Lenin"_ as one historian concluded,
_"believed that the transition to socialism was guaranteed ultimately, not by
the self-activity of workers, but by the 'proletarian' character of state
power."_ [A. S. Smith, **Red Petrograd**, pp. 261-2] Worse, the 'proletarian'
character of the state was determined by the party in government and, as we
indicated in [section 8](append31.md#app8), the party determined what was
and was not "proletarian" so allowing -- indeed, justifying -- party
dictatorship. This gap in his politics, this confusion of party with class,
helped undermine the revolution and create the dictatorship of the
bureaucracy. Little wonder that by the end of 1918, the Bolsheviks ruled the
newly established soviet state entirely alone and had turned the soviets into
docile instruments of their party apparatus rather than forms of working class
self-government. Perhaps needless to say, this reality came to be reflected in
Bolshevik ideology and the assertion that a socialist revolution required a
party dictatorship was embedded into it at this time -- where it remained
(Trotsky, for example, arguing this position throughout the 1920s and 1930s,
as shown in [section 15](append31.md#app15)).

So despite its radical language, Leninism is totally opposed to the nature of
revolt and rebellion. It seeks to undermine what makes these activities and
the organisations they create potentially revolutionary (their tendencies
towards self-management, decentralisation, solidarity, direct action, free
activity and co-operation) by using them to build the party and, ultimately, a
centralised, hierarchical state structure on the corpse of these once
revolutionary forms of working class self-organisation and self-activity. This
applies both to the social organisations of the working class **and** to their
economic ones as Leninists view nationalisation (i.e., state ownership and
control) as the basis of socialism rather than, as anarchists do,
socialisation and workers self-management of production. The Leninist position
can only produce a new ruling class (the bureaucracy) in a new class system
(state capitalism). As Kropotkin predicted:

> _"The state organisation, having always been . . . the instrument for
establishing monopolies in favour of the ruling minorities, cannot be made to
work for the destruction of these monopolies. The anarchists consider,
therefore, that to hand over to the state all the main sources of economical
life -- the land, the mines, the railways, banking, insurance, and so on -- as
also the management of all the main branches of industry, in addition to all
the functions already accumulated in its hands (education, state-supported
religions, defence of the territory, etc.), would mean to create a new
instrument of tyranny. State capitalism would only increase the powers of
bureaucracy and capitalism. True progress lies in the direction of
decentralisation, both **territorial** and **functional**, in the development
of the spirit of local and personal initiative, and of free federation from
the simple to the compound, in lieu of the present hierarchy from the centre
to the periphery."_ [**Direct Struggle Against Capital**, pp. 164-5]

While Leninists point to Lenin's **The State and Revolution** as proof of
Leninism's "socialism from below" credentials, anarchists note that, firstly,
its promises were either not applied or quickly abandoned and, secondly, its
vision of socialism is impoverished. As we discuss the first objection in
[section H.1.7](secH1.md#sech17), we will note here that Lenin's work
postulated a centralised proletarian state rooted in representative rather
than delegate institutions as well as a "socialism" modelled on capitalist
institutions which the workers were expected to "control" rather than self-
management of production. Thus Lenin's pointing to the postal service, in
which workers are usually employed by the State under capitalism, as _"an
example of the socialist economic system"_ and argued that we needed to
_"organise the whole economy on the lines of the postal service"_ simply
transferred economic power to the state bureaucracy. [**Collected Works**,
vol. 25 pp. 426-7] Anarchists, in contrast, argue that working class bodies
like trade unions must take into their _"hands the management of production"_
and co-operatives _"for production and for distribution, both in industry and
agriculture"_ were expressing aspects of _"communist society"_ for _"Socialist
forms of life could find a much easier realisation"_ by means of these bodies
_"than by a State organisation"_. [**The Conquest of Bread**, pp. 22-23] As
Maurice Brinton documents in great detail in his classic **The Bolsheviks and
Workers' Control**, the Leninist vision of socialism was never based on
workers management of the economy (see [section H.3.14](secH3.md#sech314)).
Politically, the Bolsheviks placed an executive power (their own) over the
soviets and so centralised power into the hands of a few party leaders.

So as well as differences in the **political** nature of a socialist society,
the role of organisations created in, by and for the class struggle and the
nature of socialist organisation, anarchists and Marxists disagree with the
**economic** nature of the future society. McNally claims that in Russia
_"[c]ontrol of the factories was taken over by the workers"_ but this is a
total distortion of what actually happened. Throughout 1917, it was the
workers themselves, **not** the Bolshevik Party, which raised the issue of
workers' self-management and control. As S.A. Smith puts it, the _"factory
committees launched the slogan of workers' control of production quite
independently of the Bolshevik party. It was not until May that the party
began to take it up."_ [**Op. Cit.**, p. 154] Given that the defining aspect
of capitalism is wage labour, the Russian workers' raised a clearly socialist
demand that entailed its abolition. It was the Bolshevik party, we must note,
who failed to raise above a _"trade union conscious"_ in this and so many
other cases and, worse, they hindered the movement of workers trying to
control, and then manage, the factories they worked in. As Maurice Brinton
correctly argued, _"it is ridiculous to claim -- as so many do today -- that
in 1917 the Bolsheviks really stood for the full, total and direct control by
working people of the factories, mines, building sites or other enterprises in
which they worked, i.e. that they stood for workers' self-management."_ [_"The
Bolsheviks and Workers' Control"_, **For Workers' Power**, p. 328] Rather,
Lenin identified _"workers' control"_ as something totally different:

> _"When we say: 'workers' control', always **juxtaposing** this slogan to
dictatorship of the proletariat, always putting it **immediately after** the
latter, we thereby explain what kind of state we mean . . . if we are speaking
of a proletarian state, that is, of the proletarian dictatorship, then
workers' control can become the country-wide, all-embracing, omnipresent, most
precise and most conscientious **accounting** of the production and
distribution of goods."_ [**Collected Works**, vol. 26, p. 105]

By this Lenin meant the "power" to oversee the books, to check the
implementation of decisions made by others, rather than fundamental decision
making by the workers themselves. As he argued, when _"the proletariat is
victorious it will do the following, it will set economists, engineers,
agronomists, and so forth, to work **under the control** of the workers'
organisations on drawing up a 'plan', on verifying it, on devising labour-
saving methods of centralisation, on devising the simplest, cheapest, most
convenient and universal measures and methods of control. For this we shall
pay the economists, statisticians and technicians good money . . . but we
shall not give them anything to eat if they do not perform this work
conscientiously and entirely **in the interests of the working people**."_
_"The important thing,"_ he stressed _"will not be even the confiscation of
the capitalists' property, but country-wide, all-embracing workers' control
over the capitalists and their possible supporters . . . by the workers'
control of the **workers' state**."_ The economy would be state-run based on
the structures inherited from capitalism: _"**Compulsory syndication**, i.e.,
compulsory amalgamation in associations under state control -- this is what
capitalism has prepared the way for"_ [**Op. Cit.**, vol. 26, p. 118, pp.
107-8 and p. 108] Thus others -- a few planners at the top of a centralised
state -- would determine the plans, not the workers themselves, and primarily
the "control" would be exercised over the capitalists whom Lenin thought
should remain in position for an indefinite period after the revolution.
Rather than workers' managing their own workplaces and economy Leninism meant
_"the organisation of really democratic control, i.e., control from 'below',
control by the workers and the poor peasants **over** the capitalists"_ [**Op.
Cit.**, vol. 25, p.353] Unsurprisingly, then, in 1922, he even suggested
granting legislative power to the State Planning Commission to ensure its
decisions _"could not be rejected by ordinary procedure in Soviet bodies, but
would need a special procedure to be reconsidered"_ as it was _"a body of
experienced people, experts, representatives of science and technology"_ and
so was _"actually in a better position to form a correct judgment of
affairs"_. [**Op. Cit.**, vol. 36, p. 598]

So Lenin's commitment to workers' control was limited and as Maurice Brinton
correctly summarised:

> _"Nowhere in Lenin's writings is workers' control ever equated with
fundamental decision-taking (i.e. with the **initiation** of decisions)
relating to production . . . He envisioned a period during which, in a workers
state, the bourgeois would still retain the formal ownership and effective
management of most of the productive apparatus . . . capitalists would be
coerced into co-operation. 'Workers' control' was seen as the instrument of
this coercion."_ [**Op. Cit.**, pp. 314-5]

Thus the capitalists would remain and wage slavery would continue but workers
could "control" those who had the real power and gave the orders (the
capitalists were later replaced by "one-man management" by state bureaucrats
but the lack of effective power remained -- see [section
H.3.14](secH3.md#sech314)). In other words, no vision of workers' self-
management in production (and so real socialism) and the reduction of
"socialism" to a warmed up variation of state capitalism with (in theory, but
not in practice) a dash of liberal democracy in the form of "control" of those
with the real power by those under them in the hierarchy. This is to be
expected because, as S.A. Smith correctly argues, Lenin's proposals were
_"thoroughly statist and centralist in character"_ and that he used _"the term
['workers' control'] in a very different sense from that of the factory
committees."_ [**Op. Cit.**, p. 154] As can be seen from McNally's pamphlet,
Leninists still follow this tradition and hide the grim reality that their
tradition advocates an economic regime drastically different from the workers'
self-management their words imply to most readers. Using the same slogans as
others ("workers' control" or "socialism from below", for example) but meaning
something radically different by it can only bred confusion.

Given Lenin's lack of concern about the revolutionising of the relations of
production (a lack not shared by the Russian workers, we must stress) it is
hardly surprising that Lenin considered the first task of the Bolshevik
revolution was to build state capitalism. _"State capitalism,"_ he wrote, _"is
a complete material preparation for socialism, the threshold of socialism, a
rung on the ladder of history between which and the rung called socialism
there are no gaps"_. [**Collected Works**, vol. 24, p. 259] The aim was to
ensure that _"**[a]ll** citizens are transformed into hired employees of the
state"_ and the _"whole of society will have become a single office and a
single factory, with equality of labour and pay."_ [**Op. Cit.**, vol. 25, pp.
473-4] For Lenin, the _"domination of the proletariat consists in the fact
that the landowners and capitalists have been deprived of their property . . .
The victorious proletariat has abolished property . . . and therein lies its
domination as a class. The prime thing is the question of property."_ [**Op.
Cit.**, vol. 30, p. 456] Hence his support for centralisation and _"one-man
management"_ \-- if the issue is property then working class power **in
production** cannot be considered as a necessary condition for socialism.
Little wonder Soviet Russia never progressed beyond state capitalism -- it
could not as the fundamental aspect of capitalism, wage labour, was never
replaced by workers' self-management of production. Lenin, in short, was
firmly in the same tradition as those _"certain utopians"_ whose call that
_"the Government seize trade, industry and agriculture, to add them to its
attributes and to make the French nation a nation of wage-workers"_ Proudhon
rejected during the 1848 revolution as _"expropriation by the State"_ was
_"still wage-labour."_ [**Property is Theft!**, p. 22 and p. 377]

Writing in May 1917, Lenin took the viewpoint that state capitalism _"is a
complete **material** preparation for socialism, the threshold of socialism"_
and so socialism _"is nothing but the next step forward from state capitalist
monopoly."_ It is _"merely state-capitalist monopoly **which is made to serve
the interests of the whole people** and has to that extent **ceased** to be
capitalist monopoly."_ [**Op. Cit.**, vol. 25, p. 359 and p. 358] Rather than
seeing _"workers' control"_ as workers managing production directly by means
of their own class organisations, he always saw it in terms of workers'
_"controlling"_ those who did within institutions inherited from capitalism.
It simply meant _"the country-wide, all-embracing, omnipresent, most precise
and most conscientious **accounting** of the production and distribution of
goods."_ He clarified what he meant, arguing for _"country-wide, all-embracing
workers' control over the capitalists"_ who would still manage production.
Significantly, he considered that _"as much as nine-tenths of the
**socialist** apparatus"_ required for this _"country-wide **book-keeping,**
country-wide **accounting** of the production and distribution of goods"_
would be achieved by nationalising the _"big banks,"_ which _"**are** the
'state apparatus' which we **need** to bring about socialism"_ (indeed, this
was considered _"something in the nature of the **skeleton** of socialist
society"_). This structure would be taken intact from capitalism for _"the
modern state possesses an apparatus which has extremely close connection with
the banks and [business] syndicates . . . this apparatus must not, and should
not, be smashed."_ [**Op. Cit.**, vol. 26, p. 105, p. 107, p. 106 and pp.
105-6] He had no real notion of workers' self-management of production nor of
the impossibilities of combining the centralised state capitalist system with
its big banks, monopolies, big business with genuine rank and file control,
never mind self-management.

As discussed in [section H.6.2](secH6.md#sech362), this was what the
Bolsheviks **did** do, using the institutions inherited from Tsarism as
framework for "socialism". They believed that this economic structure would be
made to serve the many rather than the few by a change in the political regime
for _"given a really revolutionary-democratic state, state-monopoly capitalism
inevitably and unavoidably implies a step, and more than one step, towards
socialism!"_ [**Op. Cit.**, vol. 25, pp. 357-8] Yet a centralised state (never
mind party dictatorship!) is hardly _"a really revolutionary-democratic"_
anything other than in Bolshevik rhetoric. Surely, then, such an centralised
economic structure would simply become a step, and more than a step, towards
rule by the bureaucracy? And, sadly, that was the case so confirming anarchist
warnings that state socialism would produce a new class system with the
bureaucracy replacing the capitalist elite.

Yet even this is too generous, given the two obvious flaws in Lenin's
position. First, in-so-far-as a social organisation **is** _"revolutionary-
democratic"_ then it is **not** a state and, as Lenin's regime showed, any new
state will not remain so for long. Second, Lenin seems to have forgotten the
Marxist theory of base and superstructure. The base is the economic forces and
relations of production while the superstructure is the culture, institutions
and state. In Marxist theory, while some mutual influences are sometimes
admitted, the base determines the superstructure. Given this, surely an
economic structure created under a class system would be far more likely to
produce an undemocratic superstructure (state) than the opposite? Surely a
centralised economic structure would produce concentrations of economic and
bureaucratic power and so it would be far more consistent for a Marxist to
suggest a centralised economic base (and _"state-monopoly capitalism"_ can be
nothing less) would produce an equally centralised political superstructure
(state)? And so it came to be -- _"state-monopoly capitalism"_ inevitably and
unavoidably implies a step, and more than one step, towards a new class system
(state-capitalism) rather than a classless one (socialism). Although, to be
fair to Lenin, Marx and Engels were equally untroubled by this danger and did
not draw this obvious conclusion. Anarchists were not so naive. As Alexander
Berkman correctly argued:

> _"The role of industrial decentralisation in the revolution is unfortunately
too little appreciated . . . Most people are still in the thraldom of the
Marxian dogma that centralisation is 'more efficient and economical.' They
close their eyes to the fact that the alleged 'economy' is achieved at the
cost of the workers' limb and life, that the 'efficiency' degrades him to a
mere industrial cog, deadens his soul, kills his body. Furthermore, in a
system of centralisation the administration of industry becomes constantly
merged in fewer hands, producing a powerful bureaucracy of industrial
overlords. It would indeed be the sheerest irony if the revolution were to aim
at such a result. It would mean the creation of a new master class."_ [**What
is Anarchism?**, p. 229]

The Leninist "vision" of the future socialist economy is one of a highly
centralised organisation, modelled on capitalism, in which, at best, workers
can supervise the decisions made by others and "control" those in power. It is
a vision of a more democratic corporate structure, with the workers replacing
the shareholders. In practice, it would be a new bureaucracy exploiting and
oppressing those who do the actual work -- as in private capitalism -- simply
because capitalist economic structures are designed to empower the few over
the many. Like the capitalist state, they cannot be used by the working class
to achieve their liberation (they are not created for the mass participation
that real socialism requires, quite the reverse in fact). Sadly, Lenin failed
to understand this and called the centralised, bureaucratic monstrosity the
Bolsheviks created "socialism".

In contrast, anarchists view the socialist economy as being based on workers'
self-management of production and the workplace turned into an association of
equals. Above the individual workplace, federations of factory committees
would co-ordinate activities and ensure wide scale co-operation is achieved.
Thus anarchists see a **new** form of economic structure developing, one based
on workers' organisations created in the process of struggle **against**
capitalism. Rather than embrace bourgeois notions of "democracy" (i.e. the
election of leaders into positions of power) like Marxists do, anarchists
dissolve hierarchical power by promoting workers' self-management and
association. While Marxism ends up as state capitalism pure and simple (as can
be seen by the experience of Russia under Lenin and then Stalin) anarchism
destroys the fundamental social relation of capitalism -- wage labour -- via
association and workers' self-management of production.

So while both Leninists and anarchists claim to support factory committees and
"workers' control" we have decidedly different notions of what we mean by
this. The Leninists see them as a means of workers' to supervise (a closer
translation of the Russian expression) those who have the real power in the
economy and so perpetuate wage slavery with the state replacing the
capitalist. Anarchists, in contrast, see them as a means of expressing workers
self-organisation, self-management and self-government -- as a means of
abolishing wage slavery and so capitalism by eliminating hierarchical
authority. The difference could not be more striking. Indeed, it would be
correct to state that the Leninist tradition is not, in fact, socialist as it
identifies socialism as the natural development of capitalism and **not** as a
new form of economy which will develop **away** from capitalism by means of
associated labour and workers' self-management of production (see [section
H.3.12](secH3.md#sech312)).

So anarchists and Leninism may often use similar words and expressions but
they aim for different things. Leninists seek party power over a state
capitalist economy and favour centralised political and economic structures.
Sadly, they seem unaware that this will simply generate a new ruling class,
the bureaucracy as centralised structures mean placing power at the top of
society. The new layer of rulers this produces need the means to enforce their
decisions and to gather and process the information needed to make their
decisions, which is why bureaucracy grows. However, by the nature of
bureaucracy the servants of the government quickly become the masters due to
their control over information, resources and so on. This is why anarchists
advocate federalism, to combat the obvious dangers of centralisation. The
Bolshevik regime confirmed the wisdom of the libertarian position as the new
state soon saw a new bureaucratic system quickly emerge around it. The size
and power of the bureaucracy _"grew by leaps and bounds. Control over the new
bureaucracy constantly diminished, partly because no genuine opposition
existed. The alienation between 'people' and 'officials,' which the soviet
system was supposed to remove, was back again. Beginning in 1918, complaints
about 'bureaucratic excesses,' lack of contact with voters, and new
proletarian bureaucrats grew louder and louder."_ [Oskar Anweiler, **The
Soviets**, p. 242] So the rise of a state bureaucracy started immediately with
the seizure of power by the Bolsheviks, particularly as the state's functions
grew to include economic as well as political ones. Instead of the state
starting to "wither away" it grew:

> _"The old state's political apparatus was 'smashed,' but in its place a new
bureaucratic and centralised system emerged with extraordinary rapidity. After
the transfer of government to Moscow in March 1918 it continued to expand . .
. As the functions of the state expanded so did the bureaucracy, and by August
1918 nearly a third of Moscow's working population were employed in offices.
The great increase in the number of employees . . . took place in early to
mid-1918 and, thereafter, despite many campaigns to reduce their number, they
remained a steady proportion of the falling population"_ [Richard Sakwa, _"The
Commune State in Moscow in 1918,"_ pp. 429-449, **Slavic Review**, vol. 46,
no. 3/4, pp. 437-8]

While Lenin started to be concerned about the growth of the bureaucracy after
1920 and Trotsky argued that the Stalinist regime rested on this caste,
neither had the theoretical framework to understand exactly why and how the
centralisation and statist structures they favoured produced the bureaucracy
they denounced. By not understanding the need for federalism they ensured that
the socialistic tendencies being built by the Russian people were crushed
under the weight of the bureaucratic machine which centralisation needs to
function. That this bureaucracy soon became the ruling class is as
unsurprising as Trotsky's inability to recognise the state capitalist nature
of Stalinism (nor his and Lenin's role in producing such a regime in the first
place).

Russia, Lenin once said, _"was accustomed to being ruled by 150 000 land
owners. Why can 240 000 Bolsheviks not take over the task?"_ [**Op. Cit.**,
vol. 21, p. 336] The idea of socialism as working class self-management and
self-government was lost on him -- and the possibility **real** socialism was
soon lost to the Russian working class when the Tsar was replaced by the
autocratic the rule of the Bolshevik Party. _"Workers' power"_ cannot be
identified or equated with the power of the Party -- as it repeatedly was by
the Bolsheviks (and Social Democrats before them).

Thus Malatesta's comments that the _"important, fundamental dissension"_
between anarchists and Marxists is that the latter _"are authoritarians,
anarchists are libertarians._ Marxists _"want power . . . and once in power
wish to impose their programme on the people . . . Anarchists instead
maintain, that government cannot be other than harmful, and by its very nature
it defends either an existing privileged class or creates a new one."_
[**Errico Malatesta: His Life and Ideas**, p. 142] Therefore anarchists seek
to influence people by the power of our ideas within popular organisations. We
see such organisations as the means by which working people can take control
of their own lives and start to create a free, libertarian socialist society
-- in other words, as we sketch in [section I.2.3](secI2.md#seci23), the
structures of a free society are created in the struggle against hierarchy
today and, moreover, people become able to govern themselves by the very
process of that struggle. A self-managed society can only be created by self-
management, in short, and any tendencies to undermine popular self-management
in favour of hierarchical power of a party will subvert a revolution and
create an end drastically at odds with the ideals of those who take part in
it.

Similarly, anarchists reject the Leninist idea of highly centralised
"vanguard" parties. As the anarchists of Trotwatch explain, such a party
leaves much to be desired:

> _"In reality, a Leninist Party simply reproduces and institutionalises
existing capitalist power relations inside a supposedly 'revolutionary'
organisation: between leaders and led; order givers and order takers; between
specialists and the acquiescent and largely powerless party workers. And that
elitist power relation is extended to include the relationship between the
party and class."_ [**Carry on Recruiting!**, p. 41]

As we discuss in [section H.5.9](secH5.md#sech59), such an organisation can
**never** create a socialist society. In contrast, anarchists argue that
socialist organisations should reflect as much as possible the future society
we are aiming to create (see [section H.1.6](secH1.md#sech16). To build
organisations which are statist/capitalistic in structure cannot do other than
reproduce the very problems of statism/capitalism into them and so undermine
their liberatory potential. As Murray Bookchin put it:

> _"The 'glorious party,' when there is one, almost invariably lags behind the
events . . . In the beginning . . . it tends to have an inhibitory function,
not a 'vanguard' role. Where it exercises influence, it tends to slow down the
flow of events, not 'co-ordinate' the revolutionary forced. This is not
accidental. The party is structured along hierarchical lines **that reflect
the very society it professes to oppose** . . . Its membership is schooled in
obedience . . . The party's leadership, in turn, is schooled in habits born of
command, authority, manipulation . . . Its leaders . . . lose contact with the
living situation below. The local groups, which know their own immediate
situation better than any remote leaders, are obliged to subordinate their
insights to directives from above. The leadership, lacking any direct
knowledge of local problems, responds sluggishly and prudently . . ._

> _"The party becomes less efficient from a revolutionary point of view the
more it seeks efficiency by means of hierarchy, cadres and centralisation.
Although everyone marches in step, the orders are usually wrong, especially
when events begin to move rapidly and take unexpected turns -- as they do in
all revolutions. The party is efficient in only one respect -- in moulding
society in its own hierarchical imagine if the revolution is successful. It
recreates bureaucracy, centralisation and the state. It fosters the
bureaucracy, centralisation and the state. It fosters the very social
conditions which justify this kind of society. Hence, instead of 'withering
away,' the state controlled by the 'glorious party' preserves the very
conditions which 'necessitate' the existence of a state -- and a party to
'guard' it."_ [**Post-Scarcity Anarchism**, pp. 123-6]

As we argue in [section J.3](secJ3.md), anarchists do not reject the need
for political organisations (anarchist groups, federations and so on) to work
in mass movements and in revolutionary situations. However, we do reject the
Leninist idea of a vanguard party as being totally inappropriate for the needs
of a social revolution -- a revolution that aims to create a free society.

In short, anarchists reject both the means and the ends Leninists aim for and
so our disagreements with that tradition is far more than semantics. Simply
put, for anarchists Leninism is **not** "socialism from below" but rather a
centralised, top-down movement aiming for a centralised, top-down state
capitalist system.

This does not mean that all members of Leninist parties do not support
workers' self-management in society and production and some genuinely seem to
favour workers' democracy and actually do believe in working class self-
emancipation, etc. They are simply unaware that the tradition they have joined
does not actually share those values (thanks to, it must be stated, works like
McNally's). It could, perhaps, be argued that such values can be "added" to
the core Leninist ideas. However, such a viewpoint is optimistic in the
extreme. Leninist positions on workers' self-management, etc., do not "just
happen" nor are they the product of ignorance. Rather they are the natural
result of those "core" ideas. To add other values to Leninism would be like
adding extensions to a house built on sand -- the foundations are unsuitable
and any additions would soon fall down. This was what happened during the
Russian Revolution -- movements from below which had a different vision of
socialism came to grief on the rocks of Bolshevik power. Simply put, adding
self-management to a centralised system and party power is impossible and if
we strip Leninism of all its authoritarian notions then we would simply have
anarchism.

So as we discuss in [section H.3.1](secH3.htm#sech31), while there appears to
be some similarity between the aims of anarchism and Marxism (namely a free
classless society of free and equal individuals) on closer look there are
significant differences between the two and only anarchism truly represents
_"socialism from below"_ (as we will see [next section](append31.md#app14),
we have been talking about "from below" since the 1840s while Marxist use of
the terminology dates from much later). This is no coincidence.. Moreover, as
shown in [section H.6.2](secH6.md#sech62), these differences are important
as Bolshevik ideology, once its advocates held power at the top of a
centralises state structure and started to apply it, impacted negatively on
the Russian revolution and ensured its failure (i.e., it was not creating
socialism even if a self-proclaimed "communist" party remained in power at the
end of the civil war in 1920). The issue is clear -- either you aim for a
socialist society and use socialist methods to get there or you do not. Those
who do seek **real** socialism (as opposed to warmed up state capitalism)
would be advised to recognise this and study closely what Leninists actually
mean by the slogans they use rather than taking them at face value.

## 14\. Why is McNally's use of the term _"socialism from below"_ dishonest?

McNally argues that Marxism can be considered as _"socialism from below."_
Indeed, that is the name of his pamphlet. However, his use of the term is
somewhat ironic for two reasons. First, because the expression _"from below"_
can be found in the writings of Bakunin and Proudhon, not Marx. Second,
because Lenin explicitly attacked the idea of _"from below"_ as an anarchist
principle.

In terms of the first point, the expression _"from below"_ was constantly on
the lips of Bakunin and Proudhon. Indeed, it was a defining part of their
ideas. Thus we find Proudhon attacking the state socialism of Louis Blanc in
1846 because he _"is never tired of appealing to authority, and socialism
loudly declares itself anarchistic; M. Blanc places power above society, and
socialism tends to subordinate it to society; M. Blanc makes social life
descend from above, and socialism maintains that it springs up and grows from
below"_ [**Property is Theft!**, p. 205] He re-iterated this during the 1848
revolution:

> _"**From above** . . . signifies power; **from below** signifies the people.
On the one hand we have the actions of government; on the other, the
initiative of the masses . . . revolution from above is . . . inevitably
revolution according to the whims of the Prince, the arbitrary judgement of a
minister, the fumblings of an Assembly or the violence of a club: it is a
revolution of dictatorship and despotism . . . Revolution on the initiative of
the masses is a revolution by the concerted action of the citizens, by the
experience of the workers, by the progress and diffusion of enlightenment,
revolution by the means of liberty . . . a revolution from below, from true
democracy . . . Saint-Simon, Fourier, Owen, Cabet, Louis Blanc, all believers
in the organisation of labour by the State, by Capital, by whatever authority,
appealed . . . to revolution **from above**. Instead of teaching the people
how to organise themselves, by calling on their experience and their
reasoning, they demanded Power . . ._

> _"The conclusion is that government can never be revolutionary quite simply
because it is government. Society alone, the masses armed with their
intelligence, can create revolution; society alone is able to deploy all its
spontaneity, to analyse and explain the mystery of its destiny and its origin,
to change its faith and its philosophy, because it alone is capable of
fighting against its originator and bearing its fruit. Governments are God’s
scourge, established to **discipline** the world: do you really expect them to
destroy themselves, to create freedom, to make revolution?_

> _"They cannot act otherwise. All revolutions . . . were achieved by the
spontaneity of the people: governments have always hindered, always
suppressed, always beaten back; they have never created revolution. Their role
is not to create change but to control it."_ [**Op. Cit.**, pp. 398-9]

Thus _"experience testifies and philosophy demonstrates . . . that any
revolution, to be effective, must be spontaneous and emanate, not from the
heads of the authorities but from the bowels of the people: that government is
reactionary rather than revolutionary: that it could not have any expertise in
revolutions, given that society, to which that secret is alone revealed, does
not show itself through legislative decree but rather through the spontaneity
of its manifestations: that, ultimately, the only connection between
government and labour is that labour, in organising itself, has the abrogation
of government as its mission"_. [**No Gods, No Masters**, vol. 1., p. 52]
_"The Revolution **from above**,"_ Proudhon stressed, _"is the intervention of
power in everything; it is the absolutist initiative of the State, the pure
governmentalism of . . . [state-socialist] Louis Blanc. The Revolution **from
above** is the negation of collective activity, of popular spontaneity . . .
What serious and lasting Revolution was not made **from below**, by the
people? How did the Revolution of 1789 come about? How was that of February
made? The Revolution **from above** has never been other than the oppression
of the wills of those below."_ [quoted by George Woodcock, **Pierre-Joseph
Proudhon**, p. 143]

Proudhon, then, placed his hopes for introducing socialism in alternative
institutions created by working class people themselves and _"insisted that
the revolution could only come from below, through the action of the workers
themselves."_ [K. Steven Vincent, **Pierre-Joseph Proudhon and the Rise of
French Republican Socialism**, p. 157] Bakunin did likewise, seeing the labour
movement as the means of ensuring that an anarchist revolution would come
_"from below."_ As he put it, _"liberty can be created only by liberty, by an
insurrection of all the people and the voluntary organisation of the workers
from below upward."_ [**Statism and Anarchy**, p. 179] Elsewhere he wrote that
_"future social organisation must be made solely from the bottom upwards, by
the free association or federation of workers, firstly in their unions, then
in the communes, regions, nations and finally in a great federation,
international and universal."_ [**Michael Bakunin: Selected Writings**, p.
206] As he wrote in 1868:

> _"I hate Communism because it is the negation of liberty and because for me
humanity is unthinkable without liberty. I am not a Communist, because
Communism concentrates and swallows up in itself for the benefit of the State
all the forces of society, because it inevitably leads to the concentration of
property in the hands of the State . . . I want to see society and collective
or social property organised from below upwards, by way of free associations,
not from above downwards, by means of any kind of authority whatsoever . . .
That is the sense in which I am a Collectivist and not a Communist."_ [quoted
by K.J. Kenafick, **Michael Bakunin and Karl Marx**, pp. 67-8]

Anarchists, argued Bakunin, opposed the state because _"all State rule, all
governments being by their very nature placed outside the people, must
necessarily seek to subject it to customs and purposes entirely foreign to it.
We therefore declare ourselves to be foes . . . of all State organisations as
such, and believe that the people can be happy and free, when, organised from
below upwards by means of its own autonomous and completely free associations,
without the supervision of any guardians, it will create its own life."_
[**Marxism, Freedom and the State**, p. 63] This applied to the so-called
"workers' state" because _"every state, even the pseudo-People's State
concocted by Mr. Marx, is in essence only a machine ruling the masses from
above, through a privileged minority of conceited intellectuals who imagine
that they know what the people need and want better than do the people
themselves."_ [**Bakunin on Anarchism**, p. 338] The revolution would see _"an
end to all masters and to domination of every kind, and the free construction
of popular life in accordance with popular needs, not from above downward, as
in the state, but from below upward, by the people themselves, dispensing with
all governments and parliaments -- a voluntary alliance of agricultural and
factory worker associations, communes, provinces, and nations; and, finally, .
. . universal human brotherhood triumphing on the ruins of all the states."_
[**Statism and Anarchy**, p. 33]

No such idea is present in Marx. Rather, he saw a revolution as consisting of
the election of a socialist party into government. At its best, for example
when he was reporting on the Paris Commune, this vision had libertarian
(_"from below"_) aspects -- perhaps unsurprisingly, given its obviously
Proudhon-inspired federalism (which Marx could not bring himself to mention).
However, at its worse this was not only reformist in the sense of utilising
bourgeois elections (see [section H.3.10](secH3.md#sech310)) but also "from
above" in nature. In 1850, for example, he argued that the workers must _"not
only strive for a single and indivisible German republic, but also within this
republic for the most determined centralisation of power in the hands of the
state authority."_ This was because _"the path of revolutionary activity"_ can
_"proceed only from the centre."_ This meant that the workers must be opposed
to a _"federative republic"_ and _"must not allow themselves to be misguided
by the democratic talk of freedom for the communities, of self-government,
etc."_ This centralisation of power was essential to overcome local autonomy,
which would allow _"every village, every town and every province"_ to put _"a
new obstacle in the path"_ of the revolution due to _"local and provincial
obstinacy."_ Decades later, Marx dismissed Bakunin's vision of _"the free
organisation of the worker masses from bottom to top"_ as _"nonsense."_
[**Marx-Engels Reader**, p. 509 and p. 547]

As we discuss in [section H.3.2](secH3.md#sech32), the idea of _"socialism
from below"_ is a distinctly anarchist notion, one found in the works of
Proudhon and Bakunin, **not** Marx. It is ironic, given his distorted account
of Proudhon and Bakunin, that McNally uses their words to describe Marxism!

Secondly, and far more seriously for McNally, Lenin repeatedly dismissed the
idea of _"from below"_ as not Marxist. In 1904, during the debate over the
party split into Bolsheviks and Mensheviks, Lenin stated that the argument
_"[b]ureaucracy **versus** democracy is in fact centralism **versus**
autonomism; it is the organisational principle of revolutionary Social-
Democracy as opposed to the organisational principle of opportunist Social-
Democracy. The latter strives to proceed from the bottom upward, and,
therefore, wherever possible . . . upholds autonomism and 'democracy,' carried
(by the overzealous) to the point of anarchism. The former strives to proceed
from the top downward."_ [**Collected Works**, vol. 7, pp. 396-7] Lenin
repeated this argument during the near revolution of 1905, mocking the
Mensheviks for only wanting _"pressure from below"_ which was _"pressure by
the citizens on the revolutionary government."_ Instead, he argued for
_"pressure . . . from above as well as from below,"_ where _"pressure from
above"_ was _"pressure by the revolutionary government on the citizens."_ He
notes that Engels _"appreciated the importance of action from above"_ and that
he saw the need for _"the utilisation of the revolutionary governmental
power."_ Lenin summarised his position (which he considered as being in line
with that of orthodox Marxism) by stating: _"Limitation, in principle, of
revolutionary action to pressure from below and renunciation of pressure also
from above is **anarchism.**"_ [**Op. Cit.**, vol. 8, p. 474, p. 478, p. 480
and p. 481] He returned to this theme, explicitly stating that it was an
_"anarchist stand"_ to be for _"'action only from below', not 'from below and
from above'"_. [**Op. Cit.**, vol. 9, p. 77]

How you can have _"socialism from below"_ when your _"organisational
principle"_ is _"from the top downward"_ and _"renunciation of pressure also
from above is **anarchism**"_ is not explained by McNally. Moreover, given
that McNally states repeatedly the evils of _"from above"_ in his pamphlet he
gives his account of Marxism a distinctly anarchist feel (while denouncing it
in a most deceitful way). Why is this? Perhaps because his readers would
recognise that in a conflict between _"pressure from above"_ (the armed might
of the state) and _"pressure from below"_ (the people) it would be the former
which would tend to win? And that this was the case in the Russian Revolution,
with the Bolshevik state crushing all forms of working class protest? As we
discuss in [section H.6](secH6.md), the _"the utilisation of the
revolutionary governmental power"_ simply produced a "dictatorship **over**
the proletariat" as Bakunin (see [section H.1.1](secH1.md#sech11)). and
other anarchists had long predicted.

In other words, Marxism is based on idea that the government pressuring the
citizens is acceptable. As we discuss in the [next
section](append31.md#app15), Trotsky recognised this and openly proclaimed
the need for party dictatorship to resist the pressures from below (dismissed
as _"wavering"_ and _"vacillation"_ by the backward masses). As we discuss in
[section H.5](secH5.md), the vanguardism of Leninism privileges the party
and its leadership and lays the foundation for "socialism from below." A given
ideological premise will led to certain conclusions in practice -- conclusions
Lenin and Trotsky were not shy in explicitly stating.

Little wonder McNally fails to mention Lenin's support for revolutionary
action _"from above"_ for in practice Leninism substituted the rule (and then
dictatorship) of the party for that of the working class as a whole. Lenin
always stressed that the _"Bolsheviks must assume power"_ and they _"can and
must take state power into their own hands."_ He raised the question of _"will
the Bolsheviks dare take over full state power alone?"_ and answered it: _"I
have already had occasion . . . to answer this question in the affirmative."_
Moreover, _"a political party . . . would have no right to exist, would be
unworthy of the name of party . . . if it refused to take power when
opportunity offers."_ He equated rule by the party with rule by the class,
noting that _"proletarian revolutionary power"_ and _"Bolshevik power"_ are
_"now one the same thing"_ and indicated that once in power the Bolsheviks
_"shall be fully and unreservedly in favour of a strong state power and of
centralism."_ [**Op. Cit.**, vol. 26, p. 19, p. 90, p. 179 and p. 116] In this
confusion, we must note, Lenin followed Engels who argued that _"each
political party sets out to establish its rule in the state, so the German
Social-Democratic Workers' Party is striving to establish **its** rule, the
rule of the working class."_ [**Collected Works**, vol. 23, p. 372] Such
confusion is deadly to a true _"revolution from below"_ and justifies the use
of repression against the working class based on the advanced ideas of the
vanguard party.

McNally, of course, stresses the impact of the civil war on the degeneration
of Bolshevism but comments like these were not caused by circumstantial
factors as can be seen from Lenin's work **Left-Wing Communism**. In this 1920
tract, written for the Second Congress of the Communist International, Lenin
lambasted those Marxists who argued for direct working class power against the
idea of party rule (i.e. the various council communists around Europe) and
argued that _"the Communists' correct understanding of his tasks"_ lies in
_"correctly gauging the conditions and the moment when the vanguard of the
proletariat can successfully assume power, when it will be able -- during and
after the seizure of power -- to win adequate support from sufficiently broad
strata of the working class and of the non-proletarian working masses, and
when it is able thereafter to maintain, consolidate, and extend its rule by
educating, training and attracting ever broader masses of the working
people."_ Note, the vanguard (the party) seizes power, **not** the masses and
he stressed that the _"mere presentation of the question -- 'dictatorship of
the party **or** dictatorship of the class: dictatorship (party) of the
leaders **or** dictatorship (party) of the masses?' -- testifies to most
incredible and hopelessly muddled thinking"_ and _"[t]o go so far . . . as to
contrast, **in general**, the dictatorship of the masses with a dictatorship
of the leaders is ridiculously absurd, and stupid."_ [**The Lenin Anthology**,
p. 575, p. 567 and p. 568] He then explained the nature of Bolshevik rule:

> _"In Russia today, the connection between leaders, party, class and masses .
. . are concretely as follows: the dictatorship is exercised by the
proletariat organised in the Soviets and is guided by the Communist Party . .
. The Party, which holds annual congresses . . ., is directed by a Central
Committee of nineteen elected at the congress, while the current work in
Moscow has to be carried on by [two] still smaller bodies . . . which are
elected at the plenary sessions of the Central Committee, five members of the
Central Committee to each bureau. This, it would appear, is a full-fledged
'oligarchy.' No important political or organisational question is decided by
any state institution in our republic [sic!] without the guidance of the
Party's Central Committee._

> _"In its work, the Party relies directly on the **trade unions**, which . .
. have a membership of over four million and are formally **non-Party**.
Actually, all the directing bodies of the vast majority of the unions . . .
are made up of Communists, and carry out of all the directives of the Party.
Thus . . . we have a formally non-communist . . . very powerful proletarian
apparatus, by means of which the Party is closely linked up with the **class**
and **the masses,** and by means of which, under the leadership of the Party,
the **class dictatorship** of the class is exercised."_ [**Op. Cit.**, pp.
571-2]

This was _"the general mechanism of the proletarian state power viewed 'from
above,' from the standpoint of the practical realisation of the dictatorship"_
and so _"all this talk about 'from above' **or** 'from below,' about 'the
dictatorship of leaders' **or** 'the dictatorship of the masses,'"_ is
_"ridiculous and childish nonsense."_ [**Op. Cit.**, p. 573] The links with
his comments from 1904 and 1905 are clear, as clear as his explanation of the
lessons he thought that the world communist movement had to learn from the
Bolshevik revolution. The notion that Leninism stands for _"socialism from
below"_ in untenable.

Lenin, of course, did not bother to view "proletarian" state power "from
below," from the viewpoint of the proletariat. If he had, perhaps he would
have recounted the numerous strikes and protests broken by the Cheka under
martial law, the gerrymandering and disbanding of soviets, the imposition of _
"one-man management"_ onto the workers in production, the turning of the
unions into agents of the state/party and the elimination of working class
freedom by party power (see [section 8](append31.md#app8)). All of which
suggests that there **are** fundamental differences, at least for the masses,
between _"from above"_ and _"from below."_

Anarchists, in contrast, recognise that parties and classes are different and
only self-management in popular organisations from below upwards can ensure
that a social revolution remains in the hands of all and not a source of power
for the few. Thus _"All Power to the Soviets,"_ for anarchists, means
**exactly** that -- not a euphemism for _"All Power to the Party."_ As Russian
anarchist Voline argued, _"for, the anarchists [in 1917] declared, if 'power'
really should belong to the soviets, it could not belong to the Bolshevik
Party, and if it should belong to that Party, as the Bolsheviks envisaged, it
could not belong to the soviets."_ Marxist confusion of the difference between
working class power and party power, combined with the nature of centralised
power and an ideology which privileges the party over the working class (see
[section 11](append31.md#app11)) cannot help but lead to the rise of a
ruling bureaucracy, pursuing "from above" their own power and privileges.
_"**All political power inevitably creates a privileged situation** for the
men who exercise it,"_ argued Voline. _"Thus is violates, from the beginning,
the equalitarian principle and strikes at the heart of the Social Revolution"_
and _"becomes the source of other privileges . . . **power is compelled to
create a bureaucratic and coercive apparatus** indispensable to all authority
. . . **Thus it forms a new privileged caste,** at first politically and later
economically."_ [**The Unknown Revolution**, p. 213 and p. 249]

The concept of revolution _"from above"_ is one that inevitably leads to a new
form of class rule -- rule by bureaucracy. This is not because the Bolsheviks
were "bad people" -- rather it is to do with the nature of centralised power
(which by its very nature can only be exercised by the few) combined with bad
politics (the confusion of party power with people power, unthinking
prejudices in favour of centralism, ignoring the need for only _"from below"_,
etc.). As the Russian anarchist Sergven argued in 1918 while the Bolshevik
regime was building state capitalism:

> _"The proletariat is being gradually enserfed by the state. The people are
being transformed into servants over whom there has arisen a new class of
administrators -- a new class born mainly form the womb of the so-called
intelligentsia . . . We do not mean to say . . . that the Bolshevik party set
out to create a new class system. But we do say that even the best intentions
and aspirations must inevitably be smashed against the evils inherent in any
system of centralised power. The separation of management from labour, the
division between administrators and workers flows logically from
centralisation. It cannot be otherwise."_ [**The Anarchists in the Russian
Revolution**, pp. 123-4]

Thus McNally's use of the term _"from below"_ is dishonest on two levels.
Firstly, it is of anarchist origin and, secondly, it was repudiated by Lenin
himself (who urged revolution _"from below"_ and _"from above"_, thus laying
the groundwork for a new class system based around the Party). It goes without
saying that either McNally is ignorant of his subject (and if so, why write a
pamphlet on it?) or he knew these facts and decided to suppress them. Either
way it shows the bankruptcy of Marxism -- it uses libertarian rhetoric for
non-libertarian ends while distorting the real source of those ideas. That
Lenin dismissed this rhetoric and the ideas behind them as _"anarchist"_ says
it all. McNally's (and the SWP/ISO's) use of this rhetoric and imagery is
therefore deeply dishonest.

## 15\. Did Trotsky keep alive Leninism's _"democratic essence"_?

McNally argues that _"[d]uring the terrible decades of the 1920s and 1940s . .
. the lone voice of Leon Trotsky kept alive some of the basic elements of
socialism from below"_ and suggests it _"was Trotsky's great virtue to insist
against all odds that socialism was rooted in the struggle for human
freedom."_ By the mid-1920s _"the programme of the Left Opposition"_ which
Trotsky lead had as one of its _"two central planks"_ that _"democracy had to
be re-established in the Bolshevik party and in the mass organisations such as
the trade unions and the soviets."_ In short:

> _""Throughout the 1920s and until his death at the hands of Stalinist agent
in 1940, Trotsky fought desperately to build a revolutionary socialist
movement based on the principles of Marx and Lenin.""_

There is one slight flaw with this argument, namely that it is not actually
true. All through the 1920s and 1930s Trotsky, rather than argue for
_"socialism's democratic essence"_, continually argued for party dictatorship.
That McNally asserts the exact opposite suggests that the ideas of anarchism
are not the only ones he is ignorant of. To prove our case, we simply need to
provide a chronological account of Trotsky's actual ideas.

We shall begin in early 1920 when he argued that the _"working class cannot be
left wandering round all over Russia. They must be thrown here and there,
appointed, commanded, just like soldiers"_ and that _"[d]eserters from labour
ought to be formed into punitive battalions or put into concentration camps"_.
[quoted by Maurice Brinton, _"The Bolsheviks and Workers' Control"_, **For
Workers' Power**, p. 61] Is _"human freedom"_ (to use McNally's words)
compatible with Trotsky's suggestions? This was no isolated comment and in
July of that year we discover him arguing that:

> _"In the hands of the party is concentrated the general control . . . it has
the final word in all fundamental questions . . . the last word belongs to the
Central Committee of the party . . . Such a regime is possible only in the
presence of the unquestioned authority of the party, and the faultlessness of
its discipline . . ._

> _"The exclusive role of the Communist Party under the conditions of a
victorious proletarian revolution is quite comprehensible. The question is of
the dictatorship of a class. In the composition of that class there enter
various elements, heterogeneous moods, different levels of development. Yet
the dictatorship pre-supposes unity of will, unity of direction, unity of
action. By what other path then can it be attained? The revolutionary
supremacy of the proletariat pre-supposes within the proletariat itself the
political supremacy of a party, with a clear programme of action and a
faultless internal discipline._

> _"The policy of coalitions contradicts internally the regime of the
revolutionary dictatorship. We have in view . . . a coalition of Communists
with other 'Socialist' organisations, representing different stages of
backwardness and prejudice-of the labouring masses._

> _"[ . . .]_

> _"We have more than once been accused of having substituted for the
dictatorship of the Soviets the dictatorship of our party. Yet it can be said
with complete justice that the dictatorship of the Soviets became possible
only by means of the dictatorship of the party. It is thanks to the clarity of
its theoretical vision and its strong revolutionary organisation that the
party has afforded to the Soviets the possibility of becoming transformed from
shapeless parliaments of labour into the apparatus of the supremacy of labour.
In this 'substitution' of the power of the party for the power of the working
class there is nothing accidental, and in reality there is no substitution at
all. The Communists express the fundamental interests of the working class. It
is quite natural that, in the period in which history brings up those
interests . . . the Communists have become the recognised representatives of
the working class as a whole."_ [**Terrorism and Communism**, pp. 107-9]

He argued against those who suggested that the dictatorship should be carried
out by the whole class: _"It is not easy to understand what actually they
imagine when they say this. The dictatorship of the proletariat, in its very
essence, signifies the immediate supremacy of the revolutionary vanguard,
which relies upon the heavy masses, and, where necessary, obliges the backward
tail to dress by the head."_ [**Op. Cit.**, p. 110] This rejection of
democracy also applied to workplace democracy:

> _"our Party Congress . . . expressed itself in favour of the principle of
one-man management in the administration of industry . . . It would be the
greatest possible mistake . . . to consider this decision as a blow to the
independence of the working class . . . It would consequently be a most crying
error to confuse the question as to the supremacy of the proletariat with the
question of boards of workers at the head of factories. The dictatorship of
the proletariat is expressed in the abolition of private property in the means
of production, in the supremacy over the whole Soviet mechanism of the
collective will of the workers, and not at all in the form in which individual
economic enterprises are administered . . . we took our stand, and continue to
do so on purely Marxist views of the revolutionary problems and creative
duties of the proletariat when it has taken power into its own hands . . . I
consider if the civil war had not plundered our economic organs of all that
was strongest, most independent, most endowed with initiative, we should
undoubtedly have entered the path of one-man management in the sphere of
economic administration much sooner and much less painfully."_ [**Op. Cit.**,
pp. 161-3]

In this, as with party dictatorship, he was simply repeating Bolshevik
orthodoxy -- Lenin had been arguing for state-appointed one-man management
(armed with _"dictatorial"_ authority) since the spring of 1918. Ignoring all
the euphemisms for party dictatorship ("_the collective will of the workers"_)
and obvious questions (like, if this were the case, how Trotsky could argue
that it was the proletariat which had _"taken power into its own hands"_?),
the fact is that he was simply wrong. It **does** matter if workplaces are run
by their workers or not for if they do not then someone else does. Replacing
capitalists with state bureaucrats just changes the face of the boss -- as
anarchists have been arguing since Proudhon. Trotsky did not deny how
authoritarian this regime was:

> _"Both economic and political compulsion are only forms of the expression of
the dictatorship of the working class in two closely connected regions . . .
the road to Socialism lies through a period of the highest possible
intensification of the principle of the State . . . Just as a lamp, before
going out, shoots up in a brilliant flame, so the State, before disappearing,
assumes the form of the dictatorship of the proletariat, i.e., the most
ruthless form of State, which embraces the life of the citizens
authoritatively in every direction . . . No organisation except the army has
ever controlled man with such severe compulsion as does the State organisation
of the working class in the most difficult period of transition. It is just
for this reason that we speak of the militarisation of labour."_ [**Op.
Cit.**, pp. 169-170]

Against those who argued that by _"[d]estroying or driving underground the
other parties, you have thereby prevented their political competition with
you, and consequently you have deprived yourselves of the possibility of
testing your line of action"_ Trotsky replied by pointing to the efficiency of
Bolshevik repression: _"In a period in which . . . the political struggle
swiftly passes into a civil war, the ruling party has sufficient material
standard by which to test its line of action, without the possible circulation
of Menshevik papers. Noske crushes the Communists, but they grow. We have
suppressed the Mensheviks and the SRs -- and they have disappeared. This
criterion is sufficient for us."_ From this he concluded that Bolshevism
_"expresses the interests of historical development."_ [**Op. Cit.**, pp.
109-110] Needless to say, he did not repeat this "might-makes-right" criteria
when the Stalinists made the Trotskyists disappear in the late 1920s and
1930s.

Of course, this was written during the Civil War and may be excused in terms
of the circumstances in which it was written. However, this ignores the
awkward fact that Trotsky's arguments reflected the theoretical conclusions
required to produce what he considered as a **successful** revolution and, as
noted in [section 8](append31.md#app8), other leading Bolsheviks had
proclaimed to the world this necessity of party dictatorship. Trotsky did not
object and universalised the argument when he pondered the important decisions
of the revolution and who would make them in his reply to the delegate from
the Spanish anarcho-syndicalist union the CNT:

> _"Who decides this question [and others like it]? We have the Council of
People's Commissars but it has to be subject to some supervision. Whose
supervision? That of the working class as an amorphous, chaotic mass? No. The
Central Committee of the party is convened to discuss . . . and to decide . .
. Who will solve these questions in Spain? The Communist Party of Spain."_
[**Proceedings and Documents of the Second Congress 1920**, vol. 1, p. 174]



This dismissal of working-class democracy was party orthodoxy, as can be seen
from the awkward fact that Trotsky continued to argue for party dictatorship
after the end of the civil war in November 1920. Thus we discover him in early
in 1921 arguing again for Party dictatorship at the Communist Party's Tenth
Party Congress. His comments made there against the **Workers' Opposition**
within the Communist Party make his position clear:

> _"The Workers' Opposition has come out with dangerous slogans, making a
fetish of democratic principles! They place the workers' right to elect
representatives above the Party, as if the party were not entitled to assert
its dictatorship even if that dictatorship temporarily clashed with the
passing moods of the workers' democracy. It is necessary to create amongst us
the awareness of the revolutionary birthright of the party, which is obliged
to maintain its dictatorship, regardless of temporary wavering even in the
working classes. This awareness is for us the indispensable element. The
dictatorship does not base itself at every given moment on the formal
principle of a workers' democracy."_ [quoted by Samuel Farber, **Before
Stalinism**, p. 209]

It should be noted that Trotsky was being too generous to the Workers'
Opposition, for _"while demanding more freedom of initiative for the workers"_
in economic matters, _"it was quite content to leave untouched the state of
affairs in which a few hundred thousand imposed their will on many millions"_
and it _"had no wish to disturb the communist party's monopoly of political
power."_ [Leonard Schapiro, **The Origin of the Communist Autocracy**, p. 294]
So even limited industrial democracy was considered too much by Trotsky in
1921. In late March 1921, he re-iterated this position in relation to the
crushing of the Kronstadt revolt for soviet democracy by asserting that the
_"economic, political, and national independence of Russia is possible only
under the dictatorship of the soviets. The backbone of this dictatorship is
the Communist Party. There is no other party that can play this part, nor can
there be."_ [Lenin and Trotsky, **Kronstadt**, p. 73]

Trotsky repeated this call again in 1922 when he stated plainly that _"we
maintain the dictatorship of our party!"_ [**The First Five Years of the
Communist International**, vol. 2, p. 255] Writing in the following year, he
argued that _"[i]f there is one question which basically not only does not
require revision but does not so much as admit the thought of revision, it is
the question of the dictatorship of the Party, and its leadership in all
spheres of our work."_ He stressed that _"[o]ur party is the ruling party . .
. To allow any changes whatever in this field, to allow the idea of a partial
. . . curtailment of the leading role of our party would mean to bring into
question all the achievements of the revolution and its future."_ He indicated
the fate of those who **did** question this: _"Whoever makes an attempt on the
party's leading role will, I hope, be unanimously dumped by all of us on the
other side of the barricade."_ [**Leon Trotsky Speaks**, p. 158 and p. 160]
Which, of course, was exactly what the Bolsheviks had done to other socialists
(anarchists and others) and working class militants and strikers after they
had taken power (see [section H.6](secH6.md) for details).

At this point, it will be argued that this was before the rise of Stalinism
and his activities in the Left Opposition. As McNally suggests, many argue
that these developments saw Trotsky finally rejecting the idea of party
dictatorship and re-embracing what McNally terms the _"democratic essence"_ of
Leninism. Unfortunately, yet again, this argument suffers from the flaw that
it is false.

Let us start with the so-called _"New Course"_ of December 1923, in which
Trotsky stated that _"[w]e are the only party in the country and, in the
period of the dictatorship, it could not be otherwise"_, the Party was
_"obliged to monopolise the direction of political life"_ and it was
_"incontestable that fractions [within the Party] are a scourge in the present
situation"_. Of course, there was talk of _"workers' democracy"_ but the _"New
Course Resolution"_ was clear that that term in fact meant only internal party
democracy: _"Workers' democracy means the liberty of frank discussion of the
most important questions of party life by all members, and the election of all
leading party functionaries and commissions"_. [**The Challenge of the Left
Opposition (1923-25)**, p. 87, p. 89 and p. 460]

This applied to the banning of factions **within** the Communist party, with
Trotsky keen to stress at the 13th Party Congress in 1924 that _"party
democracy in no way implies freedom for factional groupings which are
extremely dangerous for the ruling party, since they threaten to split or
divide the government and the state apparatus as a whole. I believe this is
undisputed and indisputable"_. He linked his position to the 10th Party
Congress _"where Valdimir Ilyich [Lenin] personally"_ made the same points and
re-iterated his position: _"I have never recognised freedom for groupings
inside the party, nor do I now recognise it"_. [**Op. Cit.**, p. 170 and p.
171] He declared his faith in the Party:

> _"Comrades, none of us wants to be or can be right against the party. In the
last analysis the party is always right, because the party is the only
historical instrument that the working class possesses for the solution of its
fundamental tasks . . . I know that no one can be right against the party. It
is only possible to be right only with the party and through it because
history has not created any other way to determine the correct position . . .
the party, in the last analysis, is always right"_. [**Op. Cit.**, p. 179]

He did acknowledge that _"even the party itself can make occasional mistakes"_
but argued that the duty of a party member was to follow its decisions if they
could not convince the party that it had made one of these. The links to his
arguments from 1920 and 1921 are clear enough, alongside the privileged
position this places the party in terms of its right to ignore any democratic
decisions of the masses it claimed to be ruling on behalf of. Needless to say,
the "New Course Resolution" likewise stated party democracy _"does not . . .
imply the freedom to form factional groupings"_. [**Op. Cit.**, p. 180 and p.
460]

Moving on to Left Opposition proper, we see Trotsky opining in 1926 that the
_"dictatorship of the party does not contradict the dictatorship of the class
either theoretically or practically; but is the expression of it, if the
regime of workers' democracy is constantly developed more and more."_ [**The
Challenge of the Left Opposition (1926-27)**, p. 76] The obvious
contradictions and absurdities of this assertion are all too plain. Needless
to say, when defending the concept of _"the dictatorship of the party"_ he
linked it to Lenin (and so to Leninist orthodoxy):

> _"Of course, the foundation of our regime is the dictatorship of a class.
But this in turn assumes . . . it is class that has come to self-consciousness
through its vanguard, which is to say, through the party. Without this, the
dictatorship could not exist . . . Dictatorship is the most highly
concentrated function of function of a class, and therefore the basic
instrument of a dictatorship is a party. In the most fundamental aspects a
class realises its dictatorship through a party. That is why Lenin spoke not
only of the dictatorship of the class but also the dictatorship of the party
and, **in a certain sense**, made them identical."_ [**Op. Cit.**, pp. 75-6]

The following year saw Trotsky state that _"[w]ith us the dictatorship of the
party (quite falsely disputed theoretically by Stalin) is the expression of
the socialist dictatorship of the proletariat . . . The dictatorship of a
party is a part of the socialist revolution"_. [**Leon Trotsky on China**, p.
251] 1927 also saw the publication of the **Platform of the Opposition**, in
which Trotsky **still** did not question the issue of Party dictatorship.
Indeed, it was actually stressed in that document and so while it urged a
_"consistent development of a workers' democracy in the party, the trade
unions, and the soviets"_ and to _"convert the urban soviets into real
institutions of proletarian power"_ it contradicted itself by, ironically,
attacking Stalin for weakening the party's dictatorship. In its words, the
_"growing replacement of the party by its own apparatus is promoted by a
'theory' of Stalin's which denies the Leninist principle, inviolable for every
Bolshevik, that the dictatorship of the proletariat is and can be realised
only through the dictatorship of the party."_ It stressed that _"the
dictatorship of the proletariat demands a single and united proletarian party
as the leader of the working masses and the poor peasantry"_ and _"[n]obody
who sincerely defends the line of Lenin can entertain the idea of 'two
parties' or play with the suggestion of a split. Only those who desire to
replace Lenin's course with some other can advocate a split or a movement
along the two-party road"_. Given this: _"We will fight with all our power
against the idea of two parties, because the dictatorship of the proletariat
demands as its very core a single proletarian party. It demands a single
party."_ [**The Challenge of the Left Opposition (1926-7)**, p. 384, p. 395,
p. 439 and p. 441]

The Platform was as anti-democratic economically as it was politically,
asserting that _"nationalisation of the means of production was a decisive
step toward the socialist reconstruction of that whole social system which is
founded upon the exploitation of man by man"_ and that the _"appropriation of
surplus value by a workers' state is not, of course, exploitation"_ yet makes
no call for workers' management of production (unsurprisingly as one-man
management had been raised by Lenin in early 1918 and became Bolshevik
orthodoxy as Trotsky had explained in 1920). The Platform does acknowledge
that _"we have a workers' state with bureaucratic distortions"_ and so its
_"swollen and privileged administrative apparatus devours a very considerable
part of our surplus value"_ and _"the growing bourgeoisie, by means of trade
and gambling on the abnormal disparity of prices, [also] appropriates a part
of the surplus value created by our state industry"_. Thus _"all the data
testify that the growth of wages is lagging behind the growth of the
productivity of labour."_ [**Op. Cit.**, p. 347, p. 348 and p. 350] Trotsky
appeared to believe that an economic regime marked by one-man management by
state-appointed bosses under a party dictatorship would somehow be without
exploitation even though someone other than the workers controlled both their
labour and how its product (and any surplus) was used -- just as in a
capitalist workplace. He failed to understand that this exploitation was the
inevitable result of the economic regime he considered as "socialist" --
namely _"nationalisation of the means of production"_ which simply handed the
economy to the bureaucracy and created state capitalism (see [section
H.3.13](secH3.md#sech313)). This did not abolish _"the exploitation of man
by man"_ but rather changed the social class which exploited the working class
from private capitalists to state bureaucrats -- as anarchists had predicted
from Proudhon onwards.



Of course **The Platform** did not bother to explain how workers' democracy
**could** develop within a party dictatorship nor how soviets could become
institutions of power when real power would, obviously, lie with the party.
But, then, it did not have to as by _"workers' democracy"_ the Platform meant
inter-party democracy, as can be seen when it _"affirm[s]"_ the _"New Course
Resolution"_ definition quoted above. [**Op. Cit.**, p. 402]



As is well know, the Opposition was crushed and Trotsky forced into exile.
This did not lead to a fundamental re-evaluation of the degeneration of the
revolution and the need for genuine soviet democracy. A key task was _"[t]o
stop the dissolution of the party into the class in the USSR"_ and so, perhaps
unsurprisingly, Soviet democracy went unmentioned. [**Writings 1930**, p. 148]
Repeating previous arguments, Trotsky was fundamentally concerned about the
dangers _"if the vanguard is dissolved into the amorphous mass"_ for _"the
party is not the class, but its vanguard; it cannot pay for its numerical
growth by the lowering of its political level"_. There was _"the demand of
party democracy"_ for the dictatorship of the proletariat _"is inconceivable
without a ruling proletarian party"_ but nothing on working class freedom or
democracy. Perhaps this is unsurprising: _"What we mean by the restoration of
party democracy is that the real revolutionary, proletarian core of the party
win the right to curb the bureaucracy and to really purge the party"_. In
other words, the first act of the successful Opposition would have been the
reduction in numbers of those who had some kind of meaningful vote. Rest
assured, though, because the new party regime _"means that the party directs
the proletarian dictatorship but does not strangle the mass organisations of
the toilers"_ and the secret ballot is _"one of the most important means to
discipline the entire apparatus and subordinate it to the party"_. [**Writings
1930-31**, p. 241, p. 244, p. 247, pp. 255-6, p. 70 and p. 130] Clearly
_"socialism's democratic essence"_ was, at best, applicable to within the
ruling party -- or at least what remained of it after the purges.

In 1932, he was arguing that the _"same class can rule with the help of
different political systems and methods according to circumstances. So the
bourgeoisie on its historical road carried through its rule under absolute
monarchy, bonapartism, parliamentary republic and fascist dictatorship . . .
the Soviet regime means the rule of the proletariat, irrespective of how broad
the stratum on whose hands the power is **immediately concentrated**."_ This
was justification for his denial that there was _"a small group in the Kremlin
who exercise oligarchical powers"_ (_"No, that is not so"_). [**Writings
1932**, p. 217] Trotsky seemed to have forgotten that the bourgeoisie was a
minority class which controlled the economic life of a country. Given this, it
is not surprising that it could still rule under dictatorships. The same
cannot be said of the working class -- particularly if, as under Lenin and
Trotsky, its democratic control of work and so the economy was replaced by
one-man management. Yet Trotsky had no alternative to make such an obviously
wrong assertion -- to acknowledge the truth, that socialism needs meaningful
workers' social and economic democracy to qualify as genuinely socialist --
would have meant raising questions over the nature of the Bolshevik regime
between 1918 and 1923 when he was at its commanding heights. Hence clearly
incorrect assertions like: _"The dictatorship of a class does not mean by a
long shot that its entire mass always participates in the management of the
state"_ [**Writings 1933-34**, p. 124]

In 1936 Trotsky finally appeared to revise his ideas in **The Revolution
Betrayed**, although his revisionism in terms of democracy was combined with
revisionism in the events of the Russian Revolution. It would be fair to
suggest that McNally's account of Trotsky's ideas may be based on this work
for in stark contrast to his early arguments he now stated that
_"[b]ureaucratic autocracy must give place to Soviet democracy. A restoration
of the right of criticism, and a genuine freedom of elections, are necessary
conditions for the further development of the country. This assumes a revival
of freedom of Soviet parties, beginning with the party of Bolsheviks"_. [**The
Revolution Betrayed**, p. 273] Given his previous comments on the matter, the
reader would be justified in wondering whether, rather than a sincere change
of heart, Trotsky's position was a limited and temporary aberration
(Anarchist-turned-Bolshevik Victor Serge, who later broke with Trotsky over
this issue, stated that he _"had prevailed on him to include in"_ this book
_"a declaration of freedom for all parties accepting the Soviet system."_
[**Memoirs of a Revolutionary**, p. 348]).

The evidence suggests the latter, that it was a temporary aberration --
particularly given the misleading account of the rise of the Bolshevik
dictatorship. Thus we find Trotsky suggesting that it was 1924-26 that saw
_"the complete suppression of party and Soviet democracy"_ when, as noted
above, he was publicly acknowledging the reality of party dictatorship in
1920. He also forgot the ideas of his own Opposition from 1927 and in 1936 it
was no longer was it a case of the necessity of a single party as _"a class
has many 'parts' -– some look forward and some back -– [and so] one and the
same class may create several parties . . . An example of only one party
corresponding to one class is not to be found in the whole course of political
history -– provided, of course, you do not take the police appearance for the
reality."_ That the need for the dictatorship of the vanguard was justified
**precisely** in terms of the backwardness of the class and other parties was
forgotten. Likewise, the acknowledgement of party dictatorship as a principle
of Leninism was overlooked in favour of the suggestion that the civil war
resulted in the opposition parties being _"forbidden one after the other"_ and
while this was _"obviously in conflict with the spirit of Soviet democracy,
the leaders of Bolshevism regarded [it] not as a principle, but as an episodic
act of self-defence."_ [**Op. Cit.**, p. 34, p. 252 and p. 96] It would be
churlish to note that the final abolition of opposition parties -- like
factions within the ruling party -- occurred **after** the end of the civil
war.

These awkward facts did not stop Trotsky from suggesting a fundamental
difference between the Leninist and Stalinist dictatorships:

> _"To be sure, during the first period of the Soviet era the Bolshevik party
also exercised a monopoly. But to identify these two phenomena would be to
take appearance for reality. The prohibition of opposition parties was a
temporary measure dictated by conditions of civil war, blockade, intervention
and famine. The ruling party, representing in that period a genuine
organisation of the proletarian vanguard, was living a full-blooded inner
life. A struggle of groups and factions to a certain degree replaced the
struggle of parties. At present, when socialism has conquered 'finally and
irrevocably,' the formation of factions is punished with concentration camp or
firing squad. The prohibition of other parties, from being a temporary evil,
has been erected into a principle."_ [**Op. Cit.**, p. 251]

In reality, the necessity of a party dictatorship was embraced by leading
Bolsheviks like Trotsky and proclaimed to the world Socialist movement. The
prohibition of opposition parties was not lamented at the time but rather
raised to a principle (a Leninist principle, no less!) and implemented after
victory in the civil war was secure. Factions were banned -- with Trotsky's
wholehearted support -- precisely because, as he later noted, they had
replaced the struggle of parties. Nor was Trotsky bothered by state repression
of opposition when he was in charge. For example a series of (unofficial)
strikes broke out in July and August 1923 in Moscow and Petrograd and this
_"gave a new lease of life to the Mensheviks"_ and so _"the GPU carried out a
massive round up of Mensheviks, and as many as one thousand were arrested in
Moscow alone."_ [Tony Cliff, **Trotsky**, vol. 3, p. 25] When it was the turn
of the ex-Bolsheviks in the Workers' Group, Trotsky _"was not at all eager to
defend"_ them and _"did not protest when their adherents were thrown into
prison. Nor was he at all eager to support their demand for soviet democracy
in that extreme form"_. [Isaac Deutscher, **The Prophet Unarmed**, pp. 108-9]
It should be noted that rather than _"extreme"_ a better word would have been
_"genuine"_ as the Workers' Group, unlike Trotsky, **did** call for a multi-
party workers' democracy -- and paid the price. Indeed, the _"New Course
Resolution"_ even went so far as to say that _"it is obvious that there can be
no toleration of the formation of groupings whose ideological content is
directed against the party as a whole and against the dictatorship of the
proletariat, as for instance the Workers' Truth and Workers' Group."_ [**The
Challenge of the Left Opposition (1923-25)**, p. 408]

It would be remiss to not note how limited Trotsky's position was: being
limited to the Soviet Union it does not automatically negate his arguments
previously made to the international socialist movement. Moreover, given the
revisionism of the origins of the Bolshevik dictatorship it is legitimate to
ponder how honest Trotsky's statement is. He stated that if _""the Soviet
bureaucracy is overthrown by a revolutionary party having all the attributes
of the old Bolshevism"_ then it _"would begin with the restoration of
democracy in the trade unions and the Soviets"_ and it _"would be able to, and
would have to, restore freedom of Soviet parties."_ Yet it was precisely the
Bolsheviks who decreed that other parties within the Soviets were not genuine
Soviet parties after all and repressed them. What guarantee exists that once
the Bolsheviks had been revived (i.e., his faction took over) they did not
conclude, as before, the necessity of party dictatorship? None. After all, did
he not suggest that the _"dictatorship of the Bolshevik party proved one of
the most powerful instruments of progress in history"_? [**Op. Cit.**, pp.
238-9 and p. 104]

This limited support for Soviet Democracy was short-lived. Writing in 1937,
ten years after the Platform was published and a year after **The Revolution
Betrayed**, Trotsky was reiterating the privileged position of the party. In
his essay _"Bolshevism and Stalinism"_ he argued quite explicitly that _"the
proletariat can take power only through its vanguard"_ and that _"the
necessity for state power arises from an insufficient cultural level of the
masses and their heterogeneity."_ Only with _"support of the vanguard by the
class"_ can there be the _"conquest of power"_ and it was in _"this sense the
proletarian revolution and dictatorship are the work of the whole class, but
only under the leadership of the vanguard."_ Thus, rather than the working
class as a whole seizing power, it is the _"vanguard"_ which takes power --
_"a revolutionary party, even after seizing power . . . is still by no means
the sovereign ruler of society."_ Note, the party is _"the sovereign ruler of
society,"_ **not** the working class. Nor can it be said that he was not clear
who held power in his system: state power is required to **govern the
masses,** who cannot exercise power themselves as _"[t]hose who propose the
abstraction of Soviets to the party dictatorship should understand that only
thanks to the Bolshevik leadership were the Soviets able to lift themselves
out of the mud of reformism and attain the state form of the proletariat."_
[**Writings 1936-37**, p. 490, p. 488 and p. 495] Later that same year he
repeated this position clearly and unambiguously:

> _"The revolutionary dictatorship of a proletarian party is for me not a
thing that one can freely accept or reject: It is an objective necessity
imposed upon us by the social realities -- the class struggle, the
heterogeneity of the revolutionary class, the necessity for a selected
vanguard in order to assure the victory. The dictatorship of a party belongs
to the barbarian prehistory as does the state itself, but we can not jump over
this chapter, which can open (not at one stroke) genuine human history . . .
The revolutionary party (vanguard) which renounces its own dictatorship
surrenders the masses to the counter-revolution . . . Abstractly speaking, it
would be very well if the party dictatorship could be replaced by the
'dictatorship' of the whole toiling people without any party, but this
presupposes such a high level of political development among the masses that
it can never be achieved under capitalist conditions. The reason for the
revolution comes from the circumstance that capitalism does not permit the
material and the moral development of the masses."_ [**Op. Cit.**, pp. 513-4]

Which was, let us not forget, his argument in 1920. Such remarkable
consistency on this point over a 17 year period and one which cannot be
overlooked if you seek to present an accurate account of Trotsky's ideas
during this period. Significantly, this was the year after his apparent (and
much belated) embrace of soviet democracy for the USSR in **The Revolution
Betrayed** and so that work must be considered as a temporary aberration,
quickly rejected. His advice on what to do during the Spanish Revolution
followed this pattern: _"Because the leaders of the CNT renounced dictatorship
**for themselves** they left the place open for the Stalinist dictatorship."_
[our emphasis, **Op. Cit.**, p. 514] So much for workers' power!

The following year saw Trotsky produce an article defending the suppression of
the Kronstadt revolt which proclaimed that a _"revolution is 'made' directly
by a **minority**. The success of a revolution is possible, however, only
where this minority finds more or less support, or at least friendly
neutrality, on the part of the majority. The shift in different stages of the
revolution, like the transition from revolution to counterrevolution, is
directly determined by changing political relations between the minority and
the majority, between the vanguard and the class."_ [_"Hue and Cry Over
Kronstadt"_, Lenin and Trotsky, **Kronstadt**, p. 85] Given that Kronstadt had
rebelled against the Bolshevik dictatorship for soviet democracy, Trotsky's
argument suggests that for him the rule of the party (the _"minority . . . the
vanguard"_) is more important than soviet democracy (see the appendix on
["What was the Kronstadt Rebellion?"](append42.md) for more details of this
key event in the history of the Russian Revolution). In other words, if the
majority come to reject the minority then the former shows lack of sufficient
class awareness and so the latter needs, as in Kronstadt, to use state power
to secure its ruling position. This is implicit in the following strange
comment:

> _"It is true that some of them [the critics of Bolshevism] recognise the
revolution and the dictatorship –- in words. But this does not help matters.
They wish for a revolution which will not lead to dictatorship or for a
dictatorship which will get along without the use of force. Of course, this
would be a very 'pleasant' dictatorship. It requires, however, a few trifles:
an equal and, moreover, an extremely high, development of the toiling masses.
But in such conditions the dictatorship would in general be unnecessary. Some
Anarchists, who are really liberal pedagogues, hope that in a hundred or a
thousand years the toilers will have attained so high a level of development
that coercion will prove unnecessary. Naturally, if capitalism could lead to
such a development, there would be no reason for overthrowing capitalism.
There would be no need either for violent revolution or for the dictatorship
which is an inevitable consequence of revolutionary victory"_ [**Op. Cit.**,
pp. 92-3]

Given that the so-called "dictatorship of the proletariat" is meant to be the
means by which the proletariat coerce the former ruling elite, it is strange
to read Trotsky argue that coercion becomes unnecessary if the toiling masses
have a high level of political development. Why would the ruling elite stop
their attempts at counter-revolution in those circumstances? That seems
unlikely so we can only conclude that the coercion (like the dictatorship) is
directed against the _"toiling masses"_ by the ruling party. This is confirmed
the following year (1939) when Trotsky repeats the same dictatorial ideas of
1921 by indicating -- yet again -- that he viewed democracy as a threat to the
revolution and saw the need for party power over workers' freedom:

> _"The very same masses are at different times inspired by different moods
and objectives. It is just for this reason that a centralised organisation of
the vanguard is indispensable. Only a party, wielding the authority it has
won, is capable of overcoming the vacillation of the masses themselves . . .
if the dictatorship of the proletariat means anything at all, then it means
that the vanguard of the proletariat is armed with the resources of the state
in order to repel dangers, including those emanating from the backward layers
of the proletariat itself."_ [_"The Moralists and Sycophants against
Marxism"_, pp. 53-66, **Their Morals and Ours**, p. 59]

Needless to say, **by definition** everyone is _"backward"_ when compared to
the _"vanguard of the proletariat."_ Moreover, as it is this _"vanguard"_
which is _"armed with the resources of the state"_ and **not** the proletariat
as a whole we are left with one obvious conclusion, namely party dictatorship
rather than working class freedom. This is because such a position means
denying exactly what workers' democracy is meant to be all about -- namely
that working people can recall and replace their delegates when those
delegates do not follow the wishes and mandates of the electors. If the
governors determine what is and what is not in the "real" interests of the
masses and "overcome" (i.e. repress) the governed, then we have dictatorship,
not democracy.

Trotsky was hardly alone in his views given that they were Bolshevik
orthodoxy. Amazingly enough, even in the Russian prison camps in the late
1920s and early 1930s, _"almost all the Trotskyists continued to consider that
'freedom of party' would be 'the end of the revolution.' 'Freedom to choose
one's party -- that is Menshevism,' was the Trotskyists' final verdict."_ This
was because it had been _"condemned formerly by Lenin, by Trotsky"_ as well as
by other Opposition Groups. [Ante Ciliga, **The Russian Enigma**, p. 280] As
Left Oppositionist Victor Serge pointed out _"the greatest reach of boldness
of the Left Opposition in the Bolshevik Party was to demand the restoration of
inner-Party democracy, and it never dared dispute the theory of single-party
government -- by this time, it was too late."_ [**The Serge-Trotsky Papers**,
p. 181] Sadly, like Trotsky's **The Revolution Betrayed**, Serge's later
**Memoirs** paint a different picture by asserting one of its _"great
fundamental ideas"_ was _"working-class democracy"_! [**Memoirs of a
Revolutionary**, p. 252]

As can be seen, McNally does not present a remotely accurate account of
Trotsky's ideas during the 1920s and 1930s. All of which makes McNally's
comments deeply ironic. He argues that _"Stalin had returned to an ideology
resembling authoritarian pre-Marxian socialism. Gone was socialism's
democratic essence. Stalin's 'Marxism' was a variant of socialism from above"_
Clearly, Trotsky's Marxism was also a variant of _"socialism from above"_ and
without _"socialism's democratic essence"_ (unless you think that party
dictatorship can somehow be reconciled with democracy or expresses one of the
_"basic elements of socialism from below"_). For Trotsky, as for Stalin, the
dictatorship of the party was a fundamental principle of Bolshevism and one
which was above democracy (which, by its very nature, expresses the
_"vacillation of the masses"_). Compare McNally's words on Stalinism to
Trotsky's position:

> _""For [Stalin's] group, 'socialism' lost all foundation in organs of
workers' democracy, soviets . . . They came increasingly to identify socialism
with a bureaucratic monopoly of power which allowed no place for organs of
mass democracy . . . Gone was the commitment to workers' democracy and
international socialism . . . Stalin undertook to reshape the entire nature
and direction of Russian society . . . the elimination of all dissent; the
liquidation of all forms of democracy and of genuine working class
organisation . . . "_

Given that the identification of socialism with the party's _"monopoly of
power"_ as well as removal of _"the commitment to workers' democracy"_
occurred under Lenin and that Trotsky's defended this, the question arises was
there any fundamental difference between Leninism and Stalinism? As Victor
Serge admitted, _"a good many Oppositionists rallied to the [Stalinist]
'general line' and renounced their errors since, as they put it, 'After all,
it is our programme that is being applied'"_ [**Op. Cit.**, p. 252] Hence Emma
Goldman:

> _"In point of truth I see no marked difference between the two protagonists
of the benevolent system of the dictatorship except that Leon Trotsky is no
longer in power to enforce its blessings, and Josef Stalin is . . . Stalin did
not come down as a gift from heaven to the hapless Russian people. He is
merely continuing the Bolshevik traditions, even if in a more relentless
manner . . . I admit, the dictatorship under Stalin's rule has become
monstrous. That does not, however, lessen the guilt of Leon Trotsky as one of
the actors in the revolutionary drama"_ [_"Trotsky Protests Too Much"_,
**Writings of Emma Goldman**, pp. 251-2]

Ante Ciliga saw the similarities first-hand while in prison in the Soviet
Union, noting that the Trotskyists _"who were in prison for anti-Stalinism
could find nothing better to do than to indulge in Stalinism themselves [in
their political groups] while in prison. This absurdity was only apparent; it
merely served to prove that between Trotskyism and Stalinism there were many
points in common"_. The outlook of the Trotskyist majority _"was not very
different from that of the Stalinist bureaucracy; they were slightly more
polite and human, that was all."_ [**Op. Cit.**, p. 218 and p. 263] This is
unsurprising given, as indicated, the same Bolshevik political legacy and same
class position (Trotskyists were labelled _"the bureaucracy in exile"_). It
may have been that if the Trotskyists had won the inter-bureaucracy struggle
in the mid-1920s then the Soviet Union would have avoided the horrors of
Stalinism but it would have remained a state capitalist party dictatorship
and, as such, a class system in which the few exploit, oppress and repress the
many. That this few would have exploited the many less ruthlessly and aimed to
impose similar regimes internationally rather than concentrating on building
_"socialism in one country"_ does not mean much.

Needless to say, Goldman had no difficulty in recognising that Bolshevik
Russia was _"State Capitalism"_ in the early 1920s (i.e., when Trotsky was
still part of the ruling class). [**My Disillusionment in Russia**, p. 247]
McNally argues that _"[b]y making the nature of property ownership the
criterion of workers' state"_ rather than _"workers' power and workers'
democracy"_ Trotsky had _"committed an error that was seriously to disorient
the Trotskyist movement in later years. For, unwittingly, Trotsky had broken
from the most basic precepts of socialism from below."_ Yet what alternative
did he have? After all, both workers' democracy and power had been eliminated
when he held power alongside Lenin and he did not consider the first -- bar
for a short period in 1936 -- as important enough to advocate and equated the
second with party rule. So if McNally's criteria is taken seriously then we
must conclude that the Bolshevik regime had not been a "workers' state" since
mid-1918 nor did Trotsky aim for one during the 1920s and 1930s. Which raises
the awkward question of why McNally thinks he had not broken _"from the most
basic precepts of socialism from below"_ by defending Lenin's party
dictatorship and Trotsky's attempts to recreate it? Does having the right
people in power make _"workers' control of society"_ an optional extra for
_"socialism from below"_?

McNally then suggests that this breaking with _"the most basic precepts of
socialism from below"_ by not recognising Stalinist Russia was _"a system of
bureaucratic state capitalism in which capital is collectively controlled by
the privileged bureaucracy that controls the state"_ was _"not readily
apparent during Trotsky's lifetime."_ Far from it -- anarchists had recognised
the grim reality of the new Bolshevik state from early 1918 and indicated that
it had confirmed the fears raised by Bakunin in his polemics with Marx (see
[section H.3.13](secH3.md#sech313)). It is worth indicating these arguments
since we did not have to wait until the 1940s before drawing what to the
uninitiated was an obvious conclusion -- that the Soviet Union was a state
capitalist dictatorship run by and for a new ruling minority.

A state, Bakunin argued, _"stands outside the people and above them"_ and so
was _"the government of society from above downward"_ which resulted in the
_"actual subordination of the sovereign people to the intellectual minority
that governs them."_ It was the _"government of the masses from above
downwards"_ by a minority _"which supposedly understands the real interests of
the people better than the people themselves"_. However, _"power corrupts
those invested with it just as much as those compelled to submit to it"_ and
the _"government of the majority by a minority in the name of the presumed
stupidity of the one and the presumed intelligence of the other"_ would have
_"the direct and inevitable result of consolidating the political and economic
privileges of the governing minority and the political and economic slavery of
the masses"_. Bakunin recognised the elitism inherent in Trotsky's privileging
of the party (the vanguard) and argued that while it was claimed _"those
elected will be passionately committed as well as learned socialists"_ the
reality would be that _"the pseudo-popular state will be nothing but the
highly despotic government of the masses by a new and very small aristocracy
of real or pretended scholars. The people are not learned, so they will be
liberated in entirety form the cares of government and included in entirety in
the governed herd. A fine liberation!"_ The new government would _"begin to
look upon the whole workers’ world from the heights of the state. They will no
longer represent the people but themselves and their own pretensions to govern
the people."_ Rather than securing the freedom of the people _"no dictatorship
can have any other objective than to perpetuate itself, and that it can
engender only slavery in the people who endure it"_. [**Statism and Anarchy**,
p. 136, p. 198, p. 13, p. 24, p. 136, p. 137, pp. 178-9, p. 178 and p. 179]

Economically, the workers would remain oppressed and exploited as the Marxists
would _"concentrate the reins of government in a strong hand, because the
ignorant people require strong supervision. They will create a single state
bank, concentrating in their own hands all commercial, industrial,
agricultural, and even scientific, production, and will divide the people into
two armies, one industrial and one agrarian, under the direct command of state
engineers, who will form a new privileged scientific and political class."_
The state bureaucracy would become the new ruling class, _"a new bureaucratic
aristocracy"_ who are _"corrupted by state service"_, and as soon as _"they
enter state service . . . the iron logic of their position, the force of
circumstances inherent in certain hierarchical and profitable relationships,
makes itself felt and . . . [they] become bureaucrats from head to toe . . .
The demands of a certain position always prove stronger than sentiments,
intentions, or good impulses . . . They have to become members of the
bureaucratic class . . . they become enemies of the people, whether they want
to or not"_. [**Op. Cit.**, p. 181 and p. 51]

Clearly the Bolshevik experience confirmed Bakunin's critique of Marxism while
the Makhnovist insurrectionary army in the Ukraine confirmed the validity of
the anarchist alternative (see the appendix ["Why does the Makhnovist movement
show there is an alternative to Bolshevism?"](append46.md) for details). As
such, it is ironic to read McNally state that _"[t]hroughout the 1920s and
until his death . . . Trotsky fought desperately to build a revolutionary
socialist movement based on the principles of Marx and Lenin."_ Leaving Marx
to one side for the moment, McNally's comments are correct simply because in
his advocacy of party power and dictatorship (for a _"socialism from above,"_
to use McNally's term) Trotsky was indeed following Lenin's principles and
Bolshevik orthodoxy. As noted in the [last section](append31.md#app14),
Lenin had been arguing from a "socialism" based on _"above"_ and _"below"_
since at least 1905 (which, to show their Marxist orthodoxy, he linked to
Engels and his arguments against Bakunin.) The reality of Bolshevik rule (as
indicated in [section 8](append31.md#app8)) showed that pressure _"from
above"_ by a "revolutionary" government easily crushes pressure "from below"
in the name, as Trotsky constantly stressed throughout the 1920s and 1930s, of
the advanced political ideas of the Bolshevik party leaders. Yet despite Lenin
and Trotsky's dismissal of democracy, McNally argues that democracy is the
core need of socialism:

> _ "A workers' state, according to Marx and Lenin, is a state based upon
workers' control of society. It depends upon the existence of democratic
organisation that can control society from below. A workers' state presupposes
that workers are running the state. To talk of a workers' state is necessarily
to talk of workers' power and workers' democracy."_

Which, as far as it goes, is correct (for anarchists, of course, the idea that
a state can be run from below is utopian -- it is not designed for that and no
state has ever been). Sadly for his argument, both Lenin and Trotsky argued
against the idea of workers' democracy and, in stark contrast, argued that the
dictatorship of the party was essential for a successful revolution. Indeed,
they both explicitly argued against the idea that a mass, democratic
organisation could run society during a revolution. The need for party power
was raised explicitly to combat the fact that the workers' could change their
minds and vote against the vanguard party. As such, the founding fathers of
the SWP/ISO political tradition explicitly argued that a workers' state had to
reject workers power and democracy in order to ensure the victory of the
revolution. Clearly, according to McNally's own argument, his own politics
cannot be considered as "socialism from below" as it explicitly argued that a
workers' state did not "necessarily" mean workers' power or democracy.

As indicated above, for the period McNally **himself** selects (the 1920s and
1930s), Trotsky consistently argued that the Bolshevik tradition the SWP/ISO
places itself was based on the _"Leninist principle"_ of party dictatorship.
For McNally to talk about Trotsky keeping _"socialism from below"_ alive is,
therefore, truly amazing. It either indicates a lack of awareness of Trotsky's
ideas or a desire to deceive. To be fair to McNally, the notion that Trotsky's
Opposition supported genuine workers' democracy seems to be a common fallacy
in SWP circles. Thus Chris Harman asserted that the _"alternative to
Stalinism"_ in the late 1920s was _"returning to genuine workers' democracy
and consciously linking the fate of Russia to the fate of the world
revolution"_ (while allowing _"a limited development of heavy industry"_) and
it was the _"historical merit of the Left Opposition"_ that _"it framed a
policy along these lines."_ [Chris Harman, **Bureaucracy and Revolution in
Eastern Europe**, p. 19] Clearly McNally is not the only Leninist unable -- or
unwilling -- to discover the grim truth about the Left Opposition or, for that
matter, the reality of Bolshevik rule.

For anarchists, we stress, the Bolshevik substitution of party power for
workers power did not come as a surprise. The state is the delegation of
**power** \-- as such, it means that the idea of a "workers' state" expressing
"workers' power" is a logical impossibility (see [section
H.3.7](secH3.md#sech37)). If workers **are** running society then power
rests in their hands. If a state exists then power rests in the hands of the
handful of people at the top, **not** in the hands of all. The state was
designed for minority rule. No state can be an organ of working class (i.e.
majority) self-management due to its basic nature, structure and design.

For this reason anarchists from Bakunin onwards have argued for a bottom-up
federation of workers' councils as the agent of revolution and the means of
managing society after capitalism and the state have been abolished. If these
organs of workers' self-management are co-opted into a state structure (as
happened in Russia) then their power will be handed over to the **real** power
in any state -- the government (in this case, the Council of People's
Commissars). They will quickly become mere rubberstamps of the organisation
which holds the reigns of power, the vanguard party and its central committee.

McNally rewrites history by arguing that it was _"Stalin's counter-
revolution"_ which saw _"communist militants . . . executed, peasants
slaughtered, the last vestiges of democracy eliminated."_ The SWP/ISO usually
date this "counter-revolution" to 1928 (the defeat of the Left Opposition and
the first Five Year Plan). However, long before this date there was no
_"vestiges"_ of meaningful democracy left -- as Trotsky himself made clear in
his comments in favour of party dictatorship between 1920 and 1923. Indeed,
Trotsky had supported the repression of the Kronstadt revolt which had called
for soviet democracy. McNally ignores this and instead argues that Trotsky
_"acknowledged that the soviets had been destroyed, that union democracy had
disappeared, that the Bolshevik party had been stripped of its revolutionary
character"_ under Stalinism. Yet, as we discusse in [section H.6](secH6.md),
the Bolsheviks had already destroyed soviet democracy, undermined union
democracy and repressed all revolutionary elements outside of the party,
argued for the introduction of state capitalism and the appointment of "one-
man management" as well as repressing peasants and striking and protesting
workers long before the start of the Russian Civil War in late May 1918. In
short, the Bolsheviks had introduced much of which McNally denounces as
"Stalinism" before the war he uses to excuse them for all responsibility for
its rise. As Maurice Brinton rightly states:

> _"there is a clear-cut and incontrovertible link between what happened under
Lenin and Trotsky and the later practices of Stalinism . . . The more one
unearths about this period the more difficult it becomes to define -- or even
to see -- the 'gulf' allegedly separating what happened in Lenin's time from
what happened later. Real knowledge of the facts also makes it impossible to
accept . . . that the whole course of events was 'historically inevitable' and
'objectively determined'. Bolshevik ideology and practice were themselves
important and sometimes decisive factors in the equation, at every critical
stage of this critical period [between 1917 and 1921]"_ [_"The Bolsheviks and
Workers' Control"_, **For Workers' Power**, p. 376]

To draw a sharp distinction between Stalinism and Bolshevism is difficult, if
not impossible, to make based on McNally's own criteria. That Stalinism was
more brutal, more unequal, more despotic is true but that does not change the
similarities in social relationships between the two -- both were dictatorial
state capitalist regimes. That the repression did not extend to within the
Bolshevik party is a weak hook to hang a theory on.

During his analysis of the failure of orthodox Trotskyism, McNally states that
after the second world war _"the Trotskyist movement greeted"_ the various new
Stalinist regimes in Eastern Europe and elsewhere _"as workers' states"_ in
spite of being _"brutally undemocratic state capitalist tyrannies."_ Given
that the SWP/ISO and a host of other Leninist groups still argue that Lenin's
brutally undemocratic state capitalist tyranny was some kind of "workers'
state" McNally's comments seem deeply ironic. As such, Trotsky's defence of
Stalinism as a _"degenerated workers' state"_ is not as surprising nor as
puzzling as McNally tries to claim. If, as he argues, _"[t]o talk of a
workers' state is necessarily to talk of workers' power and workers'
democracy"_ then Lenin's regime had ceased to be a "workers' state" (if such a
thing could exist) by the spring of 1918 at the latest. For anarchists (and
libertarian Marxists) the similarities are all too clear between the regime
under Lenin and that under Stalin. That McNally cannot see the obvious
similarities suggests a lack of objectivity and a weak commitment to the
principles of _"socialism from below"_

He sums up his account of the post-Second War World Trotskyists by arguing
that _"the movement Trotsky had created fell victim to the ideology of
socialism from above."_ Unfortunately for his claims, this is not the case. As
proven above, Trotsky had consistently argued for the dictatorship of the
party between 1920 and 1940 and so Trotskyism had always been based on _"the
ideology of socialism from above."_ Trotsky had argued for party dictatorship
simply because democratic mass organisations would allow the working class to
express their _"wavering"_ and _"vacillations."_ Given that, according to
those who follow Bolshevik ideas, the working class is meant to run the so-
called "workers' state" Trotsky's arguments are extremely significant. He
explicitly acknowledged that under Bolshevism the working class does **not**
actually manage their own fates but rather the vanguard party does. This is
cannot be anything **but** _"socialism from above."_ If, as McNally argues,
Trotsky's _"fatal error"_ in not recognising that Stalinism was state
capitalism came from _"violating the principles of socialism from below,"_
then this _"fatal error"_ is at the heart of the Leninist tradition.

As such, the roots of Trotsky's _"fatal error"_ can be traced further back
than the rise of Stalin. Its real roots lie with the idea of a "workers'
state" and so with the ideas of Marx and Engels. As Bakunin argued against
Marx (and anarchists have repeated since) the state is, by its nature, a
centralised and top-down machine. By creating a "revolutionary" government,
power is automatically transferred from the working class into the hands of a
few people at the top. As they have the real, **de facto**, power in the
state, it is inevitable that they will implement "socialism from above" as
that is how the state is structured. As Bakunin argued, all states _"are in
essence only machines governing the masses from above"_ by a _"privileged
minority, allegedly knowing the genuine interests of the people better than
the people themselves."_ The idea of a state being run "from below" makes as
much sense as "dry rain." Little wonder Bakunin argued for a _"federal
organisation, from the bottom upward, of workers' associations, groups, city
and village communes, and finally of regions and peoples"_ as _"the sole
condition of a real and not fictitious liberty."_ In other words: _"Where all
rule, there are no more ruled, and there is no State."_ [**The Political
Philosophy of Bakunin**, p. 211, p. 210 and p. 223] Only this, the destruction
of every state and its replacement by a free federation of workers' councils,
can ensure a real _"socialism from below"_.

Therefore, rather than signifying the working class running society directly,
the "workers' state" actually signifies the opposite -- namely, that the
working class has delegated that power and responsibility to **others**,
namely the government. As Leninism supports the idea of a "workers' state"
then it is inevitably and logically tied to the idea of "socialism from
below." Given that Lenin himself argued that "only from below" was an
anarchist principle, we can easily see what the _"fatal error"_ of Trotsky
**actually** was. By rejecting anarchism he automatically rejected **real**
_"socialism from below."_

Sadly for McNally, Trotsky did not, as he asserts, embrace the _"democratic
essence"_ of Leninism in the 1920s or 30s. Rather, as is clear from Trotsky's
writings, he embraced party dictatorship (i.e. _"socialism from above"_) and
considered this as quite compatible (indeed, an essential aspect) of his
Leninist ideology. That McNally fails to indicate this and, indeed, asserts
the exact opposite of the facts shows that it is not only anarchism he is
ignorant about.

[‹ Appendix : Anarchism and Marxism](append3.md "Go to previous page" )
[up](append3.md "Go to parent page" ) [Marxists and Spanish Anarchism
›](append32.md "Go to next page" )

