// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::{Caps, Object, StreamFlags, StreamType, TagList};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GstStream")]
    pub struct Stream(Object<ffi::GstStream, ffi::GstStreamClass>) @extends Object;

    match fn {
        type_ => || ffi::gst_stream_get_type(),
    }
}

impl Stream {
    #[doc(alias = "gst_stream_new")]
    pub fn new(
        stream_id: Option<&str>,
        caps: Option<&Caps>,
        type_: StreamType,
        flags: StreamFlags,
    ) -> Stream {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::gst_stream_new(
                stream_id.to_glib_none().0,
                caps.to_glib_none().0,
                type_.into_glib(),
                flags.into_glib(),
            ))
        }
    }

    #[doc(alias = "gst_stream_get_caps")]
    #[doc(alias = "get_caps")]
    pub fn caps(&self) -> Option<Caps> {
        unsafe { from_glib_full(ffi::gst_stream_get_caps(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_stream_get_stream_flags")]
    #[doc(alias = "get_stream_flags")]
    pub fn stream_flags(&self) -> StreamFlags {
        unsafe { from_glib(ffi::gst_stream_get_stream_flags(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_stream_get_stream_id")]
    #[doc(alias = "get_stream_id")]
    pub fn stream_id(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::gst_stream_get_stream_id(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_stream_get_stream_type")]
    #[doc(alias = "get_stream_type")]
    pub fn stream_type(&self) -> StreamType {
        unsafe { from_glib(ffi::gst_stream_get_stream_type(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_stream_get_tags")]
    #[doc(alias = "get_tags")]
    pub fn tags(&self) -> Option<TagList> {
        unsafe { from_glib_full(ffi::gst_stream_get_tags(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_stream_set_caps")]
    pub fn set_caps(&self, caps: Option<&Caps>) {
        unsafe {
            ffi::gst_stream_set_caps(self.to_glib_none().0, caps.to_glib_none().0);
        }
    }

    #[doc(alias = "gst_stream_set_stream_flags")]
    pub fn set_stream_flags(&self, flags: StreamFlags) {
        unsafe {
            ffi::gst_stream_set_stream_flags(self.to_glib_none().0, flags.into_glib());
        }
    }

    #[doc(alias = "gst_stream_set_stream_type")]
    pub fn set_stream_type(&self, stream_type: StreamType) {
        unsafe {
            ffi::gst_stream_set_stream_type(self.to_glib_none().0, stream_type.into_glib());
        }
    }

    #[doc(alias = "gst_stream_set_tags")]
    pub fn set_tags(&self, tags: Option<&TagList>) {
        unsafe {
            ffi::gst_stream_set_tags(self.to_glib_none().0, tags.to_glib_none().0);
        }
    }

    #[doc(alias = "caps")]
    pub fn connect_caps_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_caps_trampoline<F: Fn(&Stream) + Send + Sync + 'static>(
            this: *mut ffi::GstStream,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::caps\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_caps_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "stream-flags")]
    pub fn connect_stream_flags_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_stream_flags_trampoline<
            F: Fn(&Stream) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstStream,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::stream-flags\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_stream_flags_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "stream-type")]
    pub fn connect_stream_type_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_stream_type_trampoline<
            F: Fn(&Stream) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstStream,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::stream-type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_stream_type_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tags")]
    pub fn connect_tags_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_tags_trampoline<F: Fn(&Stream) + Send + Sync + 'static>(
            this: *mut ffi::GstStream,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tags\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tags_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

unsafe impl Send for Stream {}
unsafe impl Sync for Stream {}
