C  Copyright (c) 2003-2010 University of Florida
C
C  This program is free software; you can redistribute it and/or modify
C  it under the terms of the GNU General Public License as published by
C  the Free Software Foundation; either version 2 of the License, or
C  (at your option) any later version.

C  This program is distributed in the hope that it will be useful,
C  but WITHOUT ANY WARRANTY; without even the implied warranty of
C  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C  GNU General Public License for more details.

C  The GNU General Public License is included in this distribution
C  in the file COPYRIGHT.

C THIS SUBROUTINE RETURNS THE MATRIX OPERATIONS FOR A GIVEN
C POINT GROUP. THE CANONICAL ORIENTATIONS USED BY JODA ARE
C ASSUMED IN ALL CASES. ALL MATRIX OPERATIONS ARE RETURNED IN
C VECTOR SCR. CURRENTLY CODED FOR ALL GROUPS EXCEPT O, Oh, Th, T, AND I.
C Ih AND Td ARE IN HERE, AND THEY WORK.

      SUBROUTINE CHRTAB(PTGRP,IORDGP,NORDER,OPRTYP,OPRORD,OPRTIM,
     &                  OPRAXS,NUMCLS,NCLASS,CLSTYP,SCR)
      IMPLICIT DOUBLE PRECISION (A-H, O-Z)

      CHARACTER*4 PTGRP
      CHARACTER*1 OPRTYP(IORDGP)
      INTEGER OPRTIM(IORDGP),NUMCLS(IORDGP),OPRORD(IORDGP)
      INTEGER OPRAXS(IORDGP),TOCK,CLSTYP(IORDGP)
      CHARACTER*4 JUNCHR,JUNCHR2,CMPGRP
#include "io_units.par"
C     Main OPTIM control data
C     IPRNT   Print level - not used yet by most routines
C     INR     Step-taking algorithm to use
C     IVEC    Eigenvector to follow (TS search)
C     IDIE    Ignore negative eigenvalues
C     ICURVY  Hessian is in curviliniear coordinates
C     IMXSTP  Maximum step size in millibohr
C     ISTCRT  Controls scaling of step
C     IVIB    Controls vibrational analysis
C     ICONTL  Negative base 10 log of convergence criterion.
C     IRECAL  Tells whether Hessian is recalculated on each cyc
C     INTTYP  Tells which integral program is to be used
C              = 0 Pitzer
C              = 1 VMol
C     XYZTol  Tolerance for comparison of cartesian coordinates
C
      COMMON /OPTCTL/ IPRNT,INR,IVEC,IDIE,ICURVY,IMXSTP,ISTCRT,IVIB,
     $   ICONTL,IRECAL,INTTYP,IDISFD,IGRDFD,ICNTYP,ISYM,IBASIS,
     $   XYZTol
      COMMON/PTGP_COM/JUNCHR,JUNCHR2,CMPGRP
 
      DIMENSION SCR(9*IORDGP),SCR1(27),SCR2(9)
      IP(I)=1+9*(I-1)
C
      IL=linblnk(PTGRP)
C
C HANDLE GENERAL GROUP TYPES (CN,DN,CNV,CNH,DNH,DND,SN) FIRST.  THIS
C CAN BE DONE IN A GENERAL WAY.
C
      NORDR2=NORDER/2
      NEQ=(NORDER/2)-1
      IF(MOD(NORDER,2).EQ.1)NEQ=NORDER-1
      JI = 0
      JX=0
      NTIME=0
      IERR=0
C
C        ************ CN  GROUPS **********
C
      IF(NORDER.GT.1.AND.PTGRP(1:1).EQ.'C'
     &.AND.PTGRP(IL:IL).NE.'h'
     &.AND.PTGRP(IL:IL).NE.'v')THEN
       IORD=NORDER
       NCLASS=IORD
       DO 10 I=1,NCLASS
        OPRTYP(I)='C'
        OPRORD(I)=NORDER
        OPRTIM(I)=I
        OPRAXS(I)=3
        NUMCLS(I)=1
        CALL IDNMAT(SCR1,3,NTIME)
        CALL DOSYOP(OPRTYP(I),OPRORD(I),OPRTIM(I),OPRAXS(I),
     &              3,SCR1,SCR(IP(NTIME)),IERR,1)
        CLSTYP(I)=I
 10    CONTINUE
C
C        ********** DN  GROUPS **********
C
      ELSEIF(PTGRP(1:1).EQ.'D'
     &.AND.PTGRP(IL:IL).NE.'h'
     &.AND.PTGRP(IL:IL).NE.'d')THEN
       IORD=NORDER*2
       NCLASS=NORDR2+3-MOD(NORDER,2)
       DO 11 I=1,NORDR2
        JX=JX+1
        OPRTYP(I)='C'
        OPRORD(I)=NORDER
        OPRTIM(I)=I
        OPRAXS(I)=3
        NUMCLS(I)=2
        CALL IDNMAT(SCR1,3,NTIME)
        CALL DOSYOP(OPRTYP(I),OPRORD(I),OPRTIM(I),OPRAXS(I),
     &         3,SCR1,SCR(IP(NTIME)),IERR,1)
        CLSTYP(NTIME)=JX
        IF(I.EQ.NORDR2.AND.MOD(NORDER,2).EQ.0)THEN
         NUMCLS(I)=1
        ELSE
         CALL MTRANSP(SCR(IP(NTIME)),SCR(IP(NTIME+1)),3,3,3,3)
         CLSTYP(NTIME+1)=JX
         NTIME=NTIME+1
        ENDIF
  11   CONTINUE
C
C PERPENDICULAR C2 S.  THIS IS DIFFERENT FOR NORDER ODD AND EVEN AND
C  IS A REAL PAIN FOR N EVEN.  DO C2' (THE ONE WHICH LIES ALONG X IN
C  THE CANONICAL ORIENTATION) FOR BOTH ODD AND EVEN FIRST.
C
       JX=JX+1
       OPRTYP(JX)='C'
       OPRORD(JX)=2
       OPRTIM(JX)=1
       OPRAXS(JX)=1
       CALL IDNMAT(SCR1,3,NTIME)
       CALL DOSYOP(OPRTYP(JX),OPRORD(JX),OPRTIM(JX),OPRAXS(JX),
     &             3,SCR1,SCR(IP(NTIME)),IERR,1)
       CLSTYP(NTIME)=JX
C
C GENERATE THE OTHER N-1 C2s IF N ODD AND OTHER (N/2)-1 IF N EVEN.
C
       CALL GENRST(1,SCR,NTIME,NEQ,IORDGP,JX,CLSTYP)
       IF(MOD(NORDER,2).EQ.0)THEN
C
C DO C2'' (NOT ALONG ANY CARTESIAN AXIS EXCEPT FOR D2) FOR N EVEN.
C  CANONICAL AXIS FOR THIS OPERATION IS C(2N;Z) [X].  GET ONE
C  FROM GENDIH AND THEN CRANK OUT THE OTHERS.
C
        CALL GENDIH(OPRTYP(JX),OPRORD(JX),OPRTIM(JX),OPRAXS(JX),
     &              NUMCLS(JX),NORDER,NTIME,SCR(IP(NTIME+1)))
        CALL GENRST(1,SCR,NTIME,NEQ,IORDGP,JX,CLSTYP)
        JX=JX+1
        CLSTYP(NTIME)=JX
       ENDIF
       JX=JX+1
       OPRTYP(JX)='E'
       NUMCLS(JX)=1
       CLSTYP(NTIME)=JX
       CALL IDNMAT(SCR(IP(NTIME+1)),3,NTIME)
C
C      ********** SN GROUPS **********
C
      ELSEIF(PTGRP(1:1).EQ.'S')THEN
       IORD=NORDER
       NCLASS=NORDER
       DO 19 I=1,NORDER/2
        JX=JX+1
        OPRTYP(JX)='S'
        OPRORD(JX)=NORDER
        OPRTIM(JX)=2*I-1
        OPRAXS(JX)=3
        NUMCLS(JX)=1
        CALL IDNMAT(SCR1,3,NTIME)
        CALL DOSYOP(OPRTYP(JX),OPRORD(JX),OPRTIM(JX),OPRAXS(JX),
     &              3,SCR1,SCR(IP(NTIME)),IERR,1)
        CLSTYP(NTIME)=JX
 19    CONTINUE
       DO 190 I=1,NORDER/2
        JX=JX+1
        OPRTYP(JX)='C'
        OPRORD(JX)=NORDER/2
        OPRTIM(JX)=I
        OPRAXS(JX)=3
        NUMCLS(JX)=1
        CALL IDNMAT(SCR1,3,NTIME)
        CALL DOSYOP(OPRTYP(JX),OPRORD(JX),OPRTIM(JX),OPRAXS(JX),
     &              3,SCR1,SCR(IP(NTIME)),IERR,1)
        CLSTYP(NTIME)=JX
 190   CONTINUE
C
C    **********  C(nv) GROUPS **********
C
      ELSEIF(PTGRP(1:1).EQ.'C'.AND.PTGRP(IL:IL).EQ.'v')THEN
       IORD=NORDER
       NCLASS=NORDR2+3-MOD(NORDER,2)
       DO 12 I=1,NORDR2
        JX=JX+1
        OPRTYP(I)='C'
        OPRORD(I)=NORDER
        OPRTIM(I)=I
        OPRAXS(I)=3
        NUMCLS(I)=2
        IF(I.EQ.NORDR2.AND.MOD(NORDER,2).EQ.0)THEN
         NUMCLS(I)=1
         CALL IDNMAT(SCR1,3,NTIME)
         CALL DOSYOP(OPRTYP(I),OPRORD(I),OPRTIM(I),OPRAXS(I),
     &               3,SCR1,SCR(IP(NTIME)),IERR,1)
         CLSTYP(NTIME)=JX
        ELSE
         NUMCLS(I)=2
         CALL IDNMAT(SCR1,3,NTIME)
         CALL DOSYOP(OPRTYP(I),OPRORD(I),OPRTIM(I),OPRAXS(I),
     &               3,SCR1,SCR(IP(NTIME)),IERR,1)
         CLSTYP(NTIME)=JX
         CALL MTRANSP(SCR(IP(NTIME)),SCR(IP(NTIME+1)),3,3,3,3)
         NTIME=NTIME+1
         CLSTYP(NTIME)=JX
        ENDIF
  12   CONTINUE
C
C PLANES OF SYMMETRY.  AGAIN, DIFFERENT FOR NORDER ODD AND EVEN CASES.
C   FIRST WITH THE SIGMA(V) PLANES (THE XZ PLANE IS ONE OF THESE IN
C   THE CANONICAL ORIENTATION.
C
       JX=JX+1
       OPRTYP(JX)='P'
       OPRAXS(JX)=2
       NUMCLS(JX)=NORDER
       CALL IDNMAT(SCR1,3,NTIME)
       CALL DOSYOP(OPRTYP(JX),OPRORD(JX),OPRTIM(JX),OPRAXS(JX),
     &             3,SCR1,SCR(IP(NTIME)),IERR,1)
       CLSTYP(NTIME)=JX
C
C GENERATE THE OTHER N-1 SIGMA(V)s IF N ODD AND OTHER (N/2)-1 IF N EVEN.
C
       CALL GENRST(1,SCR,NTIME,NEQ,IORDGP,JX,CLSTYP)
C
C IF N IS EVEN, THEN GET THE (N/2) SIGMA(D) PLANES.
C
       IF(MOD(NORDER,2).EQ.0)THEN
        NUMCLS(JX)=NORDR2
        CALL GENDIH(OPRTYP(JX),OPRORD(JX),OPRTIM(JX),OPRAXS(JX),
     &              NUMCLS(JX),NORDER,NTIME,SCR(IP(NTIME+1)))
        JX=JX+1
        IF(NORDER.EQ.2)OPRAXS(JX)=1
        CLSTYP(NTIME)=JX
        CALL GENRST(1,SCR,NTIME,NEQ,IORDGP,JX,CLSTYP)
       ENDIF
       JX=JX+1
       OPRTYP(JX)='E'
       NUMCLS(JX)=1
       CALL IDNMAT(SCR(IP(NTIME+1)),3,NTIME)
       CLSTYP(NTIME)=JX
C
C     ********** THE BLESSED C(nh) GROUPS **********
C
      ELSEIF(PTGRP(1:1).EQ.'C'.AND.PTGRP(IL:IL).EQ.'h')THEN
       IORD=2*NORDER
       NCLASS=2*NORDER
       DO 13 I=1,NORDER
        J=I+NORDER
        OPRTYP(I)='C'
        OPRTYP(J)='S'
        OPRTIM(I)=I
        OPRTIM(J)=I
 13    CONTINUE
       DO 130 I=1,NORDER*2
        OPRORD(I)=NORDER
        OPRAXS(I)=3
        NUMCLS(I)=1
        CALL IDNMAT(SCR1,3,NTIME)
        CALL DOSYOP(OPRTYP(I),OPRORD(I),OPRTIM(I),OPRAXS(I),
     &              3,SCR1,SCR(IP(NTIME)),IERR,1)
        CLSTYP(NTIME)=I
130    CONTINUE
C
C    ********** THE D(nd) GROUPS **********
C
C *NOTE* - FOR THESE GROUPS, THE PERPENDICULAR AND C2 AXES ARE
C           COINCIDENT WITH THE CARTESIAN ORIENTATION.
C
C        - BY FAR, THESE GROUPS ARE THE TOUGHEST TO DEAL WITH.
C
      ELSEIF(PTGRP(1:1).EQ.'D'.AND.PTGRP(IL:IL).EQ.'d')THEN
       IORD=4*NORDER
       NCLASS=NORDER+3
C
C PURE ROTATIONS.
C
       DO 14 I=1,NORDR2
        JX=JX+1
        OPRTYP(I)='C'
        OPRORD(I)=NORDER
        OPRTIM(I)=I
        OPRAXS(I)=3
        CALL IDNMAT(SCR1,3,NTIME)
        CALL DOSYOP(OPRTYP(I),OPRORD(I),OPRTIM(I),OPRAXS(I),
     &              3,SCR1,SCR(IP(NTIME)),IERR,1)
        CLSTYP(NTIME)=JX
        IF(I.EQ.NORDR2.AND.MOD(NORDER,2).EQ.0)THEN
         NUMCLS(I)=1
        ELSE
         NUMCLS(I)=2
         CALL MTRANSP(SCR(IP(NTIME)),SCR(IP(NTIME+1)),3,3,3,3)
         NTIME=NTIME+1
         CLSTYP(NTIME)=JX
        ENDIF
 14    CONTINUE
C
C IMPROPER ROTATIONS.
C
       DO 140 I=1,NORDER,2
        JX=JX+1
        OPRTYP(JX)='S'
        OPRORD(JX)=NORDER*2
        OPRTIM(JX)=I
        OPRAXS(JX)=3
        CALL IDNMAT(SCR1,3,NTIME)
        CALL DOSYOP(OPRTYP(JX),OPRORD(JX),OPRTIM(JX),OPRAXS(JX),
     &              3,SCR1,SCR(IP(NTIME)),IERR,1)
        CLSTYP(NTIME)=JX
        IF(I.NE.NORDER)THEN
         NUMCLS(JX)=2
         CALL MTRANSP(SCR(IP(NTIME)),SCR(IP(NTIME+1)),3,3,3,3)
         NTIME=NTIME+1
         CLSTYP(NTIME)=JX
        ELSE
         NUMCLS(JX)=1
        ENDIF
140    CONTINUE
C
C PERPENDICULAR C2 AXES, PLANE AND IDENTITY.  THE AXES AND PLANES
C  ARE A LITTLE TRICKY SINCE A C(2N) (RATHER THAN A C(N)) AXIS)
C  MAPS THEM INTO ONE ANOTHER.
C
       JX=NCLASS-2
       OPRTYP(JX)='C'
       OPRORD(JX)=2
       OPRTIM(JX)=1
       OPRAXS(JX)=1
       NUMCLS(JX)=NORDER
       CALL IDNMAT(SCR1,3,NTIME)
       CALL DOSYOP(OPRTYP(JX),OPRORD(JX),OPRTIM(JX),OPRAXS(JX),
     &             3,SCR1,SCR(IP(NTIME)),IERR,1)
       CLSTYP(NTIME)=JX
C
C GENERATE REST (NORDER-1) OF THE C2 AXES, WHICH ARE RELATED TO THE
C   CANONICAL ONE BY C2N ROTATIONS, USING DIRTY TRICK.
C
       CALL IDNMAT(SCR1,3,NTIME)
       NTIME=NTIME-1
       CALL DOSYOP('C',2*NORDER,1,3,3,SCR1,
     & SCR(IP(NTIME+NORDER)),IERR,1)
       CALL GENRST(NTIME+NORDER,SCR,NTIME,NORDER-1,IORDGP,JX,CLSTYP)
C
C DIHEDRAL SYMMETRY PLANES.  PRETTY TOUGH, SINCE NONE ARE CARTESIAN IN
C   CANONICAL ORIENTATION.  ONE OF THEM CAN BE GENERATED FROM THE XZ PLA
C   BY A C(4N) ROTATION.
C
       JX=NCLASS-1
       OPRTYP(JX)='P'
       OPRAXS(JX)=2
       NUMCLS(JX)=NORDER
       CALL GENDIH(OPRTYP(JX),OPRORD(JX),OPRTIM(JX),OPRAXS(JX),
     &             NUMCLS(JX),2*NORDER,NTIME,SCR(IP(NTIME+1)))
       CLSTYP(NTIME)=JX
C
C GENERATE REST OF THE SIGMA (D) PLANES, WHICH ARE RELATED TO THE
C  CANONICAL ONE BY C2N ROTATIONS.  USE DIRTY TRICK IN PASSING THE
C  APPROPRIATE MATRIX TO GENRST.
C
       CALL IDNMAT(SCR1,3,NTIME)
C
C DECREMENT NTIME HERE SINCE IT IS INCREMENTED IN GENRST.
C
       NTIME=NTIME-1
       CALL DOSYOP('C',2*NORDER,1,3,3,SCR1,
     & SCR(IP(NTIME+NORDER)),IERR,1)
       CALL GENRST(NTIME+NORDER,SCR,NTIME,NORDER-1,IORDGP,JX,CLSTYP)
       OPRTYP(NCLASS)='E'
       NUMCLS(NCLASS)=1
       CALL IDNMAT(SCR(IP(NTIME+1)),3,NTIME)
       CLSTYP(NTIME)=NCLASS
C
C  ********** D(nh) GROUPS **********
C
      ELSEIF(PTGRP(1:1).EQ.'D'.AND.PTGRP(IL:IL).EQ.'h')THEN
       IORD=4*NORDER
       NCLASS=NORDER+6-3*MOD(NORDER,2)
C
C PRINCIPAL ROTATIONS AND IMPROPER ROTATIONS.
C
       DO 15 I=1,NORDR2
        JX=JX+1
        OPRTYP(JX)='C'
        OPRTYP(JX+NORDR2)='S'
        OPRTIM(JX)=I
        OPRTIM(JX+NORDR2)=I
        NUMCLS(JX)=2
        NUMCLS(JX+NORDR2)=2
        IF(JX.EQ.NORDR2.AND.MOD(NORDER,2).EQ.0)THEN
         NUMCLS(JX)=1
         NUMCLS(JX+NORDR2)=1
        ENDIF
 15    CONTINUE
       DO 150 I=1,NORDR2*2
        OPRORD(I)=NORDER
        OPRAXS(I)=3
        CALL IDNMAT(SCR1,3,NTIME)
        CALL DOSYOP(OPRTYP(I),OPRORD(I),OPRTIM(I),OPRAXS(I),
     &              3,SCR1,SCR(IP(NTIME)),IERR,1)
        CLSTYP(NTIME)=I
        IF(NUMCLS(I).EQ.2)THEN
         CALL MTRANSP(SCR(IP(NTIME)),SCR(IP(NTIME+1)),3,3,3,3)
         NTIME=NTIME+1
         CLSTYP(NTIME)=I
        ENDIF
150    CONTINUE
       JX=NORDR2*2
C
C PERPENDICULAR C2' ROTATIONS.  IN THE CANONICAL ORIENTATION, ONE OF
C   THESE IS THE X AXIS.  HANDLE ODD AND EVEN CASES HERE.
C   VERY MUCH LIKE C2v WITH ITS PLANES.
C
       JX=JX+1
       OPRTYP(JX)='C'
       OPRTIM(JX)=1
       OPRAXS(JX)=1
       OPRORD(JX)=2
       NUMCLS(JX)=NORDR2
       IF(MOD(NORDER,2).EQ.1)NUMCLS(JX)=NORDER
       CALL IDNMAT(SCR1,3,NTIME)
       CALL DOSYOP(OPRTYP(JX),OPRORD(JX),OPRTIM(JX),OPRAXS(JX),
     &             3,SCR1,SCR(IP(NTIME)),IERR,1)
       CLSTYP(NTIME)=JX
C
C GENERATE THE OTHER N-1 (N ODD) OR (N/2)-1 (N EVEN) GUYS.
C
       CALL GENRST(1,SCR,NTIME,NEQ,IORDGP,JX,CLSTYP)
C
C IF N IS EVEN, THEN GET ONE OF THE C2'' WITH GENDIH AND GENERATE
C  THE OTHERS.
C
       IF(MOD(NORDER,2).EQ.0)THEN
        CALL GENDIH(OPRTYP(JX),OPRORD(JX),OPRTIM(JX),OPRAXS(JX),
     &              NUMCLS(JX),NORDER,NTIME,SCR(IP(NTIME+1)))
        JX=JX+1
        CLSTYP(NTIME)=JX
        CALL GENRST(1,SCR,NTIME,NEQ,IORDGP,JX,CLSTYP)
       ENDIF
C
C VERTICAL AND DIHEDRAL SYMMETRY PLANES (SIGMA (V) AND (D)).  AGAIN,
C  LIKE C(nv) HERE.  ONE SIGMA (V) IS XZ, THE SIGMA (D)s ARE NONCARTESIA
C
       JX=JX+1
       OPRTYP(JX)='P'
       OPRAXS(JX)=2
       CALL IDNMAT(SCR1,3,NTIME)
       CALL DOSYOP(OPRTYP(JX),OPRORD(JX),OPRTIM(JX),
     &             OPRAXS(JX),3,SCR1,SCR(IP(NTIME)),IERR,1)
       CLSTYP(NTIME)=JX
C
C GENERATE THE OTHER N-1 (N ODD) OR (N/2)-1 (N EVEN) GUYS.
C
       CALL GENRST(1,SCR,NTIME,NEQ,IORDGP,JX,CLSTYP)
C
C IF N IS EVEN, THEN GET ONE OF THE SIGMA(D) WITH GENDIH AND GENERATE
C  THE OTHERS.
C
       IF(MOD(NORDER,2).EQ.0)THEN
        CALL GENDIH(OPRTYP(JX),OPRORD(JX),OPRTIM(JX),OPRAXS(JX),
     &              NUMCLS(JX),NORDER,NTIME,SCR(IP(NTIME+1)))
        JX=JX+1
        CLSTYP(NTIME)=JX
        CALL GENRST(1,SCR,NTIME,NEQ,IORDGP,JX,CLSTYP)
       ENDIF
C
C HORIZONTAL PLANE
C
       JX=JX+1
       OPRAXS(JX)=3
       NUMCLS(JX)=1
       OPRTYP(JX)='P'
       CALL IDNMAT(SCR1,3,NTIME)
       CALL DOSYOP(OPRTYP(JX),OPRORD(JX),OPRTIM(JX),
     &             OPRAXS(JX),3,SCR1,SCR(IP(NTIME)),IERR,1)
       CLSTYP(NTIME)=JX
       OPRTYP(NCLASS)='E'
       NUMCLS(NCLASS)=1
       CALL IDNMAT(SCR(IP(NTIME+1)),3,NTIME)
       CLSTYP(NTIME)=NCLASS
C
C CUBIC GROUPS::: Td FIRST
C
      ELSEIF(PTGRP.EQ.'T d'.OR.PTGRP.EQ.'T  ')THEN
       JX=0
       JI=0
C
C FIRST DO S4 - USE ORIENTATION WHERE THESE ARE X, Y AND Z.
C
       IF(PTGRP.NE.'T  ')THEN
        JX=JX+1
        OPRTYP(JX)='S'
        OPRORD(JX)=4
        NUMCLS(JX)=6
        OPRTIM(JX)=1
        JI=0
        DO 4000 I=1,3
         IAXIS=I
         DO 4100 J=1,3,2
          ITIMES=J
          JI=JI+1
          CLSTYP(JI)=1
          CALL IDNMAT(SCR1,3,NTIME)
          CALL DOSYOP(OPRTYP(JX),OPRORD(JX),ITIMES,IAXIS,3,
     &             SCR1,SCR(IP(NTIME)),IERR,1)
4100     CONTINUE
4000    CONTINUE
       ENDIF
C
C NOW C2 OPERATIONS.
C
       JX=JX+1
       OPRTYP(JX)='C'
       OPRORD(JX)=2
       NUMCLS(JX)=3
       OPRTIM(JX)=1
       DO 4001 I=1,3
        JI=JI+1
        CLSTYP(JI)=2
        CALL IDNMAT(SCR1,3,NTIME)
        CALL DOSYOP(OPRTYP(JX),OPRORD(JX),1,I,3,SCR1,SCR(IP(NTIME)),
     &            IERR,1)
4001   CONTINUE
C
C NOW C3 CLASS.  THESE ARE RELATED BY THE S4 OPERATION.
C
      JX=JX+1
      OPRTYP(JX)='C'
      OPRORD(JX)=3
      NUMCLS(JX)=8
      OPRTIM(JX)=1
      CALL IDNMAT(SCR1,3,NTIME)
      CALL DOSYOP(OPRTYP(JX),OPRORD(JX),1,3,3,SCR1,SCR(IP(NTIME)),
     &IERR,1)
C
C NOW TRANSFORM THIS REFERENCE OPERATION (A C3 ABOUT Z) TO A C3 ABOUT
C  THE (A,A,A) AXIS.
C
      CALL ZERO(SCR2,9)
      DO 4200 I=1,3
       SCR2(I)=DSQRT(3.D0)
4200  CONTINUE
      CALL SIAZ(SCR2,SCR1,3)
      CALL MTRAN2(SCR1,3)
      CALL UNITRY(SCR1,SCR(IP(NTIME)),SCR(IP(NTIME)),3)
      CLSTYP(NTIME)=JX
C
C NOW GENERATE THE OTHER THREE C3 AXES AND C3(1) OPERATIONS WITH THE S4.
C
C  IF THIS IS THE T POINT GROUP, WE DO NOT HAVE THE S4 HANDY SO PUT IT
C   IN HIGHEST POSITION IN VECTOR (WILL EVENTUALLY BE OVERWRITTEN).
C
      IF(PTGRP.EQ.'T d')THEN
       CALL GENRST(1,SCR,NTIME,3,IORDGP,JX,CLSTYP)
      ELSE
       CALL IDNMAT(SCR1,3,NTIME)
       NTIME=NTIME-1
       CALL DOSYOP('S',4,1,3,3,SCR1,SCR2,IERR,1)
       CALL ZERO(SCR(IP(12)),9)
       CALL VADD(SCR(IP(12)),SCR(IP(12)),SCR2,9,1.D0)
       CALL GENRST(12,SCR,NTIME,3,IORDGP,JX,CLSTYP)
      ENDIF
C
C NOW THE C3(2).
C
      CLSTYP(NTIME)=JX
      CALL MTRANSP(SCR(IP(NTIME)),SCR(IP(NTIME+1)),3,3,3,3)
      NTIME=NTIME+1
      CLSTYP(NTIME)=JX
      IF(PTGRP.EQ.'T d')THEN
       CALL GENRST(1,SCR,NTIME,3,IORDGP,JX,CLSTYP)
      ELSE
       CALL GENRST(12,SCR,NTIME,3,IORDGP,JX,CLSTYP)
      ENDIF
C
C NOW THE PLANES OF SYMMETRY.
C
      IF(PTGRP.EQ.'T d')THEN
       JX=JX+1
       OPRTYP(JX)='P'
       NUMCLS(JX)=6
       CALL IDNMAT(SCR1,3,NTIME)
       CLSTYP(NTIME)=JX
       CALL DOSYOP(OPRTYP(JX),OPRORD(JX),OPRTIM(JX),1,
     &             3,SCR1,SCR1(10),IERR,1)
C
C NOW TRANSFORM BY ROTATING 45 DEGREES ABOUT Z.
C
       CALL ROTM(3,45.D0,1,SCR1)
       CALL UNITRY(SCR1,SCR1(10),SCR(IP(NTIME)),3)
C
C GENERATE THE OTHERS WITH ONE OF THE OTHER C3 AXES.
C
       CALL GENRST(10,SCR,NTIME,2,IORDGP,JX,CLSTYP)
C
C NOW GET OTHER REFERENCE PLANE.
C
       CALL ROTM(3,-45.D0,1,SCR1)
       CALL UNITRY(SCR1,SCR1(10),SCR(IP(NTIME+1)),3)
       CLSTYP(NTIME+1)=JX
       NTIME=NTIME+1
       CALL GENRST(10,SCR,NTIME,2,IORDGP,JX,CLSTYP)
      ENDIF
C
C NOW THE IDENTITY AND WE'RE DONE.
C
      JX=JX+1
      OPRTYP(JX)='E'
      NUMCLS(JX)=1
      CALL IDNMAT(SCR(IP(NTIME+1)),3,NTIME)
      CLSTYP(NTIME)=JX
      NCLASS=JX
C
C NOW TRANSFORM THIS TO THE "ACES" CANONICAL ORIENTATION -- WHERE
C  XZ AND YZ ARE SYMMETRY PLANES.  ROTATED 45 DEGREES ABOUT Z FROM
C  THIS PARTICULAR ORIENATION.  THIS MUST BE DONE ONLY IF THE
C  COMPUTATIONAL ABELIAN SUBGROUP IS C2v.  IF IT IS D2, THEN THIS
C  SHOULD BE SKIPPED.
C
       IF(PTGRP.EQ.'T d'.AND.CMPGRP.NE.'D2')THEN
        CALL ROTM(3,45.D0,1,SCR1)
        DO 4500 I=1,NTIME
         CALL UNITRY(SCR1,SCR(IP(I)),SCR(IP(I)),3)
4500    CONTINUE
       ENDIF
       GOTO 383
C
C THE DREADED ICOSAHEDRAL GROUP -- BOTH Ih AND I HANDLED HERE.
C
      ELSEIF(PTGRP.EQ.'I h'.OR.PTGRP.EQ.'I  ')THEN
C
C FIRST DO C5, C5(2), S10 and S10(3) - ONE OF THE AXES IS THE Z-AXIS.
C
c       IORDGP=120
       NCLASS=10
       JX=0
       OMEGA=1.D0/DSQRT(5.D0)
       ANGLE1=DACOS(OMEGA)
       ARG2=DSQRT((1-OMEGA)/2)
       ANGLE2=DACOS(ARG2)
       ARG3=DSQRT(12.D0+24.D0*OMEGA)/6.D0
       ANGLE3=DACOS(ARG3)
       CALL ZERO(SCR2,9)
       SCR2(1)=0.D0
       SCR2(2)=2.D0/DSQRT(5.D0)
       SCR2(3)=1.D0/DSQRT(5.D0)
       CALL SIAZ(SCR2,SCR1(10),3)
       CALL MTRAN2(SCR1(10),3)
       DO 3001 IORD=1,2
        OPRTYP(IORD)='C'
        OPRORD(IORD)=5
        OPRTIM(IORD)=IORD
        OPRTYP(IORD+2)='S'
        OPRORD(IORD+2)=10
        OPRTIM(IORD+2)=1+2*(IORD-1)
        IAXIS=3
C
C C5 OPERATIONS
C
        JX=JX+1
        NUMCLS(JX)=12
        CALL IDNMAT(SCR1,3,NTIME)
        CALL DOSYOP(OPRTYP(IORD),OPRORD(IORD),OPRTIM(IORD),IAXIS,3,
     &             SCR1,SCR(IP(NTIME)),IERR,1)
        CLSTYP(NTIME)=JX
        CALL UNITRY(SCR1(10),SCR(IP(NTIME)),SCR(IP(NTIME+1)),3)
        NTIME=NTIME+1
        CLSTYP(NTIME)=JX
        CALL GENRST(1,SCR,NTIME,4,IORDGP,JX,CLSTYP)
C
C S10 OPERATIONS
C
        IF(PTGRP.NE.'I  ')THEN
         JX=JX+1
         NUMCLS(JX)=12
         CALL IDNMAT(SCR1,3,NTIME)
         CALL DOSYOP(OPRTYP(IORD+2),OPRORD(IORD+2),OPRTIM(IORD+2),
     &              IAXIS,3,SCR1,SCR(IP(NTIME)),IERR,1)
         CLSTYP(NTIME)=JX
         CALL UNITRY(SCR1(10),SCR(IP(NTIME)),SCR(IP(NTIME+1)),3)
         NTIME=NTIME+1
         CLSTYP(NTIME)=JX
         CALL GENRST(1,SCR,NTIME,4,IORDGP,JX,CLSTYP)
        ENDIF
3001   CONTINUE
C
C NOW WE HAVE THE C5(1), C5(2), S10(1) AND S10(3) AXES.  GET ALL OF
C  THE C5(4), C5(3), S10(9) AND S10(7) BY TRANSPOSITION.
C
       NTOP=24
       IF(PTGRP.EQ.'I  ')NTOP=12
       DO 1522 I=1,NTOP
        CALL MTRANSP(SCR(IP(I)),SCR(IP(NTOP+I)),3,3,3,3)
        NTIME=NTIME+1
        CLSTYP(NTIME)=CLSTYP(NTIME-NTOP)
1522   CONTINUE
C
C THIS COMPLETES THE FIVEFOLD AND TENFOLD ROTATIONS.  HAVE 48 OF 120
C   OPERATIONS DONE.
C
C
C NOW GO FOR THE C3 AND S6 AXES.
C
       CALL ROTM(1,ANGLE3,0,SCR1(10))
       ANGLE4=DACOS(-1.D0)-ANGLE1-2.D0*ANGLE3
       CALL ROTM(1,ANGLE4,0,SCR1(19))
 
       JX=JX+1
       OPRTYP(JX)='C'
       OPRTIM(JX)=1
       OPRORD(JX)=3
       NUMCLS(JX)=20
       CALL IDNMAT(SCR1,3,NTIME)
       NREF1=NTIME
       CALL DOSYOP(OPRTYP(JX),OPRORD(JX),1,3,3,SCR1,SCR(IP(NTIME)),
     &IERR,1)
       CLSTYP(NTIME)=JX
       CALL UNITRY(SCR1(10),SCR(IP(NREF1)),SCR(IP(NTIME)),3)
       CALL GENRST(1,SCR,NTIME,4,IORDGP,JX,CLSTYP)
       CALL UNITRY(SCR1(19),SCR(IP(NREF1)),SCR(IP(NTIME+1)),3)
       NTIME=NTIME+1
       CLSTYP(NTIME)=JX
       CALL GENRST(1,SCR,NTIME,4,IORDGP,JX,CLSTYP)
       DO 4030 I=0,9
        CALL MTRANSP(SCR(IP(NREF1+I)),SCR(IP(NREF1+10+I)),3,3,3,3)
        NTIME=NTIME+1
        CLSTYP(NTIME)=JX
4030   CONTINUE
 
C S OPS
       IF(PTGRP.NE.'I  ')THEN
        JX=JX+1
        OPRTYP(JX)='S'
        OPRORD(JX)=6
        NUMCLS(JX)=20
        OPRTIM(JX)=1
        CALL IDNMAT(SCR1,3,NTIME)
        NREF2=NTIME
        CALL DOSYOP(OPRTYP(JX),OPRORD(JX),1,3,3,SCR1,SCR(IP(NTIME))
     &,IERR,1)
        CALL UNITRY(SCR1(10),SCR(IP(NREF2)),SCR(IP(NTIME)),3)
        CLSTYP(NTIME)=JX
        CALL GENRST(1,SCR,NTIME,4,IORDGP,JX,CLSTYP)
        CALL UNITRY(SCR1(19),SCR(IP(NREF2)),SCR(IP(NTIME+1)),3)
        NTIME=NTIME+1
        CLSTYP(NTIME)=JX
        CALL GENRST(1,SCR,NTIME,4,IORDGP,JX,CLSTYP)
        DO 4033 I=0,9
         CALL MTRANSP(SCR(IP(NREF2+I)),SCR(IP(NREF2+10+I)),3,3,3,3)
         NTIME=NTIME+1
         CLSTYP(NTIME)=JX
4033    CONTINUE
       ENDIF
C
C NOW DO C2
C
       CALL ROTM(1,ANGLE2,0,SCR1(10))
       CALL ROTM(3,72.D0,1,SCR1(19))
       CALL SIAZ(SCR2,SCR1,3)
       CALL MTRAN2(SCR1,3)
       CALL UNITRY(SCR1,SCR1(19),SCR1(19),3)
 
       JX=JX+1
       OPRTYP(JX)='C'
       OPRORD(JX)=2
       NUMCLS(JX)=15
       OPRTIM(JX)=1
       CALL IDNMAT(SCR1,3,NTIME)
       NREF1=NTIME
       CALL DOSYOP(OPRTYP(JX),OPRORD(JX),1,3,3,SCR1,SCR(IP(NTIME)),
     & IERR,1)
       CALL UNITRY(SCR1(10),SCR(IP(NREF1)),SCR(IP(NTIME)),3)
       CLSTYP(NTIME)=JX
       CALL GENRST(1,SCR,NTIME,4,IORDGP,JX,CLSTYP)
       CALL UNITRY(SCR1(19),SCR(IP(NREF1)),SCR(IP(NTIME+1)),3)
       NTIME=NTIME+1
       CLSTYP(NTIME)=JX
       CALL GENRST(1,SCR,NTIME,4,IORDGP,JX,CLSTYP)
       CALL MODMATMUL(SCR1(10),SCR1(19),SCR1(19),3,3,3,3,3,3)
       CALL UNITRY(SCR1(10),SCR(IP(NREF1)),SCR(IP(NTIME+1)),3)
       NTIME=NTIME+1
       CLSTYP(NTIME)=JX
       CALL GENRST(1,SCR,NTIME,4,IORDGP,JX,CLSTYP)
C
C NOW DO SYMMETRY PLANES.  WE'RE ALMOST DONE!  THE FIRST ONE IS XY, SO T
C  MAKES THINGS EASY.
C
       IF(PTGRP.NE.'I  ')THEN
        JX=JX+1
        OPRTYP(JX)='P'
        NUMCLS(JX)=15
        CALL IDNMAT(SCR1,3,NTIME)
        NREF1=NTIME
        CALL DOSYOP(OPRTYP(JX),OPRORD(JX),OPRTIM(JX),1,
     &            3,SCR1,SCR(IP(NTIME)),IERR,1)
        CLSTYP(NTIME)=JX
        CALL GENRST(1,SCR,NTIME,4,IORDGP,JX,CLSTYP)
        CALL UNITRY(SCR1(10),SCR(IP(NREF1)),SCR(IP(NTIME+1)),3)
        NTIME=NTIME+1
        CLSTYP(NTIME)=JX
        CALL GENRST(1,SCR,NTIME,4,IORDGP,JX,CLSTYP)
        CALL UNITRY(SCR1(19),SCR(IP(NREF1)),SCR(IP(NTIME+1)),3)
        NTIME=NTIME+1
        CLSTYP(NTIME)=JX
        CALL GENRST(1,SCR,NTIME,4,IORDGP,JX,CLSTYP)
C
C  NOW THE INVERSION AND THE IDENTITY AND WE'RE THROUGH!
C
        JX=JX+1
        OPRTYP(JX)='I'
        NUMCLS(JX)=1
        CALL IDNMAT(SCR1,3,NTIME)
        CALL DOSYOP(OPRTYP(JX),0,0,0,3,SCR1,SCR(IP(NTIME)),IERR,
     &   1)
        CLSTYP(NTIME)=JX
       ENDIF
       JX=JX+1
       OPRTYP(JX)='E'
       NUMCLS(JX)=1
       CALL IDNMAT(SCR(IP(NTIME+1)),3,NTIME)
       CLSTYP(NTIME)=JX
       GOTO 383
C
C THE NOT-SO DREADED OCTAHEDRAL GROUP -- BOTH Oh AND O HANDLED HERE.
C
      ELSEIF(PTGRP.EQ.'O h'.OR.PTGRP.EQ.'O  '.OR.PTGRP.EQ.'T h')THEN
C
C FIRST DO C4, S4 - ONE OF THE AXES IS THE Z-AXIS.
C
       JX=0
C
C C4 OPERATIONS
C
       IF(PTGRP(1:1).EQ.'O')THEN
        JX=JX+1
        OPRTYP(JX)='C'
        OPRORD(JX)=4
        OPRTIM(JX)=1
        NUMCLS(JX)=6
        DO 8000 IAXS=1,3
         CALL IDNMAT(SCR1,3,NTIME)
         CALL DOSYOP(OPRTYP(JX),OPRORD(JX),OPRTIM(JX),
     &            IAXS,3,SCR1,SCR(IP(NTIME)),IERR,1)
         CLSTYP(NTIME)=JX
8000    CONTINUE
       ENDIF
C
C S4 OPERATIONS
C
       IF(PTGRP.EQ.'O h')THEN
        JX=JX+1
        OPRTYP(JX)='S'
        OPRORD(JX)=4
        OPRTIM(JX)=1
        NUMCLS(JX)=6
        DO 8001 IAXS=1,3
         CALL IDNMAT(SCR1,3,NTIME)
         CALL DOSYOP(OPRTYP(JX),OPRORD(JX),OPRTIM(JX),
     &               IAXS,3,SCR1,SCR(IP(NTIME)),IERR,1)
         CLSTYP(NTIME)=JX
8001    CONTINUE
       ENDIF
C
C SIGMA H PLANES
C
       IF(PTGRP.NE.'O  ')THEN
        JX=JX+1
        OPRTYP(JX)='P'
        OPRORD(JX)=0
        OPRTIM(JX)=0
        NUMCLS(JX)=3
        DO 8002 IAXS=1,3
         CALL IDNMAT(SCR1,3,NTIME)
         CALL DOSYOP(OPRTYP(JX),OPRORD(JX),OPRTIM(JX),
     &               IAXS,3,SCR1,SCR(IP(NTIME)),IERR,1)
         CLSTYP(NTIME)=JX
8002    CONTINUE
       ENDIF
C
C C4(2) OPERATIONS.
C
       JX=JX+1
       OPRTYP(JX)='C'
       OPRORD(JX)=4
       OPRTIM(JX)=2
       NUMCLS(JX)=3
       DO 8003 IAXS=1,3
        CALL IDNMAT(SCR1,3,NTIME)
        CALL DOSYOP(OPRTYP(JX),OPRORD(JX),OPRTIM(JX),
     &              IAXS,3,SCR1,SCR(IP(NTIME)),IERR,1)
        CLSTYP(NTIME)=JX
8003   CONTINUE
C
C NOW WE HAVE THE C4(1), S4(1), C4(2) AND REFLECTION PLANES.  GENERATE
C  ALL OF THE C4(3) AND S4(3) BY TRANSPOSITION.
C
       NTOP=6
       NTOP2=12
       IF(PTGRP.EQ.'O  ')THEN
        NTOP=3
        NTOP2=6
       ENDIF
       IF(PTGRP.NE.'T h')THEN
        DO 7522 I=1,NTOP
         CALL MTRANSP(SCR(IP(I)),SCR(IP(NTOP2+I)),3,3,3,3)
         NTIME=NTIME+1
         CLSTYP(NTIME)=CLSTYP(NTIME-NTOP2)
7522    CONTINUE
C
C THIS COMPLETES ALL OF THE OPERATIONS WHICH ARE HAVE AXES COINCIDENT WI
C  THE NATURAL CARTESIAN FRAME.  NOW GO ON TO DO C2 AND THE SIGMA(D) OPS
C
        DO 7001 K=1,2
         CALL ROTM(3,45.D0,1,SCR1(10))
         IF(K.EQ.1)THEN
          JX=JX+1
          OPRTYP(JX)='C'
          OPRTIM(JX)=1
          OPRORD(JX)=2
          NUMCLS(JX)=6
         ELSE
          IF(PTGRP.EQ.'O  ')GOTO 7001
          JX=JX+1
          OPRTYP(JX)='P'
          OPRTIM(JX)=0
          OPRORD(JX)=0
          NUMCLS(JX)=6
         ENDIF
         CALL IDNMAT(SCR1,3,NTIME)
         NREF1=NTIME
         CALL DOSYOP(OPRTYP(JX),OPRORD(JX),1,1,3,SCR1,SCR1(19),IERR,1)
         CALL UNITRY(SCR1(10),SCR1(19),SCR(IP(NTIME)),3)
         CLSTYP(NTIME)=JX
         NTIME=NTIME+1
         CALL MTRAN2(SCR1(10),3)
         CALL UNITRY(SCR1(10),SCR1(19),SCR(IP(NTIME)),3)
         CLSTYP(NTIME)=JX
         NTIME=NTIME+1
         CALL ROTM(2,45.D0,1,SCR1(10))
         NREF1=NTIME
         CALL DOSYOP(OPRTYP(JX),OPRORD(JX),1,1,3,SCR1,SCR1(19),IERR,1)
         CALL UNITRY(SCR1(10),SCR1(19),SCR(IP(NTIME)),3)
         CLSTYP(NTIME)=JX
         NTIME=NTIME+1
         CALL MTRAN2(SCR1(10),3)
         CALL UNITRY(SCR1(10),SCR1(19),SCR(IP(NTIME)),3)
         CLSTYP(NTIME)=JX
         NTIME=NTIME+1
         CALL ROTM(1,45.D0,1,SCR1(10))
         NREF1=NTIME
         CALL DOSYOP(OPRTYP(JX),OPRORD(JX),1,2,3,SCR1,SCR1(19),IERR,1)
         CALL UNITRY(SCR1(10),SCR1(19),SCR(IP(NTIME)),3)
         CLSTYP(NTIME)=JX
         NTIME=NTIME+1
         CALL MTRAN2(SCR1(10),3)
         CALL UNITRY(SCR1(10),SCR1(19),SCR(IP(NTIME)),3)
         CLSTYP(NTIME)=JX
7001    CONTINUE
       ENDIF
C
C
C NOW DEAL WITH THE C3 AND S6 OPS.  THE ONLY TRICKY BITS.
C
       DO 7003 K=1,2
        IF(K.EQ.1)THEN
         JX=JX+1
         OPRTYP(JX)='C'
         OPRORD(JX)=3
         NUMCLS(JX)=8
         OPRTIM(JX)=1
        ELSE
         IF(PTGRP.EQ.'O  ')GOTO 7003
         JX=JX+1
         OPRTYP(JX)='S'
         OPRORD(JX)=6
         NUMCLS(JX)=8
         OPRTIM(JX)=1
        ENDIF
        CALL IDNMAT(SCR1,3,NTIME)
        CALL DOSYOP(OPRTYP(JX),OPRORD(JX),1,3,3,SCR1,
     &             SCR(IP(NTIME)),IERR,1)
C
C NOW TRANSFORM THIS REFERENCE OPERATION (ABOUT Z) TO A C3 OR S6 ABOUT
C  THE (A,A,A) AXIS.
C
        CALL ZERO(SCR2,9)
        DO 7200 I=1,3
         SCR2(I)=DSQRT(3.D0)
7200    CONTINUE
        CALL SIAZ(SCR2,SCR1,3)
        CALL MTRAN2(SCR1,3)
        CALL UNITRY(SCR1,SCR(IP(NTIME)),SCR(IP(NTIME)),3)
        CLSTYP(NTIME)=JX
C
C NOW GENERATE THREE OF THE OTHER C3 AXES WITH A C4.
C
        IF(PTGRP.NE.'T h')THEN
         CALL GENRST(1,SCR,NTIME,3,IORDGP,JX,CLSTYP)
        ELSE
C
C IF GROUP IS Th, WE DON'T HAVE A C4.  NEED TO GENERATE A C4z MATRIX NOW
C
        CALL IDNMAT(SCR1,3,NTIME)
        NTIME=NTIME-1
        CALL DOSYOP('C',4,1,3,3,SCR1,SCR2,IERR,1)
        CALL ZERO(SCR(IP(24)),9)
        CALL VADD(SCR(IP(24)),SCR(IP(24)),SCR2,9,1.D0)
        CALL GENRST(24,SCR,NTIME,3,IORDGP,JX,CLSTYP)
       ENDIF
C
C NOW THE C3(2) OR S6(5) AXES.
C
        CLSTYP(NTIME)=JX
        CALL MTRANSP(SCR(IP(NTIME)),SCR(IP(NTIME+1)),3,3,3,3)
        NTIME=NTIME+1
        CLSTYP(NTIME)=JX
        IF(PTGRP.NE.'T h')THEN
         CALL GENRST(1,SCR,NTIME,3,IORDGP,JX,CLSTYP)
        ELSE
         CALL GENRST(24,SCR,NTIME,3,IORDGP,JX,CLSTYP)
        ENDIF
7003   CONTINUE
C
C NOW THE IDENTITY AND INVERSION AND WE ... ARE ... OUT OF HERE!
C
       IF(PTGRP.NE.'O  ')THEN
        JX=JX+1
        OPRTYP(JX)='I'
        NUMCLS(JX)=1
        CALL IDNMAT(SCR1,3,NTIME)
        CALL DOSYOP(OPRTYP(JX),0,0,0,3,SCR1,SCR(IP(NTIME)),
     &  IERR,1)
        CLSTYP(NTIME)=JX
       ENDIF
       JX=JX+1
       OPRTYP(JX)='E'
       NUMCLS(JX)=1
       CALL IDNMAT(SCR(IP(NTIME+1)),3,NTIME)
       CLSTYP(NTIME)=JX
       NCLASS=JX
       GOTO 383
      ENDIF
C
C NOW DO BORING GROUPS C1, CS, CI.
C
      IF(PTGRP.EQ.'C1 ')THEN
       NCLASS=1
       IORD=1
       OPRTYP(1)='E'
       CALL IDNMAT(SCR(NTIME+1),3,NTIME)
       NUMCLS(1)=1
       CLSTYP(1)=1
      ELSEIF(PTGRP.EQ.'C s')THEN
       NCLASS=2
       IORD=2
       OPRTYP(2)='E'
       OPRTYP(1)='P'
       OPRAXS(1)=3
       NUMCLS(2)=1
       NUMCLS(1)=1
       CALL IDNMAT(SCR(NTIME+1),3,NTIME)
       CALL IDNMAT(SCR1,3,NTIME)
       CALL DOSYOP(OPRTYP(1),OPRORD(1),OPRTIM(1),
     &        OPRAXS(1),3,SCR1,SCR(IP(NTIME)),IERR,1)
       CLSTYP(1)=1
       CLSTYP(2)=2
      ELSEIF(PTGRP.EQ.'C i')THEN
       NCLASS=2
       IORD=2
       OPRTYP(2)='E'
       OPRTYP(1)='I'
       NUMCLS(1)=1
       NUMCLS(2)=1
       CALL IDNMAT(SCR(NTIME+1),3,NTIME)
       CALL IDNMAT(SCR1,3,NTIME)
       CALL DOSYOP(OPRTYP(1),OPRORD(1),OPRTIM(1),
     &        OPRAXS(1),3,SCR1,SCR(IP(NTIME)),IERR,1)
       CLSTYP(1)=1
       CLSTYP(2)=1
      ENDIF

      IF (NTIME.EQ.0) THEN
         WRITE(*,*) '@CHRTAB: Symmetry operations for point group ',
     &          PTGRP,' unavailable.'
         CALL ERREX
      END IF
C
C NOW DO INTELLIGENT RENAMING OF CERTAIN OPERATIONS.  FOR EXAMPLE, A
C  CN(N) OPERATION IS AN IDENTITY, A CN(2) IS A CN/2, ETC.  THIS WILL
C  JUST MAKE THINGS "NICER", AND WILL NOT LEAD TO ANY ACTUAL CHANGES.
C
      DO 20 I=1,NCLASS
       IF(OPRTYP(I).NE.'C'.AND.OPRTYP(I).NE.'S')GOTO 20
       TICK=FLOAT(OPRORD(I))/FLOAT(OPRTIM(I))
       TOCK=OPRORD(I)/OPRTIM(I)
       IREM=MOD(OPRORD(I),OPRTIM(I))
       Z1=DABS(1.D0-TICK)
       IF(OPRTYP(I).EQ.'C'.AND.Z1.LT.1.D-12)THEN
        OPRTYP(I)='E'
        OPRAXS(I)=0
        OPRTIM(I)=0
        OPRORD(I)=0
       ELSEIF(OPRTYP(I).EQ.'S'.AND.Z1.LT.1.D-12)THEN
        OPRTYP(I)='P'
        OPRTIM(I)=0
        OPRORD(I)=0
       ELSEIF(IREM.EQ.0.AND.TOCK.EQ.2.AND.OPRTYP(I).EQ.'S')THEN
        OPRTYP(I)='I'
        OPRTIM(I)=0
        OPRORD(I)=0
        OPRAXS(I)=0
       ELSEIF(IREM.EQ.0)THEN
        OPRTIM(I)=1
        OPRORD(I)=TOCK
       ENDIF
20     CONTINUE
383    IF(IPRNT.GT.5)WRITE(LUOUT,9100)NTIME
9100   FORMAT(T3,'@CHRTAB-I, Generated transformation matrices ',
     &'for ',I3,' symmetry operations.')
       RETURN
       END
