#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Anomaly 2
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250823.2

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='anomaly-2'
GAME_NAME='Anomaly 2'

ARCHIVE_BASE_LINUX_0_NAME='Anomaly2_Linux_1387299615.zip'
ARCHIVE_BASE_LINUX_0_MD5='46f0ecd5363106e9eae8642836c29dfc'
ARCHIVE_BASE_LINUX_0_SIZE='2500000'
ARCHIVE_BASE_LINUX_0_VERSION='1.0-humble1'
ARCHIVE_BASE_LINUX_0_URL='https://www.humblebundle.com/store/anomaly-2'

ARCHIVE_BASE_WINDOWS_0_NAME='Anomaly2_Windows_1387299615.zip'
ARCHIVE_BASE_WINDOWS_0_MD5='2b5ccffcbaee8cfebfd4bb74cacb9fbc'
ARCHIVE_BASE_WINDOWS_0_SIZE='2500000'
ARCHIVE_BASE_WINDOWS_0_VERSION='1.0-humble1'
ARCHIVE_BASE_WINDOWS_0_URL='https://www.humblebundle.com/store/anomaly-2'

ARCHIVE_OPTIONAL_ICONS_NAME='anomaly-2_icons.tar.gz'
ARCHIVE_OPTIONAL_ICONS_MD5='73ddbd1651e08d6c8bb4735e5e0a4a81'
ARCHIVE_OPTIONAL_ICONS_URL='https://downloads.dotslashplay.it/games/anomaly-2/'
CONTENT_ICONS_PATH='.'
CONTENT_ICONS_FILES='
32x32
48x48
64x64
256x256'

CONTENT_PATH_DEFAULT_LINUX='Anomaly 2 Linux DRM-free'
CONTENT_PATH_DEFAULT_WINDOWS='Anomaly 2 Windows DRM-free/2013-12-17 03-20'
CONTENT_LIBS_BIN_FILES_LINUX='
libopenal.so.1'
CONTENT_GAME_BIN_FILES_LINUX='
*.txt
Anomaly2'
CONTENT_GAME_BIN_FILES_WINDOWS='
*.exe
*.dll
*.txt'
CONTENT_GAME_DATA_FILES='
*.dat
*.idx
*.str'

## LD_PRELOAD shim working around infinite loading times
LD_PRELOAD_SOURCE_LINUX='
#define _GNU_SOURCE
#include <dlfcn.h>
#include <semaphore.h>
#include <stdio.h>
#include <time.h>
#include <unistd.h>

static int (*_realSemTimedWait)(sem_t *, const struct timespec *) = NULL;

int sem_timedwait(sem_t *sem, const struct timespec *abs_timeout) {
	if (abs_timeout->tv_nsec >= 1000000000) {
		((struct timespec *)abs_timeout)->tv_nsec -= 1000000000;
		((struct timespec *)abs_timeout)->tv_sec++;
	}
	return _realSemTimedWait(sem, abs_timeout);
}
__attribute__((constructor)) void init(void) {
	_realSemTimedWait = dlsym(RTLD_NEXT, "sem_timedwait");
}
'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Application Data/11bitstudios/Anomaly 2'

## The Linux build triggers a segmentation fault on Mesa ≥ 23.0.0 right after the introduction video:
##
## #0  0x0809744f in ?? ()
## #1  0x080938dd in ?? ()
## #2  0x080aefee in ?? ()
## #3  0x0811fdea in ?? ()
## #4  0x0805c9fc in ?? ()
## #5  0x08056dc9 in ?? ()
## #6  0xf777e8da in __run_exit_handlers (status=<optimized out>, listp=<optimized out>, run_list_atexit=<optimized out>, run_dtors=<optimized out>) at ./stdlib/exit.c:118
## #7  0xf777eaf1 in __GI_exit (status=1) at ./stdlib/exit.c:148
## #8  0xf7dee930 in _XDefaultError (event=0xe29fe02c, dpy=0x8502b20) at ../../src/XlibInt.c:1440
## #9  _XDefaultError (dpy=0x8502b20, event=0xe29fe02c) at ../../src/XlibInt.c:1425
## #10 0xf7deea58 in _XError (dpy=0x8502b20, rep=0xe29fe0dc) at ../../src/XlibInt.c:1494
## #11 0xf67c643f in __glXSendError (dpy=0x8502b20, errorCode=10 '\n', resourceID=0, minorCode=5, coreX11error=true) at ../src/glx/glx_error.c:62
## #12 0xf67c6294 in MakeContextCurrent (dpy=<optimized out>, draw=10485767, read=10485767, gc_user=<optimized out>, opcode=<optimized out>) at ../src/glx/glxcurrent.c:147
## #13 0xf764b8c6 in InternalMakeCurrentVendor (dpy=dpy@entry=0x8502b20, draw=draw@entry=10485767, read=read@entry=10485767, ctxInfo=0xe33b0380, callerOpcode=5 '\005', threadState=<optimized out>, vendor=0x84dc350) at ../src/GLX/libglx.c:871
## #14 0xf764c210 in InternalMakeCurrentDispatch (dpy=dpy@entry=0x8502b20, draw=draw@entry=10485767, read=read@entry=10485767, ctxInfo=0xe33b0380, callerOpcode=5 '\005', vendor=0x84dc350) at ../src/GLX/libglx.c:926
## #15 0xf764d434 in CommonMakeCurrent (dpy=0x8502b20, draw=10485767, read=10485767, context=0xe33006e0, callerOpcode=5 '\005') at ../src/GLX/libglx.c:1070
## #16 0x080907da in ?? ()
## #17 0x0809150f in ?? ()
## #18 0x08105d2f in ?? ()
## #19 0x08083af4 in ?? ()
## #20 0x080834f8 in ?? ()
## #21 0xf77d0781 in start_thread (arg=<optimized out>) at ./nptl/pthread_create.c:448
## #22 0xf7866e38 in __GI___clone3 () at ../sysdeps/unix/sysv/linux/i386/clone3.S:111
##
## This has been reported to Mesa developers, but they decided that they will not provide a fix:
## https://gitlab.freedesktop.org/mesa/mesa/-/issues/12246
## Their suggestion is to buy the game on Steam (!!) and play it through Proton (!!!).
##
## The following patch, not included in upstream Mesa, might prevent that crash:
## --- a/src/glx/glxcurrent.c
## +++ b/src/glx/glxcurrent.c
## @@ -138,6 +138,11 @@ MakeContextCurrent(Display * dpy, GLXDrawable draw,
##     __glXSetCurrentContextNull();
##
##     if (gc) {
## +      if (gc->currentDpy && gc->currentDpy == dpy) {
## +         gc->vtable->unbind(gc);
## +         gc->currentDpy = NULL;
## +      }
## +
##        /* GLX spec 3.3: If ctx is current to some other thread, then
##         * glXMakeContextCurrent will generate a BadAccess error
##         */
##
## Support for the Windows build is included as a workaround.
APP_MAIN_EXE_LINUX='Anomaly2'
APP_MAIN_EXE_WINDOWS='Anomaly 2.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ID="$GAME_ID"
PKG_BIN_ID_LINUX="${PKG_BIN_ID}-linux"
PKG_BIN_ID_WINDOWS="${PKG_BIN_ID}-windows"
PKG_BIN_PROVIDES="
$PKG_BIN_ID"
PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES_LINUX='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_LINUX="${PKG_DATA_ID}-linux"
PKG_DATA_ID_WINDOWS="${PKG_DATA_ID}-windows"
PKG_DATA_PROVIDES="
$PKG_DATA_ID"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
