/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.AbstractRefreshableWebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationConfigWebApplicationContext
extends AbstractRefreshableWebApplicationContext {
    private Class<?>[] annotatedClasses;
    private String[] basePackages;
    private BeanNameGenerator beanNameGenerator;
    private ScopeMetadataResolver scopeMetadataResolver;

    @Override
    public void setConfigLocation(String location) {
        super.setConfigLocation(location);
    }

    @Override
    public void setConfigLocations(String[] locations) {
        super.setConfigLocations(locations);
    }

    public void register(Class<?> ... annotatedClasses) {
        Assert.notEmpty((Object[])annotatedClasses, (String)"At least one annotated class must be specified");
        this.annotatedClasses = annotatedClasses;
    }

    public void scan(String ... basePackages) {
        Assert.notEmpty((Object[])basePackages, (String)"At least one base package must be specified");
        this.basePackages = basePackages;
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) {
        String[] configLocations;
        AnnotatedBeanDefinitionReader reader = new AnnotatedBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        reader.setEnvironment((Environment)this.getEnvironment());
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner((BeanDefinitionRegistry)beanFactory);
        scanner.setEnvironment((Environment)this.getEnvironment());
        BeanNameGenerator beanNameGenerator = this.getBeanNameGenerator();
        ScopeMetadataResolver scopeMetadataResolver = this.getScopeMetadataResolver();
        if (beanNameGenerator != null) {
            reader.setBeanNameGenerator(beanNameGenerator);
            scanner.setBeanNameGenerator(beanNameGenerator);
            beanFactory.registerSingleton("org.springframework.context.annotation.internalConfigurationBeanNameGenerator", (Object)beanNameGenerator);
        }
        if (scopeMetadataResolver != null) {
            reader.setScopeMetadataResolver(scopeMetadataResolver);
            scanner.setScopeMetadataResolver(scopeMetadataResolver);
        }
        if (!ObjectUtils.isEmpty((Object[])this.annotatedClasses)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Registering annotated classes: [" + StringUtils.arrayToCommaDelimitedString((Object[])this.annotatedClasses) + "]"));
            }
            reader.register((Class[])this.annotatedClasses);
        }
        if (!ObjectUtils.isEmpty((Object[])this.basePackages)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Scanning base packages: [" + StringUtils.arrayToCommaDelimitedString((Object[])this.basePackages) + "]"));
            }
            scanner.scan(this.basePackages);
        }
        if ((configLocations = this.getConfigLocations()) != null) {
            for (String configLocation : configLocations) {
                try {
                    Class<?> clazz = this.getClassLoader().loadClass(configLocation);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("Successfully resolved class for [" + configLocation + "]"));
                    }
                    reader.register(new Class[]{clazz});
                }
                catch (ClassNotFoundException ex) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Could not load class for config location [" + configLocation + "] - trying package scan. " + ex));
                    }
                    int count = scanner.scan(new String[]{configLocation});
                    if (!this.logger.isInfoEnabled()) continue;
                    if (count == 0) {
                        this.logger.info((Object)("No annotated classes found for specified class/package [" + configLocation + "]"));
                        continue;
                    }
                    this.logger.info((Object)("Found " + count + " annotated classes in package [" + configLocation + "]"));
                }
            }
        }
    }

    public void setBeanNameGenerator(BeanNameGenerator beanNameGenerator) {
        this.beanNameGenerator = beanNameGenerator;
    }

    protected BeanNameGenerator getBeanNameGenerator() {
        return this.beanNameGenerator;
    }

    public void setScopeMetadataResolver(ScopeMetadataResolver scopeMetadataResolver) {
        this.scopeMetadataResolver = scopeMetadataResolver;
    }

    protected ScopeMetadataResolver getScopeMetadataResolver() {
        return this.scopeMetadataResolver;
    }
}

