/*###############################################################################
# Linux Management Providers (LMP), System Memory provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef CMPIOPENDRIM_MEMORY_H_
#define CMPIOPENDRIM_MEMORY_H_

#include "OpenDRIM_Memory.h"

CMPIObjectPath* SystemMemory_OpenDRIM_Memory_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_Memory& instance);

CMPIInstance* SystemMemory_OpenDRIM_Memory_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_Memory& instance);

void SystemMemory_OpenDRIM_Memory_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_Memory& instance);

void SystemMemory_OpenDRIM_Memory_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_Memory& instance);

void SystemMemory_OpenDRIM_Memory_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_Memory_RequestStateChange_In& args);

void SystemMemory_OpenDRIM_Memory_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_Memory_RequestStateChange_Out& args);

void SystemMemory_OpenDRIM_Memory_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_Memory_SetPowerState_In& args);

void SystemMemory_OpenDRIM_Memory_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_Memory_EnableDevice_In& args);

void SystemMemory_OpenDRIM_Memory_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_Memory_OnlineDevice_In& args);

void SystemMemory_OpenDRIM_Memory_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_Memory_QuiesceDevice_In& args);


#endif /*CMPIOPENDRIM_MEMORY_H_*/
