/*###############################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "cmpiOpenDRIM_Rack.h"

CMPIObjectPath* PhysicalAsset_OpenDRIM_Rack_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_Rack& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_Rack_classnames[0], OpenDRIM_Rack_NAMESPACE);

	if (!instance.Tag_isNULL)
		op.addKey("Tag", instance.Tag);

	if (!instance.CreationClassName_isNULL)
		op.addKey("CreationClassName", instance.CreationClassName);

	_L_;
	return op.getHdl();
}

CMPIInstance* PhysicalAsset_OpenDRIM_Rack_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_Rack& instance) {
	_E_;
	Objectpath op(broker, PhysicalAsset_OpenDRIM_Rack_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.InstallDate_isNULL)
		ci.setPropertyDatetime("InstallDate", instance.InstallDate);

	if (!instance.Name_isNULL)
		ci.setProperty("Name", instance.Name);

	if (!instance.OperationalStatus_isNULL)
		ci.setProperty("OperationalStatus", instance.OperationalStatus);

	if (!instance.StatusDescriptions_isNULL)
		ci.setProperty("StatusDescriptions", instance.StatusDescriptions);

	if (!instance.Status_isNULL)
		ci.setProperty("Status", instance.Status);

	if (!instance.HealthState_isNULL)
		ci.setProperty("HealthState", instance.HealthState);

	if (!instance.PrimaryStatus_isNULL)
		ci.setProperty("PrimaryStatus", instance.PrimaryStatus);

	if (!instance.DetailedStatus_isNULL)
		ci.setProperty("DetailedStatus", instance.DetailedStatus);

	if (!instance.OperatingStatus_isNULL)
		ci.setProperty("OperatingStatus", instance.OperatingStatus);

	if (!instance.CommunicationStatus_isNULL)
		ci.setProperty("CommunicationStatus", instance.CommunicationStatus);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.Manufacturer_isNULL)
		ci.setProperty("Manufacturer", instance.Manufacturer);

	if (!instance.Model_isNULL)
		ci.setProperty("Model", instance.Model);

	if (!instance.SKU_isNULL)
		ci.setProperty("SKU", instance.SKU);

	if (!instance.SerialNumber_isNULL)
		ci.setProperty("SerialNumber", instance.SerialNumber);

	if (!instance.Version_isNULL)
		ci.setProperty("Version", instance.Version);

	if (!instance.PartNumber_isNULL)
		ci.setProperty("PartNumber", instance.PartNumber);

	if (!instance.OtherIdentifyingInfo_isNULL)
		ci.setProperty("OtherIdentifyingInfo", instance.OtherIdentifyingInfo);

	if (!instance.PoweredOn_isNULL)
		ci.setProperty("PoweredOn", instance.PoweredOn);

	if (!instance.ManufactureDate_isNULL)
		ci.setPropertyDatetime("ManufactureDate", instance.ManufactureDate);

	if (!instance.VendorEquipmentType_isNULL)
		ci.setProperty("VendorEquipmentType", instance.VendorEquipmentType);

	if (!instance.UserTracking_isNULL)
		ci.setProperty("UserTracking", instance.UserTracking);

	if (!instance.CanBeFRUed_isNULL)
		ci.setProperty("CanBeFRUed", instance.CanBeFRUed);

	if (!instance.RemovalConditions_isNULL)
		ci.setProperty("RemovalConditions", instance.RemovalConditions);

	if (!instance.Removable_isNULL)
		ci.setProperty("Removable", instance.Removable);

	if (!instance.Replaceable_isNULL)
		ci.setProperty("Replaceable", instance.Replaceable);

	if (!instance.HotSwappable_isNULL)
		ci.setProperty("HotSwappable", instance.HotSwappable);

	if (!instance.Depth_isNULL)
		ci.setProperty("Depth", instance.Depth);

	if (!instance.Width_isNULL)
		ci.setProperty("Width", instance.Width);

	if (!instance.Weight_isNULL)
		ci.setProperty("Weight", instance.Weight);

	if (!instance.PackageType_isNULL)
		ci.setProperty("PackageType", instance.PackageType);

	if (!instance.OtherPackageType_isNULL)
		ci.setProperty("OtherPackageType", instance.OtherPackageType);

	if (!instance.VendorCompatibilityStrings_isNULL)
		ci.setProperty("VendorCompatibilityStrings", instance.VendorCompatibilityStrings);

	if (!instance.CableManagementStrategy_isNULL)
		ci.setProperty("CableManagementStrategy", instance.CableManagementStrategy);

	if (!instance.ServicePhilosophy_isNULL)
		ci.setProperty("ServicePhilosophy", instance.ServicePhilosophy);

	if (!instance.ServiceDescriptions_isNULL)
		ci.setProperty("ServiceDescriptions", instance.ServiceDescriptions);

	if (!instance.LockPresent_isNULL)
		ci.setProperty("LockPresent", instance.LockPresent);

	if (!instance.AudibleAlarm_isNULL)
		ci.setProperty("AudibleAlarm", instance.AudibleAlarm);

	if (!instance.VisibleAlarm_isNULL)
		ci.setProperty("VisibleAlarm", instance.VisibleAlarm);

	if (!instance.SecurityBreach_isNULL)
		ci.setProperty("SecurityBreach", instance.SecurityBreach);

	if (!instance.BreachDescription_isNULL)
		ci.setProperty("BreachDescription", instance.BreachDescription);

	if (!instance.IsLocked_isNULL)
		ci.setProperty("IsLocked", instance.IsLocked);

	if (!instance.Height_isNULL)
		ci.setProperty("Height", instance.Height);

	if (!instance.TypeOfRack_isNULL)
		ci.setProperty("TypeOfRack", instance.TypeOfRack);

	if (!instance.CountryDesignation_isNULL)
		ci.setProperty("CountryDesignation", instance.CountryDesignation);

	_L_;
	return ci.getHdl();
}

void PhysicalAsset_OpenDRIM_Rack_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_Rack& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("CreationClassName", instance.CreationClassName) == OK)
		instance.CreationClassName_isNULL = false;

	if (op.getKey("Tag", instance.Tag) == OK)
		instance.Tag_isNULL = false;

	_L_;
}

void PhysicalAsset_OpenDRIM_Rack_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_Rack& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getPropertyDatetime("InstallDate", instance.InstallDate) == OK)
		instance.InstallDate_isNULL = false;

	if (inst.getProperty("Name", instance.Name) == OK)
		instance.Name_isNULL = false;

	if (inst.getProperty("OperationalStatus", instance.OperationalStatus) == OK)
		instance.OperationalStatus_isNULL = false;

	if (inst.getProperty("StatusDescriptions", instance.StatusDescriptions) == OK)
		instance.StatusDescriptions_isNULL = false;

	if (inst.getProperty("Status", instance.Status) == OK)
		instance.Status_isNULL = false;

	if (inst.getProperty("HealthState", instance.HealthState) == OK)
		instance.HealthState_isNULL = false;

	if (inst.getProperty("PrimaryStatus", instance.PrimaryStatus) == OK)
		instance.PrimaryStatus_isNULL = false;

	if (inst.getProperty("DetailedStatus", instance.DetailedStatus) == OK)
		instance.DetailedStatus_isNULL = false;

	if (inst.getProperty("OperatingStatus", instance.OperatingStatus) == OK)
		instance.OperatingStatus_isNULL = false;

	if (inst.getProperty("CommunicationStatus", instance.CommunicationStatus) == OK)
		instance.CommunicationStatus_isNULL = false;

	if (inst.getProperty("Tag", instance.Tag) == OK)
		instance.Tag_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("CreationClassName", instance.CreationClassName) == OK)
		instance.CreationClassName_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getProperty("Manufacturer", instance.Manufacturer) == OK)
		instance.Manufacturer_isNULL = false;

	if (inst.getProperty("Model", instance.Model) == OK)
		instance.Model_isNULL = false;

	if (inst.getProperty("SKU", instance.SKU) == OK)
		instance.SKU_isNULL = false;

	if (inst.getProperty("SerialNumber", instance.SerialNumber) == OK)
		instance.SerialNumber_isNULL = false;

	if (inst.getProperty("Version", instance.Version) == OK)
		instance.Version_isNULL = false;

	if (inst.getProperty("PartNumber", instance.PartNumber) == OK)
		instance.PartNumber_isNULL = false;

	if (inst.getProperty("OtherIdentifyingInfo", instance.OtherIdentifyingInfo) == OK)
		instance.OtherIdentifyingInfo_isNULL = false;

	if (inst.getProperty("PoweredOn", instance.PoweredOn) == OK)
		instance.PoweredOn_isNULL = false;

	if (inst.getPropertyDatetime("ManufactureDate", instance.ManufactureDate) == OK)
		instance.ManufactureDate_isNULL = false;

	if (inst.getProperty("VendorEquipmentType", instance.VendorEquipmentType) == OK)
		instance.VendorEquipmentType_isNULL = false;

	if (inst.getProperty("UserTracking", instance.UserTracking) == OK)
		instance.UserTracking_isNULL = false;

	if (inst.getProperty("CanBeFRUed", instance.CanBeFRUed) == OK)
		instance.CanBeFRUed_isNULL = false;

	if (inst.getProperty("RemovalConditions", instance.RemovalConditions) == OK)
		instance.RemovalConditions_isNULL = false;

	if (inst.getProperty("Removable", instance.Removable) == OK)
		instance.Removable_isNULL = false;

	if (inst.getProperty("Replaceable", instance.Replaceable) == OK)
		instance.Replaceable_isNULL = false;

	if (inst.getProperty("HotSwappable", instance.HotSwappable) == OK)
		instance.HotSwappable_isNULL = false;

	if (inst.getProperty("Depth", instance.Depth) == OK)
		instance.Depth_isNULL = false;

	if (inst.getProperty("Width", instance.Width) == OK)
		instance.Width_isNULL = false;

	if (inst.getProperty("Weight", instance.Weight) == OK)
		instance.Weight_isNULL = false;

	if (inst.getProperty("PackageType", instance.PackageType) == OK)
		instance.PackageType_isNULL = false;

	if (inst.getProperty("OtherPackageType", instance.OtherPackageType) == OK)
		instance.OtherPackageType_isNULL = false;

	if (inst.getProperty("VendorCompatibilityStrings", instance.VendorCompatibilityStrings) == OK)
		instance.VendorCompatibilityStrings_isNULL = false;

	if (inst.getProperty("CableManagementStrategy", instance.CableManagementStrategy) == OK)
		instance.CableManagementStrategy_isNULL = false;

	if (inst.getProperty("ServicePhilosophy", instance.ServicePhilosophy) == OK)
		instance.ServicePhilosophy_isNULL = false;

	if (inst.getProperty("ServiceDescriptions", instance.ServiceDescriptions) == OK)
		instance.ServiceDescriptions_isNULL = false;

	if (inst.getProperty("LockPresent", instance.LockPresent) == OK)
		instance.LockPresent_isNULL = false;

	if (inst.getProperty("AudibleAlarm", instance.AudibleAlarm) == OK)
		instance.AudibleAlarm_isNULL = false;

	if (inst.getProperty("VisibleAlarm", instance.VisibleAlarm) == OK)
		instance.VisibleAlarm_isNULL = false;

	if (inst.getProperty("SecurityBreach", instance.SecurityBreach) == OK)
		instance.SecurityBreach_isNULL = false;

	if (inst.getProperty("BreachDescription", instance.BreachDescription) == OK)
		instance.BreachDescription_isNULL = false;

	if (inst.getProperty("IsLocked", instance.IsLocked) == OK)
		instance.IsLocked_isNULL = false;

	if (inst.getProperty("Height", instance.Height) == OK)
		instance.Height_isNULL = false;

	if (inst.getProperty("TypeOfRack", instance.TypeOfRack) == OK)
		instance.TypeOfRack_isNULL = false;

	if (inst.getProperty("CountryDesignation", instance.CountryDesignation) == OK)
		instance.CountryDesignation_isNULL = false;

	_L_;
}

void PhysicalAsset_OpenDRIM_Rack_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_Rack_IsCompatible_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	Objectpath ElementToCheck;
	data = in->ft->getArg(in, "ElementToCheck", &rc);
	if (rc.rc == OK) {
		CT_ToC(broker, data, ElementToCheck);	
		args.setElementToCheck(ElementToCheck);
	}			

	_L_;
}

