/*###############################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_PHYSICALPACKAGECAPACITY_H_
#define OPENDRIM_PHYSICALPACKAGECAPACITY_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiCIM_PhysicalElement.h"
#include "CIM_PhysicalElementAccess.h"
#include "cmpiCIM_PhysicalCapacity.h"
#include "CIM_PhysicalCapacityAccess.h"
*/

const static char* OpenDRIM_PhysicalPackageCapacity_classnames[] = {"OpenDRIM_PhysicalPackageCapacity"};
static string OpenDRIM_PhysicalPackageCapacity_NAMESPACE = _NAMESPACE;
const static string Element_role = "Element";
const static char* Element_classnames[] = {"CIM_PhysicalElement"};
const static string Element_NAMESPACE = _NAMESPACE;

const static string Capacity_role = "Capacity";
const static char* Capacity_classnames[] = {"CIM_PhysicalCapacity"};
const static string Capacity_NAMESPACE = _NAMESPACE;

class OpenDRIM_PhysicalPackageCapacity {

public:
	
	Objectpath Capacity;
	bool Capacity_isNULL;
	
	Objectpath Element;
	bool Element_isNULL;
	
	OpenDRIM_PhysicalPackageCapacity() {
		Capacity_isNULL = true;
		Element_isNULL = true;
	}
	
	~OpenDRIM_PhysicalPackageCapacity() {}
	
	string getKeys() const {
		return CF_toLowCase(".Capacity=\"" + CF_quoteString(Capacity.toString()) + "\""".Element=\"" + CF_quoteString(Element.toString()) + "\"");
	}

	int getCapacity(Objectpath& value) const {
		if (Capacity_isNULL==true)
			return NOT_FOUND;
		value = Capacity;
		return OK;
	}
	
	int setCapacity(const Objectpath& newValue) {
		Capacity = newValue;
		Capacity.setNamespace(Capacity_NAMESPACE);
		Capacity_isNULL = false;
		return OK;
	}

	int getElement(Objectpath& value) const {
		if (Element_isNULL==true)
			return NOT_FOUND;
		value = Element;
		return OK;
	}
	
	int setElement(const Objectpath& newValue) {
		Element = newValue;
		Element.setNamespace(Element_NAMESPACE);
		Element_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_PHYSICALPACKAGECAPACITY_H_*/
