########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Monday 16 April 2007 14:12:48 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Examples/matplotlib/Figure_net.py,v 1.3 2007/08/29 20:37:16 vareille Exp $
#
# $Id: Figure_net.py,v 1.3 2007/08/29 20:37:16 vareille Exp $
#

from traceback import print_exc
## loading libraries ##
from Vision.matplotlibNodes import matplotliblib
masterNet.getEditor().addLibraryInstance(matplotliblib,"Vision.matplotlibNodes", "matplotliblib")

from Vision.StandardNodes import stdlib
masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

try:
    ## saving node Histogram ##
    from Vision.matplotlibNodes import HistogramNE
    Histogram_24 = HistogramNE(constrkw = {}, name='Histogram', library=matplotliblib)
    masterNet.addNode(Histogram_24,42,276)
    Histogram_24.inputPortByName['bins'].widget.set(50, run=False)
    Histogram_24.inputPortByName['patch_facecolor'].widget.set("green", run=False)
    apply(Histogram_24.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore HistogramNE named Histogram in network masterNet"
    print_exc()
    Histogram_24=None

try:
    ## saving node Draw Area ##
    from Vision.matplotlibNodes import MPLDrawAreaNE
    Draw_Area_25 = MPLDrawAreaNE(constrkw = {}, name='Draw Area', library=matplotliblib)
    masterNet.addNode(Draw_Area_25,92,177)
    Draw_Area_25.inputPortByName['width'].widget.set(0.391666666667, run=False)
    Draw_Area_25.inputPortByName['hold'].widget.set(1, run=False)
    Draw_Area_25.inputPortByName['title'].widget.set("Histogram of IQ ", run=False)
    Draw_Area_25.inputPortByName['xlabel'].widget.set("Smarts", run=False)
    Draw_Area_25.inputPortByName['ylabel'].widget.set("Probability", run=False)
except:
    print "WARNING: failed to restore MPLDrawAreaNE named Draw Area in network masterNet"
    print_exc()
    Draw_Area_25=None

try:
    ## saving node ReadTable ##
    from Vision.StandardNodes import ReadTable
    ReadTable_26 = ReadTable(constrkw = {}, name='ReadTable', library=stdlib)
    masterNet.addNode(ReadTable_26,285,7)
    ReadTable_26.inputPortByName['filename'].widget.set("Data/plot_data.dat", run=False)
    ReadTable_26.inputPortByName['sep'].widget.set(",", run=False)
    ReadTable_26.inputPortByName['datatype'].widget.set("float", run=False)
    apply(ReadTable_26.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore ReadTable named ReadTable in network masterNet"
    print_exc()
    ReadTable_26=None

try:
    ## saving node Plot ##
    from Vision.matplotlibNodes import PlotNE
    Plot_27 = PlotNE(constrkw = {}, name='Plot', library=matplotliblib)
    masterNet.addNode(Plot_27,313,350)
    Plot_27.inputPortByName['color'].widget.set("blue", run=False)
    apply(Plot_27.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore PlotNE named Plot in network masterNet"
    print_exc()
    Plot_27=None

try:
    ## saving node Set Matplotlib options ##
    from Vision.matplotlibNodes import MatPlotLibOptions
    Set_Matplotlib_options_28 = MatPlotLibOptions(constrkw = {}, name='Set Matplotlib options', library=matplotliblib)
    masterNet.addNode(Set_Matplotlib_options_28,493,176)
    Set_Matplotlib_options_28.inputPortByName['matplotlibOptions'].widget.set({'gridOn': 1}, run=False)
except:
    print "WARNING: failed to restore MatPlotLibOptions named Set Matplotlib options in network masterNet"
    print_exc()
    Set_Matplotlib_options_28=None

try:
    ## saving node Draw Area ##
    from Vision.matplotlibNodes import MPLDrawAreaNE
    Draw_Area_29 = MPLDrawAreaNE(constrkw = {}, name='Draw Area', library=matplotliblib)
    masterNet.addNode(Draw_Area_29,374,178)
    Draw_Area_29.inputPortByName['left'].widget.set(0.563888888889, run=False)
    Draw_Area_29.inputPortByName['width'].widget.set(0.413888888889, run=False)
    Draw_Area_29.inputPortByName['title'].widget.set("About as simple  as it gets, folks", run=False)
    Draw_Area_29.inputPortByName['xlabel'].widget.set("time(s)", run=False)
    Draw_Area_29.inputPortByName['ylabel'].widget.set("voltage(mV)", run=False)
except:
    print "WARNING: failed to restore MPLDrawAreaNE named Draw Area in network masterNet"
    print_exc()
    Draw_Area_29=None

try:
    ## saving node Figure ##
    from Vision.matplotlibNodes import MPLFigureNE
    Figure_30 = MPLFigureNE(constrkw = {}, name='Figure', library=matplotliblib)
    masterNet.addNode(Figure_30,92,419)
    Figure_30.inputPortByName['packOpts'].widget.set("{'side':'top', 'fill':'both', 'expand':1}", run=False)
except:
    print "WARNING: failed to restore MPLFigureNE named Figure in network masterNet"
    print_exc()
    Figure_30=None

try:
    ## saving node ReadTable ##
    from Vision.StandardNodes import ReadTable
    ReadTable_31 = ReadTable(constrkw = {}, name='ReadTable', library=stdlib)
    masterNet.addNode(ReadTable_31,22,5)
    ReadTable_31.inputPortByName['filename'].widget.set("Data/histogram_data.dat", run=False)
    ReadTable_31.inputPortByName['sep'].widget.set(",", run=False)
    ReadTable_31.inputPortByName['datatype'].widget.set("float", run=False)
    apply(ReadTable_31.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore ReadTable named ReadTable in network masterNet"
    print_exc()
    ReadTable_31=None

try:
    ## saving node Index ##
    from Vision.StandardNodes import Index
    Index_32 = Index(constrkw = {}, name='Index', library=stdlib)
    masterNet.addNode(Index_32,255,234)
    apply(Index_32.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore Index named Index in network masterNet"
    print_exc()
    Index_32=None

try:
    ## saving node Index ##
    from Vision.StandardNodes import Index
    Index_33 = Index(constrkw = {}, name='Index', library=stdlib)
    masterNet.addNode(Index_33,439,233)
    apply(Index_33.inputPortByName['index'].widget.configure, (), {'max': 1})
    Index_33.inputPortByName['index'].widget.set(1, run=False)
    apply(Index_33.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore Index named Index in network masterNet"
    print_exc()
    Index_33=None

masterNet.freeze()

## saving connections for network Figure ##
if Draw_Area_25 is not None and Histogram_24 is not None:
    try:
        masterNet.connectNodes(
            Draw_Area_25, Histogram_24, "drawAreaDef", "drawAreaDef", blocking=True)
    except:
        print "WARNING: failed to restore connection between Draw_Area_25 and Histogram_24 in network masterNet"
if Set_Matplotlib_options_28 is not None and Plot_27 is not None:
    try:
        masterNet.connectNodes(
            Set_Matplotlib_options_28, Plot_27, "matplotlibOptions", "drawAreaDef", blocking=True)
    except:
        print "WARNING: failed to restore connection between Set_Matplotlib_options_28 and Plot_27 in network masterNet"
if Draw_Area_29 is not None and Plot_27 is not None:
    try:
        masterNet.connectNodes(
            Draw_Area_29, Plot_27, "drawAreaDef", "drawAreaDef", blocking=True)
    except:
        print "WARNING: failed to restore connection between Draw_Area_29 and Plot_27 in network masterNet"
if Histogram_24 is not None and Figure_30 is not None:
    try:
        masterNet.connectNodes(
            Histogram_24, Figure_30, "plot", "plots", blocking=True)
    except:
        print "WARNING: failed to restore connection between Histogram_24 and Figure_30 in network masterNet"
if Plot_27 is not None and Figure_30 is not None:
    try:
        masterNet.connectNodes(
            Plot_27, Figure_30, "plot", "plots", blocking=True)
    except:
        print "WARNING: failed to restore connection between Plot_27 and Figure_30 in network masterNet"
if ReadTable_31 is not None and Histogram_24 is not None:
    try:
        masterNet.connectNodes(
            ReadTable_31, Histogram_24, "data", "values", blocking=True)
    except:
        print "WARNING: failed to restore connection between ReadTable_31 and Histogram_24 in network masterNet"
if ReadTable_26 is not None and Index_33 is not None:
    try:
        masterNet.connectNodes(
            ReadTable_26, Index_33, "data", "data", blocking=True)
    except:
        print "WARNING: failed to restore connection between ReadTable_26 and Index_33 in network masterNet"
if ReadTable_26 is not None and Index_32 is not None:
    try:
        masterNet.connectNodes(
            ReadTable_26, Index_32, "data", "data", blocking=True)
    except:
        print "WARNING: failed to restore connection between ReadTable_26 and Index_32 in network masterNet"
if Index_32 is not None and Plot_27 is not None:
    try:
        masterNet.connectNodes(
            Index_32, Plot_27, "data", "y", blocking=True)
    except:
        print "WARNING: failed to restore connection between Index_32 and Plot_27 in network masterNet"
if Index_33 is not None and Plot_27 is not None:
    try:
        masterNet.connectNodes(
            Index_33, Plot_27, "data", "x", blocking=True)
    except:
        print "WARNING: failed to restore connection between Index_33 and Plot_27 in network masterNet"
masterNet.unfreeze()
#masterNet.run()

