/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.sam;

import htsjdk.samtools.SAMFileReader;
import java.io.File;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;

public class SAMFileReaderBuilder {
    private File samFile = null;
    private SAMFileReader.ValidationStringency validationStringency = null;

    public void setSAMFile(File samFile) {
        this.samFile = samFile;
    }

    public void setValidationStringency(SAMFileReader.ValidationStringency validationStringency) {
        this.validationStringency = validationStringency;
    }

    public SAMFileReader build() {
        if (this.samFile == null) {
            throw new ReviewedGATKException("Filename for output sam file must be supplied.");
        }
        if (this.validationStringency == null) {
            throw new ReviewedGATKException("Header for output sam file must be supplied.");
        }
        SAMFileReader reader = new SAMFileReader(this.samFile);
        reader.setValidationStringency(this.validationStringency);
        return reader;
    }
}

