/*  traingtk
 *  Copyright (c) 2000 FURUKAWA Yo.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/* $Id: gtktrain.c,v 1.1.1.1 2000/05/07 06:46:46 furukawa Exp $ */

#include <stdio.h>

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "interface.h"
#include "support.h"

#include "gtktrain.h"
#include "libtrain.h"

/* -- local variables */

static GtkWidget *gMainWin;
static gboolean gMainWin_StationFilled;

/* -- prototypes */

static void
MainWin_Search(void);
static void
MainWin_Quit(void);
static void
MainWin_FillStationList(void);

/* -- implementation */

int
main(int argc, char *argv[])
{
    bindtextdomain(PACKAGE, PACKAGE_LOCALE_DIR);
    textdomain(PACKAGE);

    if (Train_Initialize() < 0){
	return 0;
    }

    gtk_set_locale();
    gtk_init(&argc, &argv);

    add_pixmap_directory(PACKAGE_DATA_DIR "/pixmaps");
    add_pixmap_directory(PACKAGE_SOURCE_DIR "/pixmaps");

    gMainWin = create_MainWin();
    gtk_widget_show(gMainWin);
    
    gtk_main();
    return 0;
}

/* -- callbacks */

gboolean
on_MainWin_configure_event(GtkWidget *widget,
			   GdkEventConfigure *event, gpointer user_data)
{
    gMainWin_StationFilled = FALSE;
    return FALSE;
}

void
on_MainWin_destroy(GtkObject *object,
		   gpointer user_data)
{
    MainWin_Quit();
}


gboolean
on_MainWin_delete_event(GtkWidget *widget,
			GdkEvent *event, gpointer user_data)
{
    return FALSE;
}


gboolean
on_MainWin_destroy_event(GtkWidget *widget,
			 GdkEvent *event, gpointer user_data)
{
    MainWin_Quit();
    return FALSE;
}

/* -- menu callbacks */

void
on_MenuOpen_activate(GtkMenuItem *menuitem, gpointer user_data)
{
    GtkWidget *DataOpenDialog;
    DataOpenDialog = create_DataOpenDialog();
    gtk_file_selection_set_filename(GTK_FILE_SELECTION(DataOpenDialog),
				    Train_GetTrainDir());
    gtk_widget_show(DataOpenDialog);
    gMainWin_StationFilled = FALSE;
}

void
on_MenuTime_activate(GtkMenuItem *menuitem, gpointer user_data)
{
    GtkWidget *TimeDialog;
    TimeDialog = create_TimeDialog();
    TimeDialog_Prepare(TimeDialog);
    gtk_widget_show(TimeDialog);
}

void
on_MenuLimit_activate(GtkMenuItem *menuitem, gpointer user_data)
{
    GtkWidget *LimitDialog;
    LimitDialog = create_LimitDialog();
    LimitDialog_Prepare(LimitDialog);
    gtk_widget_show(LimitDialog);
}

void
on_MenuQuit_activate(GtkMenuItem *menuitem, gpointer user_data)
{
    MainWin_Quit();
}

void
on_MenuAbout_activate(GtkMenuItem *menuitem, gpointer user_data)
{
    GtkWidget *AboutDialog;
    AboutDialog = create_AboutDialog();
    gtk_widget_show(AboutDialog);
}

/* -- other callback */

void
on_ButtonSearch_clicked(GtkButton *button, gpointer user_data)
{
    MainWin_Search();
}

void
on_EntryStart_changed(GtkEditable *editable, gpointer user_data)
{
    GtkWidget *clist_result;

    char str[128];
    int cookie = 0;
    int idx;
    
    MainWin_FillStationList();

    clist_result = get_widget(GTK_WIDGET(gMainWin), "CListResult");

    sprintf(str, gtk_entry_get_text(GTK_ENTRY(editable)));
    idx = Train_GetStationComplementCandidate(str, strlen(str), &cookie);
    if (idx < 0){
	idx = 0;
    }
    gtk_clist_select_row(GTK_CLIST(clist_result), idx, 0);
    gtk_clist_moveto(GTK_CLIST(clist_result), idx, 0, 0, 0);
}

void
on_EntryDestination_changed(GtkEditable *editable, gpointer user_data)
{
    GtkWidget *clist_result;

    char str[128];
    int cookie = 0;
    int idx;
    
    MainWin_FillStationList();

    clist_result = get_widget(GTK_WIDGET(gMainWin), "CListResult");

    sprintf(str, gtk_entry_get_text(GTK_ENTRY(editable)));
    idx = Train_GetStationComplementCandidate(str, strlen(str), &cookie);
    if (idx < 0){
	idx = 0;
    }
    gtk_clist_select_row(GTK_CLIST(clist_result), idx, 0);
    gtk_clist_moveto(GTK_CLIST(clist_result), idx, 0, 0, 0);
}

gboolean
on_EntryStart_key_press_event(GtkWidget *widget, GdkEventKey *event,
			      gpointer user_data)
{
    char str[128];
    int idx, cookie = 0;
    
    switch (event->keyval){
    case GDK_Up:
    case GDK_Down:
	g_message("I want to move focus to candidate list");
	break;
    case GDK_Return:
	/* complete */
	sprintf(str, gtk_entry_get_text(GTK_ENTRY(widget)));
	idx = Train_GetStationComplementCandidate(str, strlen(str), &cookie);
	if (idx < 0){
	    return FALSE;
	}
	gtk_entry_set_text(GTK_ENTRY(widget), Train_GetStationNameInRoman(idx));
	return TRUE;
	break;
    }
    return FALSE;
}

gboolean
on_EntryDestination_key_press_event(GtkWidget *widget, GdkEventKey *event,
				    gpointer user_data)
{
    char str[128];
    int idx, cookie = 0;
    
    switch (event->keyval){
    case GDK_Up:
    case GDK_Down:
	g_message("I want to move focus to candidate list");
	break;
    case GDK_Return:
	/* complete */
	sprintf(str, gtk_entry_get_text(GTK_ENTRY(widget)));
	idx = Train_GetStationComplementCandidate(str, strlen(str), &cookie);
	if (idx < 0){
	    return FALSE;
	}
	gtk_entry_set_text(GTK_ENTRY(widget), Train_GetStationNameInRoman(idx));
	return TRUE;
	break;
    }
    return FALSE;
}

/* -- main work -- */

static void
MainWin_Quit(void)
{
    Train_Finalize();
    gtk_main_quit();
}

static void
MainWin_Search(void)
{
    GtkWidget *entry_start;
    GtkWidget *entry_destination;
    GtkWidget *entry_walk;
    GtkWidget *entry_wait;
    GtkWidget *entry_total;
    GtkWidget *clist_result;

    char start[128], destination[128], rosen[128];
    int startid, endid;
    int i;
    char *p;

    entry_start = get_widget(GTK_WIDGET(gMainWin), "EntryStart");
    entry_destination = get_widget(GTK_WIDGET(gMainWin), "EntryDestination");
    entry_walk = get_widget(GTK_WIDGET(gMainWin), "EntryWalk");
    entry_wait = get_widget(GTK_WIDGET(gMainWin), "EntryWait");
    entry_total = get_widget(GTK_WIDGET(gMainWin), "EntryTotal");
    clist_result = get_widget(GTK_WIDGET(gMainWin), "CListResult");

    sprintf(start, gtk_entry_get_text(GTK_ENTRY(entry_start)));
    sprintf(destination, gtk_entry_get_text(GTK_ENTRY(entry_destination)));
    rosen[0] = '\0';

    fprintf(stderr, "start: %s\n", start);
    fprintf(stderr, "destination: %s\n", destination);

    startid = Train_SetStartPoint(start);
    endid = Train_SetEndPoint(destination);

    Train_Search(startid, endid);

    gtk_clist_clear(GTK_CLIST(clist_result));
    for (i = 0; (p = Train_GetResultItem(i)) != NULL; i++){
	if (strlen(p) > 0){
	    gchar *row[1];
	    row[0] = p;
	    gtk_clist_append(GTK_CLIST(clist_result), row);
	    fprintf(stderr, "%4d: %s\n", i, p);
	}
    }
    gMainWin_StationFilled = FALSE;

    gtk_entry_set_text(GTK_ENTRY(entry_walk), Train_GetWalkText());
    gtk_entry_set_text(GTK_ENTRY(entry_wait), Train_GetWaitText());
    gtk_entry_set_text(GTK_ENTRY(entry_total), Train_GetTotalText());
}

static void
MainWin_FillStationList(void)
{
    GtkWidget *clist_result;

    int max, i;

    if (gMainWin_StationFilled){
	return;
    }

    clist_result = get_widget(GTK_WIDGET(gMainWin), "CListResult");
    gtk_clist_clear(GTK_CLIST(clist_result));

    max = Train_GetStationCount();
    for (i = 0; i < max; i++){
	gchar *row[1];
	gchar buf[128], name[128];
	sprintf(name, "%s", Train_GetStationName(i));
	sprintf(buf, "%s (%s)", name, Train_GetStationNameInRoman(i));
	row[0] = buf;
	gtk_clist_append(GTK_CLIST(clist_result), row);
    }

    gMainWin_StationFilled = TRUE;
}
