/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;
import org.apache.xpath.patterns.StepPattern;

public class MatchPatternIterator
extends LocPathIterator {
    static final long serialVersionUID = -5201153767396296474L;
    protected StepPattern m_pattern;
    protected int m_superAxis = -1;
    protected DTMAxisTraverser m_traverser;
    private static final boolean DEBUG = false;

    MatchPatternIterator(Compiler compiler, int opPos, int analysis) throws TransformerException {
        super(compiler, opPos, analysis, false);
        int firstStepPos = Compiler.getFirstChildPos(opPos);
        this.m_pattern = WalkerFactory.loadSteps(this, compiler, firstStepPos, 0);
        boolean fromRoot = false;
        boolean walkBack = false;
        boolean walkDescendants = false;
        boolean walkAttributes = false;
        if ((analysis & 0x28000000) != 0) {
            fromRoot = true;
        }
        if ((analysis & 0x5D86000) != 0) {
            walkBack = true;
        }
        if ((analysis & 0x70000) != 0) {
            walkDescendants = true;
        }
        if ((analysis & 0x208000) != 0) {
            walkAttributes = true;
        }
        this.m_superAxis = fromRoot || walkBack ? (walkAttributes ? 16 : 17) : (walkDescendants ? (walkAttributes ? 14 : 5) : 16);
    }

    public void setRoot(int context, Object environment) {
        super.setRoot(context, environment);
        this.m_traverser = this.m_cdtm.getAxisTraverser(this.m_superAxis);
    }

    public void detach() {
        if (this.m_allowDetach) {
            this.m_traverser = null;
            super.detach();
        }
    }

    protected int getNextNode() {
        this.m_lastFetched = -1 == this.m_lastFetched ? this.m_traverser.first(this.m_context) : this.m_traverser.next(this.m_context, this.m_lastFetched);
        return this.m_lastFetched;
    }

    public int nextNode() {
        int savedStart;
        VariableStack vars;
        block9: {
            if (this.m_foundLast) {
                return -1;
            }
            if (-1 != this.m_stackFrame) {
                vars = this.m_execContext.getVarStack();
                savedStart = vars.getStackFrame();
                vars.setStackFrame(this.m_stackFrame);
            } else {
                vars = null;
                savedStart = 0;
            }
            try {
                int next;
                while (-1 != (next = this.getNextNode()) && 1 != this.acceptNode(next, this.m_execContext) && next != -1) {
                }
                if (-1 == next) break block9;
                this.incrementCurrentPos();
                int n = next;
                Object var4_5 = null;
                if (-1 != this.m_stackFrame) {
                    vars.setStackFrame(savedStart);
                }
                return n;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var4_7 = null;
                    if (-1 == this.m_stackFrame) break block10;
                    vars.setStackFrame(savedStart);
                }
                throw throwable;
            }
        }
        this.m_foundLast = true;
        Object var4_6 = null;
        if (-1 != this.m_stackFrame) {
            vars.setStackFrame(savedStart);
        }
        return -1;
    }

    public short acceptNode(int n, XPathContext xctxt) {
        try {
            xctxt.pushCurrentNode(n);
            xctxt.pushIteratorRoot(this.m_context);
            XObject score = this.m_pattern.execute(xctxt);
            short s = score == NodeTest.SCORE_NONE ? (short)3 : 1;
            Object var4_6 = null;
            xctxt.popCurrentNode();
            xctxt.popIteratorRoot();
            return s;
        }
        catch (TransformerException se) {
            try {
                throw new RuntimeException(se.getMessage());
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                xctxt.popCurrentNode();
                xctxt.popIteratorRoot();
                throw throwable;
            }
        }
    }
}

