/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.CommandConfig;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.exceptions.InternalErrorException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.processors.CommandProcessor;
import amazon.fws.clicommando.processors.cliparams.CliParamProcessor;
import amazon.fws.clicommando.processors.cliparams.CliParamProcessorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PosixCliCommandProcessor
implements CommandProcessor {
    @Override
    public Command process(Command process) throws CliCommandoException {
        CommandLine line;
        Options options = new Options();
        PosixParser parser = new PosixParser();
        String[] commandLineArgs = process.getCommandLineArgs();
        CommandConfig commandConfig = process.getCurrentCommandConfig();
        List<CliParamProcessor> paramProcessors = this.loadParams(commandConfig.getAllParameters(), options, commandLineArgs);
        try {
            line = parser.parse(options, commandLineArgs);
        }
        catch (AlreadySelectedException pe) {
            throw new BadInputException(ErrorMessages.ErrorCode.ALREADY_SELECTED, this.removeEnglishPretext(pe.getLocalizedMessage()));
        }
        catch (UnrecognizedOptionException pe) {
            throw new BadInputException(ErrorMessages.ErrorCode.UNRECOGNIZED_OPTION, this.removeEnglishPretext(pe.getLocalizedMessage()));
        }
        catch (MissingArgumentException pe) {
            throw new BadInputException(ErrorMessages.ErrorCode.MISSING_ARGUMENT, this.removeEnglishPretext(pe.getLocalizedMessage()));
        }
        catch (MissingOptionException pe) {
            throw new BadInputException(ErrorMessages.ErrorCode.MISSING_ARGUMENT, this.removeEnglishPretext(pe.getLocalizedMessage()));
        }
        catch (ParseException pe) {
            throw new InternalErrorException("Programmers bug- all parser level options must be optional and bad input errors are explicitly caught", (Exception)((Object)pe));
        }
        this.loadValuesIntoParams(line, paramProcessors);
        return process;
    }

    private List<CliParamProcessor> loadParams(Collection<ParamConfig> params, Options options, String[] commandLineArgs) throws CliCommandoException {
        ArrayList<CliParamProcessor> paramProcessors = new ArrayList<CliParamProcessor>();
        for (ParamConfig pc : params) {
            CliParamProcessor paramProcessor = CliParamProcessorFactory.create(pc, commandLineArgs);
            paramProcessor.loadOptions(options);
            paramProcessors.add(paramProcessor);
        }
        return paramProcessors;
    }

    private void loadValuesIntoParams(CommandLine line, List<CliParamProcessor> paramProcessors) throws CliCommandoException {
        for (CliParamProcessor paramProcessor : paramProcessors) {
            paramProcessor.loadValuesFromCommandLine(line);
            paramProcessor.setIfParamIsSpecifiedOnCommandLine(line);
        }
    }

    private String removeEnglishPretext(String fullMessage) {
        int index = fullMessage.indexOf(58) + 1;
        return fullMessage.substring(index);
    }
}

