/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGI_WOP.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgi_wrOpen(void);

	Open the user INI file for writing, enter write state.

	Return: cfg error code

ob: cfgi_wrOpen
ty: L
su: inifile/2
sh: Open the user INI file for writing
lo: Enters the write state.\par
	Creates a temporary INI file that recieves all writes and delays to
	replace the current INI file until the write process is closed
	successfully.
re: cfgi_wrClose
fi: cfgi_wop.c
in:

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGI_WOP.C 1.3 1999/12/13 02:22:15 ska Exp ska $";
#endif

int cfgi_wrOpen(void)
{	int rv;

	DBG_ENTER("cfgi_wrOpen", Suppl_inifile2)

	chkHeap
	if((rv = cfgi_createFile(strdup(usrini.cfgi_fnam))) == CFG_ERR_NONE)
		I(writeOpen) = CFG_WFILE;

	chkHeap
	DBG_RETURN_I( rv)
}
