/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.event.shared;

import com.google.web.bindery.event.shared.Event;
import com.google.web.bindery.event.shared.EventBus;
import com.google.web.bindery.event.shared.HandlerRegistration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResettableEventBus
extends EventBus {
    private final EventBus wrapped;
    private final Set<HandlerRegistration> registrations = new HashSet<HandlerRegistration>();

    public ResettableEventBus(EventBus wrappedBus) {
        this.wrapped = wrappedBus;
    }

    @Override
    public <H> HandlerRegistration addHandler(Event.Type<H> type, H handler) {
        HandlerRegistration rtn = this.wrapped.addHandler(type, handler);
        return this.doRegisterHandler(rtn);
    }

    @Override
    public <H> HandlerRegistration addHandlerToSource(Event.Type<H> type, Object source, H handler) {
        HandlerRegistration rtn = this.wrapped.addHandlerToSource(type, source, handler);
        return this.doRegisterHandler(rtn);
    }

    @Override
    public void fireEvent(Event<?> event) {
        this.wrapped.fireEvent(event);
    }

    @Override
    public void fireEventFromSource(Event<?> event, Object source) {
        this.wrapped.fireEventFromSource(event, source);
    }

    public void removeHandlers() {
        Iterator<HandlerRegistration> it = this.registrations.iterator();
        while (it.hasNext()) {
            HandlerRegistration r = it.next();
            it.remove();
            r.removeHandler();
        }
    }

    protected int getRegistrationSize() {
        return this.registrations.size();
    }

    private HandlerRegistration doRegisterHandler(final HandlerRegistration registration) {
        this.registrations.add(registration);
        return new HandlerRegistration(){

            public void removeHandler() {
                ResettableEventBus.this.doUnregisterHandler(registration);
            }
        };
    }

    private void doUnregisterHandler(HandlerRegistration registration) {
        if (this.registrations.contains(registration)) {
            registration.removeHandler();
            this.registrations.remove(registration);
        }
    }
}

