/*
 *  mon_lowmem.cpp - MacOS low memory globals definitions
 *
 *  cxmon (C) 1997-2004 Christian Bauer, Marc Hellwig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "sysdeps.h"

#include "mon_lowmem.h"

// Array of low memory globals in ascending order
const lowmem_info lowmem[] = {
	{"MonkeyLives"		, 0x100},
	{"ScrVRes"			, 0x102},
	{"ScrHRes"			, 0x104},
	{"ScreenRow"		, 0x106},
	{"MemTop"			, 0x108},
	{"BufPtr"			, 0x10C},
	{"StkLowPt"			, 0x110},
	{"HeapEnd"			, 0x114},
	{"TheZone"			, 0x118},
	{"UTableBase"		, 0x11C},
	{"MacJump"			, 0x120},
	{"DskRtnAdr"		, 0x124},
	{"PollRtnAdr"		, 0x128},
	{"DskVerify"		, 0x12C},
	{"LoadTrap"			, 0x12D},
	{"MmInOK"			, 0x12E},
	{"CPUFlag"			, 0x12F},
	{"ApplLimit"		, 0x130},
	{"SonyVars"			, 0x134},
	{"PWMValue"			, 0x138},
	{"PollStack"		, 0x13A},
	{"PollProc"			, 0x13E},
	{"DskErr"			, 0x142},
	{"SysEvtMask"		, 0x144},
	{"SysEvtBuf"		, 0x146},
	{"EventQueue"		, 0x14A},
	{"EvtBufCnt"		, 0x154},
	{"RndSeed"			, 0x156},
	{"SysVersion"		, 0x15A},
	{"SEvtEnb"			, 0x15C},
	{"DSWndUpdate"		, 0x15D},
	{"FontFlag"			, 0x15E},
	{"IntFlag"			, 0x15F},
	{"VBLQueue"			, 0x160},
	{"Ticks"			, 0x16A},
	{"MBTicks"			, 0x16E},
	{"MBState"			, 0x172},
	{"Tocks"			, 0x173},
	{"KeyMap"			, 0x174},
	{"KeypadMap"		, 0x17C},
	{"KeyLast"			, 0x184},
	{"KeyTime"			, 0x186},
	{"KeyRepTime"		, 0x18A},
	{"KeyThresh"		, 0x18E},
	{"KeyRepThresh"		, 0x190},
	{"Lvl1DT"			, 0x192},
	{"Lvl2DT"			, 0x1B2},
	{"UnitNtryCnt"		, 0x1D2},
	{"VIA"				, 0x1D4},
	{"SCCRd"			, 0x1D8},
	{"SCCWr"			, 0x1DC},
	{"IWM"				, 0x1E0},
	{"GetParam"			, 0x1E4},
	{"SysParam"			, 0x1F8},
	{"SPValid"			, 0x1F8},
	{"SPATalkA"			, 0x1F9},
	{"SPATalkB"			, 0x1FA},
	{"SPConfig"			, 0x1FB},
	{"SPPortA"			, 0x1FC},
	{"SPPortB"			, 0x1FE},
	{"SPAlarm"			, 0x200},
	{"SPFont"			, 0x204},
	{"SPKbd"			, 0x206},
	{"SPPrint"			, 0x207},
	{"SPVolCtl"			, 0x208},
	{"SPClikCaret"		, 0x209},
	{"SPMisc1"			, 0x20A},
	{"SPMisc2"			, 0x20B},
	{"Time"				, 0x20C},
	{"BootDrive"		, 0x210},
	{"JShell"			, 0x212},
	{"SFSaveDisk"		, 0x214},
	{"KbdVars"			, 0x216},
	{"KbdLast"			, 0x218},
	{"JKybdTask"		, 0x21A},
	{"KbdType"			, 0x21E},
	{"AlarmState"		, 0x21F},
	{"MemErr"			, 0x220},
	{"JFigTrkSpd"		, 0x222},
	{"JDiskPrime"		, 0x226},
	{"JRdAddr"			, 0x22A},
	{"JRdData"			, 0x22E},
	{"JWrData"			, 0x232},
	{"JSeek"			, 0x236},
	{"JSetupPoll"		, 0x23A},
	{"JRecal"			, 0x23E},
	{"JControl"			, 0x242},
	{"JWakeUp"			, 0x246},
	{"JReSeek"			, 0x24A},
	{"JMakeSpdTbl"		, 0x24E},
	{"JAdrDisk"			, 0x252},
	{"JSetSpeed"		, 0x256},
	{"NiblTbl"			, 0x25A},
	{"FlEvtMask"		, 0x25E},
	{"SdVolume"			, 0x260},
	{"SdEnable/Finder"	, 0x261},
	{"SoundVars"		, 0x262},
	{"SoundBase"		, 0x266},
	{"SoundVBL"			, 0x26A},
	{"SoundDCE"			, 0x27A},
	{"SoundActive"		, 0x27E},
	{"SoundLevel"		, 0x27F},
	{"CurPitch"			, 0x280},
	{"Switcher"			, 0x282},
	{"SwitcherTPtr"		, 0x286},
	{"RSDHndl"			, 0x28A},
	{"ROM85"			, 0x28E},
	{"PortAUse"			, 0x290},
	{"PortBUse"			, 0x291},
	{"ScreenVars"		, 0x292},
	{"JGNEFilter"		, 0x29A},
	{"Key1Trans"		, 0x29E},
	{"Key2Trans"		, 0x2A2},
	{"SysZone"			, 0x2A6},
	{"ApplZone"			, 0x2AA},
	{"ROMBase"			, 0x2AE},
	{"RAMBase"			, 0x2B2},
	{"ExpandMem"		, 0x2B6},
	{"DSAlertTab"		, 0x2BA},
	{"ExtStsDT"			, 0x2BE},
	{"SCCASts"			, 0x2CE},
	{"SCCBSts"			, 0x2CF},
	{"SerialVars"		, 0x2D0},
	{"ABusVars"			, 0x2D8},
	{"ABusDCE"			, 0x2DC},
	{"FinderName"		, 0x2E0},
	{"DoubleTime"		, 0x2F0},
	{"CaretTime"		, 0x2F4},
	{"ScrDmpEnb"		, 0x2F8},
	{"ScrDmpType"		, 0x2F9},
	{"TagData"			, 0x2FA},
	{"BufTgFNum"		, 0x2FC},
	{"BufTgFFlg"		, 0x300},
	{"BufTgFBkNum"		, 0x302},
	{"BufTgDate"		, 0x304},
	{"DrvQHdr"			, 0x308},
	{"PWMBuf2"			, 0x312},
	{"HpChk/MacPgm"		, 0x316},
	{"Lo3Bytes"			, 0x31A},
	{"MinStack"			, 0x31E},
	{"DefltStack"		, 0x322},
	{"MMDefFlags"		, 0x326},
	{"GZRootHnd"		, 0x328},
	{"GZRootPtr"		, 0x32C},
	{"GZMoveHnd"		, 0x330},
	{"DSDrawProc"		, 0x334},
	{"EjectNotify"		, 0x338},
	{"IAZNotify"		, 0x33C},
	{"CurDB"			, 0x340},
	{"NxtDB"			, 0x342},
	{"MaxDB"			, 0x344},
	{"FlushOnly"		, 0x346},
	{"RegRsrc"			, 0x347},
	{"FLckUnlck"		, 0x348},
	{"FrcSync"			, 0x349},
	{"NewMount"			, 0x34A},
	{"NoEject"			, 0x34B},
	{"DrMstrBlk"		, 0x34C},
	{"FCBSPtr"			, 0x34E},
	{"DefVCBPtr"		, 0x352},
	{"VCBQHdr"			, 0x356},
	{"FSQHdr"			, 0x360},
	{"FSQHead"			, 0x362},
	{"FSQTail"			, 0x366},
	{"HFSStkTop"		, 0x36A},
	{"HFSStkPtr"		, 0x36E},
	{"WDCBsPtr"			, 0x372},
	{"HFSFlags"			, 0x376},
	{"CacheFlag"		, 0x377},
	{"SysBMCPtr"		, 0x378},
	{"SysVolCPtr"		, 0x37C},
	{"SysCtlCPtr"		, 0x380},
	{"DefVRefNum"		, 0x384},
	{"PMSPPtr"			, 0x386},
	{"HFSTagData"		, 0x38A},
	{"HFSDSErr"			, 0x392},
	{"CacheVars"		, 0x394},
	{"CurDirStore"		, 0x398},
	{"CacheCom"			, 0x39C},
	{"FmtDefaults"		, 0x39E},
	{"ErCode"			, 0x3A2},
	{"Params"			, 0x3A4},
	{"FSTemp8"			, 0x3D6},
	{"FSIOErr"			, 0x3DE},
	{"FSQueueHook"		, 0x3E2},
	{"ExtFSHook"		, 0x3E6},
	{"DskSwtchHook"		, 0x3EA},
	{"ReqstVol"			, 0x3EE},
	{"ToExtFS"			, 0x3F2},
	{"FSFCBLen"			, 0x3F6},
	{"DSAlertRect"		, 0x3F8},
	{"JHideCrsr"		, 0x800},
	{"JShowCrsr"		, 0x804},
	{"JShieldCrsr"		, 0x808},
	{"JScrnAddr"		, 0x80C},
	{"JScrnSize"		, 0x810},
	{"JInitCrsr"		, 0x814},
	{"JSetCrsr"			, 0x818},
	{"JCrsrObscure"		, 0x81C},
	{"JUpdateProc"		, 0x820},
	{"ScrnBase"			, 0x824},
	{"MTemp"			, 0x828},
	{"RawMouse"			, 0x82C},
	{"Mouse"			, 0x830},
	{"CrsrPin"			, 0x834},
	{"CrsrRect"			, 0x83C},
	{"TheCrsr"			, 0x844},
	{"CrsrAddr"			, 0x888},
	{"JAllocCrsr"		, 0x88C},
	{"JSetCCrsr"		, 0x890},
	{"JOpcodeProc"		, 0x894},
	{"CrsrBase"			, 0x898},
	{"CrsrDevice"		, 0x89C},
	{"SrcDevice"		, 0x8A0},
	{"MainDevice"		, 0x8A4},
	{"DeviceList"		, 0x8A8},
	{"CrsrRow"			, 0x8AC},
	{"QDColors"			, 0x8B0},
	{"CrsrVis"			, 0x8CC},
	{"CrsrBusy"			, 0x8CD},
	{"CrsrNew"			, 0x8CE},
	{"CrsrCouple"		, 0x8CF},
	{"CrsrState"		, 0x8D0},
	{"CrsrObscure"		, 0x8D2},
	{"CrsrScale"		, 0x8D3},
	{"MouseMask"		, 0x8D6},
	{"MouseOffset"		, 0x8DA},
	{"JournalFlag"		, 0x8DE},
	{"JSwapFont"		, 0x8E0},
	{"JFontInfo"		, 0x8E4},
	{"JournalRef"		, 0x8E8},
	{"CrsrThresh"		, 0x8EC},
	{"JCrsrTask"		, 0x8EE},
	{"WWExist"			, 0x8F2},
	{"QDExist"			, 0x8F3},
	{"JFetch"			, 0x8F4},
	{"JStash"			, 0x8F8},
	{"JIODone"			, 0x8FC},
	{"CurApRefNum"		, 0x900},
	{"LaunchFlag"		, 0x902},
	{"FondState"		, 0x903},
	{"CurrentA5"		, 0x904},
	{"CurStackBase"		, 0x908},
	{"LoadFiller"		, 0x90C},
	{"CurApName"		, 0x910},
	{"SaveSegHandle"	, 0x930},
	{"CurJTOffset"		, 0x934},
	{"CurPageOption"	, 0x936},
	{"HiliteMode"		, 0x938},
	{"LoaderPBlock"		, 0x93A},
	{"PrintErr"			, 0x944},
	{"ChooserBits"		, 0x946},
	{"PrFlags"			, 0x946},
	{"PrType"			, 0x947},
	{"PrRefNum"			, 0x952},
	{"LastPGlobal"		, 0x954},
	{"ScrapSize"		, 0x960},
	{"ScrapHandle"		, 0x964},
	{"ScrapCount"		, 0x968},
	{"ScrapState"		, 0x96A},
	{"ScrapName"		, 0x96C},
	{"ScrapTag"			, 0x970},
	{"RomFont0"			, 0x980},
	{"AppFontID"		, 0x984},
	{"SaveFondFlags"	, 0x986},
	{"FMDefaultSize"	, 0x987},
	{"CurFMFamily"		, 0x988},
	{"CurFMSize"		, 0x98A},
	{"CurFMFace"		, 0x98C},
	{"CurFMNeedBits"	, 0x98D},
	{"CurFMDevice"		, 0x98E},
	{"CurFMNumer"		, 0x990},
	{"CurFMDenom"		, 0x994},
	{"FOutError"		, 0x998},
	{"FOutFontHandle"	, 0x99A},
	{"FOutBold"			, 0x99E},
	{"FOutItalic"		, 0x99F},
	{"FOutULOffset"		, 0x9A0},
	{"FOutULShadow"		, 0x9A1},
	{"FOutULThick"		, 0x9A2},
	{"FOutShadow"		, 0x9A3},
	{"FOutExtra"		, 0x9A4},
	{"FOutAscent"		, 0x9A5},
	{"FOutDescent"		, 0x9A6},
	{"FOutWidMax"		, 0x9A7},
	{"FOutLeading"		, 0x9A8},
	{"FOutUnused"		, 0x9A9},
	{"FOutNumer"		, 0x9AA},
	{"FOutDenom"		, 0x9AE},
	{"FMDotsPerInch"	, 0x9B2},
	{"FMStyleTab"		, 0x9B6},
	{"ToolScratch"		, 0x9CE},
	{"WindowList"		, 0x9D6},
	{"SaveUpdate"		, 0x9DA},
	{"PaintWhite"		, 0x9DC},
	{"WMgrPort"			, 0x9DE},
	{"DeskPort"			, 0x9E2},
	{"OldStructure"		, 0x9E6},
	{"OldContent"		, 0x9EA},
	{"GrayRgn"			, 0x9EE},
	{"SaveVisRgn"		, 0x9F2},
	{"DragHook"			, 0x9F6},
	{"TempRect"			, 0x9FA},
	{"OneOne"			, 0xA02},
	{"MinusOne"			, 0xA06},
	{"TopMenuItem"		, 0xA0A},
	{"AtMenuBottom"		, 0xA0C},
	{"IconBitmap"		, 0xA0E},
	{"MenuList"			, 0xA1C},
	{"MBarEnable"		, 0xA20},
	{"CurDeKind"		, 0xA22},
	{"MenuFlash"		, 0xA24},
	{"TheMenu"			, 0xA26},
	{"SavedHandle"		, 0xA28},
	{"MBarHook"			, 0xA2C},
	{"MenuHook"			, 0xA30},
	{"DragPattern"		, 0xA34},
	{"DeskPattern"		, 0xA3C},
	{"DragFlag"			, 0xA44},
	{"CurDragAction"	, 0xA46},
	{"FPState"			, 0xA4A},
	{"TopMapHndl"		, 0xA50},
	{"SysMapHndl"		, 0xA54},
	{"SysMap"			, 0xA58},
	{"CurMap"			, 0xA5A},
	{"ResReadOnly"		, 0xA5C},
	{"ResLoad"			, 0xA5E},
	{"ResErr"			, 0xA60},
	{"TaskLock"			, 0xA62},
	{"FScaleDisable"	, 0xA63},
	{"CurActivate"		, 0xA64},
	{"CurDeactive"		, 0xA68},
	{"DeskHook"			, 0xA6C},
	{"TEDoText"			, 0xA70},
	{"TERecal"			, 0xA74},
	{"ApplScratch"		, 0xA78},
	{"GhostWindow"		, 0xA84},
	{"CloseOrnHook"		, 0xA88},
	{"ResumeProc"		, 0xA8C},
	{"RestProc"			, 0xA8C},
	{"SaveProc"			, 0xA90},
	{"SaveSP"			, 0xA94},
	{"ANumber"			, 0xA98},
	{"ACount"			, 0xA9A},
	{"DABeeper"			, 0xA9C},
	{"DAStrings"		, 0xAA0},
	{"TEScrpLength"		, 0xAB0},
	{"TEScrpHandle"		, 0xAB4},
	{"AppPacks"			, 0xAB8},
	{"SysResName"		, 0xAD8},
	{"SoundGlue"		, 0xAE8},
	{"AppParmHandle"	, 0xAEC},
	{"DSErrCode"		, 0xAF0},
	{"ResErrProc"		, 0xAF2},
	{"TEWdBreak"		, 0xAF6},
	{"DlgFont"			, 0xAFA},
	{"LastTGlobal"		, 0xAFC},
	{"TrapAgain"		, 0xB00},
	{"KeyMVars"			, 0xB04},
	{"ROMMapHndl"		, 0xB06},
	{"PWMBuf1"			, 0xB0A},
	{"BootMask"			, 0xB0E},
	{"WidthPtr"			, 0xB10},
	{"ATalkHk1"			, 0xB14},
	{"LAPMgrPtr"		, 0xB18},
	{"FourDHack"		, 0xB1C},
	{"UnSwitchedFlags"	, 0xB20},
	{"SwitchedFlags"	, 0xB21},
	{"HWCfgFlags"		, 0xB22},
	{"TimeSCSIDB"		, 0xB24},
	{"Top2MenuItem"		, 0xB26},
	{"At2MenuBottom"	, 0xB28},
	{"WidthTabHandle"	, 0xB2A},
	{"SCSIDrvrs"		, 0xB2E},
	{"TimeVars"			, 0xB30},
	{"BtDskRfn"			, 0xB34},
	{"BootTmp8"			, 0xB36},
	{"NTSC"				, 0xB3E},
	{"T1Arbitrate"		, 0xB3F},
	{"JDiskSel"			, 0xB40},
	{"JSendCmd"			, 0xB44},
	{"JDCDReset"		, 0xB48},
	{"LastSPExtra"		, 0xB4C},
	{"FileShareVars"	, 0xB50},
	{"MenuDisable"		, 0xB54},
	{"MBDFHndl"			, 0xB58},
	{"MBSaveLoc"		, 0xB5C},
	{"BNMQHdr"			, 0xB60},
	{"BackgrounderVars"	, 0xB64},
	{"MenuLayer"		, 0xB68},
	{"OmegaSANE"		, 0xB6C},
	{"CarlByte"			, 0xB72},
	{"SystemInfo"		, 0xB73},
	{"VMGlobals"		, 0xB78},
	{"Twitcher2"		, 0xB7C},
	{"RMgrHiVars"		, 0xB80},
	{"HSCHndl"			, 0xB84},
	{"PadRsrc"			, 0xB88},
	{"ResOneDeep"		, 0xB9A},
	{"PadRsrc2"			, 0xB9C},
	{"RomMapInsert"		, 0xB9E},
	{"TmpResLoad"		, 0xB9F},
	{"IntlSpec"			, 0xBA0},
	{"RMgrPerm"			, 0xBA4},
	{"WordRedraw"		, 0xBA5},
	{"SysFontFam"		, 0xBA6},
	{"DefFontSize"		, 0xBA8},
	{"MBarHeight"		, 0xBAA},
	{"TESysJust"		, 0xBAC},
	{"HiHeapMark"		, 0xBAE},
	{"SegHiEnable"		, 0xBB2},
	{"FDevDisable"		, 0xBB3},
	{"CommToolboxGlob"	, 0xBB4},
	{"CMVector"			, 0xBB4},
	{"ShutDwnQHdr"		, 0xBBC},
	{"NewUnused"		, 0xBC0},
	{"LastFOND"			, 0xBC2},
	{"FONDID"			, 0xBC6},
	{"App2Packs"		, 0xBC8},
	{"MAErrProc"		, 0xBE8},
	{"MASuperTab"		, 0xBEC},
	{"MimeGlobs"		, 0xBF0},
	{"FractEnable"		, 0xBF4},
	{"UsedFWidth"		, 0xBF5},
	{"FScaleHFact"		, 0xBF6},
	{"FScaleVFact"		, 0xBFA},
	{"SCCIOPFlag"		, 0xBFE},
	{"MacJmpFlag"		, 0xBFF},
	{"SCSIBase"			, 0xC00},
	{"SCSIDMA"			, 0xC04},
	{"SCSIHsk"			, 0xC08},
	{"SCSIGlobals"		, 0xC0C},
	{"RGBBlack"			, 0xC10},
	{"RGBWhite"			, 0xC16},
	{"FMSynth"			, 0xC1C},
	{"RowBits"			, 0xC20},
	{"ColLines"			, 0xC22},
	{"ScreenBytes"		, 0xC24},
	{"IOPMgrVars"		, 0xC28},
	{"NMIFlag"			, 0xC2C},
	{"VidType"			, 0xC2D},
	{"VidMode"			, 0xC2E},
	{"SCSIPoll"			, 0xC2F},
	{"SEVarBase"		, 0xC30},
	{"MacsBugSP"		, 0xC6C},
	{"MacsBugPC"		, 0xC70},
	{"MacsBugSR"		, 0xC74},
	{"MMUFlags"			, 0xCB0},
	{"MMUType"			, 0xCB1},
	{"MMU32bit"			, 0xCB2},
	{"MachineType"		, 0xCB3},
	{"MMUTbl24"			, 0xCB4},
	{"MMUTbl32"			, 0xCB8},
	{"SInfoPtr"			, 0xCBC},
	{"ASCBase"			, 0xCC0},
	{"SMGlobals"		, 0xCC4},
	{"TheGDevice"		, 0xCC8},
	{"CQDGlobals"		, 0xCCC},
	{"AuxWinHead"		, 0xCD0},
	{"AuxCtlHead"		, 0xCD4},
	{"DeskCPat"			, 0xCD8},
	{"SetOSDefKey"		, 0xCDC},
	{"LastBinPat"		, 0xCE0},
	{"DeskPatEnable"	, 0xCE8},
	{"TimeVIADB"		, 0xCEA},
	{"VIA2Base"			, 0xCEC},
	{"VMVectors"		, 0xCF0},
	{"ADBBase"			, 0xCF8},
	{"WarmStart"		, 0xCFC},
	{"TimeDBRA"			, 0xD00},
	{"TimeSCCDB"		, 0xD02},
	{"SlotQDT"			, 0xD04},
	{"SlotPrTbl"		, 0xD08},
	{"SlotVBLQ"			, 0xD0C},
	{"ScrnVBLPtr"		, 0xD10},
	{"SlotTICKS"		, 0xD14},
	{"PowerMgrVars"		, 0xD18},
	{"AGBHandle"		, 0xD1C},
	{"TableSeed"		, 0xD20},
	{"SRsrcTblPtr"		, 0xD24},
	{"JVBLTask"			, 0xD28},
	{"WMgrCPort"		, 0xD2C},
	{"VertRRate"		, 0xD30},
	{"SynListHandle"	, 0xD32},
	{"LastFore"			, 0xD36},
	{"LastBG"			, 0xD3A},
	{"LastMode"			, 0xD3E},
	{"LastDepth"		, 0xD40},
	{"FMExist"			, 0xD42},
	{"SavedHilite"		, 0xD43},
	{"ShieldDepth"		, 0xD4C},
	{"MenuCInfo"		, 0xD50},
	{"MBProcHndl"		, 0xD54},
	{"MBFlash"			, 0xD5C},
	{"ChunkyDepth"		, 0xD60},
	{"CrsrPtr"			, 0xD62},
	{"PortList"			, 0xD66},
	{"MickeyBytes"		, 0xD6A},
	{"QDErr"			, 0xD6E},
	{"VIA2DT"			, 0xD70},
	{"SInitFlags"		, 0xD90},
	{"DTQueue"			, 0xD92},
	{"DTQFlags"			, 0xD92},
	{"DTskQHdr"			, 0xD94},
	{"DTskQTail"		, 0xD98},
	{"JDTInstall"		, 0xD9C},
	{"HiliteRGB"		, 0xDA0},
	{"OldTimeSCSIDB"	, 0xDA6},
	{"DSCtrAdj"			, 0xDA8},
	{"IconTLAddr"		, 0xDAC},
	{"VideoInfoOK"		, 0xDB0},
	{"EndSRTPtr"		, 0xDB4},
	{"SDMJmpTblPtr"		, 0xDB8},
	{"JSwapMMU"			, 0xDBC},
	{"SdmBusErr"		, 0xDC0},
	{"LastTxGDevice"	, 0xDC4},
	{"PMgrHandle"		, 0xDC8},
	{"LayerPalette"		, 0xDCC},
	{"AddrMapFlags"		, 0xDD0},
	{"UnivROMFlags"		, 0xDD4},
	{"UniversalInfoPtr"	, 0xDD8},
	{"BootGlobPtr"		, 0xDDC},
	{"EgretGlobals"		, 0xDE0},
	{"SaneTrapAddr"		, 0xDE4},
	{"Warhol"			, 0xDE8},
	{"MemVectors24"		, 0x1E00},
	{"Mem2Vectors24"	, 0x1EE0},
	{"Phys2Log"			, 0x1EF0},
	{"RealMemTop"		, 0x1EF4},
	{"PhysMemTop"		, 0x1EF8},
	{"MMFlags"			, 0x1EFC},
	{"MemVectors32"		, 0x1F00},
	{"DrawCrsrVector"	, 0x1FB8},
	{"EraseCrsrVector"	, 0x1FBC},
	{"PSCIntTbl"		, 0x1FC0},
	{"DSPGlobals"		, 0x1FC4},
	{"FP040Vects"		, 0x1FC8},
	{"FPBSUNVec"		, 0x1FCC},
	{"FPUNFLVec"		, 0x1FD0},
	{"FPOPERRVec"		, 0x1FD4},
	{"FPOVFLVec"		, 0x1FD8},
	{"FPSNANVec"		, 0x1FDC},
	{"Mem2Vectors32"	, 0x1FE0},
	{"SCSI2Base"		, 0x1FF0},
	{"LockMemCt"		, 0x1FF4},
	{"DockingGlobals"	, 0x1FF8},
	{"VectorPtr"		, 0x2000},
	{"BasesValid1"		, 0x2400},
	{"BasesValid2"		, 0x2404},
	{"ExtValid1"		, 0x2408},
	{"ExtValid2"		, 0x240C},
	{NULL				, 0xFFFF}
};
