/* mimetype-test.c generated by valac 0.20.1, the Vala compiler
 * generated from mimetype-test.vala, do not modify */

/* where-clause-test.vala
 *
 * Copyright © 2011-2012 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 * Copyright © 2010 Canonical, Ltd.
 *             By Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "zeitgeist-datamodel.h"

#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);



gint _vala_main (gchar** args, int args_length1);
void mime_type_basic_test (void);
static void _mime_type_basic_test_gtest_func (void);
void mime_type_regex_test (void);
static void _mime_type_regex_test_gtest_func (void);
void mime_type_none_test (void);
static void _mime_type_none_test_gtest_func (void);
void mime_type_null_test (void);
static void _mime_type_null_test_gtest_func (void);
void mime_type_registration_test (void);
static void _mime_type_registration_test_gtest_func (void);
void uri_scheme_basic_test (void);
static void _uri_scheme_basic_test_gtest_func (void);
void uri_scheme_none_test (void);
static void _uri_scheme_none_test_gtest_func (void);
void uri_scheme_registration_test (void);
static void _uri_scheme_registration_test_gtest_func (void);


static void _mime_type_basic_test_gtest_func (void) {
#line 30 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	mime_type_basic_test ();
#line 60 "mimetype-test.c"
}


static void _mime_type_regex_test_gtest_func (void) {
#line 31 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	mime_type_regex_test ();
#line 67 "mimetype-test.c"
}


static void _mime_type_none_test_gtest_func (void) {
#line 32 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	mime_type_none_test ();
#line 74 "mimetype-test.c"
}


static void _mime_type_null_test_gtest_func (void) {
#line 33 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	mime_type_null_test ();
#line 81 "mimetype-test.c"
}


static void _mime_type_registration_test_gtest_func (void) {
#line 34 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	mime_type_registration_test ();
#line 88 "mimetype-test.c"
}


static void _uri_scheme_basic_test_gtest_func (void) {
#line 36 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	uri_scheme_basic_test ();
#line 95 "mimetype-test.c"
}


static void _uri_scheme_none_test_gtest_func (void) {
#line 37 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	uri_scheme_none_test ();
#line 102 "mimetype-test.c"
}


static void _uri_scheme_registration_test_gtest_func (void) {
#line 38 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	uri_scheme_registration_test ();
#line 109 "mimetype-test.c"
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 28 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	g_test_init (&args_length1, &args, NULL);
#line 30 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	g_test_add_func ("/MimeType/basic", _mime_type_basic_test_gtest_func);
#line 31 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	g_test_add_func ("/MimeType/regex", _mime_type_regex_test_gtest_func);
#line 32 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	g_test_add_func ("/MimeType/none", _mime_type_none_test_gtest_func);
#line 33 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	g_test_add_func ("/MimeType/null", _mime_type_null_test_gtest_func);
#line 34 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	g_test_add_func ("/MimeType/register", _mime_type_registration_test_gtest_func);
#line 36 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	g_test_add_func ("/UriScheme/basic", _uri_scheme_basic_test_gtest_func);
#line 37 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	g_test_add_func ("/UriScheme/none", _uri_scheme_none_test_gtest_func);
#line 38 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	g_test_add_func ("/UriScheme/register", _uri_scheme_registration_test_gtest_func);
#line 40 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	_tmp0_ = g_test_run ();
#line 40 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	result = _tmp0_;
#line 40 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	return result;
#line 140 "mimetype-test.c"
}


int main (int argc, char ** argv) {
#line 26 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	g_type_init ();
#line 26 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	return _vala_main (argv, argc);
#line 149 "mimetype-test.c"
}


void mime_type_basic_test (void) {
	const gchar* _tmp0_ = NULL;
#line 45 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	_tmp0_ = zeitgeist_interpretation_for_mimetype ("text/plain");
#line 45 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	g_assert_cmpstr (ZEITGEIST_NFO_TEXT_DOCUMENT, ==, _tmp0_);
#line 159 "mimetype-test.c"
}


void mime_type_regex_test (void) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 52 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	_tmp0_ = zeitgeist_interpretation_for_mimetype ("application/x-applix-FOOBAR");
#line 52 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	g_assert_cmpstr (ZEITGEIST_NFO_DOCUMENT, ==, _tmp0_);
#line 56 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	_tmp1_ = zeitgeist_interpretation_for_mimetype ("application/x-applix-spreadsheet");
#line 56 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	g_assert_cmpstr (ZEITGEIST_NFO_SPREADSHEET, ==, _tmp1_);
#line 174 "mimetype-test.c"
}


void mime_type_none_test (void) {
	const gchar* _tmp0_ = NULL;
#line 62 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	_tmp0_ = zeitgeist_interpretation_for_mimetype ("foo/bar");
#line 62 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	_vala_assert (_tmp0_ == NULL, "interpretation_for_mimetype (\"foo/bar\") == null");
#line 184 "mimetype-test.c"
}


void mime_type_null_test (void) {
	const gchar* _tmp0_ = NULL;
#line 67 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	_tmp0_ = zeitgeist_interpretation_for_mimetype (NULL);
#line 67 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	_vala_assert (_tmp0_ == NULL, "interpretation_for_mimetype (null) == null");
#line 194 "mimetype-test.c"
}


void mime_type_registration_test (void) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 72 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	zeitgeist_register_mimetype ("awesome/bird", "Bluebird");
#line 204 "mimetype-test.c"
	{
#line 75 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
		zeitgeist_register_mimetype_regex ("everything/.*", "is nothing");
#line 208 "mimetype-test.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
#line 73 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
		e = _inner_error_;
#line 73 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
		_inner_error_ = NULL;
#line 77 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
		_vala_assert (FALSE, "false");
#line 73 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
		_g_error_free0 (e);
#line 222 "mimetype-test.c"
	}
	__finally0:
#line 73 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	if (_inner_error_ != NULL) {
#line 73 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 73 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
		g_clear_error (&_inner_error_);
#line 73 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
		return;
#line 233 "mimetype-test.c"
	}
#line 80 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	mime_type_basic_test ();
#line 81 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	mime_type_regex_test ();
#line 82 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	mime_type_none_test ();
#line 84 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	_tmp0_ = zeitgeist_interpretation_for_mimetype ("awesome/bird");
#line 84 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	g_assert_cmpstr ("Bluebird", ==, _tmp0_);
#line 86 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	_tmp1_ = zeitgeist_interpretation_for_mimetype ("everything/everywhere");
#line 86 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	g_assert_cmpstr ("is nothing", ==, _tmp1_);
#line 249 "mimetype-test.c"
}


void uri_scheme_basic_test (void) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 92 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	_tmp0_ = zeitgeist_manifestation_for_uri ("file:///tmp/foo.txt");
#line 92 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	g_assert_cmpstr (ZEITGEIST_NFO_FILE_DATA_OBJECT, ==, _tmp0_);
#line 94 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	_tmp1_ = zeitgeist_manifestation_for_uri ("ftp://ftp.example.com");
#line 94 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	g_assert_cmpstr (ZEITGEIST_NFO_REMOTE_DATA_OBJECT, ==, _tmp1_);
#line 264 "mimetype-test.c"
}


void uri_scheme_none_test (void) {
	const gchar* _tmp0_ = NULL;
#line 100 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	_tmp0_ = zeitgeist_manifestation_for_uri ("asdf://awesomehttp://");
#line 100 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	_vala_assert (_tmp0_ == NULL, "manifestation_for_uri (\"asdf://awesomehttp://\") == null");
#line 274 "mimetype-test.c"
}


void uri_scheme_registration_test (void) {
	const gchar* _tmp0_ = NULL;
#line 105 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	zeitgeist_register_uri_scheme ("42://", "the answer");
#line 107 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	uri_scheme_basic_test ();
#line 108 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	uri_scheme_none_test ();
#line 110 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	_tmp0_ = zeitgeist_manifestation_for_uri ("42://what is it?");
#line 110 "/home/manish/code/zeitgeist/test/direct/mimetype-test.vala"
	g_assert_cmpstr ("the answer", ==, _tmp0_);
#line 290 "mimetype-test.c"
}



