/* PhotoMetadata.c generated by valac 0.40.4, the Vala compiler
 * generated from PhotoMetadata.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/**/
/* PhotoMetadata*/
/**/
/* PhotoMetadata is a wrapper class around gexiv2.  The reasoning for this is (a) to facilitate*/
/* interface changes to meet Shotwell's requirements without needing modifications of the library*/
/* itself, and (b) some requirements for this class (i.e. obtaining raw metadata) is not available*/
/* in gexiv2, and so must be done by hand.*/
/**/
/* Although it's perceived that Exiv2 will remain Shotwell's metadata library of choice, this*/
/* may change in the future, and so this wrapper helps with that as well.*/
/**/
/* There is no expectation of thread-safety in this class (yet).*/
/**/
/* Tags come from Exiv2's naming scheme:*/
/* http://www.exiv2.org/metadata.html*/
/**/


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <gexiv2/gexiv2.h>
#include <libexif/exif-data.h>
#include <libexif/exif-mem.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_METADATA_DOMAIN (metadata_domain_get_type ())

#define TYPE_KEYWORD_TRANSFORMER (keyword_transformer_get_type ())
#define KEYWORD_TRANSFORMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEYWORD_TRANSFORMER, KeywordTransformer))
#define KEYWORD_TRANSFORMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEYWORD_TRANSFORMER, KeywordTransformerClass))
#define IS_KEYWORD_TRANSFORMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEYWORD_TRANSFORMER))
#define IS_KEYWORD_TRANSFORMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEYWORD_TRANSFORMER))
#define KEYWORD_TRANSFORMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEYWORD_TRANSFORMER, KeywordTransformerClass))

typedef struct _KeywordTransformer KeywordTransformer;
typedef struct _KeywordTransformerClass KeywordTransformerClass;
typedef struct _KeywordTransformerPrivate KeywordTransformerPrivate;
typedef struct _ParamSpecKeywordTransformer ParamSpecKeywordTransformer;

#define TYPE_NULL_KEYWORD_TRANSFORMER (null_keyword_transformer_get_type ())
#define NULL_KEYWORD_TRANSFORMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NULL_KEYWORD_TRANSFORMER, NullKeywordTransformer))
#define NULL_KEYWORD_TRANSFORMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NULL_KEYWORD_TRANSFORMER, NullKeywordTransformerClass))
#define IS_NULL_KEYWORD_TRANSFORMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NULL_KEYWORD_TRANSFORMER))
#define IS_NULL_KEYWORD_TRANSFORMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NULL_KEYWORD_TRANSFORMER))
#define NULL_KEYWORD_TRANSFORMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NULL_KEYWORD_TRANSFORMER, NullKeywordTransformerClass))

typedef struct _NullKeywordTransformer NullKeywordTransformer;
typedef struct _NullKeywordTransformerClass NullKeywordTransformerClass;
typedef struct _NullKeywordTransformerPrivate NullKeywordTransformerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_ACD_SEE_KEYWORD_TRANSFORMER (acd_see_keyword_transformer_get_type ())
#define ACD_SEE_KEYWORD_TRANSFORMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACD_SEE_KEYWORD_TRANSFORMER, ACDSeeKeywordTransformer))
#define ACD_SEE_KEYWORD_TRANSFORMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACD_SEE_KEYWORD_TRANSFORMER, ACDSeeKeywordTransformerClass))
#define IS_ACD_SEE_KEYWORD_TRANSFORMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACD_SEE_KEYWORD_TRANSFORMER))
#define IS_ACD_SEE_KEYWORD_TRANSFORMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACD_SEE_KEYWORD_TRANSFORMER))
#define ACD_SEE_KEYWORD_TRANSFORMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACD_SEE_KEYWORD_TRANSFORMER, ACDSeeKeywordTransformerClass))

typedef struct _ACDSeeKeywordTransformer ACDSeeKeywordTransformer;
typedef struct _ACDSeeKeywordTransformerClass ACDSeeKeywordTransformerClass;
typedef struct _ACDSeeKeywordTransformerPrivate ACDSeeKeywordTransformerPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_markup_parse_context_unref0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define TYPE_HIERARCHICAL_KEYWORD_FIELD (hierarchical_keyword_field_get_type ())
#define HIERARCHICAL_KEYWORD_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HIERARCHICAL_KEYWORD_FIELD, HierarchicalKeywordField))
#define HIERARCHICAL_KEYWORD_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HIERARCHICAL_KEYWORD_FIELD, HierarchicalKeywordFieldClass))
#define IS_HIERARCHICAL_KEYWORD_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HIERARCHICAL_KEYWORD_FIELD))
#define IS_HIERARCHICAL_KEYWORD_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HIERARCHICAL_KEYWORD_FIELD))
#define HIERARCHICAL_KEYWORD_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HIERARCHICAL_KEYWORD_FIELD, HierarchicalKeywordFieldClass))

typedef struct _HierarchicalKeywordField HierarchicalKeywordField;
typedef struct _HierarchicalKeywordFieldClass HierarchicalKeywordFieldClass;
typedef struct _HierarchicalKeywordFieldPrivate HierarchicalKeywordFieldPrivate;
#define _keyword_transformer_unref0(var) ((var == NULL) ? NULL : (var = (keyword_transformer_unref (var), NULL)))
typedef struct _ParamSpecHierarchicalKeywordField ParamSpecHierarchicalKeywordField;

#define TYPE_PHOTO_PREVIEW (photo_preview_get_type ())
#define PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_PREVIEW, PhotoPreview))
#define PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))
#define IS_PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_PREVIEW))
#define IS_PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_PREVIEW))
#define PHOTO_PREVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))

typedef struct _PhotoPreview PhotoPreview;
typedef struct _PhotoPreviewClass PhotoPreviewClass;
typedef struct _PhotoPreviewPrivate PhotoPreviewPrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
typedef struct _ParamSpecPhotoPreview ParamSpecPhotoPreview;

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;
typedef struct _MediaMetadataPrivate MediaMetadataPrivate;

#define TYPE_METADATA_DATE_TIME (metadata_date_time_get_type ())
#define METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTime))
#define METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))
#define IS_METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_DATE_TIME))
#define IS_METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_DATE_TIME))
#define METADATA_DATE_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))

typedef struct _MetadataDateTime MetadataDateTime;
typedef struct _MetadataDateTimeClass MetadataDateTimeClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;
typedef struct _PhotoMetadataPrivate PhotoMetadataPrivate;

#define PHOTO_METADATA_TYPE_SET_OPTION (photo_metadata_set_option_get_type ())
#define _exif_data_unref0(var) ((var == NULL) ? NULL : (var = (exif_data_unref (var), NULL)))

#define TYPE_PREPARE_INPUT_TEXT_OPTIONS (prepare_input_text_options_get_type ())
typedef struct _Block1Data Block1Data;
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;

#define TYPE_METADATA_RATIONAL (metadata_rational_get_type ())
typedef struct _MetadataRational MetadataRational;
typedef struct _Block4Data Block4Data;
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _exif_mem_unref0(var) ((var == NULL) ? NULL : (var = (exif_mem_unref (var), NULL)))
#define _g_checksum_free0(var) ((var == NULL) ? NULL : (var = (g_checksum_free (var), NULL)))

#define PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW (photo_metadata_internal_photo_preview_get_type ())
#define PHOTO_METADATA_INTERNAL_PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW, PhotoMetadataInternalPhotoPreview))
#define PHOTO_METADATA_INTERNAL_PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW, PhotoMetadataInternalPhotoPreviewClass))
#define PHOTO_METADATA_IS_INTERNAL_PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW))
#define PHOTO_METADATA_IS_INTERNAL_PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW))
#define PHOTO_METADATA_INTERNAL_PHOTO_PREVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW, PhotoMetadataInternalPhotoPreviewClass))

typedef struct _PhotoMetadataInternalPhotoPreview PhotoMetadataInternalPhotoPreview;
typedef struct _PhotoMetadataInternalPhotoPreviewClass PhotoMetadataInternalPhotoPreviewClass;
typedef struct _Block6Data Block6Data;

#define TYPE_HIERARCHICAL_TAG_INDEX (hierarchical_tag_index_get_type ())
#define HIERARCHICAL_TAG_INDEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndex))
#define HIERARCHICAL_TAG_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndexClass))
#define IS_HIERARCHICAL_TAG_INDEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HIERARCHICAL_TAG_INDEX))
#define IS_HIERARCHICAL_TAG_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HIERARCHICAL_TAG_INDEX))
#define HIERARCHICAL_TAG_INDEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndexClass))

typedef struct _HierarchicalTagIndex HierarchicalTagIndex;
typedef struct _HierarchicalTagIndexClass HierarchicalTagIndexClass;
#define _hierarchical_keyword_field_unref0(var) ((var == NULL) ? NULL : (var = (hierarchical_keyword_field_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _hierarchical_tag_index_unref0(var) ((var == NULL) ? NULL : (var = (hierarchical_tag_index_unref (var), NULL)))

#define TYPE_ORIENTATION (orientation_get_type ())

#define TYPE_RATING (rating_get_type ())
typedef struct _PhotoMetadataInternalPhotoPreviewPrivate PhotoMetadataInternalPhotoPreviewPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	METADATA_DOMAIN_UNKNOWN,
	METADATA_DOMAIN_EXIF,
	METADATA_DOMAIN_XMP,
	METADATA_DOMAIN_IPTC
} MetadataDomain;

struct _KeywordTransformer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	KeywordTransformerPrivate * priv;
};

struct _KeywordTransformerClass {
	GTypeClass parent_class;
	void (*finalize) (KeywordTransformer *self);
	GeeList* (*transform) (KeywordTransformer* self, const gchar* input, GError** error);
};

struct _ParamSpecKeywordTransformer {
	GParamSpec parent_instance;
};

struct _NullKeywordTransformer {
	KeywordTransformer parent_instance;
	NullKeywordTransformerPrivate * priv;
};

struct _NullKeywordTransformerClass {
	KeywordTransformerClass parent_class;
};

struct _ACDSeeKeywordTransformer {
	KeywordTransformer parent_instance;
	ACDSeeKeywordTransformerPrivate * priv;
};

struct _ACDSeeKeywordTransformerClass {
	KeywordTransformerClass parent_class;
};

struct _ACDSeeKeywordTransformerPrivate {
	GMarkupParser parser;
	GError* error;
	GeeArrayQueue* stack;
	GeeArrayList* result;
	gboolean assigned;
};

struct _HierarchicalKeywordField {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HierarchicalKeywordFieldPrivate * priv;
	gchar* field_name;
	gchar* path_separator;
	gboolean wants_leading_separator;
	gboolean is_writeable;
	KeywordTransformer* transformer;
};

struct _HierarchicalKeywordFieldClass {
	GTypeClass parent_class;
	void (*finalize) (HierarchicalKeywordField *self);
};

struct _ParamSpecHierarchicalKeywordField {
	GParamSpec parent_instance;
};

struct _PhotoPreview {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoPreviewPrivate * priv;
};

struct _PhotoPreviewClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoPreview *self);
	GBytes* (*flatten) (PhotoPreview* self, GError** error);
	GdkPixbuf* (*get_pixbuf) (PhotoPreview* self, GError** error);
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _PhotoPreviewPrivate {
	gchar* name;
	Dimensions dimensions;
	guint32 size;
	gchar* mime_type;
	gchar* extension;
};

struct _ParamSpecPhotoPreview {
	GParamSpec parent_instance;
};

struct _MediaMetadata {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MediaMetadataPrivate * priv;
};

struct _MediaMetadataClass {
	GTypeClass parent_class;
	void (*finalize) (MediaMetadata *self);
	void (*read_from_file) (MediaMetadata* self, GFile* file, GError** error);
	MetadataDateTime* (*get_creation_date_time) (MediaMetadata* self);
	gchar* (*get_title) (MediaMetadata* self);
	gchar* (*get_comment) (MediaMetadata* self);
};

struct _PhotoMetadata {
	MediaMetadata parent_instance;
	PhotoMetadataPrivate * priv;
};

struct _PhotoMetadataClass {
	MediaMetadataClass parent_class;
};

struct _PhotoMetadataPrivate {
	GExiv2Metadata* exiv2;
	ExifData* exif;
	gchar* source_name;
	gchar* metadata_hash;
	gchar* thumbnail_md5;
};

typedef enum  {
	PHOTO_METADATA_SET_OPTION_ALL_DOMAINS,
	PHOTO_METADATA_SET_OPTION_ONLY_IF_DOMAIN_PRESENT,
	PHOTO_METADATA_SET_OPTION_AT_LEAST_DEFAULT_DOMAIN
} PhotoMetadataSetOption;

typedef enum  {
	PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL = 1 << 0,
	PREPARE_INPUT_TEXT_OPTIONS_VALIDATE = 1 << 1,
	PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL = 1 << 2,
	PREPARE_INPUT_TEXT_OPTIONS_STRIP = 1 << 3,
	PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF = 1 << 4,
	PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE = 1 << 5,
	PREPARE_INPUT_TEXT_OPTIONS_DEFAULT = ((((PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL | PREPARE_INPUT_TEXT_OPTIONS_VALIDATE) | PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL) | PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF) | PREPARE_INPUT_TEXT_OPTIONS_STRIP) | PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE
} PrepareInputTextOptions;

typedef void (*PhotoMetadataSetGenericValue) (const gchar* tag, void* user_data);
struct _Block1Data {
	int _ref_count_;
	PhotoMetadata* self;
	gchar* value;
};

struct _Block2Data {
	int _ref_count_;
	PhotoMetadata* self;
	GeeCollection* values;
};

struct _Block3Data {
	int _ref_count_;
	PhotoMetadata* self;
	glong value;
};

struct _MetadataRational {
	gint numerator;
	gint denominator;
};

struct _Block4Data {
	int _ref_count_;
	PhotoMetadata* self;
	MetadataRational rational;
};

typedef enum  {
	METADATA_DATE_TIME_ERROR_INVALID_FORMAT,
	METADATA_DATE_TIME_ERROR_UNSUPPORTED_FORMAT
} MetadataDateTimeError;
#define METADATA_DATE_TIME_ERROR metadata_date_time_error_quark ()
struct _Block5Data {
	int _ref_count_;
	PhotoMetadata* self;
	MetadataDateTime* date_time;
};

struct _Block6Data {
	int _ref_count_;
	PhotoMetadata* self;
	gchar* comment;
};

typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

struct _PhotoMetadataInternalPhotoPreview {
	PhotoPreview parent_instance;
	PhotoMetadataInternalPhotoPreviewPrivate * priv;
	PhotoMetadata* owner;
	guint number;
};

struct _PhotoMetadataInternalPhotoPreviewClass {
	PhotoPreviewClass parent_class;
};


static gpointer keyword_transformer_parent_class = NULL;
static gpointer null_keyword_transformer_parent_class = NULL;
static gpointer acd_see_keyword_transformer_parent_class = NULL;
static gpointer hierarchical_keyword_field_parent_class = NULL;
static gpointer photo_preview_parent_class = NULL;
static gpointer photo_metadata_parent_class = NULL;
static gchar** photo_metadata_DATE_TIME_TAGS;
static gint photo_metadata_DATE_TIME_TAGS_length1;
static gchar** photo_metadata_DATE_TIME_TAGS = NULL;
static gint photo_metadata_DATE_TIME_TAGS_length1 = 0;
static gint _photo_metadata_DATE_TIME_TAGS_size_ = 0;
static gchar** photo_metadata_EXPOSURE_DATE_TIME_TAGS;
static gint photo_metadata_EXPOSURE_DATE_TIME_TAGS_length1;
static gchar** photo_metadata_EXPOSURE_DATE_TIME_TAGS = NULL;
static gint photo_metadata_EXPOSURE_DATE_TIME_TAGS_length1 = 0;
static gint _photo_metadata_EXPOSURE_DATE_TIME_TAGS_size_ = 0;
static gchar** photo_metadata_DIGITIZED_DATE_TIME_TAGS;
static gint photo_metadata_DIGITIZED_DATE_TIME_TAGS_length1;
static gchar** photo_metadata_DIGITIZED_DATE_TIME_TAGS = NULL;
static gint photo_metadata_DIGITIZED_DATE_TIME_TAGS_length1 = 0;
static gint _photo_metadata_DIGITIZED_DATE_TIME_TAGS_size_ = 0;
static gchar** photo_metadata_WIDTH_TAGS;
static gint photo_metadata_WIDTH_TAGS_length1;
static gchar** photo_metadata_WIDTH_TAGS = NULL;
static gint photo_metadata_WIDTH_TAGS_length1 = 0;
static gint _photo_metadata_WIDTH_TAGS_size_ = 0;
extern gchar** photo_metadata_HEIGHT_TAGS;
extern gint photo_metadata_HEIGHT_TAGS_length1;
gchar** photo_metadata_HEIGHT_TAGS = NULL;
gint photo_metadata_HEIGHT_TAGS_length1 = 0;
static gchar** photo_metadata_STANDARD_TITLE_TAGS;
static gint photo_metadata_STANDARD_TITLE_TAGS_length1;
static gchar** photo_metadata_STANDARD_TITLE_TAGS = NULL;
static gint photo_metadata_STANDARD_TITLE_TAGS_length1 = 0;
static gint _photo_metadata_STANDARD_TITLE_TAGS_size_ = 0;
static gchar** photo_metadata_COMMENT_TAGS;
static gint photo_metadata_COMMENT_TAGS_length1;
static gchar** photo_metadata_COMMENT_TAGS = NULL;
static gint photo_metadata_COMMENT_TAGS_length1 = 0;
static gint _photo_metadata_COMMENT_TAGS_size_ = 0;
static gchar** photo_metadata_KEYWORD_TAGS;
static gint photo_metadata_KEYWORD_TAGS_length1;
static gchar** photo_metadata_KEYWORD_TAGS = NULL;
static gint photo_metadata_KEYWORD_TAGS_length1 = 0;
static gint _photo_metadata_KEYWORD_TAGS_size_ = 0;
static HierarchicalKeywordField** photo_metadata_HIERARCHICAL_KEYWORD_TAGS;
static gint photo_metadata_HIERARCHICAL_KEYWORD_TAGS_length1;
static HierarchicalKeywordField** photo_metadata_HIERARCHICAL_KEYWORD_TAGS = NULL;
static gint photo_metadata_HIERARCHICAL_KEYWORD_TAGS_length1 = 0;
static gint _photo_metadata_HIERARCHICAL_KEYWORD_TAGS_size_ = 0;
static gchar** photo_metadata_ARTIST_TAGS;
static gint photo_metadata_ARTIST_TAGS_length1;
static gchar** photo_metadata_ARTIST_TAGS = NULL;
static gint photo_metadata_ARTIST_TAGS_length1 = 0;
static gint _photo_metadata_ARTIST_TAGS_size_ = 0;
static gchar** photo_metadata_RATING_TAGS;
static gint photo_metadata_RATING_TAGS_length1;
static gchar** photo_metadata_RATING_TAGS = NULL;
static gint photo_metadata_RATING_TAGS_length1 = 0;
static gint _photo_metadata_RATING_TAGS_size_ = 0;
static gpointer photo_metadata_internal_photo_preview_parent_class = NULL;

GType metadata_domain_get_type (void) G_GNUC_CONST;
gpointer keyword_transformer_ref (gpointer instance);
void keyword_transformer_unref (gpointer instance);
GParamSpec* param_spec_keyword_transformer (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
void value_set_keyword_transformer (GValue* value,
                                    gpointer v_object);
void value_take_keyword_transformer (GValue* value,
                                     gpointer v_object);
gpointer value_get_keyword_transformer (const GValue* value);
GType keyword_transformer_get_type (void) G_GNUC_CONST;
GeeList* keyword_transformer_transform (KeywordTransformer* self,
                                        const gchar* input,
                                        GError** error);
static GeeList* keyword_transformer_real_transform (KeywordTransformer* self,
                                             const gchar* input,
                                             GError** error);
KeywordTransformer* keyword_transformer_construct (GType object_type);
static void keyword_transformer_finalize (KeywordTransformer * obj);
GType null_keyword_transformer_get_type (void) G_GNUC_CONST;
static GeeList* null_keyword_transformer_real_transform (KeywordTransformer* base,
                                                  const gchar* input,
                                                  GError** error);
NullKeywordTransformer* null_keyword_transformer_new (void);
NullKeywordTransformer* null_keyword_transformer_construct (GType object_type);
GType acd_see_keyword_transformer_get_type (void) G_GNUC_CONST;
#define ACD_SEE_KEYWORD_TRANSFORMER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ACD_SEE_KEYWORD_TRANSFORMER, ACDSeeKeywordTransformerPrivate))
ACDSeeKeywordTransformer* acd_see_keyword_transformer_new (void);
ACDSeeKeywordTransformer* acd_see_keyword_transformer_construct (GType object_type);
static void acd_see_keyword_transformer_on_start (ACDSeeKeywordTransformer* self,
                                           GMarkupParseContext* ctx,
                                           const gchar* name,
                                           gchar** attribute_names,
                                           gchar** attribute_values,
                                           GError** error);
static void _acd_see_keyword_transformer_on_start_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                                              const gchar* element_name,
                                                                              gchar** attribute_names,
                                                                              gchar** attribute_values,
                                                                              gpointer self,
                                                                              GError** error);
static void acd_see_keyword_transformer_on_end (ACDSeeKeywordTransformer* self,
                                         GMarkupParseContext* ctx,
                                         const gchar* name,
                                         GError** error);
static void _acd_see_keyword_transformer_on_end_gmarkup_parser_end_element_func (GMarkupParseContext* context,
                                                                          const gchar* element_name,
                                                                          gpointer self,
                                                                          GError** error);
static void acd_see_keyword_transformer_on_text (ACDSeeKeywordTransformer* self,
                                          GMarkupParseContext* ctx,
                                          const gchar* text,
                                          GError** error);
static void _acd_see_keyword_transformer_on_text_gmarkup_parser_text_func (GMarkupParseContext* context,
                                                                    const gchar* text,
                                                                    gsize text_len,
                                                                    gpointer self,
                                                                    GError** error);
static void acd_see_keyword_transformer_on_error (ACDSeeKeywordTransformer* self,
                                           GMarkupParseContext* ctx,
                                           GError* _error_);
static void _acd_see_keyword_transformer_on_error_gmarkup_parser_error_func (GMarkupParseContext* context,
                                                                      GError* _error_,
                                                                      gpointer self);
static GeeList* acd_see_keyword_transformer_real_transform (KeywordTransformer* base,
                                                     const gchar* input,
                                                     GError** error);
static void acd_see_keyword_transformer_finalize (KeywordTransformer * obj);
gpointer hierarchical_keyword_field_ref (gpointer instance);
void hierarchical_keyword_field_unref (gpointer instance);
GParamSpec* param_spec_hierarchical_keyword_field (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
void value_set_hierarchical_keyword_field (GValue* value,
                                           gpointer v_object);
void value_take_hierarchical_keyword_field (GValue* value,
                                            gpointer v_object);
gpointer value_get_hierarchical_keyword_field (const GValue* value);
GType hierarchical_keyword_field_get_type (void) G_GNUC_CONST;
HierarchicalKeywordField* hierarchical_keyword_field_new (const gchar* field_name,
                                                          const gchar* path_separator,
                                                          gboolean wants_leading_separator,
                                                          gboolean is_writeable,
                                                          KeywordTransformer* transformer);
HierarchicalKeywordField* hierarchical_keyword_field_construct (GType object_type,
                                                                const gchar* field_name,
                                                                const gchar* path_separator,
                                                                gboolean wants_leading_separator,
                                                                gboolean is_writeable,
                                                                KeywordTransformer* transformer);
static void hierarchical_keyword_field_finalize (HierarchicalKeywordField * obj);
gpointer photo_preview_ref (gpointer instance);
void photo_preview_unref (gpointer instance);
GParamSpec* param_spec_photo_preview (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
void value_set_photo_preview (GValue* value,
                              gpointer v_object);
void value_take_photo_preview (GValue* value,
                               gpointer v_object);
gpointer value_get_photo_preview (const GValue* value);
GType photo_preview_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
#define PHOTO_PREVIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PHOTO_PREVIEW, PhotoPreviewPrivate))
PhotoPreview* photo_preview_construct (GType object_type,
                                       const gchar* name,
                                       Dimensions* dimensions,
                                       guint32 size,
                                       const gchar* mime_type,
                                       const gchar* extension);
gchar* photo_preview_get_name (PhotoPreview* self);
void photo_preview_get_pixel_dimensions (PhotoPreview* self,
                                         Dimensions* result);
guint32 photo_preview_get_size (PhotoPreview* self);
gchar* photo_preview_get_mime_type (PhotoPreview* self);
gchar* photo_preview_get_extension (PhotoPreview* self);
GBytes* photo_preview_flatten (PhotoPreview* self,
                               GError** error);
static GBytes* photo_preview_real_flatten (PhotoPreview* self,
                                    GError** error);
GdkPixbuf* photo_preview_get_pixbuf (PhotoPreview* self,
                                     GError** error);
static GdkPixbuf* photo_preview_real_get_pixbuf (PhotoPreview* self,
                                          GError** error);
static void photo_preview_finalize (PhotoPreview * obj);
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_media_metadata (GValue* value,
                               gpointer v_object);
void value_take_media_metadata (GValue* value,
                                gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
gpointer metadata_date_time_ref (gpointer instance);
void metadata_date_time_unref (gpointer instance);
GParamSpec* param_spec_metadata_date_time (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void value_set_metadata_date_time (GValue* value,
                                   gpointer v_object);
void value_take_metadata_date_time (GValue* value,
                                    gpointer v_object);
gpointer value_get_metadata_date_time (const GValue* value);
GType metadata_date_time_get_type (void) G_GNUC_CONST;
GType photo_metadata_get_type (void) G_GNUC_CONST;
#define PHOTO_METADATA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PHOTO_METADATA, PhotoMetadataPrivate))
GType photo_metadata_set_option_get_type (void) G_GNUC_CONST;
GType prepare_input_text_options_get_type (void) G_GNUC_CONST;
#define PHOTO_METADATA_PREPARE_STRING_OPTIONS (((((PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL | PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL) | PREPARE_INPUT_TEXT_OPTIONS_STRIP) | PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF) | PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE) | PREPARE_INPUT_TEXT_OPTIONS_VALIDATE)
#define PHOTO_METADATA_IPHOTO_TITLE_TAG "Iptc.Application2.ObjectName"
PhotoMetadata* photo_metadata_new (void);
PhotoMetadata* photo_metadata_construct (GType object_type);
MediaMetadata* media_metadata_construct (GType object_type);
static void photo_metadata_real_read_from_file (MediaMetadata* base,
                                         GFile* file,
                                         GError** error);
void photo_metadata_write_to_file (PhotoMetadata* self,
                                   GFile* file,
                                   GError** error);
void photo_metadata_read_from_buffer (PhotoMetadata* self,
                                      guint8* buffer,
                                      int buffer_length1,
                                      gint length,
                                      GError** error);
void photo_metadata_read_from_app1_segment (PhotoMetadata* self,
                                            GBytes* buffer,
                                            GError** error);
MetadataDomain photo_metadata_get_tag_domain (const gchar* tag);
gboolean photo_metadata_has_domain (PhotoMetadata* self,
                                    MetadataDomain domain);
gboolean photo_metadata_has_exif (PhotoMetadata* self);
gboolean photo_metadata_has_xmp (PhotoMetadata* self);
gboolean photo_metadata_has_iptc (PhotoMetadata* self);
gboolean photo_metadata_can_write_to_domain (PhotoMetadata* self,
                                             MetadataDomain domain);
gboolean photo_metadata_can_write_exif (PhotoMetadata* self);
gboolean photo_metadata_can_write_xmp (PhotoMetadata* self);
gboolean photo_metadata_can_write_iptc (PhotoMetadata* self);
gboolean photo_metadata_has_tag (PhotoMetadata* self,
                                 const gchar* tag);
static GeeSet* photo_metadata_create_string_set (PhotoMetadata* self,
                                          GCompareDataFunc compare_func,
                                          void* compare_func_target,
                                          GDestroyNotify compare_func_target_destroy_notify);
GeeCollection* photo_metadata_get_tags (PhotoMetadata* self,
                                        MetadataDomain domain,
                                        GCompareDataFunc compare_func,
                                        void* compare_func_target,
                                        GDestroyNotify compare_func_target_destroy_notify);
GeeCollection* photo_metadata_get_all_tags (PhotoMetadata* self,
                                            GCompareDataFunc compare_func,
                                            void* compare_func_target,
                                            GDestroyNotify compare_func_target_destroy_notify);
gchar* photo_metadata_get_tag_label (PhotoMetadata* self,
                                     const gchar* tag);
gchar* photo_metadata_get_tag_description (PhotoMetadata* self,
                                           const gchar* tag);
gchar* photo_metadata_get_string (PhotoMetadata* self,
                                  const gchar* tag,
                                  PrepareInputTextOptions options);
gchar* prepare_input_text (const gchar* text,
                           PrepareInputTextOptions options,
                           gint dest_length);
#define DEFAULT_USER_TEXT_INPUT_LENGTH 1024
gchar* photo_metadata_get_string_interpreted (PhotoMetadata* self,
                                              const gchar* tag,
                                              PrepareInputTextOptions options);
gchar* photo_metadata_get_first_string (PhotoMetadata* self,
                                        gchar** tags,
                                        int tags_length1);
gchar* photo_metadata_get_first_string_interpreted (PhotoMetadata* self,
                                                    gchar** tags,
                                                    int tags_length1);
GeeList* photo_metadata_get_string_multiple (PhotoMetadata* self,
                                             const gchar* tag);
GeeList* photo_metadata_get_first_string_multiple (PhotoMetadata* self,
                                                   gchar** tags,
                                                   int tags_length1);
void photo_metadata_set_string (PhotoMetadata* self,
                                const gchar* tag,
                                const gchar* value,
                                PrepareInputTextOptions options);
static void photo_metadata_set_all_generic (PhotoMetadata* self,
                                     gchar** tags,
                                     int tags_length1,
                                     PhotoMetadataSetOption option,
                                     PhotoMetadataSetGenericValue setter,
                                     void* setter_target);
void photo_metadata_set_all_string (PhotoMetadata* self,
                                    gchar** tags,
                                    int tags_length1,
                                    const gchar* value,
                                    PhotoMetadataSetOption option);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda5_ (Block1Data* _data1_,
                 const gchar* tag);
static void ___lambda5__photo_metadata_set_generic_value (const gchar* tag,
                                                   gpointer self);
void photo_metadata_set_string_multiple (PhotoMetadata* self,
                                         const gchar* tag,
                                         GeeCollection* collection);
static void _vala_array_add48 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add49 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
void photo_metadata_set_all_string_multiple (PhotoMetadata* self,
                                             gchar** tags,
                                             int tags_length1,
                                             GeeCollection* values,
                                             PhotoMetadataSetOption option);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda6_ (Block2Data* _data2_,
                 const gchar* tag);
static void ___lambda6__photo_metadata_set_generic_value (const gchar* tag,
                                                   gpointer self);
gboolean photo_metadata_get_long (PhotoMetadata* self,
                                  const gchar* tag,
                                  glong* value);
gboolean photo_metadata_get_first_long (PhotoMetadata* self,
                                        gchar** tags,
                                        int tags_length1,
                                        glong* value);
void photo_metadata_set_long (PhotoMetadata* self,
                              const gchar* tag,
                              glong value);
void photo_metadata_set_all_long (PhotoMetadata* self,
                                  gchar** tags,
                                  int tags_length1,
                                  glong value,
                                  PhotoMetadataSetOption option);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda7_ (Block3Data* _data3_,
                 const gchar* tag);
static void ___lambda7__photo_metadata_set_generic_value (const gchar* tag,
                                                   gpointer self);
GType metadata_rational_get_type (void) G_GNUC_CONST;
MetadataRational* metadata_rational_dup (const MetadataRational* self);
void metadata_rational_free (MetadataRational* self);
gboolean photo_metadata_get_rational (PhotoMetadata* self,
                                      const gchar* tag,
                                      MetadataRational* rational);
void metadata_rational_init (MetadataRational *self,
                             gint numerator,
                             gint denominator);
gboolean photo_metadata_get_first_rational (PhotoMetadata* self,
                                            gchar** tags,
                                            int tags_length1,
                                            MetadataRational* rational);
void photo_metadata_set_rational (PhotoMetadata* self,
                                  const gchar* tag,
                                  MetadataRational* rational);
gchar* metadata_rational_to_string (MetadataRational *self);
void photo_metadata_set_all_rational (PhotoMetadata* self,
                                      gchar** tags,
                                      int tags_length1,
                                      MetadataRational* rational,
                                      PhotoMetadataSetOption option);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda8_ (Block4Data* _data4_,
                 const gchar* tag);
static void ___lambda8__photo_metadata_set_generic_value (const gchar* tag,
                                                   gpointer self);
MetadataDateTime* photo_metadata_get_date_time (PhotoMetadata* self,
                                                const gchar* tag);
GQuark metadata_date_time_error_quark (void);
MetadataDateTime* metadata_date_time_new_from_xmp (const gchar* label,
                                                   GError** error);
MetadataDateTime* metadata_date_time_construct_from_xmp (GType object_type,
                                                         const gchar* label,
                                                         GError** error);
MetadataDateTime* metadata_date_time_new_from_exif (const gchar* label,
                                                    GError** error);
MetadataDateTime* metadata_date_time_construct_from_exif (GType object_type,
                                                          const gchar* label,
                                                          GError** error);
MetadataDateTime* photo_metadata_get_first_date_time (PhotoMetadata* self,
                                                      gchar** tags,
                                                      int tags_length1);
void photo_metadata_set_date_time (PhotoMetadata* self,
                                   const gchar* tag,
                                   MetadataDateTime* date_time);
gchar* metadata_date_time_get_exif_label (MetadataDateTime* self);
gchar* metadata_date_time_get_xmp_label (MetadataDateTime* self);
const gchar* metadata_domain_to_string (MetadataDomain self);
void photo_metadata_set_all_date_time (PhotoMetadata* self,
                                       gchar** tags,
                                       int tags_length1,
                                       MetadataDateTime* date_time,
                                       PhotoMetadataSetOption option);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda9_ (Block5Data* _data5_,
                 const gchar* tag);
static void ___lambda9__photo_metadata_set_generic_value (const gchar* tag,
                                                   gpointer self);
gchar* photo_metadata_exif_hash (PhotoMetadata* self);
gchar* photo_metadata_thumbnail_hash (PhotoMetadata* self);
guint photo_metadata_get_preview_count (PhotoMetadata* self);
PhotoPreview* photo_metadata_get_preview (PhotoMetadata* self,
                                          guint number);
static PhotoMetadataInternalPhotoPreview* photo_metadata_internal_photo_preview_new (PhotoMetadata* owner,
                                                                              const gchar* name,
                                                                              guint number,
                                                                              GExiv2PreviewProperties* props);
static PhotoMetadataInternalPhotoPreview* photo_metadata_internal_photo_preview_construct (GType object_type,
                                                                                    PhotoMetadata* owner,
                                                                                    const gchar* name,
                                                                                    guint number,
                                                                                    GExiv2PreviewProperties* props);
static GType photo_metadata_internal_photo_preview_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
void photo_metadata_remove_exif_thumbnail (PhotoMetadata* self);
void photo_metadata_remove_tag (PhotoMetadata* self,
                                const gchar* tag);
void photo_metadata_remove_tags (PhotoMetadata* self,
                                 gchar** tags,
                                 int tags_length1);
void photo_metadata_clear_domain (PhotoMetadata* self,
                                  MetadataDomain domain);
void photo_metadata_clear (PhotoMetadata* self);
MetadataDateTime* photo_metadata_get_modification_date_time (PhotoMetadata* self);
void photo_metadata_set_modification_date_time (PhotoMetadata* self,
                                                MetadataDateTime* date_time,
                                                PhotoMetadataSetOption option);
MetadataDateTime* photo_metadata_get_exposure_date_time (PhotoMetadata* self);
void photo_metadata_set_exposure_date_time (PhotoMetadata* self,
                                            MetadataDateTime* date_time,
                                            PhotoMetadataSetOption option);
MetadataDateTime* photo_metadata_get_digitized_date_time (PhotoMetadata* self);
void photo_metadata_set_digitized_date_time (PhotoMetadata* self,
                                             MetadataDateTime* date_time,
                                             PhotoMetadataSetOption option);
static MetadataDateTime* photo_metadata_real_get_creation_date_time (MediaMetadata* base);
Dimensions* photo_metadata_get_pixel_dimensions (PhotoMetadata* self);
void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
void photo_metadata_set_pixel_dimensions (PhotoMetadata* self,
                                          Dimensions* dim,
                                          PhotoMetadataSetOption option);
static gchar* photo_metadata_real_get_title (MediaMetadata* base);
gboolean is_string_empty (const gchar* s);
void photo_metadata_set_title (PhotoMetadata* self,
                               const gchar* title,
                               PhotoMetadataSetOption option);
static gchar* photo_metadata_real_get_comment (MediaMetadata* base);
void photo_metadata_set_comment (PhotoMetadata* self,
                                 const gchar* comment,
                                 PhotoMetadataSetOption option);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void ___lambda10_ (Block6Data* _data6_,
                   const gchar* tag);
static void ____lambda10__photo_metadata_set_generic_value (const gchar* tag,
                                                     gpointer self);
GeeSet* photo_metadata_get_keywords (PhotoMetadata* self,
                                     GCompareDataFunc compare_func,
                                     void* compare_func_target,
                                     GDestroyNotify compare_func_target_destroy_notify);
gchar* hierarchical_tag_utilities_make_flat_tag_safe (const gchar* in_tag);
gpointer hierarchical_tag_index_ref (gpointer instance);
void hierarchical_tag_index_unref (gpointer instance);
GParamSpec* param_spec_hierarchical_tag_index (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
void value_set_hierarchical_tag_index (GValue* value,
                                       gpointer v_object);
void value_take_hierarchical_tag_index (GValue* value,
                                        gpointer v_object);
gpointer value_get_hierarchical_tag_index (const GValue* value);
GType hierarchical_tag_index_get_type (void) G_GNUC_CONST;
static void photo_metadata_internal_set_hierarchical_keywords (PhotoMetadata* self,
                                                        HierarchicalTagIndex* index);
GeeCollection* hierarchical_tag_index_get_all_paths (HierarchicalTagIndex* self);
#define TAG_PATH_SEPARATOR_STRING "/"
void photo_metadata_set_keywords (PhotoMetadata* self,
                                  GeeCollection* keywords,
                                  PhotoMetadataSetOption option);
HierarchicalTagIndex* hierarchical_tag_index_new (void);
HierarchicalTagIndex* hierarchical_tag_index_construct (GType object_type);
GeeList* hierarchical_tag_utilities_enumerate_path_components (const gchar* in_path);
void hierarchical_tag_index_add_path (HierarchicalTagIndex* self,
                                      const gchar* tag,
                                      const gchar* path);
GeeCollection* hierarchical_tag_index_get_all_tags (HierarchicalTagIndex* self);
gboolean photo_metadata_has_hierarchical_keywords (PhotoMetadata* self);
GeeSet* photo_metadata_get_hierarchical_keywords (PhotoMetadata* self);
gchar* hierarchical_tag_utilities_canonicalize (const gchar* in_tag,
                                                const gchar* foreign_separator);
gboolean photo_metadata_has_orientation (PhotoMetadata* self);
GType orientation_get_type (void) G_GNUC_CONST;
Orientation photo_metadata_get_orientation (PhotoMetadata* self);
void photo_metadata_set_orientation (PhotoMetadata* self,
                                     Orientation orientation);
gboolean photo_metadata_get_gps (PhotoMetadata* self,
                                 gdouble* longitude,
                                 gchar* * long_ref,
                                 gdouble* latitude,
                                 gchar* * lat_ref,
                                 gdouble* altitude);
gboolean photo_metadata_get_exposure (PhotoMetadata* self,
                                      MetadataRational* exposure);
gchar* photo_metadata_get_exposure_string (PhotoMetadata* self);
gboolean metadata_rational_is_valid (MetadataRational *self);
gboolean photo_metadata_get_iso (PhotoMetadata* self,
                                 glong* iso);
gchar* photo_metadata_get_iso_string (PhotoMetadata* self);
gboolean photo_metadata_get_aperture (PhotoMetadata* self,
                                      MetadataRational* aperture);
gchar* photo_metadata_get_aperture_string (PhotoMetadata* self,
                                           gboolean pango_formatted);
gchar* photo_metadata_get_camera_make (PhotoMetadata* self);
gchar* photo_metadata_get_camera_model (PhotoMetadata* self);
gboolean photo_metadata_get_flash (PhotoMetadata* self,
                                   glong* flash);
gchar* photo_metadata_get_flash_string (PhotoMetadata* self);
gboolean photo_metadata_get_focal_length (PhotoMetadata* self,
                                          MetadataRational* focal_length);
gchar* photo_metadata_get_focal_length_string (PhotoMetadata* self);
gchar* photo_metadata_get_artist (PhotoMetadata* self);
gchar* photo_metadata_get_copyright (PhotoMetadata* self);
gchar* photo_metadata_get_software (PhotoMetadata* self);
void photo_metadata_set_software (PhotoMetadata* self,
                                  const gchar* software,
                                  const gchar* version);
void photo_metadata_remove_software (PhotoMetadata* self);
gchar* photo_metadata_get_exposure_bias (PhotoMetadata* self);
GType rating_get_type (void) G_GNUC_CONST;
Rating photo_metadata_get_rating (PhotoMetadata* self);
Rating rating_unserialize (gint value);
void photo_metadata_set_rating (PhotoMetadata* self,
                                Rating rating);
gint rating_serialize (Rating self);
static GBytes* photo_metadata_internal_photo_preview_real_flatten (PhotoPreview* base,
                                                            GError** error);
static void photo_metadata_internal_photo_preview_finalize (PhotoPreview * obj);
static void photo_metadata_finalize (MediaMetadata * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

extern const gint RESOURCES_rating_thresholds[6];

GType
metadata_domain_get_type (void)
{
	static volatile gsize metadata_domain_type_id__volatile = 0;
	if (g_once_init_enter (&metadata_domain_type_id__volatile)) {
		static const GEnumValue values[] = {{METADATA_DOMAIN_UNKNOWN, "METADATA_DOMAIN_UNKNOWN", "unknown"}, {METADATA_DOMAIN_EXIF, "METADATA_DOMAIN_EXIF", "exif"}, {METADATA_DOMAIN_XMP, "METADATA_DOMAIN_XMP", "xmp"}, {METADATA_DOMAIN_IPTC, "METADATA_DOMAIN_IPTC", "iptc"}, {0, NULL, NULL}};
		GType metadata_domain_type_id;
		metadata_domain_type_id = g_enum_register_static ("MetadataDomain", values);
		g_once_init_leave (&metadata_domain_type_id__volatile, metadata_domain_type_id);
	}
	return metadata_domain_type_id__volatile;
}


static GeeList*
keyword_transformer_real_transform (KeywordTransformer* self,
                                    const gchar* input,
                                    GError** error)
{
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_critical ("Type `%s' does not implement abstract method `keyword_transformer_transform'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 1021 "PhotoMetadata.c"
}


GeeList*
keyword_transformer_transform (KeywordTransformer* self,
                               const gchar* input,
                               GError** error)
{
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_KEYWORD_TRANSFORMER (self), NULL);
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return KEYWORD_TRANSFORMER_GET_CLASS (self)->transform (self, input, error);
#line 1034 "PhotoMetadata.c"
}


KeywordTransformer*
keyword_transformer_construct (GType object_type)
{
	KeywordTransformer* self = NULL;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = (KeywordTransformer*) g_type_create_instance (object_type);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self;
#line 1046 "PhotoMetadata.c"
}


static void
value_keyword_transformer_init (GValue* value)
{
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	value->data[0].v_pointer = NULL;
#line 1055 "PhotoMetadata.c"
}


static void
value_keyword_transformer_free_value (GValue* value)
{
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (value->data[0].v_pointer) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		keyword_transformer_unref (value->data[0].v_pointer);
#line 1066 "PhotoMetadata.c"
	}
}


static void
value_keyword_transformer_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (src_value->data[0].v_pointer) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		dest_value->data[0].v_pointer = keyword_transformer_ref (src_value->data[0].v_pointer);
#line 1079 "PhotoMetadata.c"
	} else {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1083 "PhotoMetadata.c"
	}
}


static gpointer
value_keyword_transformer_peek_pointer (const GValue* value)
{
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return value->data[0].v_pointer;
#line 1093 "PhotoMetadata.c"
}


static gchar*
value_keyword_transformer_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (collect_values[0].v_pointer) {
#line 1105 "PhotoMetadata.c"
		KeywordTransformer * object;
		object = collect_values[0].v_pointer;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (object->parent_instance.g_class == NULL) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1112 "PhotoMetadata.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1116 "PhotoMetadata.c"
		}
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = keyword_transformer_ref (object);
#line 1120 "PhotoMetadata.c"
	} else {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 1124 "PhotoMetadata.c"
	}
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 1128 "PhotoMetadata.c"
}


static gchar*
value_keyword_transformer_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	KeywordTransformer ** object_p;
	object_p = collect_values[0].v_pointer;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!object_p) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1144 "PhotoMetadata.c"
	}
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!value->data[0].v_pointer) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*object_p = NULL;
#line 1150 "PhotoMetadata.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*object_p = value->data[0].v_pointer;
#line 1154 "PhotoMetadata.c"
	} else {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*object_p = keyword_transformer_ref (value->data[0].v_pointer);
#line 1158 "PhotoMetadata.c"
	}
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 1162 "PhotoMetadata.c"
}


GParamSpec*
param_spec_keyword_transformer (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	ParamSpecKeywordTransformer* spec;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_KEYWORD_TRANSFORMER), NULL);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return G_PARAM_SPEC (spec);
#line 1182 "PhotoMetadata.c"
}


gpointer
value_get_keyword_transformer (const GValue* value)
{
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_KEYWORD_TRANSFORMER), NULL);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return value->data[0].v_pointer;
#line 1193 "PhotoMetadata.c"
}


void
value_set_keyword_transformer (GValue* value,
                               gpointer v_object)
{
	KeywordTransformer * old;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_KEYWORD_TRANSFORMER));
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	old = value->data[0].v_pointer;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (v_object) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_KEYWORD_TRANSFORMER));
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		keyword_transformer_ref (value->data[0].v_pointer);
#line 1216 "PhotoMetadata.c"
	} else {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 1220 "PhotoMetadata.c"
	}
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (old) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		keyword_transformer_unref (old);
#line 1226 "PhotoMetadata.c"
	}
}


void
value_take_keyword_transformer (GValue* value,
                                gpointer v_object)
{
	KeywordTransformer * old;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_KEYWORD_TRANSFORMER));
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	old = value->data[0].v_pointer;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (v_object) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_KEYWORD_TRANSFORMER));
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 1248 "PhotoMetadata.c"
	} else {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 1252 "PhotoMetadata.c"
	}
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (old) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		keyword_transformer_unref (old);
#line 1258 "PhotoMetadata.c"
	}
}


static void
keyword_transformer_class_init (KeywordTransformerClass * klass)
{
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	keyword_transformer_parent_class = g_type_class_peek_parent (klass);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((KeywordTransformerClass *) klass)->finalize = keyword_transformer_finalize;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((KeywordTransformerClass *) klass)->transform = (GeeList* (*) (KeywordTransformer *, const gchar*, GError**)) keyword_transformer_real_transform;
#line 1272 "PhotoMetadata.c"
}


static void
keyword_transformer_instance_init (KeywordTransformer * self)
{
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->ref_count = 1;
#line 1281 "PhotoMetadata.c"
}


static void
keyword_transformer_finalize (KeywordTransformer * obj)
{
	KeywordTransformer * self;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KEYWORD_TRANSFORMER, KeywordTransformer);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_signal_handlers_destroy (self);
#line 1293 "PhotoMetadata.c"
}


GType
keyword_transformer_get_type (void)
{
	static volatile gsize keyword_transformer_type_id__volatile = 0;
	if (g_once_init_enter (&keyword_transformer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_keyword_transformer_init, value_keyword_transformer_free_value, value_keyword_transformer_copy_value, value_keyword_transformer_peek_pointer, "p", value_keyword_transformer_collect_value, "p", value_keyword_transformer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (KeywordTransformerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keyword_transformer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeywordTransformer), 0, (GInstanceInitFunc) keyword_transformer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType keyword_transformer_type_id;
		keyword_transformer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "KeywordTransformer", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&keyword_transformer_type_id__volatile, keyword_transformer_type_id);
	}
	return keyword_transformer_type_id__volatile;
}


gpointer
keyword_transformer_ref (gpointer instance)
{
	KeywordTransformer * self;
	self = instance;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_atomic_int_inc (&self->ref_count);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return instance;
#line 1322 "PhotoMetadata.c"
}


void
keyword_transformer_unref (gpointer instance)
{
	KeywordTransformer * self;
	self = instance;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		KEYWORD_TRANSFORMER_GET_CLASS (self)->finalize (self);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1337 "PhotoMetadata.c"
	}
}


static GeeList*
null_keyword_transformer_real_transform (KeywordTransformer* base,
                                         const gchar* input,
                                         GError** error)
{
	NullKeywordTransformer * self;
	GeeList* result = NULL;
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp0_;
#line 36 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_NULL_KEYWORD_TRANSFORMER, NullKeywordTransformer);
#line 36 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (input != NULL, NULL);
#line 37 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 37 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_result_ = _tmp0_;
#line 38 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_result_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), input);
#line 40 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_result_, GEE_TYPE_LIST, GeeList);
#line 40 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 1365 "PhotoMetadata.c"
}


NullKeywordTransformer*
null_keyword_transformer_construct (GType object_type)
{
	NullKeywordTransformer* self = NULL;
#line 35 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = (NullKeywordTransformer*) keyword_transformer_construct (object_type);
#line 35 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self;
#line 1377 "PhotoMetadata.c"
}


NullKeywordTransformer*
null_keyword_transformer_new (void)
{
#line 35 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return null_keyword_transformer_construct (TYPE_NULL_KEYWORD_TRANSFORMER);
#line 1386 "PhotoMetadata.c"
}


static void
null_keyword_transformer_class_init (NullKeywordTransformerClass * klass)
{
#line 35 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	null_keyword_transformer_parent_class = g_type_class_peek_parent (klass);
#line 35 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((KeywordTransformerClass *) klass)->transform = (GeeList* (*) (KeywordTransformer *, const gchar*, GError**)) null_keyword_transformer_real_transform;
#line 1397 "PhotoMetadata.c"
}


static void
null_keyword_transformer_instance_init (NullKeywordTransformer * self)
{
}


GType
null_keyword_transformer_get_type (void)
{
	static volatile gsize null_keyword_transformer_type_id__volatile = 0;
	if (g_once_init_enter (&null_keyword_transformer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NullKeywordTransformerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) null_keyword_transformer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NullKeywordTransformer), 0, (GInstanceInitFunc) null_keyword_transformer_instance_init, NULL };
		GType null_keyword_transformer_type_id;
		null_keyword_transformer_type_id = g_type_register_static (TYPE_KEYWORD_TRANSFORMER, "NullKeywordTransformer", &g_define_type_info, 0);
		g_once_init_leave (&null_keyword_transformer_type_id__volatile, null_keyword_transformer_type_id);
	}
	return null_keyword_transformer_type_id__volatile;
}


static void
_acd_see_keyword_transformer_on_start_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                                         const gchar* element_name,
                                                                         gchar** attribute_names,
                                                                         gchar** attribute_values,
                                                                         gpointer self,
                                                                         GError** error)
{
#line 64 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	acd_see_keyword_transformer_on_start ((ACDSeeKeywordTransformer*) self, context, element_name, attribute_names, attribute_values, error);
#line 1431 "PhotoMetadata.c"
}


static void
_acd_see_keyword_transformer_on_end_gmarkup_parser_end_element_func (GMarkupParseContext* context,
                                                                     const gchar* element_name,
                                                                     gpointer self,
                                                                     GError** error)
{
#line 65 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	acd_see_keyword_transformer_on_end ((ACDSeeKeywordTransformer*) self, context, element_name, error);
#line 1443 "PhotoMetadata.c"
}


static void
_acd_see_keyword_transformer_on_text_gmarkup_parser_text_func (GMarkupParseContext* context,
                                                               const gchar* text,
                                                               gsize text_len,
                                                               gpointer self,
                                                               GError** error)
{
#line 66 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	acd_see_keyword_transformer_on_text ((ACDSeeKeywordTransformer*) self, context, text, error);
#line 1456 "PhotoMetadata.c"
}


static void
_acd_see_keyword_transformer_on_error_gmarkup_parser_error_func (GMarkupParseContext* context,
                                                                 GError* _error_,
                                                                 gpointer self)
{
#line 67 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	acd_see_keyword_transformer_on_error ((ACDSeeKeywordTransformer*) self, context, _error_);
#line 1467 "PhotoMetadata.c"
}


ACDSeeKeywordTransformer*
acd_see_keyword_transformer_construct (GType object_type)
{
	ACDSeeKeywordTransformer* self = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayQueue* _tmp1_;
#line 62 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = (ACDSeeKeywordTransformer*) keyword_transformer_construct (object_type);
#line 63 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	memset (&self->priv->parser, 0, sizeof (GMarkupParser));
#line 64 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->parser.start_element = _acd_see_keyword_transformer_on_start_gmarkup_parser_start_element_func;
#line 65 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->parser.end_element = _acd_see_keyword_transformer_on_end_gmarkup_parser_end_element_func;
#line 66 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->parser.text = _acd_see_keyword_transformer_on_text_gmarkup_parser_text_func;
#line 67 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->parser.error = _acd_see_keyword_transformer_on_error_gmarkup_parser_error_func;
#line 68 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 68 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (self->priv->result);
#line 68 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->result = _tmp0_;
#line 69 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = gee_array_queue_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 69 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (self->priv->stack);
#line 69 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->stack = _tmp1_;
#line 62 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self;
#line 1503 "PhotoMetadata.c"
}


ACDSeeKeywordTransformer*
acd_see_keyword_transformer_new (void)
{
#line 62 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return acd_see_keyword_transformer_construct (TYPE_ACD_SEE_KEYWORD_TRANSFORMER);
#line 1512 "PhotoMetadata.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 77 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self ? g_object_ref (self) : NULL;
#line 1521 "PhotoMetadata.c"
}


static GeeList*
acd_see_keyword_transformer_real_transform (KeywordTransformer* base,
                                            const gchar* input,
                                            GError** error)
{
	ACDSeeKeywordTransformer * self;
	GeeList* result = NULL;
	GMarkupParseContext* ctx = NULL;
	GMarkupParser _tmp0_;
	GMarkupParseContext* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	GeeList* _tmp5_;
	GError * _inner_error_ = NULL;
#line 72 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ACD_SEE_KEYWORD_TRANSFORMER, ACDSeeKeywordTransformer);
#line 72 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (input != NULL, NULL);
#line 73 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->parser;
#line 73 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_markup_parse_context_new (&_tmp0_, 0, self, NULL);
#line 73 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	ctx = _tmp1_;
#line 75 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = strlen (input);
#line 75 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = _tmp2_;
#line 75 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_markup_parse_context_parse (ctx, input, (gssize) _tmp3_, &_inner_error_);
#line 75 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 75 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 75 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_markup_parse_context_unref0 (ctx);
#line 75 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return NULL;
#line 1564 "PhotoMetadata.c"
	}
#line 77 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = self->priv->result;
#line 77 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_LIST, GeeList));
#line 77 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp5_;
#line 77 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_markup_parse_context_unref0 (ctx);
#line 77 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 1576 "PhotoMetadata.c"
}


static void
acd_see_keyword_transformer_on_start (ACDSeeKeywordTransformer* self,
                                      GMarkupParseContext* ctx,
                                      const gchar* name,
                                      gchar** attribute_names,
                                      gchar** attribute_values,
                                      GError** error)
{
	GError * _inner_error_ = NULL;
#line 80 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_ACD_SEE_KEYWORD_TRANSFORMER (self));
#line 80 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (ctx != NULL);
#line 80 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (name != NULL);
#line 88 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->assigned = FALSE;
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_strcmp0 (name, "Categories") == 0) {
#line 90 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 1601 "PhotoMetadata.c"
	}
#line 93 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_strcmp0 (name, "Category") != 0) {
#line 94 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 1607 "PhotoMetadata.c"
	}
#line 97 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_markup_collect_attributes (name, attribute_names, attribute_values, &_inner_error_, G_MARKUP_COLLECT_BOOLEAN, "Assigned", &self->priv->assigned, G_MARKUP_COLLECT_INVALID);
#line 97 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 97 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (_inner_error_->domain == G_MARKUP_ERROR) {
#line 97 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			g_propagate_error (error, _inner_error_);
#line 97 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return;
#line 1619 "PhotoMetadata.c"
		} else {
#line 97 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 97 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			g_clear_error (&_inner_error_);
#line 97 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return;
#line 1627 "PhotoMetadata.c"
		}
	}
}


static void
acd_see_keyword_transformer_on_end (ACDSeeKeywordTransformer* self,
                                    GMarkupParseContext* ctx,
                                    const gchar* name,
                                    GError** error)
{
#line 104 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_ACD_SEE_KEYWORD_TRANSFORMER (self));
#line 104 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (ctx != NULL);
#line 104 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (name != NULL);
#line 106 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_strcmp0 (name, "Category") == 0) {
#line 1647 "PhotoMetadata.c"
		GeeArrayQueue* _tmp0_;
		gpointer _tmp1_;
		gchar* _tmp2_;
#line 107 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp0_ = self->priv->stack;
#line 107 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = gee_deque_poll_tail (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_DEQUE, GeeDeque));
#line 107 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = (gchar*) _tmp1_;
#line 107 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_tmp2_);
#line 1659 "PhotoMetadata.c"
	}
}


static void
acd_see_keyword_transformer_on_text (ACDSeeKeywordTransformer* self,
                                     GMarkupParseContext* ctx,
                                     const gchar* text,
                                     GError** error)
{
	GeeArrayQueue* _tmp0_;
	gboolean _tmp1_;
#line 111 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_ACD_SEE_KEYWORD_TRANSFORMER (self));
#line 111 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (ctx != NULL);
#line 111 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (text != NULL);
#line 113 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_strcmp0 (text, "") == 0) {
#line 114 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 1682 "PhotoMetadata.c"
	}
#line 117 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->stack;
#line 117 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gee_deque_offer_tail (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_DEQUE, GeeDeque), text);
#line 118 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = self->priv->assigned;
#line 118 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp1_) {
#line 1692 "PhotoMetadata.c"
		GString* builder = NULL;
		GString* _tmp2_;
		GString* _tmp10_;
		gssize _tmp11_;
		GeeArrayList* _tmp15_;
		GString* _tmp16_;
		const gchar* _tmp17_;
#line 119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = g_string_new ("");
#line 119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		builder = _tmp2_;
#line 1704 "PhotoMetadata.c"
		{
			GeeIterator* _f_it = NULL;
			GeeArrayQueue* _tmp3_;
			GeeIterator* _tmp4_;
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp3_ = self->priv->stack;
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp4_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_f_it = _tmp4_;
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			while (TRUE) {
#line 1717 "PhotoMetadata.c"
				GeeIterator* _tmp5_;
				gchar* f = NULL;
				GeeIterator* _tmp6_;
				gpointer _tmp7_;
				GString* _tmp8_;
				const gchar* _tmp9_;
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp5_ = _f_it;
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!gee_iterator_next (_tmp5_)) {
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					break;
#line 1730 "PhotoMetadata.c"
				}
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp6_ = _f_it;
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp7_ = gee_iterator_get (_tmp6_);
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				f = (gchar*) _tmp7_;
#line 121 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp8_ = builder;
#line 121 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp9_ = f;
#line 121 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				g_string_append_printf (_tmp8_, "%s|", _tmp9_);
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (f);
#line 1746 "PhotoMetadata.c"
			}
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_g_object_unref0 (_f_it);
#line 1750 "PhotoMetadata.c"
		}
#line 123 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = builder;
#line 123 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp11_ = _tmp10_->len;
#line 123 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (_tmp11_ > ((gssize) 0)) {
#line 1758 "PhotoMetadata.c"
			GString* _tmp12_;
			GString* _tmp13_;
			gssize _tmp14_;
#line 124 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp12_ = builder;
#line 124 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp13_ = builder;
#line 124 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp14_ = _tmp13_->len;
#line 124 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			g_string_truncate (_tmp12_, (gsize) (_tmp14_ - 1));
#line 1770 "PhotoMetadata.c"
		}
#line 126 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp15_ = self->priv->result;
#line 126 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp16_ = builder;
#line 126 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp17_ = _tmp16_->str;
#line 126 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp17_);
#line 118 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_string_free0 (builder);
#line 1782 "PhotoMetadata.c"
	}
}


static gpointer
_g_error_copy0 (gpointer self)
{
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self ? g_error_copy (self) : NULL;
#line 1792 "PhotoMetadata.c"
}


static void
acd_see_keyword_transformer_on_error (ACDSeeKeywordTransformer* self,
                                      GMarkupParseContext* ctx,
                                      GError* _error_)
{
	GError* _tmp0_;
#line 130 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_ACD_SEE_KEYWORD_TRANSFORMER (self));
#line 130 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (ctx != NULL);
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = _g_error_copy0 (_error_);
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_error_free0 (self->priv->error);
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->error = _tmp0_;
#line 1812 "PhotoMetadata.c"
}


static void
acd_see_keyword_transformer_class_init (ACDSeeKeywordTransformerClass * klass)
{
#line 55 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	acd_see_keyword_transformer_parent_class = g_type_class_peek_parent (klass);
#line 55 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((KeywordTransformerClass *) klass)->finalize = acd_see_keyword_transformer_finalize;
#line 55 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_type_class_add_private (klass, sizeof (ACDSeeKeywordTransformerPrivate));
#line 55 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((KeywordTransformerClass *) klass)->transform = (GeeList* (*) (KeywordTransformer *, const gchar*, GError**)) acd_see_keyword_transformer_real_transform;
#line 1827 "PhotoMetadata.c"
}


static void
acd_see_keyword_transformer_instance_init (ACDSeeKeywordTransformer * self)
{
#line 55 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv = ACD_SEE_KEYWORD_TRANSFORMER_GET_PRIVATE (self);
#line 1836 "PhotoMetadata.c"
}


static void
acd_see_keyword_transformer_finalize (KeywordTransformer * obj)
{
	ACDSeeKeywordTransformer * self;
#line 55 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ACD_SEE_KEYWORD_TRANSFORMER, ACDSeeKeywordTransformer);
#line 57 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_error_free0 (self->priv->error);
#line 58 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (self->priv->stack);
#line 59 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (self->priv->result);
#line 55 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	KEYWORD_TRANSFORMER_CLASS (acd_see_keyword_transformer_parent_class)->finalize (obj);
#line 1854 "PhotoMetadata.c"
}


GType
acd_see_keyword_transformer_get_type (void)
{
	static volatile gsize acd_see_keyword_transformer_type_id__volatile = 0;
	if (g_once_init_enter (&acd_see_keyword_transformer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ACDSeeKeywordTransformerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) acd_see_keyword_transformer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ACDSeeKeywordTransformer), 0, (GInstanceInitFunc) acd_see_keyword_transformer_instance_init, NULL };
		GType acd_see_keyword_transformer_type_id;
		acd_see_keyword_transformer_type_id = g_type_register_static (TYPE_KEYWORD_TRANSFORMER, "ACDSeeKeywordTransformer", &g_define_type_info, 0);
		g_once_init_leave (&acd_see_keyword_transformer_type_id__volatile, acd_see_keyword_transformer_type_id);
	}
	return acd_see_keyword_transformer_type_id__volatile;
}


static gpointer
_keyword_transformer_ref0 (gpointer self)
{
#line 154 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self ? keyword_transformer_ref (self) : NULL;
#line 1877 "PhotoMetadata.c"
}


HierarchicalKeywordField*
hierarchical_keyword_field_construct (GType object_type,
                                      const gchar* field_name,
                                      const gchar* path_separator,
                                      gboolean wants_leading_separator,
                                      gboolean is_writeable,
                                      KeywordTransformer* transformer)
{
	HierarchicalKeywordField* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	KeywordTransformer* _tmp2_;
#line 144 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (field_name != NULL, NULL);
#line 144 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (path_separator != NULL, NULL);
#line 144 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_KEYWORD_TRANSFORMER (transformer), NULL);
#line 144 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = (HierarchicalKeywordField*) g_type_create_instance (object_type);
#line 150 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = g_strdup (field_name);
#line 150 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->field_name);
#line 150 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->field_name = _tmp0_;
#line 151 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup (path_separator);
#line 151 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->path_separator);
#line 151 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->path_separator = _tmp1_;
#line 152 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->wants_leading_separator = wants_leading_separator;
#line 153 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->is_writeable = is_writeable;
#line 154 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = _keyword_transformer_ref0 (transformer);
#line 154 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_keyword_transformer_unref0 (self->transformer);
#line 154 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->transformer = _tmp2_;
#line 144 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self;
#line 1925 "PhotoMetadata.c"
}


HierarchicalKeywordField*
hierarchical_keyword_field_new (const gchar* field_name,
                                const gchar* path_separator,
                                gboolean wants_leading_separator,
                                gboolean is_writeable,
                                KeywordTransformer* transformer)
{
#line 144 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return hierarchical_keyword_field_construct (TYPE_HIERARCHICAL_KEYWORD_FIELD, field_name, path_separator, wants_leading_separator, is_writeable, transformer);
#line 1938 "PhotoMetadata.c"
}


static void
value_hierarchical_keyword_field_init (GValue* value)
{
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	value->data[0].v_pointer = NULL;
#line 1947 "PhotoMetadata.c"
}


static void
value_hierarchical_keyword_field_free_value (GValue* value)
{
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (value->data[0].v_pointer) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		hierarchical_keyword_field_unref (value->data[0].v_pointer);
#line 1958 "PhotoMetadata.c"
	}
}


static void
value_hierarchical_keyword_field_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (src_value->data[0].v_pointer) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		dest_value->data[0].v_pointer = hierarchical_keyword_field_ref (src_value->data[0].v_pointer);
#line 1971 "PhotoMetadata.c"
	} else {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1975 "PhotoMetadata.c"
	}
}


static gpointer
value_hierarchical_keyword_field_peek_pointer (const GValue* value)
{
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return value->data[0].v_pointer;
#line 1985 "PhotoMetadata.c"
}


static gchar*
value_hierarchical_keyword_field_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (collect_values[0].v_pointer) {
#line 1997 "PhotoMetadata.c"
		HierarchicalKeywordField * object;
		object = collect_values[0].v_pointer;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (object->parent_instance.g_class == NULL) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2004 "PhotoMetadata.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2008 "PhotoMetadata.c"
		}
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = hierarchical_keyword_field_ref (object);
#line 2012 "PhotoMetadata.c"
	} else {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 2016 "PhotoMetadata.c"
	}
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 2020 "PhotoMetadata.c"
}


static gchar*
value_hierarchical_keyword_field_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	HierarchicalKeywordField ** object_p;
	object_p = collect_values[0].v_pointer;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!object_p) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2036 "PhotoMetadata.c"
	}
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!value->data[0].v_pointer) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*object_p = NULL;
#line 2042 "PhotoMetadata.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*object_p = value->data[0].v_pointer;
#line 2046 "PhotoMetadata.c"
	} else {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*object_p = hierarchical_keyword_field_ref (value->data[0].v_pointer);
#line 2050 "PhotoMetadata.c"
	}
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 2054 "PhotoMetadata.c"
}


GParamSpec*
param_spec_hierarchical_keyword_field (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	ParamSpecHierarchicalKeywordField* spec;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HIERARCHICAL_KEYWORD_FIELD), NULL);
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return G_PARAM_SPEC (spec);
#line 2074 "PhotoMetadata.c"
}


gpointer
value_get_hierarchical_keyword_field (const GValue* value)
{
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HIERARCHICAL_KEYWORD_FIELD), NULL);
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return value->data[0].v_pointer;
#line 2085 "PhotoMetadata.c"
}


void
value_set_hierarchical_keyword_field (GValue* value,
                                      gpointer v_object)
{
	HierarchicalKeywordField * old;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HIERARCHICAL_KEYWORD_FIELD));
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	old = value->data[0].v_pointer;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (v_object) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HIERARCHICAL_KEYWORD_FIELD));
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		hierarchical_keyword_field_ref (value->data[0].v_pointer);
#line 2108 "PhotoMetadata.c"
	} else {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 2112 "PhotoMetadata.c"
	}
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (old) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		hierarchical_keyword_field_unref (old);
#line 2118 "PhotoMetadata.c"
	}
}


void
value_take_hierarchical_keyword_field (GValue* value,
                                       gpointer v_object)
{
	HierarchicalKeywordField * old;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HIERARCHICAL_KEYWORD_FIELD));
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	old = value->data[0].v_pointer;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (v_object) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HIERARCHICAL_KEYWORD_FIELD));
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 2140 "PhotoMetadata.c"
	} else {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 2144 "PhotoMetadata.c"
	}
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (old) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		hierarchical_keyword_field_unref (old);
#line 2150 "PhotoMetadata.c"
	}
}


static void
hierarchical_keyword_field_class_init (HierarchicalKeywordFieldClass * klass)
{
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	hierarchical_keyword_field_parent_class = g_type_class_peek_parent (klass);
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((HierarchicalKeywordFieldClass *) klass)->finalize = hierarchical_keyword_field_finalize;
#line 2162 "PhotoMetadata.c"
}


static void
hierarchical_keyword_field_instance_init (HierarchicalKeywordField * self)
{
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->ref_count = 1;
#line 2171 "PhotoMetadata.c"
}


static void
hierarchical_keyword_field_finalize (HierarchicalKeywordField * obj)
{
	HierarchicalKeywordField * self;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HIERARCHICAL_KEYWORD_FIELD, HierarchicalKeywordField);
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_signal_handlers_destroy (self);
#line 138 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->field_name);
#line 139 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->path_separator);
#line 142 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_keyword_transformer_unref0 (self->transformer);
#line 2189 "PhotoMetadata.c"
}


GType
hierarchical_keyword_field_get_type (void)
{
	static volatile gsize hierarchical_keyword_field_type_id__volatile = 0;
	if (g_once_init_enter (&hierarchical_keyword_field_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_hierarchical_keyword_field_init, value_hierarchical_keyword_field_free_value, value_hierarchical_keyword_field_copy_value, value_hierarchical_keyword_field_peek_pointer, "p", value_hierarchical_keyword_field_collect_value, "p", value_hierarchical_keyword_field_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (HierarchicalKeywordFieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) hierarchical_keyword_field_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HierarchicalKeywordField), 0, (GInstanceInitFunc) hierarchical_keyword_field_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType hierarchical_keyword_field_type_id;
		hierarchical_keyword_field_type_id = g_type_register_fundamental (g_type_fundamental_next (), "HierarchicalKeywordField", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&hierarchical_keyword_field_type_id__volatile, hierarchical_keyword_field_type_id);
	}
	return hierarchical_keyword_field_type_id__volatile;
}


gpointer
hierarchical_keyword_field_ref (gpointer instance)
{
	HierarchicalKeywordField * self;
	self = instance;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_atomic_int_inc (&self->ref_count);
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return instance;
#line 2218 "PhotoMetadata.c"
}


void
hierarchical_keyword_field_unref (gpointer instance)
{
	HierarchicalKeywordField * self;
	self = instance;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		HIERARCHICAL_KEYWORD_FIELD_GET_CLASS (self)->finalize (self);
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2233 "PhotoMetadata.c"
	}
}


PhotoPreview*
photo_preview_construct (GType object_type,
                         const gchar* name,
                         Dimensions* dimensions,
                         guint32 size,
                         const gchar* mime_type,
                         const gchar* extension)
{
	PhotoPreview* self = NULL;
	gchar* _tmp0_;
	Dimensions _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (dimensions != NULL, NULL);
#line 165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (mime_type != NULL, NULL);
#line 165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (extension != NULL, NULL);
#line 165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = (PhotoPreview*) g_type_create_instance (object_type);
#line 166 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = g_strdup (name);
#line 166 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->name);
#line 166 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->name = _tmp0_;
#line 167 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = *dimensions;
#line 167 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->dimensions = _tmp1_;
#line 168 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->size = size;
#line 169 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = g_strdup (mime_type);
#line 169 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->mime_type);
#line 169 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->mime_type = _tmp2_;
#line 170 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = g_strdup (extension);
#line 170 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->extension);
#line 170 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->extension = _tmp3_;
#line 165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self;
#line 2287 "PhotoMetadata.c"
}


gchar*
photo_preview_get_name (PhotoPreview* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 173 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_PREVIEW (self), NULL);
#line 174 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->name;
#line 174 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 174 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 174 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 2307 "PhotoMetadata.c"
}


void
photo_preview_get_pixel_dimensions (PhotoPreview* self,
                                    Dimensions* result)
{
	Dimensions _tmp0_;
#line 177 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_PREVIEW (self));
#line 178 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->dimensions;
#line 178 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	*result = _tmp0_;
#line 178 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return;
#line 2324 "PhotoMetadata.c"
}


guint32
photo_preview_get_size (PhotoPreview* self)
{
	guint32 result = 0U;
	guint32 _tmp0_;
#line 181 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_PREVIEW (self), 0U);
#line 182 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->size;
#line 182 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 182 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 2341 "PhotoMetadata.c"
}


gchar*
photo_preview_get_mime_type (PhotoPreview* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 185 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_PREVIEW (self), NULL);
#line 186 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->mime_type;
#line 186 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 186 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 186 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 2361 "PhotoMetadata.c"
}


gchar*
photo_preview_get_extension (PhotoPreview* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 189 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_PREVIEW (self), NULL);
#line 190 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->extension;
#line 190 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 190 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 190 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 2381 "PhotoMetadata.c"
}


static GBytes*
photo_preview_real_flatten (PhotoPreview* self,
                            GError** error)
{
#line 193 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_preview_flatten'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 193 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 2393 "PhotoMetadata.c"
}


GBytes*
photo_preview_flatten (PhotoPreview* self,
                       GError** error)
{
#line 193 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_PREVIEW (self), NULL);
#line 193 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return PHOTO_PREVIEW_GET_CLASS (self)->flatten (self, error);
#line 2405 "PhotoMetadata.c"
}


static GdkPixbuf*
photo_preview_real_get_pixbuf (PhotoPreview* self,
                               GError** error)
{
	GdkPixbuf* result = NULL;
	GBytes* flattened = NULL;
	GBytes* _tmp0_;
	GError * _inner_error_ = NULL;
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_preview_flatten (self, &_inner_error_);
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	flattened = _tmp0_;
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return NULL;
#line 2427 "PhotoMetadata.c"
	}
	{
		GdkPixbuf* _tmp1_ = NULL;
		GMemoryInputStream* _tmp2_;
		GMemoryInputStream* _tmp3_;
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_;
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = (GMemoryInputStream*) g_memory_input_stream_new_from_bytes (flattened);
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = _tmp2_;
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = gdk_pixbuf_new_from_stream (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_input_stream_get_type (), GInputStream), NULL, &_inner_error_);
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = _tmp4_;
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_object_unref0 (_tmp3_);
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = _tmp5_;
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2450 "PhotoMetadata.c"
			goto __catch29_g_error;
		}
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = _tmp1_;
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = NULL;
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = _tmp6_;
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_object_unref0 (_tmp1_);
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_bytes_unref0 (flattened);
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 2465 "PhotoMetadata.c"
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
#line 200 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		err = _inner_error_;
#line 200 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_inner_error_ = NULL;
#line 204 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = self->priv->name;
#line 204 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp8_ = err;
#line 204 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = _tmp8_->message;
#line 204 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_warning ("PhotoMetadata.vala:204: Unable to decode thumbnail for %s: %s", _tmp7_, _tmp9_);
#line 206 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 206 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_error_free0 (err);
#line 206 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_bytes_unref0 (flattened);
#line 206 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 2494 "PhotoMetadata.c"
	}
	__finally29:
#line 200 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_propagate_error (error, _inner_error_);
#line 200 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_bytes_unref0 (flattened);
#line 200 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 2503 "PhotoMetadata.c"
}


GdkPixbuf*
photo_preview_get_pixbuf (PhotoPreview* self,
                          GError** error)
{
#line 195 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_PREVIEW (self), NULL);
#line 195 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return PHOTO_PREVIEW_GET_CLASS (self)->get_pixbuf (self, error);
#line 2515 "PhotoMetadata.c"
}


static void
value_photo_preview_init (GValue* value)
{
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	value->data[0].v_pointer = NULL;
#line 2524 "PhotoMetadata.c"
}


static void
value_photo_preview_free_value (GValue* value)
{
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (value->data[0].v_pointer) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_preview_unref (value->data[0].v_pointer);
#line 2535 "PhotoMetadata.c"
	}
}


static void
value_photo_preview_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (src_value->data[0].v_pointer) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		dest_value->data[0].v_pointer = photo_preview_ref (src_value->data[0].v_pointer);
#line 2548 "PhotoMetadata.c"
	} else {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2552 "PhotoMetadata.c"
	}
}


static gpointer
value_photo_preview_peek_pointer (const GValue* value)
{
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return value->data[0].v_pointer;
#line 2562 "PhotoMetadata.c"
}


static gchar*
value_photo_preview_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (collect_values[0].v_pointer) {
#line 2574 "PhotoMetadata.c"
		PhotoPreview * object;
		object = collect_values[0].v_pointer;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (object->parent_instance.g_class == NULL) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2581 "PhotoMetadata.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2585 "PhotoMetadata.c"
		}
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = photo_preview_ref (object);
#line 2589 "PhotoMetadata.c"
	} else {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 2593 "PhotoMetadata.c"
	}
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 2597 "PhotoMetadata.c"
}


static gchar*
value_photo_preview_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	PhotoPreview ** object_p;
	object_p = collect_values[0].v_pointer;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!object_p) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2613 "PhotoMetadata.c"
	}
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!value->data[0].v_pointer) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*object_p = NULL;
#line 2619 "PhotoMetadata.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*object_p = value->data[0].v_pointer;
#line 2623 "PhotoMetadata.c"
	} else {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*object_p = photo_preview_ref (value->data[0].v_pointer);
#line 2627 "PhotoMetadata.c"
	}
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 2631 "PhotoMetadata.c"
}


GParamSpec*
param_spec_photo_preview (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ParamSpecPhotoPreview* spec;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PHOTO_PREVIEW), NULL);
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return G_PARAM_SPEC (spec);
#line 2651 "PhotoMetadata.c"
}


gpointer
value_get_photo_preview (const GValue* value)
{
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_PREVIEW), NULL);
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return value->data[0].v_pointer;
#line 2662 "PhotoMetadata.c"
}


void
value_set_photo_preview (GValue* value,
                         gpointer v_object)
{
	PhotoPreview * old;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_PREVIEW));
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	old = value->data[0].v_pointer;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (v_object) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_PREVIEW));
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_preview_ref (value->data[0].v_pointer);
#line 2685 "PhotoMetadata.c"
	} else {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 2689 "PhotoMetadata.c"
	}
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (old) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_preview_unref (old);
#line 2695 "PhotoMetadata.c"
	}
}


void
value_take_photo_preview (GValue* value,
                          gpointer v_object)
{
	PhotoPreview * old;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_PREVIEW));
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	old = value->data[0].v_pointer;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (v_object) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_PREVIEW));
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 2717 "PhotoMetadata.c"
	} else {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 2721 "PhotoMetadata.c"
	}
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (old) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_preview_unref (old);
#line 2727 "PhotoMetadata.c"
	}
}


static void
photo_preview_class_init (PhotoPreviewClass * klass)
{
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_preview_parent_class = g_type_class_peek_parent (klass);
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((PhotoPreviewClass *) klass)->finalize = photo_preview_finalize;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_type_class_add_private (klass, sizeof (PhotoPreviewPrivate));
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((PhotoPreviewClass *) klass)->flatten = (GBytes* (*) (PhotoPreview *, GError**)) photo_preview_real_flatten;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((PhotoPreviewClass *) klass)->get_pixbuf = (GdkPixbuf* (*) (PhotoPreview *, GError**)) photo_preview_real_get_pixbuf;
#line 2745 "PhotoMetadata.c"
}


static void
photo_preview_instance_init (PhotoPreview * self)
{
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv = PHOTO_PREVIEW_GET_PRIVATE (self);
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->ref_count = 1;
#line 2756 "PhotoMetadata.c"
}


static void
photo_preview_finalize (PhotoPreview * obj)
{
	PhotoPreview * self;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_PREVIEW, PhotoPreview);
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_signal_handlers_destroy (self);
#line 159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->name);
#line 162 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->mime_type);
#line 163 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->extension);
#line 2774 "PhotoMetadata.c"
}


GType
photo_preview_get_type (void)
{
	static volatile gsize photo_preview_type_id__volatile = 0;
	if (g_once_init_enter (&photo_preview_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_photo_preview_init, value_photo_preview_free_value, value_photo_preview_copy_value, value_photo_preview_peek_pointer, "p", value_photo_preview_collect_value, "p", value_photo_preview_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PhotoPreviewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_preview_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoPreview), 0, (GInstanceInitFunc) photo_preview_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType photo_preview_type_id;
		photo_preview_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoPreview", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&photo_preview_type_id__volatile, photo_preview_type_id);
	}
	return photo_preview_type_id__volatile;
}


gpointer
photo_preview_ref (gpointer instance)
{
	PhotoPreview * self;
	self = instance;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_atomic_int_inc (&self->ref_count);
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return instance;
#line 2803 "PhotoMetadata.c"
}


void
photo_preview_unref (gpointer instance)
{
	PhotoPreview * self;
	self = instance;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		PHOTO_PREVIEW_GET_CLASS (self)->finalize (self);
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2818 "PhotoMetadata.c"
	}
}


GType
photo_metadata_set_option_get_type (void)
{
	static volatile gsize photo_metadata_set_option_type_id__volatile = 0;
	if (g_once_init_enter (&photo_metadata_set_option_type_id__volatile)) {
		static const GEnumValue values[] = {{PHOTO_METADATA_SET_OPTION_ALL_DOMAINS, "PHOTO_METADATA_SET_OPTION_ALL_DOMAINS", "all-domains"}, {PHOTO_METADATA_SET_OPTION_ONLY_IF_DOMAIN_PRESENT, "PHOTO_METADATA_SET_OPTION_ONLY_IF_DOMAIN_PRESENT", "only-if-domain-present"}, {PHOTO_METADATA_SET_OPTION_AT_LEAST_DEFAULT_DOMAIN, "PHOTO_METADATA_SET_OPTION_AT_LEAST_DEFAULT_DOMAIN", "at-least-default-domain"}, {0, NULL, NULL}};
		GType photo_metadata_set_option_type_id;
		photo_metadata_set_option_type_id = g_enum_register_static ("PhotoMetadataSetOption", values);
		g_once_init_leave (&photo_metadata_set_option_type_id__volatile, photo_metadata_set_option_type_id);
	}
	return photo_metadata_set_option_type_id__volatile;
}


PhotoMetadata*
photo_metadata_construct (GType object_type)
{
	PhotoMetadata* self = NULL;
#line 254 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = (PhotoMetadata*) media_metadata_construct (object_type);
#line 254 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self;
#line 2845 "PhotoMetadata.c"
}


PhotoMetadata*
photo_metadata_new (void)
{
#line 254 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return photo_metadata_construct (TYPE_PHOTO_METADATA);
#line 2854 "PhotoMetadata.c"
}


static void
photo_metadata_real_read_from_file (MediaMetadata* base,
                                    GFile* file,
                                    GError** error)
{
	PhotoMetadata * self;
	GExiv2Metadata* _tmp0_;
	GExiv2Metadata* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ExifData* _tmp6_;
	gchar* _tmp7_;
	GError * _inner_error_ = NULL;
#line 257 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_METADATA, PhotoMetadata);
#line 257 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 258 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = gexiv2_metadata_new ();
#line 258 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (self->priv->exiv2);
#line 258 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exiv2 = _tmp0_;
#line 259 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_exif_data_unref0 (self->priv->exif);
#line 259 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exif = NULL;
#line 261 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = self->priv->exiv2;
#line 261 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = g_file_get_path (file);
#line 261 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = _tmp2_;
#line 261 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gexiv2_metadata_open_path (_tmp1_, _tmp3_, &_inner_error_);
#line 261 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp3_);
#line 261 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 261 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 261 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 2903 "PhotoMetadata.c"
	}
#line 262 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = g_file_get_path (file);
#line 262 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = _tmp4_;
#line 262 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = exif_data_new_from_file (_tmp5_);
#line 262 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_exif_data_unref0 (self->priv->exif);
#line 262 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exif = _tmp6_;
#line 262 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp5_);
#line 263 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = g_file_get_basename (file);
#line 263 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->source_name);
#line 263 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->source_name = _tmp7_;
#line 2923 "PhotoMetadata.c"
}


void
photo_metadata_write_to_file (PhotoMetadata* self,
                              GFile* file,
                              GError** error)
{
	GExiv2Metadata* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
#line 266 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 266 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 267 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 267 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_file_get_path (file);
#line 267 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = _tmp1_;
#line 267 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gexiv2_metadata_save_file (_tmp0_, _tmp2_, &_inner_error_);
#line 267 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp2_);
#line 267 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 267 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 267 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 2956 "PhotoMetadata.c"
	}
}


void
photo_metadata_read_from_buffer (PhotoMetadata* self,
                                 guint8* buffer,
                                 int buffer_length1,
                                 gint length,
                                 GError** error)
{
	GExiv2Metadata* _tmp0_;
	GExiv2Metadata* _tmp1_;
	ExifData* _tmp2_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
#line 270 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 271 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (length <= 0) {
#line 272 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		length = buffer_length1;
#line 2979 "PhotoMetadata.c"
	}
#line 274 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_assert (buffer_length1 >= length, "buffer.length >= length");
#line 276 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = gexiv2_metadata_new ();
#line 276 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (self->priv->exiv2);
#line 276 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exiv2 = _tmp0_;
#line 277 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_exif_data_unref0 (self->priv->exif);
#line 277 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exif = NULL;
#line 279 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = self->priv->exiv2;
#line 279 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gexiv2_metadata_open_buf (_tmp1_, buffer, (glong) length, &_inner_error_);
#line 279 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 279 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 279 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 3003 "PhotoMetadata.c"
	}
#line 280 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = exif_data_new_from_data (buffer, (gsize) length);
#line 280 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_exif_data_unref0 (self->priv->exif);
#line 280 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exif = _tmp2_;
#line 281 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = g_strdup_printf ("<memory buffer %d bytes>", length);
#line 281 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->source_name);
#line 281 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->source_name = _tmp3_;
#line 3017 "PhotoMetadata.c"
}


void
photo_metadata_read_from_app1_segment (PhotoMetadata* self,
                                       GBytes* buffer,
                                       GError** error)
{
	GExiv2Metadata* _tmp0_;
	GExiv2Metadata* _tmp1_;
	gsize _tmp2_;
	guint8* _tmp3_;
	gsize _tmp4_;
	guint8* _tmp5_;
	ExifData* _tmp6_;
	gchar* _tmp7_;
	GError * _inner_error_ = NULL;
#line 284 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 284 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (buffer != NULL);
#line 285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = gexiv2_metadata_new ();
#line 285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (self->priv->exiv2);
#line 285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exiv2 = _tmp0_;
#line 286 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_exif_data_unref0 (self->priv->exif);
#line 286 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exif = NULL;
#line 288 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = self->priv->exiv2;
#line 288 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = g_bytes_get_data (buffer, &_tmp2_);
#line 288 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gexiv2_metadata_from_app1_segment (_tmp1_, _tmp3_, (glong) g_bytes_get_size (buffer), &_inner_error_);
#line 288 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 288 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 288 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 3061 "PhotoMetadata.c"
	}
#line 289 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = g_bytes_get_data (buffer, &_tmp4_);
#line 289 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = exif_data_new_from_data (_tmp5_, g_bytes_get_size (buffer));
#line 289 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_exif_data_unref0 (self->priv->exif);
#line 289 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exif = _tmp6_;
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = g_strdup_printf ("<app1 segment %zu bytes>", g_bytes_get_size (buffer));
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->source_name);
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->source_name = _tmp7_;
#line 3077 "PhotoMetadata.c"
}


MetadataDomain
photo_metadata_get_tag_domain (const gchar* tag)
{
	MetadataDomain result = 0;
#line 293 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, 0);
#line 294 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (gexiv2_metadata_is_exif_tag (tag)) {
#line 295 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = METADATA_DOMAIN_EXIF;
#line 295 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 3093 "PhotoMetadata.c"
	}
#line 297 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (gexiv2_metadata_is_xmp_tag (tag)) {
#line 298 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = METADATA_DOMAIN_XMP;
#line 298 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 3101 "PhotoMetadata.c"
	}
#line 300 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (gexiv2_metadata_is_iptc_tag (tag)) {
#line 301 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = METADATA_DOMAIN_IPTC;
#line 301 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 3109 "PhotoMetadata.c"
	}
#line 303 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = METADATA_DOMAIN_UNKNOWN;
#line 303 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3115 "PhotoMetadata.c"
}


gboolean
photo_metadata_has_domain (PhotoMetadata* self,
                           MetadataDomain domain)
{
	gboolean result = FALSE;
#line 306 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 307 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	switch (domain) {
#line 307 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_EXIF:
#line 3130 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp0_;
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp0_ = self->priv->exiv2;
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			result = gexiv2_metadata_has_exif (_tmp0_);
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return result;
#line 3139 "PhotoMetadata.c"
		}
#line 307 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_XMP:
#line 3143 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp1_;
#line 312 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = self->priv->exiv2;
#line 312 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			result = gexiv2_metadata_has_xmp (_tmp1_);
#line 312 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return result;
#line 3152 "PhotoMetadata.c"
		}
#line 307 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_IPTC:
#line 3156 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp2_;
#line 315 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp2_ = self->priv->exiv2;
#line 315 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			result = gexiv2_metadata_has_iptc (_tmp2_);
#line 315 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return result;
#line 3165 "PhotoMetadata.c"
		}
		default:
#line 307 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_UNKNOWN:
#line 3170 "PhotoMetadata.c"
		{
#line 319 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			result = FALSE;
#line 319 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return result;
#line 3176 "PhotoMetadata.c"
		}
	}
}


gboolean
photo_metadata_has_exif (PhotoMetadata* self)
{
	gboolean result = FALSE;
#line 323 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 324 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = photo_metadata_has_domain (self, METADATA_DOMAIN_EXIF);
#line 324 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3192 "PhotoMetadata.c"
}


gboolean
photo_metadata_has_xmp (PhotoMetadata* self)
{
	gboolean result = FALSE;
#line 327 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 328 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = photo_metadata_has_domain (self, METADATA_DOMAIN_XMP);
#line 328 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3206 "PhotoMetadata.c"
}


gboolean
photo_metadata_has_iptc (PhotoMetadata* self)
{
	gboolean result = FALSE;
#line 331 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 332 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = photo_metadata_has_domain (self, METADATA_DOMAIN_IPTC);
#line 332 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3220 "PhotoMetadata.c"
}


gboolean
photo_metadata_can_write_to_domain (PhotoMetadata* self,
                                    MetadataDomain domain)
{
	gboolean result = FALSE;
#line 335 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 336 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	switch (domain) {
#line 336 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_EXIF:
#line 3235 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp0_;
#line 338 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp0_ = self->priv->exiv2;
#line 338 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			result = gexiv2_metadata_get_supports_exif (_tmp0_);
#line 338 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return result;
#line 3244 "PhotoMetadata.c"
		}
#line 336 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_XMP:
#line 3248 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp1_;
#line 341 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = self->priv->exiv2;
#line 341 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			result = gexiv2_metadata_get_supports_xmp (_tmp1_);
#line 341 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return result;
#line 3257 "PhotoMetadata.c"
		}
#line 336 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_IPTC:
#line 3261 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp2_;
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp2_ = self->priv->exiv2;
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			result = gexiv2_metadata_get_supports_iptc (_tmp2_);
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return result;
#line 3270 "PhotoMetadata.c"
		}
		default:
#line 336 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_UNKNOWN:
#line 3275 "PhotoMetadata.c"
		{
#line 348 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			result = FALSE;
#line 348 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return result;
#line 3281 "PhotoMetadata.c"
		}
	}
}


gboolean
photo_metadata_can_write_exif (PhotoMetadata* self)
{
	gboolean result = FALSE;
#line 352 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 353 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = photo_metadata_can_write_to_domain (self, METADATA_DOMAIN_EXIF);
#line 353 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3297 "PhotoMetadata.c"
}


gboolean
photo_metadata_can_write_xmp (PhotoMetadata* self)
{
	gboolean result = FALSE;
#line 356 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 357 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = photo_metadata_can_write_to_domain (self, METADATA_DOMAIN_XMP);
#line 357 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3311 "PhotoMetadata.c"
}


gboolean
photo_metadata_can_write_iptc (PhotoMetadata* self)
{
	gboolean result = FALSE;
#line 360 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 361 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = photo_metadata_can_write_to_domain (self, METADATA_DOMAIN_IPTC);
#line 361 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3325 "PhotoMetadata.c"
}


gboolean
photo_metadata_has_tag (PhotoMetadata* self,
                        const gchar* tag)
{
	gboolean result = FALSE;
	GExiv2Metadata* _tmp0_;
#line 364 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 364 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, FALSE);
#line 365 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 365 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = gexiv2_metadata_has_tag (_tmp0_, tag);
#line 365 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3345 "PhotoMetadata.c"
}


static GeeSet*
photo_metadata_create_string_set (PhotoMetadata* self,
                                  GCompareDataFunc compare_func,
                                  void* compare_func_target,
                                  GDestroyNotify compare_func_target_destroy_notify)
{
	GeeSet* result = NULL;
#line 368 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 370 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (compare_func == NULL) {
#line 3360 "PhotoMetadata.c"
		GeeHashSet* _tmp0_;
#line 371 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 371 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_SET, GeeSet);
#line 371 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
#line 371 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func = NULL;
#line 371 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func_target = NULL;
#line 371 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func_target_destroy_notify = NULL;
#line 371 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 3376 "PhotoMetadata.c"
	} else {
		GCompareDataFunc _tmp1_;
		void* _tmp1__target;
		GDestroyNotify _tmp1__target_destroy_notify;
		GeeTreeSet* _tmp2_;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = compare_func;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1__target = compare_func_target;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1__target_destroy_notify = compare_func_target_destroy_notify;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func = NULL;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func_target = NULL;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func_target_destroy_notify = NULL;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp1_, _tmp1__target, _tmp1__target_destroy_notify);
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_SET, GeeSet);
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func = NULL;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func_target = NULL;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func_target_destroy_notify = NULL;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 3408 "PhotoMetadata.c"
	}
#line 368 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
#line 368 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func = NULL;
#line 368 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target = NULL;
#line 368 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target_destroy_notify = NULL;
#line 3418 "PhotoMetadata.c"
}


GeeCollection*
photo_metadata_get_tags (PhotoMetadata* self,
                         MetadataDomain domain,
                         GCompareDataFunc compare_func,
                         void* compare_func_target,
                         GDestroyNotify compare_func_target_destroy_notify)
{
	GeeCollection* result = NULL;
	gchar** tags = NULL;
	gint tags_length1;
	gint _tags_size_;
	gboolean _tmp9_ = FALSE;
	gchar** _tmp10_;
	gint _tmp10__length1;
	GeeCollection* collection = NULL;
	GCompareDataFunc _tmp12_;
	void* _tmp12__target;
	GDestroyNotify _tmp12__target_destroy_notify;
	GeeSet* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
#line 376 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 378 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	tags = NULL;
#line 378 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	tags_length1 = 0;
#line 378 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tags_size_ = tags_length1;
#line 379 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	switch (domain) {
#line 379 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_EXIF:
#line 3455 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp0_;
			gchar** _tmp1_;
			gchar** _tmp2_;
#line 381 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp0_ = self->priv->exiv2;
#line 381 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp2_ = _tmp1_ = gexiv2_metadata_get_exif_tags (_tmp0_);
#line 381 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags = (_vala_array_free (tags, tags_length1, (GDestroyNotify) g_free), NULL);
#line 381 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags = _tmp2_;
#line 381 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags_length1 = _vala_array_length (_tmp1_);
#line 381 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tags_size_ = tags_length1;
#line 382 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 3474 "PhotoMetadata.c"
		}
#line 379 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_XMP:
#line 3478 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp3_;
			gchar** _tmp4_;
			gchar** _tmp5_;
#line 385 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp3_ = self->priv->exiv2;
#line 385 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp5_ = _tmp4_ = gexiv2_metadata_get_xmp_tags (_tmp3_);
#line 385 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags = (_vala_array_free (tags, tags_length1, (GDestroyNotify) g_free), NULL);
#line 385 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags = _tmp5_;
#line 385 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags_length1 = _vala_array_length (_tmp4_);
#line 385 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tags_size_ = tags_length1;
#line 386 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 3497 "PhotoMetadata.c"
		}
#line 379 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_IPTC:
#line 3501 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp6_;
			gchar** _tmp7_;
			gchar** _tmp8_;
#line 389 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp6_ = self->priv->exiv2;
#line 389 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp8_ = _tmp7_ = gexiv2_metadata_get_iptc_tags (_tmp6_);
#line 389 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags = (_vala_array_free (tags, tags_length1, (GDestroyNotify) g_free), NULL);
#line 389 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags = _tmp8_;
#line 389 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags_length1 = _vala_array_length (_tmp7_);
#line 389 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tags_size_ = tags_length1;
#line 390 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 3520 "PhotoMetadata.c"
		}
		default:
#line 379 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		break;
#line 3525 "PhotoMetadata.c"
	}
#line 393 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_ = tags;
#line 393 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10__length1 = tags_length1;
#line 393 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp10_ == NULL) {
#line 393 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = TRUE;
#line 3535 "PhotoMetadata.c"
	} else {
		gchar** _tmp11_;
		gint _tmp11__length1;
#line 393 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp11_ = tags;
#line 393 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp11__length1 = tags_length1;
#line 393 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = _tmp11__length1 == 0;
#line 3545 "PhotoMetadata.c"
	}
#line 393 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp9_) {
#line 394 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 394 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tags = (_vala_array_free (tags, tags_length1, (GDestroyNotify) g_free), NULL);
#line 394 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
#line 394 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func = NULL;
#line 394 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func_target = NULL;
#line 394 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func_target_destroy_notify = NULL;
#line 394 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 3563 "PhotoMetadata.c"
	}
#line 396 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12_ = compare_func;
#line 396 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12__target = compare_func_target;
#line 396 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12__target_destroy_notify = compare_func_target_destroy_notify;
#line 396 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func = NULL;
#line 396 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target = NULL;
#line 396 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target_destroy_notify = NULL;
#line 396 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13_ = photo_metadata_create_string_set (self, _tmp12_, _tmp12__target, _tmp12__target_destroy_notify);
#line 396 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	collection = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_COLLECTION, GeeCollection);
#line 397 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp14_ = tags;
#line 397 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp14__length1 = tags_length1;
#line 3585 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 397 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = _tmp14_;
#line 397 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = _tmp14__length1;
#line 397 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < _tmp14__length1; tag_it = tag_it + 1) {
#line 3597 "PhotoMetadata.c"
			gchar* _tmp15_;
			gchar* tag = NULL;
#line 397 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp15_ = g_strdup (tag_collection[tag_it]);
#line 397 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp15_;
#line 3604 "PhotoMetadata.c"
			{
				GeeCollection* _tmp16_;
				const gchar* _tmp17_;
#line 398 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp16_ = collection;
#line 398 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp17_ = tag;
#line 398 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				gee_collection_add (_tmp16_, _tmp17_);
#line 397 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 3616 "PhotoMetadata.c"
			}
		}
	}
#line 400 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = collection;
#line 400 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	tags = (_vala_array_free (tags, tags_length1, (GDestroyNotify) g_free), NULL);
#line 400 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
#line 400 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func = NULL;
#line 400 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target = NULL;
#line 400 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target_destroy_notify = NULL;
#line 400 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3634 "PhotoMetadata.c"
}


GeeCollection*
photo_metadata_get_all_tags (PhotoMetadata* self,
                             GCompareDataFunc compare_func,
                             void* compare_func_target,
                             GDestroyNotify compare_func_target_destroy_notify)
{
	GeeCollection* result = NULL;
	GeeCollection* all_tags = NULL;
	GCompareDataFunc _tmp0_;
	void* _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	GeeSet* _tmp1_;
	GeeCollection* exif_tags = NULL;
	GeeCollection* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_;
	GeeCollection* xmp_tags = NULL;
	GeeCollection* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GeeCollection* _tmp12_;
	GeeCollection* iptc_tags = NULL;
	GeeCollection* _tmp18_;
	gboolean _tmp19_ = FALSE;
	GeeCollection* _tmp20_;
	GeeCollection* _tmp26_ = NULL;
	GeeCollection* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	GeeCollection* _tmp31_;
#line 403 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 405 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = compare_func;
#line 405 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__target = compare_func_target;
#line 405 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__target_destroy_notify = compare_func_target_destroy_notify;
#line 405 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func = NULL;
#line 405 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target = NULL;
#line 405 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target_destroy_notify = NULL;
#line 405 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_create_string_set (self, _tmp0_, _tmp0__target, _tmp0__target_destroy_notify);
#line 405 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	all_tags = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection);
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = photo_metadata_get_tags (self, METADATA_DOMAIN_EXIF, NULL, NULL, NULL);
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	exif_tags = _tmp2_;
#line 408 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = exif_tags;
#line 408 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp4_ != NULL) {
#line 3693 "PhotoMetadata.c"
		GeeCollection* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
#line 408 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = exif_tags;
#line 408 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = gee_collection_get_size (_tmp5_);
#line 408 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = _tmp6_;
#line 408 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = _tmp7_ > 0;
#line 3705 "PhotoMetadata.c"
	} else {
#line 408 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = FALSE;
#line 3709 "PhotoMetadata.c"
	}
#line 408 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp3_) {
#line 3713 "PhotoMetadata.c"
		GeeCollection* _tmp8_;
		GeeCollection* _tmp9_;
#line 409 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp8_ = all_tags;
#line 409 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = exif_tags;
#line 409 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		gee_collection_add_all (_tmp8_, _tmp9_);
#line 3722 "PhotoMetadata.c"
	}
#line 411 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_ = photo_metadata_get_tags (self, METADATA_DOMAIN_XMP, NULL, NULL, NULL);
#line 411 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	xmp_tags = _tmp10_;
#line 412 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12_ = xmp_tags;
#line 412 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp12_ != NULL) {
#line 3732 "PhotoMetadata.c"
		GeeCollection* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
#line 412 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp13_ = xmp_tags;
#line 412 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp14_ = gee_collection_get_size (_tmp13_);
#line 412 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp15_ = _tmp14_;
#line 412 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp11_ = _tmp15_ > 0;
#line 3744 "PhotoMetadata.c"
	} else {
#line 412 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp11_ = FALSE;
#line 3748 "PhotoMetadata.c"
	}
#line 412 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp11_) {
#line 3752 "PhotoMetadata.c"
		GeeCollection* _tmp16_;
		GeeCollection* _tmp17_;
#line 413 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp16_ = all_tags;
#line 413 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp17_ = xmp_tags;
#line 413 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		gee_collection_add_all (_tmp16_, _tmp17_);
#line 3761 "PhotoMetadata.c"
	}
#line 415 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp18_ = photo_metadata_get_tags (self, METADATA_DOMAIN_IPTC, NULL, NULL, NULL);
#line 415 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	iptc_tags = _tmp18_;
#line 416 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp20_ = iptc_tags;
#line 416 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp20_ != NULL) {
#line 3771 "PhotoMetadata.c"
		GeeCollection* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
#line 416 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp21_ = iptc_tags;
#line 416 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp22_ = gee_collection_get_size (_tmp21_);
#line 416 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp23_ = _tmp22_;
#line 416 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp19_ = _tmp23_ > 0;
#line 3783 "PhotoMetadata.c"
	} else {
#line 416 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp19_ = FALSE;
#line 3787 "PhotoMetadata.c"
	}
#line 416 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp19_) {
#line 3791 "PhotoMetadata.c"
		GeeCollection* _tmp24_;
		GeeCollection* _tmp25_;
#line 417 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp24_ = all_tags;
#line 417 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp25_ = iptc_tags;
#line 417 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		gee_collection_add_all (_tmp24_, _tmp25_);
#line 3800 "PhotoMetadata.c"
	}
#line 419 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp27_ = all_tags;
#line 419 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp28_ = gee_collection_get_size (_tmp27_);
#line 419 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp29_ = _tmp28_;
#line 419 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp29_ > 0) {
#line 3810 "PhotoMetadata.c"
		GeeCollection* _tmp30_;
#line 419 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp30_ = all_tags;
#line 419 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp26_ = _tmp30_;
#line 3816 "PhotoMetadata.c"
	} else {
#line 419 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp26_ = NULL;
#line 3820 "PhotoMetadata.c"
	}
#line 419 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp31_ = _g_object_ref0 (_tmp26_);
#line 419 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp31_;
#line 419 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (iptc_tags);
#line 419 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (xmp_tags);
#line 419 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (exif_tags);
#line 419 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (all_tags);
#line 419 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
#line 419 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func = NULL;
#line 419 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target = NULL;
#line 419 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target_destroy_notify = NULL;
#line 419 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3844 "PhotoMetadata.c"
}


gchar*
photo_metadata_get_tag_label (PhotoMetadata* self,
                              const gchar* tag)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 422 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 422 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 423 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = gexiv2_metadata_get_tag_label (tag);
#line 423 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 423 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 423 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3867 "PhotoMetadata.c"
}


gchar*
photo_metadata_get_tag_description (PhotoMetadata* self,
                                    const gchar* tag)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 426 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 426 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 427 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = gexiv2_metadata_get_tag_description (tag);
#line 427 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 427 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 427 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3890 "PhotoMetadata.c"
}


gchar*
photo_metadata_get_string (PhotoMetadata* self,
                           const gchar* tag,
                           PrepareInputTextOptions options)
{
	gchar* result = NULL;
	GExiv2Metadata* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
#line 430 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 430 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 431 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 431 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = gexiv2_metadata_get_tag_string (_tmp0_, tag);
#line 431 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = _tmp1_;
#line 431 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = prepare_input_text (_tmp2_, options, DEFAULT_USER_TEXT_INPUT_LENGTH);
#line 431 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = _tmp3_;
#line 431 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp2_);
#line 431 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp4_;
#line 431 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3925 "PhotoMetadata.c"
}


gchar*
photo_metadata_get_string_interpreted (PhotoMetadata* self,
                                       const gchar* tag,
                                       PrepareInputTextOptions options)
{
	gchar* result = NULL;
	GExiv2Metadata* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
#line 434 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 434 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 435 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 435 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = gexiv2_metadata_get_tag_interpreted_string (_tmp0_, tag);
#line 435 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = _tmp1_;
#line 435 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = prepare_input_text (_tmp2_, options, DEFAULT_USER_TEXT_INPUT_LENGTH);
#line 435 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = _tmp3_;
#line 435 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp2_);
#line 435 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp4_;
#line 435 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3960 "PhotoMetadata.c"
}


gchar*
photo_metadata_get_first_string (PhotoMetadata* self,
                                 gchar** tags,
                                 int tags_length1)
{
	gchar* result = NULL;
#line 438 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 3972 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 439 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = tags;
#line 439 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = tags_length1;
#line 439 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < tags_length1; tag_it = tag_it + 1) {
#line 3984 "PhotoMetadata.c"
			gchar* _tmp0_;
			gchar* tag = NULL;
#line 439 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp0_ = g_strdup (tag_collection[tag_it]);
#line 439 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp0_;
#line 3991 "PhotoMetadata.c"
			{
				gchar* value = NULL;
				const gchar* _tmp1_;
				gchar* _tmp2_;
				const gchar* _tmp3_;
#line 440 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp1_ = tag;
#line 440 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = photo_metadata_get_string (self, _tmp1_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 440 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				value = _tmp2_;
#line 441 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = value;
#line 441 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp3_ != NULL) {
#line 442 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					result = value;
#line 442 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_free0 (tag);
#line 442 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					return result;
#line 4013 "PhotoMetadata.c"
				}
#line 439 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (value);
#line 439 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 4019 "PhotoMetadata.c"
			}
		}
	}
#line 445 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = NULL;
#line 445 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 4027 "PhotoMetadata.c"
}


gchar*
photo_metadata_get_first_string_interpreted (PhotoMetadata* self,
                                             gchar** tags,
                                             int tags_length1)
{
	gchar* result = NULL;
#line 448 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 4039 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 449 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = tags;
#line 449 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = tags_length1;
#line 449 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < tags_length1; tag_it = tag_it + 1) {
#line 4051 "PhotoMetadata.c"
			gchar* _tmp0_;
			gchar* tag = NULL;
#line 449 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp0_ = g_strdup (tag_collection[tag_it]);
#line 449 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp0_;
#line 4058 "PhotoMetadata.c"
			{
				gchar* value = NULL;
				const gchar* _tmp1_;
				gchar* _tmp2_;
				const gchar* _tmp3_;
#line 450 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp1_ = tag;
#line 450 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = photo_metadata_get_string_interpreted (self, _tmp1_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 450 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				value = _tmp2_;
#line 451 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = value;
#line 451 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp3_ != NULL) {
#line 452 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					result = value;
#line 452 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_free0 (tag);
#line 452 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					return result;
#line 4080 "PhotoMetadata.c"
				}
#line 449 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (value);
#line 449 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 4086 "PhotoMetadata.c"
			}
		}
	}
#line 455 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = NULL;
#line 455 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 4094 "PhotoMetadata.c"
}


GeeList*
photo_metadata_get_string_multiple (PhotoMetadata* self,
                                    const gchar* tag)
{
	GeeList* result = NULL;
	gchar** values = NULL;
	GExiv2Metadata* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint values_length1;
	gint _values_size_;
	gboolean _tmp3_ = FALSE;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GeeList* list = NULL;
	GeeArrayList* _tmp6_;
	GeeHashSet* collection = NULL;
	GeeHashSet* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GeeList* _tmp20_ = NULL;
	GeeList* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	GeeList* _tmp25_;
#line 464 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 464 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 465 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 465 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = _tmp1_ = gexiv2_metadata_get_tag_multiple (_tmp0_, tag);
#line 465 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	values = _tmp2_;
#line 465 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	values_length1 = _vala_array_length (_tmp1_);
#line 465 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_values_size_ = values_length1;
#line 466 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = values;
#line 466 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4__length1 = values_length1;
#line 466 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp4_ == NULL) {
#line 466 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = TRUE;
#line 4145 "PhotoMetadata.c"
	} else {
		gchar** _tmp5_;
		gint _tmp5__length1;
#line 466 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = values;
#line 466 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5__length1 = values_length1;
#line 466 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = _tmp5__length1 == 0;
#line 4155 "PhotoMetadata.c"
	}
#line 466 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp3_) {
#line 467 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 467 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 467 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 4165 "PhotoMetadata.c"
	}
#line 469 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 469 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	list = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_LIST, GeeList);
#line 471 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 471 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	collection = _tmp7_;
#line 472 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = values;
#line 472 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8__length1 = values_length1;
#line 4179 "PhotoMetadata.c"
	{
		gchar** value_collection = NULL;
		gint value_collection_length1 = 0;
		gint _value_collection_size_ = 0;
		gint value_it = 0;
#line 472 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value_collection = _tmp8_;
#line 472 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value_collection_length1 = _tmp8__length1;
#line 472 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (value_it = 0; value_it < _tmp8__length1; value_it = value_it + 1) {
#line 4191 "PhotoMetadata.c"
			gchar* _tmp9_;
			gchar* value = NULL;
#line 472 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp9_ = g_strdup (value_collection[value_it]);
#line 472 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			value = _tmp9_;
#line 4198 "PhotoMetadata.c"
			{
				gchar* prepped = NULL;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gboolean _tmp12_ = FALSE;
				const gchar* _tmp13_;
#line 473 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp10_ = value;
#line 473 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp11_ = prepare_input_text (_tmp10_, PHOTO_METADATA_PREPARE_STRING_OPTIONS, DEFAULT_USER_TEXT_INPUT_LENGTH);
#line 473 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				prepped = _tmp11_;
#line 476 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp13_ = prepped;
#line 476 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp13_ != NULL) {
#line 4215 "PhotoMetadata.c"
					GeeHashSet* _tmp14_;
					const gchar* _tmp15_;
#line 476 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp14_ = collection;
#line 476 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp15_ = prepped;
#line 476 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp12_ = !gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp15_);
#line 4224 "PhotoMetadata.c"
				} else {
#line 476 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp12_ = FALSE;
#line 4228 "PhotoMetadata.c"
				}
#line 476 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp12_) {
#line 4232 "PhotoMetadata.c"
					GeeList* _tmp16_;
					const gchar* _tmp17_;
					GeeHashSet* _tmp18_;
					const gchar* _tmp19_;
#line 477 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp16_ = list;
#line 477 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp17_ = prepped;
#line 477 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_COLLECTION, GeeCollection), _tmp17_);
#line 478 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp18_ = collection;
#line 478 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp19_ = prepped;
#line 478 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp19_);
#line 4249 "PhotoMetadata.c"
				}
#line 472 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (prepped);
#line 472 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (value);
#line 4255 "PhotoMetadata.c"
			}
		}
	}
#line 482 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp21_ = list;
#line 482 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp22_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection));
#line 482 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp23_ = _tmp22_;
#line 482 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp23_ > 0) {
#line 4267 "PhotoMetadata.c"
		GeeList* _tmp24_;
#line 482 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp24_ = list;
#line 482 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp20_ = _tmp24_;
#line 4273 "PhotoMetadata.c"
	} else {
#line 482 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp20_ = NULL;
#line 4277 "PhotoMetadata.c"
	}
#line 482 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp25_ = _g_object_ref0 (_tmp20_);
#line 482 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp25_;
#line 482 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (collection);
#line 482 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (list);
#line 482 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 482 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 4291 "PhotoMetadata.c"
}


GeeList*
photo_metadata_get_first_string_multiple (PhotoMetadata* self,
                                          gchar** tags,
                                          int tags_length1)
{
	GeeList* result = NULL;
#line 491 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 4303 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 492 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = tags;
#line 492 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = tags_length1;
#line 492 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < tags_length1; tag_it = tag_it + 1) {
#line 4315 "PhotoMetadata.c"
			gchar* _tmp0_;
			gchar* tag = NULL;
#line 492 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp0_ = g_strdup (tag_collection[tag_it]);
#line 492 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp0_;
#line 4322 "PhotoMetadata.c"
			{
				GeeList* values = NULL;
				const gchar* _tmp1_;
				GeeList* _tmp2_;
				gboolean _tmp3_ = FALSE;
				GeeList* _tmp4_;
#line 493 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp1_ = tag;
#line 493 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = photo_metadata_get_string_multiple (self, _tmp1_);
#line 493 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				values = _tmp2_;
#line 494 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp4_ = values;
#line 494 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp4_ != NULL) {
#line 4339 "PhotoMetadata.c"
					GeeList* _tmp5_;
					gint _tmp6_;
					gint _tmp7_;
#line 494 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp5_ = values;
#line 494 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp6_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
#line 494 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp7_ = _tmp6_;
#line 494 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp3_ = _tmp7_ > 0;
#line 4351 "PhotoMetadata.c"
				} else {
#line 494 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp3_ = FALSE;
#line 4355 "PhotoMetadata.c"
				}
#line 494 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp3_) {
#line 495 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					result = values;
#line 495 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_free0 (tag);
#line 495 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					return result;
#line 4365 "PhotoMetadata.c"
				}
#line 492 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_object_unref0 (values);
#line 492 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 4371 "PhotoMetadata.c"
			}
		}
	}
#line 498 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = NULL;
#line 498 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 4379 "PhotoMetadata.c"
}


void
photo_metadata_set_string (PhotoMetadata* self,
                           const gchar* tag,
                           const gchar* value,
                           PrepareInputTextOptions options)
{
	gchar* prepped = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GExiv2Metadata* _tmp2_;
	const gchar* _tmp3_;
#line 501 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 501 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 501 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (value != NULL);
#line 502 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = prepare_input_text (value, options, DEFAULT_USER_TEXT_INPUT_LENGTH);
#line 502 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	prepped = _tmp0_;
#line 503 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = prepped;
#line 503 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp1_ == NULL) {
#line 504 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_warning ("PhotoMetadata.vala:504: Not setting tag %s to string %s: invalid UTF-8", tag, value);
#line 506 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (prepped);
#line 506 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 4414 "PhotoMetadata.c"
	}
#line 509 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = self->priv->exiv2;
#line 509 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = prepped;
#line 509 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!gexiv2_metadata_set_tag_string (_tmp2_, tag, _tmp3_)) {
#line 4422 "PhotoMetadata.c"
		const gchar* _tmp4_;
#line 510 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = self->priv->source_name;
#line 510 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_warning ("PhotoMetadata.vala:510: Unable to set tag %s to string %s from source " \
"%s", tag, value, _tmp4_);
#line 4428 "PhotoMetadata.c"
	}
#line 501 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (prepped);
#line 4432 "PhotoMetadata.c"
}


static void
photo_metadata_set_all_generic (PhotoMetadata* self,
                                gchar** tags,
                                int tags_length1,
                                PhotoMetadataSetOption option,
                                PhotoMetadataSetGenericValue setter,
                                void* setter_target)
{
	gboolean written = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
#line 515 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 516 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	written = FALSE;
#line 4451 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 517 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = tags;
#line 517 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = tags_length1;
#line 517 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < tags_length1; tag_it = tag_it + 1) {
#line 4463 "PhotoMetadata.c"
			gchar* _tmp0_;
			gchar* tag = NULL;
#line 517 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp0_ = g_strdup (tag_collection[tag_it]);
#line 517 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp0_;
#line 4470 "PhotoMetadata.c"
			{
				gboolean _tmp1_ = FALSE;
#line 518 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (option == PHOTO_METADATA_SET_OPTION_ALL_DOMAINS) {
#line 518 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp1_ = TRUE;
#line 4477 "PhotoMetadata.c"
				} else {
					const gchar* _tmp2_;
#line 518 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp2_ = tag;
#line 518 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp1_ = photo_metadata_has_domain (self, photo_metadata_get_tag_domain (_tmp2_));
#line 4484 "PhotoMetadata.c"
				}
#line 518 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp1_) {
#line 4488 "PhotoMetadata.c"
					const gchar* _tmp3_;
#line 519 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp3_ = tag;
#line 519 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					setter (_tmp3_, setter_target);
#line 520 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					written = TRUE;
#line 4496 "PhotoMetadata.c"
				}
#line 517 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 4500 "PhotoMetadata.c"
			}
		}
	}
#line 524 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (option == PHOTO_METADATA_SET_OPTION_AT_LEAST_DEFAULT_DOMAIN) {
#line 4506 "PhotoMetadata.c"
		gboolean _tmp6_;
#line 524 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = written;
#line 524 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = !_tmp6_;
#line 4512 "PhotoMetadata.c"
	} else {
#line 524 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = FALSE;
#line 4516 "PhotoMetadata.c"
	}
#line 524 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp5_) {
#line 524 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = tags_length1 > 0;
#line 4522 "PhotoMetadata.c"
	} else {
#line 524 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = FALSE;
#line 4526 "PhotoMetadata.c"
	}
#line 524 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp4_) {
#line 4530 "PhotoMetadata.c"
		MetadataDomain default_domain = 0;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
#line 525 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = tags[0];
#line 525 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		default_domain = photo_metadata_get_tag_domain (_tmp7_);
#line 528 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp8_ = tags[0];
#line 528 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		setter (_tmp8_, setter_target);
#line 4542 "PhotoMetadata.c"
		{
			gint ctr = 0;
#line 531 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			ctr = 1;
#line 4547 "PhotoMetadata.c"
			{
				gboolean _tmp9_ = FALSE;
#line 531 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp9_ = TRUE;
#line 531 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				while (TRUE) {
#line 4554 "PhotoMetadata.c"
					gint _tmp11_;
					gint _tmp12_;
					const gchar* _tmp13_;
					MetadataDomain _tmp14_;
#line 531 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					if (!_tmp9_) {
#line 4561 "PhotoMetadata.c"
						gint _tmp10_;
#line 531 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp10_ = ctr;
#line 531 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						ctr = _tmp10_ + 1;
#line 4567 "PhotoMetadata.c"
					}
#line 531 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp9_ = FALSE;
#line 531 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp11_ = ctr;
#line 531 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					if (!(_tmp11_ < tags_length1)) {
#line 531 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						break;
#line 4577 "PhotoMetadata.c"
					}
#line 532 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp12_ = ctr;
#line 532 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp13_ = tags[_tmp12_];
#line 532 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp14_ = default_domain;
#line 532 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					if (photo_metadata_get_tag_domain (_tmp13_) == _tmp14_) {
#line 4587 "PhotoMetadata.c"
						gint _tmp15_;
						const gchar* _tmp16_;
#line 533 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp15_ = ctr;
#line 533 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp16_ = tags[_tmp15_];
#line 533 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						setter (_tmp16_, setter_target);
#line 4596 "PhotoMetadata.c"
					}
				}
			}
		}
	}
}


static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
#line 538 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 538 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return _data1_;
#line 4612 "PhotoMetadata.c"
}


static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 538 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 4623 "PhotoMetadata.c"
		PhotoMetadata* self;
#line 538 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		self = _data1_->self;
#line 538 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_data1_->value);
#line 538 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_media_metadata_unref0 (self);
#line 538 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_slice_free (Block1Data, _data1_);
#line 4633 "PhotoMetadata.c"
	}
}


static void
__lambda5_ (Block1Data* _data1_,
            const gchar* tag)
{
	PhotoMetadata* self;
#line 539 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = _data1_->self;
#line 539 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 539 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_string (self, tag, _data1_->value, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 4649 "PhotoMetadata.c"
}


static void
___lambda5__photo_metadata_set_generic_value (const gchar* tag,
                                              gpointer self)
{
#line 539 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	__lambda5_ (self, tag);
#line 4659 "PhotoMetadata.c"
}


void
photo_metadata_set_all_string (PhotoMetadata* self,
                               gchar** tags,
                               int tags_length1,
                               const gchar* value,
                               PhotoMetadataSetOption option)
{
	Block1Data* _data1_;
	gchar* _tmp0_;
#line 538 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 538 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (value != NULL);
#line 538 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 538 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data1_->_ref_count_ = 1;
#line 538 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data1_->self = media_metadata_ref (self);
#line 538 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = g_strdup (value);
#line 538 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_data1_->value);
#line 538 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data1_->value = _tmp0_;
#line 539 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_all_generic (self, tags, tags_length1, option, ___lambda5__photo_metadata_set_generic_value, _data1_);
#line 538 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	block1_data_unref (_data1_);
#line 538 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data1_ = NULL;
#line 4694 "PhotoMetadata.c"
}


static void
_vala_array_add48 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
#line 547 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if ((*length) == (*size)) {
#line 547 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 547 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 4710 "PhotoMetadata.c"
	}
#line 547 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	(*array)[(*length)++] = value;
#line 547 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	(*array)[*length] = NULL;
#line 4716 "PhotoMetadata.c"
}


static void
_vala_array_add49 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
#line 559 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if ((*length) == (*size)) {
#line 559 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 559 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 4732 "PhotoMetadata.c"
	}
#line 559 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	(*array)[(*length)++] = value;
#line 559 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	(*array)[*length] = NULL;
#line 4738 "PhotoMetadata.c"
}


void
photo_metadata_set_string_multiple (PhotoMetadata* self,
                                    const gchar* tag,
                                    GeeCollection* collection)
{
	gchar** values = NULL;
	gchar** _tmp0_;
	gint values_length1;
	gint _values_size_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar** _tmp13_;
	gint _tmp13__length1;
	GExiv2Metadata* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
#line 542 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 542 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 542 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (GEE_IS_COLLECTION (collection));
#line 543 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 543 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	values = _tmp0_;
#line 543 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	values_length1 = 0;
#line 543 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_values_size_ = values_length1;
#line 4772 "PhotoMetadata.c"
	{
		GeeIterator* _value_it = NULL;
		GeeIterator* _tmp1_;
#line 544 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (collection, GEE_TYPE_ITERABLE, GeeIterable));
#line 544 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_value_it = _tmp1_;
#line 544 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		while (TRUE) {
#line 4782 "PhotoMetadata.c"
			GeeIterator* _tmp2_;
			gchar* value = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			gchar* prepped = NULL;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			const gchar* _tmp7_;
#line 544 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp2_ = _value_it;
#line 544 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			if (!gee_iterator_next (_tmp2_)) {
#line 544 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				break;
#line 4797 "PhotoMetadata.c"
			}
#line 544 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp3_ = _value_it;
#line 544 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp4_ = gee_iterator_get (_tmp3_);
#line 544 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			value = (gchar*) _tmp4_;
#line 545 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp5_ = value;
#line 545 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp6_ = prepare_input_text (_tmp5_, PHOTO_METADATA_PREPARE_STRING_OPTIONS, -1);
#line 545 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			prepped = _tmp6_;
#line 546 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp7_ = prepped;
#line 546 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			if (_tmp7_ != NULL) {
#line 4815 "PhotoMetadata.c"
				gchar** _tmp8_;
				gint _tmp8__length1;
				const gchar* _tmp9_;
				gchar* _tmp10_;
#line 547 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp8_ = values;
#line 547 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp8__length1 = values_length1;
#line 547 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp9_ = prepped;
#line 547 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp10_ = g_strdup (_tmp9_);
#line 547 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_vala_array_add48 (&values, &values_length1, &_values_size_, _tmp10_);
#line 4830 "PhotoMetadata.c"
			} else {
				const gchar* _tmp11_;
#line 549 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp11_ = value;
#line 549 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				g_warning ("PhotoMetadata.vala:549: Unable to set string %s to %s: invalid UTF-8", _tmp11_, tag);
#line 4837 "PhotoMetadata.c"
			}
#line 544 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_g_free0 (prepped);
#line 544 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_g_free0 (value);
#line 4843 "PhotoMetadata.c"
		}
#line 544 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_object_unref0 (_value_it);
#line 4847 "PhotoMetadata.c"
	}
#line 552 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12_ = values;
#line 552 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12__length1 = values_length1;
#line 552 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp12__length1 == 0) {
#line 553 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 553 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 4859 "PhotoMetadata.c"
	}
#line 559 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13_ = values;
#line 559 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13__length1 = values_length1;
#line 559 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_array_add49 (&values, &values_length1, &_values_size_, NULL);
#line 561 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp14_ = self->priv->exiv2;
#line 561 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp15_ = values;
#line 561 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp15__length1 = values_length1;
#line 561 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!gexiv2_metadata_set_tag_multiple (_tmp14_, tag, _tmp15_)) {
#line 4875 "PhotoMetadata.c"
		gchar** _tmp16_;
		gint _tmp16__length1;
		const gchar* _tmp17_;
#line 562 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp16_ = values;
#line 562 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp16__length1 = values_length1;
#line 562 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp17_ = self->priv->source_name;
#line 562 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_warning ("PhotoMetadata.vala:562: Unable to set %d strings to tag %s from source" \
" %s", _tmp16__length1, tag, _tmp17_);
#line 4887 "PhotoMetadata.c"
	}
#line 542 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 4891 "PhotoMetadata.c"
}


static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
#line 565 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 565 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return _data2_;
#line 4902 "PhotoMetadata.c"
}


static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 565 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 4913 "PhotoMetadata.c"
		PhotoMetadata* self;
#line 565 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		self = _data2_->self;
#line 565 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_object_unref0 (_data2_->values);
#line 565 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_media_metadata_unref0 (self);
#line 565 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_slice_free (Block2Data, _data2_);
#line 4923 "PhotoMetadata.c"
	}
}


static void
__lambda6_ (Block2Data* _data2_,
            const gchar* tag)
{
	PhotoMetadata* self;
#line 566 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = _data2_->self;
#line 566 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 566 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_string_multiple (self, tag, _data2_->values);
#line 4939 "PhotoMetadata.c"
}


static void
___lambda6__photo_metadata_set_generic_value (const gchar* tag,
                                              gpointer self)
{
#line 566 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	__lambda6_ (self, tag);
#line 4949 "PhotoMetadata.c"
}


void
photo_metadata_set_all_string_multiple (PhotoMetadata* self,
                                        gchar** tags,
                                        int tags_length1,
                                        GeeCollection* values,
                                        PhotoMetadataSetOption option)
{
	Block2Data* _data2_;
	GeeCollection* _tmp0_;
#line 565 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 565 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (GEE_IS_COLLECTION (values));
#line 565 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 565 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data2_->_ref_count_ = 1;
#line 565 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data2_->self = media_metadata_ref (self);
#line 565 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = _g_object_ref0 (values);
#line 565 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (_data2_->values);
#line 565 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data2_->values = _tmp0_;
#line 566 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_all_generic (self, tags, tags_length1, option, ___lambda6__photo_metadata_set_generic_value, _data2_);
#line 565 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	block2_data_unref (_data2_);
#line 565 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data2_ = NULL;
#line 4984 "PhotoMetadata.c"
}


gboolean
photo_metadata_get_long (PhotoMetadata* self,
                         const gchar* tag,
                         glong* value)
{
	glong _vala_value = 0L;
	gboolean result = FALSE;
	GExiv2Metadata* _tmp0_;
#line 569 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 569 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, FALSE);
#line 570 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!photo_metadata_has_tag (self, tag)) {
#line 571 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_vala_value = (glong) 0;
#line 573 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = FALSE;
#line 573 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (value) {
#line 573 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*value = _vala_value;
#line 5010 "PhotoMetadata.c"
		}
#line 573 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 5014 "PhotoMetadata.c"
	}
#line 576 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 576 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_value = gexiv2_metadata_get_tag_long (_tmp0_, tag);
#line 578 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = TRUE;
#line 578 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (value) {
#line 578 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*value = _vala_value;
#line 5026 "PhotoMetadata.c"
	}
#line 578 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 5030 "PhotoMetadata.c"
}


gboolean
photo_metadata_get_first_long (PhotoMetadata* self,
                               gchar** tags,
                               int tags_length1,
                               glong* value)
{
	glong _vala_value = 0L;
	gboolean result = FALSE;
#line 581 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 5044 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 582 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = tags;
#line 582 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = tags_length1;
#line 582 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < tags_length1; tag_it = tag_it + 1) {
#line 5056 "PhotoMetadata.c"
			gchar* _tmp0_;
			gchar* tag = NULL;
#line 582 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp0_ = g_strdup (tag_collection[tag_it]);
#line 582 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp0_;
#line 5063 "PhotoMetadata.c"
			{
				const gchar* _tmp1_;
				glong _tmp2_ = 0L;
				gboolean _tmp3_;
#line 583 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp1_ = tag;
#line 583 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = photo_metadata_get_long (self, _tmp1_, &_tmp2_);
#line 583 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_vala_value = _tmp2_;
#line 583 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp3_) {
#line 584 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					result = TRUE;
#line 584 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_free0 (tag);
#line 584 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					if (value) {
#line 584 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						*value = _vala_value;
#line 5084 "PhotoMetadata.c"
					}
#line 584 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					return result;
#line 5088 "PhotoMetadata.c"
				}
#line 582 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 5092 "PhotoMetadata.c"
			}
		}
	}
#line 587 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_value = (glong) 0;
#line 589 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = FALSE;
#line 589 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (value) {
#line 589 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*value = _vala_value;
#line 5104 "PhotoMetadata.c"
	}
#line 589 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 5108 "PhotoMetadata.c"
}


void
photo_metadata_set_long (PhotoMetadata* self,
                         const gchar* tag,
                         glong value)
{
	GExiv2Metadata* _tmp0_;
#line 592 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 592 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 593 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 593 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!gexiv2_metadata_set_tag_long (_tmp0_, tag, value)) {
#line 5126 "PhotoMetadata.c"
		const gchar* _tmp1_;
#line 594 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = self->priv->source_name;
#line 594 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_warning ("PhotoMetadata.vala:594: Unable to set tag %s to long %ld from source %" \
"s", tag, value, _tmp1_);
#line 5132 "PhotoMetadata.c"
	}
}


static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
#line 597 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 597 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return _data3_;
#line 5144 "PhotoMetadata.c"
}


static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 597 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 5155 "PhotoMetadata.c"
		PhotoMetadata* self;
#line 597 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		self = _data3_->self;
#line 597 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_media_metadata_unref0 (self);
#line 597 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_slice_free (Block3Data, _data3_);
#line 5163 "PhotoMetadata.c"
	}
}


static void
__lambda7_ (Block3Data* _data3_,
            const gchar* tag)
{
	PhotoMetadata* self;
#line 598 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = _data3_->self;
#line 598 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 598 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_long (self, tag, _data3_->value);
#line 5179 "PhotoMetadata.c"
}


static void
___lambda7__photo_metadata_set_generic_value (const gchar* tag,
                                              gpointer self)
{
#line 598 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	__lambda7_ (self, tag);
#line 5189 "PhotoMetadata.c"
}


void
photo_metadata_set_all_long (PhotoMetadata* self,
                             gchar** tags,
                             int tags_length1,
                             glong value,
                             PhotoMetadataSetOption option)
{
	Block3Data* _data3_;
#line 597 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 597 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 597 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data3_->_ref_count_ = 1;
#line 597 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data3_->self = media_metadata_ref (self);
#line 597 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data3_->value = value;
#line 598 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_all_generic (self, tags, tags_length1, option, ___lambda7__photo_metadata_set_generic_value, _data3_);
#line 597 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	block3_data_unref (_data3_);
#line 597 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data3_ = NULL;
#line 5217 "PhotoMetadata.c"
}


gboolean
photo_metadata_get_rational (PhotoMetadata* self,
                             const gchar* tag,
                             MetadataRational* rational)
{
	MetadataRational _vala_rational = {0};
	gboolean result = FALSE;
	gint numerator = 0;
	gint denominator = 0;
	gboolean _result_ = FALSE;
	GExiv2Metadata* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean _tmp3_;
#line 601 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 601 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, FALSE);
#line 603 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 603 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = gexiv2_metadata_get_exif_tag_rational (_tmp0_, tag, &_tmp1_, &_tmp2_);
#line 603 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	numerator = _tmp1_;
#line 603 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	denominator = _tmp2_;
#line 603 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_result_ = _tmp3_;
#line 605 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	metadata_rational_init (&_vala_rational, numerator, denominator);
#line 607 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _result_;
#line 607 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (rational) {
#line 607 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*rational = _vala_rational;
#line 5257 "PhotoMetadata.c"
	}
#line 607 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 5261 "PhotoMetadata.c"
}


gboolean
photo_metadata_get_first_rational (PhotoMetadata* self,
                                   gchar** tags,
                                   int tags_length1,
                                   MetadataRational* rational)
{
	MetadataRational _vala_rational = {0};
	gboolean result = FALSE;
#line 610 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 5275 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 611 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = tags;
#line 611 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = tags_length1;
#line 611 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < tags_length1; tag_it = tag_it + 1) {
#line 5287 "PhotoMetadata.c"
			gchar* _tmp0_;
			gchar* tag = NULL;
#line 611 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp0_ = g_strdup (tag_collection[tag_it]);
#line 611 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp0_;
#line 5294 "PhotoMetadata.c"
			{
				const gchar* _tmp1_;
				MetadataRational _tmp2_ = {0};
				gboolean _tmp3_;
#line 612 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp1_ = tag;
#line 612 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = photo_metadata_get_rational (self, _tmp1_, &_tmp2_);
#line 612 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_vala_rational = _tmp2_;
#line 612 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp3_) {
#line 613 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					result = TRUE;
#line 613 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_free0 (tag);
#line 613 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					if (rational) {
#line 613 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						*rational = _vala_rational;
#line 5315 "PhotoMetadata.c"
					}
#line 613 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					return result;
#line 5319 "PhotoMetadata.c"
				}
#line 611 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 5323 "PhotoMetadata.c"
			}
		}
	}
#line 616 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	metadata_rational_init (&_vala_rational, 0, 0);
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = FALSE;
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (rational) {
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*rational = _vala_rational;
#line 5335 "PhotoMetadata.c"
	}
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 5339 "PhotoMetadata.c"
}


void
photo_metadata_set_rational (PhotoMetadata* self,
                             const gchar* tag,
                             MetadataRational* rational)
{
	GExiv2Metadata* _tmp0_;
	MetadataRational _tmp1_;
	gint _tmp2_;
	MetadataRational _tmp3_;
	gint _tmp4_;
#line 621 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 621 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 621 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (rational != NULL);
#line 622 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 622 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = *rational;
#line 622 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = _tmp1_.numerator;
#line 622 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = *rational;
#line 622 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = _tmp3_.denominator;
#line 622 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!gexiv2_metadata_set_exif_tag_rational (_tmp0_, tag, _tmp2_, _tmp4_)) {
#line 5371 "PhotoMetadata.c"
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
#line 623 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = metadata_rational_to_string (rational);
#line 623 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = _tmp5_;
#line 623 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = self->priv->source_name;
#line 623 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_warning ("PhotoMetadata.vala:623: Unable to set tag %s to rational %s from sourc" \
"e %s", tag, _tmp6_, _tmp7_);
#line 623 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_tmp6_);
#line 5385 "PhotoMetadata.c"
	}
}


static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
#line 628 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 628 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return _data4_;
#line 5397 "PhotoMetadata.c"
}


static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 628 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 5408 "PhotoMetadata.c"
		PhotoMetadata* self;
#line 628 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		self = _data4_->self;
#line 628 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_media_metadata_unref0 (self);
#line 628 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_slice_free (Block4Data, _data4_);
#line 5416 "PhotoMetadata.c"
	}
}


static void
__lambda8_ (Block4Data* _data4_,
            const gchar* tag)
{
	PhotoMetadata* self;
	MetadataRational _tmp0_;
#line 629 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = _data4_->self;
#line 629 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 629 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = _data4_->rational;
#line 629 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_rational (self, tag, &_tmp0_);
#line 5435 "PhotoMetadata.c"
}


static void
___lambda8__photo_metadata_set_generic_value (const gchar* tag,
                                              gpointer self)
{
#line 629 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	__lambda8_ (self, tag);
#line 5445 "PhotoMetadata.c"
}


void
photo_metadata_set_all_rational (PhotoMetadata* self,
                                 gchar** tags,
                                 int tags_length1,
                                 MetadataRational* rational,
                                 PhotoMetadataSetOption option)
{
	Block4Data* _data4_;
	MetadataRational _tmp0_;
#line 628 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 628 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (rational != NULL);
#line 628 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 628 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data4_->_ref_count_ = 1;
#line 628 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data4_->self = media_metadata_ref (self);
#line 628 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = *rational;
#line 628 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data4_->rational = _tmp0_;
#line 629 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_all_generic (self, tags, tags_length1, option, ___lambda8__photo_metadata_set_generic_value, _data4_);
#line 628 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	block4_data_unref (_data4_);
#line 628 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data4_ = NULL;
#line 5478 "PhotoMetadata.c"
}


MetadataDateTime*
photo_metadata_get_date_time (PhotoMetadata* self,
                              const gchar* tag)
{
	MetadataDateTime* result = NULL;
	gchar* value = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GError * _inner_error_ = NULL;
#line 632 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 632 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 633 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_string (self, tag, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 633 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	value = _tmp0_;
#line 634 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = value;
#line 634 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp1_ == NULL) {
#line 635 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 635 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (value);
#line 635 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 5509 "PhotoMetadata.c"
	}
	{
#line 638 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		switch (photo_metadata_get_tag_domain (tag)) {
#line 638 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			case METADATA_DOMAIN_XMP:
#line 5516 "PhotoMetadata.c"
			{
				MetadataDateTime* _tmp2_ = NULL;
				const gchar* _tmp3_;
				MetadataDateTime* _tmp4_;
				MetadataDateTime* _tmp5_;
#line 640 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = value;
#line 640 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp4_ = metadata_date_time_new_from_xmp (_tmp3_, &_inner_error_);
#line 640 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = _tmp4_;
#line 640 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5530 "PhotoMetadata.c"
					goto __catch30_g_error;
				}
#line 640 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp5_ = _tmp2_;
#line 640 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = NULL;
#line 640 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				result = _tmp5_;
#line 640 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_metadata_date_time_unref0 (_tmp2_);
#line 640 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (value);
#line 640 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				return result;
#line 5545 "PhotoMetadata.c"
			}
#line 638 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			case METADATA_DOMAIN_IPTC:
#line 5549 "PhotoMetadata.c"
			{
#line 645 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				result = NULL;
#line 645 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (value);
#line 645 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				return result;
#line 5557 "PhotoMetadata.c"
			}
			default:
#line 638 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			case METADATA_DOMAIN_EXIF:
#line 5562 "PhotoMetadata.c"
			{
				MetadataDateTime* _tmp6_ = NULL;
				const gchar* _tmp7_;
				MetadataDateTime* _tmp8_;
				MetadataDateTime* _tmp9_;
#line 649 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp7_ = value;
#line 649 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp8_ = metadata_date_time_new_from_exif (_tmp7_, &_inner_error_);
#line 649 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp6_ = _tmp8_;
#line 649 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5576 "PhotoMetadata.c"
					goto __catch30_g_error;
				}
#line 649 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp9_ = _tmp6_;
#line 649 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp6_ = NULL;
#line 649 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				result = _tmp9_;
#line 649 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_metadata_date_time_unref0 (_tmp6_);
#line 649 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (value);
#line 649 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				return result;
#line 5591 "PhotoMetadata.c"
			}
		}
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
#line 637 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		err = _inner_error_;
#line 637 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_inner_error_ = NULL;
#line 652 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = self->priv->source_name;
#line 652 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp11_ = err;
#line 652 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp12_ = _tmp11_->message;
#line 652 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_warning ("PhotoMetadata.vala:652: Unable to read date/time %s from source %s: %s", tag, _tmp10_, _tmp12_);
#line 654 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 654 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_error_free0 (err);
#line 654 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (value);
#line 654 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 5622 "PhotoMetadata.c"
	}
	__finally30:
#line 637 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (value);
#line 637 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 637 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_clear_error (&_inner_error_);
#line 637 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 5633 "PhotoMetadata.c"
}


MetadataDateTime*
photo_metadata_get_first_date_time (PhotoMetadata* self,
                                    gchar** tags,
                                    int tags_length1)
{
	MetadataDateTime* result = NULL;
#line 658 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 5645 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 659 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = tags;
#line 659 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = tags_length1;
#line 659 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < tags_length1; tag_it = tag_it + 1) {
#line 5657 "PhotoMetadata.c"
			gchar* _tmp0_;
			gchar* tag = NULL;
#line 659 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp0_ = g_strdup (tag_collection[tag_it]);
#line 659 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp0_;
#line 5664 "PhotoMetadata.c"
			{
				MetadataDateTime* date_time = NULL;
				const gchar* _tmp1_;
				MetadataDateTime* _tmp2_;
				MetadataDateTime* _tmp3_;
#line 660 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp1_ = tag;
#line 660 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = photo_metadata_get_date_time (self, _tmp1_);
#line 660 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				date_time = _tmp2_;
#line 661 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = date_time;
#line 661 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp3_ != NULL) {
#line 662 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					result = date_time;
#line 662 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_free0 (tag);
#line 662 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					return result;
#line 5686 "PhotoMetadata.c"
				}
#line 659 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_metadata_date_time_unref0 (date_time);
#line 659 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 5692 "PhotoMetadata.c"
			}
		}
	}
#line 665 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = NULL;
#line 665 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 5700 "PhotoMetadata.c"
}


void
photo_metadata_set_date_time (PhotoMetadata* self,
                              const gchar* tag,
                              MetadataDateTime* date_time)
{
#line 668 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 668 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 668 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_METADATA_DATE_TIME (date_time));
#line 669 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	switch (photo_metadata_get_tag_domain (tag)) {
#line 669 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_EXIF:
#line 5719 "PhotoMetadata.c"
		{
			gchar* _tmp0_;
			gchar* _tmp1_;
#line 671 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp0_ = metadata_date_time_get_exif_label (date_time);
#line 671 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = _tmp0_;
#line 671 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			photo_metadata_set_string (self, tag, _tmp1_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 671 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_g_free0 (_tmp1_);
#line 672 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 5733 "PhotoMetadata.c"
		}
#line 669 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_XMP:
#line 5737 "PhotoMetadata.c"
		{
			gchar* _tmp2_;
			gchar* _tmp3_;
#line 675 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp2_ = metadata_date_time_get_xmp_label (date_time);
#line 675 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp3_ = _tmp2_;
#line 675 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			photo_metadata_set_string (self, tag, _tmp3_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 675 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_g_free0 (_tmp3_);
#line 676 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 5751 "PhotoMetadata.c"
		}
		default:
#line 669 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_IPTC:
#line 5756 "PhotoMetadata.c"
		{
			const gchar* _tmp4_;
			GEnumValue* _tmp5_;
#line 681 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp4_ = self->priv->source_name;
#line 682 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp5_ = g_enum_get_value (g_type_class_ref (TYPE_METADATA_DOMAIN), photo_metadata_get_tag_domain (tag));
#line 681 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			g_warning ("PhotoMetadata.vala:681: Cannot set date/time for %s from source %s: un" \
"supported metadata domain %s", tag, _tmp4_, (_tmp5_ != NULL) ? _tmp5_->value_name : NULL);
#line 683 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 5768 "PhotoMetadata.c"
		}
	}
}


static gpointer
_metadata_date_time_ref0 (gpointer self)
{
#line 687 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self ? metadata_date_time_ref (self) : NULL;
#line 5779 "PhotoMetadata.c"
}


static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
#line 687 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 687 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return _data5_;
#line 5790 "PhotoMetadata.c"
}


static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 687 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 5801 "PhotoMetadata.c"
		PhotoMetadata* self;
#line 687 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		self = _data5_->self;
#line 687 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_metadata_date_time_unref0 (_data5_->date_time);
#line 687 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_media_metadata_unref0 (self);
#line 687 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_slice_free (Block5Data, _data5_);
#line 5811 "PhotoMetadata.c"
	}
}


static void
__lambda9_ (Block5Data* _data5_,
            const gchar* tag)
{
	PhotoMetadata* self;
#line 688 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = _data5_->self;
#line 688 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 688 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_date_time (self, tag, _data5_->date_time);
#line 5827 "PhotoMetadata.c"
}


static void
___lambda9__photo_metadata_set_generic_value (const gchar* tag,
                                              gpointer self)
{
#line 688 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	__lambda9_ (self, tag);
#line 5837 "PhotoMetadata.c"
}


void
photo_metadata_set_all_date_time (PhotoMetadata* self,
                                  gchar** tags,
                                  int tags_length1,
                                  MetadataDateTime* date_time,
                                  PhotoMetadataSetOption option)
{
	Block5Data* _data5_;
	MetadataDateTime* _tmp0_;
#line 687 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 687 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_METADATA_DATE_TIME (date_time));
#line 687 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 687 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data5_->_ref_count_ = 1;
#line 687 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data5_->self = media_metadata_ref (self);
#line 687 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = _metadata_date_time_ref0 (date_time);
#line 687 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_metadata_date_time_unref0 (_data5_->date_time);
#line 687 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data5_->date_time = _tmp0_;
#line 688 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_all_generic (self, tags, tags_length1, option, ___lambda9__photo_metadata_set_generic_value, _data5_);
#line 687 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	block5_data_unref (_data5_);
#line 687 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data5_ = NULL;
#line 5872 "PhotoMetadata.c"
}


gchar*
photo_metadata_exif_hash (PhotoMetadata* self)
{
	gchar* result = NULL;
	ExifData* _tmp0_;
	const gchar* _tmp1_;
	gchar* hash = NULL;
	guchar* thumb = NULL;
	ExifData* _tmp4_;
	guchar* _tmp5_;
	guint thumb_size = 0U;
	ExifData* _tmp6_;
	guint _tmp7_;
	ExifData* _tmp8_;
	ExifData* _tmp9_;
	guchar* saved_data = NULL;
	guint saved_size = 0U;
	ExifData* _tmp10_;
	ExifData* _tmp11_;
	guchar* _tmp12_;
	ExifData* _tmp13_;
	guint _tmp14_;
	gboolean _tmp15_ = FALSE;
	guint _tmp16_;
#line 692 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 693 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exif;
#line 693 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp0_ == NULL) {
#line 694 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 694 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 5910 "PhotoMetadata.c"
	}
#line 696 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = self->priv->metadata_hash;
#line 696 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp1_ != NULL) {
#line 5916 "PhotoMetadata.c"
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 697 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = self->priv->metadata_hash;
#line 697 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 697 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = _tmp3_;
#line 697 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 5927 "PhotoMetadata.c"
	}
#line 700 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	hash = NULL;
#line 702 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = self->priv->exif;
#line 702 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = _tmp4_->data;
#line 702 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	thumb = _tmp5_;
#line 703 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = self->priv->exif;
#line 703 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = _tmp6_->size;
#line 703 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	thumb_size = _tmp7_;
#line 706 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = self->priv->exif;
#line 706 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_->data = NULL;
#line 707 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = self->priv->exif;
#line 707 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_->size = (guint) 0;
#line 709 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	saved_data = NULL;
#line 710 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	saved_size = (guint) 0;
#line 712 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_ = self->priv->exif;
#line 712 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	exif_data_save_data (_tmp10_, &saved_data, &saved_size);
#line 714 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_ = self->priv->exif;
#line 714 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12_ = thumb;
#line 714 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_->data = _tmp12_;
#line 715 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13_ = self->priv->exif;
#line 715 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp14_ = thumb_size;
#line 715 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13_->size = _tmp14_;
#line 717 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp16_ = saved_size;
#line 717 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp16_ > ((guint) 0)) {
#line 5975 "PhotoMetadata.c"
		guchar* _tmp17_;
#line 717 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp17_ = saved_data;
#line 717 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp15_ = _tmp17_ != NULL;
#line 5981 "PhotoMetadata.c"
	} else {
#line 717 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp15_ = FALSE;
#line 5985 "PhotoMetadata.c"
	}
#line 717 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp15_) {
#line 5989 "PhotoMetadata.c"
		GChecksum* md5 = NULL;
		GChecksum* _tmp18_;
		GChecksum* _tmp19_;
		guchar* _tmp20_;
		guint _tmp21_;
		ExifMem* _tmp22_;
		ExifMem* _tmp23_;
		guchar* _tmp24_;
		GChecksum* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
#line 718 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp18_ = g_checksum_new (G_CHECKSUM_MD5);
#line 718 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		md5 = _tmp18_;
#line 719 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp19_ = md5;
#line 719 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp20_ = saved_data;
#line 719 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp21_ = saved_size;
#line 719 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_checksum_update (_tmp19_, (guchar*) _tmp20_, (gsize) _tmp21_);
#line 720 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp22_ = exif_mem_new_default ();
#line 720 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp23_ = _tmp22_;
#line 720 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp24_ = saved_data;
#line 720 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		exif_mem_free (_tmp23_, _tmp24_);
#line 720 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_exif_mem_unref0 (_tmp23_);
#line 722 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp25_ = md5;
#line 722 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp26_ = g_checksum_get_string (_tmp25_);
#line 722 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp27_ = g_strdup (_tmp26_);
#line 722 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (self->priv->metadata_hash);
#line 722 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		self->priv->metadata_hash = _tmp27_;
#line 717 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_checksum_free0 (md5);
#line 6035 "PhotoMetadata.c"
	}
#line 725 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = hash;
#line 725 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 6041 "PhotoMetadata.c"
}


gchar*
photo_metadata_thumbnail_hash (PhotoMetadata* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	guchar* buffer = NULL;
	gint buffer_length1 = 0;
	gint _buffer_size_ = 0;
	GExiv2Metadata* _tmp3_;
	guint8* _tmp4_ = NULL;
	gint _tmp5_;
	gboolean _tmp6_;
#line 729 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->thumbnail_md5;
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp0_ != NULL) {
#line 6063 "PhotoMetadata.c"
		const gchar* _tmp1_;
		gchar* _tmp2_;
#line 731 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = self->priv->thumbnail_md5;
#line 731 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = g_strdup (_tmp1_);
#line 731 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = _tmp2_;
#line 731 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 6074 "PhotoMetadata.c"
	}
#line 735 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = self->priv->exiv2;
#line 735 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = gexiv2_metadata_get_exif_thumbnail (_tmp3_, &_tmp4_, &_tmp5_);
#line 735 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	buffer = (g_free (buffer), NULL);
#line 735 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	buffer = _tmp4_;
#line 735 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	buffer_length1 = _tmp5_;
#line 735 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_buffer_size_ = buffer_length1;
#line 735 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp6_) {
#line 6090 "PhotoMetadata.c"
		GChecksum* md5 = NULL;
		GChecksum* _tmp7_;
		GChecksum* _tmp8_;
		guchar* _tmp9_;
		gint _tmp9__length1;
		guchar* _tmp10_;
		gint _tmp10__length1;
		GChecksum* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
#line 736 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = g_checksum_new (G_CHECKSUM_MD5);
#line 736 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		md5 = _tmp7_;
#line 737 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp8_ = md5;
#line 737 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = buffer;
#line 737 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9__length1 = buffer_length1;
#line 737 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = buffer;
#line 737 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10__length1 = buffer_length1;
#line 737 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_checksum_update (_tmp8_, _tmp9_, (gsize) _tmp10__length1);
#line 739 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp11_ = md5;
#line 739 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp12_ = g_checksum_get_string (_tmp11_);
#line 739 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp13_ = g_strdup (_tmp12_);
#line 739 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (self->priv->thumbnail_md5);
#line 739 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		self->priv->thumbnail_md5 = _tmp13_;
#line 741 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp14_ = self->priv->thumbnail_md5;
#line 741 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp15_ = g_strdup (_tmp14_);
#line 741 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = _tmp15_;
#line 741 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_checksum_free0 (md5);
#line 741 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		buffer = (g_free (buffer), NULL);
#line 741 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 6141 "PhotoMetadata.c"
	}
#line 744 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = NULL;
#line 744 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	buffer = (g_free (buffer), NULL);
#line 744 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 6149 "PhotoMetadata.c"
}


guint
photo_metadata_get_preview_count (PhotoMetadata* self)
{
	guint result = 0U;
	GExiv2PreviewProperties** props = NULL;
	GExiv2Metadata* _tmp0_;
	GExiv2PreviewProperties** _tmp1_;
	GExiv2PreviewProperties** _tmp2_;
	gint props_length1;
	gint _props_size_;
	gint _tmp3_ = 0;
	GExiv2PreviewProperties** _tmp4_;
	gint _tmp4__length1;
#line 747 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), 0U);
#line 748 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 748 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = _tmp1_ = gexiv2_metadata_get_preview_properties (_tmp0_);
#line 748 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	props = _tmp2_;
#line 748 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	props_length1 = _vala_array_length (_tmp1_);
#line 748 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_props_size_ = props_length1;
#line 750 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = props;
#line 750 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4__length1 = props_length1;
#line 750 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp4_ != NULL) {
#line 6184 "PhotoMetadata.c"
		GExiv2PreviewProperties** _tmp5_;
		gint _tmp5__length1;
#line 750 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = props;
#line 750 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5__length1 = props_length1;
#line 750 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = _tmp5__length1;
#line 6193 "PhotoMetadata.c"
	} else {
#line 750 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = 0;
#line 6197 "PhotoMetadata.c"
	}
#line 750 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = (guint) _tmp3_;
#line 750 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 6203 "PhotoMetadata.c"
}


PhotoPreview*
photo_metadata_get_preview (PhotoMetadata* self,
                            guint number)
{
	PhotoPreview* result = NULL;
	GExiv2PreviewProperties** props = NULL;
	GExiv2Metadata* _tmp0_;
	GExiv2PreviewProperties** _tmp1_;
	GExiv2PreviewProperties** _tmp2_;
	gint props_length1;
	gint _props_size_;
	gboolean _tmp3_ = FALSE;
	GExiv2PreviewProperties** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp6_;
	GExiv2PreviewProperties** _tmp7_;
	gint _tmp7__length1;
	GExiv2PreviewProperties* _tmp8_;
	PhotoMetadataInternalPhotoPreview* _tmp9_;
#line 754 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 755 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 755 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = _tmp1_ = gexiv2_metadata_get_preview_properties (_tmp0_);
#line 755 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	props = _tmp2_;
#line 755 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	props_length1 = _vala_array_length (_tmp1_);
#line 755 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_props_size_ = props_length1;
#line 756 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = props;
#line 756 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4__length1 = props_length1;
#line 756 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp4_ == NULL) {
#line 756 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = TRUE;
#line 6246 "PhotoMetadata.c"
	} else {
		GExiv2PreviewProperties** _tmp5_;
		gint _tmp5__length1;
#line 756 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = props;
#line 756 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5__length1 = props_length1;
#line 756 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = ((guint) _tmp5__length1) <= number;
#line 6256 "PhotoMetadata.c"
	}
#line 756 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp3_) {
#line 757 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 757 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 6264 "PhotoMetadata.c"
	}
#line 759 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = self->priv->source_name;
#line 759 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = props;
#line 759 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7__length1 = props_length1;
#line 759 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = _tmp7_[number];
#line 759 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = photo_metadata_internal_photo_preview_new (self, _tmp6_, number, _tmp8_);
#line 759 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_PHOTO_PREVIEW, PhotoPreview);
#line 759 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 6280 "PhotoMetadata.c"
}


void
photo_metadata_remove_exif_thumbnail (PhotoMetadata* self)
{
	GExiv2Metadata* _tmp0_;
	ExifData* _tmp1_;
#line 762 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 763 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 763 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gexiv2_metadata_erase_exif_thumbnail (_tmp0_);
#line 764 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = self->priv->exif;
#line 764 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp1_ != NULL) {
#line 6299 "PhotoMetadata.c"
		ExifMem* _tmp2_;
		ExifMem* _tmp3_;
		ExifData* _tmp4_;
		guchar* _tmp5_;
		ExifData* _tmp6_;
		ExifData* _tmp7_;
#line 765 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = exif_mem_new_default ();
#line 765 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = _tmp2_;
#line 765 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = self->priv->exif;
#line 765 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = _tmp4_->data;
#line 765 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		exif_mem_free (_tmp3_, _tmp5_);
#line 765 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_exif_mem_unref0 (_tmp3_);
#line 766 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = self->priv->exif;
#line 766 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_->data = NULL;
#line 767 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = self->priv->exif;
#line 767 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_->size = (guint) 0;
#line 6326 "PhotoMetadata.c"
	}
}


void
photo_metadata_remove_tag (PhotoMetadata* self,
                           const gchar* tag)
{
	GExiv2Metadata* _tmp0_;
#line 771 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 771 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 772 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 772 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gexiv2_metadata_clear_tag (_tmp0_, tag);
#line 6344 "PhotoMetadata.c"
}


void
photo_metadata_remove_tags (PhotoMetadata* self,
                            gchar** tags,
                            int tags_length1)
{
#line 775 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 6355 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 776 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = tags;
#line 776 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = tags_length1;
#line 776 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < tags_length1; tag_it = tag_it + 1) {
#line 6367 "PhotoMetadata.c"
			gchar* _tmp0_;
			gchar* tag = NULL;
#line 776 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp0_ = g_strdup (tag_collection[tag_it]);
#line 776 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp0_;
#line 6374 "PhotoMetadata.c"
			{
				const gchar* _tmp1_;
#line 777 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp1_ = tag;
#line 777 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				photo_metadata_remove_tag (self, _tmp1_);
#line 776 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 6383 "PhotoMetadata.c"
			}
		}
	}
}


void
photo_metadata_clear_domain (PhotoMetadata* self,
                             MetadataDomain domain)
{
#line 780 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 781 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	switch (domain) {
#line 781 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_EXIF:
#line 6400 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp0_;
#line 783 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp0_ = self->priv->exiv2;
#line 783 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			gexiv2_metadata_clear_exif (_tmp0_);
#line 784 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 6409 "PhotoMetadata.c"
		}
#line 781 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_XMP:
#line 6413 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp1_;
#line 787 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = self->priv->exiv2;
#line 787 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			gexiv2_metadata_clear_xmp (_tmp1_);
#line 788 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 6422 "PhotoMetadata.c"
		}
#line 781 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_IPTC:
#line 6426 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp2_;
#line 791 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp2_ = self->priv->exiv2;
#line 791 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			gexiv2_metadata_clear_iptc (_tmp2_);
#line 792 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 6435 "PhotoMetadata.c"
		}
		default:
#line 781 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		break;
#line 6440 "PhotoMetadata.c"
	}
}


void
photo_metadata_clear (PhotoMetadata* self)
{
	GExiv2Metadata* _tmp0_;
#line 796 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 797 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 797 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gexiv2_metadata_clear (_tmp0_);
#line 6455 "PhotoMetadata.c"
}


MetadataDateTime*
photo_metadata_get_modification_date_time (PhotoMetadata* self)
{
	MetadataDateTime* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	MetadataDateTime* _tmp1_;
#line 807 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 808 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_DATE_TIME_TAGS;
#line 808 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_DATE_TIME_TAGS_length1;
#line 808 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_first_date_time (self, _tmp0_, _tmp0__length1);
#line 808 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 808 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 6478 "PhotoMetadata.c"
}


void
photo_metadata_set_modification_date_time (PhotoMetadata* self,
                                           MetadataDateTime* date_time,
                                           PhotoMetadataSetOption option)
{
#line 811 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 811 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail ((date_time == NULL) || IS_METADATA_DATE_TIME (date_time));
#line 813 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (date_time != NULL) {
#line 6493 "PhotoMetadata.c"
		gchar** _tmp0_;
		gint _tmp0__length1;
#line 814 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp0_ = photo_metadata_DATE_TIME_TAGS;
#line 814 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp0__length1 = photo_metadata_DATE_TIME_TAGS_length1;
#line 814 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_all_date_time (self, _tmp0_, _tmp0__length1, date_time, option);
#line 6502 "PhotoMetadata.c"
	} else {
		gchar** _tmp1_;
		gint _tmp1__length1;
#line 816 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = photo_metadata_DATE_TIME_TAGS;
#line 816 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1__length1 = photo_metadata_DATE_TIME_TAGS_length1;
#line 816 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_remove_tags (self, _tmp1_, _tmp1__length1);
#line 6512 "PhotoMetadata.c"
	}
}


MetadataDateTime*
photo_metadata_get_exposure_date_time (PhotoMetadata* self)
{
	MetadataDateTime* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	MetadataDateTime* _tmp1_;
#line 828 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 829 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_EXPOSURE_DATE_TIME_TAGS;
#line 829 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_EXPOSURE_DATE_TIME_TAGS_length1;
#line 829 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_first_date_time (self, _tmp0_, _tmp0__length1);
#line 829 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 829 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 6536 "PhotoMetadata.c"
}


void
photo_metadata_set_exposure_date_time (PhotoMetadata* self,
                                       MetadataDateTime* date_time,
                                       PhotoMetadataSetOption option)
{
#line 832 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 832 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail ((date_time == NULL) || IS_METADATA_DATE_TIME (date_time));
#line 834 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (date_time != NULL) {
#line 6551 "PhotoMetadata.c"
		gchar** _tmp0_;
		gint _tmp0__length1;
#line 835 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp0_ = photo_metadata_EXPOSURE_DATE_TIME_TAGS;
#line 835 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp0__length1 = photo_metadata_EXPOSURE_DATE_TIME_TAGS_length1;
#line 835 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_all_date_time (self, _tmp0_, _tmp0__length1, date_time, option);
#line 6560 "PhotoMetadata.c"
	} else {
		gchar** _tmp1_;
		gint _tmp1__length1;
#line 837 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = photo_metadata_EXPOSURE_DATE_TIME_TAGS;
#line 837 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1__length1 = photo_metadata_EXPOSURE_DATE_TIME_TAGS_length1;
#line 837 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_remove_tags (self, _tmp1_, _tmp1__length1);
#line 6570 "PhotoMetadata.c"
	}
}


MetadataDateTime*
photo_metadata_get_digitized_date_time (PhotoMetadata* self)
{
	MetadataDateTime* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	MetadataDateTime* _tmp1_;
#line 845 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 846 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_DIGITIZED_DATE_TIME_TAGS;
#line 846 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_DIGITIZED_DATE_TIME_TAGS_length1;
#line 846 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_first_date_time (self, _tmp0_, _tmp0__length1);
#line 846 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 846 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 6594 "PhotoMetadata.c"
}


void
photo_metadata_set_digitized_date_time (PhotoMetadata* self,
                                        MetadataDateTime* date_time,
                                        PhotoMetadataSetOption option)
{
#line 849 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 849 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail ((date_time == NULL) || IS_METADATA_DATE_TIME (date_time));
#line 851 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (date_time != NULL) {
#line 6609 "PhotoMetadata.c"
		gchar** _tmp0_;
		gint _tmp0__length1;
#line 852 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp0_ = photo_metadata_DIGITIZED_DATE_TIME_TAGS;
#line 852 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp0__length1 = photo_metadata_DIGITIZED_DATE_TIME_TAGS_length1;
#line 852 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_all_date_time (self, _tmp0_, _tmp0__length1, date_time, option);
#line 6618 "PhotoMetadata.c"
	} else {
		gchar** _tmp1_;
		gint _tmp1__length1;
#line 854 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = photo_metadata_DIGITIZED_DATE_TIME_TAGS;
#line 854 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1__length1 = photo_metadata_DIGITIZED_DATE_TIME_TAGS_length1;
#line 854 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_remove_tags (self, _tmp1_, _tmp1__length1);
#line 6628 "PhotoMetadata.c"
	}
}


static MetadataDateTime*
photo_metadata_real_get_creation_date_time (MediaMetadata* base)
{
	PhotoMetadata * self;
	MetadataDateTime* result = NULL;
	MetadataDateTime* creation = NULL;
	MetadataDateTime* _tmp0_;
	MetadataDateTime* _tmp1_;
#line 857 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_METADATA, PhotoMetadata);
#line 858 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_exposure_date_time (self);
#line 858 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	creation = _tmp0_;
#line 859 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = creation;
#line 859 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp1_ == NULL) {
#line 6651 "PhotoMetadata.c"
		MetadataDateTime* _tmp2_;
#line 860 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = photo_metadata_get_digitized_date_time (self);
#line 860 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_metadata_date_time_unref0 (creation);
#line 860 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		creation = _tmp2_;
#line 6659 "PhotoMetadata.c"
	}
#line 862 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = creation;
#line 862 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 6665 "PhotoMetadata.c"
}


static gpointer
_dimensions_dup0 (gpointer self)
{
#line 893 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self ? dimensions_dup (self) : NULL;
#line 6674 "PhotoMetadata.c"
}


Dimensions*
photo_metadata_get_pixel_dimensions (PhotoMetadata* self)
{
	Dimensions* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
#line 879 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 881 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_WIDTH_TAGS;
#line 881 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_WIDTH_TAGS_length1;
#line 881 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_HEIGHT_TAGS;
#line 881 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1__length1 = photo_metadata_HEIGHT_TAGS_length1;
#line 881 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_assert (_tmp0__length1 == _tmp1__length1, "WIDTH_TAGS.length == HEIGHT_TAGS.length");
#line 6698 "PhotoMetadata.c"
	{
		gint ctr = 0;
#line 882 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		ctr = 0;
#line 6703 "PhotoMetadata.c"
		{
			gboolean _tmp2_ = FALSE;
#line 882 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp2_ = TRUE;
#line 882 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			while (TRUE) {
#line 6710 "PhotoMetadata.c"
				gint _tmp4_;
				gchar** _tmp5_;
				gint _tmp5__length1;
				glong width = 0L;
				gchar** _tmp6_;
				gint _tmp6__length1;
				gint _tmp7_;
				const gchar* _tmp8_;
				glong _tmp9_ = 0L;
				gboolean _tmp10_;
				glong height = 0L;
				gchar** _tmp11_;
				gint _tmp11__length1;
				gint _tmp12_;
				const gchar* _tmp13_;
				glong _tmp14_ = 0L;
				gboolean _tmp15_;
				glong _tmp16_;
				glong _tmp17_;
				Dimensions _tmp18_ = {0};
				Dimensions* _tmp19_;
#line 882 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!_tmp2_) {
#line 6734 "PhotoMetadata.c"
					gint _tmp3_;
#line 882 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp3_ = ctr;
#line 882 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					ctr = _tmp3_ + 1;
#line 6740 "PhotoMetadata.c"
				}
#line 882 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = FALSE;
#line 882 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp4_ = ctr;
#line 882 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp5_ = photo_metadata_WIDTH_TAGS;
#line 882 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp5__length1 = photo_metadata_WIDTH_TAGS_length1;
#line 882 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!(_tmp4_ < _tmp5__length1)) {
#line 882 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					break;
#line 6754 "PhotoMetadata.c"
				}
#line 886 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp6_ = photo_metadata_WIDTH_TAGS;
#line 886 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp6__length1 = photo_metadata_WIDTH_TAGS_length1;
#line 886 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp7_ = ctr;
#line 886 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp8_ = _tmp6_[_tmp7_];
#line 886 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp10_ = photo_metadata_get_long (self, _tmp8_, &_tmp9_);
#line 886 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				width = _tmp9_;
#line 886 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!_tmp10_) {
#line 887 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					continue;
#line 6772 "PhotoMetadata.c"
				}
#line 890 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp11_ = photo_metadata_HEIGHT_TAGS;
#line 890 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp11__length1 = photo_metadata_HEIGHT_TAGS_length1;
#line 890 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp12_ = ctr;
#line 890 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp13_ = _tmp11_[_tmp12_];
#line 890 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp15_ = photo_metadata_get_long (self, _tmp13_, &_tmp14_);
#line 890 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				height = _tmp14_;
#line 890 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!_tmp15_) {
#line 891 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					continue;
#line 6790 "PhotoMetadata.c"
				}
#line 893 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp16_ = width;
#line 893 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp17_ = height;
#line 893 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				dimensions_init (&_tmp18_, (gint) _tmp16_, (gint) _tmp17_);
#line 893 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp19_ = _dimensions_dup0 (&_tmp18_);
#line 893 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				result = _tmp19_;
#line 893 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				return result;
#line 6804 "PhotoMetadata.c"
			}
		}
	}
#line 896 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = NULL;
#line 896 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 6812 "PhotoMetadata.c"
}


void
photo_metadata_set_pixel_dimensions (PhotoMetadata* self,
                                     Dimensions* dim,
                                     PhotoMetadataSetOption option)
{
#line 899 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 900 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (dim != NULL) {
#line 6825 "PhotoMetadata.c"
		gchar** _tmp0_;
		gint _tmp0__length1;
		gint _tmp1_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		gint _tmp3_;
#line 901 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp0_ = photo_metadata_WIDTH_TAGS;
#line 901 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp0__length1 = photo_metadata_WIDTH_TAGS_length1;
#line 901 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = (*dim).width;
#line 901 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_all_long (self, _tmp0_, _tmp0__length1, (glong) _tmp1_, option);
#line 902 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = photo_metadata_HEIGHT_TAGS;
#line 902 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2__length1 = photo_metadata_HEIGHT_TAGS_length1;
#line 902 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = (*dim).height;
#line 902 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_all_long (self, _tmp2_, _tmp2__length1, (glong) _tmp3_, option);
#line 6848 "PhotoMetadata.c"
	} else {
		gchar** _tmp4_;
		gint _tmp4__length1;
		gchar** _tmp5_;
		gint _tmp5__length1;
#line 904 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = photo_metadata_WIDTH_TAGS;
#line 904 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4__length1 = photo_metadata_WIDTH_TAGS_length1;
#line 904 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_remove_tags (self, _tmp4_, _tmp4__length1);
#line 905 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = photo_metadata_HEIGHT_TAGS;
#line 905 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5__length1 = photo_metadata_HEIGHT_TAGS_length1;
#line 905 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_remove_tags (self, _tmp5_, _tmp5__length1);
#line 6866 "PhotoMetadata.c"
	}
}


static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
#line 1248 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1249 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1249 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1250 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1250 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1251 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _result_;
#line 1251 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 6892 "PhotoMetadata.c"
}


static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
#line 1417 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1417 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1418 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1418 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1418 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 6912 "PhotoMetadata.c"
}


static gchar*
photo_metadata_real_get_title (MediaMetadata* base)
{
	PhotoMetadata * self;
	gchar* result = NULL;
	GeeList* _tmp0_ = NULL;
	GeeList* titles = NULL;
	GeeList* _tmp4_;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GeeList* _tmp7_;
	gchar* title = NULL;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	const gchar* _tmp20_;
	gchar* _tmp24_;
#line 939 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_METADATA, PhotoMetadata);
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (photo_metadata_has_tag (self, PHOTO_METADATA_IPHOTO_TITLE_TAG)) {
#line 6939 "PhotoMetadata.c"
		GeeList* _tmp1_;
#line 948 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = photo_metadata_get_string_multiple (self, PHOTO_METADATA_IPHOTO_TITLE_TAG);
#line 948 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_object_unref0 (_tmp0_);
#line 948 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp0_ = _tmp1_;
#line 6947 "PhotoMetadata.c"
	} else {
		gchar** _tmp2_;
		gint _tmp2__length1;
		GeeList* _tmp3_;
#line 949 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = photo_metadata_STANDARD_TITLE_TAGS;
#line 949 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2__length1 = photo_metadata_STANDARD_TITLE_TAGS_length1;
#line 949 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = photo_metadata_get_first_string_multiple (self, _tmp2_, _tmp2__length1);
#line 949 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_object_unref0 (_tmp0_);
#line 949 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp0_ = _tmp3_;
#line 6962 "PhotoMetadata.c"
	}
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = _g_object_ref0 (_tmp0_);
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	titles = _tmp4_;
#line 954 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = titles;
#line 954 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp7_ != NULL) {
#line 6972 "PhotoMetadata.c"
		GeeList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
#line 954 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp8_ = titles;
#line 954 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection));
#line 954 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = _tmp9_;
#line 954 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = _tmp10_ > 0;
#line 6984 "PhotoMetadata.c"
	} else {
#line 954 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = FALSE;
#line 6988 "PhotoMetadata.c"
	}
#line 954 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp6_) {
#line 6992 "PhotoMetadata.c"
		GeeList* _tmp11_;
		gpointer _tmp12_;
#line 954 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp11_ = titles;
#line 954 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp12_ = gee_list_get (_tmp11_, 0);
#line 954 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_tmp5_);
#line 954 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = (gchar*) _tmp12_;
#line 7003 "PhotoMetadata.c"
	} else {
#line 954 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_tmp5_);
#line 954 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = NULL;
#line 7009 "PhotoMetadata.c"
	}
#line 954 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13_ = g_strdup (_tmp5_);
#line 954 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	title = _tmp13_;
#line 957 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp14_ = title;
#line 957 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp14_ != NULL) {
#line 7019 "PhotoMetadata.c"
		const gchar* _tmp15_;
		gchar* _tmp16_;
#line 958 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp15_ = title;
#line 958 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp16_ = string_strip (_tmp15_);
#line 958 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (title);
#line 958 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		title = _tmp16_;
#line 7030 "PhotoMetadata.c"
	}
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp20_ = title;
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!is_string_empty (_tmp20_)) {
#line 7036 "PhotoMetadata.c"
		const gchar* _tmp21_;
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp21_ = title;
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp19_ = !string_contains (_tmp21_, "\n");
#line 7042 "PhotoMetadata.c"
	} else {
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp19_ = FALSE;
#line 7046 "PhotoMetadata.c"
	}
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp19_) {
#line 7050 "PhotoMetadata.c"
		const gchar* _tmp22_;
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp22_ = title;
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp18_ = !string_contains (_tmp22_, "\r");
#line 7056 "PhotoMetadata.c"
	} else {
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp18_ = FALSE;
#line 7060 "PhotoMetadata.c"
	}
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp18_) {
#line 7064 "PhotoMetadata.c"
		const gchar* _tmp23_;
#line 962 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp23_ = title;
#line 962 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp17_ = _tmp23_;
#line 7070 "PhotoMetadata.c"
	} else {
#line 962 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp17_ = NULL;
#line 7074 "PhotoMetadata.c"
	}
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp24_ = g_strdup (_tmp17_);
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp24_;
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (title);
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp5_);
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (titles);
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (_tmp0_);
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 7090 "PhotoMetadata.c"
}


void
photo_metadata_set_title (PhotoMetadata* self,
                          const gchar* title,
                          PhotoMetadataSetOption option)
{
#line 965 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 966 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!is_string_empty (title)) {
#line 967 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (photo_metadata_has_tag (self, PHOTO_METADATA_IPHOTO_TITLE_TAG)) {
#line 968 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			photo_metadata_set_string (self, PHOTO_METADATA_IPHOTO_TITLE_TAG, title, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 7107 "PhotoMetadata.c"
		} else {
			gchar** _tmp0_;
			gint _tmp0__length1;
#line 970 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp0_ = photo_metadata_STANDARD_TITLE_TAGS;
#line 970 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp0__length1 = photo_metadata_STANDARD_TITLE_TAGS_length1;
#line 970 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			photo_metadata_set_all_string (self, _tmp0_, _tmp0__length1, title, option);
#line 7117 "PhotoMetadata.c"
		}
	} else {
		gchar** _tmp1_;
		gint _tmp1__length1;
#line 972 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = photo_metadata_STANDARD_TITLE_TAGS;
#line 972 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1__length1 = photo_metadata_STANDARD_TITLE_TAGS_length1;
#line 972 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_remove_tags (self, _tmp1_, _tmp1__length1);
#line 7128 "PhotoMetadata.c"
	}
}


static gchar*
photo_metadata_real_get_comment (MediaMetadata* base)
{
	PhotoMetadata * self;
	gchar* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar* _tmp1_;
#line 981 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_METADATA, PhotoMetadata);
#line 982 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_COMMENT_TAGS;
#line 982 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_COMMENT_TAGS_length1;
#line 982 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_first_string_interpreted (self, _tmp0_, _tmp0__length1);
#line 982 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 982 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 7153 "PhotoMetadata.c"
}


static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return _data6_;
#line 7164 "PhotoMetadata.c"
}


static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 7175 "PhotoMetadata.c"
		PhotoMetadata* self;
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		self = _data6_->self;
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_data6_->comment);
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_media_metadata_unref0 (self);
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_slice_free (Block6Data, _data6_);
#line 7185 "PhotoMetadata.c"
	}
}


static void
___lambda10_ (Block6Data* _data6_,
              const gchar* tag)
{
	PhotoMetadata* self;
#line 990 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = _data6_->self;
#line 990 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 991 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_string (self, tag, _data6_->comment, PHOTO_METADATA_PREPARE_STRING_OPTIONS & (~PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF));
#line 7201 "PhotoMetadata.c"
}


static void
____lambda10__photo_metadata_set_generic_value (const gchar* tag,
                                                gpointer self)
{
#line 990 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	___lambda10_ (self, tag);
#line 7211 "PhotoMetadata.c"
}


void
photo_metadata_set_comment (PhotoMetadata* self,
                            const gchar* comment,
                            PhotoMetadataSetOption option)
{
	Block6Data* _data6_;
	gchar* _tmp0_;
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data6_ = g_slice_new0 (Block6Data);
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data6_->_ref_count_ = 1;
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data6_->self = media_metadata_ref (self);
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = g_strdup (comment);
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_data6_->comment);
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data6_->comment = _tmp0_;
#line 989 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!is_string_empty (_data6_->comment)) {
#line 7238 "PhotoMetadata.c"
		gchar** _tmp1_;
		gint _tmp1__length1;
#line 990 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = photo_metadata_COMMENT_TAGS;
#line 990 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1__length1 = photo_metadata_COMMENT_TAGS_length1;
#line 990 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_all_generic (self, _tmp1_, _tmp1__length1, option, ____lambda10__photo_metadata_set_generic_value, _data6_);
#line 7247 "PhotoMetadata.c"
	} else {
		gchar** _tmp2_;
		gint _tmp2__length1;
#line 995 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = photo_metadata_COMMENT_TAGS;
#line 995 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2__length1 = photo_metadata_COMMENT_TAGS_length1;
#line 995 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_remove_tags (self, _tmp2_, _tmp2__length1);
#line 7257 "PhotoMetadata.c"
	}
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	block6_data_unref (_data6_);
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data6_ = NULL;
#line 7263 "PhotoMetadata.c"
}


GeeSet*
photo_metadata_get_keywords (PhotoMetadata* self,
                             GCompareDataFunc compare_func,
                             void* compare_func_target,
                             GDestroyNotify compare_func_target_destroy_notify)
{
	GeeSet* result = NULL;
	GeeSet* keywords = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	GeeSet* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	GeeSet* _tmp23_;
	GeeSet* _tmp28_;
#line 1015 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1016 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	keywords = NULL;
#line 1017 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_KEYWORD_TAGS;
#line 1017 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_KEYWORD_TAGS_length1;
#line 7289 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 1017 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = _tmp0_;
#line 1017 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = _tmp0__length1;
#line 1017 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < _tmp0__length1; tag_it = tag_it + 1) {
#line 7301 "PhotoMetadata.c"
			gchar* _tmp1_;
			gchar* tag = NULL;
#line 1017 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = g_strdup (tag_collection[tag_it]);
#line 1017 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp1_;
#line 7308 "PhotoMetadata.c"
			{
				GeeCollection* values = NULL;
				const gchar* _tmp2_;
				GeeList* _tmp3_;
				gboolean _tmp4_ = FALSE;
				GeeCollection* _tmp5_;
#line 1018 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = tag;
#line 1018 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = photo_metadata_get_string_multiple (self, _tmp2_);
#line 1018 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				values = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection);
#line 1019 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp5_ = values;
#line 1019 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp5_ != NULL) {
#line 7325 "PhotoMetadata.c"
					GeeCollection* _tmp6_;
					gint _tmp7_;
					gint _tmp8_;
#line 1019 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp6_ = values;
#line 1019 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp7_ = gee_collection_get_size (_tmp6_);
#line 1019 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp8_ = _tmp7_;
#line 1019 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp4_ = _tmp8_ > 0;
#line 7337 "PhotoMetadata.c"
				} else {
#line 1019 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp4_ = FALSE;
#line 7341 "PhotoMetadata.c"
				}
#line 1019 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp4_) {
#line 7345 "PhotoMetadata.c"
					GeeSet* _tmp9_;
#line 1020 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp9_ = keywords;
#line 1020 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					if (_tmp9_ == NULL) {
#line 7351 "PhotoMetadata.c"
						GCompareDataFunc _tmp10_;
						void* _tmp10__target;
						GDestroyNotify _tmp10__target_destroy_notify;
						GeeSet* _tmp11_;
#line 1021 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp10_ = compare_func;
#line 1021 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp10__target = compare_func_target;
#line 1021 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp10__target_destroy_notify = compare_func_target_destroy_notify;
#line 1021 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						compare_func = NULL;
#line 1021 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						compare_func_target = NULL;
#line 1021 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						compare_func_target_destroy_notify = NULL;
#line 1021 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp11_ = photo_metadata_create_string_set (self, _tmp10_, _tmp10__target, _tmp10__target_destroy_notify);
#line 1021 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_g_object_unref0 (keywords);
#line 1021 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						keywords = _tmp11_;
#line 7374 "PhotoMetadata.c"
					}
					{
						GeeIterator* _current_value_it = NULL;
						GeeCollection* _tmp12_;
						GeeIterator* _tmp13_;
#line 1023 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp12_ = values;
#line 1023 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp13_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1023 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_current_value_it = _tmp13_;
#line 1023 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						while (TRUE) {
#line 7388 "PhotoMetadata.c"
							GeeIterator* _tmp14_;
							gchar* current_value = NULL;
							GeeIterator* _tmp15_;
							gpointer _tmp16_;
							GeeSet* _tmp17_;
							const gchar* _tmp18_;
							gchar* _tmp19_;
							gchar* _tmp20_;
#line 1023 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp14_ = _current_value_it;
#line 1023 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							if (!gee_iterator_next (_tmp14_)) {
#line 1023 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
								break;
#line 7403 "PhotoMetadata.c"
							}
#line 1023 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp15_ = _current_value_it;
#line 1023 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp16_ = gee_iterator_get (_tmp15_);
#line 1023 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							current_value = (gchar*) _tmp16_;
#line 1024 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp17_ = keywords;
#line 1024 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp18_ = current_value;
#line 1024 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp19_ = hierarchical_tag_utilities_make_flat_tag_safe (_tmp18_);
#line 1024 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp20_ = _tmp19_;
#line 1024 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_COLLECTION, GeeCollection), _tmp20_);
#line 1024 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_free0 (_tmp20_);
#line 1023 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_free0 (current_value);
#line 7425 "PhotoMetadata.c"
						}
#line 1023 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_g_object_unref0 (_current_value_it);
#line 7429 "PhotoMetadata.c"
					}
				}
#line 1017 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_object_unref0 (values);
#line 1017 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 7436 "PhotoMetadata.c"
			}
		}
	}
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp23_ = keywords;
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp23_ != NULL) {
#line 7444 "PhotoMetadata.c"
		GeeSet* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp24_ = keywords;
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp25_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp26_ = _tmp25_;
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp22_ = _tmp26_ > 0;
#line 7456 "PhotoMetadata.c"
	} else {
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp22_ = FALSE;
#line 7460 "PhotoMetadata.c"
	}
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp22_) {
#line 7464 "PhotoMetadata.c"
		GeeSet* _tmp27_;
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp27_ = keywords;
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp21_ = _tmp27_;
#line 7470 "PhotoMetadata.c"
	} else {
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp21_ = NULL;
#line 7474 "PhotoMetadata.c"
	}
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp28_ = _g_object_ref0 (_tmp21_);
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp28_;
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (keywords);
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func = NULL;
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target = NULL;
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target_destroy_notify = NULL;
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 7492 "PhotoMetadata.c"
}


static gpointer
_hierarchical_keyword_field_ref0 (gpointer self)
{
#line 1032 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self ? hierarchical_keyword_field_ref (self) : NULL;
#line 7501 "PhotoMetadata.c"
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
#line 1421 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1421 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1421 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 7524 "PhotoMetadata.c"
	} else {
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 7528 "PhotoMetadata.c"
	}
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 7534 "PhotoMetadata.c"
	} else {
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 7538 "PhotoMetadata.c"
	}
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 7542 "PhotoMetadata.c"
		gchar* _tmp2_;
#line 1423 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1423 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = _tmp2_;
#line 1423 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 7550 "PhotoMetadata.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		regex = _tmp6_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 7578 "PhotoMetadata.c"
				goto __catch31_g_regex_error;
			}
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			return NULL;
#line 7587 "PhotoMetadata.c"
		}
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp8_ = regex;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 7601 "PhotoMetadata.c"
				goto __catch31_g_regex_error;
			}
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			return NULL;
#line 7612 "PhotoMetadata.c"
		}
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = _tmp10_;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 7626 "PhotoMetadata.c"
	}
	goto __finally31;
	__catch31_g_regex_error:
	{
		GError* e = NULL;
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1429 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 7640 "PhotoMetadata.c"
	}
	__finally31:
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return NULL;
#line 7651 "PhotoMetadata.c"
	}
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 1336 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1336 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	end = _tmp0_;
#line 1337 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = end;
#line 1337 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1338 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = maxlen;
#line 1338 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 7676 "PhotoMetadata.c"
	} else {
		gchar* _tmp2_;
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = end;
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 7685 "PhotoMetadata.c"
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
#line 1347 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 7706 "PhotoMetadata.c"
	} else {
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 7710 "PhotoMetadata.c"
	}
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 1351 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 7716 "PhotoMetadata.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 7726 "PhotoMetadata.c"
	}
#line 1356 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 7730 "PhotoMetadata.c"
		glong _tmp3_;
#line 1357 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1357 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		offset = _tmp3_ + offset;
#line 1358 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 7738 "PhotoMetadata.c"
	} else {
		glong _tmp4_;
#line 1360 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = string_length;
#line 1360 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_return_val_if_fail (offset <= _tmp4_, NULL);
#line 7745 "PhotoMetadata.c"
	}
#line 1362 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 7749 "PhotoMetadata.c"
		glong _tmp5_;
#line 1363 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp5_ = string_length;
#line 1363 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		len = _tmp5_ - offset;
#line 7755 "PhotoMetadata.c"
	}
#line 1365 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp6_ = string_length;
#line 1365 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 7767 "PhotoMetadata.c"
}


static void
photo_metadata_internal_set_hierarchical_keywords (PhotoMetadata* self,
                                                   HierarchicalTagIndex* index)
{
	HierarchicalKeywordField** _tmp0_;
	gint _tmp0__length1;
	HierarchicalKeywordField** _tmp4_;
	gint _tmp4__length1;
#line 1031 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 1031 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail ((index == NULL) || IS_HIERARCHICAL_TAG_INDEX (index));
#line 1032 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_HIERARCHICAL_KEYWORD_TAGS;
#line 1032 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_HIERARCHICAL_KEYWORD_TAGS_length1;
#line 7787 "PhotoMetadata.c"
	{
		HierarchicalKeywordField** current_field_collection = NULL;
		gint current_field_collection_length1 = 0;
		gint _current_field_collection_size_ = 0;
		gint current_field_it = 0;
#line 1032 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		current_field_collection = _tmp0_;
#line 1032 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		current_field_collection_length1 = _tmp0__length1;
#line 1032 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (current_field_it = 0; current_field_it < _tmp0__length1; current_field_it = current_field_it + 1) {
#line 7799 "PhotoMetadata.c"
			HierarchicalKeywordField* _tmp1_;
			HierarchicalKeywordField* current_field = NULL;
#line 1032 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = _hierarchical_keyword_field_ref0 (current_field_collection[current_field_it]);
#line 1032 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			current_field = _tmp1_;
#line 7806 "PhotoMetadata.c"
			{
				HierarchicalKeywordField* _tmp2_;
				const gchar* _tmp3_;
#line 1033 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = current_field;
#line 1033 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = _tmp2_->field_name;
#line 1033 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				photo_metadata_remove_tag (self, _tmp3_);
#line 1032 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_hierarchical_keyword_field_unref0 (current_field);
#line 7818 "PhotoMetadata.c"
			}
		}
	}
#line 1035 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (index == NULL) {
#line 1036 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 7826 "PhotoMetadata.c"
	}
#line 1038 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = photo_metadata_HIERARCHICAL_KEYWORD_TAGS;
#line 1038 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4__length1 = photo_metadata_HIERARCHICAL_KEYWORD_TAGS_length1;
#line 7832 "PhotoMetadata.c"
	{
		HierarchicalKeywordField** current_field_collection = NULL;
		gint current_field_collection_length1 = 0;
		gint _current_field_collection_size_ = 0;
		gint current_field_it = 0;
#line 1038 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		current_field_collection = _tmp4_;
#line 1038 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		current_field_collection_length1 = _tmp4__length1;
#line 1038 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (current_field_it = 0; current_field_it < _tmp4__length1; current_field_it = current_field_it + 1) {
#line 7844 "PhotoMetadata.c"
			HierarchicalKeywordField* _tmp5_;
			HierarchicalKeywordField* current_field = NULL;
#line 1038 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp5_ = _hierarchical_keyword_field_ref0 (current_field_collection[current_field_it]);
#line 1038 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			current_field = _tmp5_;
#line 7851 "PhotoMetadata.c"
			{
				HierarchicalKeywordField* _tmp6_;
				gboolean _tmp7_;
				GeeSet* writeable_set = NULL;
				GeeTreeSet* _tmp8_;
				HierarchicalKeywordField* _tmp26_;
				const gchar* _tmp27_;
				GeeSet* _tmp28_;
#line 1039 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp6_ = current_field;
#line 1039 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp7_ = _tmp6_->is_writeable;
#line 1039 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!_tmp7_) {
#line 1040 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_hierarchical_keyword_field_unref0 (current_field);
#line 1040 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					continue;
#line 7870 "PhotoMetadata.c"
				}
#line 1042 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp8_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 1042 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				writeable_set = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_SET, GeeSet);
#line 7876 "PhotoMetadata.c"
				{
					GeeIterator* _current_path_it = NULL;
					GeeCollection* _tmp9_;
					GeeCollection* _tmp10_;
					GeeIterator* _tmp11_;
					GeeIterator* _tmp12_;
#line 1044 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp9_ = hierarchical_tag_index_get_all_paths (index);
#line 1044 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp10_ = _tmp9_;
#line 1044 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp11_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1044 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp12_ = _tmp11_;
#line 1044 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_object_unref0 (_tmp10_);
#line 1044 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_current_path_it = _tmp12_;
#line 1044 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					while (TRUE) {
#line 7897 "PhotoMetadata.c"
						GeeIterator* _tmp13_;
						gchar* current_path = NULL;
						GeeIterator* _tmp14_;
						gpointer _tmp15_;
						gchar* writeable_path = NULL;
						const gchar* _tmp16_;
						HierarchicalKeywordField* _tmp17_;
						const gchar* _tmp18_;
						gchar* _tmp19_;
						HierarchicalKeywordField* _tmp20_;
						gboolean _tmp21_;
						GeeSet* _tmp24_;
						const gchar* _tmp25_;
#line 1044 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp13_ = _current_path_it;
#line 1044 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						if (!gee_iterator_next (_tmp13_)) {
#line 1044 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							break;
#line 7917 "PhotoMetadata.c"
						}
#line 1044 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp14_ = _current_path_it;
#line 1044 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp15_ = gee_iterator_get (_tmp14_);
#line 1044 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						current_path = (gchar*) _tmp15_;
#line 1045 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp16_ = current_path;
#line 1045 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp17_ = current_field;
#line 1045 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp18_ = _tmp17_->path_separator;
#line 1045 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp19_ = string_replace (_tmp16_, TAG_PATH_SEPARATOR_STRING, _tmp18_);
#line 1045 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						writeable_path = _tmp19_;
#line 1047 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp20_ = current_field;
#line 1047 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp21_ = _tmp20_->wants_leading_separator;
#line 1047 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						if (!_tmp21_) {
#line 7941 "PhotoMetadata.c"
							const gchar* _tmp22_;
							gchar* _tmp23_;
#line 1048 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp22_ = writeable_path;
#line 1048 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp23_ = string_substring (_tmp22_, (glong) 1, (glong) -1);
#line 1048 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_free0 (writeable_path);
#line 1048 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							writeable_path = _tmp23_;
#line 7952 "PhotoMetadata.c"
						}
#line 1050 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp24_ = writeable_set;
#line 1050 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp25_ = writeable_path;
#line 1050 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_COLLECTION, GeeCollection), _tmp25_);
#line 1044 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_g_free0 (writeable_path);
#line 1044 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_g_free0 (current_path);
#line 7964 "PhotoMetadata.c"
					}
#line 1044 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_object_unref0 (_current_path_it);
#line 7968 "PhotoMetadata.c"
				}
#line 1053 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp26_ = current_field;
#line 1053 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp27_ = _tmp26_->field_name;
#line 1053 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp28_ = writeable_set;
#line 1053 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				photo_metadata_set_string_multiple (self, _tmp27_, G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1038 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_object_unref0 (writeable_set);
#line 1038 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_hierarchical_keyword_field_unref0 (current_field);
#line 7982 "PhotoMetadata.c"
			}
		}
	}
}


void
photo_metadata_set_keywords (PhotoMetadata* self,
                             GeeCollection* keywords,
                             PhotoMetadataSetOption option)
{
	HierarchicalTagIndex* htag_index = NULL;
	HierarchicalTagIndex* _tmp0_;
	GeeSet* flat_keywords = NULL;
	GeeTreeSet* _tmp1_;
#line 1057 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 1057 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail ((keywords == NULL) || GEE_IS_COLLECTION (keywords));
#line 1058 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = hierarchical_tag_index_new ();
#line 1058 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	htag_index = _tmp0_;
#line 1059 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 1059 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	flat_keywords = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_SET, GeeSet);
#line 1061 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (keywords != NULL) {
#line 8012 "PhotoMetadata.c"
		GeeSet* _tmp19_;
		HierarchicalTagIndex* _tmp20_;
		GeeCollection* _tmp21_;
		GeeCollection* _tmp22_;
		{
			GeeIterator* _keyword_it = NULL;
			GeeIterator* _tmp2_;
#line 1062 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (keywords, GEE_TYPE_ITERABLE, GeeIterable));
#line 1062 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_keyword_it = _tmp2_;
#line 1062 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			while (TRUE) {
#line 8026 "PhotoMetadata.c"
				GeeIterator* _tmp3_;
				gchar* keyword = NULL;
				GeeIterator* _tmp4_;
				gpointer _tmp5_;
				const gchar* _tmp6_;
#line 1062 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = _keyword_it;
#line 1062 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!gee_iterator_next (_tmp3_)) {
#line 1062 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					break;
#line 8038 "PhotoMetadata.c"
				}
#line 1062 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp4_ = _keyword_it;
#line 1062 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp5_ = gee_iterator_get (_tmp4_);
#line 1062 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				keyword = (gchar*) _tmp5_;
#line 1063 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp6_ = keyword;
#line 1063 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (g_str_has_prefix (_tmp6_, TAG_PATH_SEPARATOR_STRING)) {
#line 8050 "PhotoMetadata.c"
					GeeCollection* path_components = NULL;
					const gchar* _tmp7_;
					GeeList* _tmp8_;
#line 1064 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp7_ = keyword;
#line 1064 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp8_ = hierarchical_tag_utilities_enumerate_path_components (_tmp7_);
#line 1064 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					path_components = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection);
#line 8060 "PhotoMetadata.c"
					{
						GeeIterator* _component_it = NULL;
						GeeCollection* _tmp9_;
						GeeIterator* _tmp10_;
#line 1066 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp9_ = path_components;
#line 1066 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp10_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1066 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_component_it = _tmp10_;
#line 1066 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						while (TRUE) {
#line 8073 "PhotoMetadata.c"
							GeeIterator* _tmp11_;
							gchar* component = NULL;
							GeeIterator* _tmp12_;
							gpointer _tmp13_;
							HierarchicalTagIndex* _tmp14_;
							const gchar* _tmp15_;
							const gchar* _tmp16_;
#line 1066 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp11_ = _component_it;
#line 1066 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							if (!gee_iterator_next (_tmp11_)) {
#line 1066 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
								break;
#line 8087 "PhotoMetadata.c"
							}
#line 1066 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp12_ = _component_it;
#line 1066 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp13_ = gee_iterator_get (_tmp12_);
#line 1066 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							component = (gchar*) _tmp13_;
#line 1067 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp14_ = htag_index;
#line 1067 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp15_ = component;
#line 1067 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp16_ = keyword;
#line 1067 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							hierarchical_tag_index_add_path (_tmp14_, _tmp15_, _tmp16_);
#line 1066 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_free0 (component);
#line 8105 "PhotoMetadata.c"
						}
#line 1066 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_g_object_unref0 (_component_it);
#line 8109 "PhotoMetadata.c"
					}
#line 1063 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_object_unref0 (path_components);
#line 8113 "PhotoMetadata.c"
				} else {
					GeeSet* _tmp17_;
					const gchar* _tmp18_;
#line 1069 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp17_ = flat_keywords;
#line 1069 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp18_ = keyword;
#line 1069 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_COLLECTION, GeeCollection), _tmp18_);
#line 8123 "PhotoMetadata.c"
				}
#line 1062 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (keyword);
#line 8127 "PhotoMetadata.c"
			}
#line 1062 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_g_object_unref0 (_keyword_it);
#line 8131 "PhotoMetadata.c"
		}
#line 1073 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp19_ = flat_keywords;
#line 1073 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp20_ = htag_index;
#line 1073 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp21_ = hierarchical_tag_index_get_all_tags (_tmp20_);
#line 1073 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp22_ = _tmp21_;
#line 1073 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_COLLECTION, GeeCollection), _tmp22_);
#line 1073 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_object_unref0 (_tmp22_);
#line 8145 "PhotoMetadata.c"
	}
#line 1076 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (keywords != NULL) {
#line 8149 "PhotoMetadata.c"
		gchar** _tmp23_;
		gint _tmp23__length1;
		GeeSet* _tmp24_;
		HierarchicalTagIndex* _tmp25_;
#line 1077 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp23_ = photo_metadata_KEYWORD_TAGS;
#line 1077 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp23__length1 = photo_metadata_KEYWORD_TAGS_length1;
#line 1077 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp24_ = flat_keywords;
#line 1077 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_all_string_multiple (self, _tmp23_, _tmp23__length1, G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_COLLECTION, GeeCollection), option);
#line 1078 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp25_ = htag_index;
#line 1078 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_internal_set_hierarchical_keywords (self, _tmp25_);
#line 8166 "PhotoMetadata.c"
	} else {
		gchar** _tmp26_;
		gint _tmp26__length1;
#line 1080 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp26_ = photo_metadata_KEYWORD_TAGS;
#line 1080 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp26__length1 = photo_metadata_KEYWORD_TAGS_length1;
#line 1080 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_remove_tags (self, _tmp26_, _tmp26__length1);
#line 1081 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_internal_set_hierarchical_keywords (self, NULL);
#line 8178 "PhotoMetadata.c"
	}
#line 1057 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (flat_keywords);
#line 1057 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_hierarchical_tag_index_unref0 (htag_index);
#line 8184 "PhotoMetadata.c"
}


gboolean
photo_metadata_has_hierarchical_keywords (PhotoMetadata* self)
{
	gboolean result = FALSE;
	HierarchicalKeywordField** _tmp0_;
	gint _tmp0__length1;
#line 1085 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 1086 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_HIERARCHICAL_KEYWORD_TAGS;
#line 1086 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_HIERARCHICAL_KEYWORD_TAGS_length1;
#line 8200 "PhotoMetadata.c"
	{
		HierarchicalKeywordField** field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
#line 1086 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		field_collection = _tmp0_;
#line 1086 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		field_collection_length1 = _tmp0__length1;
#line 1086 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (field_it = 0; field_it < _tmp0__length1; field_it = field_it + 1) {
#line 8212 "PhotoMetadata.c"
			HierarchicalKeywordField* _tmp1_;
			HierarchicalKeywordField* field = NULL;
#line 1086 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = _hierarchical_keyword_field_ref0 (field_collection[field_it]);
#line 1086 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			field = _tmp1_;
#line 8219 "PhotoMetadata.c"
			{
				GeeCollection* values = NULL;
				HierarchicalKeywordField* _tmp2_;
				const gchar* _tmp3_;
				GeeList* _tmp4_;
				gboolean _tmp5_ = FALSE;
				GeeCollection* _tmp6_;
#line 1087 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = field;
#line 1087 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = _tmp2_->field_name;
#line 1087 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp4_ = photo_metadata_get_string_multiple (self, _tmp3_);
#line 1087 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				values = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection);
#line 1089 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp6_ = values;
#line 1089 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp6_ != NULL) {
#line 8239 "PhotoMetadata.c"
					GeeCollection* _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
#line 1089 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp7_ = values;
#line 1089 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp8_ = gee_collection_get_size (_tmp7_);
#line 1089 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp9_ = _tmp8_;
#line 1089 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp5_ = _tmp9_ > 0;
#line 8251 "PhotoMetadata.c"
				} else {
#line 1089 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp5_ = FALSE;
#line 8255 "PhotoMetadata.c"
				}
#line 1089 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp5_) {
#line 1090 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					result = TRUE;
#line 1090 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_object_unref0 (values);
#line 1090 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_hierarchical_keyword_field_unref0 (field);
#line 1090 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					return result;
#line 8267 "PhotoMetadata.c"
				}
#line 1086 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_object_unref0 (values);
#line 1086 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_hierarchical_keyword_field_unref0 (field);
#line 8273 "PhotoMetadata.c"
			}
		}
	}
#line 1093 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = FALSE;
#line 1093 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8281 "PhotoMetadata.c"
}


GeeSet*
photo_metadata_get_hierarchical_keywords (PhotoMetadata* self)
{
	GeeSet* result = NULL;
	GeeSet* h_keywords = NULL;
	GeeSet* _tmp0_;
	HierarchicalKeywordField** _tmp1_;
	gint _tmp1__length1;
	GError * _inner_error_ = NULL;
#line 1096 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1097 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_assert (photo_metadata_has_hierarchical_keywords (self), "has_hierarchical_keywords()");
#line 1099 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_create_string_set (self, NULL, NULL, NULL);
#line 1099 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	h_keywords = _tmp0_;
#line 1101 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_HIERARCHICAL_KEYWORD_TAGS;
#line 1101 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1__length1 = photo_metadata_HIERARCHICAL_KEYWORD_TAGS_length1;
#line 8306 "PhotoMetadata.c"
	{
		HierarchicalKeywordField** field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
#line 1101 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		field_collection = _tmp1_;
#line 1101 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		field_collection_length1 = _tmp1__length1;
#line 1101 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (field_it = 0; field_it < _tmp1__length1; field_it = field_it + 1) {
#line 8318 "PhotoMetadata.c"
			HierarchicalKeywordField* _tmp2_;
			HierarchicalKeywordField* field = NULL;
#line 1101 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp2_ = _hierarchical_keyword_field_ref0 (field_collection[field_it]);
#line 1101 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			field = _tmp2_;
#line 8325 "PhotoMetadata.c"
			{
				GeeCollection* values = NULL;
				HierarchicalKeywordField* _tmp3_;
				const gchar* _tmp4_;
				GeeList* _tmp5_;
				gboolean _tmp6_ = FALSE;
				GeeCollection* _tmp7_;
				GeeArrayList* transformed_values = NULL;
				GeeArrayList* _tmp11_;
#line 1102 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = field;
#line 1102 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp4_ = _tmp3_->field_name;
#line 1102 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp5_ = photo_metadata_get_string_multiple (self, _tmp4_);
#line 1102 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				values = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection);
#line 1104 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp7_ = values;
#line 1104 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp7_ == NULL) {
#line 1104 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp6_ = TRUE;
#line 8349 "PhotoMetadata.c"
				} else {
					GeeCollection* _tmp8_;
					gint _tmp9_;
					gint _tmp10_;
#line 1104 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp8_ = values;
#line 1104 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp9_ = gee_collection_get_size (_tmp8_);
#line 1104 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp10_ = _tmp9_;
#line 1104 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp6_ = _tmp10_ < 1;
#line 8362 "PhotoMetadata.c"
				}
#line 1104 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp6_) {
#line 1105 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_object_unref0 (values);
#line 1105 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_hierarchical_keyword_field_unref0 (field);
#line 1105 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					continue;
#line 8372 "PhotoMetadata.c"
				}
#line 1107 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp11_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 1107 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				transformed_values = _tmp11_;
#line 8378 "PhotoMetadata.c"
				{
					GeeIterator* _current_value_it = NULL;
					GeeCollection* _tmp12_;
					GeeIterator* _tmp13_;
#line 1108 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp12_ = values;
#line 1108 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp13_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1108 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_current_value_it = _tmp13_;
#line 1108 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					while (TRUE) {
#line 8391 "PhotoMetadata.c"
						GeeIterator* _tmp14_;
						gchar* current_value = NULL;
						GeeIterator* _tmp15_;
						gpointer _tmp16_;
#line 1108 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp14_ = _current_value_it;
#line 1108 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						if (!gee_iterator_next (_tmp14_)) {
#line 1108 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							break;
#line 8402 "PhotoMetadata.c"
						}
#line 1108 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp15_ = _current_value_it;
#line 1108 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp16_ = gee_iterator_get (_tmp15_);
#line 1108 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						current_value = (gchar*) _tmp16_;
#line 8410 "PhotoMetadata.c"
						{
							GeeList* transformed = NULL;
							HierarchicalKeywordField* _tmp17_;
							KeywordTransformer* _tmp18_;
							const gchar* _tmp19_;
							GeeList* _tmp20_;
							GeeArrayList* _tmp21_;
							GeeList* _tmp22_;
#line 1110 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp17_ = field;
#line 1110 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp18_ = _tmp17_->transformer;
#line 1110 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp19_ = current_value;
#line 1110 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp20_ = keyword_transformer_transform (_tmp18_, _tmp19_, &_inner_error_);
#line 1110 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							transformed = _tmp20_;
#line 1110 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8431 "PhotoMetadata.c"
								goto __catch32_g_error;
							}
#line 1111 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp21_ = transformed_values;
#line 1111 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp22_ = transformed;
#line 1111 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							gee_array_list_add_all (_tmp21_, G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1109 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_object_unref0 (transformed);
#line 8442 "PhotoMetadata.c"
						}
						goto __finally32;
						__catch32_g_error:
						{
							GError* _error_ = NULL;
							const gchar* _tmp23_;
							GError* _tmp24_;
							const gchar* _tmp25_;
#line 1109 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_error_ = _inner_error_;
#line 1109 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_inner_error_ = NULL;
#line 1113 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp23_ = current_value;
#line 1113 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp24_ = _error_;
#line 1113 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp25_ = _tmp24_->message;
#line 1113 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							g_critical ("PhotoMetadata.vala:1113: Failed to transform tag value %s: %s", _tmp23_, _tmp25_);
#line 1109 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_error_free0 (_error_);
#line 8465 "PhotoMetadata.c"
						}
						__finally32:
#line 1109 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1109 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_free0 (current_value);
#line 1109 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_object_unref0 (_current_value_it);
#line 1109 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_object_unref0 (transformed_values);
#line 1109 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_object_unref0 (values);
#line 1109 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_hierarchical_keyword_field_unref0 (field);
#line 1109 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_object_unref0 (h_keywords);
#line 1109 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1109 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							g_clear_error (&_inner_error_);
#line 1109 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							return NULL;
#line 8488 "PhotoMetadata.c"
						}
#line 1108 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_g_free0 (current_value);
#line 8492 "PhotoMetadata.c"
					}
#line 1108 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_object_unref0 (_current_value_it);
#line 8496 "PhotoMetadata.c"
				}
				{
					GeeArrayList* _current_value_list = NULL;
					GeeArrayList* _tmp26_;
					GeeArrayList* _tmp27_;
					gint _current_value_size = 0;
					GeeArrayList* _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					gint _current_value_index = 0;
#line 1119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp26_ = transformed_values;
#line 1119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp27_ = _g_object_ref0 (_tmp26_);
#line 1119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_current_value_list = _tmp27_;
#line 1119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp28_ = _current_value_list;
#line 1119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp29_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp30_ = _tmp29_;
#line 1119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_current_value_size = _tmp30_;
#line 1119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_current_value_index = -1;
#line 1119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					while (TRUE) {
#line 8525 "PhotoMetadata.c"
						gint _tmp31_;
						gint _tmp32_;
						gint _tmp33_;
						gchar* current_value = NULL;
						GeeArrayList* _tmp34_;
						gint _tmp35_;
						gpointer _tmp36_;
						gchar* canonicalized = NULL;
						const gchar* _tmp37_;
						HierarchicalKeywordField* _tmp38_;
						const gchar* _tmp39_;
						gchar* _tmp40_;
						const gchar* _tmp41_;
#line 1119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp31_ = _current_value_index;
#line 1119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_current_value_index = _tmp31_ + 1;
#line 1119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp32_ = _current_value_index;
#line 1119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp33_ = _current_value_size;
#line 1119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						if (!(_tmp32_ < _tmp33_)) {
#line 1119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							break;
#line 8551 "PhotoMetadata.c"
						}
#line 1119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp34_ = _current_value_list;
#line 1119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp35_ = _current_value_index;
#line 1119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp36_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp35_);
#line 1119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						current_value = (gchar*) _tmp36_;
#line 1120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp37_ = current_value;
#line 1120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp38_ = field;
#line 1120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp39_ = _tmp38_->path_separator;
#line 1120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp40_ = hierarchical_tag_utilities_canonicalize (_tmp37_, _tmp39_);
#line 1120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						canonicalized = _tmp40_;
#line 1124 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp41_ = canonicalized;
#line 1124 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						if (_tmp41_ != NULL) {
#line 8575 "PhotoMetadata.c"
							GeeSet* _tmp42_;
							const gchar* _tmp43_;
#line 1125 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp42_ = h_keywords;
#line 1125 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp43_ = canonicalized;
#line 1125 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, GEE_TYPE_COLLECTION, GeeCollection), _tmp43_);
#line 8584 "PhotoMetadata.c"
						}
#line 1119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_g_free0 (canonicalized);
#line 1119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_g_free0 (current_value);
#line 8590 "PhotoMetadata.c"
					}
#line 1119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_object_unref0 (_current_value_list);
#line 8594 "PhotoMetadata.c"
				}
#line 1101 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_object_unref0 (transformed_values);
#line 1101 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_object_unref0 (values);
#line 1101 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_hierarchical_keyword_field_unref0 (field);
#line 8602 "PhotoMetadata.c"
			}
		}
	}
#line 1129 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = h_keywords;
#line 1129 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8610 "PhotoMetadata.c"
}


gboolean
photo_metadata_has_orientation (PhotoMetadata* self)
{
	gboolean result = FALSE;
	GExiv2Metadata* _tmp0_;
#line 1132 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 1133 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 1133 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = gexiv2_metadata_get_orientation (_tmp0_) == GEXIV2_ORIENTATION_UNSPECIFIED;
#line 1133 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8627 "PhotoMetadata.c"
}


Orientation
photo_metadata_get_orientation (PhotoMetadata* self)
{
	Orientation result = 0;
	GExiv2Orientation orientation = 0;
	GExiv2Metadata* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GExiv2Orientation _tmp3_;
#line 1137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), 0);
#line 1140 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 1140 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	orientation = gexiv2_metadata_get_orientation (_tmp0_);
#line 1141 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = orientation;
#line 1141 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp3_ == GEXIV2_ORIENTATION_UNSPECIFIED) {
#line 1141 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = TRUE;
#line 8652 "PhotoMetadata.c"
	} else {
		GExiv2Orientation _tmp4_;
#line 1141 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = orientation;
#line 1141 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = _tmp4_ < ORIENTATION_MIN;
#line 8659 "PhotoMetadata.c"
	}
#line 1141 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp2_) {
#line 1141 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = TRUE;
#line 8665 "PhotoMetadata.c"
	} else {
		GExiv2Orientation _tmp5_;
#line 1142 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = orientation;
#line 1142 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = _tmp5_ > ORIENTATION_MAX;
#line 8672 "PhotoMetadata.c"
	}
#line 1141 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp1_) {
#line 1143 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = ORIENTATION_TOP_LEFT;
#line 1143 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 8680 "PhotoMetadata.c"
	} else {
		GExiv2Orientation _tmp6_;
#line 1145 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = orientation;
#line 1145 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = (Orientation) _tmp6_;
#line 1145 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 8689 "PhotoMetadata.c"
	}
}


void
photo_metadata_set_orientation (PhotoMetadata* self,
                                Orientation orientation)
{
	GExiv2Metadata* _tmp0_;
#line 1148 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 1150 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 1150 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gexiv2_metadata_set_orientation (_tmp0_, (GExiv2Orientation) orientation);
#line 8705 "PhotoMetadata.c"
}


gboolean
photo_metadata_get_gps (PhotoMetadata* self,
                        gdouble* longitude,
                        gchar* * long_ref,
                        gdouble* latitude,
                        gchar* * lat_ref,
                        gdouble* altitude)
{
	gdouble _vala_longitude = 0.0;
	gchar* _vala_long_ref = NULL;
	gdouble _vala_latitude = 0.0;
	gchar* _vala_lat_ref = NULL;
	gdouble _vala_altitude = 0.0;
	gboolean result = FALSE;
	GExiv2Metadata* _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gboolean _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
#line 1153 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 1155 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 1155 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = gexiv2_metadata_get_gps_info (_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
#line 1155 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_longitude = _tmp1_;
#line 1155 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_latitude = _tmp2_;
#line 1155 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_altitude = _tmp3_;
#line 1155 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp4_) {
#line 1156 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_vala_long_ref);
#line 1156 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_vala_long_ref = NULL;
#line 1157 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_vala_lat_ref);
#line 1157 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_vala_lat_ref = NULL;
#line 1159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = FALSE;
#line 1159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (longitude) {
#line 1159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*longitude = _vala_longitude;
#line 8758 "PhotoMetadata.c"
		}
#line 1159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (long_ref) {
#line 1159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*long_ref = _vala_long_ref;
#line 8764 "PhotoMetadata.c"
		} else {
#line 1159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_g_free0 (_vala_long_ref);
#line 8768 "PhotoMetadata.c"
		}
#line 1159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (latitude) {
#line 1159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*latitude = _vala_latitude;
#line 8774 "PhotoMetadata.c"
		}
#line 1159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (lat_ref) {
#line 1159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*lat_ref = _vala_lat_ref;
#line 8780 "PhotoMetadata.c"
		} else {
#line 1159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_g_free0 (_vala_lat_ref);
#line 8784 "PhotoMetadata.c"
		}
#line 1159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (altitude) {
#line 1159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*altitude = _vala_altitude;
#line 8790 "PhotoMetadata.c"
		}
#line 1159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 8794 "PhotoMetadata.c"
	}
#line 1162 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = photo_metadata_get_string (self, "Exif.GPSInfo.GPSLongitudeRef", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1162 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_vala_long_ref);
#line 1162 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_long_ref = _tmp5_;
#line 1163 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = photo_metadata_get_string (self, "Exif.GPSInfo.GPSLatitudeRef", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1163 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_vala_lat_ref);
#line 1163 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_lat_ref = _tmp6_;
#line 1165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = TRUE;
#line 1165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (longitude) {
#line 1165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*longitude = _vala_longitude;
#line 8814 "PhotoMetadata.c"
	}
#line 1165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (long_ref) {
#line 1165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*long_ref = _vala_long_ref;
#line 8820 "PhotoMetadata.c"
	} else {
#line 1165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_vala_long_ref);
#line 8824 "PhotoMetadata.c"
	}
#line 1165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (latitude) {
#line 1165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*latitude = _vala_latitude;
#line 8830 "PhotoMetadata.c"
	}
#line 1165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (lat_ref) {
#line 1165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*lat_ref = _vala_lat_ref;
#line 8836 "PhotoMetadata.c"
	} else {
#line 1165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_vala_lat_ref);
#line 8840 "PhotoMetadata.c"
	}
#line 1165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (altitude) {
#line 1165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*altitude = _vala_altitude;
#line 8846 "PhotoMetadata.c"
	}
#line 1165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8850 "PhotoMetadata.c"
}


gboolean
photo_metadata_get_exposure (PhotoMetadata* self,
                             MetadataRational* exposure)
{
	MetadataRational _vala_exposure = {0};
	gboolean result = FALSE;
	MetadataRational _tmp0_ = {0};
	gboolean _tmp1_;
#line 1168 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 1169 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_rational (self, "Exif.Photo.ExposureTime", &_tmp0_);
#line 1169 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_exposure = _tmp0_;
#line 1169 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 1169 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (exposure) {
#line 1169 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*exposure = _vala_exposure;
#line 8874 "PhotoMetadata.c"
	}
#line 1169 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8878 "PhotoMetadata.c"
}


gchar*
photo_metadata_get_exposure_string (PhotoMetadata* self)
{
	gchar* result = NULL;
	MetadataRational exposure_time = {0};
	MetadataRational _tmp0_ = {0};
	gboolean _tmp1_;
	gchar* _tmp2_;
#line 1172 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1174 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_rational (self, "Exif.Photo.ExposureTime", &_tmp0_);
#line 1174 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	exposure_time = _tmp0_;
#line 1174 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp1_) {
#line 1175 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 1175 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 8902 "PhotoMetadata.c"
	}
#line 1177 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!metadata_rational_is_valid (&exposure_time)) {
#line 1178 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 1178 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 8910 "PhotoMetadata.c"
	}
#line 1180 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = photo_metadata_get_string_interpreted (self, "Exif.Photo.ExposureTime", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1180 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp2_;
#line 1180 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8918 "PhotoMetadata.c"
}


gboolean
photo_metadata_get_iso (PhotoMetadata* self,
                        glong* iso)
{
	glong _vala_iso = 0L;
	gboolean result = FALSE;
	gboolean fetched_ok = FALSE;
	glong _tmp0_ = 0L;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	glong _tmp4_;
#line 1183 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 1184 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_long (self, "Exif.Photo.ISOSpeedRatings", &_tmp0_);
#line 1184 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_iso = _tmp0_;
#line 1184 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	fetched_ok = _tmp1_;
#line 1186 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = fetched_ok;
#line 1186 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp2_ == FALSE) {
#line 1187 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = FALSE;
#line 1187 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (iso) {
#line 1187 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*iso = _vala_iso;
#line 8952 "PhotoMetadata.c"
		}
#line 1187 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 8956 "PhotoMetadata.c"
	}
#line 1191 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = _vala_iso;
#line 1191 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp4_ < ((glong) 6)) {
#line 1191 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = TRUE;
#line 8964 "PhotoMetadata.c"
	} else {
		glong _tmp5_;
#line 1191 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = _vala_iso;
#line 1191 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = _tmp5_ > ((glong) 409600);
#line 8971 "PhotoMetadata.c"
	}
#line 1191 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp3_) {
#line 1192 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = FALSE;
#line 1192 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (iso) {
#line 1192 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*iso = _vala_iso;
#line 8981 "PhotoMetadata.c"
		}
#line 1192 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 8985 "PhotoMetadata.c"
	}
#line 1194 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = TRUE;
#line 1194 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (iso) {
#line 1194 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*iso = _vala_iso;
#line 8993 "PhotoMetadata.c"
	}
#line 1194 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8997 "PhotoMetadata.c"
}


gchar*
photo_metadata_get_iso_string (PhotoMetadata* self)
{
	gchar* result = NULL;
	glong iso = 0L;
	glong _tmp0_ = 0L;
	gboolean _tmp1_;
	gchar* _tmp2_;
#line 1197 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1199 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_iso (self, &_tmp0_);
#line 1199 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	iso = _tmp0_;
#line 1199 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp1_) {
#line 1200 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 1200 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 9021 "PhotoMetadata.c"
	}
#line 1202 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = photo_metadata_get_string_interpreted (self, "Exif.Photo.ISOSpeedRatings", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1202 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp2_;
#line 1202 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9029 "PhotoMetadata.c"
}


gboolean
photo_metadata_get_aperture (PhotoMetadata* self,
                             MetadataRational* aperture)
{
	MetadataRational _vala_aperture = {0};
	gboolean result = FALSE;
	MetadataRational _tmp0_ = {0};
	gboolean _tmp1_;
#line 1205 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 1206 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_rational (self, "Exif.Photo.FNumber", &_tmp0_);
#line 1206 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_aperture = _tmp0_;
#line 1206 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 1206 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (aperture) {
#line 1206 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*aperture = _vala_aperture;
#line 9053 "PhotoMetadata.c"
	}
#line 1206 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9057 "PhotoMetadata.c"
}


gchar*
photo_metadata_get_aperture_string (PhotoMetadata* self,
                                    gboolean pango_formatted)
{
	gchar* result = NULL;
	MetadataRational aperture = {0};
	MetadataRational _tmp0_ = {0};
	gboolean _tmp1_;
	gdouble aperture_value = 0.0;
	MetadataRational _tmp2_;
	gint _tmp3_;
	MetadataRational _tmp4_;
	gint _tmp5_;
	gdouble _tmp6_;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
#line 1209 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1211 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_aperture (self, &_tmp0_);
#line 1211 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	aperture = _tmp0_;
#line 1211 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp1_) {
#line 1212 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 1212 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 9095 "PhotoMetadata.c"
	}
#line 1214 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = aperture;
#line 1214 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = _tmp2_.numerator;
#line 1214 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = aperture;
#line 1214 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = _tmp4_.denominator;
#line 1214 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	aperture_value = ((gdouble) _tmp3_) / ((gdouble) _tmp5_);
#line 1215 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = aperture_value;
#line 1215 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	aperture_value = ((gint) (_tmp6_ * 10.0)) / 10.0;
#line 1217 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (pango_formatted) {
#line 1217 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = "<i>f</i>/";
#line 9115 "PhotoMetadata.c"
	} else {
#line 1217 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = "f/";
#line 9119 "PhotoMetadata.c"
	}
#line 1218 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = aperture_value;
#line 1218 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (fmod (_tmp9_, 1) == ((gdouble) 0)) {
#line 1218 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp8_ = "%.0f";
#line 9127 "PhotoMetadata.c"
	} else {
#line 1218 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp8_ = "%.1f";
#line 9131 "PhotoMetadata.c"
	}
#line 1217 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_ = aperture_value;
#line 1217 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_ = g_strdup_printf (_tmp8_, _tmp10_);
#line 1217 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12_ = _tmp11_;
#line 1217 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13_ = g_strconcat (_tmp7_, _tmp12_, NULL);
#line 1217 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp14_ = _tmp13_;
#line 1217 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp12_);
#line 1217 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp14_;
#line 1217 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9149 "PhotoMetadata.c"
}


gchar*
photo_metadata_get_camera_make (PhotoMetadata* self)
{
	gchar* result = NULL;
	gchar* _tmp0_;
#line 1221 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1222 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_string_interpreted (self, "Exif.Image.Make", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1222 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 1222 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9166 "PhotoMetadata.c"
}


gchar*
photo_metadata_get_camera_model (PhotoMetadata* self)
{
	gchar* result = NULL;
	gchar* _tmp0_;
#line 1225 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1226 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_string_interpreted (self, "Exif.Image.Model", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1226 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 1226 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9183 "PhotoMetadata.c"
}


gboolean
photo_metadata_get_flash (PhotoMetadata* self,
                          glong* flash)
{
	glong _vala_flash = 0L;
	gboolean result = FALSE;
	glong _tmp0_ = 0L;
	gboolean _tmp1_;
#line 1229 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 1231 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_long (self, "Exif.Photo.Flash", &_tmp0_);
#line 1231 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_flash = _tmp0_;
#line 1231 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 1231 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (flash) {
#line 1231 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*flash = _vala_flash;
#line 9207 "PhotoMetadata.c"
	}
#line 1231 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9211 "PhotoMetadata.c"
}


gchar*
photo_metadata_get_flash_string (PhotoMetadata* self)
{
	gchar* result = NULL;
	gchar* _tmp0_;
#line 1234 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1236 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_string_interpreted (self, "Exif.Photo.Flash", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1236 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 1236 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9228 "PhotoMetadata.c"
}


gboolean
photo_metadata_get_focal_length (PhotoMetadata* self,
                                 MetadataRational* focal_length)
{
	MetadataRational _vala_focal_length = {0};
	gboolean result = FALSE;
	MetadataRational _tmp0_ = {0};
	gboolean _tmp1_;
#line 1239 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 1240 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_rational (self, "Exif.Photo.FocalLength", &_tmp0_);
#line 1240 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_focal_length = _tmp0_;
#line 1240 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 1240 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (focal_length) {
#line 1240 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*focal_length = _vala_focal_length;
#line 9252 "PhotoMetadata.c"
	}
#line 1240 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9256 "PhotoMetadata.c"
}


gchar*
photo_metadata_get_focal_length_string (PhotoMetadata* self)
{
	gchar* result = NULL;
	gchar* _tmp0_;
#line 1243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1244 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_string_interpreted (self, "Exif.Photo.FocalLength", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1244 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 1244 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9273 "PhotoMetadata.c"
}


gchar*
photo_metadata_get_artist (PhotoMetadata* self)
{
	gchar* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar* _tmp1_;
#line 1253 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1254 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_ARTIST_TAGS;
#line 1254 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_ARTIST_TAGS_length1;
#line 1254 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_first_string_interpreted (self, _tmp0_, _tmp0__length1);
#line 1254 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 1254 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9296 "PhotoMetadata.c"
}


gchar*
photo_metadata_get_copyright (PhotoMetadata* self)
{
	gchar* result = NULL;
	gchar* _tmp0_;
#line 1257 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1258 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_string_interpreted (self, "Exif.Image.Copyright", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1258 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 1258 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9313 "PhotoMetadata.c"
}


gchar*
photo_metadata_get_software (PhotoMetadata* self)
{
	gchar* result = NULL;
	gchar* _tmp0_;
#line 1261 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1262 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_string_interpreted (self, "Exif.Image.Software", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1262 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 1262 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9330 "PhotoMetadata.c"
}


void
photo_metadata_set_software (PhotoMetadata* self,
                             const gchar* software,
                             const gchar* version)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 1265 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 1265 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (software != NULL);
#line 1265 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (version != NULL);
#line 1267 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = g_strdup_printf ("%s %s", software, version);
#line 1267 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = _tmp0_;
#line 1267 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_string (self, "Exif.Image.Software", _tmp1_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1267 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp1_);
#line 1269 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (photo_metadata_has_iptc (self)) {
#line 1270 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_string (self, "Iptc.Application2.Program", software, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1271 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_string (self, "Iptc.Application2.ProgramVersion", version, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 9361 "PhotoMetadata.c"
	}
}


void
photo_metadata_remove_software (PhotoMetadata* self)
{
#line 1275 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 1276 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_remove_tag (self, "Exif.Image.Software");
#line 1277 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_remove_tag (self, "Iptc.Application2.Program");
#line 1278 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_remove_tag (self, "Iptc.Application2.ProgramVersion");
#line 9377 "PhotoMetadata.c"
}


gchar*
photo_metadata_get_exposure_bias (PhotoMetadata* self)
{
	gchar* result = NULL;
	gchar* _tmp0_;
#line 1281 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1282 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_string_interpreted (self, "Exif.Photo.ExposureBiasValue", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1282 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 1282 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9394 "PhotoMetadata.c"
}


Rating
photo_metadata_get_rating (PhotoMetadata* self)
{
	Rating result = 0;
	gchar* rating_string = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gint int_percent_rating = 0;
	const gchar* _tmp6_;
#line 1293 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), 0);
#line 1294 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_RATING_TAGS;
#line 1294 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_RATING_TAGS_length1;
#line 1294 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_first_string (self, _tmp0_, _tmp0__length1);
#line 1294 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	rating_string = _tmp1_;
#line 1295 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = rating_string;
#line 1295 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp2_ != NULL) {
#line 9425 "PhotoMetadata.c"
		const gchar* _tmp3_;
#line 1296 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = rating_string;
#line 1296 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = rating_unserialize (atoi (_tmp3_));
#line 1296 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (rating_string);
#line 1296 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 9435 "PhotoMetadata.c"
	}
#line 1298 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = photo_metadata_get_string (self, "Exif.Image.RatingPercent", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1298 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (rating_string);
#line 1298 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	rating_string = _tmp4_;
#line 1299 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = rating_string;
#line 1299 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp5_ == NULL) {
#line 1300 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = RATING_UNRATED;
#line 1300 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (rating_string);
#line 1300 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 9453 "PhotoMetadata.c"
	}
#line 1303 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = rating_string;
#line 1303 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	int_percent_rating = atoi (_tmp6_);
#line 9459 "PhotoMetadata.c"
	{
		gint i = 0;
#line 1304 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		i = 5;
#line 9464 "PhotoMetadata.c"
		{
			gboolean _tmp7_ = FALSE;
#line 1304 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp7_ = TRUE;
#line 1304 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			while (TRUE) {
#line 9471 "PhotoMetadata.c"
				gint _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
#line 1304 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!_tmp7_) {
#line 9478 "PhotoMetadata.c"
					gint _tmp8_;
#line 1304 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp8_ = i;
#line 1304 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					i = _tmp8_ - 1;
#line 9484 "PhotoMetadata.c"
				}
#line 1304 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp7_ = FALSE;
#line 1304 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp9_ = i;
#line 1304 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!(_tmp9_ >= 0)) {
#line 1304 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					break;
#line 9494 "PhotoMetadata.c"
				}
#line 1305 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp10_ = int_percent_rating;
#line 1305 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp11_ = i;
#line 1305 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp12_ = RESOURCES_rating_thresholds[_tmp11_];
#line 1305 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp10_ >= _tmp12_) {
#line 9504 "PhotoMetadata.c"
					gint _tmp13_;
#line 1306 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp13_ = i;
#line 1306 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					result = rating_unserialize (_tmp13_);
#line 1306 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_free0 (rating_string);
#line 1306 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					return result;
#line 9514 "PhotoMetadata.c"
				}
			}
		}
	}
#line 1308 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = rating_unserialize (-1);
#line 1308 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (rating_string);
#line 1308 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9525 "PhotoMetadata.c"
}


void
photo_metadata_set_rating (PhotoMetadata* self,
                           Rating rating)
{
	gint int_rating = 0;
	gint _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_;
#line 1316 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 1317 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	int_rating = rating_serialize (rating);
#line 1318 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = int_rating;
#line 1318 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup_printf ("%i", _tmp0_);
#line 1318 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = _tmp1_;
#line 1318 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_string (self, "Xmp.xmp.Rating", _tmp2_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1318 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp2_);
#line 1319 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = int_rating;
#line 1319 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
#line 1319 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = _tmp4_;
#line 1319 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_string (self, "Exif.Image.Rating", _tmp5_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1319 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp5_);
#line 1321 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = int_rating;
#line 1321 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (0 <= _tmp6_) {
#line 9569 "PhotoMetadata.c"
		gint _tmp7_;
		gint _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1322 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = int_rating;
#line 1322 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp8_ = RESOURCES_rating_thresholds[_tmp7_];
#line 1322 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = g_strdup_printf ("%i", _tmp8_);
#line 1322 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = _tmp9_;
#line 1322 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_string (self, "Exif.Image.RatingPercent", _tmp10_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1322 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_tmp10_);
#line 9586 "PhotoMetadata.c"
	} else {
		gint _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
#line 1324 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp11_ = int_rating;
#line 1324 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp12_ = g_strdup_printf ("%i", _tmp11_);
#line 1324 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp13_ = _tmp12_;
#line 1324 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_string (self, "Exif.Image.RatingPercent", _tmp13_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1324 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_tmp13_);
#line 9601 "PhotoMetadata.c"
	}
}


static gpointer
_media_metadata_ref0 (gpointer self)
{
#line 235 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self ? media_metadata_ref (self) : NULL;
#line 9611 "PhotoMetadata.c"
}


static PhotoMetadataInternalPhotoPreview*
photo_metadata_internal_photo_preview_construct (GType object_type,
                                                 PhotoMetadata* owner,
                                                 const gchar* name,
                                                 guint number,
                                                 GExiv2PreviewProperties* props)
{
	PhotoMetadataInternalPhotoPreview* self = NULL;
	Dimensions _tmp0_ = {0};
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	PhotoMetadata* _tmp3_;
#line 230 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (owner), NULL);
#line 230 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 230 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (GEXIV2_IS_PREVIEW_PROPERTIES (props), NULL);
#line 232 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	dimensions_init (&_tmp0_, (gint) gexiv2_preview_properties_get_width (props), (gint) gexiv2_preview_properties_get_height (props));
#line 232 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = gexiv2_preview_properties_get_mime_type (props);
#line 232 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = gexiv2_preview_properties_get_extension (props);
#line 232 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = (PhotoMetadataInternalPhotoPreview*) photo_preview_construct (object_type, name, &_tmp0_, gexiv2_preview_properties_get_size (props), _tmp1_, _tmp2_);
#line 235 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = _media_metadata_ref0 (owner);
#line 235 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_media_metadata_unref0 (self->owner);
#line 235 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->owner = _tmp3_;
#line 236 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->number = number;
#line 230 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self;
#line 9651 "PhotoMetadata.c"
}


static PhotoMetadataInternalPhotoPreview*
photo_metadata_internal_photo_preview_new (PhotoMetadata* owner,
                                           const gchar* name,
                                           guint number,
                                           GExiv2PreviewProperties* props)
{
#line 230 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return photo_metadata_internal_photo_preview_construct (PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW, owner, name, number, props);
#line 9663 "PhotoMetadata.c"
}


static GBytes*
photo_metadata_internal_photo_preview_real_flatten (PhotoPreview* base,
                                                    GError** error)
{
	PhotoMetadataInternalPhotoPreview * self;
	GBytes* result = NULL;
	GExiv2PreviewProperties** props = NULL;
	PhotoMetadata* _tmp0_;
	GExiv2Metadata* _tmp1_;
	GExiv2PreviewProperties** _tmp2_;
	GExiv2PreviewProperties** _tmp3_;
	gint props_length1;
	gint _props_size_;
	gboolean _tmp4_ = FALSE;
	GExiv2PreviewProperties** _tmp5_;
	gint _tmp5__length1;
	PhotoMetadata* _tmp8_;
	GExiv2Metadata* _tmp9_;
	GExiv2PreviewProperties** _tmp10_;
	gint _tmp10__length1;
	guint _tmp11_;
	GExiv2PreviewProperties* _tmp12_;
	GExiv2PreviewImage* _tmp13_;
	GExiv2PreviewImage* _tmp14_;
	guint32 _tmp15_;
	guint8* _tmp16_;
	GBytes* _tmp17_;
	GBytes* _tmp18_;
#line 239 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW, PhotoMetadataInternalPhotoPreview);
#line 240 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->owner;
#line 240 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = _tmp0_->priv->exiv2;
#line 240 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = _tmp2_ = gexiv2_metadata_get_preview_properties (_tmp1_);
#line 240 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	props = _tmp3_;
#line 240 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	props_length1 = _vala_array_length (_tmp2_);
#line 240 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_props_size_ = props_length1;
#line 241 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = props;
#line 241 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5__length1 = props_length1;
#line 241 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp5_ != NULL) {
#line 9715 "PhotoMetadata.c"
		GExiv2PreviewProperties** _tmp6_;
		gint _tmp6__length1;
		guint _tmp7_;
#line 241 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = props;
#line 241 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6__length1 = props_length1;
#line 241 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = self->number;
#line 241 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = ((guint) _tmp6__length1) > _tmp7_;
#line 9727 "PhotoMetadata.c"
	} else {
#line 241 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = FALSE;
#line 9731 "PhotoMetadata.c"
	}
#line 241 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_assert (_tmp4_, "props != null && props.length > number");
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = self->owner;
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = _tmp8_->priv->exiv2;
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_ = props;
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10__length1 = props_length1;
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_ = self->number;
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12_ = _tmp10_[_tmp11_];
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13_ = gexiv2_metadata_get_preview_image (_tmp9_, _tmp12_);
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp14_ = _tmp13_;
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp16_ = gexiv2_preview_image_get_data (_tmp14_, &_tmp15_);
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp17_ = g_bytes_new (_tmp16_, _tmp15_);
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp18_ = _tmp17_;
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (_tmp14_);
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp18_;
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9763 "PhotoMetadata.c"
}


static void
photo_metadata_internal_photo_preview_class_init (PhotoMetadataInternalPhotoPreviewClass * klass)
{
#line 226 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_internal_photo_preview_parent_class = g_type_class_peek_parent (klass);
#line 226 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((PhotoPreviewClass *) klass)->finalize = photo_metadata_internal_photo_preview_finalize;
#line 226 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((PhotoPreviewClass *) klass)->flatten = (GBytes* (*) (PhotoPreview *, GError**)) photo_metadata_internal_photo_preview_real_flatten;
#line 9776 "PhotoMetadata.c"
}


static void
photo_metadata_internal_photo_preview_instance_init (PhotoMetadataInternalPhotoPreview * self)
{
}


static void
photo_metadata_internal_photo_preview_finalize (PhotoPreview * obj)
{
	PhotoMetadataInternalPhotoPreview * self;
#line 226 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW, PhotoMetadataInternalPhotoPreview);
#line 227 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_media_metadata_unref0 (self->owner);
#line 226 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	PHOTO_PREVIEW_CLASS (photo_metadata_internal_photo_preview_parent_class)->finalize (obj);
#line 9796 "PhotoMetadata.c"
}


static GType
photo_metadata_internal_photo_preview_get_type (void)
{
	static volatile gsize photo_metadata_internal_photo_preview_type_id__volatile = 0;
	if (g_once_init_enter (&photo_metadata_internal_photo_preview_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoMetadataInternalPhotoPreviewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_metadata_internal_photo_preview_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoMetadataInternalPhotoPreview), 0, (GInstanceInitFunc) photo_metadata_internal_photo_preview_instance_init, NULL };
		GType photo_metadata_internal_photo_preview_type_id;
		photo_metadata_internal_photo_preview_type_id = g_type_register_static (TYPE_PHOTO_PREVIEW, "PhotoMetadataInternalPhotoPreview", &g_define_type_info, 0);
		g_once_init_leave (&photo_metadata_internal_photo_preview_type_id__volatile, photo_metadata_internal_photo_preview_type_id);
	}
	return photo_metadata_internal_photo_preview_type_id__volatile;
}


static void
photo_metadata_class_init (PhotoMetadataClass * klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar** _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar** _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar** _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar** _tmp37_;
	NullKeywordTransformer* _tmp38_;
	NullKeywordTransformer* _tmp39_;
	HierarchicalKeywordField* _tmp40_;
	NullKeywordTransformer* _tmp41_;
	NullKeywordTransformer* _tmp42_;
	HierarchicalKeywordField* _tmp43_;
	ACDSeeKeywordTransformer* _tmp44_;
	ACDSeeKeywordTransformer* _tmp45_;
	HierarchicalKeywordField* _tmp46_;
	NullKeywordTransformer* _tmp47_;
	NullKeywordTransformer* _tmp48_;
	HierarchicalKeywordField* _tmp49_;
	NullKeywordTransformer* _tmp50_;
	NullKeywordTransformer* _tmp51_;
	HierarchicalKeywordField* _tmp52_;
	HierarchicalKeywordField** _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar** _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar** _tmp63_;
#line 211 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_parent_class = g_type_class_peek_parent (klass);
#line 211 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((MediaMetadataClass *) klass)->finalize = photo_metadata_finalize;
#line 211 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_type_class_add_private (klass, sizeof (PhotoMetadataPrivate));
#line 211 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((MediaMetadataClass *) klass)->read_from_file = (void (*) (MediaMetadata *, GFile*, GError**)) photo_metadata_real_read_from_file;
#line 211 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((MediaMetadataClass *) klass)->get_creation_date_time = (MetadataDateTime* (*) (MediaMetadata *)) photo_metadata_real_get_creation_date_time;
#line 211 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((MediaMetadataClass *) klass)->get_title = (gchar* (*) (MediaMetadata *)) photo_metadata_real_get_title;
#line 211 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((MediaMetadataClass *) klass)->get_comment = (gchar* (*) (MediaMetadata *)) photo_metadata_real_get_comment;
#line 800 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = g_strdup ("Exif.Image.DateTime");
#line 800 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup ("Xmp.tiff.DateTime");
#line 800 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = g_strdup ("Xmp.xmp.ModifyDate");
#line 800 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = g_strdup ("Xmp.acdsee.datetime");
#line 800 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = g_new0 (gchar*, 4 + 1);
#line 800 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_[0] = _tmp0_;
#line 800 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_[1] = _tmp1_;
#line 800 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_[2] = _tmp2_;
#line 800 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_[3] = _tmp3_;
#line 800 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_DATE_TIME_TAGS = _tmp4_;
#line 800 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_DATE_TIME_TAGS_length1 = 4;
#line 819 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = g_strdup ("Exif.Photo.DateTimeOriginal");
#line 819 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = g_strdup ("Xmp.exif.DateTimeOriginal");
#line 819 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = g_strdup ("Xmp.xmp.CreateDate");
#line 819 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = g_strdup ("Exif.Photo.DateTimeDigitized");
#line 819 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = g_strdup ("Xmp.exif.DateTimeDigitized");
#line 819 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_ = g_strdup ("Exif.Image.DateTime");
#line 819 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_ = g_new0 (gchar*, 6 + 1);
#line 819 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_[0] = _tmp5_;
#line 819 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_[1] = _tmp6_;
#line 819 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_[2] = _tmp7_;
#line 819 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_[3] = _tmp8_;
#line 819 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_[4] = _tmp9_;
#line 819 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_[5] = _tmp10_;
#line 819 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_EXPOSURE_DATE_TIME_TAGS = _tmp11_;
#line 819 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_EXPOSURE_DATE_TIME_TAGS_length1 = 6;
#line 840 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12_ = g_strdup ("Exif.Photo.DateTimeDigitized");
#line 840 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13_ = g_strdup ("Xmp.exif.DateTimeDigitized");
#line 840 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp14_ = g_new0 (gchar*, 2 + 1);
#line 840 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp14_[0] = _tmp12_;
#line 840 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp14_[1] = _tmp13_;
#line 840 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_DIGITIZED_DATE_TIME_TAGS = _tmp14_;
#line 840 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_DIGITIZED_DATE_TIME_TAGS_length1 = 2;
#line 865 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp15_ = g_strdup ("Exif.Photo.PixelXDimension");
#line 865 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp16_ = g_strdup ("Xmp.exif.PixelXDimension");
#line 865 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp17_ = g_strdup ("Xmp.tiff.ImageWidth");
#line 865 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp18_ = g_strdup ("Xmp.exif.PixelXDimension");
#line 865 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp19_ = g_new0 (gchar*, 4 + 1);
#line 865 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp19_[0] = _tmp15_;
#line 865 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp19_[1] = _tmp16_;
#line 865 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp19_[2] = _tmp17_;
#line 865 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp19_[3] = _tmp18_;
#line 865 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_WIDTH_TAGS = _tmp19_;
#line 865 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_WIDTH_TAGS_length1 = 4;
#line 872 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp20_ = g_strdup ("Exif.Photo.PixelYDimension");
#line 872 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp21_ = g_strdup ("Xmp.exif.PixelYDimension");
#line 872 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp22_ = g_strdup ("Xmp.tiff.ImageHeight");
#line 872 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp23_ = g_strdup ("Xmp.exif.PixelYDimension");
#line 872 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp24_ = g_new0 (gchar*, 4 + 1);
#line 872 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp24_[0] = _tmp20_;
#line 872 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp24_[1] = _tmp21_;
#line 872 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp24_[2] = _tmp22_;
#line 872 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp24_[3] = _tmp23_;
#line 872 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_HEIGHT_TAGS = _tmp24_;
#line 872 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_HEIGHT_TAGS_length1 = 4;
#line 931 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp25_ = g_strdup ("Iptc.Application2.Caption");
#line 931 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp26_ = g_strdup ("Xmp.dc.title");
#line 931 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp27_ = g_strdup ("Iptc.Application2.Headline");
#line 931 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp28_ = g_strdup ("Xmp.photoshop.Headline");
#line 931 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp29_ = g_strdup ("Xmp.acdsee.caption");
#line 931 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp30_ = g_new0 (gchar*, 5 + 1);
#line 931 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp30_[0] = _tmp25_;
#line 931 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp30_[1] = _tmp26_;
#line 931 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp30_[2] = _tmp27_;
#line 931 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp30_[3] = _tmp28_;
#line 931 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp30_[4] = _tmp29_;
#line 931 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_STANDARD_TITLE_TAGS = _tmp30_;
#line 931 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_STANDARD_TITLE_TAGS_length1 = 5;
#line 976 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp31_ = g_strdup ("Exif.Photo.UserComment");
#line 976 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp32_ = g_strdup ("Xmp.acdsee.notes");
#line 976 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp33_ = g_new0 (gchar*, 2 + 1);
#line 976 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp33_[0] = _tmp31_;
#line 976 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp33_[1] = _tmp32_;
#line 976 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_COMMENT_TAGS = _tmp33_;
#line 976 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_COMMENT_TAGS_length1 = 2;
#line 998 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp34_ = g_strdup ("Xmp.dc.subject");
#line 998 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp35_ = g_strdup ("Iptc.Application2.Keywords");
#line 998 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp36_ = g_strdup ("Xmp.xmp.Label");
#line 998 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp37_ = g_new0 (gchar*, 3 + 1);
#line 998 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp37_[0] = _tmp34_;
#line 998 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp37_[1] = _tmp35_;
#line 998 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp37_[2] = _tmp36_;
#line 998 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_KEYWORD_TAGS = _tmp37_;
#line 998 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_KEYWORD_TAGS_length1 = 3;
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp38_ = null_keyword_transformer_new ();
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp39_ = _tmp38_;
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp40_ = hierarchical_keyword_field_new ("Xmp.lr.hierarchicalSubject", "|", FALSE, FALSE, G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, TYPE_KEYWORD_TRANSFORMER, KeywordTransformer));
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp41_ = null_keyword_transformer_new ();
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp42_ = _tmp41_;
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp43_ = hierarchical_keyword_field_new ("Xmp.acdsee.keywords", "|", FALSE, FALSE, G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, TYPE_KEYWORD_TRANSFORMER, KeywordTransformer));
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp44_ = acd_see_keyword_transformer_new ();
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp45_ = _tmp44_;
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp46_ = hierarchical_keyword_field_new ("Xmp.acdsee.categories", "|", FALSE, FALSE, G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, TYPE_KEYWORD_TRANSFORMER, KeywordTransformer));
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp47_ = null_keyword_transformer_new ();
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp48_ = _tmp47_;
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp49_ = hierarchical_keyword_field_new ("Xmp.digiKam.TagsList", "/", FALSE, TRUE, G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, TYPE_KEYWORD_TRANSFORMER, KeywordTransformer));
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp50_ = null_keyword_transformer_new ();
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp51_ = _tmp50_;
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp52_ = hierarchical_keyword_field_new ("Xmp.MicrosoftPhoto.LastKeywordXMP", "/", FALSE, TRUE, G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, TYPE_KEYWORD_TRANSFORMER, KeywordTransformer));
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp53_ = g_new0 (HierarchicalKeywordField*, 5 + 1);
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp53_[0] = _tmp40_;
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp53_[1] = _tmp43_;
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp53_[2] = _tmp46_;
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp53_[3] = _tmp49_;
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp53_[4] = _tmp52_;
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_HIERARCHICAL_KEYWORD_TAGS = _tmp53_;
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_HIERARCHICAL_KEYWORD_TAGS_length1 = 5;
#line 1247 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp54_ = g_strdup ("Exif.Image.Artist");
#line 1247 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp55_ = g_strdup ("Exif.Canon.OwnerName");
#line 1247 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp56_ = g_strdup ("Xmp.acdsee.author");
#line 1247 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp57_ = g_new0 (gchar*, 3 + 1);
#line 1247 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp57_[0] = _tmp54_;
#line 1247 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp57_[1] = _tmp55_;
#line 1247 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp57_[2] = _tmp56_;
#line 1247 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_ARTIST_TAGS = _tmp57_;
#line 1247 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_ARTIST_TAGS_length1 = 3;
#line 1285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp58_ = g_strdup ("Xmp.xmp.Rating");
#line 1285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp59_ = g_strdup ("Iptc.Application2.Urgency");
#line 1285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp60_ = g_strdup ("Xmp.photoshop.Urgency");
#line 1285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp61_ = g_strdup ("Exif.Image.Rating");
#line 1285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp62_ = g_strdup ("Xmp.acdsee.rating");
#line 1285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp63_ = g_new0 (gchar*, 5 + 1);
#line 1285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp63_[0] = _tmp58_;
#line 1285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp63_[1] = _tmp59_;
#line 1285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp63_[2] = _tmp60_;
#line 1285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp63_[3] = _tmp61_;
#line 1285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp63_[4] = _tmp62_;
#line 1285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_RATING_TAGS = _tmp63_;
#line 1285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_RATING_TAGS_length1 = 5;
#line 10153 "PhotoMetadata.c"
}


static void
photo_metadata_instance_init (PhotoMetadata * self)
{
	GExiv2Metadata* _tmp0_;
	gchar* _tmp1_;
#line 211 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv = PHOTO_METADATA_GET_PRIVATE (self);
#line 248 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = gexiv2_metadata_new ();
#line 248 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exiv2 = _tmp0_;
#line 249 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exif = NULL;
#line 250 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup ("<uninitialized>");
#line 250 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->source_name = _tmp1_;
#line 251 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->metadata_hash = NULL;
#line 252 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->thumbnail_md5 = NULL;
#line 10178 "PhotoMetadata.c"
}


static void
photo_metadata_finalize (MediaMetadata * obj)
{
	PhotoMetadata * self;
#line 211 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_METADATA, PhotoMetadata);
#line 248 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (self->priv->exiv2);
#line 249 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_exif_data_unref0 (self->priv->exif);
#line 250 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->source_name);
#line 251 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->metadata_hash);
#line 252 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->thumbnail_md5);
#line 211 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	MEDIA_METADATA_CLASS (photo_metadata_parent_class)->finalize (obj);
#line 10200 "PhotoMetadata.c"
}


GType
photo_metadata_get_type (void)
{
	static volatile gsize photo_metadata_type_id__volatile = 0;
	if (g_once_init_enter (&photo_metadata_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoMetadataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_metadata_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoMetadata), 0, (GInstanceInitFunc) photo_metadata_instance_init, NULL };
		GType photo_metadata_type_id;
		photo_metadata_type_id = g_type_register_static (TYPE_MEDIA_METADATA, "PhotoMetadata", &g_define_type_info, 0);
		g_once_init_leave (&photo_metadata_type_id__volatile, photo_metadata_type_id);
	}
	return photo_metadata_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



