RabbitMQ `3.11.8` is a maintenance release in the `3.11.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.11.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.11.0)
if upgrading from a version prior to 3.11.0.

This release requires Erlang 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.11.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Erlang 25 as our new baseline means much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation available to all RabbitMQ 3.11 users.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.11.x/release-notes).

### Core Server

#### Enhancements

 * Stream throughput improvements for workloads with a lot of very small (say, less than 10 bytes)
   messages.

   GitHub issue: [#6862](https://github.com/rabbitmq/rabbitmq-server/pull/6862)


### CLI Tools

#### Features

 * `rabbitmqctl hash_password` is a new command that produces a [hashed value](https://www.rabbitmq.com/passwords.html#computing-password-hash) of the provided password.

   Contributed by @SimonUnge (AWS).

   GitHub issue: [#5957](https://github.com/rabbitmq/rabbitmq-server/issues/5957)

 * `rabbitmq-diagnostics check_port_connectivity` now supports a new optional flag, `--address`,
   that makes the check connect to a specific IP address instead of resolving node's hostname.
   This is useful when target node is configured to only listen for connections on one interface
   but not others:

   ``` shell
   rabbitmq-diagnostics check_port_connectivity --address 127.0.0.1
   rabbitmq-diagnostics check_port_connectivity --address "::1"
   ```

   GitHub issue: [#6853](https://github.com/rabbitmq/rabbitmq-server/issues/6853)


### Management Plugin

#### Bug Fixes

 * User filtering combined with pagination in the management UI did not work as expected.

   GitHub issue: [#4908](https://github.com/rabbitmq/rabbitmq-server/issues/4908)

 * Correctly format JSON field value in channel detail API response.

   Contributed @Syuparn.

   GitHub issue: [#2684](https://github.com/rabbitmq/rabbitmq-server/issues/2684)


### AMQP 1.0 Plugin

#### Bug Fixes

 * AMQP 1.0 connection churn resulted in a memory leak.

   GitHub issue: [#6969](https://github.com/rabbitmq/rabbitmq-server/issues/6969)


### STOMP Plugin

#### Bug Fixes

 * STOMP client subscriptions to a destination that is an AMQP 0-9-1 exchange now declares
   auto-delete, exclusive queues (previously only auto-delete) as promised in the docs.

   Contributed by @csicar.

   GitHub issue: [#6955](https://github.com/rabbitmq/rabbitmq-server/issues/6955)


## Dependency Upgrades

 * `osiris` was upgraded [from `1.4.2` to `1.4.3`](https://github.com/rabbitmq/osiris/tags)
 * `thoas` was upgraded [from `0.4.1` to `1.0.0`](https://github.com/lpil/thoas/releases)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.11.8.tar.xz`
instead of the source tarball produced by GitHub.
