#!/bin/sh

set -e
. ./testsuite/common.sh

testpkg='testsuite/data/pearpkg1'
testpecl='testsuite/data/peclpkg1'
testchan='testsuite/data/pearchan1'

sed -e "s@/usr/share/pkg-php-tools/overrides@${PWD}/lib/overrides@" \
    lib/scripts/phppkginfo > lib/scripts/phppkginfo.test
chmod u+x lib/scripts/phppkginfo.test
sed -e "s@/usr/share/pkg-php-tools/scripts/phppkginfo@${PWD}/lib/scripts/phppkginfo.test@" \
    bin/dh_phppear > bin/dh_phppear.test

ret=0
old_dir="${PWD}"

cd "${testpkg}"
expect_equal "perl '${old_dir}/bin/dh_phppear.test'" '' || ret=$?
expect_equal "cat 'debian/php-foo.substvars'" 'phppear:Debian-Depends=php5-common (>= 5.2.1), php-pear (>= 1.8.0)
phppear:Debian-Recommends=php5-mysql
phppear:summary=this is a wrapper package for installing dependencies for MyProject
phppear:description=<Some random notes>
phppear:channel=pear.php.net' || ret=$?
rm -f debian/php-foo.substvars debian/php-foo.debhelper.log
cd "${old_dir}"

cd "${testpecl}"
expect_equal "perl '${old_dir}/bin/dh_phppear.test'" '' || ret=$?
expect_equal "cat 'debian/php-foo.substvars'" "phppear:Debian-Depends=php5-common (>= 5.2.1), php-pear (>= 1.8.0), phpapi-$(php-config --phpapi)
phppear:summary=this is a wrapper package for installing dependencies for MyProject
phppear:description=<Some random notes>
phppear:channel=pear.php.net" || ret=$?
rm -f debian/php-foo.substvars debian/php-foo.debhelper.log
cd "${old_dir}"

cd "${testchan}"
expect_equal "perl '${old_dir}/bin/dh_phppear.test'" '' || ret=$?
expect_equal "cat 'debian/php-foo.substvars'" 'phppear:channel-name=pear.horde.org
phppear:channel-summary=Horde PEAR server
phppear:channel-alias=horde
phppear:channel-common-description=This is the PEAR channel registry entry for horde.${Newline}${Newline}PEAR is a framework and distribution system for reusable PHP components. A${Newline}PEAR channel is a website that provides package for download and a few${Newline}extra meta-information for files.' || ret=$?
rm -f debian/php-foo.substvars debian/php-foo.debhelper.log
cd "${old_dir}"

rm bin/dh_phppear.test
rm lib/scripts/phppkginfo.test

exit $ret
