#ifndef INCLUDE_DEBUG_H
#define INCLUDE_DEBUG_H
/* ----------------------------------------------------------------------------
 * debug.h
 * definitions for debugging. This file describes in detail which debug
 * information should be printed to console. The symbol DEBUG must also
 * be defined. It is the master key for all of this options.
 *
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

/* emulation flags for non available hardware */
#define SIMU_I386     0 /* =1, some i386 specific calls will be redirected */
#define SIMU_ACPI     0 /* =1, read acpi info from home instead of /proc */
#define SIMU_AMBIENT  0 /* =1 for simulating ambient light sensor */

/* module_powersave.c */
#define SLEEPLOCKS    0 /* =1 for printing sleeplock status to console */
#define IBAM          0 /* =1 for printing adaptive battery time */

/* module_pmac.c & module_imac.c */
#define PMUINTR       0 /* =1 for printing PMU interrupts to console */
#define PMUTALK       0 /* =1 for logging PMU communication into /var/log/pbbuttonsd */
#define TRACKPAD      0 /* =1 for debugging dynamic trackpad reconfiguration */

/* module_cdrom.c */
#define CDROM         0 /* =1 mount and status information */
#define CDROMPERF     0 /* =1 for printing CDROM performance data to console */

/* module_display.c */
#define BRIGHTNESS    0 /* =1 show current brightness values of KBD and LCD */
#define DISPLAYTIMER  0 /* =1 show when the display timer is active */
#define AMBIENT       0 /* =1 for printing some ambient values to console */
#define FADING        0 /* =1 for printing fading values to console */

/* module_peep.c */
#define PEEP_IPC      1 /* =1, all tags sent to clients will be printed */
#define PEEP_CONFIG   1 /* =1, all configure tags will be printed */
#define PEEP_QUERY    1 /* =1, all query tags will be printed */
#define PEEP_SECURE   1 /* =1, all security tags will be printed */
#define PEEP_KEYBOARD 0 /* =1, keyboard events are printed */
#define PEEP_MOUSE    0 /* =1, mouse events are printed */
#define PEEP_TIMER    0 /* =1, timer events are printed */
#define PEEP_NOCYCLIC 1 /* =1, some cyclic tags will be filtered out */

/* module_acpi.c */
#define ACPI_EVENTS   0 /* =1, show information about ACPI events */
#define ACPI_PATHS    0 /* =1, show ACPI files, selected for polling */
#define ACPI_BATTERY  0 /* =1, show information about ACPI batteries */

#endif    /* INCLUDE_DEBUG_H */

