# Copyright (c) 2012 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'dependencies': [
    '../base/base.gyp:base_static',
    '../components/url_formatter/url_formatter.gyp:url_formatter',
    '../crypto/crypto.gyp:crypto',
    '../device/battery/battery.gyp:device_battery',
    '../device/battery/battery.gyp:device_battery_mojo_bindings',
    '../device/vibration/vibration.gyp:device_vibration',
    '../device/vibration/vibration.gyp:device_vibration_mojo_bindings',
    '../google_apis/google_apis.gyp:google_apis',
    '../mojo/mojo_base.gyp:mojo_application_base',
    '../mojo/mojo_base.gyp:mojo_geometry_lib',
    '../mojo/mojo_base.gyp:mojo_url_type_converters',
    '../mojo/mojo_services.gyp:network_service_bindings_lib',
    '../mojo/mojo_services.gyp:updater_bindings_lib',
    '../mojo/mojo_shell.gyp:mojo_shell_lib',
    '../mojo/mojo_shell.gyp:mojo_fetcher_lib',
    '../net/net.gyp:net',
    '../net/net.gyp:net_extras',
    '../skia/skia.gyp:skia',
    '../skia/skia.gyp:skia_mojo',
    '../sql/sql.gyp:sql',
    '../third_party/kasko/kasko.gyp:kasko_features',
    '../third_party/mojo/mojo_public.gyp:mojo_cpp_bindings',
    '../third_party/re2/re2.gyp:re2',
    '../third_party/zlib/google/zip.gyp:zip',
    '../third_party/zlib/zlib.gyp:zlib',
    '../third_party/WebKit/public/blink_headers.gyp:blink_headers',
    '../ui/accessibility/accessibility.gyp:accessibility',
    '../ui/accessibility/accessibility.gyp:ax_gen',
    '../ui/base/ui_base.gyp:ui_base',
    '../ui/base/ime/ui_base_ime.gyp:ui_base_ime',
    '../ui/events/events.gyp:events',
    '../ui/events/events.gyp:events_base',
    '../ui/events/events.gyp:gesture_detection',
    '../ui/gfx/gfx.gyp:gfx',
    '../ui/gfx/gfx.gyp:gfx_geometry',
    '../ui/resources/ui_resources.gyp:ui_resources',
    '../ui/snapshot/snapshot.gyp:snapshot',
    'browser/background_sync/background_sync_proto.gyp:background_sync_proto',
    'browser/cache_storage/cache_storage_proto.gyp:cache_storage_proto',
    'browser/notifications/notification_proto.gyp:notification_proto',
    'browser/service_worker/service_worker_proto.gyp:service_worker_proto',
    'browser/speech/proto/speech_proto.gyp:speech_proto',
    'content_common_mojo_bindings.gyp:content_common_mojo_bindings',
  ],
  'export_dependent_settings': [
    '../ui/accessibility/accessibility.gyp:ax_gen',
    # The public content API headers directly include Blink API headers, so we
    # have to export the blink header settings so that relative paths in these
    # headers resolve correctly.
    '../third_party/WebKit/public/blink_headers.gyp:blink_headers',
    # The public render_widget_host.h needs to re-export skia defines.
    '../skia/skia.gyp:skia',
    'content_common_mojo_bindings.gyp:content_common_mojo_bindings',
  ],
  'include_dirs': [
    '..',
    '<(INTERMEDIATE_DIR)',
    '<(DEPTH)/../../..',
  ],
  'variables': {
    'public_browser_sources': [
      'public/browser/access_token_store.h',
      'public/browser/android/browser_media_player_manager_register.cc',
      'public/browser/android/browser_media_player_manager_register.h',
      'public/browser/android/compositor.h',
      'public/browser/android/compositor_client.h',
      'public/browser/android/content_protocol_handler.h',
      'public/browser/android/content_view_core.h',
      'public/browser/android/content_view_layer_renderer.h',
      'public/browser/android/devtools_auth.h',
      'public/browser/android/download_controller_android.cc',
      'public/browser/android/download_controller_android.h',
      'public/browser/android/external_video_surface_container.h',
      'public/browser/android/synchronous_compositor.h',
      'public/browser/android/synchronous_compositor_client.h',
      'public/browser/appcache_service.h',
      'public/browser/ax_event_notification_details.cc',
      'public/browser/ax_event_notification_details.h',
      'public/browser/background_sync_context.h',
      'public/browser/background_sync_controller.h',
      'public/browser/background_sync_parameters.cc',
      'public/browser/background_sync_parameters.h',
      'public/browser/background_tracing_config.cc',
      'public/browser/background_tracing_config.h',
      'public/browser/background_tracing_manager.h',
      'public/browser/blob_handle.h',
      'public/browser/bluetooth_chooser.cc',
      'public/browser/bluetooth_chooser.h',
      'public/browser/browser_accessibility_state.h',
      'public/browser/browser_child_process_host.h',
      'public/browser/browser_child_process_host_delegate.cc',
      'public/browser/browser_child_process_host_delegate.h',
      'public/browser/browser_child_process_host_iterator.cc',
      'public/browser/browser_child_process_host_iterator.h',
      'public/browser/browser_child_process_observer.cc',
      'public/browser/browser_child_process_observer.h',
      'public/browser/browser_context.h',
      'public/browser/browser_ipc_logging.h',
      'public/browser/browser_main_parts.cc',
      'public/browser/browser_main_parts.h',
      'public/browser/browser_main_runner.h',
      'public/browser/browser_message_filter.cc',
      'public/browser/browser_message_filter.h',
      'public/browser/browser_plugin_guest_delegate.cc',
      'public/browser/browser_plugin_guest_delegate.h',
      'public/browser/browser_plugin_guest_manager.cc',
      'public/browser/browser_plugin_guest_manager.h',
      'public/browser/browser_ppapi_host.h',
      'public/browser/browser_thread.h',
      'public/browser/browser_thread_delegate.h',
      'public/browser/browser_url_handler.h',
      'public/browser/arc_video_host_delegate.h',
      'public/browser/cache_storage_context.h',
      'public/browser/cache_storage_usage_info.h',
      'public/browser/cert_store.h',
      'public/browser/certificate_request_result_type.h',
      'public/browser/child_process_data.h',
      'public/browser/child_process_security_policy.h',
      'public/browser/client_certificate_delegate.h',
      'public/browser/color_chooser.h',
      'public/browser/content_browser_client.cc',
      'public/browser/content_browser_client.h',
      'public/browser/context_factory.h',
      'public/browser/cookie_store_factory.h',
      'public/browser/desktop_media_id.cc',
      'public/browser/desktop_media_id.h',
      'public/browser/desktop_notification_delegate.h',
      'public/browser/devtools_agent_host.h',
      'public/browser/devtools_agent_host_client.h',
      'public/browser/devtools_external_agent_proxy.h',
      'public/browser/devtools_external_agent_proxy_delegate.h',
      'public/browser/devtools_frontend_host.h',
      'public/browser/devtools_manager_delegate.h',
      'public/browser/dom_storage_context.h',
      'public/browser/download_danger_type.h',
      'public/browser/download_destination_observer.h',
      'public/browser/download_interrupt_reason_values.h',
      'public/browser/download_interrupt_reasons.h',
      'public/browser/download_item.h',
      'public/browser/download_manager.h',
      'public/browser/download_manager_delegate.cc',
      'public/browser/download_manager_delegate.h',
      'public/browser/download_save_info.cc',
      'public/browser/download_save_info.h',
      'public/browser/download_url_parameters.cc',
      'public/browser/download_url_parameters.h',
      'public/browser/favicon_status.cc',
      'public/browser/favicon_status.h',
      'public/browser/file_descriptor_info.h',
      'public/browser/focused_node_details.h',
      'public/browser/font_list_async.h',
      'public/browser/geolocation_provider.h',
      'public/browser/global_request_id.h',
      'public/browser/gpu_data_manager.h',
      'public/browser/gpu_data_manager_observer.h',
      'public/browser/histogram_fetcher.h',
      'public/browser/host_zoom_map.h',
      'public/browser/indexed_db_context.h',
      'public/browser/indexed_db_info.h',
      'public/browser/interstitial_page.h',
      'public/browser/interstitial_page_delegate.cc',
      'public/browser/interstitial_page_delegate.h',
      'public/browser/invalidate_type.h',
      'public/browser/javascript_dialog_manager.cc',
      'public/browser/javascript_dialog_manager.h',
      'public/browser/load_from_memory_cache_details.cc',
      'public/browser/load_from_memory_cache_details.h',
      'public/browser/load_notification_details.h',
      'public/browser/local_storage_usage_info.h',
      'public/browser/location_provider.h',
      'public/browser/media_capture_devices.h',
      'public/browser/media_device_id.cc',
      'public/browser/media_device_id.h',
      'public/browser/message_port_delegate.h',
      'public/browser/message_port_provider.h',
      'public/browser/mojo_app_connection.h',
      'public/browser/native_web_keyboard_event.h',
      'public/browser/navigation_controller.cc',
      'public/browser/navigation_controller.h',
      'public/browser/navigation_details.cc',
      'public/browser/navigation_details.h',
      'public/browser/navigation_entry.h',
      'public/browser/navigation_handle.cc',
      'public/browser/navigation_handle.h',
      'public/browser/navigation_throttle.cc',
      'public/browser/navigation_throttle.h',
      'public/browser/navigation_type.h',
      'public/browser/navigator_connect_context.h',
      'public/browser/navigator_connect_service_factory.h',
      'public/browser/notification_database_data.h',
      'public/browser/notification_details.h',
      'public/browser/notification_event_dispatcher.h',
      'public/browser/notification_observer.h',
      'public/browser/notification_registrar.cc',
      'public/browser/notification_registrar.h',
      'public/browser/notification_service.h',
      'public/browser/notification_source.h',
      'public/browser/notification_types.h',
      'public/browser/overscroll_configuration.h',
      'public/browser/page_navigator.cc',
      'public/browser/page_navigator.h',
      'public/browser/pepper_flash_settings_helper.h',
      'public/browser/permission_manager.h',
      'public/browser/permission_type.h',
      'public/browser/platform_notification_context.h',
      'public/browser/platform_notification_service.h',
      'public/browser/plugin_data_remover.h',
      'public/browser/plugin_service.h',
      'public/browser/plugin_service_filter.h',
      'public/browser/power_save_blocker.h',
      'public/browser/presentation_screen_availability_listener.h',
      'public/browser/presentation_service_delegate.h',
      'public/browser/presentation_session.cc',
      'public/browser/presentation_session.h',
      'public/browser/presentation_session_message.cc',
      'public/browser/presentation_session_message.h',
      'public/browser/profiler_controller.h',
      'public/browser/profiler_subscriber.h',
      'public/browser/push_messaging_service.cc',
      'public/browser/push_messaging_service.h',
      'public/browser/quota_permission_context.h',
      'public/browser/readback_types.h',
      'public/browser/render_frame_host.h',
      'public/browser/render_process_host.h',
      'public/browser/render_process_host_factory.h',
      'public/browser/render_process_host_observer.h',
      'public/browser/render_view_host.h',
      'public/browser/render_widget_host.h',
      'public/browser/render_widget_host_view.h',
      'public/browser/render_widget_host_view_frame_subscriber.h',
      'public/browser/render_widget_host_view_mac_delegate.h',
      'public/browser/resource_context.h',
      'public/browser/resource_controller.h',
      'public/browser/resource_dispatcher_host.h',
      'public/browser/resource_dispatcher_host_delegate.cc',
      'public/browser/resource_dispatcher_host_delegate.h',
      'public/browser/resource_dispatcher_host_login_delegate.h',
      'public/browser/resource_request_details.cc',
      'public/browser/resource_request_details.h',
      'public/browser/resource_request_info.h',
      'public/browser/resource_throttle.h',
      'public/browser/save_page_type.h',
      'public/browser/screen_orientation_delegate.h',
      'public/browser/screen_orientation_dispatcher_host.h',
      'public/browser/screen_orientation_provider.cc',
      'public/browser/screen_orientation_provider.h',
      'public/browser/security_style_explanation.h',
      'public/browser/security_style_explanations.cc',
      'public/browser/security_style_explanations.h',
      'public/browser/service_worker_context.h',
      'public/browser/service_worker_usage_info.cc',
      'public/browser/service_worker_usage_info.h',
      'public/browser/session_storage_namespace.h',
      'public/browser/session_storage_usage_info.h',
      'public/browser/signed_certificate_timestamp_store.h',
      'public/browser/site_instance.h',
      'public/browser/speech_recognition_event_listener.h',
      'public/browser/speech_recognition_manager.h',
      'public/browser/speech_recognition_manager_delegate.h',
      'public/browser/speech_recognition_session_config.cc',
      'public/browser/speech_recognition_session_config.h',
      'public/browser/speech_recognition_session_context.cc',
      'public/browser/speech_recognition_session_context.h',
      'public/browser/speech_recognition_session_preamble.cc',
      'public/browser/speech_recognition_session_preamble.h',
      'public/browser/ssl_host_state_delegate.h',
      'public/browser/storage_partition.h',
      'public/browser/stream_handle.h',
      'public/browser/stream_info.cc',
      'public/browser/stream_info.h',
      'public/browser/trace_uploader.h',
      'public/browser/tracing_controller.h',
      'public/browser/tracing_delegate.cc',
      'public/browser/tracing_delegate.h',
      'public/browser/url_data_source.cc',
      'public/browser/url_data_source.h',
      'public/browser/user_metrics.h',
      'public/browser/utility_process_host.h',
      'public/browser/web_contents.cc',
      'public/browser/web_contents.h',
      'public/browser/web_contents_delegate.cc',
      'public/browser/web_contents_delegate.h',
      'public/browser/web_contents_media_capture_id.cc',
      'public/browser/web_contents_media_capture_id.h',
      'public/browser/web_contents_observer.cc',
      'public/browser/web_contents_observer.h',
      'public/browser/web_contents_user_data.h',
      'public/browser/web_contents_view_delegate.cc',
      'public/browser/web_contents_view_delegate.h',
      'public/browser/web_drag_dest_delegate.h',
      'public/browser/web_ui.h',
      'public/browser/web_ui_controller.cc',
      'public/browser/web_ui_controller.h',
      'public/browser/web_ui_controller_factory.h',
      'public/browser/web_ui_data_source.h',
      'public/browser/web_ui_message_handler.h',
      'public/browser/worker_service.h',
      'public/browser/worker_service_observer.h',
      'public/browser/zoom_level_delegate.h',
      'public/browser/zygote_host_linux.h',
    ],
    'private_browser_sources': [
      # These files are generated by GRIT.
      '<(SHARED_INTERMEDIATE_DIR)/blink/grit/devtools_resources.h',
      '<(SHARED_INTERMEDIATE_DIR)/blink/grit/devtools_resources_map.cc',
      '<(SHARED_INTERMEDIATE_DIR)/blink/grit/devtools_resources_map.h',
      # These files are generated by devtools_protocol_handler_generator.py.
      '<(SHARED_INTERMEDIATE_DIR)/content/browser/devtools/protocol/devtools_protocol_dispatcher.cc',
      '<(SHARED_INTERMEDIATE_DIR)/content/browser/devtools/protocol/devtools_protocol_dispatcher.h',
      '<(SHARED_INTERMEDIATE_DIR)/content/browser/tracing/grit/tracing_resources.h',
      '<(SHARED_INTERMEDIATE_DIR)/ui/resources/grit/webui_resources_map.cc',
      'browser/accessibility/accessibility_mode_helper.cc',
      'browser/accessibility/accessibility_mode_helper.h',
      'browser/accessibility/accessibility_tree_formatter.cc',
      'browser/accessibility/accessibility_tree_formatter.h',
      'browser/accessibility/accessibility_tree_formatter_blink.cc',
      'browser/accessibility/accessibility_tree_formatter_blink.h',
      'browser/accessibility/accessibility_tree_formatter_mac.mm',
      'browser/accessibility/accessibility_tree_formatter_stub.cc',
      'browser/accessibility/accessibility_tree_formatter_utils_win.cc',
      'browser/accessibility/accessibility_tree_formatter_utils_win.h',
      'browser/accessibility/accessibility_tree_formatter_win.cc',
      'browser/accessibility/accessibility_ui.cc',
      'browser/accessibility/accessibility_ui.h',
      'browser/accessibility/ax_tree_id_registry.cc',
      'browser/accessibility/ax_tree_id_registry.h',
      'browser/accessibility/browser_accessibility.cc',
      'browser/accessibility/browser_accessibility.h',
      'browser/accessibility/browser_accessibility_cocoa.h',
      'browser/accessibility/browser_accessibility_cocoa.mm',
      'browser/accessibility/browser_accessibility_mac.h',
      'browser/accessibility/browser_accessibility_mac.mm',
      'browser/accessibility/browser_accessibility_manager.cc',
      'browser/accessibility/browser_accessibility_manager.h',
      'browser/accessibility/browser_accessibility_manager_mac.h',
      'browser/accessibility/browser_accessibility_manager_mac.mm',
      'browser/accessibility/browser_accessibility_manager_win.cc',
      'browser/accessibility/browser_accessibility_manager_win.h',
      'browser/accessibility/browser_accessibility_state_impl.cc',
      'browser/accessibility/browser_accessibility_state_impl.h',
      'browser/accessibility/browser_accessibility_state_impl_win.cc',
      'browser/accessibility/browser_accessibility_win.cc',
      'browser/accessibility/browser_accessibility_win.h',
      'browser/accessibility/one_shot_accessibility_tree_search.cc',
      'browser/accessibility/one_shot_accessibility_tree_search.h',
      'browser/android/background_sync_network_observer_android.cc',
      'browser/android/background_sync_network_observer_android.h',
      'browser/android/browser_jni_registrar.cc',
      'browser/android/browser_jni_registrar.h',
      'browser/android/browser_startup_controller.cc',
      'browser/android/browser_startup_controller.h',
      'browser/android/browser_surface_texture_manager.cc',
      'browser/android/browser_surface_texture_manager.h',
      'browser/android/child_process_launcher_android.cc',
      'browser/android/child_process_launcher_android.h',
      'browser/android/content_protocol_handler_impl.cc',
      'browser/android/content_protocol_handler_impl.h',
      'browser/android/content_startup_flags.cc',
      'browser/android/content_startup_flags.h',
      'browser/android/content_video_view.cc',
      'browser/android/content_video_view.h',
      'browser/android/devtools_auth.cc',
      'browser/android/in_process_surface_texture_manager.cc',
      'browser/android/in_process_surface_texture_manager.h',
      'public/browser/android/download_controller_android.h',
      'browser/android/url_request_content_job.cc',
      'browser/android/url_request_content_job.h',
      'browser/appcache/appcache.cc',
      'browser/appcache/appcache.h',
      'browser/appcache/appcache_backend_impl.cc',
      'browser/appcache/appcache_backend_impl.h',
      'browser/appcache/appcache_database.cc',
      'browser/appcache/appcache_database.h',
      'browser/appcache/appcache_disk_cache.cc',
      'browser/appcache/appcache_disk_cache.h',
      'browser/appcache/appcache_dispatcher_host.cc',
      'browser/appcache/appcache_dispatcher_host.h',
      'browser/appcache/appcache_entry.h',
      'browser/appcache/appcache_executable_handler.h',
      'browser/appcache/appcache_frontend_proxy.cc',
      'browser/appcache/appcache_frontend_proxy.h',
      'browser/appcache/appcache_group.cc',
      'browser/appcache/appcache_group.h',
      'browser/appcache/appcache_histograms.cc',
      'browser/appcache/appcache_histograms.h',
      'browser/appcache/appcache_host.cc',
      'browser/appcache/appcache_host.h',
      'browser/appcache/appcache_interceptor.cc',
      'browser/appcache/appcache_interceptor.h',
      'browser/appcache/appcache_internals_ui.cc',
      'browser/appcache/appcache_internals_ui.h',
      'browser/appcache/appcache_manifest_parser.cc',
      'browser/appcache/appcache_manifest_parser.h',
      'browser/appcache/appcache_policy.h',
      'browser/appcache/appcache_quota_client.cc',
      'browser/appcache/appcache_quota_client.h',
      'browser/appcache/appcache_request_handler.cc',
      'browser/appcache/appcache_request_handler.h',
      'browser/appcache/appcache_response.cc',
      'browser/appcache/appcache_response.h',
      'browser/appcache/appcache_service_impl.cc',
      'browser/appcache/appcache_service_impl.h',
      'browser/appcache/appcache_storage.cc',
      'browser/appcache/appcache_storage.h',
      'browser/appcache/appcache_storage_impl.cc',
      'browser/appcache/appcache_storage_impl.h',
      'browser/appcache/appcache_update_job.cc',
      'browser/appcache/appcache_update_job.h',
      'browser/appcache/appcache_url_request_job.cc',
      'browser/appcache/appcache_url_request_job.h',
      'browser/appcache/appcache_working_set.cc',
      'browser/appcache/appcache_working_set.h',
      'browser/appcache/chrome_appcache_service.cc',
      'browser/appcache/chrome_appcache_service.h',
      'browser/background_sync/background_sync_context_impl.cc',
      'browser/background_sync/background_sync_context_impl.h',
      'browser/background_sync/background_sync_manager.cc',
      'browser/background_sync/background_sync_manager.h',
      'browser/background_sync/background_sync_metrics.cc',
      'browser/background_sync/background_sync_metrics.h',
      'browser/background_sync/background_sync_network_observer.cc',
      'browser/background_sync/background_sync_network_observer.h',
      'browser/background_sync/background_sync_power_observer.cc',
      'browser/background_sync/background_sync_power_observer.h',
      'browser/background_sync/background_sync_registration.cc',
      'browser/background_sync/background_sync_registration.h',
      'browser/background_sync/background_sync_registration_handle.cc',
      'browser/background_sync/background_sync_registration_handle.h',
      'browser/background_sync/background_sync_registration_options.cc',
      'browser/background_sync/background_sync_registration_options.h',
      'browser/background_sync/background_sync_service_impl.cc',
      'browser/background_sync/background_sync_service_impl.h',
      'browser/background_sync/background_sync_status.h',
      'browser/bad_message.cc',
      'browser/bad_message.h',
      'browser/bluetooth/bluetooth_allowed_devices_map.cc',
      'browser/bluetooth/bluetooth_allowed_devices_map.h',
      'browser/bluetooth/bluetooth_dispatcher_host.cc',
      'browser/bluetooth/bluetooth_dispatcher_host.h',
      'browser/bluetooth/bluetooth_metrics.cc',
      'browser/bluetooth/bluetooth_metrics.h',
      'browser/bluetooth/first_device_bluetooth_chooser.cc',
      'browser/bluetooth/first_device_bluetooth_chooser.h',
      'browser/bootstrap_sandbox_manager_mac.cc',
      'browser/bootstrap_sandbox_manager_mac.h',
      'browser/browser_child_process_host_impl.cc',
      'browser/browser_child_process_host_impl.h',
      'browser/browser_context.cc',
      'browser/browser_ipc_logging.cc',
      'browser/browser_main.cc',
      'browser/browser_main.h',
      'browser/browser_main_loop.cc',
      'browser/browser_main_loop.h',
      'browser/browser_main_runner.cc',
      'browser/browser_plugin/browser_plugin_embedder.cc',
      'browser/browser_plugin/browser_plugin_embedder.h',
      'browser/browser_plugin/browser_plugin_guest.cc',
      'browser/browser_plugin/browser_plugin_guest.h',
      'browser/browser_plugin/browser_plugin_message_filter.cc',
      'browser/browser_plugin/browser_plugin_message_filter.h',
      'browser/browser_plugin/browser_plugin_popup_menu_helper_mac.h',
      'browser/browser_plugin/browser_plugin_popup_menu_helper_mac.mm',
      'browser/browser_process_sub_thread.cc',
      'browser/browser_process_sub_thread.h',
      'browser/browser_shutdown_profile_dumper.cc',
      'browser/browser_shutdown_profile_dumper.h',
      'browser/browser_thread_impl.cc',
      'browser/browser_thread_impl.h',
      'browser/browser_url_handler_impl.cc',
      'browser/browser_url_handler_impl.h',
      'browser/browsing_instance.cc',
      'browser/browsing_instance.h',
      'browser/byte_stream.cc',
      'browser/byte_stream.h',
      'browser/cache_storage/cache_storage.cc',
      'browser/cache_storage/cache_storage.h',
      'browser/cache_storage/cache_storage_blob_to_disk_cache.cc',
      'browser/cache_storage/cache_storage_blob_to_disk_cache.h',
      'browser/cache_storage/cache_storage_cache.cc',
      'browser/cache_storage/cache_storage_cache.h',
      'browser/cache_storage/cache_storage_context_impl.cc',
      'browser/cache_storage/cache_storage_context_impl.h',
      'browser/cache_storage/cache_storage_dispatcher_host.cc',
      'browser/cache_storage/cache_storage_dispatcher_host.h',
      'browser/cache_storage/cache_storage_manager.cc',
      'browser/cache_storage/cache_storage_manager.h',
      'browser/cache_storage/cache_storage_quota_client.cc',
      'browser/cache_storage/cache_storage_quota_client.h',
      'browser/cache_storage/cache_storage_scheduler.cc',
      'browser/cache_storage/cache_storage_scheduler.h',
      'browser/cert_store_impl.cc',
      'browser/cert_store_impl.h',
      'browser/child_process_launcher.cc',
      'browser/child_process_launcher.h',
      'browser/child_process_security_policy_impl.cc',
      'browser/child_process_security_policy_impl.h',
      'browser/cocoa/system_hotkey_helper_mac.h',
      'browser/cocoa/system_hotkey_helper_mac.mm',
      'browser/cocoa/system_hotkey_map.h',
      'browser/cocoa/system_hotkey_map.mm',
      'browser/device_monitor_mac.h',
      'browser/device_monitor_mac.mm',
      'browser/device_monitor_udev.cc',
      'browser/device_monitor_udev.h',
      'browser/device_sensors/ambient_light_mac.cc',
      'browser/device_sensors/ambient_light_mac.h',
      'browser/device_sensors/data_fetcher_shared_memory.h',
      'browser/device_sensors/data_fetcher_shared_memory_android.cc',
      'browser/device_sensors/data_fetcher_shared_memory_base.cc',
      'browser/device_sensors/data_fetcher_shared_memory_base.h',
      'browser/device_sensors/data_fetcher_shared_memory_chromeos.cc',
      'browser/device_sensors/data_fetcher_shared_memory_default.cc',
      'browser/device_sensors/data_fetcher_shared_memory_mac.cc',
      'browser/device_sensors/data_fetcher_shared_memory_win.cc',
      'browser/device_sensors/device_inertial_sensor_service.cc',
      'browser/device_sensors/device_inertial_sensor_service.h',
      'browser/device_sensors/device_light_message_filter.cc',
      'browser/device_sensors/device_light_message_filter.h',
      'browser/device_sensors/device_motion_message_filter.cc',
      'browser/device_sensors/device_motion_message_filter.h',
      'browser/device_sensors/device_orientation_absolute_message_filter.cc',
      'browser/device_sensors/device_orientation_absolute_message_filter.h',
      'browser/device_sensors/device_orientation_message_filter.cc',
      'browser/device_sensors/device_orientation_message_filter.h',
      'browser/device_sensors/device_sensors_consts.h',
      'browser/device_sensors/sensor_manager_android.cc',
      'browser/device_sensors/sensor_manager_android.h',
      'browser/device_sensors/sensor_manager_chromeos.cc',
      'browser/device_sensors/sensor_manager_chromeos.h',
      'browser/devtools/browser_devtools_agent_host.cc',
      'browser/devtools/browser_devtools_agent_host.h',
      'browser/devtools/devtools_agent_host_impl.cc',
      'browser/devtools/devtools_agent_host_impl.h',
      'browser/devtools/devtools_frame_trace_recorder.cc',
      'browser/devtools/devtools_frame_trace_recorder.h',
      'browser/devtools/devtools_frontend_host_impl.cc',
      'browser/devtools/devtools_frontend_host_impl.h',
      'browser/devtools/devtools_io_context.cc',
      'browser/devtools/devtools_io_context.h',
      'browser/devtools/devtools_manager.cc',
      'browser/devtools/devtools_manager.h',
      'browser/devtools/devtools_netlog_observer.cc',
      'browser/devtools/devtools_netlog_observer.h',
      'browser/devtools/devtools_protocol_handler.cc',
      'browser/devtools/devtools_protocol_handler.h',
      'browser/devtools/forwarding_agent_host.cc',
      'browser/devtools/forwarding_agent_host.h',
      'browser/devtools/protocol/color_picker.cc',
      'browser/devtools/protocol/color_picker.h',
      'browser/devtools/protocol/devtools_protocol_delegate.h',
      'browser/devtools/protocol/devtools_protocol_client.cc',
      'browser/devtools/protocol/devtools_protocol_client.h',
      'browser/devtools/protocol/dom_handler.cc',
      'browser/devtools/protocol/dom_handler.h',
      'browser/devtools/protocol/emulation_handler.cc',
      'browser/devtools/protocol/emulation_handler.h',
      'browser/devtools/protocol/input_handler.cc',
      'browser/devtools/protocol/input_handler.h',
      'browser/devtools/protocol/inspector_handler.cc',
      'browser/devtools/protocol/inspector_handler.h',
      'browser/devtools/protocol/io_handler.cc',
      'browser/devtools/protocol/io_handler.h',
      'browser/devtools/protocol/memory_handler.cc',
      'browser/devtools/protocol/memory_handler.h',
      'browser/devtools/protocol/network_handler.cc',
      'browser/devtools/protocol/network_handler.h',
      'browser/devtools/protocol/page_handler.cc',
      'browser/devtools/protocol/page_handler.h',
      'browser/devtools/protocol/security_handler.cc',
      'browser/devtools/protocol/security_handler.h',
      'browser/devtools/protocol/service_worker_handler.cc',
      'browser/devtools/protocol/service_worker_handler.h',
      'browser/devtools/protocol/system_info_handler.cc',
      'browser/devtools/protocol/system_info_handler.h',
      'browser/devtools/protocol/tethering_handler.cc',
      'browser/devtools/protocol/tethering_handler.h',
      'browser/devtools/protocol/tracing_handler.cc',
      'browser/devtools/protocol/tracing_handler.h',
      'browser/devtools/render_frame_devtools_agent_host.cc',
      'browser/devtools/render_frame_devtools_agent_host.h',
      'browser/devtools/service_worker_devtools_agent_host.cc',
      'browser/devtools/service_worker_devtools_agent_host.h',
      'browser/devtools/service_worker_devtools_manager.cc',
      'browser/devtools/service_worker_devtools_manager.h',
      'browser/devtools/shared_worker_devtools_agent_host.cc',
      'browser/devtools/shared_worker_devtools_agent_host.h',
      'browser/devtools/shared_worker_devtools_manager.cc',
      'browser/devtools/shared_worker_devtools_manager.h',
      'browser/devtools/worker_devtools_agent_host.cc',
      'browser/devtools/worker_devtools_agent_host.h',
      'browser/dom_storage/dom_storage_area.cc',
      'browser/dom_storage/dom_storage_area.h',
      'browser/dom_storage/dom_storage_context_impl.cc',
      'browser/dom_storage/dom_storage_context_impl.h',
      'browser/dom_storage/dom_storage_context_wrapper.cc',
      'browser/dom_storage/dom_storage_context_wrapper.h',
      'browser/dom_storage/dom_storage_database.cc',
      'browser/dom_storage/dom_storage_database.h',
      'browser/dom_storage/dom_storage_database_adapter.h',
      'browser/dom_storage/dom_storage_host.cc',
      'browser/dom_storage/dom_storage_host.h',
      'browser/dom_storage/dom_storage_message_filter.cc',
      'browser/dom_storage/dom_storage_message_filter.h',
      'browser/dom_storage/dom_storage_namespace.cc',
      'browser/dom_storage/dom_storage_namespace.h',
      'browser/dom_storage/dom_storage_session.cc',
      'browser/dom_storage/dom_storage_session.h',
      'browser/dom_storage/dom_storage_task_runner.cc',
      'browser/dom_storage/dom_storage_task_runner.h',
      'browser/dom_storage/local_storage_database_adapter.cc',
      'browser/dom_storage/local_storage_database_adapter.h',
      'browser/dom_storage/session_storage_database.cc',
      'browser/dom_storage/session_storage_database.h',
      'browser/dom_storage/session_storage_database_adapter.cc',
      'browser/dom_storage/session_storage_database_adapter.h',
      'browser/dom_storage/session_storage_namespace_impl.cc',
      'browser/dom_storage/session_storage_namespace_impl.h',
      'browser/download/base_file.cc',
      'browser/download/base_file.h',
      'browser/download/base_file_linux.cc',
      'browser/download/base_file_mac.cc',
      'browser/download/base_file_posix.cc',
      'browser/download/base_file_win.cc',
      'browser/download/download_create_info.cc',
      'browser/download/download_create_info.h',
      'browser/download/download_file.h',
      'browser/download/download_file_factory.cc',
      'browser/download/download_file_factory.h',
      'browser/download/download_file_impl.cc',
      'browser/download/download_file_impl.h',
      'browser/download/download_interrupt_reasons_impl.cc',
      'browser/download/download_interrupt_reasons_impl.h',
      'browser/download/download_item_factory.h',
      'browser/download/download_item_impl.cc',
      'browser/download/download_item_impl.h',
      'browser/download/download_item_impl_delegate.cc',
      'browser/download/download_item_impl_delegate.h',
      'browser/download/download_manager_impl.cc',
      'browser/download/download_manager_impl.h',
      'browser/download/download_net_log_parameters.cc',
      'browser/download/download_net_log_parameters.h',
      'browser/download/download_request_core.cc',
      'browser/download/download_request_core.h',
      'browser/download/download_request_handle.cc',
      'browser/download/download_request_handle.h',
      'browser/download/download_resource_handler.cc',
      'browser/download/download_resource_handler.h',
      'browser/download/download_stats.cc',
      'browser/download/download_stats.h',
      'browser/download/drag_download_file.cc',
      'browser/download/drag_download_file.h',
      'browser/download/drag_download_util.cc',
      'browser/download/drag_download_util.h',
      'browser/download/file_metadata_linux.cc',
      'browser/download/file_metadata_linux.h',
      'browser/download/file_metadata_mac.h',
      'browser/download/file_metadata_mac.mm',
      'browser/download/mhtml_generation_manager.cc',
      'browser/download/mhtml_generation_manager.h',
      'browser/download/rate_estimator.cc',
      'browser/download/rate_estimator.h',
      'browser/download/save_file.cc',
      'browser/download/save_file.h',
      'browser/download/save_file_manager.cc',
      'browser/download/save_file_manager.h',
      'browser/download/save_file_resource_handler.cc',
      'browser/download/save_file_resource_handler.h',
      'browser/download/save_item.cc',
      'browser/download/save_item.h',
      'browser/download/save_package.cc',
      'browser/download/save_package.h',
      'browser/download/save_types.cc',
      'browser/download/save_types.h',
      'browser/download/url_downloader.cc',
      'browser/download/url_downloader.h',
      'browser/fileapi/blob_storage_host.cc',
      'browser/fileapi/blob_storage_host.h',
      'browser/fileapi/browser_file_system_helper.cc',
      'browser/fileapi/browser_file_system_helper.h',
      'browser/fileapi/chrome_blob_storage_context.cc',
      'browser/fileapi/chrome_blob_storage_context.h',
      'browser/fileapi/fileapi_message_filter.cc',
      'browser/fileapi/fileapi_message_filter.h',
      'browser/fileapi/upload_file_system_file_element_reader.cc',
      'browser/fileapi/upload_file_system_file_element_reader.h',
      'browser/font_list_async.cc',
      'browser/frame_host/cross_process_frame_connector.cc',
      'browser/frame_host/cross_process_frame_connector.h',
      'browser/frame_host/cross_site_transferring_request.cc',
      'browser/frame_host/cross_site_transferring_request.h',
      'browser/frame_host/debug_urls.cc',
      'browser/frame_host/debug_urls.h',
      'browser/frame_host/frame_mojo_shell.cc',
      'browser/frame_host/frame_mojo_shell.h',
      'browser/frame_host/frame_navigation_entry.cc',
      'browser/frame_host/frame_navigation_entry.h',
      'browser/frame_host/frame_tree.cc',
      'browser/frame_host/frame_tree.h',
      'browser/frame_host/frame_tree_node.cc',
      'browser/frame_host/frame_tree_node.h',
      'browser/frame_host/interstitial_page_impl.cc',
      'browser/frame_host/interstitial_page_impl.h',
      'browser/frame_host/interstitial_page_navigator_impl.cc',
      'browser/frame_host/interstitial_page_navigator_impl.h',
      'browser/frame_host/navigation_controller_android.cc',
      'browser/frame_host/navigation_controller_android.h',
      'browser/frame_host/navigation_controller_delegate.h',
      'browser/frame_host/navigation_controller_impl.cc',
      'browser/frame_host/navigation_controller_impl.h',
      'browser/frame_host/navigation_entry_impl.cc',
      'browser/frame_host/navigation_entry_impl.h',
      'browser/frame_host/navigation_entry_screenshot_manager.cc',
      'browser/frame_host/navigation_entry_screenshot_manager.h',
      'browser/frame_host/navigation_handle_impl.cc',
      'browser/frame_host/navigation_handle_impl.h',
      'browser/frame_host/navigation_request.cc',
      'browser/frame_host/navigation_request.h',
      'browser/frame_host/navigation_request_info.cc',
      'browser/frame_host/navigation_request_info.h',
      'browser/frame_host/navigator.cc',
      'browser/frame_host/navigator.h',
      'browser/frame_host/navigator_delegate.cc',
      'browser/frame_host/navigator_delegate.h',
      'browser/frame_host/navigator_impl.cc',
      'browser/frame_host/navigator_impl.h',
      'browser/frame_host/popup_menu_helper_mac.h',
      'browser/frame_host/popup_menu_helper_mac.mm',
      'browser/frame_host/render_frame_host_delegate.cc',
      'browser/frame_host/render_frame_host_delegate.h',
      'browser/frame_host/render_frame_host_factory.cc',
      'browser/frame_host/render_frame_host_factory.h',
      'browser/frame_host/render_frame_host_impl.cc',
      'browser/frame_host/render_frame_host_impl.h',
      'browser/frame_host/render_frame_host_manager.cc',
      'browser/frame_host/render_frame_host_manager.h',
      'browser/frame_host/render_frame_message_filter.cc',
      'browser/frame_host/render_frame_message_filter.h',
      'browser/frame_host/render_frame_proxy_host.cc',
      'browser/frame_host/render_frame_proxy_host.h',
      'browser/frame_host/render_widget_host_view_child_frame.cc',
      'browser/frame_host/render_widget_host_view_child_frame.h',
      'browser/frame_host/render_widget_host_view_guest.cc',
      'browser/frame_host/render_widget_host_view_guest.h',
      'browser/gamepad/gamepad_consumer.h',
      'browser/gamepad/gamepad_data_fetcher.h',
      'browser/gamepad/gamepad_data_fetcher.cc',
      'browser/gamepad/gamepad_platform_data_fetcher.h',
      'browser/gamepad/gamepad_platform_data_fetcher_android.cc',
      'browser/gamepad/gamepad_platform_data_fetcher_android.h',
      'browser/gamepad/gamepad_platform_data_fetcher_linux.cc',
      'browser/gamepad/gamepad_platform_data_fetcher_linux.h',
      'browser/gamepad/gamepad_platform_data_fetcher_mac.h',
      'browser/gamepad/gamepad_platform_data_fetcher_mac.mm',
      'browser/gamepad/gamepad_platform_data_fetcher_win.cc',
      'browser/gamepad/gamepad_platform_data_fetcher_win.h',
      'browser/gamepad/gamepad_provider.cc',
      'browser/gamepad/gamepad_provider.h',
      'browser/gamepad/gamepad_service.cc',
      'browser/gamepad/gamepad_service.h',
      'browser/gamepad/gamepad_standard_mappings.cc',
      'browser/gamepad/gamepad_standard_mappings.h',
      'browser/gamepad/gamepad_standard_mappings_linux.cc',
      'browser/gamepad/gamepad_standard_mappings_mac.mm',
      'browser/gamepad/gamepad_standard_mappings_win.cc',
      'browser/gamepad/raw_input_data_fetcher_win.cc',
      'browser/gamepad/raw_input_data_fetcher_win.h',
      'browser/gamepad/xbox_data_fetcher_mac.cc',
      'browser/gamepad/xbox_data_fetcher_mac.h',
      'browser/geofencing/geofencing_dispatcher_host.cc',
      'browser/geofencing/geofencing_dispatcher_host.h',
      'browser/geofencing/geofencing_manager.cc',
      'browser/geofencing/geofencing_manager.h',
      'browser/geofencing/geofencing_provider.h',
      'browser/geofencing/geofencing_registration_delegate.h',
      'browser/geofencing/geofencing_service.cc',
      'browser/geofencing/geofencing_service.h',
      'browser/geofencing/mock_geofencing_service.cc',
      'browser/geofencing/mock_geofencing_service.h',
      'browser/geolocation/empty_wifi_data_provider.cc',
      'browser/geolocation/empty_wifi_data_provider.h',
      'browser/geolocation/geolocation_provider_impl.cc',
      'browser/geolocation/geolocation_provider_impl.h',
      'browser/geolocation/geolocation_service_context.cc',
      'browser/geolocation/geolocation_service_context.h',
      'browser/geolocation/geolocation_service_impl.cc',
      'browser/geolocation/geolocation_service_impl.h',
      'browser/geolocation/location_api_adapter_android.cc',
      'browser/geolocation/location_api_adapter_android.h',
      'browser/geolocation/location_arbitrator.h',
      'browser/geolocation/location_arbitrator_impl.cc',
      'browser/geolocation/location_arbitrator_impl.h',
      'browser/geolocation/location_provider_android.cc',
      'browser/geolocation/location_provider_android.h',
      'browser/geolocation/location_provider_base.cc',
      'browser/geolocation/location_provider_base.h',
      'browser/geolocation/network_location_provider.cc',
      'browser/geolocation/network_location_provider.h',
      'browser/geolocation/network_location_request.cc',
      'browser/geolocation/network_location_request.h',
      'browser/geolocation/wifi_data.cc',
      'browser/geolocation/wifi_data.h',
      'browser/geolocation/wifi_data_provider.cc',
      'browser/geolocation/wifi_data_provider.h',
      'browser/geolocation/wifi_data_provider_chromeos.cc',
      'browser/geolocation/wifi_data_provider_chromeos.h',
      'browser/geolocation/wifi_data_provider_common.cc',
      'browser/geolocation/wifi_data_provider_common.h',
      'browser/geolocation/wifi_data_provider_common_win.cc',
      'browser/geolocation/wifi_data_provider_common_win.h',
      'browser/geolocation/wifi_data_provider_corewlan_mac.mm',
      'browser/geolocation/wifi_data_provider_linux.cc',
      'browser/geolocation/wifi_data_provider_linux.h',
      'browser/geolocation/wifi_data_provider_mac.cc',
      'browser/geolocation/wifi_data_provider_mac.h',
      'browser/geolocation/wifi_data_provider_manager.cc',
      'browser/geolocation/wifi_data_provider_manager.h',
      'browser/geolocation/wifi_data_provider_win.cc',
      'browser/geolocation/wifi_data_provider_win.h',
      'browser/geolocation/wifi_polling_policy.h',
      'browser/gpu/browser_gpu_channel_host_factory.cc',
      'browser/gpu/browser_gpu_channel_host_factory.h',
      'browser/gpu/browser_gpu_memory_buffer_manager.cc',
      'browser/gpu/browser_gpu_memory_buffer_manager.h',
      'browser/gpu/compositor_util.cc',
      'browser/gpu/compositor_util.h',
      'browser/gpu/gpu_data_manager_impl.cc',
      'browser/gpu/gpu_data_manager_impl.h',
      'browser/gpu/gpu_data_manager_impl_private.cc',
      'browser/gpu/gpu_data_manager_impl_private.h',
      'browser/gpu/gpu_internals_ui.cc',
      'browser/gpu/gpu_internals_ui.h',
      'browser/gpu/gpu_process_host.cc',
      'browser/gpu/gpu_process_host.h',
      'browser/gpu/gpu_process_host_ui_shim.cc',
      'browser/gpu/gpu_process_host_ui_shim.h',
      'browser/gpu/gpu_surface_tracker.cc',
      'browser/gpu/gpu_surface_tracker.h',
      'browser/gpu/shader_disk_cache.cc',
      'browser/gpu/shader_disk_cache.h',
      'browser/histogram_controller.cc',
      'browser/histogram_controller.h',
      'browser/histogram_internals_request_job.cc',
      'browser/histogram_internals_request_job.h',
      'browser/histogram_message_filter.cc',
      'browser/histogram_message_filter.h',
      'browser/histogram_subscriber.h',
      'browser/histogram_synchronizer.cc',
      'browser/histogram_synchronizer.h',
      'browser/host_zoom_level_context.cc',
      'browser/host_zoom_level_context.h',
      'browser/host_zoom_map_impl.cc',
      'browser/host_zoom_map_impl.h',
      'browser/indexed_db/indexed_db.h',
      'browser/indexed_db/indexed_db_active_blob_registry.cc',
      'browser/indexed_db/indexed_db_active_blob_registry.h',
      'browser/indexed_db/indexed_db_backing_store.cc',
      'browser/indexed_db/indexed_db_backing_store.h',
      'browser/indexed_db/indexed_db_blob_info.cc',
      'browser/indexed_db/indexed_db_blob_info.h',
      'browser/indexed_db/indexed_db_callbacks.cc',
      'browser/indexed_db/indexed_db_callbacks.h',
      'browser/indexed_db/indexed_db_class_factory.cc',
      'browser/indexed_db/indexed_db_class_factory.h',
      'browser/indexed_db/indexed_db_connection.cc',
      'browser/indexed_db/indexed_db_connection.h',
      'browser/indexed_db/indexed_db_context_impl.cc',
      'browser/indexed_db/indexed_db_context_impl.h',
      'browser/indexed_db/indexed_db_cursor.cc',
      'browser/indexed_db/indexed_db_cursor.h',
      'browser/indexed_db/indexed_db_database.cc',
      'browser/indexed_db/indexed_db_database.h',
      'browser/indexed_db/indexed_db_database_callbacks.cc',
      'browser/indexed_db/indexed_db_database_callbacks.h',
      'browser/indexed_db/indexed_db_database_error.cc',
      'browser/indexed_db/indexed_db_database_error.h',
      'browser/indexed_db/indexed_db_dispatcher_host.cc',
      'browser/indexed_db/indexed_db_dispatcher_host.h',
      'browser/indexed_db/indexed_db_factory.h',
      'browser/indexed_db/indexed_db_factory_impl.cc',
      'browser/indexed_db/indexed_db_factory_impl.h',
      'browser/indexed_db/indexed_db_index_writer.cc',
      'browser/indexed_db/indexed_db_index_writer.h',
      'browser/indexed_db/indexed_db_internals_ui.cc',
      'browser/indexed_db/indexed_db_internals_ui.h',
      'browser/indexed_db/indexed_db_leveldb_coding.cc',
      'browser/indexed_db/indexed_db_leveldb_coding.h',
      'browser/indexed_db/indexed_db_metadata.cc',
      'browser/indexed_db/indexed_db_metadata.h',
      'browser/indexed_db/indexed_db_pending_connection.cc',
      'browser/indexed_db/indexed_db_pending_connection.h',
      'browser/indexed_db/indexed_db_quota_client.cc',
      'browser/indexed_db/indexed_db_quota_client.h',
      'browser/indexed_db/indexed_db_return_value.h',
      'browser/indexed_db/indexed_db_transaction.cc',
      'browser/indexed_db/indexed_db_transaction.h',
      'browser/indexed_db/indexed_db_transaction_coordinator.cc',
      'browser/indexed_db/indexed_db_transaction_coordinator.h',
      'browser/indexed_db/indexed_db_value.cc',
      'browser/indexed_db/indexed_db_value.h',
      'browser/indexed_db/leveldb/leveldb_comparator.h',
      'browser/indexed_db/leveldb/leveldb_database.cc',
      'browser/indexed_db/leveldb/leveldb_database.h',
      'browser/indexed_db/leveldb/leveldb_env.cc',
      'browser/indexed_db/leveldb/leveldb_env.h',
      'browser/indexed_db/leveldb/leveldb_factory.h',
      'browser/indexed_db/leveldb/leveldb_iterator.h',
      'browser/indexed_db/leveldb/leveldb_iterator_impl.cc',
      'browser/indexed_db/leveldb/leveldb_iterator_impl.h',
      'browser/indexed_db/leveldb/leveldb_transaction.cc',
      'browser/indexed_db/leveldb/leveldb_transaction.h',
      'browser/indexed_db/leveldb/leveldb_write_batch.cc',
      'browser/indexed_db/leveldb/leveldb_write_batch.h',
      'browser/loader/async_resource_handler.cc',
      'browser/loader/async_resource_handler.h',
      'browser/loader/async_revalidation_driver.cc',
      'browser/loader/async_revalidation_driver.h',
      'browser/loader/async_revalidation_manager.cc',
      'browser/loader/async_revalidation_manager.h',
      'browser/loader/cross_site_resource_handler.cc',
      'browser/loader/cross_site_resource_handler.h',
      'browser/loader/detachable_resource_handler.cc',
      'browser/loader/detachable_resource_handler.h',
      'browser/loader/global_routing_id.h',
      'browser/loader/layered_resource_handler.cc',
      'browser/loader/layered_resource_handler.h',
      'browser/loader/mime_type_resource_handler.cc',
      'browser/loader/mime_type_resource_handler.h',
      'browser/loader/navigation_resource_handler.cc',
      'browser/loader/navigation_resource_handler.h',
      'browser/loader/navigation_resource_throttle.cc',
      'browser/loader/navigation_resource_throttle.h',
      'browser/loader/navigation_url_loader.cc',
      'browser/loader/navigation_url_loader.h',
      'browser/loader/navigation_url_loader_delegate.h',
      'browser/loader/navigation_url_loader_factory.h',
      'browser/loader/navigation_url_loader_impl.cc',
      'browser/loader/navigation_url_loader_impl.h',
      'browser/loader/navigation_url_loader_impl_core.cc',
      'browser/loader/navigation_url_loader_impl_core.h',
      'browser/loader/power_save_block_resource_throttle.cc',
      'browser/loader/power_save_block_resource_throttle.h',
      'browser/loader/redirect_to_file_resource_handler.cc',
      'browser/loader/redirect_to_file_resource_handler.h',
      'browser/loader/resource_buffer.cc',
      'browser/loader/resource_buffer.h',
      'browser/loader/resource_dispatcher_host_impl.cc',
      'browser/loader/resource_dispatcher_host_impl.h',
      'browser/loader/resource_handler.cc',
      'browser/loader/resource_handler.h',
      'browser/loader/resource_loader.cc',
      'browser/loader/resource_loader.h',
      'browser/loader/resource_loader_delegate.h',
      'browser/loader/resource_message_delegate.cc',
      'browser/loader/resource_message_delegate.h',
      'browser/loader/resource_message_filter.cc',
      'browser/loader/resource_message_filter.h',
      'browser/loader/resource_request_info_impl.cc',
      'browser/loader/resource_request_info_impl.h',
      'browser/loader/resource_scheduler.cc',
      'browser/loader/resource_scheduler.h',
      'browser/loader/resource_scheduler_filter.cc',
      'browser/loader/resource_scheduler_filter.h',
      'browser/loader/stream_resource_handler.cc',
      'browser/loader/stream_resource_handler.h',
      'browser/loader/stream_writer.cc',
      'browser/loader/stream_writer.h',
      'browser/loader/sync_resource_handler.cc',
      'browser/loader/sync_resource_handler.h',
      'browser/loader/temporary_file_stream.cc',
      'browser/loader/temporary_file_stream.h',
      'browser/loader/throttling_resource_handler.cc',
      'browser/loader/throttling_resource_handler.h',
      'browser/loader/upload_data_stream_builder.cc',
      'browser/loader/upload_data_stream_builder.h',
      'browser/mach_broker_mac.h',
      'browser/mach_broker_mac.mm',
      'browser/manifest/manifest_manager_host.cc',
      'browser/manifest/manifest_manager_host.h',
      'browser/media/android/browser_demuxer_android.cc',
      'browser/media/android/browser_demuxer_android.h',
      'browser/media/android/browser_media_player_manager.cc',
      'browser/media/android/browser_media_player_manager.h',
      'browser/media/android/browser_media_session_manager.cc',
      'browser/media/android/browser_media_session_manager.h',
      'browser/media/android/media_resource_getter_impl.cc',
      'browser/media/android/media_resource_getter_impl.h',
      'browser/media/android/media_session.cc',
      'browser/media/android/media_session.h',
      'browser/media/android/media_session_observer.h',
      'browser/media/android/media_session_uma_helper.cc',
      'browser/media/android/media_session_uma_helper.h',
      'browser/media/android/media_throttler.cc',
      'browser/media/android/media_throttler.h',
      'browser/media/android/media_web_contents_observer_android.cc',
      'browser/media/android/media_web_contents_observer_android.h',
      'browser/media/android/provision_fetcher_impl.cc',
      'browser/media/android/provision_fetcher_impl.h',
      'browser/media/android/url_provision_fetcher.cc',
      'browser/media/android/url_provision_fetcher.h',
      'browser/media/audible_metrics.cc',
      'browser/media/audible_metrics.h',
      'browser/media/audio_stream_monitor.cc',
      'browser/media/audio_stream_monitor.h',
      'browser/media/capture/audio_mirroring_manager.cc',
      'browser/media/capture/audio_mirroring_manager.h',
      'browser/media/capture/cursor_renderer.h',
      'browser/media/capture/cursor_renderer_aura.cc',
      'browser/media/capture/cursor_renderer_aura.h',
      'browser/media/capture/web_contents_audio_input_stream.cc',
      'browser/media/capture/web_contents_audio_input_stream.h',
      'browser/media/capture/web_contents_audio_muter.cc',
      'browser/media/capture/web_contents_audio_muter.h',
      'browser/media/capture/web_contents_tracker.cc',
      'browser/media/capture/web_contents_tracker.h',
      'browser/media/capture/web_contents_video_capture_device.cc',
      'browser/media/capture/web_contents_video_capture_device.h',
      'browser/media/capture/window_activity_tracker.h',
      'browser/media/capture/window_activity_tracker_aura.cc',
      'browser/media/capture/window_activity_tracker_aura.h',
      'browser/media/media_internals.cc',
      'browser/media/media_internals.h',
      'browser/media/media_internals_handler.cc',
      'browser/media/media_internals_handler.h',
      'browser/media/media_internals_proxy.cc',
      'browser/media/media_internals_proxy.h',
      'browser/media/media_internals_ui.cc',
      'browser/media/media_internals_ui.h',
      'browser/media/media_web_contents_observer.cc',
      'browser/media/media_web_contents_observer.h',
      'browser/media/midi_host.cc',
      'browser/media/midi_host.h',
      'browser/media/webrtc_identity_store.cc',
      'browser/media/webrtc_identity_store.h',
      'browser/media/webrtc_identity_store_backend.cc',
      'browser/media/webrtc_identity_store_backend.h',
      'browser/memory/memory_message_filter.cc',
      'browser/memory/memory_message_filter.h',
      'browser/memory/memory_pressure_controller.cc',
      'browser/memory/memory_pressure_controller.h',
      'browser/message_port_message_filter.cc',
      'browser/message_port_message_filter.h',
      'browser/message_port_provider.cc',
      'browser/message_port_service.cc',
      'browser/message_port_service.h',
      'browser/mime_registry_message_filter.cc',
      'browser/mime_registry_message_filter.h',
      'browser/mojo/mojo_app_connection_impl.cc',
      'browser/mojo/mojo_app_connection_impl.h',
      'browser/mojo/mojo_application_host.cc',
      'browser/mojo/mojo_application_host.h',
      'browser/mojo/mojo_shell_context.cc',
      'browser/mojo/mojo_shell_context.h',
      'browser/mojo/service_registrar_android.cc',
      'browser/mojo/service_registrar_android.h',
      'browser/mojo/service_registry_android.cc',
      'browser/mojo/service_registry_android.h',
      'browser/navigator_connect/navigator_connect_context_impl.cc',
      'browser/navigator_connect/navigator_connect_context_impl.h',
      'browser/navigator_connect/service_port_service_impl.cc',
      'browser/navigator_connect/service_port_service_impl.h',
      'browser/net/browser_online_state_observer.cc',
      'browser/net/browser_online_state_observer.h',
      'browser/net/network_errors_listing_ui.cc',
      'browser/net/network_errors_listing_ui.h',
      'browser/net/quota_policy_cookie_store.cc',
      'browser/net/quota_policy_cookie_store.h',
      'browser/net/view_blob_internals_job_factory.cc',
      'browser/net/view_blob_internals_job_factory.h',
      'browser/net/view_http_cache_job_factory.cc',
      'browser/net/view_http_cache_job_factory.h',
      'browser/notification_service_impl.cc',
      'browser/notification_service_impl.h',
      'browser/notifications/notification_database.cc',
      'browser/notifications/notification_database.h',
      'browser/notifications/notification_database_data_conversions.cc',
      'browser/notifications/notification_database_data_conversions.h',
      'browser/notifications/notification_event_dispatcher_impl.cc',
      'browser/notifications/notification_event_dispatcher_impl.h',
      'browser/notifications/notification_id_generator.cc',
      'browser/notifications/notification_id_generator.h',
      'browser/notifications/notification_message_filter.cc',
      'browser/notifications/notification_message_filter.h',
      'browser/notifications/page_notification_delegate.cc',
      'browser/notifications/page_notification_delegate.h',
      'browser/notifications/platform_notification_context_impl.cc',
      'browser/notifications/platform_notification_context_impl.h',
      'browser/permissions/permission_service_context.cc',
      'browser/permissions/permission_service_context.h',
      'browser/permissions/permission_service_impl.cc',
      'browser/permissions/permission_service_impl.h',
      'browser/power_monitor_message_broadcaster.cc',
      'browser/power_monitor_message_broadcaster.h',
      'browser/power_save_blocker_android.h',
      'browser/power_save_blocker_chromeos.cc',
      'browser/power_save_blocker_impl.cc',
      'browser/power_save_blocker_impl.h',
      'browser/power_save_blocker_mac.cc',
      #'browser/power_save_blocker_ozone.cc',
      'browser/power_save_blocker_win.cc',
      'browser/power_save_blocker_x11.cc',
      'browser/power_usage_monitor_impl.cc',
      'browser/power_usage_monitor_impl.h',
      'browser/presentation/presentation_service_impl.cc',
      'browser/presentation/presentation_service_impl.h',
      'browser/presentation/presentation_type_converters.cc',
      'browser/presentation/presentation_type_converters.h',
      'browser/profiler_controller_impl.cc',
      'browser/profiler_controller_impl.h',
      'browser/profiler_message_filter.cc',
      'browser/profiler_message_filter.h',
      'browser/push_messaging/push_messaging_message_filter.cc',
      'browser/push_messaging/push_messaging_message_filter.h',
      'browser/push_messaging/push_messaging_router.cc',
      'browser/push_messaging/push_messaging_router.h',
      'browser/quota_dispatcher_host.cc',
      'browser/quota_dispatcher_host.h',
      'browser/renderer_data_memoizing_store.h',
      'browser/renderer_host/begin_frame_observer_proxy.cc',
      'browser/renderer_host/begin_frame_observer_proxy.h',
      'browser/renderer_host/clipboard_message_filter.cc',
      'browser/renderer_host/clipboard_message_filter.h',
      'browser/renderer_host/clipboard_message_filter_mac.mm',
      'browser/renderer_host/compositor_resize_lock_aura.cc',
      'browser/renderer_host/compositor_resize_lock_aura.h',
      'browser/renderer_host/database_message_filter.cc',
      'browser/renderer_host/database_message_filter.h',
      'browser/renderer_host/delegated_frame_evictor.cc',
      'browser/renderer_host/delegated_frame_evictor.h',
      'browser/renderer_host/dip_util.cc',
      'browser/renderer_host/dip_util.h',
      'browser/renderer_host/dwrite_font_proxy_message_filter_win.cc',
      'browser/renderer_host/dwrite_font_proxy_message_filter_win.h',
      'browser/renderer_host/event_with_latency_info.h',
      'browser/renderer_host/file_utilities_message_filter.cc',
      'browser/renderer_host/file_utilities_message_filter.h',
      'browser/renderer_host/font_utils_linux.cc',
      'browser/renderer_host/font_utils_linux.h',
      'browser/renderer_host/frame_metadata_util.cc',
      'browser/renderer_host/frame_metadata_util.h',
      'browser/renderer_host/gamepad_browser_message_filter.cc',
      'browser/renderer_host/gamepad_browser_message_filter.h',
      'browser/renderer_host/gpu_message_filter.cc',
      'browser/renderer_host/gpu_message_filter.h',
      'browser/renderer_host/input/gesture_event_queue.cc',
      'browser/renderer_host/input/gesture_event_queue.h',
      'browser/renderer_host/input/input_ack_handler.h',
      'browser/renderer_host/input/input_router.h',
      'browser/renderer_host/input/input_router_client.h',
      'browser/renderer_host/input/input_router_config_helper.cc',
      'browser/renderer_host/input/input_router_config_helper.h',
      'browser/renderer_host/input/input_router_impl.cc',
      'browser/renderer_host/input/input_router_impl.h',
      'browser/renderer_host/input/motion_event_web.cc',
      'browser/renderer_host/input/motion_event_web.h',
      'browser/renderer_host/input/mouse_wheel_rails_filter_mac.cc',
      'browser/renderer_host/input/mouse_wheel_rails_filter_mac.h',
      'browser/renderer_host/input/render_widget_host_latency_tracker.cc',
      'browser/renderer_host/input/render_widget_host_latency_tracker.h',
      'browser/renderer_host/input/stylus_text_selector.cc',
      'browser/renderer_host/input/stylus_text_selector.h',
      'browser/renderer_host/input/synthetic_gesture.cc',
      'browser/renderer_host/input/synthetic_gesture.h',
      'browser/renderer_host/input/synthetic_gesture_controller.cc',
      'browser/renderer_host/input/synthetic_gesture_controller.h',
      'browser/renderer_host/input/synthetic_gesture_target.h',
      'browser/renderer_host/input/synthetic_gesture_target_aura.cc',
      'browser/renderer_host/input/synthetic_gesture_target_aura.h',
      'browser/renderer_host/input/synthetic_gesture_target_base.cc',
      'browser/renderer_host/input/synthetic_gesture_target_base.h',
      'browser/renderer_host/input/synthetic_gesture_target_mac.h',
      'browser/renderer_host/input/synthetic_gesture_target_mac.mm',
      'browser/renderer_host/input/synthetic_mouse_pointer.cc',
      'browser/renderer_host/input/synthetic_mouse_pointer.h',
      'browser/renderer_host/input/synthetic_pinch_gesture.cc',
      'browser/renderer_host/input/synthetic_pinch_gesture.h',
      'browser/renderer_host/input/synthetic_pointer.cc',
      'browser/renderer_host/input/synthetic_pointer.h',
      'browser/renderer_host/input/synthetic_pointer_action.cc',
      'browser/renderer_host/input/synthetic_pointer_action.h',
      'browser/renderer_host/input/synthetic_smooth_drag_gesture.cc',
      'browser/renderer_host/input/synthetic_smooth_drag_gesture.h',
      'browser/renderer_host/input/synthetic_smooth_move_gesture.cc',
      'browser/renderer_host/input/synthetic_smooth_move_gesture.h',
      'browser/renderer_host/input/synthetic_smooth_scroll_gesture.cc',
      'browser/renderer_host/input/synthetic_smooth_scroll_gesture.h',
      'browser/renderer_host/input/synthetic_tap_gesture.cc',
      'browser/renderer_host/input/synthetic_tap_gesture.h',
      'browser/renderer_host/input/synthetic_touchpad_pinch_gesture.cc',
      'browser/renderer_host/input/synthetic_touchpad_pinch_gesture.h',
      'browser/renderer_host/input/synthetic_touchscreen_pinch_gesture.cc',
      'browser/renderer_host/input/synthetic_touchscreen_pinch_gesture.h',
      'browser/renderer_host/input/synthetic_touch_pointer.cc',
      'browser/renderer_host/input/synthetic_touch_pointer.h',
      'browser/renderer_host/input/tap_suppression_controller.cc',
      'browser/renderer_host/input/tap_suppression_controller.h',
      'browser/renderer_host/input/tap_suppression_controller_client.h',
      'browser/renderer_host/input/timeout_monitor.cc',
      'browser/renderer_host/input/timeout_monitor.h',
      'browser/renderer_host/input/touch_action_filter.cc',
      'browser/renderer_host/input/touch_action_filter.h',
      'browser/renderer_host/input/touch_emulator.cc',
      'browser/renderer_host/input/touch_emulator.h',
      'browser/renderer_host/input/touch_emulator_client.h',
      'browser/renderer_host/input/touch_event_queue.cc',
      'browser/renderer_host/input/touch_event_queue.h',
      #'browser/renderer_host/input/touch_selection_controller_client_aura.cc',
      #'browser/renderer_host/input/touch_selection_controller_client_aura.h',
      'browser/renderer_host/input/touchpad_tap_suppression_controller.cc',
      'browser/renderer_host/input/touchpad_tap_suppression_controller.h',
      'browser/renderer_host/input/touchscreen_tap_suppression_controller.cc',
      'browser/renderer_host/input/touchscreen_tap_suppression_controller.h',
      'browser/renderer_host/input/ui_touch_selection_helper.cc',
      'browser/renderer_host/input/ui_touch_selection_helper.h',
      'browser/renderer_host/input/web_input_event_builders_android.cc',
      'browser/renderer_host/input/web_input_event_builders_android.h',
      'browser/renderer_host/input/web_input_event_builders_mac.h',
      'browser/renderer_host/input/web_input_event_builders_mac.mm',
      'browser/renderer_host/input/web_input_event_builders_win.cc',
      'browser/renderer_host/input/web_input_event_builders_win.h',
      'browser/renderer_host/input/web_input_event_util.cc',
      'browser/renderer_host/input/web_input_event_util.h',
      'browser/renderer_host/legacy_render_widget_host_win.cc',
      'browser/renderer_host/legacy_render_widget_host_win.h',
      'browser/renderer_host/media/audio_input_debug_writer.cc',
      'browser/renderer_host/media/audio_input_debug_writer.h',
      'browser/renderer_host/media/audio_input_device_manager.cc',
      'browser/renderer_host/media/audio_input_device_manager.h',
      'browser/renderer_host/media/audio_input_renderer_host.cc',
      'browser/renderer_host/media/audio_input_renderer_host.h',
      'browser/renderer_host/media/audio_input_sync_writer.cc',
      'browser/renderer_host/media/audio_input_sync_writer.h',
      'browser/renderer_host/media/audio_output_device_enumerator.cc',
      'browser/renderer_host/media/audio_output_device_enumerator.h',
      'browser/renderer_host/media/audio_renderer_host.cc',
      'browser/renderer_host/media/audio_renderer_host.h',
      'browser/renderer_host/media/audio_sync_reader.cc',
      'browser/renderer_host/media/audio_sync_reader.h',
      'browser/renderer_host/media/media_capture_devices_impl.cc',
      'browser/renderer_host/media/media_capture_devices_impl.h',
      'browser/renderer_host/media/media_stream_dispatcher_host.cc',
      'browser/renderer_host/media/media_stream_dispatcher_host.h',
      'browser/renderer_host/media/media_stream_manager.cc',
      'browser/renderer_host/media/media_stream_manager.h',
      'browser/renderer_host/media/media_stream_provider.h',
      'browser/renderer_host/media/media_stream_requester.h',
      'browser/renderer_host/media/media_stream_track_metrics_host.cc',
      'browser/renderer_host/media/media_stream_track_metrics_host.h',
      'browser/renderer_host/media/media_stream_ui_proxy.cc',
      'browser/renderer_host/media/media_stream_ui_proxy.h',
      'browser/renderer_host/media/video_capture_buffer_pool.cc',
      'browser/renderer_host/media/video_capture_buffer_pool.h',
      'browser/renderer_host/media/video_capture_controller.cc',
      'browser/renderer_host/media/video_capture_controller.h',
      'browser/renderer_host/media/video_capture_controller_event_handler.h',
      'browser/renderer_host/media/video_capture_device_client.cc',
      'browser/renderer_host/media/video_capture_device_client.h',
      'browser/renderer_host/media/video_capture_gpu_jpeg_decoder.cc',
      'browser/renderer_host/media/video_capture_gpu_jpeg_decoder.h',
      'browser/renderer_host/media/video_capture_host.cc',
      'browser/renderer_host/media/video_capture_host.h',
      'browser/renderer_host/media/video_capture_manager.cc',
      'browser/renderer_host/media/video_capture_manager.h',
      'browser/renderer_host/memory_benchmark_message_filter.cc',
      'browser/renderer_host/memory_benchmark_message_filter.h',
      #'browser/renderer_host/native_web_keyboard_event_aura.cc',
      'browser/renderer_host/native_web_keyboard_event_mac.mm',
      'browser/renderer_host/overscroll_configuration.cc',
      'browser/renderer_host/overscroll_controller.cc',
      'browser/renderer_host/overscroll_controller.h',
      'browser/renderer_host/overscroll_controller_delegate.h',
      'browser/renderer_host/render_message_filter.cc',
      'browser/renderer_host/render_message_filter.h',
      'browser/renderer_host/render_process_host_impl.cc',
      'browser/renderer_host/render_process_host_impl.h',
      'browser/renderer_host/render_sandbox_host_linux.cc',
      'browser/renderer_host/render_sandbox_host_linux.h',
      'browser/renderer_host/render_view_host_delegate.cc',
      'browser/renderer_host/render_view_host_delegate.h',
      'browser/renderer_host/render_view_host_delegate_view.h',
      'browser/renderer_host/render_view_host_factory.cc',
      'browser/renderer_host/render_view_host_factory.h',
      'browser/renderer_host/render_view_host_impl.cc',
      'browser/renderer_host/render_view_host_impl.h',
      'browser/renderer_host/render_widget_helper.cc',
      'browser/renderer_host/render_widget_helper.h',
      'browser/renderer_host/render_widget_host_delegate.cc',
      'browser/renderer_host/render_widget_host_delegate.h',
      'browser/renderer_host/render_widget_host_impl.cc',
      'browser/renderer_host/render_widget_host_impl.h',
      'browser/renderer_host/render_widget_host_input_event_router.cc',
      'browser/renderer_host/render_widget_host_input_event_router.h',
      'browser/renderer_host/render_widget_host_owner_delegate.h',
      #'browser/renderer_host/render_widget_host_view_aura.cc',
      #'browser/renderer_host/render_widget_host_view_aura.h',
      'browser/renderer_host/render_widget_host_view_base.cc',
      'browser/renderer_host/render_widget_host_view_base.h',
      'browser/renderer_host/render_widget_host_view_mac.h',
      'browser/renderer_host/render_widget_host_view_mac.mm',
      'browser/renderer_host/render_widget_host_view_mac_dictionary_helper.h',
      'browser/renderer_host/render_widget_host_view_mac_dictionary_helper.mm',
      'browser/renderer_host/render_widget_host_view_mac_editcommand_helper.h',
      'browser/renderer_host/render_widget_host_view_mac_editcommand_helper.mm',
      'browser/renderer_host/render_widget_resize_helper_mac.cc',
      'browser/renderer_host/render_widget_resize_helper_mac.h',
      'browser/renderer_host/renderer_frame_manager.cc',
      'browser/renderer_host/renderer_frame_manager.h',
      'browser/renderer_host/sandbox_ipc_linux.cc',
      'browser/renderer_host/sandbox_ipc_linux.h',
      'browser/renderer_host/text_input_client_mac.h',
      'browser/renderer_host/text_input_client_mac.mm',
      'browser/renderer_host/text_input_client_message_filter.h',
      'browser/renderer_host/text_input_client_message_filter.mm',
      'browser/renderer_host/ui_events_helper.cc',
      'browser/renderer_host/ui_events_helper.h',
      'browser/renderer_host/web_input_event_aura.cc',
      'browser/renderer_host/web_input_event_aura.h',
      'browser/renderer_host/web_input_event_aurawin.cc',
      'browser/renderer_host/webmenurunner_mac.h',
      'browser/renderer_host/webmenurunner_mac.mm',
      'browser/renderer_host/websocket_dispatcher_host.cc',
      'browser/renderer_host/websocket_dispatcher_host.h',
      'browser/renderer_host/websocket_host.cc',
      'browser/renderer_host/websocket_host.h',
      'browser/resolve_proxy_msg_helper.cc',
      'browser/resolve_proxy_msg_helper.h',
      'browser/resource_context_impl.cc',
      'browser/resource_context_impl.h',
      'browser/safe_util_win.cc',
      'browser/safe_util_win.h',
      'browser/screen_orientation/screen_orientation_dispatcher_host_impl.cc',
      'browser/screen_orientation/screen_orientation_dispatcher_host_impl.h',
      'browser/service_worker/embedded_worker_instance.cc',
      'browser/service_worker/embedded_worker_instance.h',
      'browser/service_worker/embedded_worker_registry.cc',
      'browser/service_worker/embedded_worker_registry.h',
      'browser/service_worker/foreign_fetch_request_handler.cc',
      'browser/service_worker/foreign_fetch_request_handler.h',
      'browser/service_worker/service_worker_cache_writer.cc',
      'browser/service_worker/service_worker_cache_writer.h',
      'browser/service_worker/service_worker_client_utils.cc',
      'browser/service_worker/service_worker_client_utils.h',
      'browser/service_worker/service_worker_context_core.cc',
      'browser/service_worker/service_worker_context_core.h',
      'browser/service_worker/service_worker_context_observer.h',
      'browser/service_worker/service_worker_context_request_handler.cc',
      'browser/service_worker/service_worker_context_request_handler.h',
      'browser/service_worker/service_worker_context_watcher.cc',
      'browser/service_worker/service_worker_context_watcher.h',
      'browser/service_worker/service_worker_context_wrapper.cc',
      'browser/service_worker/service_worker_context_wrapper.h',
      'browser/service_worker/service_worker_controllee_request_handler.cc',
      'browser/service_worker/service_worker_controllee_request_handler.h',
      'browser/service_worker/service_worker_database.cc',
      'browser/service_worker/service_worker_database.h',
      'browser/service_worker/service_worker_database_task_manager.cc',
      'browser/service_worker/service_worker_database_task_manager.h',
      'browser/service_worker/service_worker_disk_cache.cc',
      'browser/service_worker/service_worker_disk_cache.h',
      'browser/service_worker/service_worker_dispatcher_host.cc',
      'browser/service_worker/service_worker_dispatcher_host.h',
      'browser/service_worker/service_worker_fetch_dispatcher.cc',
      'browser/service_worker/service_worker_fetch_dispatcher.h',
      'browser/service_worker/service_worker_handle.cc',
      'browser/service_worker/service_worker_handle.h',
      'browser/service_worker/service_worker_info.cc',
      'browser/service_worker/service_worker_info.h',
      'browser/service_worker/service_worker_internals_ui.cc',
      'browser/service_worker/service_worker_internals_ui.h',
      'browser/service_worker/service_worker_job_coordinator.cc',
      'browser/service_worker/service_worker_job_coordinator.h',
      'browser/service_worker/service_worker_metrics.cc',
      'browser/service_worker/service_worker_metrics.h',
      'browser/service_worker/service_worker_navigation_handle.cc',
      'browser/service_worker/service_worker_navigation_handle.h',
      'browser/service_worker/service_worker_navigation_handle_core.cc',
      'browser/service_worker/service_worker_navigation_handle_core.h',
      'browser/service_worker/service_worker_process_manager.cc',
      'browser/service_worker/service_worker_process_manager.h',
      'browser/service_worker/service_worker_provider_host.cc',
      'browser/service_worker/service_worker_provider_host.h',
      'browser/service_worker/service_worker_quota_client.cc',
      'browser/service_worker/service_worker_quota_client.h',
      'browser/service_worker/service_worker_read_from_cache_job.cc',
      'browser/service_worker/service_worker_read_from_cache_job.h',
      'browser/service_worker/service_worker_register_job.cc',
      'browser/service_worker/service_worker_register_job.h',
      'browser/service_worker/service_worker_register_job_base.h',
      'browser/service_worker/service_worker_registration.cc',
      'browser/service_worker/service_worker_registration.h',
      'browser/service_worker/service_worker_registration_handle.cc',
      'browser/service_worker/service_worker_registration_handle.h',
      'browser/service_worker/service_worker_registration_status.cc',
      'browser/service_worker/service_worker_registration_status.h',
      'browser/service_worker/service_worker_request_handler.cc',
      'browser/service_worker/service_worker_request_handler.h',
      'browser/service_worker/service_worker_script_cache_map.cc',
      'browser/service_worker/service_worker_script_cache_map.h',
      'browser/service_worker/service_worker_storage.cc',
      'browser/service_worker/service_worker_storage.h',
      'browser/service_worker/service_worker_unregister_job.cc',
      'browser/service_worker/service_worker_unregister_job.h',
      'browser/service_worker/service_worker_url_request_job.cc',
      'browser/service_worker/service_worker_url_request_job.h',
      'browser/service_worker/service_worker_version.cc',
      'browser/service_worker/service_worker_version.h',
      'browser/service_worker/service_worker_write_to_cache_job.cc',
      'browser/service_worker/service_worker_write_to_cache_job.h',
      'browser/shared_worker/shared_worker_host.cc',
      'browser/shared_worker/shared_worker_host.h',
      'browser/shared_worker/shared_worker_instance.cc',
      'browser/shared_worker/shared_worker_instance.h',
      'browser/shared_worker/shared_worker_message_filter.cc',
      'browser/shared_worker/shared_worker_message_filter.h',
      'browser/shared_worker/shared_worker_service_impl.cc',
      'browser/shared_worker/shared_worker_service_impl.h',
      'browser/shared_worker/worker_document_set.cc',
      'browser/shared_worker/worker_document_set.h',
      'browser/shared_worker/worker_storage_partition.cc',
      'browser/shared_worker/worker_storage_partition.h',
      'browser/signed_certificate_timestamp_store_impl.cc',
      'browser/signed_certificate_timestamp_store_impl.h',
      'browser/site_instance_impl.cc',
      'browser/site_instance_impl.h',
      'browser/speech/audio_buffer.cc',
      'browser/speech/audio_buffer.h',
      'browser/speech/audio_encoder.cc',
      'browser/speech/audio_encoder.h',
      'browser/speech/chunked_byte_buffer.cc',
      'browser/speech/chunked_byte_buffer.h',
      'browser/speech/endpointer/endpointer.cc',
      'browser/speech/endpointer/endpointer.h',
      'browser/speech/endpointer/energy_endpointer.cc',
      'browser/speech/endpointer/energy_endpointer.h',
      'browser/speech/endpointer/energy_endpointer_params.cc',
      'browser/speech/endpointer/energy_endpointer_params.h',
      'browser/speech/google_one_shot_remote_engine.cc',
      'browser/speech/google_one_shot_remote_engine.h',
      'browser/speech/google_streaming_remote_engine.cc',
      'browser/speech/google_streaming_remote_engine.h',
      'browser/speech/speech_recognition_dispatcher_host.cc',
      'browser/speech/speech_recognition_dispatcher_host.h',
      'browser/speech/speech_recognition_engine.cc',
      'browser/speech/speech_recognition_engine.h',
      'browser/speech/speech_recognition_manager_impl.cc',
      'browser/speech/speech_recognition_manager_impl.h',
      'browser/speech/speech_recognizer.h',
      'browser/speech/speech_recognizer_impl.cc',
      'browser/speech/speech_recognizer_impl.h',
      'browser/speech/speech_recognizer_impl_android.cc',
      'browser/speech/speech_recognizer_impl_android.h',
      'browser/ssl/ssl_cert_error_handler.cc',
      'browser/ssl/ssl_cert_error_handler.h',
      'browser/ssl/ssl_client_auth_handler.cc',
      'browser/ssl/ssl_client_auth_handler.h',
      'browser/ssl/ssl_error_handler.cc',
      'browser/ssl/ssl_error_handler.h',
      'browser/ssl/ssl_manager.cc',
      'browser/ssl/ssl_manager.h',
      'browser/ssl/ssl_policy.cc',
      'browser/ssl/ssl_policy.h',
      'browser/ssl/ssl_policy_backend.cc',
      'browser/ssl/ssl_policy_backend.h',
      'browser/ssl/ssl_request_info.cc',
      'browser/ssl/ssl_request_info.h',
      'browser/startup_task_runner.cc',
      'browser/startup_task_runner.h',
      'browser/storage_partition_impl.cc',
      'browser/storage_partition_impl.h',
      'browser/storage_partition_impl_map.cc',
      'browser/storage_partition_impl_map.h',
      'browser/streams/stream.cc',
      'browser/streams/stream.h',
      'browser/streams/stream_context.cc',
      'browser/streams/stream_context.h',
      'browser/streams/stream_handle_impl.cc',
      'browser/streams/stream_handle_impl.h',
      'browser/streams/stream_read_observer.h',
      'browser/streams/stream_register_observer.h',
      'browser/streams/stream_registry.cc',
      'browser/streams/stream_registry.h',
      'browser/streams/stream_url_request_job.cc',
      'browser/streams/stream_url_request_job.h',
      'browser/streams/stream_write_observer.h',
      'browser/system_message_window_win.cc',
      'browser/system_message_window_win.h',
      'browser/theme_helper_mac.h',
      'browser/theme_helper_mac.mm',
      'browser/time_zone_monitor.cc',
      'browser/time_zone_monitor.h',
      'browser/time_zone_monitor_android.cc',
      'browser/time_zone_monitor_android.h',
      'browser/time_zone_monitor_chromeos.cc',
      'browser/time_zone_monitor_linux.cc',
      'browser/time_zone_monitor_mac.mm',
      'browser/time_zone_monitor_win.cc',
      'browser/tracing/background_tracing_config_impl.cc',
      'browser/tracing/background_tracing_config_impl.h',
      'browser/tracing/background_tracing_manager_impl.cc',
      'browser/tracing/background_tracing_manager_impl.h',
      'browser/tracing/background_tracing_rule.cc',
      'browser/tracing/background_tracing_rule.h',
      'browser/tracing/battor_power_trace_provider.cc',
      'browser/tracing/battor_power_trace_provider.h',
      'browser/tracing/etw_system_event_consumer_win.cc',
      'browser/tracing/etw_system_event_consumer_win.h',
      'browser/tracing/file_tracing_provider_impl.cc',
      'browser/tracing/file_tracing_provider_impl.h',
      'browser/tracing/power_tracing_agent.cc',
      'browser/tracing/power_tracing_agent.h',
      'browser/tracing/trace_message_filter.cc',
      'browser/tracing/trace_message_filter.h',
      'browser/tracing/tracing_controller_impl.cc',
      'browser/tracing/tracing_controller_impl.h',
      'browser/tracing/tracing_controller_impl_data_sinks.cc',
      'browser/tracing/tracing_ui.cc',
      'browser/tracing/tracing_ui.h',
      'browser/udev_linux.cc',
      'browser/udev_linux.h',
      'browser/user_metrics.cc',
      'browser/utility_process_host_impl.cc',
      'browser/utility_process_host_impl.h',
      'browser/wake_lock/wake_lock_service_context.cc',
      'browser/wake_lock/wake_lock_service_context.h',
      'browser/wake_lock/wake_lock_service_impl.cc',
      'browser/wake_lock/wake_lock_service_impl.h',
      'browser/web_contents/aura/gesture_nav_simple.cc',
      'browser/web_contents/aura/gesture_nav_simple.h',
      'browser/web_contents/aura/overscroll_navigation_overlay.cc',
      'browser/web_contents/aura/overscroll_navigation_overlay.h',
      'browser/web_contents/aura/overscroll_window_animation.cc',
      'browser/web_contents/aura/overscroll_window_animation.h',
      'browser/web_contents/aura/overscroll_window_delegate.cc',
      'browser/web_contents/aura/overscroll_window_delegate.h',
      'browser/web_contents/aura/shadow_layer_delegate.cc',
      'browser/web_contents/aura/shadow_layer_delegate.h',
      'browser/web_contents/web_contents_impl.cc',
      'browser/web_contents/web_contents_impl.h',
      'browser/web_contents/web_contents_view.h',
      #'browser/web_contents/web_contents_view_aura.cc',
      #'browser/web_contents/web_contents_view_aura.h',
      'browser/web_contents/web_contents_view_guest.cc',
      'browser/web_contents/web_contents_view_guest.h',
      'browser/web_contents/web_contents_view_mac.h',
      'browser/web_contents/web_contents_view_mac.mm',
      'browser/web_contents/web_drag_dest_mac.h',
      'browser/web_contents/web_drag_dest_mac.mm',
      'browser/web_contents/web_drag_source_mac.h',
      'browser/web_contents/web_drag_source_mac.mm',
      'browser/web_contents/web_drag_utils_win.cc',
      'browser/web_contents/web_drag_utils_win.h',
      'browser/webui/content_web_ui_controller_factory.cc',
      'browser/webui/content_web_ui_controller_factory.h',
      'browser/webui/generic_handler.cc',
      'browser/webui/generic_handler.h',
      'browser/webui/shared_resources_data_source.cc',
      'browser/webui/shared_resources_data_source.h',
      'browser/webui/url_data_manager.cc',
      'browser/webui/url_data_manager.h',
      'browser/webui/url_data_manager_backend.cc',
      'browser/webui/url_data_manager_backend.h',
      'browser/webui/url_data_source_impl.cc',
      'browser/webui/url_data_source_impl.h',
      'browser/webui/web_ui_controller_factory_registry.cc',
      'browser/webui/web_ui_controller_factory_registry.h',
      'browser/webui/web_ui_data_source_impl.cc',
      'browser/webui/web_ui_data_source_impl.h',
      'browser/webui/web_ui_impl.cc',
      'browser/webui/web_ui_impl.h',
      'browser/webui/web_ui_message_handler.cc',
      'browser/zygote_host/zygote_host_impl_linux.cc',
      'browser/zygote_host/zygote_host_impl_linux.h',
      'zygote/zygote_linux.cc',
      'zygote/zygote_linux.h',
      'zygote/zygote_main_linux.cc',
      '<(DEPTH)/../../../shared/port/content/browser/power_save_blocker_oxide.cc',
      '<(DEPTH)/../../../shared/port/content/browser/power_save_blocker_oxide.h',
      '<(DEPTH)/../../../shared/port/content/browser/render_widget_host_view_oxide.cc',
      '<(DEPTH)/../../../shared/port/content/browser/render_widget_host_view_oxide.h',
      '<(DEPTH)/../../../shared/port/content/browser/web_contents_view_oxide.cc',
      '<(DEPTH)/../../../shared/port/content/browser/web_contents_view_oxide.h',
    ],
    'android_browser_sources': [
      'browser/android/java/gin_java_bound_object.cc',
      'browser/android/java/gin_java_bound_object.h',
      'browser/android/java/gin_java_bound_object_delegate.cc',
      'browser/android/java/gin_java_bound_object_delegate.h',
      'browser/android/java/gin_java_bridge_dispatcher_host.cc',
      'browser/android/java/gin_java_bridge_dispatcher_host.h',
      'browser/android/java/gin_java_bridge_message_filter.cc',
      'browser/android/java/gin_java_bridge_message_filter.h',
      'browser/android/java/gin_java_method_invocation_helper.cc',
      'browser/android/java/gin_java_method_invocation_helper.h',
      'browser/android/java/gin_java_script_to_java_types_coercion.cc',
      'browser/android/java/gin_java_script_to_java_types_coercion.h',
      'browser/android/java/java_bridge_thread.cc',
      'browser/android/java/java_bridge_thread.h',
      'browser/android/java/java_method.cc',
      'browser/android/java/java_method.h',
      'browser/android/java/java_type.cc',
      'browser/android/java/java_type.h',
      'browser/android/java/jni_helper.cc',
      'browser/android/java/jni_helper.h',
    ],
    'android_in_process_browser_sources': [
      'browser/android/in_process/context_provider_in_process.cc',
      'browser/android/in_process/context_provider_in_process.h',
      'browser/android/in_process/synchronous_compositor_factory_impl.cc',
      'browser/android/in_process/synchronous_compositor_factory_impl.h',
      'browser/android/in_process/synchronous_compositor_impl.cc',
      'browser/android/in_process/synchronous_compositor_impl.h',
      'browser/android/in_process/synchronous_compositor_registry_in_proc.cc',
      'browser/android/in_process/synchronous_compositor_registry_in_proc.h',
      'browser/android/in_process/synchronous_input_event_filter.cc',
      'browser/android/in_process/synchronous_input_event_filter.h',
      'browser/android/synchronous_compositor_base.cc',
      'browser/android/synchronous_compositor_base.h',
      'browser/android/synchronous_compositor_host.cc',
      'browser/android/synchronous_compositor_host.h',
    ],
    'android_non_aura_browser_sources': [
        'browser/accessibility/accessibility_tree_formatter_android.cc',
        'browser/accessibility/browser_accessibility_android.cc',
        'browser/accessibility/browser_accessibility_android.h',
        'browser/accessibility/browser_accessibility_manager_android.cc',
        'browser/accessibility/browser_accessibility_manager_android.h',
        'browser/android/composited_touch_handle_drawable.cc',
        'browser/android/composited_touch_handle_drawable.h',
        'browser/android/content_view_core_impl.cc',
        'browser/android/content_view_core_impl.h',
        'browser/android/content_view_render_view.cc',
        'browser/android/content_view_render_view.h',
        'browser/android/content_view_statics.cc',
        'browser/android/content_view_statics.h',
        'browser/android/date_time_chooser_android.cc',
        'browser/android/date_time_chooser_android.h',
        'browser/android/deferred_download_observer.cc',
        'browser/android/deferred_download_observer.h',
        'browser/android/download_controller_android_impl.cc',
        'browser/android/download_controller_android_impl.h',
        'browser/android/interstitial_page_delegate_android.cc',
        'browser/android/interstitial_page_delegate_android.h',
        'browser/android/load_url_params.cc',
        'browser/android/load_url_params.h',
        'browser/android/overscroll_controller_android.cc',
        'browser/android/overscroll_controller_android.h',
        'browser/android/popup_touch_handle_drawable.cc',
        'browser/android/popup_touch_handle_drawable.h',
        'browser/android/tracing_controller_android.cc',
        'browser/android/tracing_controller_android.h',
        'browser/android/web_contents_observer_proxy.cc',
        'browser/android/web_contents_observer_proxy.h',
        'browser/compositor/browser_compositor_overlay_candidate_validator_android.cc',
        'browser/compositor/browser_compositor_overlay_candidate_validator_android.h',
        'browser/power_save_blocker_android.cc',
        'browser/renderer_host/compositor_impl_android.cc',
        'browser/renderer_host/compositor_impl_android.h',
        'browser/renderer_host/ime_adapter_android.cc',
        'browser/renderer_host/ime_adapter_android.h',
        'browser/renderer_host/input/synthetic_gesture_target_android.cc',
        'browser/renderer_host/input/synthetic_gesture_target_android.h',
        'browser/renderer_host/native_web_keyboard_event_android.cc',
        'browser/renderer_host/render_widget_host_view_android.cc',
        'browser/renderer_host/render_widget_host_view_android.h',
        'browser/screen_orientation/screen_orientation_delegate_android.cc',
        'browser/screen_orientation/screen_orientation_delegate_android.h',
        'browser/screen_orientation/screen_orientation_message_filter_android.cc',
        'browser/screen_orientation/screen_orientation_message_filter_android.h',
        'browser/web_contents/web_contents_android.cc',
        'browser/web_contents/web_contents_android.h',
        'browser/web_contents/web_contents_view_android.cc',
        'browser/web_contents/web_contents_view_android.h',
    ],
    'auralinux_browser_sources': [
      'browser/accessibility/accessibility_tree_formatter_auralinux.cc',
      'browser/accessibility/browser_accessibility_auralinux.cc',
      'browser/accessibility/browser_accessibility_auralinux.h',
      'browser/accessibility/browser_accessibility_manager_auralinux.cc',
      'browser/accessibility/browser_accessibility_manager_auralinux.h',
    ],
    'webrtc_browser_sources': [
      'browser/media/webrtc_internals.cc',
      'browser/media/webrtc_internals.h',
      'browser/media/webrtc_internals_message_handler.cc',
      'browser/media/webrtc_internals_message_handler.h',
      'browser/media/webrtc_internals_ui.cc',
      'browser/media/webrtc_internals_ui.h',
      'browser/media/webrtc_internals_ui_observer.h',
      'browser/renderer_host/media/peer_connection_tracker_host.cc',
      'browser/renderer_host/media/peer_connection_tracker_host.h',
      'browser/renderer_host/media/webrtc_identity_service_host.cc',
      'browser/renderer_host/media/webrtc_identity_service_host.h',
      'browser/renderer_host/p2p/socket_dispatcher_host.cc',
      'browser/renderer_host/p2p/socket_dispatcher_host.h',
      'browser/renderer_host/p2p/socket_host.cc',
      'browser/renderer_host/p2p/socket_host.h',
      'browser/renderer_host/p2p/socket_host_tcp.cc',
      'browser/renderer_host/p2p/socket_host_tcp.h',
      'browser/renderer_host/p2p/socket_host_tcp_server.cc',
      'browser/renderer_host/p2p/socket_host_tcp_server.h',
      'browser/renderer_host/p2p/socket_host_throttler.cc',
      'browser/renderer_host/p2p/socket_host_throttler.h',
      'browser/renderer_host/p2p/socket_host_udp.cc',
      'browser/renderer_host/p2p/socket_host_udp.h',
    ],
    'compositor_browser_sources': [
      'browser/compositor/browser_compositor_output_surface.cc',
      'browser/compositor/browser_compositor_output_surface.h',
      'browser/compositor/browser_compositor_overlay_candidate_validator.h',
      'browser/compositor/browser_compositor_overlay_candidate_validator_android.cc',
      'browser/compositor/browser_compositor_overlay_candidate_validator_android.h',
      'browser/compositor/browser_compositor_overlay_candidate_validator_mac.h',
      'browser/compositor/browser_compositor_overlay_candidate_validator_mac.mm',
      'browser/compositor/browser_compositor_overlay_candidate_validator_ozone.cc',
      'browser/compositor/browser_compositor_overlay_candidate_validator_ozone.h',
      'browser/compositor/browser_compositor_view_mac.h',
      'browser/compositor/browser_compositor_view_mac.mm',
      'browser/compositor/buffer_queue.cc',
      'browser/compositor/buffer_queue.h',
      'browser/compositor/delegated_frame_host.cc',
      'browser/compositor/delegated_frame_host.h',
      'browser/compositor/gpu_browser_compositor_output_surface.cc',
      'browser/compositor/gpu_browser_compositor_output_surface.h',
      'browser/compositor/gpu_process_transport_factory.cc',
      'browser/compositor/gpu_process_transport_factory.h',
      'browser/compositor/gpu_surfaceless_browser_compositor_output_surface.cc',
      'browser/compositor/gpu_surfaceless_browser_compositor_output_surface.h',
      'browser/compositor/image_transport_factory.cc',
      'browser/compositor/image_transport_factory.h',
      'browser/compositor/offscreen_browser_compositor_output_surface.cc',
      'browser/compositor/offscreen_browser_compositor_output_surface.h',
      'browser/compositor/owned_mailbox.cc',
      'browser/compositor/owned_mailbox.h',
      'browser/compositor/reflector_impl.cc',
      'browser/compositor/reflector_impl.h',
      'browser/compositor/reflector_texture.cc',
      'browser/compositor/reflector_texture.h',
      'browser/compositor/resize_lock.cc',
      'browser/compositor/resize_lock.h',
      'browser/compositor/software_browser_compositor_output_surface.cc',
      'browser/compositor/software_browser_compositor_output_surface.h',
      'browser/compositor/software_output_device_mac.h',
      'browser/compositor/software_output_device_mac.mm',
      'browser/compositor/software_output_device_ozone.cc',
      'browser/compositor/software_output_device_ozone.h',
      'browser/compositor/software_output_device_win.cc',
      'browser/compositor/software_output_device_win.h',
      'browser/compositor/software_output_device_x11.cc',
      'browser/compositor/software_output_device_x11.h',
      'browser/context_factory.cc',
    ],
    'plugin_browser_sources': [
      'browser/pepper_flash_settings_helper_impl.cc',
      'browser/pepper_flash_settings_helper_impl.h',
      'browser/plugin_content_origin_whitelist.cc',
      'browser/plugin_content_origin_whitelist.h',
      'browser/plugin_data_remover_impl.cc',
      'browser/plugin_data_remover_impl.h',
      'browser/plugin_loader_posix.cc',
      'browser/plugin_loader_posix.h',
      'browser/plugin_process_host.cc',
      'browser/plugin_process_host.h',
      'browser/plugin_process_host_mac.cc',
      'browser/plugin_service_impl.cc',
      'browser/plugin_service_impl.h',
      'browser/ppapi_plugin_process_host.cc',
      'browser/ppapi_plugin_process_host.h',
      'browser/renderer_host/pepper/browser_ppapi_host_impl.cc',
      'browser/renderer_host/pepper/browser_ppapi_host_impl.h',
      'browser/renderer_host/pepper/content_browser_pepper_host_factory.cc',
      'browser/renderer_host/pepper/content_browser_pepper_host_factory.h',
      'browser/renderer_host/pepper/pepper_browser_font_singleton_host.cc',
      'browser/renderer_host/pepper/pepper_browser_font_singleton_host.h',
      'browser/renderer_host/pepper/pepper_external_file_ref_backend.cc',
      'browser/renderer_host/pepper/pepper_external_file_ref_backend.h',
      'browser/renderer_host/pepper/pepper_file_io_host.cc',
      'browser/renderer_host/pepper/pepper_file_io_host.h',
      'browser/renderer_host/pepper/pepper_file_ref_host.cc',
      'browser/renderer_host/pepper/pepper_file_ref_host.h',
      'browser/renderer_host/pepper/pepper_file_system_browser_host.cc',
      'browser/renderer_host/pepper/pepper_file_system_browser_host.h',
      'browser/renderer_host/pepper/pepper_flash_file_message_filter.cc',
      'browser/renderer_host/pepper/pepper_flash_file_message_filter.h',
      'browser/renderer_host/pepper/pepper_gamepad_host.cc',
      'browser/renderer_host/pepper/pepper_gamepad_host.h',
      'browser/renderer_host/pepper/pepper_host_resolver_message_filter.cc',
      'browser/renderer_host/pepper/pepper_host_resolver_message_filter.h',
      'browser/renderer_host/pepper/pepper_internal_file_ref_backend.cc',
      'browser/renderer_host/pepper/pepper_internal_file_ref_backend.h',
      'browser/renderer_host/pepper/pepper_lookup_request.h',
      'browser/renderer_host/pepper/pepper_message_filter.cc',
      'browser/renderer_host/pepper/pepper_message_filter.h',
      'browser/renderer_host/pepper/pepper_network_monitor_host.cc',
      'browser/renderer_host/pepper/pepper_network_monitor_host.h',
      'browser/renderer_host/pepper/pepper_network_proxy_host.cc',
      'browser/renderer_host/pepper/pepper_network_proxy_host.h',
      'browser/renderer_host/pepper/pepper_print_settings_manager.cc',
      'browser/renderer_host/pepper/pepper_print_settings_manager.h',
      'browser/renderer_host/pepper/pepper_printing_host.cc',
      'browser/renderer_host/pepper/pepper_printing_host.h',
      'browser/renderer_host/pepper/pepper_renderer_connection.cc',
      'browser/renderer_host/pepper/pepper_renderer_connection.h',
      'browser/renderer_host/pepper/pepper_security_helper.cc',
      'browser/renderer_host/pepper/pepper_security_helper.h',
      'browser/renderer_host/pepper/pepper_socket_utils.cc',
      'browser/renderer_host/pepper/pepper_socket_utils.h',
      'browser/renderer_host/pepper/pepper_tcp_server_socket_message_filter.cc',
      'browser/renderer_host/pepper/pepper_tcp_server_socket_message_filter.h',
      'browser/renderer_host/pepper/pepper_tcp_socket_message_filter.cc',
      'browser/renderer_host/pepper/pepper_tcp_socket_message_filter.h',
      'browser/renderer_host/pepper/pepper_truetype_font.h',
      'browser/renderer_host/pepper/pepper_truetype_font_android.cc',
      'browser/renderer_host/pepper/pepper_truetype_font_host.cc',
      'browser/renderer_host/pepper/pepper_truetype_font_host.h',
      'browser/renderer_host/pepper/pepper_truetype_font_linux.cc',
      'browser/renderer_host/pepper/pepper_truetype_font_list.h',
      'browser/renderer_host/pepper/pepper_truetype_font_list_android.cc',
      'browser/renderer_host/pepper/pepper_truetype_font_list_host.cc',
      'browser/renderer_host/pepper/pepper_truetype_font_list_host.h',
      'browser/renderer_host/pepper/pepper_truetype_font_list_mac.mm',
      'browser/renderer_host/pepper/pepper_truetype_font_list_ozone.cc',
      'browser/renderer_host/pepper/pepper_truetype_font_list_pango.cc',
      'browser/renderer_host/pepper/pepper_truetype_font_list_win.cc',
      'browser/renderer_host/pepper/pepper_truetype_font_mac.mm',
      'browser/renderer_host/pepper/pepper_truetype_font_win.cc',
      'browser/renderer_host/pepper/pepper_udp_socket_message_filter.cc',
      'browser/renderer_host/pepper/pepper_udp_socket_message_filter.h',
      'browser/renderer_host/pepper/quota_reservation.cc',
      'browser/renderer_host/pepper/quota_reservation.h',
      'browser/renderer_host/pepper/ssl_context_helper.cc',
      'browser/renderer_host/pepper/ssl_context_helper.h',
      'public/browser/plugin_service.h',
    ],
  },
  'sources': [
    '<@(public_browser_sources)',
    '<@(private_browser_sources)',
  ],
  'conditions': [
    ['oxide_build=="qt"', {
      'sources': [
        '<(DEPTH)/../../../qt/core/port/content/browser/native_web_keyboard_event_oxide_qt.cc',
      ],
      'dependencies': [
        '<(DEPTH)/../../../qt/build/system.gyp:Qt5Core',
        '<(DEPTH)/../../../qt/build/system.gyp:Qt5Gui',
      ],
      'export_dependent_settings': [
        '<(DEPTH)/../../../qt/build/system.gyp:Qt5Core',
      ],
    }],
    ['OS != "win"', {
      'sources': [
        'browser/file_descriptor_info_impl.cc',
        'browser/file_descriptor_info_impl.h',
      ]
    }],
    ['OS!="win" and OS!="mac" and OS!="android" and (OS!="linux" or use_udev==0)', {
      'sources': [
        'browser/gamepad/gamepad_platform_data_fetcher.cc',
      ]
    }],
    ['OS=="ios"', {
      'sources/': [
        # iOS only needs a small portion of content; exclude all the
        # implementation, and re-include what is used.
        ['exclude', '\\.(cc|mm)$'],
        ['include', '^public/browser/navigation_details\\.cc$'],
        ['include', '^public/browser/page_navigator\\.cc$'],
        ['include', '^browser/browser_context\\.cc$'],
      ],
    }, {  # OS!="ios"
      'dependencies': [
        'app/resources/content_resources.gyp:content_resources',
        'app/strings/content_strings.gyp:content_strings',
        'browser/devtools/devtools_resources.gyp:devtools_resources',
        'browser/devtools/devtools.gyp:devtools_protocol_handler',
        '../cc/cc.gyp:cc',
        '../cc/cc.gyp:cc_surfaces',
        '../components/mime_util/mime_util.gyp:mime_util',
        '../components/scheduler/scheduler.gyp:scheduler_common',
        '../device/bluetooth/bluetooth.gyp:device_bluetooth',
        '../device/usb/usb.gyp:device_usb',
        '../gin/gin.gyp:gin',
        '../net/net.gyp:http_server',
        '../storage/storage_browser.gyp:storage',
        '../storage/storage_common.gyp:storage_common',
        '../third_party/angle/src/angle.gyp:commit_id',
        '../third_party/leveldatabase/leveldatabase.gyp:leveldatabase',
        '../third_party/mojo/mojo_public.gyp:mojo_cpp_bindings',
        '../third_party/mojo/mojo_public.gyp:mojo_js_bindings',
        '../ui/events/blink/events_blink.gyp:events_blink',
        '../ui/surface/surface.gyp:surface',
        '../ui/touch_selection/ui_touch_selection.gyp:ui_touch_selection',
      ],
      'export_dependent_settings': [
        '../third_party/mojo/mojo_public.gyp:mojo_cpp_bindings',
      ],
    }],
    ['debug_devtools==1', {
      'defines': [
        'DEBUG_DEVTOOLS=1',
      ],
    }],
    ['enable_basic_printing==1 or enable_print_preview==1', {
      'dependencies': [
        '../printing/printing.gyp:printing',
      ],
    }],
    ['OS!="ios" and chrome_multiple_dll!=1', {
      'dependencies': [
        '../third_party/WebKit/public/blink.gyp:blink',
      ],
    }],
    ['OS!="ios"', {
      'dependencies': [
        '../sandbox/sandbox.gyp:sandbox',
      ],
    }],
    ['OS!="android" and OS!="ios"', {
      'dependencies': [
        'browser/tracing/tracing_resources.gyp:tracing_resources',
        '../ui/compositor/compositor.gyp:compositor',
      ],
      'sources': [ '<@(compositor_browser_sources)' ],
    }, {
      'sources/': [
        ['exclude', '^public/browser/context_factory.h'],
      ]
    }],
    ['OS!="ios"', {
      'sources': [
        'browser/compositor/surface_utils.cc',
        'browser/compositor/surface_utils.h',
      ]
    }],
    ['OS!="ios"', {
      'dependencies': [
        '../third_party/libyuv/libyuv.gyp:libyuv',
      ],
    }],
    ['enable_webrtc==1', {
      'dependencies': [
        '../jingle/jingle.gyp:jingle_glue',
      ],
      'sources': [
        '<@(webrtc_browser_sources)',
      ],
    }],
    ['enable_webrtc==1 and OS=="linux"', {
      'dependencies': [
        '../third_party/libjingle/libjingle.gyp:libjingle_webrtc',
      ],
    }],
    ['enable_webrtc==1 and (OS=="linux" or OS=="mac" or OS=="win")', {
      'sources': [
        'browser/media/capture/desktop_capture_device.cc',
        'browser/media/capture/desktop_capture_device.h',
        'browser/media/capture/desktop_capture_device_uma_types.cc',
        'browser/media/capture/desktop_capture_device_uma_types.h',
      ],
      'dependencies': [
        '../third_party/webrtc/modules/modules.gyp:desktop_capture',
      ],
      'defines': [
        'ENABLE_SCREEN_CAPTURE=1',
      ],
    }],
    ['enable_webrtc==1 and use_aura==1', {
      'sources': [
        "browser/media/capture/aura_window_capture_machine.cc",
        "browser/media/capture/aura_window_capture_machine.h",
        'browser/media/capture/desktop_capture_device_aura.cc',
        'browser/media/capture/desktop_capture_device_aura.h',
      ],
    }],
    ['OS=="win"', {
      'dependencies': [
        # For accessibility
        '../third_party/iaccessible2/iaccessible2.gyp:iaccessible2',
        '../third_party/isimpledom/isimpledom.gyp:isimpledom',
      ],
      'sources/': [
        ['exclude', '^browser/device_sensors/data_fetcher_shared_memory_default.cc$'],
      ],
      'defines': [
        # This prevents the inclusion of atlhost.h which paired
        # with the windows 8 sdk it does the wrong thing.
        '__ATLHOST_H__',
      ],
      'link_settings': {
        'libraries': [
          '-lcomctl32.lib',
          '-ldinput8.lib',
          '-ldwmapi.lib',
          '-ldxguid.lib',
          '-lsensorsapi.lib',
          '-lportabledeviceguids.lib',
        ],
        'msvs_settings': {
          'VCLinkerTool': {
            'DelayLoadDLLs': [
              'dinput8.dll',
              'user32.dll',
              'dwmapi.dll',
            ],
          },
        },
      },
    }],
    ['OS=="linux" and chromeos==0 and use_x11==1', {
      'dependencies': [
        '../build/linux/system.gyp:atk',
        '../build/linux/system.gyp:gconf',
        '../build/linux/system.gyp:glib',
      ],
      'variables': {
        'clang_warning_flags': [
          # glib uses the pre-c++11 typedef-as-static_assert hack.
          '-Wno-unused-local-typedefs',
        ],
      },
      'sources': [
        '<@(auralinux_browser_sources)',
      ],
    }],
    ['use_udev == 1', {
      'dependencies': [
        '../device/udev_linux/udev.gyp:udev_linux',
      ],
    }, {
      'sources!': [
        'browser/device_monitor_udev.cc',
        'browser/device_monitor_udev.h',
        'browser/gamepad/gamepad_platform_data_fetcher_linux.cc',
        'browser/udev_linux.cc',
        'browser/udev_linux.h',
      ],
    }],
    ['OS=="linux" and use_aura==1', {
      'dependencies': [
        '../build/linux/system.gyp:fontconfig',
      ],
    }],
    ['use_x11==1', {
      'dependencies': [
        '../build/linux/system.gyp:x11',
        '../ui/events/platform/x11/x11_events_platform.gyp:x11_events_platform',
        '../ui/gfx/x/gfx_x11.gyp:gfx_x11',
      ],
    }],
    ['use_pango==1', {
      'dependencies': [
        '../build/linux/system.gyp:pangocairo',
      ],
      'sources!': [
        'browser/renderer_host/pepper/pepper_truetype_font_list_ozone.cc',
      ],
    }],
    ['OS=="android"', {
      'dependencies': [
        '../media/media.gyp:media',
        '../media/mojo/interfaces/mojo_bindings.gyp:provision_fetcher_api',
        '../mojo/mojo_base.gyp:libmojo_system_java',
        '../ui/android/ui_android.gyp:ui_android',
        'content.gyp:content_jni_headers',
      ],
      'dependencies!': [
        '../device/battery/battery.gyp:device_battery',
      ],
      'defines': ['APPCACHE_USE_SIMPLE_CACHE'],
      'direct_dependent_settings': {
        'defines': ['APPCACHE_USE_SIMPLE_CACHE'],
      },
      'link_settings': {
        'libraries': [
          '-ljnigraphics',
        ],
      },
      'sources/': [
        ['exclude', '^browser/device_sensors/data_fetcher_shared_memory_default\\.cc$'],
        ['exclude', '^browser/geolocation/network_location_provider\\.(cc|h)$'],
        ['exclude', '^browser/geolocation/network_location_request\\.(cc|h)$'],
        ['exclude', '^browser/tracing/trace_uploader\\.(cc|h)$'],
        ['exclude', '^browser/tracing/tracing_ui\\.(cc|h)$'],
      ],
      'sources': [ '<@(android_browser_sources)', ],
      'sources!': [
        'browser/browser_ipc_logging.cc',
        'browser/geolocation/device_data_provider.cc',
        'browser/geolocation/empty_device_data_provider.cc',
        'browser/geolocation/wifi_data_provider_common.cc',
        'browser/power_usage_monitor_impl.cc',
        'browser/power_usage_monitor_impl.h',
        'browser/renderer_host/native_web_keyboard_event.cc',
      ],
      'conditions': [
        ['use_aura == 0', {
          'sources': [
            '<@(android_in_process_browser_sources)',
            '<@(android_non_aura_browser_sources)',
          ],
          'sources!': [ 'browser/renderer_host/begin_frame_observer_proxy.cc', ],
        }],
      ],
    }],
    ['OS=="mac"', {
      'sources/': [
        ['exclude', '^browser/device_sensors/data_fetcher_shared_memory_default.cc$'],
      ],
      'sources!': [
        'browser/geolocation/empty_wifi_data_provider.cc',
      ],
      'dependencies': [
        '../third_party/mozilla/mozilla.gyp:mozilla',
        '../third_party/sudden_motion_sensor/sudden_motion_sensor.gyp:sudden_motion_sensor',
        '../ui/accelerated_widget_mac/accelerated_widget_mac.gyp:accelerated_widget_mac',
      ],
      'link_settings': {
        'libraries': [
          '$(SDKROOT)/usr/lib/libbsm.dylib',
        ],
      },
    }],
    ['chromeos==1', {
      'dependencies': [
        '../build/linux/system.gyp:dbus',
        '../chromeos/chromeos.gyp:chromeos',
        '../chromeos/chromeos.gyp:power_manager_proto',
        '../components/components.gyp:arc',
      ],
      'sources': [
        'browser/gpu/gpu_arc_video_service_host.cc',
        'browser/gpu/gpu_arc_video_service_host.h',
      ],
      'sources!': [
        'browser/device_sensors/data_fetcher_shared_memory_default.cc',
        'browser/geolocation/wifi_data_provider_linux.cc',
        'browser/power_save_blocker_ozone.cc',
        'browser/power_save_blocker_x11.cc',
      ],
    }],
    ['os_bsd==1', {
      'sources/': [
        ['exclude', '^browser/gamepad/gamepad_platform_data_fetcher_linux\\.cc$'],
      ],
    }],
    ['use_aura==1', {
      'dependencies': [
        '../ui/aura/aura.gyp:aura',
        '../ui/aura_extra/aura_extra.gyp:aura_extra',
        '../ui/strings/ui_strings.gyp:ui_strings',
      ],
    }, {
      'sources/': [
        ['exclude', '^browser/media/capture/cursor_renderer_aura.cc'],
        ['exclude', '^browser/media/capture/cursor_renderer_aura.h'],
        ['exclude', '^browser/renderer_host/input/touch_selection_controller_client_aura.cc'],
        ['exclude', '^browser/renderer_host/input/touch_selection_controller_client_aura.h'],
        ['exclude', '^browser/renderer_host/render_widget_host_view_aura.cc'],
        ['exclude', '^browser/renderer_host/render_widget_host_view_aura.h'],
        ['exclude', '^browser/renderer_host/ui_events_helper.cc'],
        ['exclude', '^browser/renderer_host/ui_events_helper.h'],
      ],
    }],
    ['enable_plugins==1', {
      'dependencies': [
        '../ppapi/ppapi_internal.gyp:ppapi_ipc',
        '../ppapi/ppapi_internal.gyp:ppapi_shared',
      ],
      'sources': [
        '<@(plugin_browser_sources)',
      ],
    }],
    ['enable_web_speech==1', {
      'dependencies': [
        '../third_party/flac/flac.gyp:libflac',
      ],
    }],
    ['enable_web_speech==0 and OS=="android"', {
      'sources/': [
        ['exclude', '^browser/speech/'],
        ['include', '^browser/speech/speech_recognition_dispatcher_host\\.(cc|h)$'],
        ['include', '^browser/speech/speech_recognition_manager_impl\\.(cc|h)$'],
        ['include', '^browser/speech/speech_recognizer\\.h$'],
        ['include', '^browser/speech/speech_recognizer_impl_android\\.(cc|h)$'],
      ],
    }],
    ['OS == "win"', {
      'sources!': [
        'browser/geolocation/empty_wifi_data_provider.cc',
      ],
    }],
    ['OS == "linux" and use_dbus==1', {
      'sources!': [
        'browser/geolocation/empty_wifi_data_provider.cc',
      ],
      'dependencies': [
        '../build/linux/system.gyp:dbus',
        '../dbus/dbus.gyp:dbus',
      ],
    }, {  # OS != "linux" or use_dbus==0
      'sources!': [
        'browser/geolocation/wifi_data_provider_linux.cc',
      ],
    }],
    ['enable_browser_cdms==1', {
      'sources': [
        'browser/media/cdm/browser_cdm_manager.cc',
        'browser/media/cdm/browser_cdm_manager.h',
      ],
    }],
    ['OS == "linux"', {
      'dependencies': [
        '../third_party/boringssl/boringssl.gyp:boringssl',
      ],
    }],
    ['enable_webvr==1', {
      'sources': [
        'browser/vr/vr_device.cc',
        'browser/vr/vr_device.h',
        'browser/vr/vr_device_manager.cc',
        'browser/vr/vr_device_manager.h',
        'browser/vr/vr_device_provider.h',
      ]
    }],
    ['enable_webvr==1 and OS=="android"', {
      'sources': [
        'browser/vr/android/cardboard/cardboard_vr_device.cc',
        'browser/vr/android/cardboard/cardboard_vr_device.h',
        'browser/vr/android/cardboard/cardboard_vr_device_provider.cc',
        'browser/vr/android/cardboard/cardboard_vr_device_provider.h',
      ],
    }],
  ],
}
