/* SPDX-License-Identifier: BSD-2-Clause */
/*
 * Copyright (c) 2005, 2006
 * Matthew D. Fuller <fullermd@over-yonder.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR(S) ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * Some lookup tables of powers of 2, used for describing the number of
 * hosts or networks in a given group.
 * XXX This isn't really well suited for localization...
 */

#ifndef __LIBCIDR__POW2_P_H
#define __LIBCIDR__POW2_P_H

/* Powers of two */
static const char *__cidr_pow2[] = {
	"1",
	"2",
	"4",
	"8",
	"16",
	"32",
	"64",
	"128",
	"256",
	"512",
	"1,024",
	"2,048",
	"4,096",
	"8,192",
	"16,384",
	"32,768",
	"65,536",
	"131,072",
	"262,144",
	"524,288",
	"1,048,576",
	"2,097,152",
	"4,194,304",
	"8,388,608",
	"16,777,216",
	"33,554,432",
	"67,108,864",
	"134,217,728",
	"268,435,456",
	"536,870,912",
	"1,073,741,824",
	"2,147,483,648",
	"4,294,967,296",
	"8,589,934,592",
	"17,179,869,184",
	"34,359,738,368",
	"68,719,476,736",
	"137,438,953,472",
	"274,877,906,944",
	"549,755,813,888",
	"1,099,511,627,776",
	"2,199,023,255,552",
	"4,398,046,511,104",
	"8,796,093,022,208",
	"17,592,186,044,416",
	"35,184,372,088,832",
	"70,368,744,177,664",
	"140,737,488,355,328",
	"281,474,976,710,656",
	"562,949,953,421,312",
	"1,125,899,906,842,624",
	"2,251,799,813,685,248",
	"4,503,599,627,370,496",
	"9,007,199,254,740,992",
	"18,014,398,509,481,984",
	"36,028,797,018,963,968",
	"72,057,594,037,927,936",
	"144,115,188,075,855,872",
	"288,230,376,151,711,744",
	"576,460,752,303,423,488",
	"1,152,921,504,606,846,976",
	"2,305,843,009,213,693,952",
	"4,611,686,018,427,387,904",
	"9,223,372,036,854,775,808",
	"18,446,744,073,709,551,616",
	"36,893,488,147,419,103,232",
	"73,786,976,294,838,206,464",
	"147,573,952,589,676,412,928",
	"295,147,905,179,352,825,856",
	"590,295,810,358,705,651,712",
	"1,180,591,620,717,411,303,424",
	"2,361,183,241,434,822,606,848",
	"4,722,366,482,869,645,213,696",
	"9,444,732,965,739,290,427,392",
	"18,889,465,931,478,580,854,784",
	"37,778,931,862,957,161,709,568",
	"75,557,863,725,914,323,419,136",
	"151,115,727,451,828,646,838,272",
	"302,231,454,903,657,293,676,544",
	"604,462,909,807,314,587,353,088",
	"1,208,925,819,614,629,174,706,176",
	"2,417,851,639,229,258,349,412,352",
	"4,835,703,278,458,516,698,824,704",
	"9,671,406,556,917,033,397,649,408",
	"19,342,813,113,834,066,795,298,816",
	"38,685,626,227,668,133,590,597,632",
	"77,371,252,455,336,267,181,195,264",
	"154,742,504,910,672,534,362,390,528",
	"309,485,009,821,345,068,724,781,056",
	"618,970,019,642,690,137,449,562,112",
	"1,237,940,039,285,380,274,899,124,224",
	"2,475,880,078,570,760,549,798,248,448",
	"4,951,760,157,141,521,099,596,496,896",
	"9,903,520,314,283,042,199,192,993,792",
	"19,807,040,628,566,084,398,385,987,584",
	"39,614,081,257,132,168,796,771,975,168",
	"79,228,162,514,264,337,593,543,950,336",
	"158,456,325,028,528,675,187,087,900,672",
	"316,912,650,057,057,350,374,175,801,344",
	"633,825,300,114,114,700,748,351,602,688",
	"1,267,650,600,228,229,401,496,703,205,376",
	"2,535,301,200,456,458,802,993,406,410,752",
	"5,070,602,400,912,917,605,986,812,821,504",
	"10,141,204,801,825,835,211,973,625,643,008",
	"20,282,409,603,651,670,423,947,251,286,016",
	"40,564,819,207,303,340,847,894,502,572,032",
	"81,129,638,414,606,681,695,789,005,144,064",
	"162,259,276,829,213,363,391,578,010,288,128",
	"324,518,553,658,426,726,783,156,020,576,256",
	"649,037,107,316,853,453,566,312,041,152,512",
	"1,298,074,214,633,706,907,132,624,082,305,024",
	"2,596,148,429,267,413,814,265,248,164,610,048",
	"5,192,296,858,534,827,628,530,496,329,220,096",
	"10,384,593,717,069,655,257,060,992,658,440,192",
	"20,769,187,434,139,310,514,121,985,316,880,384",
	"41,538,374,868,278,621,028,243,970,633,760,768",
	"83,076,749,736,557,242,056,487,941,267,521,536",
	"166,153,499,473,114,484,112,975,882,535,043,072",
	"332,306,998,946,228,968,225,951,765,070,086,144",
	"664,613,997,892,457,936,451,903,530,140,172,288",
	"1,329,227,995,784,915,872,903,807,060,280,344,576",
	"2,658,455,991,569,831,745,807,614,120,560,689,152",
	"5,316,911,983,139,663,491,615,228,241,121,378,304",
	"10,633,823,966,279,326,983,230,456,482,242,756,608",
	"21,267,647,932,558,653,966,460,912,964,485,513,216",
	"42,535,295,865,117,307,932,921,825,928,971,026,432",
	"85,070,591,730,234,615,865,843,651,857,942,052,864",
	"170,141,183,460,469,231,731,687,303,715,884,105,728",
	"340,282,366,920,938,463,463,374,607,431,768,211,456"
};

/* Powers of 2 minus two; hosts in a subnet with this many host bit */
static const char *__cidr_pow2m2[] = {
	"1", /* Special */
	"2", /* Special */
	"2",
	"6",
	"14",
	"30",
	"62",
	"126",
	"254",
	"510",
	"1,022",
	"2,046",
	"4,094",
	"8,190",
	"16,382",
	"32,766",
	"65,534",
	"131,070",
	"262,142",
	"524,286",
	"1,048,574",
	"2,097,150",
	"4,194,302",
	"8,388,606",
	"16,777,214",
	"33,554,430",
	"67,108,862",
	"134,217,726",
	"268,435,454",
	"536,870,910",
	"1,073,741,822",
	"2,147,483,646",
	"4,294,967,294",
	"8,589,934,590",
	"17,179,869,182",
	"34,359,738,366",
	"68,719,476,734",
	"137,438,953,470",
	"274,877,906,942",
	"549,755,813,886",
	"1,099,511,627,774",
	"2,199,023,255,550",
	"4,398,046,511,102",
	"8,796,093,022,206",
	"17,592,186,044,414",
	"35,184,372,088,830",
	"70,368,744,177,662",
	"140,737,488,355,326",
	"281,474,976,710,654",
	"562,949,953,421,310",
	"1,125,899,906,842,622",
	"2,251,799,813,685,246",
	"4,503,599,627,370,494",
	"9,007,199,254,740,990",
	"18,014,398,509,481,982",
	"36,028,797,018,963,966",
	"72,057,594,037,927,934",
	"144,115,188,075,855,870",
	"288,230,376,151,711,742",
	"576,460,752,303,423,486",
	"1,152,921,504,606,846,974",
	"2,305,843,009,213,693,950",
	"4,611,686,018,427,387,902",
	"9,223,372,036,854,775,806",
	"18,446,744,073,709,551,614",
	"36,893,488,147,419,103,230",
	"73,786,976,294,838,206,462",
	"147,573,952,589,676,412,926",
	"295,147,905,179,352,825,854",
	"590,295,810,358,705,651,710",
	"1,180,591,620,717,411,303,422",
	"2,361,183,241,434,822,606,846",
	"4,722,366,482,869,645,213,694",
	"9,444,732,965,739,290,427,390",
	"18,889,465,931,478,580,854,782",
	"37,778,931,862,957,161,709,566",
	"75,557,863,725,914,323,419,134",
	"151,115,727,451,828,646,838,270",
	"302,231,454,903,657,293,676,542",
	"604,462,909,807,314,587,353,086",
	"1,208,925,819,614,629,174,706,174",
	"2,417,851,639,229,258,349,412,350",
	"4,835,703,278,458,516,698,824,702",
	"9,671,406,556,917,033,397,649,406",
	"19,342,813,113,834,066,795,298,814",
	"38,685,626,227,668,133,590,597,630",
	"77,371,252,455,336,267,181,195,262",
	"154,742,504,910,672,534,362,390,526",
	"309,485,009,821,345,068,724,781,054",
	"618,970,019,642,690,137,449,562,110",
	"1,237,940,039,285,380,274,899,124,222",
	"2,475,880,078,570,760,549,798,248,446",
	"4,951,760,157,141,521,099,596,496,894",
	"9,903,520,314,283,042,199,192,993,790",
	"19,807,040,628,566,084,398,385,987,582",
	"39,614,081,257,132,168,796,771,975,166",
	"79,228,162,514,264,337,593,543,950,334",
	"158,456,325,028,528,675,187,087,900,670",
	"316,912,650,057,057,350,374,175,801,342",
	"633,825,300,114,114,700,748,351,602,686",
	"1,267,650,600,228,229,401,496,703,205,374",
	"2,535,301,200,456,458,802,993,406,410,750",
	"5,070,602,400,912,917,605,986,812,821,502",
	"10,141,204,801,825,835,211,973,625,643,006",
	"20,282,409,603,651,670,423,947,251,286,014",
	"40,564,819,207,303,340,847,894,502,572,030",
	"81,129,638,414,606,681,695,789,005,144,062",
	"162,259,276,829,213,363,391,578,010,288,126",
	"324,518,553,658,426,726,783,156,020,576,254",
	"649,037,107,316,853,453,566,312,041,152,510",
	"1,298,074,214,633,706,907,132,624,082,305,022",
	"2,596,148,429,267,413,814,265,248,164,610,046",
	"5,192,296,858,534,827,628,530,496,329,220,094",
	"10,384,593,717,069,655,257,060,992,658,440,190",
	"20,769,187,434,139,310,514,121,985,316,880,382",
	"41,538,374,868,278,621,028,243,970,633,760,766",
	"83,076,749,736,557,242,056,487,941,267,521,534",
	"166,153,499,473,114,484,112,975,882,535,043,070",
	"332,306,998,946,228,968,225,951,765,070,086,142",
	"664,613,997,892,457,936,451,903,530,140,172,286",
	"1,329,227,995,784,915,872,903,807,060,280,344,574",
	"2,658,455,991,569,831,745,807,614,120,560,689,150",
	"5,316,911,983,139,663,491,615,228,241,121,378,302",
	"10,633,823,966,279,326,983,230,456,482,242,756,606",
	"21,267,647,932,558,653,966,460,912,964,485,513,214",
	"42,535,295,865,117,307,932,921,825,928,971,026,430",
	"85,070,591,730,234,615,865,843,651,857,942,052,862",
	"170,141,183,460,469,231,731,687,303,715,884,105,726",
	"340,282,366,920,938,463,463,374,607,431,768,211,454"
};

#endif /* __LIBCIDR__POW2_P_H */
