// l3 MPEG decoding tables
// output of:
// src/libmpg123/calctables l3

#if defined(RUNTIME_TABLES)

#ifdef REAL_IS_FLOAT

// aligned to 16 bytes for vector instructions, e.g. AltiVec

static ALIGNED(16) real ispow[8207];
static ALIGNED(16) real aa_ca[8];
static ALIGNED(16) real aa_cs[8];
static ALIGNED(16) real win[4][36];
static ALIGNED(16) real win1[4][36];
ALIGNED(16) real INT123_COS9[9];
static real COS6_1;
static real COS6_2;
ALIGNED(16) real INT123_tfcos36[9];
static ALIGNED(16) real tfcos12[3];
static ALIGNED(16) real cos9[3];
static ALIGNED(16) real cos18[3];
static ALIGNED(16) real tan1_1[16];
static ALIGNED(16) real tan2_1[16];
static ALIGNED(16) real tan1_2[16];
static ALIGNED(16) real tan2_2[16];
static ALIGNED(16) real pow1_1[2][32];
static ALIGNED(16) real pow2_1[2][32];
static ALIGNED(16) real pow1_2[2][32];
static ALIGNED(16) real pow2_2[2][32];

#endif

static short mapbuf0[9][152];
static short mapbuf1[9][156];
static short mapbuf2[9][44];
static short *map[9][3];
static short *mapend[9][3];
static unsigned short n_slen2[512];
static unsigned short i_slen2[256];

#else

#ifdef REAL_IS_FLOAT

// aligned to 16 bytes for vector instructions, e.g. AltiVec

static const ALIGNED(16) real ispow[8207] = 
{
	 0.00000000e+00f,  1.00000000e+00f,  2.51984210e+00f,  4.32674871e+00f
,	 6.34960421e+00f,  8.54987973e+00f,  1.09027236e+01f,  1.33905183e+01f
,	 1.60000000e+01f,  1.87207544e+01f,  2.15443469e+01f,  2.44637810e+01f
,	 2.74731418e+01f,  3.05673509e+01f,  3.37419917e+01f,  3.69931811e+01f
,	 4.03174736e+01f,  4.37117870e+01f,  4.71733451e+01f,  5.06996313e+01f
,	 5.42883523e+01f,  5.79374077e+01f,  6.16448653e+01f,  6.54089405e+01f
,	 6.92279794e+01f,  7.31004435e+01f,  7.70248978e+01f,  8.10000000e+01f
,	 8.50244912e+01f,  8.90971879e+01f,  9.32169752e+01f,  9.73828002e+01f
,	 1.01593667e+02f,  1.05848633e+02f,  1.10146801e+02f,  1.14487321e+02f
,	 1.18869381e+02f,  1.23292209e+02f,  1.27755065e+02f,  1.32257246e+02f
,	 1.36798076e+02f,  1.41376907e+02f,  1.45993119e+02f,  1.50646117e+02f
,	 1.55335327e+02f,  1.60060199e+02f,  1.64820202e+02f,  1.69614826e+02f
,	 1.74443577e+02f,  1.79305980e+02f,  1.84201575e+02f,  1.89129918e+02f
,	 1.94090580e+02f,  1.99083145e+02f,  2.04107210e+02f,  2.09162385e+02f
,	 2.14248292e+02f,  2.19364564e+02f,  2.24510845e+02f,  2.29686789e+02f
,	 2.34892058e+02f,  2.40126328e+02f,  2.45389280e+02f,  2.50680604e+02f
,	 2.56000000e+02f,  2.61347174e+02f,  2.66721841e+02f,  2.72123723e+02f
,	 2.77552547e+02f,  2.83008049e+02f,  2.88489971e+02f,  2.93998060e+02f
,	 2.99532071e+02f,  3.05091761e+02f,  3.10676898e+02f,  3.16287249e+02f
,	 3.21922592e+02f,  3.27582707e+02f,  3.33267377e+02f,  3.38976394e+02f
,	 3.44709550e+02f,  3.50466646e+02f,  3.56247482e+02f,  3.62051866e+02f
,	 3.67879608e+02f,  3.73730522e+02f,  3.79604427e+02f,  3.85501143e+02f
,	 3.91420496e+02f,  3.97362314e+02f,  4.03326427e+02f,  4.09312672e+02f
,	 4.15320884e+02f,  4.21350905e+02f,  4.27402579e+02f,  4.33475750e+02f
,	 4.39570269e+02f,  4.45685987e+02f,  4.51822757e+02f,  4.57980436e+02f
,	 4.64158883e+02f,  4.70357960e+02f,  4.76577530e+02f,  4.82817459e+02f
,	 4.89077615e+02f,  4.95357868e+02f,  5.01658090e+02f,  5.07978156e+02f
,	 5.14317941e+02f,  5.20677324e+02f,  5.27056184e+02f,  5.33454404e+02f
,	 5.39871867e+02f,  5.46308458e+02f,  5.52764065e+02f,  5.59238575e+02f
,	 5.65731879e+02f,  5.72243870e+02f,  5.78774440e+02f,  5.85323483e+02f
,	 5.91890898e+02f,  5.98476581e+02f,  6.05080431e+02f,  6.11702349e+02f
,	 6.18342238e+02f,  6.25000000e+02f,  6.31675540e+02f,  6.38368763e+02f
,	 6.45079578e+02f,  6.51807891e+02f,  6.58553612e+02f,  6.65316653e+02f
,	 6.72096925e+02f,  6.78894340e+02f,  6.85708813e+02f,  6.92540258e+02f
,	 6.99388593e+02f,  7.06253733e+02f,  7.13135597e+02f,  7.20034104e+02f
,	 7.26949174e+02f,  7.33880729e+02f,  7.40828689e+02f,  7.47792979e+02f
,	 7.54773522e+02f,  7.61770242e+02f,  7.68783065e+02f,  7.75811917e+02f
,	 7.82856726e+02f,  7.89917420e+02f,  7.96993927e+02f,  8.04086177e+02f
,	 8.11194101e+02f,  8.18317630e+02f,  8.25456695e+02f,  8.32611230e+02f
,	 8.39781167e+02f,  8.46966442e+02f,  8.54166988e+02f,  8.61382741e+02f
,	 8.68613637e+02f,  8.75859614e+02f,  8.83120608e+02f,  8.90396558e+02f
,	 8.97687403e+02f,  9.04993081e+02f,  9.12313534e+02f,  9.19648701e+02f
,	 9.26998523e+02f,  9.34362944e+02f,  9.41741904e+02f,  9.49135347e+02f
,	 9.56543216e+02f,  9.63965455e+02f,  9.71402010e+02f,  9.78852824e+02f
,	 9.86317844e+02f,  9.93797016e+02f,  1.00129029e+03f,  1.00879760e+03f
,	 1.01631891e+03f,  1.02385416e+03f,  1.03140330e+03f,  1.03896628e+03f
,	 1.04654305e+03f,  1.05413355e+03f,  1.06173775e+03f,  1.06935559e+03f
,	 1.07698701e+03f,  1.08463198e+03f,  1.09229044e+03f,  1.09996236e+03f
,	 1.10764767e+03f,  1.11534634e+03f,  1.12305831e+03f,  1.13078355e+03f
,	 1.13852200e+03f,  1.14627363e+03f,  1.15403838e+03f,  1.16181622e+03f
,	 1.16960710e+03f,  1.17741097e+03f,  1.18522779e+03f,  1.19305752e+03f
,	 1.20090012e+03f,  1.20875555e+03f,  1.21662376e+03f,  1.22450471e+03f
,	 1.23239836e+03f,  1.24030468e+03f,  1.24822361e+03f,  1.25615512e+03f
,	 1.26409918e+03f,  1.27205573e+03f,  1.28002474e+03f,  1.28800618e+03f
,	 1.29600000e+03f,  1.30400617e+03f,  1.31202464e+03f,  1.32005539e+03f
,	 1.32809836e+03f,  1.33615353e+03f,  1.34422087e+03f,  1.35230032e+03f
,	 1.36039186e+03f,  1.36849545e+03f,  1.37661105e+03f,  1.38473864e+03f
,	 1.39287816e+03f,  1.40102960e+03f,  1.40919291e+03f,  1.41736805e+03f
,	 1.42555501e+03f,  1.43375373e+03f,  1.44196419e+03f,  1.45018636e+03f
,	 1.45842020e+03f,  1.46666567e+03f,  1.47492276e+03f,  1.48319141e+03f
,	 1.49147160e+03f,  1.49976331e+03f,  1.50806648e+03f,  1.51638111e+03f
,	 1.52470714e+03f,  1.53304456e+03f,  1.54139333e+03f,  1.54975342e+03f
,	 1.55812480e+03f,  1.56650744e+03f,  1.57490131e+03f,  1.58330638e+03f
,	 1.59172262e+03f,  1.60015000e+03f,  1.60858848e+03f,  1.61703805e+03f
,	 1.62549868e+03f,  1.63397032e+03f,  1.64245296e+03f,  1.65094657e+03f
,	 1.65945112e+03f,  1.66796657e+03f,  1.67649291e+03f,  1.68503011e+03f
,	 1.69357813e+03f,  1.70213695e+03f,  1.71070654e+03f,  1.71928688e+03f
,	 1.72787793e+03f,  1.73647968e+03f,  1.74509210e+03f,  1.75371515e+03f
,	 1.76234882e+03f,  1.77099307e+03f,  1.77964789e+03f,  1.78831324e+03f
,	 1.79698910e+03f,  1.80567544e+03f,  1.81437225e+03f,  1.82307949e+03f
,	 1.83179713e+03f,  1.84052517e+03f,  1.84926356e+03f,  1.85801228e+03f
,	 1.86677132e+03f,  1.87554064e+03f,  1.88432023e+03f,  1.89311006e+03f
,	 1.90191010e+03f,  1.91072033e+03f,  1.91954072e+03f,  1.92837127e+03f
,	 1.93721193e+03f,  1.94606269e+03f,  1.95492353e+03f,  1.96379442e+03f
,	 1.97267534e+03f,  1.98156626e+03f,  1.99046717e+03f,  1.99937804e+03f
,	 2.00829885e+03f,  2.01722958e+03f,  2.02617020e+03f,  2.03512070e+03f
,	 2.04408105e+03f,  2.05305123e+03f,  2.06203121e+03f,  2.07102099e+03f
,	 2.08002053e+03f,  2.08902982e+03f,  2.09804883e+03f,  2.10707754e+03f
,	 2.11611594e+03f,  2.12516400e+03f,  2.13422170e+03f,  2.14328902e+03f
,	 2.15236594e+03f,  2.16145244e+03f,  2.17054849e+03f,  2.17965409e+03f
,	 2.18876921e+03f,  2.19789383e+03f,  2.20702793e+03f,  2.21617149e+03f
,	 2.22532449e+03f,  2.23448691e+03f,  2.24365873e+03f,  2.25283994e+03f
,	 2.26203051e+03f,  2.27123042e+03f,  2.28043967e+03f,  2.28965821e+03f
,	 2.29888605e+03f,  2.30812316e+03f,  2.31736951e+03f,  2.32662510e+03f
,	 2.33588991e+03f,  2.34516390e+03f,  2.35444708e+03f,  2.36373942e+03f
,	 2.37304090e+03f,  2.38235150e+03f,  2.39167120e+03f,  2.40100000e+03f
,	 2.41033787e+03f,  2.41968478e+03f,  2.42904074e+03f,  2.43840571e+03f
,	 2.44777968e+03f,  2.45716264e+03f,  2.46655456e+03f,  2.47595543e+03f
,	 2.48536523e+03f,  2.49478394e+03f,  2.50421156e+03f,  2.51364806e+03f
,	 2.52309342e+03f,  2.53254763e+03f,  2.54201067e+03f,  2.55148252e+03f
,	 2.56096318e+03f,  2.57045262e+03f,  2.57995082e+03f,  2.58945777e+03f
,	 2.59897346e+03f,  2.60849787e+03f,  2.61803097e+03f,  2.62757277e+03f
,	 2.63712323e+03f,  2.64668235e+03f,  2.65625011e+03f,  2.66582649e+03f
,	 2.67541148e+03f,  2.68500506e+03f,  2.69460722e+03f,  2.70421794e+03f
,	 2.71383721e+03f,  2.72346501e+03f,  2.73310133e+03f,  2.74274614e+03f
,	 2.75239945e+03f,  2.76206122e+03f,  2.77173146e+03f,  2.78141013e+03f
,	 2.79109723e+03f,  2.80079274e+03f,  2.81049666e+03f,  2.82020895e+03f
,	 2.82992962e+03f,  2.83965863e+03f,  2.84939599e+03f,  2.85914168e+03f
,	 2.86889568e+03f,  2.87865797e+03f,  2.88842855e+03f,  2.89820740e+03f
,	 2.90799450e+03f,  2.91778985e+03f,  2.92759342e+03f,  2.93740521e+03f
,	 2.94722520e+03f,  2.95705337e+03f,  2.96688972e+03f,  2.97673423e+03f
,	 2.98658688e+03f,  2.99644767e+03f,  3.00631658e+03f,  3.01619359e+03f
,	 3.02607869e+03f,  3.03597188e+03f,  3.04587312e+03f,  3.05578243e+03f
,	 3.06569977e+03f,  3.07562514e+03f,  3.08555852e+03f,  3.09549991e+03f
,	 3.10544928e+03f,  3.11540663e+03f,  3.12537194e+03f,  3.13534520e+03f
,	 3.14532640e+03f,  3.15531553e+03f,  3.16531256e+03f,  3.17531750e+03f
,	 3.18533032e+03f,  3.19535102e+03f,  3.20537958e+03f,  3.21541599e+03f
,	 3.22546023e+03f,  3.23551231e+03f,  3.24557220e+03f,  3.25563988e+03f
,	 3.26571536e+03f,  3.27579862e+03f,  3.28588964e+03f,  3.29598841e+03f
,	 3.30609493e+03f,  3.31620917e+03f,  3.32633113e+03f,  3.33646080e+03f
,	 3.34659817e+03f,  3.35674321e+03f,  3.36689593e+03f,  3.37705631e+03f
,	 3.38722433e+03f,  3.39739999e+03f,  3.40758328e+03f,  3.41777418e+03f
,	 3.42797268e+03f,  3.43817877e+03f,  3.44839245e+03f,  3.45861369e+03f
,	 3.46884249e+03f,  3.47907883e+03f,  3.48932271e+03f,  3.49957411e+03f
,	 3.50983303e+03f,  3.52009945e+03f,  3.53037336e+03f,  3.54065475e+03f
,	 3.55094361e+03f,  3.56123993e+03f,  3.57154369e+03f,  3.58185489e+03f
,	 3.59217352e+03f,  3.60249957e+03f,  3.61283301e+03f,  3.62317386e+03f
,	 3.63352208e+03f,  3.64387768e+03f,  3.65424065e+03f,  3.66461096e+03f
,	 3.67498862e+03f,  3.68537360e+03f,  3.69576591e+03f,  3.70616553e+03f
,	 3.71657245e+03f,  3.72698666e+03f,  3.73740815e+03f,  3.74783692e+03f
,	 3.75827294e+03f,  3.76871621e+03f,  3.77916672e+03f,  3.78962446e+03f
,	 3.80008941e+03f,  3.81056158e+03f,  3.82104095e+03f,  3.83152751e+03f
,	 3.84202125e+03f,  3.85252216e+03f,  3.86303023e+03f,  3.87354545e+03f
,	 3.88406781e+03f,  3.89459731e+03f,  3.90513392e+03f,  3.91567765e+03f
,	 3.92622848e+03f,  3.93678640e+03f,  3.94735141e+03f,  3.95792349e+03f
,	 3.96850263e+03f,  3.97908883e+03f,  3.98968207e+03f,  4.00028236e+03f
,	 4.01088967e+03f,  4.02150399e+03f,  4.03212533e+03f,  4.04275366e+03f
,	 4.05338899e+03f,  4.06403129e+03f,  4.07468057e+03f,  4.08533681e+03f
,	 4.09600000e+03f,  4.10667014e+03f,  4.11734721e+03f,  4.12803121e+03f
,	 4.13872213e+03f,  4.14941995e+03f,  4.16012468e+03f,  4.17083629e+03f
,	 4.18155479e+03f,  4.19228016e+03f,  4.20301239e+03f,  4.21375148e+03f
,	 4.22449742e+03f,  4.23525020e+03f,  4.24600980e+03f,  4.25677622e+03f
,	 4.26754946e+03f,  4.27832950e+03f,  4.28911634e+03f,  4.29990996e+03f
,	 4.31071036e+03f,  4.32151753e+03f,  4.33233146e+03f,  4.34315214e+03f
,	 4.35397956e+03f,  4.36481373e+03f,  4.37565461e+03f,  4.38650222e+03f
,	 4.39735654e+03f,  4.40821756e+03f,  4.41908527e+03f,  4.42995967e+03f
,	 4.44084075e+03f,  4.45172850e+03f,  4.46262291e+03f,  4.47352397e+03f
,	 4.48443167e+03f,  4.49534602e+03f,  4.50626699e+03f,  4.51719458e+03f
,	 4.52812879e+03f,  4.53906960e+03f,  4.55001700e+03f,  4.56097100e+03f
,	 4.57193158e+03f,  4.58289873e+03f,  4.59387244e+03f,  4.60485271e+03f
,	 4.61583954e+03f,  4.62683290e+03f,  4.63783280e+03f,  4.64883922e+03f
,	 4.65985216e+03f,  4.67087162e+03f,  4.68189757e+03f,  4.69293002e+03f
,	 4.70396896e+03f,  4.71501438e+03f,  4.72606627e+03f,  4.73712463e+03f
,	 4.74818945e+03f,  4.75926071e+03f,  4.77033842e+03f,  4.78142256e+03f
,	 4.79251313e+03f,  4.80361012e+03f,  4.81471352e+03f,  4.82582333e+03f
,	 4.83693953e+03f,  4.84806213e+03f,  4.85919110e+03f,  4.87032646e+03f
,	 4.88146818e+03f,  4.89261627e+03f,  4.90377070e+03f,  4.91493149e+03f
,	 4.92609861e+03f,  4.93727207e+03f,  4.94845185e+03f,  4.95963795e+03f
,	 4.97083036e+03f,  4.98202908e+03f,  4.99323409e+03f,  5.00444539e+03f
,	 5.01566297e+03f,  5.02688683e+03f,  5.03811696e+03f,  5.04935335e+03f
,	 5.06059599e+03f,  5.07184488e+03f,  5.08310002e+03f,  5.09436138e+03f
,	 5.10562897e+03f,  5.11690279e+03f,  5.12818281e+03f,  5.13946905e+03f
,	 5.15076148e+03f,  5.16206010e+03f,  5.17336491e+03f,  5.18467590e+03f
,	 5.19599307e+03f,  5.20731639e+03f,  5.21864588e+03f,  5.22998152e+03f
,	 5.24132331e+03f,  5.25267123e+03f,  5.26402529e+03f,  5.27538547e+03f
,	 5.28675177e+03f,  5.29812418e+03f,  5.30950270e+03f,  5.32088732e+03f
,	 5.33227803e+03f,  5.34367483e+03f,  5.35507771e+03f,  5.36648666e+03f
,	 5.37790168e+03f,  5.38932276e+03f,  5.40074990e+03f,  5.41218308e+03f
,	 5.42362230e+03f,  5.43506756e+03f,  5.44651884e+03f,  5.45797615e+03f
,	 5.46943948e+03f,  5.48090881e+03f,  5.49238415e+03f,  5.50386548e+03f
,	 5.51535281e+03f,  5.52684612e+03f,  5.53834540e+03f,  5.54985066e+03f
,	 5.56136189e+03f,  5.57287908e+03f,  5.58440221e+03f,  5.59593130e+03f
,	 5.60746633e+03f,  5.61900729e+03f,  5.63055418e+03f,  5.64210700e+03f
,	 5.65366573e+03f,  5.66523038e+03f,  5.67680092e+03f,  5.68837737e+03f
,	 5.69995971e+03f,  5.71154794e+03f,  5.72314204e+03f,  5.73474203e+03f
,	 5.74634788e+03f,  5.75795959e+03f,  5.76957716e+03f,  5.78120058e+03f
,	 5.79282985e+03f,  5.80446496e+03f,  5.81610590e+03f,  5.82775267e+03f
,	 5.83940526e+03f,  5.85106367e+03f,  5.86272788e+03f,  5.87439790e+03f
,	 5.88607372e+03f,  5.89775534e+03f,  5.90944274e+03f,  5.92113592e+03f
,	 5.93283488e+03f,  5.94453961e+03f,  5.95625010e+03f,  5.96796635e+03f
,	 5.97968835e+03f,  5.99141611e+03f,  6.00314960e+03f,  6.01488883e+03f
,	 6.02663379e+03f,  6.03838448e+03f,  6.05014088e+03f,  6.06190300e+03f
,	 6.07367083e+03f,  6.08544436e+03f,  6.09722359e+03f,  6.10900851e+03f
,	 6.12079911e+03f,  6.13259540e+03f,  6.14439736e+03f,  6.15620499e+03f
,	 6.16801829e+03f,  6.17983725e+03f,  6.19166185e+03f,  6.20349211e+03f
,	 6.21532801e+03f,  6.22716955e+03f,  6.23901672e+03f,  6.25086952e+03f
,	 6.26272794e+03f,  6.27459197e+03f,  6.28646161e+03f,  6.29833687e+03f
,	 6.31021772e+03f,  6.32210416e+03f,  6.33399620e+03f,  6.34589382e+03f
,	 6.35779702e+03f,  6.36970579e+03f,  6.38162013e+03f,  6.39354004e+03f
,	 6.40546550e+03f,  6.41739652e+03f,  6.42933308e+03f,  6.44127519e+03f
,	 6.45322284e+03f,  6.46517601e+03f,  6.47713472e+03f,  6.48909895e+03f
,	 6.50106869e+03f,  6.51304395e+03f,  6.52502471e+03f,  6.53701098e+03f
,	 6.54900274e+03f,  6.56100000e+03f,  6.57300274e+03f,  6.58501097e+03f
,	 6.59702467e+03f,  6.60904384e+03f,  6.62106848e+03f,  6.63309859e+03f
,	 6.64513415e+03f,  6.65717516e+03f,  6.66922162e+03f,  6.68127352e+03f
,	 6.69333086e+03f,  6.70539363e+03f,  6.71746183e+03f,  6.72953545e+03f
,	 6.74161449e+03f,  6.75369894e+03f,  6.76578880e+03f,  6.77788406e+03f
,	 6.78998472e+03f,  6.80209078e+03f,  6.81420222e+03f,  6.82631905e+03f
,	 6.83844126e+03f,  6.85056884e+03f,  6.86270179e+03f,  6.87484011e+03f
,	 6.88698379e+03f,  6.89913282e+03f,  6.91128720e+03f,  6.92344693e+03f
,	 6.93561201e+03f,  6.94778241e+03f,  6.95995815e+03f,  6.97213922e+03f
,	 6.98432561e+03f,  6.99651732e+03f,  7.00871434e+03f,  7.02091667e+03f
,	 7.03312431e+03f,  7.04533724e+03f,  7.05755547e+03f,  7.06977899e+03f
,	 7.08200780e+03f,  7.09424188e+03f,  7.10648125e+03f,  7.11872588e+03f
,	 7.13097578e+03f,  7.14323095e+03f,  7.15549138e+03f,  7.16775706e+03f
,	 7.18002798e+03f,  7.19230416e+03f,  7.20458557e+03f,  7.21687222e+03f
,	 7.22916411e+03f,  7.24146122e+03f,  7.25376355e+03f,  7.26607110e+03f
,	 7.27838386e+03f,  7.29070184e+03f,  7.30302502e+03f,  7.31535340e+03f
,	 7.32768697e+03f,  7.34002574e+03f,  7.35236970e+03f,  7.36471884e+03f
,	 7.37707316e+03f,  7.38943265e+03f,  7.40179731e+03f,  7.41416714e+03f
,	 7.42654213e+03f,  7.43892228e+03f,  7.45130758e+03f,  7.46369803e+03f
,	 7.47609363e+03f,  7.48849436e+03f,  7.50090023e+03f,  7.51331123e+03f
,	 7.52572736e+03f,  7.53814862e+03f,  7.55057499e+03f,  7.56300648e+03f
,	 7.57544307e+03f,  7.58788478e+03f,  7.60033158e+03f,  7.61278349e+03f
,	 7.62524048e+03f,  7.63770257e+03f,  7.65016975e+03f,  7.66264200e+03f
,	 7.67511933e+03f,  7.68760174e+03f,  7.70008921e+03f,  7.71258175e+03f
,	 7.72507935e+03f,  7.73758200e+03f,  7.75008971e+03f,  7.76260247e+03f
,	 7.77512027e+03f,  7.78764311e+03f,  7.80017099e+03f,  7.81270390e+03f
,	 7.82524184e+03f,  7.83778480e+03f,  7.85033279e+03f,  7.86288579e+03f
,	 7.87544380e+03f,  7.88800682e+03f,  7.90057484e+03f,  7.91314787e+03f
,	 7.92572589e+03f,  7.93830890e+03f,  7.95089690e+03f,  7.96348989e+03f
,	 7.97608785e+03f,  7.98869079e+03f,  8.00129871e+03f,  8.01391159e+03f
,	 8.02652944e+03f,  8.03915225e+03f,  8.05178002e+03f,  8.06441274e+03f
,	 8.07705040e+03f,  8.08969302e+03f,  8.10234057e+03f,  8.11499306e+03f
,	 8.12765049e+03f,  8.14031285e+03f,  8.15298013e+03f,  8.16565233e+03f
,	 8.17832946e+03f,  8.19101149e+03f,  8.20369844e+03f,  8.21639030e+03f
,	 8.22908705e+03f,  8.24178871e+03f,  8.25449526e+03f,  8.26720671e+03f
,	 8.27992304e+03f,  8.29264426e+03f,  8.30537036e+03f,  8.31810133e+03f
,	 8.33083718e+03f,  8.34357790e+03f,  8.35632348e+03f,  8.36907392e+03f
,	 8.38182923e+03f,  8.39458939e+03f,  8.40735439e+03f,  8.42012425e+03f
,	 8.43289895e+03f,  8.44567849e+03f,  8.45846286e+03f,  8.47125207e+03f
,	 8.48404611e+03f,  8.49684497e+03f,  8.50964865e+03f,  8.52245715e+03f
,	 8.53527047e+03f,  8.54808859e+03f,  8.56091153e+03f,  8.57373926e+03f
,	 8.58657180e+03f,  8.59940913e+03f,  8.61225126e+03f,  8.62509817e+03f
,	 8.63794987e+03f,  8.65080636e+03f,  8.66366762e+03f,  8.67653365e+03f
,	 8.68940446e+03f,  8.70228004e+03f,  8.71516038e+03f,  8.72804548e+03f
,	 8.74093533e+03f,  8.75382995e+03f,  8.76672931e+03f,  8.77963342e+03f
,	 8.79254227e+03f,  8.80545586e+03f,  8.81837419e+03f,  8.83129725e+03f
,	 8.84422504e+03f,  8.85715755e+03f,  8.87009479e+03f,  8.88303675e+03f
,	 8.89598342e+03f,  8.90893481e+03f,  8.92189090e+03f,  8.93485170e+03f
,	 8.94781720e+03f,  8.96078740e+03f,  8.97376230e+03f,  8.98674188e+03f
,	 8.99972616e+03f,  9.01271512e+03f,  9.02570876e+03f,  9.03870708e+03f
,	 9.05171007e+03f,  9.06471774e+03f,  9.07773007e+03f,  9.09074707e+03f
,	 9.10376873e+03f,  9.11679505e+03f,  9.12982602e+03f,  9.14286165e+03f
,	 9.15590192e+03f,  9.16894683e+03f,  9.18199639e+03f,  9.19505059e+03f
,	 9.20810942e+03f,  9.22117289e+03f,  9.23424098e+03f,  9.24731369e+03f
,	 9.26039103e+03f,  9.27347299e+03f,  9.28655956e+03f,  9.29965075e+03f
,	 9.31274654e+03f,  9.32584694e+03f,  9.33895194e+03f,  9.35206154e+03f
,	 9.36517573e+03f,  9.37829452e+03f,  9.39141790e+03f,  9.40454586e+03f
,	 9.41767841e+03f,  9.43081554e+03f,  9.44395724e+03f,  9.45710352e+03f
,	 9.47025437e+03f,  9.48340978e+03f,  9.49656976e+03f,  9.50973430e+03f
,	 9.52290339e+03f,  9.53607704e+03f,  9.54925524e+03f,  9.56243800e+03f
,	 9.57562529e+03f,  9.58881713e+03f,  9.60201350e+03f,  9.61521441e+03f
,	 9.62841986e+03f,  9.64162983e+03f,  9.65484433e+03f,  9.66806335e+03f
,	 9.68128690e+03f,  9.69451496e+03f,  9.70774753e+03f,  9.72098461e+03f
,	 9.73422621e+03f,  9.74747230e+03f,  9.76072290e+03f,  9.77397800e+03f
,	 9.78723759e+03f,  9.80050168e+03f,  9.81377025e+03f,  9.82704331e+03f
,	 9.84032086e+03f,  9.85360288e+03f,  9.86688938e+03f,  9.88018036e+03f
,	 9.89347581e+03f,  9.90677573e+03f,  9.92008011e+03f,  9.93338895e+03f
,	 9.94670225e+03f,  9.96002001e+03f,  9.97334223e+03f,  9.98666889e+03f
,	 1.00000000e+04f,  1.00133356e+04f,  1.00266756e+04f,  1.00400200e+04f
,	 1.00533689e+04f,  1.00667222e+04f,  1.00800799e+04f,  1.00934421e+04f
,	 1.01068086e+04f,  1.01201796e+04f,  1.01335551e+04f,  1.01469349e+04f
,	 1.01603192e+04f,  1.01737078e+04f,  1.01871009e+04f,  1.02004983e+04f
,	 1.02139002e+04f,  1.02273065e+04f,  1.02407171e+04f,  1.02541322e+04f
,	 1.02675516e+04f,  1.02809755e+04f,  1.02944037e+04f,  1.03078363e+04f
,	 1.03212732e+04f,  1.03347146e+04f,  1.03481603e+04f,  1.03616104e+04f
,	 1.03750648e+04f,  1.03885237e+04f,  1.04019868e+04f,  1.04154544e+04f
,	 1.04289263e+04f,  1.04424025e+04f,  1.04558831e+04f,  1.04693680e+04f
,	 1.04828573e+04f,  1.04963509e+04f,  1.05098489e+04f,  1.05233512e+04f
,	 1.05368578e+04f,  1.05503688e+04f,  1.05638840e+04f,  1.05774036e+04f
,	 1.05909276e+04f,  1.06044558e+04f,  1.06179884e+04f,  1.06315253e+04f
,	 1.06450665e+04f,  1.06586119e+04f,  1.06721617e+04f,  1.06857158e+04f
,	 1.06992743e+04f,  1.07128369e+04f,  1.07264039e+04f,  1.07399752e+04f
,	 1.07535508e+04f,  1.07671307e+04f,  1.07807148e+04f,  1.07943032e+04f
,	 1.08078959e+04f,  1.08214929e+04f,  1.08350941e+04f,  1.08486997e+04f
,	 1.08623094e+04f,  1.08759235e+04f,  1.08895418e+04f,  1.09031644e+04f
,	 1.09167912e+04f,  1.09304223e+04f,  1.09440576e+04f,  1.09576972e+04f
,	 1.09713410e+04f,  1.09849891e+04f,  1.09986414e+04f,  1.10122979e+04f
,	 1.10259587e+04f,  1.10396237e+04f,  1.10532930e+04f,  1.10669664e+04f
,	 1.10806441e+04f,  1.10943261e+04f,  1.11080122e+04f,  1.11217025e+04f
,	 1.11353971e+04f,  1.11490959e+04f,  1.11627989e+04f,  1.11765061e+04f
,	 1.11902175e+04f,  1.12039331e+04f,  1.12176529e+04f,  1.12313769e+04f
,	 1.12451051e+04f,  1.12588375e+04f,  1.12725740e+04f,  1.12863148e+04f
,	 1.13000597e+04f,  1.13138088e+04f,  1.13275621e+04f,  1.13413196e+04f
,	 1.13550813e+04f,  1.13688471e+04f,  1.13826171e+04f,  1.13963912e+04f
,	 1.14101695e+04f,  1.14239520e+04f,  1.14377387e+04f,  1.14515295e+04f
,	 1.14653244e+04f,  1.14791235e+04f,  1.14929267e+04f,  1.15067341e+04f
,	 1.15205457e+04f,  1.15343613e+04f,  1.15481811e+04f,  1.15620051e+04f
,	 1.15758332e+04f,  1.15896654e+04f,  1.16035017e+04f,  1.16173422e+04f
,	 1.16311868e+04f,  1.16450355e+04f,  1.16588883e+04f,  1.16727453e+04f
,	 1.16866063e+04f,  1.17004715e+04f,  1.17143408e+04f,  1.17282142e+04f
,	 1.17420917e+04f,  1.17559733e+04f,  1.17698589e+04f,  1.17837487e+04f
,	 1.17976426e+04f,  1.18115406e+04f,  1.18254426e+04f,  1.18393488e+04f
,	 1.18532590e+04f,  1.18671733e+04f,  1.18810917e+04f,  1.18950142e+04f
,	 1.19089408e+04f,  1.19228714e+04f,  1.19368061e+04f,  1.19507448e+04f
,	 1.19646877e+04f,  1.19786346e+04f,  1.19925855e+04f,  1.20065405e+04f
,	 1.20204996e+04f,  1.20344627e+04f,  1.20484299e+04f,  1.20624011e+04f
,	 1.20763763e+04f,  1.20903557e+04f,  1.21043390e+04f,  1.21183264e+04f
,	 1.21323178e+04f,  1.21463133e+04f,  1.21603128e+04f,  1.21743163e+04f
,	 1.21883239e+04f,  1.22023354e+04f,  1.22163510e+04f,  1.22303707e+04f
,	 1.22443943e+04f,  1.22584220e+04f,  1.22724537e+04f,  1.22864893e+04f
,	 1.23005290e+04f,  1.23145727e+04f,  1.23286204e+04f,  1.23426722e+04f
,	 1.23567279e+04f,  1.23707876e+04f,  1.23848513e+04f,  1.23989190e+04f
,	 1.24129907e+04f,  1.24270664e+04f,  1.24411460e+04f,  1.24552297e+04f
,	 1.24693173e+04f,  1.24834089e+04f,  1.24975045e+04f,  1.25116041e+04f
,	 1.25257076e+04f,  1.25398151e+04f,  1.25539266e+04f,  1.25680421e+04f
,	 1.25821615e+04f,  1.25962848e+04f,  1.26104122e+04f,  1.26245435e+04f
,	 1.26386787e+04f,  1.26528179e+04f,  1.26669611e+04f,  1.26811082e+04f
,	 1.26952592e+04f,  1.27094142e+04f,  1.27235731e+04f,  1.27377360e+04f
,	 1.27519028e+04f,  1.27660736e+04f,  1.27802483e+04f,  1.27944269e+04f
,	 1.28086094e+04f,  1.28227959e+04f,  1.28369863e+04f,  1.28511806e+04f
,	 1.28653788e+04f,  1.28795810e+04f,  1.28937871e+04f,  1.29079971e+04f
,	 1.29222109e+04f,  1.29364288e+04f,  1.29506505e+04f,  1.29648761e+04f
,	 1.29791056e+04f,  1.29933390e+04f,  1.30075764e+04f,  1.30218176e+04f
,	 1.30360627e+04f,  1.30503117e+04f,  1.30645646e+04f,  1.30788214e+04f
,	 1.30930821e+04f,  1.31073466e+04f,  1.31216151e+04f,  1.31358874e+04f
,	 1.31501636e+04f,  1.31644437e+04f,  1.31787276e+04f,  1.31930154e+04f
,	 1.32073071e+04f,  1.32216027e+04f,  1.32359021e+04f,  1.32502054e+04f
,	 1.32645125e+04f,  1.32788235e+04f,  1.32931384e+04f,  1.33074571e+04f
,	 1.33217797e+04f,  1.33361061e+04f,  1.33504364e+04f,  1.33647705e+04f
,	 1.33791084e+04f,  1.33934502e+04f,  1.34077959e+04f,  1.34221454e+04f
,	 1.34364987e+04f,  1.34508558e+04f,  1.34652168e+04f,  1.34795816e+04f
,	 1.34939503e+04f,  1.35083227e+04f,  1.35226990e+04f,  1.35370791e+04f
,	 1.35514631e+04f,  1.35658508e+04f,  1.35802424e+04f,  1.35946378e+04f
,	 1.36090370e+04f,  1.36234400e+04f,  1.36378468e+04f,  1.36522574e+04f
,	 1.36666718e+04f,  1.36810900e+04f,  1.36955120e+04f,  1.37099379e+04f
,	 1.37243675e+04f,  1.37388009e+04f,  1.37532381e+04f,  1.37676791e+04f
,	 1.37821239e+04f,  1.37965724e+04f,  1.38110248e+04f,  1.38254809e+04f
,	 1.38399408e+04f,  1.38544045e+04f,  1.38688720e+04f,  1.38833432e+04f
,	 1.38978182e+04f,  1.39122970e+04f,  1.39267795e+04f,  1.39412658e+04f
,	 1.39557559e+04f,  1.39702498e+04f,  1.39847474e+04f,  1.39992487e+04f
,	 1.40137538e+04f,  1.40282627e+04f,  1.40427753e+04f,  1.40572917e+04f
,	 1.40718118e+04f,  1.40863357e+04f,  1.41008633e+04f,  1.41153946e+04f
,	 1.41299297e+04f,  1.41444686e+04f,  1.41590111e+04f,  1.41735574e+04f
,	 1.41881075e+04f,  1.42026613e+04f,  1.42172187e+04f,  1.42317800e+04f
,	 1.42463449e+04f,  1.42609136e+04f,  1.42754860e+04f,  1.42900621e+04f
,	 1.43046420e+04f,  1.43192255e+04f,  1.43338128e+04f,  1.43484038e+04f
,	 1.43629984e+04f,  1.43775968e+04f,  1.43921989e+04f,  1.44068048e+04f
,	 1.44214143e+04f,  1.44360275e+04f,  1.44506444e+04f,  1.44652650e+04f
,	 1.44798893e+04f,  1.44945173e+04f,  1.45091490e+04f,  1.45237844e+04f
,	 1.45384234e+04f,  1.45530662e+04f,  1.45677126e+04f,  1.45823627e+04f
,	 1.45970165e+04f,  1.46116740e+04f,  1.46263352e+04f,  1.46410000e+04f
,	 1.46556685e+04f,  1.46703407e+04f,  1.46850165e+04f,  1.46996960e+04f
,	 1.47143792e+04f,  1.47290660e+04f,  1.47437566e+04f,  1.47584507e+04f
,	 1.47731485e+04f,  1.47878500e+04f,  1.48025551e+04f,  1.48172639e+04f
,	 1.48319764e+04f,  1.48466925e+04f,  1.48614122e+04f,  1.48761356e+04f
,	 1.48908626e+04f,  1.49055933e+04f,  1.49203276e+04f,  1.49350655e+04f
,	 1.49498071e+04f,  1.49645523e+04f,  1.49793012e+04f,  1.49940536e+04f
,	 1.50088098e+04f,  1.50235695e+04f,  1.50383329e+04f,  1.50530998e+04f
,	 1.50678705e+04f,  1.50826447e+04f,  1.50974225e+04f,  1.51122040e+04f
,	 1.51269891e+04f,  1.51417778e+04f,  1.51565701e+04f,  1.51713660e+04f
,	 1.51861655e+04f,  1.52009687e+04f,  1.52157754e+04f,  1.52305858e+04f
,	 1.52453997e+04f,  1.52602172e+04f,  1.52750384e+04f,  1.52898631e+04f
,	 1.53046915e+04f,  1.53195234e+04f,  1.53343589e+04f,  1.53491980e+04f
,	 1.53640407e+04f,  1.53788870e+04f,  1.53937368e+04f,  1.54085903e+04f
,	 1.54234473e+04f,  1.54383079e+04f,  1.54531721e+04f,  1.54680398e+04f
,	 1.54829111e+04f,  1.54977860e+04f,  1.55126645e+04f,  1.55275466e+04f
,	 1.55424322e+04f,  1.55573213e+04f,  1.55722141e+04f,  1.55871104e+04f
,	 1.56020102e+04f,  1.56169136e+04f,  1.56318206e+04f,  1.56467311e+04f
,	 1.56616452e+04f,  1.56765628e+04f,  1.56914840e+04f,  1.57064087e+04f
,	 1.57213370e+04f,  1.57362688e+04f,  1.57512042e+04f,  1.57661431e+04f
,	 1.57810855e+04f,  1.57960315e+04f,  1.58109810e+04f,  1.58259341e+04f
,	 1.58408906e+04f,  1.58558507e+04f,  1.58708144e+04f,  1.58857816e+04f
,	 1.59007523e+04f,  1.59157265e+04f,  1.59307042e+04f,  1.59456855e+04f
,	 1.59606703e+04f,  1.59756586e+04f,  1.59906504e+04f,  1.60056457e+04f
,	 1.60206446e+04f,  1.60356469e+04f,  1.60506528e+04f,  1.60656622e+04f
,	 1.60806751e+04f,  1.60956915e+04f,  1.61107114e+04f,  1.61257347e+04f
,	 1.61407616e+04f,  1.61557920e+04f,  1.61708259e+04f,  1.61858633e+04f
,	 1.62009042e+04f,  1.62159485e+04f,  1.62309964e+04f,  1.62460477e+04f
,	 1.62611026e+04f,  1.62761609e+04f,  1.62912227e+04f,  1.63062880e+04f
,	 1.63213568e+04f,  1.63364290e+04f,  1.63515047e+04f,  1.63665839e+04f
,	 1.63816666e+04f,  1.63967527e+04f,  1.64118423e+04f,  1.64269354e+04f
,	 1.64420320e+04f,  1.64571320e+04f,  1.64722355e+04f,  1.64873424e+04f
,	 1.65024528e+04f,  1.65175667e+04f,  1.65326840e+04f,  1.65478048e+04f
,	 1.65629290e+04f,  1.65780567e+04f,  1.65931879e+04f,  1.66083225e+04f
,	 1.66234605e+04f,  1.66386020e+04f,  1.66537469e+04f,  1.66688953e+04f
,	 1.66840471e+04f,  1.66992024e+04f,  1.67143611e+04f,  1.67295232e+04f
,	 1.67446888e+04f,  1.67598578e+04f,  1.67750302e+04f,  1.67902061e+04f
,	 1.68053854e+04f,  1.68205681e+04f,  1.68357543e+04f,  1.68509439e+04f
,	 1.68661369e+04f,  1.68813333e+04f,  1.68965332e+04f,  1.69117364e+04f
,	 1.69269431e+04f,  1.69421532e+04f,  1.69573667e+04f,  1.69725837e+04f
,	 1.69878040e+04f,  1.70030278e+04f,  1.70182549e+04f,  1.70334855e+04f
,	 1.70487195e+04f,  1.70639568e+04f,  1.70791976e+04f,  1.70944418e+04f
,	 1.71096894e+04f,  1.71249403e+04f,  1.71401947e+04f,  1.71554525e+04f
,	 1.71707136e+04f,  1.71859782e+04f,  1.72012461e+04f,  1.72165175e+04f
,	 1.72317922e+04f,  1.72470703e+04f,  1.72623518e+04f,  1.72776366e+04f
,	 1.72929249e+04f,  1.73082165e+04f,  1.73235115e+04f,  1.73388099e+04f
,	 1.73541117e+04f,  1.73694168e+04f,  1.73847253e+04f,  1.74000372e+04f
,	 1.74153525e+04f,  1.74306711e+04f,  1.74459931e+04f,  1.74613184e+04f
,	 1.74766471e+04f,  1.74919792e+04f,  1.75073146e+04f,  1.75226534e+04f
,	 1.75379956e+04f,  1.75533411e+04f,  1.75686899e+04f,  1.75840421e+04f
,	 1.75993977e+04f,  1.76147566e+04f,  1.76301189e+04f,  1.76454845e+04f
,	 1.76608535e+04f,  1.76762258e+04f,  1.76916014e+04f,  1.77069804e+04f
,	 1.77223627e+04f,  1.77377484e+04f,  1.77531374e+04f,  1.77685297e+04f
,	 1.77839254e+04f,  1.77993244e+04f,  1.78147267e+04f,  1.78301324e+04f
,	 1.78455414e+04f,  1.78609537e+04f,  1.78763694e+04f,  1.78917883e+04f
,	 1.79072106e+04f,  1.79226362e+04f,  1.79380652e+04f,  1.79534974e+04f
,	 1.79689330e+04f,  1.79843719e+04f,  1.79998141e+04f,  1.80152596e+04f
,	 1.80307084e+04f,  1.80461605e+04f,  1.80616160e+04f,  1.80770747e+04f
,	 1.80925368e+04f,  1.81080022e+04f,  1.81234708e+04f,  1.81389428e+04f
,	 1.81544180e+04f,  1.81698966e+04f,  1.81853785e+04f,  1.82008636e+04f
,	 1.82163521e+04f,  1.82318438e+04f,  1.82473388e+04f,  1.82628372e+04f
,	 1.82783388e+04f,  1.82938437e+04f,  1.83093519e+04f,  1.83248633e+04f
,	 1.83403781e+04f,  1.83558961e+04f,  1.83714174e+04f,  1.83869420e+04f
,	 1.84024699e+04f,  1.84180010e+04f,  1.84335355e+04f,  1.84490732e+04f
,	 1.84646141e+04f,  1.84801584e+04f,  1.84957059e+04f,  1.85112567e+04f
,	 1.85268107e+04f,  1.85423680e+04f,  1.85579286e+04f,  1.85734924e+04f
,	 1.85890595e+04f,  1.86046299e+04f,  1.86202035e+04f,  1.86357804e+04f
,	 1.86513605e+04f,  1.86669439e+04f,  1.86825305e+04f,  1.86981204e+04f
,	 1.87137135e+04f,  1.87293099e+04f,  1.87449095e+04f,  1.87605124e+04f
,	 1.87761185e+04f,  1.87917279e+04f,  1.88073405e+04f,  1.88229564e+04f
,	 1.88385755e+04f,  1.88541978e+04f,  1.88698234e+04f,  1.88854522e+04f
,	 1.89010842e+04f,  1.89167195e+04f,  1.89323580e+04f,  1.89479997e+04f
,	 1.89636446e+04f,  1.89792928e+04f,  1.89949442e+04f,  1.90105989e+04f
,	 1.90262567e+04f,  1.90419178e+04f,  1.90575821e+04f,  1.90732496e+04f
,	 1.90889204e+04f,  1.91045943e+04f,  1.91202715e+04f,  1.91359519e+04f
,	 1.91516355e+04f,  1.91673223e+04f,  1.91830123e+04f,  1.91987056e+04f
,	 1.92144020e+04f,  1.92301016e+04f,  1.92458045e+04f,  1.92615105e+04f
,	 1.92772198e+04f,  1.92929323e+04f,  1.93086479e+04f,  1.93243668e+04f
,	 1.93400888e+04f,  1.93558141e+04f,  1.93715425e+04f,  1.93872741e+04f
,	 1.94030090e+04f,  1.94187470e+04f,  1.94344882e+04f,  1.94502326e+04f
,	 1.94659802e+04f,  1.94817309e+04f,  1.94974849e+04f,  1.95132420e+04f
,	 1.95290023e+04f,  1.95447658e+04f,  1.95605325e+04f,  1.95763024e+04f
,	 1.95920754e+04f,  1.96078516e+04f,  1.96236310e+04f,  1.96394135e+04f
,	 1.96551992e+04f,  1.96709881e+04f,  1.96867802e+04f,  1.97025754e+04f
,	 1.97183738e+04f,  1.97341754e+04f,  1.97499801e+04f,  1.97657880e+04f
,	 1.97815991e+04f,  1.97974133e+04f,  1.98132306e+04f,  1.98290512e+04f
,	 1.98448748e+04f,  1.98607017e+04f,  1.98765317e+04f,  1.98923648e+04f
,	 1.99082011e+04f,  1.99240405e+04f,  1.99398831e+04f,  1.99557289e+04f
,	 1.99715778e+04f,  1.99874298e+04f,  2.00032850e+04f,  2.00191433e+04f
,	 2.00350047e+04f,  2.00508693e+04f,  2.00667371e+04f,  2.00826080e+04f
,	 2.00984820e+04f,  2.01143591e+04f,  2.01302394e+04f,  2.01461228e+04f
,	 2.01620093e+04f,  2.01778990e+04f,  2.01937918e+04f,  2.02096877e+04f
,	 2.02255868e+04f,  2.02414890e+04f,  2.02573943e+04f,  2.02733027e+04f
,	 2.02892143e+04f,  2.03051289e+04f,  2.03210467e+04f,  2.03369676e+04f
,	 2.03528916e+04f,  2.03688188e+04f,  2.03847490e+04f,  2.04006824e+04f
,	 2.04166189e+04f,  2.04325585e+04f,  2.04485012e+04f,  2.04644470e+04f
,	 2.04803959e+04f,  2.04963479e+04f,  2.05123030e+04f,  2.05282612e+04f
,	 2.05442226e+04f,  2.05601870e+04f,  2.05761545e+04f,  2.05921251e+04f
,	 2.06080989e+04f,  2.06240757e+04f,  2.06400556e+04f,  2.06560386e+04f
,	 2.06720247e+04f,  2.06880139e+04f,  2.07040062e+04f,  2.07200015e+04f
,	 2.07360000e+04f,  2.07520015e+04f,  2.07680062e+04f,  2.07840139e+04f
,	 2.08000247e+04f,  2.08160386e+04f,  2.08320555e+04f,  2.08480755e+04f
,	 2.08640987e+04f,  2.08801249e+04f,  2.08961541e+04f,  2.09121865e+04f
,	 2.09282219e+04f,  2.09442604e+04f,  2.09603019e+04f,  2.09763466e+04f
,	 2.09923943e+04f,  2.10084450e+04f,  2.10244988e+04f,  2.10405557e+04f
,	 2.10566157e+04f,  2.10726787e+04f,  2.10887448e+04f,  2.11048140e+04f
,	 2.11208862e+04f,  2.11369614e+04f,  2.11530397e+04f,  2.11691211e+04f
,	 2.11852055e+04f,  2.12012930e+04f,  2.12173836e+04f,  2.12334772e+04f
,	 2.12495738e+04f,  2.12656735e+04f,  2.12817762e+04f,  2.12978820e+04f
,	 2.13139908e+04f,  2.13301027e+04f,  2.13462176e+04f,  2.13623356e+04f
,	 2.13784566e+04f,  2.13945806e+04f,  2.14107077e+04f,  2.14268378e+04f
,	 2.14429709e+04f,  2.14591071e+04f,  2.14752463e+04f,  2.14913886e+04f
,	 2.15075339e+04f,  2.15236822e+04f,  2.15398335e+04f,  2.15559879e+04f
,	 2.15721453e+04f,  2.15883057e+04f,  2.16044692e+04f,  2.16206356e+04f
,	 2.16368051e+04f,  2.16529776e+04f,  2.16691532e+04f,  2.16853317e+04f
,	 2.17015133e+04f,  2.17176979e+04f,  2.17338855e+04f,  2.17500761e+04f
,	 2.17662698e+04f,  2.17824664e+04f,  2.17986661e+04f,  2.18148687e+04f
,	 2.18310744e+04f,  2.18472831e+04f,  2.18634948e+04f,  2.18797095e+04f
,	 2.18959272e+04f,  2.19121479e+04f,  2.19283716e+04f,  2.19445983e+04f
,	 2.19608280e+04f,  2.19770607e+04f,  2.19932964e+04f,  2.20095351e+04f
,	 2.20257768e+04f,  2.20420215e+04f,  2.20582692e+04f,  2.20745199e+04f
,	 2.20907736e+04f,  2.21070302e+04f,  2.21232899e+04f,  2.21395525e+04f
,	 2.21558182e+04f,  2.21720868e+04f,  2.21883584e+04f,  2.22046330e+04f
,	 2.22209105e+04f,  2.22371911e+04f,  2.22534746e+04f,  2.22697611e+04f
,	 2.22860506e+04f,  2.23023430e+04f,  2.23186385e+04f,  2.23349369e+04f
,	 2.23512383e+04f,  2.23675426e+04f,  2.23838500e+04f,  2.24001603e+04f
,	 2.24164735e+04f,  2.24327898e+04f,  2.24491090e+04f,  2.24654312e+04f
,	 2.24817563e+04f,  2.24980844e+04f,  2.25144155e+04f,  2.25307495e+04f
,	 2.25470865e+04f,  2.25634264e+04f,  2.25797693e+04f,  2.25961152e+04f
,	 2.26124640e+04f,  2.26288158e+04f,  2.26451705e+04f,  2.26615282e+04f
,	 2.26778889e+04f,  2.26942524e+04f,  2.27106190e+04f,  2.27269885e+04f
,	 2.27433609e+04f,  2.27597363e+04f,  2.27761146e+04f,  2.27924959e+04f
,	 2.28088801e+04f,  2.28252673e+04f,  2.28416574e+04f,  2.28580504e+04f
,	 2.28744464e+04f,  2.28908453e+04f,  2.29072472e+04f,  2.29236520e+04f
,	 2.29400597e+04f,  2.29564704e+04f,  2.29728840e+04f,  2.29893005e+04f
,	 2.30057200e+04f,  2.30221424e+04f,  2.30385677e+04f,  2.30549959e+04f
,	 2.30714271e+04f,  2.30878612e+04f,  2.31042982e+04f,  2.31207382e+04f
,	 2.31371811e+04f,  2.31536269e+04f,  2.31700756e+04f,  2.31865272e+04f
,	 2.32029818e+04f,  2.32194393e+04f,  2.32358996e+04f,  2.32523630e+04f
,	 2.32688292e+04f,  2.32852983e+04f,  2.33017704e+04f,  2.33182453e+04f
,	 2.33347232e+04f,  2.33512040e+04f,  2.33676876e+04f,  2.33841742e+04f
,	 2.34006637e+04f,  2.34171562e+04f,  2.34336515e+04f,  2.34501497e+04f
,	 2.34666508e+04f,  2.34831548e+04f,  2.34996617e+04f,  2.35161715e+04f
,	 2.35326843e+04f,  2.35491999e+04f,  2.35657184e+04f,  2.35822398e+04f
,	 2.35987641e+04f,  2.36152913e+04f,  2.36318214e+04f,  2.36483543e+04f
,	 2.36648902e+04f,  2.36814290e+04f,  2.36979706e+04f,  2.37145151e+04f
,	 2.37310625e+04f,  2.37476128e+04f,  2.37641660e+04f,  2.37807221e+04f
,	 2.37972810e+04f,  2.38138429e+04f,  2.38304076e+04f,  2.38469752e+04f
,	 2.38635456e+04f,  2.38801190e+04f,  2.38966952e+04f,  2.39132743e+04f
,	 2.39298563e+04f,  2.39464411e+04f,  2.39630288e+04f,  2.39796194e+04f
,	 2.39962129e+04f,  2.40128092e+04f,  2.40294084e+04f,  2.40460105e+04f
,	 2.40626154e+04f,  2.40792232e+04f,  2.40958338e+04f,  2.41124474e+04f
,	 2.41290637e+04f,  2.41456830e+04f,  2.41623051e+04f,  2.41789300e+04f
,	 2.41955579e+04f,  2.42121885e+04f,  2.42288221e+04f,  2.42454585e+04f
,	 2.42620977e+04f,  2.42787398e+04f,  2.42953848e+04f,  2.43120326e+04f
,	 2.43286832e+04f,  2.43453367e+04f,  2.43619931e+04f,  2.43786523e+04f
,	 2.43953143e+04f,  2.44119792e+04f,  2.44286469e+04f,  2.44453175e+04f
,	 2.44619909e+04f,  2.44786672e+04f,  2.44953463e+04f,  2.45120282e+04f
,	 2.45287130e+04f,  2.45454006e+04f,  2.45620911e+04f,  2.45787844e+04f
,	 2.45954805e+04f,  2.46121795e+04f,  2.46288812e+04f,  2.46455859e+04f
,	 2.46622933e+04f,  2.46790036e+04f,  2.46957167e+04f,  2.47124327e+04f
,	 2.47291514e+04f,  2.47458730e+04f,  2.47625975e+04f,  2.47793247e+04f
,	 2.47960548e+04f,  2.48127877e+04f,  2.48295234e+04f,  2.48462619e+04f
,	 2.48630033e+04f,  2.48797474e+04f,  2.48964944e+04f,  2.49132442e+04f
,	 2.49299969e+04f,  2.49467523e+04f,  2.49635105e+04f,  2.49802716e+04f
,	 2.49970355e+04f,  2.50138022e+04f,  2.50305717e+04f,  2.50473440e+04f
,	 2.50641191e+04f,  2.50808970e+04f,  2.50976777e+04f,  2.51144613e+04f
,	 2.51312476e+04f,  2.51480368e+04f,  2.51648287e+04f,  2.51816235e+04f
,	 2.51984210e+04f,  2.52152213e+04f,  2.52320245e+04f,  2.52488304e+04f
,	 2.52656392e+04f,  2.52824507e+04f,  2.52992650e+04f,  2.53160822e+04f
,	 2.53329021e+04f,  2.53497248e+04f,  2.53665503e+04f,  2.53833786e+04f
,	 2.54002097e+04f,  2.54170436e+04f,  2.54338802e+04f,  2.54507197e+04f
,	 2.54675619e+04f,  2.54844069e+04f,  2.55012547e+04f,  2.55181053e+04f
,	 2.55349587e+04f,  2.55518148e+04f,  2.55686737e+04f,  2.55855355e+04f
,	 2.56023999e+04f,  2.56192672e+04f,  2.56361373e+04f,  2.56530101e+04f
,	 2.56698857e+04f,  2.56867640e+04f,  2.57036452e+04f,  2.57205291e+04f
,	 2.57374158e+04f,  2.57543052e+04f,  2.57711974e+04f,  2.57880924e+04f
,	 2.58049902e+04f,  2.58218907e+04f,  2.58387940e+04f,  2.58557001e+04f
,	 2.58726089e+04f,  2.58895205e+04f,  2.59064348e+04f,  2.59233519e+04f
,	 2.59402718e+04f,  2.59571944e+04f,  2.59741198e+04f,  2.59910479e+04f
,	 2.60079788e+04f,  2.60249125e+04f,  2.60418489e+04f,  2.60587881e+04f
,	 2.60757300e+04f,  2.60926747e+04f,  2.61096221e+04f,  2.61265722e+04f
,	 2.61435252e+04f,  2.61604808e+04f,  2.61774393e+04f,  2.61944004e+04f
,	 2.62113643e+04f,  2.62283310e+04f,  2.62453004e+04f,  2.62622725e+04f
,	 2.62792474e+04f,  2.62962251e+04f,  2.63132054e+04f,  2.63301885e+04f
,	 2.63471744e+04f,  2.63641630e+04f,  2.63811543e+04f,  2.63981484e+04f
,	 2.64151451e+04f,  2.64321447e+04f,  2.64491469e+04f,  2.64661519e+04f
,	 2.64831597e+04f,  2.65001701e+04f,  2.65171833e+04f,  2.65341992e+04f
,	 2.65512179e+04f,  2.65682393e+04f,  2.65852634e+04f,  2.66022902e+04f
,	 2.66193197e+04f,  2.66363520e+04f,  2.66533870e+04f,  2.66704247e+04f
,	 2.66874652e+04f,  2.67045083e+04f,  2.67215542e+04f,  2.67386028e+04f
,	 2.67556542e+04f,  2.67727082e+04f,  2.67897649e+04f,  2.68068244e+04f
,	 2.68238866e+04f,  2.68409515e+04f,  2.68580191e+04f,  2.68750894e+04f
,	 2.68921625e+04f,  2.69092382e+04f,  2.69263167e+04f,  2.69433978e+04f
,	 2.69604817e+04f,  2.69775683e+04f,  2.69946576e+04f,  2.70117495e+04f
,	 2.70288442e+04f,  2.70459416e+04f,  2.70630417e+04f,  2.70801445e+04f
,	 2.70972500e+04f,  2.71143582e+04f,  2.71314691e+04f,  2.71485827e+04f
,	 2.71656990e+04f,  2.71828180e+04f,  2.71999397e+04f,  2.72170641e+04f
,	 2.72341911e+04f,  2.72513209e+04f,  2.72684534e+04f,  2.72855885e+04f
,	 2.73027264e+04f,  2.73198669e+04f,  2.73370101e+04f,  2.73541560e+04f
,	 2.73713046e+04f,  2.73884559e+04f,  2.74056099e+04f,  2.74227665e+04f
,	 2.74399259e+04f,  2.74570879e+04f,  2.74742526e+04f,  2.74914200e+04f
,	 2.75085900e+04f,  2.75257628e+04f,  2.75429382e+04f,  2.75601163e+04f
,	 2.75772971e+04f,  2.75944805e+04f,  2.76116667e+04f,  2.76288555e+04f
,	 2.76460470e+04f,  2.76632411e+04f,  2.76804379e+04f,  2.76976374e+04f
,	 2.77148396e+04f,  2.77320444e+04f,  2.77492519e+04f,  2.77664621e+04f
,	 2.77836749e+04f,  2.78008905e+04f,  2.78181086e+04f,  2.78353295e+04f
,	 2.78525530e+04f,  2.78697791e+04f,  2.78870079e+04f,  2.79042394e+04f
,	 2.79214736e+04f,  2.79387104e+04f,  2.79559499e+04f,  2.79731920e+04f
,	 2.79904368e+04f,  2.80076842e+04f,  2.80249343e+04f,  2.80421870e+04f
,	 2.80594424e+04f,  2.80767005e+04f,  2.80939612e+04f,  2.81112246e+04f
,	 2.81284906e+04f,  2.81457592e+04f,  2.81630306e+04f,  2.81803045e+04f
,	 2.81975811e+04f,  2.82148604e+04f,  2.82321423e+04f,  2.82494268e+04f
,	 2.82667140e+04f,  2.82840038e+04f,  2.83012963e+04f,  2.83185914e+04f
,	 2.83358892e+04f,  2.83531896e+04f,  2.83704926e+04f,  2.83877983e+04f
,	 2.84051066e+04f,  2.84224176e+04f,  2.84397311e+04f,  2.84570474e+04f
,	 2.84743662e+04f,  2.84916877e+04f,  2.85090118e+04f,  2.85263386e+04f
,	 2.85436680e+04f,  2.85610000e+04f,  2.85783346e+04f,  2.85956719e+04f
,	 2.86130118e+04f,  2.86303544e+04f,  2.86476995e+04f,  2.86650473e+04f
,	 2.86823977e+04f,  2.86997508e+04f,  2.87171064e+04f,  2.87344647e+04f
,	 2.87518256e+04f,  2.87691891e+04f,  2.87865553e+04f,  2.88039240e+04f
,	 2.88212954e+04f,  2.88386694e+04f,  2.88560460e+04f,  2.88734253e+04f
,	 2.88908071e+04f,  2.89081916e+04f,  2.89255787e+04f,  2.89429683e+04f
,	 2.89603607e+04f,  2.89777556e+04f,  2.89951531e+04f,  2.90125532e+04f
,	 2.90299560e+04f,  2.90473613e+04f,  2.90647693e+04f,  2.90821799e+04f
,	 2.90995930e+04f,  2.91170088e+04f,  2.91344272e+04f,  2.91518482e+04f
,	 2.91692718e+04f,  2.91866980e+04f,  2.92041268e+04f,  2.92215582e+04f
,	 2.92389922e+04f,  2.92564288e+04f,  2.92738680e+04f,  2.92913098e+04f
,	 2.93087541e+04f,  2.93262011e+04f,  2.93436507e+04f,  2.93611029e+04f
,	 2.93785576e+04f,  2.93960150e+04f,  2.94134750e+04f,  2.94309375e+04f
,	 2.94484026e+04f,  2.94658704e+04f,  2.94833407e+04f,  2.95008136e+04f
,	 2.95182891e+04f,  2.95357672e+04f,  2.95532478e+04f,  2.95707311e+04f
,	 2.95882169e+04f,  2.96057053e+04f,  2.96231963e+04f,  2.96406899e+04f
,	 2.96581861e+04f,  2.96756848e+04f,  2.96931861e+04f,  2.97106900e+04f
,	 2.97281965e+04f,  2.97457056e+04f,  2.97632172e+04f,  2.97807314e+04f
,	 2.97982482e+04f,  2.98157676e+04f,  2.98332895e+04f,  2.98508140e+04f
,	 2.98683411e+04f,  2.98858708e+04f,  2.99034030e+04f,  2.99209378e+04f
,	 2.99384752e+04f,  2.99560151e+04f,  2.99735576e+04f,  2.99911027e+04f
,	 3.00086503e+04f,  3.00262005e+04f,  3.00437533e+04f,  3.00613086e+04f
,	 3.00788665e+04f,  3.00964270e+04f,  3.01139900e+04f,  3.01315555e+04f
,	 3.01491237e+04f,  3.01666944e+04f,  3.01842676e+04f,  3.02018435e+04f
,	 3.02194218e+04f,  3.02370028e+04f,  3.02545863e+04f,  3.02721723e+04f
,	 3.02897609e+04f,  3.03073520e+04f,  3.03249457e+04f,  3.03425420e+04f
,	 3.03601408e+04f,  3.03777422e+04f,  3.03953461e+04f,  3.04129525e+04f
,	 3.04305615e+04f,  3.04481731e+04f,  3.04657872e+04f,  3.04834038e+04f
,	 3.05010230e+04f,  3.05186448e+04f,  3.05362690e+04f,  3.05538959e+04f
,	 3.05715252e+04f,  3.05891571e+04f,  3.06067916e+04f,  3.06244286e+04f
,	 3.06420681e+04f,  3.06597102e+04f,  3.06773548e+04f,  3.06950019e+04f
,	 3.07126516e+04f,  3.07303038e+04f,  3.07479586e+04f,  3.07656159e+04f
,	 3.07832757e+04f,  3.08009380e+04f,  3.08186029e+04f,  3.08362703e+04f
,	 3.08539403e+04f,  3.08716128e+04f,  3.08892878e+04f,  3.09069653e+04f
,	 3.09246454e+04f,  3.09423280e+04f,  3.09600131e+04f,  3.09777007e+04f
,	 3.09953909e+04f,  3.10130836e+04f,  3.10307788e+04f,  3.10484766e+04f
,	 3.10661768e+04f,  3.10838796e+04f,  3.11015849e+04f,  3.11192927e+04f
,	 3.11370031e+04f,  3.11547160e+04f,  3.11724313e+04f,  3.11901492e+04f
,	 3.12078697e+04f,  3.12255926e+04f,  3.12433180e+04f,  3.12610460e+04f
,	 3.12787765e+04f,  3.12965095e+04f,  3.13142450e+04f,  3.13319830e+04f
,	 3.13497235e+04f,  3.13674665e+04f,  3.13852121e+04f,  3.14029601e+04f
,	 3.14207107e+04f,  3.14384638e+04f,  3.14562193e+04f,  3.14739774e+04f
,	 3.14917380e+04f,  3.15095011e+04f,  3.15272667e+04f,  3.15450348e+04f
,	 3.15628054e+04f,  3.15805785e+04f,  3.15983541e+04f,  3.16161322e+04f
,	 3.16339128e+04f,  3.16516959e+04f,  3.16694815e+04f,  3.16872696e+04f
,	 3.17050602e+04f,  3.17228533e+04f,  3.17406488e+04f,  3.17584469e+04f
,	 3.17762475e+04f,  3.17940506e+04f,  3.18118561e+04f,  3.18296642e+04f
,	 3.18474747e+04f,  3.18652877e+04f,  3.18831033e+04f,  3.19009213e+04f
,	 3.19187418e+04f,  3.19365648e+04f,  3.19543902e+04f,  3.19722182e+04f
,	 3.19900486e+04f,  3.20078816e+04f,  3.20257170e+04f,  3.20435549e+04f
,	 3.20613953e+04f,  3.20792381e+04f,  3.20970835e+04f,  3.21149313e+04f
,	 3.21327816e+04f,  3.21506344e+04f,  3.21684897e+04f,  3.21863474e+04f
,	 3.22042076e+04f,  3.22220703e+04f,  3.22399355e+04f,  3.22578031e+04f
,	 3.22756732e+04f,  3.22935458e+04f,  3.23114209e+04f,  3.23292985e+04f
,	 3.23471785e+04f,  3.23650609e+04f,  3.23829459e+04f,  3.24008333e+04f
,	 3.24187232e+04f,  3.24366156e+04f,  3.24545104e+04f,  3.24724077e+04f
,	 3.24903075e+04f,  3.25082097e+04f,  3.25261144e+04f,  3.25440216e+04f
,	 3.25619312e+04f,  3.25798433e+04f,  3.25977578e+04f,  3.26156748e+04f
,	 3.26335943e+04f,  3.26515162e+04f,  3.26694406e+04f,  3.26873675e+04f
,	 3.27052968e+04f,  3.27232285e+04f,  3.27411627e+04f,  3.27590994e+04f
,	 3.27770386e+04f,  3.27949801e+04f,  3.28129242e+04f,  3.28308707e+04f
,	 3.28488196e+04f,  3.28667710e+04f,  3.28847249e+04f,  3.29026812e+04f
,	 3.29206399e+04f,  3.29386011e+04f,  3.29565648e+04f,  3.29745309e+04f
,	 3.29924994e+04f,  3.30104704e+04f,  3.30284439e+04f,  3.30464198e+04f
,	 3.30643981e+04f,  3.30823789e+04f,  3.31003621e+04f,  3.31183477e+04f
,	 3.31363358e+04f,  3.31543264e+04f,  3.31723194e+04f,  3.31903148e+04f
,	 3.32083127e+04f,  3.32263130e+04f,  3.32443157e+04f,  3.32623209e+04f
,	 3.32803285e+04f,  3.32983386e+04f,  3.33163511e+04f,  3.33343660e+04f
,	 3.33523833e+04f,  3.33704031e+04f,  3.33884254e+04f,  3.34064500e+04f
,	 3.34244771e+04f,  3.34425066e+04f,  3.34605386e+04f,  3.34785730e+04f
,	 3.34966098e+04f,  3.35146490e+04f,  3.35326907e+04f,  3.35507348e+04f
,	 3.35687813e+04f,  3.35868302e+04f,  3.36048816e+04f,  3.36229354e+04f
,	 3.36409916e+04f,  3.36590503e+04f,  3.36771113e+04f,  3.36951748e+04f
,	 3.37132407e+04f,  3.37313090e+04f,  3.37493798e+04f,  3.37674529e+04f
,	 3.37855285e+04f,  3.38036065e+04f,  3.38216870e+04f,  3.38397698e+04f
,	 3.38578550e+04f,  3.38759427e+04f,  3.38940328e+04f,  3.39121253e+04f
,	 3.39302202e+04f,  3.39483175e+04f,  3.39664173e+04f,  3.39845194e+04f
,	 3.40026240e+04f,  3.40207309e+04f,  3.40388403e+04f,  3.40569521e+04f
,	 3.40750663e+04f,  3.40931829e+04f,  3.41113019e+04f,  3.41294233e+04f
,	 3.41475472e+04f,  3.41656734e+04f,  3.41838020e+04f,  3.42019330e+04f
,	 3.42200665e+04f,  3.42382023e+04f,  3.42563406e+04f,  3.42744812e+04f
,	 3.42926243e+04f,  3.43107697e+04f,  3.43289176e+04f,  3.43470678e+04f
,	 3.43652204e+04f,  3.43833755e+04f,  3.44015329e+04f,  3.44196927e+04f
,	 3.44378550e+04f,  3.44560196e+04f,  3.44741866e+04f,  3.44923560e+04f
,	 3.45105278e+04f,  3.45287020e+04f,  3.45468786e+04f,  3.45650576e+04f
,	 3.45832390e+04f,  3.46014227e+04f,  3.46196089e+04f,  3.46377974e+04f
,	 3.46559883e+04f,  3.46741817e+04f,  3.46923774e+04f,  3.47105754e+04f
,	 3.47287759e+04f,  3.47469788e+04f,  3.47651840e+04f,  3.47833916e+04f
,	 3.48016016e+04f,  3.48198140e+04f,  3.48380288e+04f,  3.48562460e+04f
,	 3.48744655e+04f,  3.48926874e+04f,  3.49109117e+04f,  3.49291384e+04f
,	 3.49473674e+04f,  3.49655988e+04f,  3.49838327e+04f,  3.50020688e+04f
,	 3.50203074e+04f,  3.50385483e+04f,  3.50567916e+04f,  3.50750373e+04f
,	 3.50932854e+04f,  3.51115358e+04f,  3.51297886e+04f,  3.51480437e+04f
,	 3.51663013e+04f,  3.51845612e+04f,  3.52028235e+04f,  3.52210881e+04f
,	 3.52393551e+04f,  3.52576245e+04f,  3.52758963e+04f,  3.52941704e+04f
,	 3.53124469e+04f,  3.53307257e+04f,  3.53490069e+04f,  3.53672905e+04f
,	 3.53855764e+04f,  3.54038647e+04f,  3.54221554e+04f,  3.54404484e+04f
,	 3.54587438e+04f,  3.54770415e+04f,  3.54953417e+04f,  3.55136441e+04f
,	 3.55319489e+04f,  3.55502561e+04f,  3.55685657e+04f,  3.55868776e+04f
,	 3.56051918e+04f,  3.56235084e+04f,  3.56418274e+04f,  3.56601487e+04f
,	 3.56784723e+04f,  3.56967984e+04f,  3.57151267e+04f,  3.57334575e+04f
,	 3.57517905e+04f,  3.57701260e+04f,  3.57884637e+04f,  3.58068039e+04f
,	 3.58251463e+04f,  3.58434912e+04f,  3.58618383e+04f,  3.58801879e+04f
,	 3.58985397e+04f,  3.59168939e+04f,  3.59352505e+04f,  3.59536094e+04f
,	 3.59719706e+04f,  3.59903342e+04f,  3.60087001e+04f,  3.60270684e+04f
,	 3.60454390e+04f,  3.60638120e+04f,  3.60821873e+04f,  3.61005649e+04f
,	 3.61189449e+04f,  3.61373272e+04f,  3.61557118e+04f,  3.61740988e+04f
,	 3.61924882e+04f,  3.62108798e+04f,  3.62292738e+04f,  3.62476701e+04f
,	 3.62660688e+04f,  3.62844698e+04f,  3.63028731e+04f,  3.63212788e+04f
,	 3.63396868e+04f,  3.63580971e+04f,  3.63765098e+04f,  3.63949248e+04f
,	 3.64133421e+04f,  3.64317617e+04f,  3.64501837e+04f,  3.64686080e+04f
,	 3.64870347e+04f,  3.65054636e+04f,  3.65238949e+04f,  3.65423285e+04f
,	 3.65607644e+04f,  3.65792027e+04f,  3.65976433e+04f,  3.66160862e+04f
,	 3.66345314e+04f,  3.66529790e+04f,  3.66714288e+04f,  3.66898810e+04f
,	 3.67083356e+04f,  3.67267924e+04f,  3.67452515e+04f,  3.67637130e+04f
,	 3.67821768e+04f,  3.68006429e+04f,  3.68191113e+04f,  3.68375821e+04f
,	 3.68560551e+04f,  3.68745305e+04f,  3.68930082e+04f,  3.69114882e+04f
,	 3.69299705e+04f,  3.69484551e+04f,  3.69669421e+04f,  3.69854313e+04f
,	 3.70039229e+04f,  3.70224167e+04f,  3.70409129e+04f,  3.70594114e+04f
,	 3.70779122e+04f,  3.70964153e+04f,  3.71149207e+04f,  3.71334284e+04f
,	 3.71519385e+04f,  3.71704508e+04f,  3.71889654e+04f,  3.72074824e+04f
,	 3.72260016e+04f,  3.72445232e+04f,  3.72630470e+04f,  3.72815732e+04f
,	 3.73001016e+04f,  3.73186324e+04f,  3.73371655e+04f,  3.73557008e+04f
,	 3.73742385e+04f,  3.73927784e+04f,  3.74113207e+04f,  3.74298653e+04f
,	 3.74484121e+04f,  3.74669613e+04f,  3.74855127e+04f,  3.75040664e+04f
,	 3.75226225e+04f,  3.75411808e+04f,  3.75597414e+04f,  3.75783043e+04f
,	 3.75968696e+04f,  3.76154371e+04f,  3.76340068e+04f,  3.76525789e+04f
,	 3.76711533e+04f,  3.76897300e+04f,  3.77083089e+04f,  3.77268902e+04f
,	 3.77454737e+04f,  3.77640595e+04f,  3.77826476e+04f,  3.78012380e+04f
,	 3.78198307e+04f,  3.78384257e+04f,  3.78570229e+04f,  3.78756224e+04f
,	 3.78942242e+04f,  3.79128283e+04f,  3.79314347e+04f,  3.79500434e+04f
,	 3.79686543e+04f,  3.79872676e+04f,  3.80058831e+04f,  3.80245009e+04f
,	 3.80431209e+04f,  3.80617433e+04f,  3.80803679e+04f,  3.80989948e+04f
,	 3.81176240e+04f,  3.81362554e+04f,  3.81548891e+04f,  3.81735251e+04f
,	 3.81921634e+04f,  3.82108040e+04f,  3.82294468e+04f,  3.82480919e+04f
,	 3.82667393e+04f,  3.82853889e+04f,  3.83040408e+04f,  3.83226950e+04f
,	 3.83413515e+04f,  3.83600102e+04f,  3.83786712e+04f,  3.83973345e+04f
,	 3.84160000e+04f,  3.84346678e+04f,  3.84533379e+04f,  3.84720102e+04f
,	 3.84906848e+04f,  3.85093617e+04f,  3.85280408e+04f,  3.85467222e+04f
,	 3.85654058e+04f,  3.85840918e+04f,  3.86027800e+04f,  3.86214704e+04f
,	 3.86401631e+04f,  3.86588581e+04f,  3.86775553e+04f,  3.86962548e+04f
,	 3.87149565e+04f,  3.87336605e+04f,  3.87523668e+04f,  3.87710753e+04f
,	 3.87897861e+04f,  3.88084992e+04f,  3.88272144e+04f,  3.88459320e+04f
,	 3.88646518e+04f,  3.88833739e+04f,  3.89020982e+04f,  3.89208247e+04f
,	 3.89395535e+04f,  3.89582846e+04f,  3.89770179e+04f,  3.89957535e+04f
,	 3.90144913e+04f,  3.90332314e+04f,  3.90519737e+04f,  3.90707183e+04f
,	 3.90894651e+04f,  3.91082142e+04f,  3.91269655e+04f,  3.91457191e+04f
,	 3.91644749e+04f,  3.91832329e+04f,  3.92019932e+04f,  3.92207558e+04f
,	 3.92395206e+04f,  3.92582876e+04f,  3.92770569e+04f,  3.92958284e+04f
,	 3.93146022e+04f,  3.93333782e+04f,  3.93521564e+04f,  3.93709369e+04f
,	 3.93897196e+04f,  3.94085046e+04f,  3.94272918e+04f,  3.94460812e+04f
,	 3.94648729e+04f,  3.94836668e+04f,  3.95024630e+04f,  3.95212614e+04f
,	 3.95400620e+04f,  3.95588648e+04f,  3.95776699e+04f,  3.95964773e+04f
,	 3.96152868e+04f,  3.96340986e+04f,  3.96529126e+04f,  3.96717289e+04f
,	 3.96905474e+04f,  3.97093681e+04f,  3.97281911e+04f,  3.97470162e+04f
,	 3.97658436e+04f,  3.97846733e+04f,  3.98035052e+04f,  3.98223392e+04f
,	 3.98411756e+04f,  3.98600141e+04f,  3.98788549e+04f,  3.98976979e+04f
,	 3.99165431e+04f,  3.99353906e+04f,  3.99542402e+04f,  3.99730921e+04f
,	 3.99919463e+04f,  4.00108026e+04f,  4.00296612e+04f,  4.00485220e+04f
,	 4.00673850e+04f,  4.00862502e+04f,  4.01051176e+04f,  4.01239873e+04f
,	 4.01428592e+04f,  4.01617333e+04f,  4.01806096e+04f,  4.01994882e+04f
,	 4.02183689e+04f,  4.02372519e+04f,  4.02561371e+04f,  4.02750245e+04f
,	 4.02939141e+04f,  4.03128059e+04f,  4.03317000e+04f,  4.03505962e+04f
,	 4.03694947e+04f,  4.03883954e+04f,  4.04072983e+04f,  4.04262034e+04f
,	 4.04451107e+04f,  4.04640202e+04f,  4.04829319e+04f,  4.05018459e+04f
,	 4.05207620e+04f,  4.05396804e+04f,  4.05586010e+04f,  4.05775237e+04f
,	 4.05964487e+04f,  4.06153759e+04f,  4.06343053e+04f,  4.06532369e+04f
,	 4.06721707e+04f,  4.06911067e+04f,  4.07100449e+04f,  4.07289853e+04f
,	 4.07479279e+04f,  4.07668727e+04f,  4.07858198e+04f,  4.08047690e+04f
,	 4.08237204e+04f,  4.08426740e+04f,  4.08616298e+04f,  4.08805878e+04f
,	 4.08995480e+04f,  4.09185105e+04f,  4.09374751e+04f,  4.09564419e+04f
,	 4.09754109e+04f,  4.09943821e+04f,  4.10133555e+04f,  4.10323310e+04f
,	 4.10513088e+04f,  4.10702888e+04f,  4.10892710e+04f,  4.11082553e+04f
,	 4.11272419e+04f,  4.11462306e+04f,  4.11652215e+04f,  4.11842147e+04f
,	 4.12032100e+04f,  4.12222075e+04f,  4.12412072e+04f,  4.12602091e+04f
,	 4.12792131e+04f,  4.12982194e+04f,  4.13172278e+04f,  4.13362385e+04f
,	 4.13552513e+04f,  4.13742663e+04f,  4.13932835e+04f,  4.14123028e+04f
,	 4.14313244e+04f,  4.14503481e+04f,  4.14693740e+04f,  4.14884021e+04f
,	 4.15074324e+04f,  4.15264649e+04f,  4.15454995e+04f,  4.15645364e+04f
,	 4.15835754e+04f,  4.16026166e+04f,  4.16216599e+04f,  4.16407055e+04f
,	 4.16597532e+04f,  4.16788031e+04f,  4.16978552e+04f,  4.17169094e+04f
,	 4.17359659e+04f,  4.17550245e+04f,  4.17740853e+04f,  4.17931482e+04f
,	 4.18122133e+04f,  4.18312807e+04f,  4.18503501e+04f,  4.18694218e+04f
,	 4.18884956e+04f,  4.19075716e+04f,  4.19266498e+04f,  4.19457301e+04f
,	 4.19648126e+04f,  4.19838973e+04f,  4.20029841e+04f,  4.20220731e+04f
,	 4.20411643e+04f,  4.20602576e+04f,  4.20793532e+04f,  4.20984508e+04f
,	 4.21175507e+04f,  4.21366527e+04f,  4.21557569e+04f,  4.21748632e+04f
,	 4.21939717e+04f,  4.22130824e+04f,  4.22321952e+04f,  4.22513102e+04f
,	 4.22704274e+04f,  4.22895467e+04f,  4.23086682e+04f,  4.23277918e+04f
,	 4.23469176e+04f,  4.23660456e+04f,  4.23851757e+04f,  4.24043080e+04f
,	 4.24234424e+04f,  4.24425790e+04f,  4.24617178e+04f,  4.24808587e+04f
,	 4.25000018e+04f,  4.25191470e+04f,  4.25382944e+04f,  4.25574439e+04f
,	 4.25765956e+04f,  4.25957494e+04f,  4.26149054e+04f,  4.26340636e+04f
,	 4.26532239e+04f,  4.26723863e+04f,  4.26915509e+04f,  4.27107177e+04f
,	 4.27298866e+04f,  4.27490576e+04f,  4.27682308e+04f,  4.27874062e+04f
,	 4.28065837e+04f,  4.28257634e+04f,  4.28449452e+04f,  4.28641291e+04f
,	 4.28833152e+04f,  4.29025034e+04f,  4.29216938e+04f,  4.29408863e+04f
,	 4.29600810e+04f,  4.29792778e+04f,  4.29984768e+04f,  4.30176779e+04f
,	 4.30368812e+04f,  4.30560865e+04f,  4.30752941e+04f,  4.30945038e+04f
,	 4.31137156e+04f,  4.31329295e+04f,  4.31521456e+04f,  4.31713639e+04f
,	 4.31905842e+04f,  4.32098067e+04f,  4.32290314e+04f,  4.32482582e+04f
,	 4.32674871e+04f,  4.32867182e+04f,  4.33059514e+04f,  4.33251867e+04f
,	 4.33444242e+04f,  4.33636638e+04f,  4.33829055e+04f,  4.34021494e+04f
,	 4.34213954e+04f,  4.34406435e+04f,  4.34598938e+04f,  4.34791462e+04f
,	 4.34984007e+04f,  4.35176574e+04f,  4.35369162e+04f,  4.35561771e+04f
,	 4.35754402e+04f,  4.35947054e+04f,  4.36139727e+04f,  4.36332421e+04f
,	 4.36525137e+04f,  4.36717874e+04f,  4.36910632e+04f,  4.37103412e+04f
,	 4.37296212e+04f,  4.37489034e+04f,  4.37681878e+04f,  4.37874742e+04f
,	 4.38067628e+04f,  4.38260535e+04f,  4.38453463e+04f,  4.38646413e+04f
,	 4.38839383e+04f,  4.39032375e+04f,  4.39225388e+04f,  4.39418422e+04f
,	 4.39611478e+04f,  4.39804555e+04f,  4.39997652e+04f,  4.40190772e+04f
,	 4.40383912e+04f,  4.40577073e+04f,  4.40770256e+04f,  4.40963460e+04f
,	 4.41156684e+04f,  4.41349931e+04f,  4.41543198e+04f,  4.41736486e+04f
,	 4.41929796e+04f,  4.42123126e+04f,  4.42316478e+04f,  4.42509851e+04f
,	 4.42703245e+04f,  4.42896661e+04f,  4.43090097e+04f,  4.43283554e+04f
,	 4.43477033e+04f,  4.43670533e+04f,  4.43864053e+04f,  4.44057595e+04f
,	 4.44251158e+04f,  4.44444742e+04f,  4.44638347e+04f,  4.44831973e+04f
,	 4.45025621e+04f,  4.45219289e+04f,  4.45412978e+04f,  4.45606689e+04f
,	 4.45800420e+04f,  4.45994173e+04f,  4.46187947e+04f,  4.46381741e+04f
,	 4.46575557e+04f,  4.46769394e+04f,  4.46963251e+04f,  4.47157130e+04f
,	 4.47351030e+04f,  4.47544951e+04f,  4.47738892e+04f,  4.47932855e+04f
,	 4.48126839e+04f,  4.48320844e+04f,  4.48514870e+04f,  4.48708916e+04f
,	 4.48902984e+04f,  4.49097073e+04f,  4.49291183e+04f,  4.49485313e+04f
,	 4.49679465e+04f,  4.49873638e+04f,  4.50067831e+04f,  4.50262046e+04f
,	 4.50456281e+04f,  4.50650537e+04f,  4.50844815e+04f,  4.51039113e+04f
,	 4.51233432e+04f,  4.51427772e+04f,  4.51622133e+04f,  4.51816515e+04f
,	 4.52010918e+04f,  4.52205342e+04f,  4.52399787e+04f,  4.52594252e+04f
,	 4.52788738e+04f,  4.52983246e+04f,  4.53177774e+04f,  4.53372323e+04f
,	 4.53566893e+04f,  4.53761484e+04f,  4.53956096e+04f,  4.54150728e+04f
,	 4.54345382e+04f,  4.54540056e+04f,  4.54734751e+04f,  4.54929467e+04f
,	 4.55124204e+04f,  4.55318961e+04f,  4.55513740e+04f,  4.55708539e+04f
,	 4.55903359e+04f,  4.56098200e+04f,  4.56293062e+04f,  4.56487944e+04f
,	 4.56682847e+04f,  4.56877772e+04f,  4.57072717e+04f,  4.57267682e+04f
,	 4.57462669e+04f,  4.57657676e+04f,  4.57852704e+04f,  4.58047753e+04f
,	 4.58242822e+04f,  4.58437913e+04f,  4.58633024e+04f,  4.58828156e+04f
,	 4.59023308e+04f,  4.59218482e+04f,  4.59413676e+04f,  4.59608891e+04f
,	 4.59804126e+04f,  4.59999382e+04f,  4.60194659e+04f,  4.60389957e+04f
,	 4.60585275e+04f,  4.60780615e+04f,  4.60975974e+04f,  4.61171355e+04f
,	 4.61366756e+04f,  4.61562178e+04f,  4.61757621e+04f,  4.61953084e+04f
,	 4.62148568e+04f,  4.62344073e+04f,  4.62539598e+04f,  4.62735144e+04f
,	 4.62930711e+04f,  4.63126298e+04f,  4.63321906e+04f,  4.63517535e+04f
,	 4.63713184e+04f,  4.63908854e+04f,  4.64104544e+04f,  4.64300255e+04f
,	 4.64495987e+04f,  4.64691740e+04f,  4.64887513e+04f,  4.65083306e+04f
,	 4.65279120e+04f,  4.65474955e+04f,  4.65670811e+04f,  4.65866687e+04f
,	 4.66062583e+04f,  4.66258501e+04f,  4.66454438e+04f,  4.66650397e+04f
,	 4.66846376e+04f,  4.67042375e+04f,  4.67238395e+04f,  4.67434436e+04f
,	 4.67630497e+04f,  4.67826579e+04f,  4.68022681e+04f,  4.68218804e+04f
,	 4.68414948e+04f,  4.68611112e+04f,  4.68807296e+04f,  4.69003501e+04f
,	 4.69199727e+04f,  4.69395973e+04f,  4.69592239e+04f,  4.69788526e+04f
,	 4.69984834e+04f,  4.70181162e+04f,  4.70377510e+04f,  4.70573879e+04f
,	 4.70770269e+04f,  4.70966679e+04f,  4.71163109e+04f,  4.71359560e+04f
,	 4.71556032e+04f,  4.71752524e+04f,  4.71949036e+04f,  4.72145569e+04f
,	 4.72342122e+04f,  4.72538696e+04f,  4.72735290e+04f,  4.72931905e+04f
,	 4.73128540e+04f,  4.73325195e+04f,  4.73521871e+04f,  4.73718568e+04f
,	 4.73915284e+04f,  4.74112022e+04f,  4.74308779e+04f,  4.74505557e+04f
,	 4.74702356e+04f,  4.74899174e+04f,  4.75096014e+04f,  4.75292873e+04f
,	 4.75489753e+04f,  4.75686653e+04f,  4.75883574e+04f,  4.76080515e+04f
,	 4.76277477e+04f,  4.76474459e+04f,  4.76671461e+04f,  4.76868483e+04f
,	 4.77065526e+04f,  4.77262590e+04f,  4.77459673e+04f,  4.77656777e+04f
,	 4.77853901e+04f,  4.78051046e+04f,  4.78248211e+04f,  4.78445396e+04f
,	 4.78642602e+04f,  4.78839828e+04f,  4.79037074e+04f,  4.79234340e+04f
,	 4.79431627e+04f,  4.79628934e+04f,  4.79826262e+04f,  4.80023609e+04f
,	 4.80220977e+04f,  4.80418366e+04f,  4.80615774e+04f,  4.80813203e+04f
,	 4.81010652e+04f,  4.81208122e+04f,  4.81405611e+04f,  4.81603121e+04f
,	 4.81800651e+04f,  4.81998201e+04f,  4.82195772e+04f,  4.82393363e+04f
,	 4.82590974e+04f,  4.82788605e+04f,  4.82986257e+04f,  4.83183929e+04f
,	 4.83381621e+04f,  4.83579333e+04f,  4.83777065e+04f,  4.83974818e+04f
,	 4.84172591e+04f,  4.84370384e+04f,  4.84568197e+04f,  4.84766030e+04f
,	 4.84963884e+04f,  4.85161758e+04f,  4.85359652e+04f,  4.85557566e+04f
,	 4.85755500e+04f,  4.85953454e+04f,  4.86151429e+04f,  4.86349424e+04f
,	 4.86547439e+04f,  4.86745474e+04f,  4.86943529e+04f,  4.87141604e+04f
,	 4.87339700e+04f,  4.87537816e+04f,  4.87735951e+04f,  4.87934107e+04f
,	 4.88132283e+04f,  4.88330479e+04f,  4.88528696e+04f,  4.88726932e+04f
,	 4.88925188e+04f,  4.89123465e+04f,  4.89321762e+04f,  4.89520078e+04f
,	 4.89718415e+04f,  4.89916772e+04f,  4.90115149e+04f,  4.90313546e+04f
,	 4.90511963e+04f,  4.90710401e+04f,  4.90908858e+04f,  4.91107335e+04f
,	 4.91305832e+04f,  4.91504350e+04f,  4.91702887e+04f,  4.91901445e+04f
,	 4.92100022e+04f,  4.92298620e+04f,  4.92497238e+04f,  4.92695875e+04f
,	 4.92894533e+04f,  4.93093211e+04f,  4.93291908e+04f,  4.93490626e+04f
,	 4.93689364e+04f,  4.93888122e+04f,  4.94086899e+04f,  4.94285697e+04f
,	 4.94484515e+04f,  4.94683352e+04f,  4.94882210e+04f,  4.95081088e+04f
,	 4.95279985e+04f,  4.95478903e+04f,  4.95677841e+04f,  4.95876798e+04f
,	 4.96075776e+04f,  4.96274773e+04f,  4.96473791e+04f,  4.96672828e+04f
,	 4.96871885e+04f,  4.97070962e+04f,  4.97270060e+04f,  4.97469177e+04f
,	 4.97668314e+04f,  4.97867471e+04f,  4.98066648e+04f,  4.98265844e+04f
,	 4.98465061e+04f,  4.98664298e+04f,  4.98863554e+04f,  4.99062830e+04f
,	 4.99262127e+04f,  4.99461443e+04f,  4.99660779e+04f,  4.99860135e+04f
,	 5.00059511e+04f,  5.00258907e+04f,  5.00458322e+04f,  5.00657758e+04f
,	 5.00857213e+04f,  5.01056688e+04f,  5.01256183e+04f,  5.01455698e+04f
,	 5.01655233e+04f,  5.01854787e+04f,  5.02054362e+04f,  5.02253956e+04f
,	 5.02453570e+04f,  5.02653204e+04f,  5.02852858e+04f,  5.03052531e+04f
,	 5.03252224e+04f,  5.03451938e+04f,  5.03651671e+04f,  5.03851423e+04f
,	 5.04051196e+04f,  5.04250988e+04f,  5.04450800e+04f,  5.04650632e+04f
,	 5.04850484e+04f,  5.05050356e+04f,  5.05250247e+04f,  5.05450158e+04f
,	 5.05650089e+04f,  5.05850040e+04f,  5.06050010e+04f,  5.06250000e+04f
,	 5.06450010e+04f,  5.06650040e+04f,  5.06850089e+04f,  5.07050158e+04f
,	 5.07250247e+04f,  5.07450355e+04f,  5.07650484e+04f,  5.07850632e+04f
,	 5.08050800e+04f,  5.08250987e+04f,  5.08451194e+04f,  5.08651421e+04f
,	 5.08851668e+04f,  5.09051934e+04f,  5.09252220e+04f,  5.09452526e+04f
,	 5.09652851e+04f,  5.09853196e+04f,  5.10053561e+04f,  5.10253945e+04f
,	 5.10454350e+04f,  5.10654773e+04f,  5.10855217e+04f,  5.11055680e+04f
,	 5.11256163e+04f,  5.11456665e+04f,  5.11657187e+04f,  5.11857729e+04f
,	 5.12058290e+04f,  5.12258871e+04f,  5.12459472e+04f,  5.12660092e+04f
,	 5.12860732e+04f,  5.13061392e+04f,  5.13262071e+04f,  5.13462770e+04f
,	 5.13663488e+04f,  5.13864226e+04f,  5.14064984e+04f,  5.14265761e+04f
,	 5.14466558e+04f,  5.14667374e+04f,  5.14868210e+04f,  5.15069066e+04f
,	 5.15269941e+04f,  5.15470836e+04f,  5.15671750e+04f,  5.15872684e+04f
,	 5.16073638e+04f,  5.16274611e+04f,  5.16475603e+04f,  5.16676615e+04f
,	 5.16877647e+04f,  5.17078698e+04f,  5.17279769e+04f,  5.17480859e+04f
,	 5.17681969e+04f,  5.17883099e+04f,  5.18084248e+04f,  5.18285416e+04f
,	 5.18486604e+04f,  5.18687812e+04f,  5.18889039e+04f,  5.19090285e+04f
,	 5.19291551e+04f,  5.19492837e+04f,  5.19694142e+04f,  5.19895466e+04f
,	 5.20096810e+04f,  5.20298174e+04f,  5.20499557e+04f,  5.20700959e+04f
,	 5.20902381e+04f,  5.21103823e+04f,  5.21305284e+04f,  5.21506764e+04f
,	 5.21708264e+04f,  5.21909783e+04f,  5.22111322e+04f,  5.22312880e+04f
,	 5.22514458e+04f,  5.22716055e+04f,  5.22917671e+04f,  5.23119307e+04f
,	 5.23320963e+04f,  5.23522638e+04f,  5.23724332e+04f,  5.23926046e+04f
,	 5.24127779e+04f,  5.24329531e+04f,  5.24531303e+04f,  5.24733094e+04f
,	 5.24934905e+04f,  5.25136735e+04f,  5.25338585e+04f,  5.25540454e+04f
,	 5.25742342e+04f,  5.25944250e+04f,  5.26146177e+04f,  5.26348123e+04f
,	 5.26550089e+04f,  5.26752074e+04f,  5.26954079e+04f,  5.27156102e+04f
,	 5.27358146e+04f,  5.27560208e+04f,  5.27762290e+04f,  5.27964392e+04f
,	 5.28166512e+04f,  5.28368652e+04f,  5.28570811e+04f,  5.28772990e+04f
,	 5.28975188e+04f,  5.29177405e+04f,  5.29379642e+04f,  5.29581898e+04f
,	 5.29784173e+04f,  5.29986468e+04f,  5.30188782e+04f,  5.30391115e+04f
,	 5.30593467e+04f,  5.30795839e+04f,  5.30998230e+04f,  5.31200640e+04f
,	 5.31403070e+04f,  5.31605519e+04f,  5.31807987e+04f,  5.32010475e+04f
,	 5.32212981e+04f,  5.32415507e+04f,  5.32618053e+04f,  5.32820617e+04f
,	 5.33023201e+04f,  5.33225804e+04f,  5.33428426e+04f,  5.33631068e+04f
,	 5.33833728e+04f,  5.34036408e+04f,  5.34239108e+04f,  5.34441826e+04f
,	 5.34644564e+04f,  5.34847321e+04f,  5.35050097e+04f,  5.35252892e+04f
,	 5.35455706e+04f,  5.35658540e+04f,  5.35861393e+04f,  5.36064265e+04f
,	 5.36267157e+04f,  5.36470067e+04f,  5.36672997e+04f,  5.36875946e+04f
,	 5.37078914e+04f,  5.37281901e+04f,  5.37484908e+04f,  5.37687933e+04f
,	 5.37890978e+04f,  5.38094042e+04f,  5.38297125e+04f,  5.38500227e+04f
,	 5.38703349e+04f,  5.38906489e+04f,  5.39109649e+04f,  5.39312828e+04f
,	 5.39516026e+04f,  5.39719243e+04f,  5.39922479e+04f,  5.40125734e+04f
,	 5.40329009e+04f,  5.40532302e+04f,  5.40735615e+04f,  5.40938947e+04f
,	 5.41142298e+04f,  5.41345668e+04f,  5.41549057e+04f,  5.41752465e+04f
,	 5.41955893e+04f,  5.42159339e+04f,  5.42362805e+04f,  5.42566289e+04f
,	 5.42769793e+04f,  5.42973316e+04f,  5.43176858e+04f,  5.43380419e+04f
,	 5.43583999e+04f,  5.43787598e+04f,  5.43991216e+04f,  5.44194853e+04f
,	 5.44398509e+04f,  5.44602184e+04f,  5.44805879e+04f,  5.45009592e+04f
,	 5.45213324e+04f,  5.45417076e+04f,  5.45620846e+04f,  5.45824636e+04f
,	 5.46028444e+04f,  5.46232272e+04f,  5.46436118e+04f,  5.46639984e+04f
,	 5.46843868e+04f,  5.47047772e+04f,  5.47251694e+04f,  5.47455636e+04f
,	 5.47659597e+04f,  5.47863576e+04f,  5.48067575e+04f,  5.48271592e+04f
,	 5.48475629e+04f,  5.48679684e+04f,  5.48883759e+04f,  5.49087852e+04f
,	 5.49291964e+04f,  5.49496096e+04f,  5.49700246e+04f,  5.49904415e+04f
,	 5.50108604e+04f,  5.50312811e+04f,  5.50517037e+04f,  5.50721282e+04f
,	 5.50925546e+04f,  5.51129829e+04f,  5.51334131e+04f,  5.51538452e+04f
,	 5.51742791e+04f,  5.51947150e+04f,  5.52151528e+04f,  5.52355924e+04f
,	 5.52560339e+04f,  5.52764774e+04f,  5.52969227e+04f,  5.53173699e+04f
,	 5.53378190e+04f,  5.53582700e+04f,  5.53787229e+04f,  5.53991776e+04f
,	 5.54196343e+04f,  5.54400928e+04f,  5.54605533e+04f,  5.54810156e+04f
,	 5.55014798e+04f,  5.55219459e+04f,  5.55424138e+04f,  5.55628837e+04f
,	 5.55833555e+04f,  5.56038291e+04f,  5.56243046e+04f,  5.56447820e+04f
,	 5.56652613e+04f,  5.56857425e+04f,  5.57062255e+04f,  5.57267105e+04f
,	 5.57471973e+04f,  5.57676860e+04f,  5.57881766e+04f,  5.58086690e+04f
,	 5.58291634e+04f,  5.58496596e+04f,  5.58701577e+04f,  5.58906577e+04f
,	 5.59111596e+04f,  5.59316633e+04f,  5.59521689e+04f,  5.59726765e+04f
,	 5.59931858e+04f,  5.60136971e+04f,  5.60342102e+04f,  5.60547253e+04f
,	 5.60752422e+04f,  5.60957609e+04f,  5.61162816e+04f,  5.61368041e+04f
,	 5.61573285e+04f,  5.61778548e+04f,  5.61983829e+04f,  5.62189130e+04f
,	 5.62394449e+04f,  5.62599786e+04f,  5.62805143e+04f,  5.63010518e+04f
,	 5.63215912e+04f,  5.63421325e+04f,  5.63626756e+04f,  5.63832206e+04f
,	 5.64037675e+04f,  5.64243163e+04f,  5.64448669e+04f,  5.64654194e+04f
,	 5.64859738e+04f,  5.65065300e+04f,  5.65270881e+04f,  5.65476481e+04f
,	 5.65682099e+04f,  5.65887737e+04f,  5.66093392e+04f,  5.66299067e+04f
,	 5.66504760e+04f,  5.66710472e+04f,  5.66916202e+04f,  5.67121952e+04f
,	 5.67327720e+04f,  5.67533506e+04f,  5.67739311e+04f,  5.67945135e+04f
,	 5.68150978e+04f,  5.68356839e+04f,  5.68562718e+04f,  5.68768617e+04f
,	 5.68974534e+04f,  5.69180470e+04f,  5.69386424e+04f,  5.69592397e+04f
,	 5.69798388e+04f,  5.70004399e+04f,  5.70210427e+04f,  5.70416475e+04f
,	 5.70622541e+04f,  5.70828625e+04f,  5.71034729e+04f,  5.71240850e+04f
,	 5.71446991e+04f,  5.71653150e+04f,  5.71859327e+04f,  5.72065524e+04f
,	 5.72271738e+04f,  5.72477972e+04f,  5.72684224e+04f,  5.72890494e+04f
,	 5.73096783e+04f,  5.73303091e+04f,  5.73509417e+04f,  5.73715762e+04f
,	 5.73922125e+04f,  5.74128507e+04f,  5.74334907e+04f,  5.74541326e+04f
,	 5.74747764e+04f,  5.74954220e+04f,  5.75160694e+04f,  5.75367187e+04f
,	 5.75573699e+04f,  5.75780229e+04f,  5.75986778e+04f,  5.76193345e+04f
,	 5.76399931e+04f,  5.76606535e+04f,  5.76813158e+04f,  5.77019799e+04f
,	 5.77226458e+04f,  5.77433137e+04f,  5.77639833e+04f,  5.77846549e+04f
,	 5.78053282e+04f,  5.78260035e+04f,  5.78466805e+04f,  5.78673594e+04f
,	 5.78880402e+04f,  5.79087228e+04f,  5.79294073e+04f,  5.79500936e+04f
,	 5.79707817e+04f,  5.79914717e+04f,  5.80121636e+04f,  5.80328572e+04f
,	 5.80535528e+04f,  5.80742501e+04f,  5.80949494e+04f,  5.81156504e+04f
,	 5.81363533e+04f,  5.81570581e+04f,  5.81777647e+04f,  5.81984731e+04f
,	 5.82191834e+04f,  5.82398955e+04f,  5.82606095e+04f,  5.82813253e+04f
,	 5.83020429e+04f,  5.83227624e+04f,  5.83434837e+04f,  5.83642069e+04f
,	 5.83849319e+04f,  5.84056588e+04f,  5.84263874e+04f,  5.84471180e+04f
,	 5.84678503e+04f,  5.84885845e+04f,  5.85093206e+04f,  5.85300584e+04f
,	 5.85507982e+04f,  5.85715397e+04f,  5.85922831e+04f,  5.86130283e+04f
,	 5.86337754e+04f,  5.86545243e+04f,  5.86752750e+04f,  5.86960275e+04f
,	 5.87167819e+04f,  5.87375382e+04f,  5.87582962e+04f,  5.87790561e+04f
,	 5.87998179e+04f,  5.88205814e+04f,  5.88413468e+04f,  5.88621141e+04f
,	 5.88828831e+04f,  5.89036540e+04f,  5.89244267e+04f,  5.89452013e+04f
,	 5.89659777e+04f,  5.89867559e+04f,  5.90075359e+04f,  5.90283178e+04f
,	 5.90491015e+04f,  5.90698870e+04f,  5.90906744e+04f,  5.91114636e+04f
,	 5.91322546e+04f,  5.91530475e+04f,  5.91738421e+04f,  5.91946386e+04f
,	 5.92154370e+04f,  5.92362371e+04f,  5.92570391e+04f,  5.92778429e+04f
,	 5.92986485e+04f,  5.93194560e+04f,  5.93402653e+04f,  5.93610764e+04f
,	 5.93818893e+04f,  5.94027041e+04f,  5.94235206e+04f,  5.94443390e+04f
,	 5.94651593e+04f,  5.94859813e+04f,  5.95068052e+04f,  5.95276309e+04f
,	 5.95484584e+04f,  5.95692877e+04f,  5.95901189e+04f,  5.96109518e+04f
,	 5.96317866e+04f,  5.96526232e+04f,  5.96734617e+04f,  5.96943019e+04f
,	 5.97151440e+04f,  5.97359879e+04f,  5.97568336e+04f,  5.97776811e+04f
,	 5.97985305e+04f,  5.98193816e+04f,  5.98402346e+04f,  5.98610894e+04f
,	 5.98819460e+04f,  5.99028045e+04f,  5.99236647e+04f,  5.99445268e+04f
,	 5.99653906e+04f,  5.99862563e+04f,  6.00071238e+04f,  6.00279932e+04f
,	 6.00488643e+04f,  6.00697372e+04f,  6.00906120e+04f,  6.01114886e+04f
,	 6.01323670e+04f,  6.01532472e+04f,  6.01741292e+04f,  6.01950130e+04f
,	 6.02158986e+04f,  6.02367861e+04f,  6.02576753e+04f,  6.02785664e+04f
,	 6.02994593e+04f,  6.03203540e+04f,  6.03412505e+04f,  6.03621488e+04f
,	 6.03830489e+04f,  6.04039508e+04f,  6.04248546e+04f,  6.04457601e+04f
,	 6.04666675e+04f,  6.04875766e+04f,  6.05084876e+04f,  6.05294003e+04f
,	 6.05503149e+04f,  6.05712313e+04f,  6.05921495e+04f,  6.06130695e+04f
,	 6.06339913e+04f,  6.06549149e+04f,  6.06758403e+04f,  6.06967675e+04f
,	 6.07176965e+04f,  6.07386274e+04f,  6.07595600e+04f,  6.07804944e+04f
,	 6.08014306e+04f,  6.08223687e+04f,  6.08433085e+04f,  6.08642501e+04f
,	 6.08851936e+04f,  6.09061388e+04f,  6.09270859e+04f,  6.09480347e+04f
,	 6.09689853e+04f,  6.09899378e+04f,  6.10108920e+04f,  6.10318481e+04f
,	 6.10528059e+04f,  6.10737655e+04f,  6.10947270e+04f,  6.11156902e+04f
,	 6.11366552e+04f,  6.11576221e+04f,  6.11785907e+04f,  6.11995611e+04f
,	 6.12205333e+04f,  6.12415074e+04f,  6.12624832e+04f,  6.12834608e+04f
,	 6.13044402e+04f,  6.13254214e+04f,  6.13464044e+04f,  6.13673892e+04f
,	 6.13883757e+04f,  6.14093641e+04f,  6.14303543e+04f,  6.14513463e+04f
,	 6.14723400e+04f,  6.14933356e+04f,  6.15143329e+04f,  6.15353320e+04f
,	 6.15563330e+04f,  6.15773357e+04f,  6.15983402e+04f,  6.16193465e+04f
,	 6.16403546e+04f,  6.16613644e+04f,  6.16823761e+04f,  6.17033896e+04f
,	 6.17244048e+04f,  6.17454218e+04f,  6.17664407e+04f,  6.17874613e+04f
,	 6.18084837e+04f,  6.18295079e+04f,  6.18505338e+04f,  6.18715616e+04f
,	 6.18925912e+04f,  6.19136225e+04f,  6.19346556e+04f,  6.19556905e+04f
,	 6.19767272e+04f,  6.19977657e+04f,  6.20188060e+04f,  6.20398480e+04f
,	 6.20608918e+04f,  6.20819374e+04f,  6.21029848e+04f,  6.21240340e+04f
,	 6.21450850e+04f,  6.21661377e+04f,  6.21871923e+04f,  6.22082486e+04f
,	 6.22293067e+04f,  6.22503666e+04f,  6.22714282e+04f,  6.22924917e+04f
,	 6.23135569e+04f,  6.23346239e+04f,  6.23556927e+04f,  6.23767632e+04f
,	 6.23978356e+04f,  6.24189097e+04f,  6.24399856e+04f,  6.24610633e+04f
,	 6.24821427e+04f,  6.25032240e+04f,  6.25243070e+04f,  6.25453918e+04f
,	 6.25664783e+04f,  6.25875667e+04f,  6.26086568e+04f,  6.26297487e+04f
,	 6.26508424e+04f,  6.26719378e+04f,  6.26930350e+04f,  6.27141340e+04f
,	 6.27352348e+04f,  6.27563373e+04f,  6.27774417e+04f,  6.27985478e+04f
,	 6.28196556e+04f,  6.28407653e+04f,  6.28618767e+04f,  6.28829899e+04f
,	 6.29041048e+04f,  6.29252216e+04f,  6.29463401e+04f,  6.29674603e+04f
,	 6.29885824e+04f,  6.30097062e+04f,  6.30308318e+04f,  6.30519592e+04f
,	 6.30730883e+04f,  6.30942192e+04f,  6.31153518e+04f,  6.31364863e+04f
,	 6.31576225e+04f,  6.31787605e+04f,  6.31999002e+04f,  6.32210417e+04f
,	 6.32421850e+04f,  6.32633300e+04f,  6.32844768e+04f,  6.33056254e+04f
,	 6.33267758e+04f,  6.33479279e+04f,  6.33690818e+04f,  6.33902374e+04f
,	 6.34113948e+04f,  6.34325540e+04f,  6.34537149e+04f,  6.34748776e+04f
,	 6.34960421e+04f,  6.35172083e+04f,  6.35383763e+04f,  6.35595461e+04f
,	 6.35807176e+04f,  6.36018909e+04f,  6.36230659e+04f,  6.36442427e+04f
,	 6.36654213e+04f,  6.36866016e+04f,  6.37077837e+04f,  6.37289675e+04f
,	 6.37501532e+04f,  6.37713405e+04f,  6.37925297e+04f,  6.38137205e+04f
,	 6.38349132e+04f,  6.38561076e+04f,  6.38773038e+04f,  6.38985017e+04f
,	 6.39197014e+04f,  6.39409028e+04f,  6.39621060e+04f,  6.39833110e+04f
,	 6.40045177e+04f,  6.40257262e+04f,  6.40469364e+04f,  6.40681484e+04f
,	 6.40893621e+04f,  6.41105776e+04f,  6.41317949e+04f,  6.41530139e+04f
,	 6.41742346e+04f,  6.41954572e+04f,  6.42166814e+04f,  6.42379075e+04f
,	 6.42591352e+04f,  6.42803648e+04f,  6.43015960e+04f,  6.43228291e+04f
,	 6.43440639e+04f,  6.43653004e+04f,  6.43865387e+04f,  6.44077788e+04f
,	 6.44290205e+04f,  6.44502641e+04f,  6.44715094e+04f,  6.44927564e+04f
,	 6.45140052e+04f,  6.45352558e+04f,  6.45565081e+04f,  6.45777621e+04f
,	 6.45990179e+04f,  6.46202755e+04f,  6.46415348e+04f,  6.46627958e+04f
,	 6.46840586e+04f,  6.47053231e+04f,  6.47265894e+04f,  6.47478574e+04f
,	 6.47691272e+04f,  6.47903987e+04f,  6.48116720e+04f,  6.48329470e+04f
,	 6.48542238e+04f,  6.48755023e+04f,  6.48967825e+04f,  6.49180645e+04f
,	 6.49393483e+04f,  6.49606337e+04f,  6.49819210e+04f,  6.50032099e+04f
,	 6.50245007e+04f,  6.50457931e+04f,  6.50670873e+04f,  6.50883832e+04f
,	 6.51096809e+04f,  6.51309804e+04f,  6.51522815e+04f,  6.51735844e+04f
,	 6.51948891e+04f,  6.52161955e+04f,  6.52375036e+04f,  6.52588135e+04f
,	 6.52801251e+04f,  6.53014384e+04f,  6.53227535e+04f,  6.53440703e+04f
,	 6.53653889e+04f,  6.53867092e+04f,  6.54080313e+04f,  6.54293550e+04f
,	 6.54506806e+04f,  6.54720078e+04f,  6.54933368e+04f,  6.55146675e+04f
,	 6.55360000e+04f,  6.55573342e+04f,  6.55786701e+04f,  6.56000078e+04f
,	 6.56213472e+04f,  6.56426884e+04f,  6.56640312e+04f,  6.56853759e+04f
,	 6.57067222e+04f,  6.57280703e+04f,  6.57494201e+04f,  6.57707716e+04f
,	 6.57921249e+04f,  6.58134799e+04f,  6.58348367e+04f,  6.58561952e+04f
,	 6.58775554e+04f,  6.58989173e+04f,  6.59202810e+04f,  6.59416464e+04f
,	 6.59630135e+04f,  6.59843824e+04f,  6.60057530e+04f,  6.60271253e+04f
,	 6.60484994e+04f,  6.60698751e+04f,  6.60912526e+04f,  6.61126319e+04f
,	 6.61340129e+04f,  6.61553956e+04f,  6.61767800e+04f,  6.61981661e+04f
,	 6.62195540e+04f,  6.62409436e+04f,  6.62623350e+04f,  6.62837280e+04f
,	 6.63051228e+04f,  6.63265193e+04f,  6.63479176e+04f,  6.63693175e+04f
,	 6.63907192e+04f,  6.64121226e+04f,  6.64335278e+04f,  6.64549346e+04f
,	 6.64763432e+04f,  6.64977535e+04f,  6.65191656e+04f,  6.65405793e+04f
,	 6.65619948e+04f,  6.65834120e+04f,  6.66048309e+04f,  6.66262516e+04f
,	 6.66476740e+04f,  6.66690981e+04f,  6.66905239e+04f,  6.67119514e+04f
,	 6.67333807e+04f,  6.67548116e+04f,  6.67762443e+04f,  6.67976788e+04f
,	 6.68191149e+04f,  6.68405527e+04f,  6.68619923e+04f,  6.68834336e+04f
,	 6.69048766e+04f,  6.69263214e+04f,  6.69477678e+04f,  6.69692160e+04f
,	 6.69906658e+04f,  6.70121174e+04f,  6.70335708e+04f,  6.70550258e+04f
,	 6.70764825e+04f,  6.70979410e+04f,  6.71194012e+04f,  6.71408631e+04f
,	 6.71623267e+04f,  6.71837920e+04f,  6.72052591e+04f,  6.72267278e+04f
,	 6.72481983e+04f,  6.72696705e+04f,  6.72911444e+04f,  6.73126200e+04f
,	 6.73340973e+04f,  6.73555764e+04f,  6.73770571e+04f,  6.73985396e+04f
,	 6.74200237e+04f,  6.74415096e+04f,  6.74629972e+04f,  6.74844865e+04f
,	 6.75059776e+04f,  6.75274703e+04f,  6.75489647e+04f,  6.75704609e+04f
,	 6.75919587e+04f,  6.76134583e+04f,  6.76349596e+04f,  6.76564626e+04f
,	 6.76779673e+04f,  6.76994737e+04f,  6.77209818e+04f,  6.77424916e+04f
,	 6.77640031e+04f,  6.77855164e+04f,  6.78070313e+04f,  6.78285480e+04f
,	 6.78500663e+04f,  6.78715864e+04f,  6.78931081e+04f,  6.79146316e+04f
,	 6.79361568e+04f,  6.79576837e+04f,  6.79792123e+04f,  6.80007426e+04f
,	 6.80222746e+04f,  6.80438083e+04f,  6.80653437e+04f,  6.80868808e+04f
,	 6.81084196e+04f,  6.81299601e+04f,  6.81515023e+04f,  6.81730463e+04f
,	 6.81945919e+04f,  6.82161392e+04f,  6.82376882e+04f,  6.82592390e+04f
,	 6.82807914e+04f,  6.83023455e+04f,  6.83239014e+04f,  6.83454589e+04f
,	 6.83670181e+04f,  6.83885790e+04f,  6.84101417e+04f,  6.84317060e+04f
,	 6.84532720e+04f,  6.84748398e+04f,  6.84964092e+04f,  6.85179803e+04f
,	 6.85395531e+04f,  6.85611277e+04f,  6.85827039e+04f,  6.86042818e+04f
,	 6.86258614e+04f,  6.86474427e+04f,  6.86690257e+04f,  6.86906104e+04f
,	 6.87121968e+04f,  6.87337849e+04f,  6.87553747e+04f,  6.87769662e+04f
,	 6.87985593e+04f,  6.88201542e+04f,  6.88417508e+04f,  6.88633490e+04f
,	 6.88849490e+04f,  6.89065506e+04f,  6.89281540e+04f,  6.89497590e+04f
,	 6.89713657e+04f,  6.89929741e+04f,  6.90145843e+04f,  6.90361961e+04f
,	 6.90578095e+04f,  6.90794247e+04f,  6.91010416e+04f,  6.91226602e+04f
,	 6.91442804e+04f,  6.91659024e+04f,  6.91875260e+04f,  6.92091513e+04f
,	 6.92307783e+04f,  6.92524071e+04f,  6.92740374e+04f,  6.92956695e+04f
,	 6.93173033e+04f,  6.93389388e+04f,  6.93605759e+04f,  6.93822147e+04f
,	 6.94038553e+04f,  6.94254975e+04f,  6.94471414e+04f,  6.94687869e+04f
,	 6.94904342e+04f,  6.95120832e+04f,  6.95337338e+04f,  6.95553861e+04f
,	 6.95770401e+04f,  6.95986958e+04f,  6.96203532e+04f,  6.96420123e+04f
,	 6.96636730e+04f,  6.96853355e+04f,  6.97069996e+04f,  6.97286654e+04f
,	 6.97503328e+04f,  6.97720020e+04f,  6.97936729e+04f,  6.98153454e+04f
,	 6.98370196e+04f,  6.98586955e+04f,  6.98803731e+04f,  6.99020523e+04f
,	 6.99237333e+04f,  6.99454159e+04f,  6.99671002e+04f,  6.99887862e+04f
,	 7.00104738e+04f,  7.00321632e+04f,  7.00538542e+04f,  7.00755469e+04f
,	 7.00972412e+04f,  7.01189373e+04f,  7.01406350e+04f,  7.01623344e+04f
,	 7.01840355e+04f,  7.02057383e+04f,  7.02274427e+04f,  7.02491489e+04f
,	 7.02708567e+04f,  7.02925661e+04f,  7.03142773e+04f,  7.03359901e+04f
,	 7.03577046e+04f,  7.03794208e+04f,  7.04011387e+04f,  7.04228582e+04f
,	 7.04445794e+04f,  7.04663023e+04f,  7.04880268e+04f,  7.05097530e+04f
,	 7.05314809e+04f,  7.05532105e+04f,  7.05749418e+04f,  7.05966747e+04f
,	 7.06184093e+04f,  7.06401455e+04f,  7.06618835e+04f,  7.06836231e+04f
,	 7.07053644e+04f,  7.07271073e+04f,  7.07488519e+04f,  7.07705982e+04f
,	 7.07923462e+04f,  7.08140958e+04f,  7.08358472e+04f,  7.08576001e+04f
,	 7.08793548e+04f,  7.09011111e+04f,  7.09228691e+04f,  7.09446287e+04f
,	 7.09663900e+04f,  7.09881530e+04f,  7.10099177e+04f,  7.10316840e+04f
,	 7.10534520e+04f,  7.10752217e+04f,  7.10969930e+04f,  7.11187660e+04f
,	 7.11405407e+04f,  7.11623170e+04f,  7.11840950e+04f,  7.12058746e+04f
,	 7.12276560e+04f,  7.12494390e+04f,  7.12712236e+04f,  7.12930099e+04f
,	 7.13147979e+04f,  7.13365876e+04f,  7.13583789e+04f,  7.13801719e+04f
,	 7.14019665e+04f,  7.14237628e+04f,  7.14455608e+04f,  7.14673604e+04f
,	 7.14891617e+04f,  7.15109646e+04f,  7.15327693e+04f,  7.15545755e+04f
,	 7.15763835e+04f,  7.15981931e+04f,  7.16200043e+04f,  7.16418173e+04f
,	 7.16636318e+04f,  7.16854481e+04f,  7.17072660e+04f,  7.17290856e+04f
,	 7.17509068e+04f,  7.17727297e+04f,  7.17945542e+04f,  7.18163804e+04f
,	 7.18382083e+04f,  7.18600378e+04f,  7.18818689e+04f,  7.19037018e+04f
,	 7.19255363e+04f,  7.19473724e+04f,  7.19692102e+04f,  7.19910497e+04f
,	 7.20128908e+04f,  7.20347336e+04f,  7.20565780e+04f,  7.20784241e+04f
,	 7.21002718e+04f,  7.21221212e+04f,  7.21439723e+04f,  7.21658250e+04f
,	 7.21876793e+04f,  7.22095353e+04f,  7.22313930e+04f,  7.22532523e+04f
,	 7.22751133e+04f,  7.22969759e+04f,  7.23188402e+04f,  7.23407061e+04f
,	 7.23625737e+04f,  7.23844430e+04f,  7.24063138e+04f,  7.24281864e+04f
,	 7.24500606e+04f,  7.24719364e+04f,  7.24938139e+04f,  7.25156931e+04f
,	 7.25375739e+04f,  7.25594563e+04f,  7.25813404e+04f,  7.26032262e+04f
,	 7.26251135e+04f,  7.26470026e+04f,  7.26688933e+04f,  7.26907856e+04f
,	 7.27126796e+04f,  7.27345753e+04f,  7.27564725e+04f,  7.27783715e+04f
,	 7.28002721e+04f,  7.28221743e+04f,  7.28440782e+04f,  7.28659837e+04f
,	 7.28878909e+04f,  7.29097997e+04f,  7.29317101e+04f,  7.29536222e+04f
,	 7.29755360e+04f,  7.29974514e+04f,  7.30193684e+04f,  7.30412871e+04f
,	 7.30632075e+04f,  7.30851294e+04f,  7.31070530e+04f,  7.31289783e+04f
,	 7.31509052e+04f,  7.31728338e+04f,  7.31947640e+04f,  7.32166958e+04f
,	 7.32386293e+04f,  7.32605644e+04f,  7.32825012e+04f,  7.33044396e+04f
,	 7.33263796e+04f,  7.33483213e+04f,  7.33702646e+04f,  7.33922096e+04f
,	 7.34141562e+04f,  7.34361045e+04f,  7.34580544e+04f,  7.34800059e+04f
,	 7.35019591e+04f,  7.35239139e+04f,  7.35458703e+04f,  7.35678284e+04f
,	 7.35897881e+04f,  7.36117495e+04f,  7.36337125e+04f,  7.36556771e+04f
,	 7.36776434e+04f,  7.36996113e+04f,  7.37215809e+04f,  7.37435521e+04f
,	 7.37655249e+04f,  7.37874994e+04f,  7.38094755e+04f,  7.38314532e+04f
,	 7.38534326e+04f,  7.38754136e+04f,  7.38973962e+04f,  7.39193805e+04f
,	 7.39413664e+04f,  7.39633540e+04f,  7.39853431e+04f,  7.40073339e+04f
,	 7.40293264e+04f,  7.40513205e+04f,  7.40733162e+04f,  7.40953135e+04f
,	 7.41173125e+04f,  7.41393131e+04f,  7.41613154e+04f,  7.41833192e+04f
,	 7.42053248e+04f,  7.42273319e+04f,  7.42493407e+04f,  7.42713511e+04f
,	 7.42933631e+04f,  7.43153768e+04f,  7.43373921e+04f,  7.43594090e+04f
,	 7.43814275e+04f,  7.44034477e+04f,  7.44254695e+04f,  7.44474930e+04f
,	 7.44695180e+04f,  7.44915447e+04f,  7.45135731e+04f,  7.45356030e+04f
,	 7.45576346e+04f,  7.45796678e+04f,  7.46017027e+04f,  7.46237391e+04f
,	 7.46457772e+04f,  7.46678169e+04f,  7.46898583e+04f,  7.47119013e+04f
,	 7.47339459e+04f,  7.47559921e+04f,  7.47780399e+04f,  7.48000894e+04f
,	 7.48221405e+04f,  7.48441932e+04f,  7.48662476e+04f,  7.48883036e+04f
,	 7.49103612e+04f,  7.49324204e+04f,  7.49544812e+04f,  7.49765437e+04f
,	 7.49986078e+04f,  7.50206735e+04f,  7.50427408e+04f,  7.50648098e+04f
,	 7.50868804e+04f,  7.51089526e+04f,  7.51310264e+04f,  7.51531019e+04f
,	 7.51751789e+04f,  7.51972576e+04f,  7.52193379e+04f,  7.52414199e+04f
,	 7.52635034e+04f,  7.52855886e+04f,  7.53076754e+04f,  7.53297638e+04f
,	 7.53518538e+04f,  7.53739455e+04f,  7.53960387e+04f,  7.54181336e+04f
,	 7.54402301e+04f,  7.54623282e+04f,  7.54844280e+04f,  7.55065293e+04f
,	 7.55286323e+04f,  7.55507369e+04f,  7.55728431e+04f,  7.55949510e+04f
,	 7.56170604e+04f,  7.56391715e+04f,  7.56612841e+04f,  7.56833984e+04f
,	 7.57055143e+04f,  7.57276319e+04f,  7.57497510e+04f,  7.57718717e+04f
,	 7.57939941e+04f,  7.58161181e+04f,  7.58382437e+04f,  7.58603709e+04f
,	 7.58824997e+04f,  7.59046302e+04f,  7.59267622e+04f,  7.59488959e+04f
,	 7.59710311e+04f,  7.59931680e+04f,  7.60153065e+04f,  7.60374466e+04f
,	 7.60595884e+04f,  7.60817317e+04f,  7.61038766e+04f,  7.61260232e+04f
,	 7.61481714e+04f,  7.61703212e+04f,  7.61924725e+04f,  7.62146255e+04f
,	 7.62367801e+04f,  7.62589364e+04f,  7.62810942e+04f,  7.63032536e+04f
,	 7.63254147e+04f,  7.63475773e+04f,  7.63697416e+04f,  7.63919075e+04f
,	 7.64140750e+04f,  7.64362440e+04f,  7.64584147e+04f,  7.64805870e+04f
,	 7.65027609e+04f,  7.65249365e+04f,  7.65471136e+04f,  7.65692923e+04f
,	 7.65914727e+04f,  7.66136546e+04f,  7.66358381e+04f,  7.66580233e+04f
,	 7.66802101e+04f,  7.67023984e+04f,  7.67245884e+04f,  7.67467800e+04f
,	 7.67689731e+04f,  7.67911679e+04f,  7.68133643e+04f,  7.68355623e+04f
,	 7.68577619e+04f,  7.68799631e+04f,  7.69021659e+04f,  7.69243703e+04f
,	 7.69465763e+04f,  7.69687839e+04f,  7.69909931e+04f,  7.70132039e+04f
,	 7.70354163e+04f,  7.70576303e+04f,  7.70798459e+04f,  7.71020631e+04f
,	 7.71242820e+04f,  7.71465024e+04f,  7.71687244e+04f,  7.71909480e+04f
,	 7.72131732e+04f,  7.72354000e+04f,  7.72576284e+04f,  7.72798585e+04f
,	 7.73020901e+04f,  7.73243233e+04f,  7.73465581e+04f,  7.73687945e+04f
,	 7.73910325e+04f,  7.74132721e+04f,  7.74355133e+04f,  7.74577561e+04f
,	 7.74800005e+04f,  7.75022465e+04f,  7.75244941e+04f,  7.75467432e+04f
,	 7.75689940e+04f,  7.75912464e+04f,  7.76135004e+04f,  7.76357559e+04f
,	 7.76580131e+04f,  7.76802718e+04f,  7.77025322e+04f,  7.77247941e+04f
,	 7.77470577e+04f,  7.77693228e+04f,  7.77915895e+04f,  7.78138578e+04f
,	 7.78361278e+04f,  7.78583993e+04f,  7.78806724e+04f,  7.79029471e+04f
,	 7.79252233e+04f,  7.79475012e+04f,  7.79697807e+04f,  7.79920617e+04f
,	 7.80143444e+04f,  7.80366286e+04f,  7.80589145e+04f,  7.80812019e+04f
,	 7.81034909e+04f,  7.81257815e+04f,  7.81480737e+04f,  7.81703675e+04f
,	 7.81926629e+04f,  7.82149598e+04f,  7.82372584e+04f,  7.82595585e+04f
,	 7.82818602e+04f,  7.83041636e+04f,  7.83264685e+04f,  7.83487750e+04f
,	 7.83710830e+04f,  7.83933927e+04f,  7.84157040e+04f,  7.84380168e+04f
,	 7.84603313e+04f,  7.84826473e+04f,  7.85049649e+04f,  7.85272841e+04f
,	 7.85496048e+04f,  7.85719272e+04f,  7.85942512e+04f,  7.86165767e+04f
,	 7.86389038e+04f,  7.86612325e+04f,  7.86835628e+04f,  7.87058947e+04f
,	 7.87282281e+04f,  7.87505632e+04f,  7.87728998e+04f,  7.87952380e+04f
,	 7.88175778e+04f,  7.88399192e+04f,  7.88622621e+04f,  7.88846067e+04f
,	 7.89069528e+04f,  7.89293005e+04f,  7.89516498e+04f,  7.89740007e+04f
,	 7.89963531e+04f,  7.90187071e+04f,  7.90410627e+04f,  7.90634199e+04f
,	 7.90857787e+04f,  7.91081391e+04f,  7.91305010e+04f,  7.91528645e+04f
,	 7.91752296e+04f,  7.91975963e+04f,  7.92199645e+04f,  7.92423344e+04f
,	 7.92647058e+04f,  7.92870788e+04f,  7.93094533e+04f,  7.93318295e+04f
,	 7.93542072e+04f,  7.93765865e+04f,  7.93989674e+04f,  7.94213498e+04f
,	 7.94437339e+04f,  7.94661195e+04f,  7.94885067e+04f,  7.95108954e+04f
,	 7.95332858e+04f,  7.95556777e+04f,  7.95780712e+04f,  7.96004663e+04f
,	 7.96228629e+04f,  7.96452611e+04f,  7.96676609e+04f,  7.96900623e+04f
,	 7.97124652e+04f,  7.97348697e+04f,  7.97572758e+04f,  7.97796835e+04f
,	 7.98020927e+04f,  7.98245035e+04f,  7.98469159e+04f,  7.98693299e+04f
,	 7.98917454e+04f,  7.99141625e+04f,  7.99365812e+04f,  7.99590014e+04f
,	 7.99814232e+04f,  8.00038466e+04f,  8.00262716e+04f,  8.00486981e+04f
,	 8.00711262e+04f,  8.00935559e+04f,  8.01159871e+04f,  8.01384199e+04f
,	 8.01608543e+04f,  8.01832903e+04f,  8.02057278e+04f,  8.02281669e+04f
,	 8.02506075e+04f,  8.02730498e+04f,  8.02954936e+04f,  8.03179389e+04f
,	 8.03403859e+04f,  8.03628344e+04f,  8.03852845e+04f,  8.04077361e+04f
,	 8.04301893e+04f,  8.04526441e+04f,  8.04751004e+04f,  8.04975583e+04f
,	 8.05200178e+04f,  8.05424788e+04f,  8.05649414e+04f,  8.05874056e+04f
,	 8.06098713e+04f,  8.06323386e+04f,  8.06548075e+04f,  8.06772779e+04f
,	 8.06997499e+04f,  8.07222235e+04f,  8.07446986e+04f,  8.07671753e+04f
,	 8.07896536e+04f,  8.08121334e+04f,  8.08346148e+04f,  8.08570977e+04f
,	 8.08795822e+04f,  8.09020683e+04f,  8.09245559e+04f,  8.09470451e+04f
,	 8.09695359e+04f,  8.09920282e+04f,  8.10145221e+04f,  8.10370175e+04f
,	 8.10595145e+04f,  8.10820131e+04f,  8.11045132e+04f,  8.11270149e+04f
,	 8.11495181e+04f,  8.11720229e+04f,  8.11945293e+04f,  8.12170372e+04f
,	 8.12395467e+04f,  8.12620578e+04f,  8.12845704e+04f,  8.13070845e+04f
,	 8.13296002e+04f,  8.13521175e+04f,  8.13746364e+04f,  8.13971568e+04f
,	 8.14196787e+04f,  8.14422022e+04f,  8.14647273e+04f,  8.14872539e+04f
,	 8.15097821e+04f,  8.15323118e+04f,  8.15548431e+04f,  8.15773760e+04f
,	 8.15999104e+04f,  8.16224464e+04f,  8.16449839e+04f,  8.16675230e+04f
,	 8.16900636e+04f,  8.17126058e+04f,  8.17351495e+04f,  8.17576948e+04f
,	 8.17802417e+04f,  8.18027901e+04f,  8.18253400e+04f,  8.18478915e+04f
,	 8.18704446e+04f,  8.18929992e+04f,  8.19155554e+04f,  8.19381131e+04f
,	 8.19606724e+04f,  8.19832332e+04f,  8.20057956e+04f,  8.20283595e+04f
,	 8.20509250e+04f,  8.20734921e+04f,  8.20960606e+04f,  8.21186308e+04f
,	 8.21412025e+04f,  8.21637757e+04f,  8.21863505e+04f,  8.22089269e+04f
,	 8.22315047e+04f,  8.22540842e+04f,  8.22766652e+04f,  8.22992477e+04f
,	 8.23218318e+04f,  8.23444174e+04f,  8.23670046e+04f,  8.23895934e+04f
,	 8.24121837e+04f,  8.24347755e+04f,  8.24573689e+04f,  8.24799638e+04f
,	 8.25025603e+04f,  8.25251583e+04f,  8.25477579e+04f,  8.25703590e+04f
,	 8.25929617e+04f,  8.26155659e+04f,  8.26381716e+04f,  8.26607789e+04f
,	 8.26833878e+04f,  8.27059982e+04f,  8.27286101e+04f,  8.27512236e+04f
,	 8.27738386e+04f,  8.27964552e+04f,  8.28190733e+04f,  8.28416930e+04f
,	 8.28643142e+04f,  8.28869369e+04f,  8.29095612e+04f,  8.29321871e+04f
,	 8.29548145e+04f,  8.29774434e+04f,  8.30000739e+04f,  8.30227059e+04f
,	 8.30453394e+04f,  8.30679745e+04f,  8.30906112e+04f,  8.31132493e+04f
,	 8.31358891e+04f,  8.31585303e+04f,  8.31811731e+04f,  8.32038175e+04f
,	 8.32264634e+04f,  8.32491108e+04f,  8.32717598e+04f,  8.32944103e+04f
,	 8.33170623e+04f,  8.33397159e+04f,  8.33623710e+04f,  8.33850277e+04f
,	 8.34076859e+04f,  8.34303456e+04f,  8.34530069e+04f,  8.34756697e+04f
,	 8.34983341e+04f,  8.35210000e+04f,  8.35436674e+04f,  8.35663364e+04f
,	 8.35890069e+04f,  8.36116790e+04f,  8.36343526e+04f,  8.36570277e+04f
,	 8.36797043e+04f,  8.37023825e+04f,  8.37250623e+04f,  8.37477435e+04f
,	 8.37704263e+04f,  8.37931107e+04f,  8.38157965e+04f,  8.38384839e+04f
,	 8.38611729e+04f,  8.38838634e+04f,  8.39065554e+04f,  8.39292489e+04f
,	 8.39519440e+04f,  8.39746406e+04f,  8.39973388e+04f,  8.40200385e+04f
,	 8.40427397e+04f,  8.40654424e+04f,  8.40881467e+04f,  8.41108525e+04f
,	 8.41335599e+04f,  8.41562688e+04f,  8.41789792e+04f,  8.42016911e+04f
,	 8.42244046e+04f,  8.42471196e+04f,  8.42698361e+04f,  8.42925542e+04f
,	 8.43152738e+04f,  8.43379949e+04f,  8.43607176e+04f,  8.43834418e+04f
,	 8.44061675e+04f,  8.44288947e+04f,  8.44516235e+04f,  8.44743538e+04f
,	 8.44970857e+04f,  8.45198190e+04f,  8.45425539e+04f,  8.45652904e+04f
,	 8.45880283e+04f,  8.46107678e+04f,  8.46335088e+04f,  8.46562513e+04f
,	 8.46789954e+04f,  8.47017410e+04f,  8.47244881e+04f,  8.47472368e+04f
,	 8.47699869e+04f,  8.47927386e+04f,  8.48154919e+04f,  8.48382466e+04f
,	 8.48610029e+04f,  8.48837607e+04f,  8.49065200e+04f,  8.49292809e+04f
,	 8.49520433e+04f,  8.49748072e+04f,  8.49975726e+04f,  8.50203395e+04f
,	 8.50431080e+04f,  8.50658780e+04f,  8.50886495e+04f,  8.51114226e+04f
,	 8.51341972e+04f,  8.51569733e+04f,  8.51797509e+04f,  8.52025300e+04f
,	 8.52253107e+04f,  8.52480929e+04f,  8.52708766e+04f,  8.52936618e+04f
,	 8.53164486e+04f,  8.53392368e+04f,  8.53620266e+04f,  8.53848179e+04f
,	 8.54076108e+04f,  8.54304051e+04f,  8.54532010e+04f,  8.54759984e+04f
,	 8.54987973e+04f,  8.55215978e+04f,  8.55443997e+04f,  8.55672032e+04f
,	 8.55900082e+04f,  8.56128147e+04f,  8.56356228e+04f,  8.56584323e+04f
,	 8.56812434e+04f,  8.57040560e+04f,  8.57268701e+04f,  8.57496857e+04f
,	 8.57725029e+04f,  8.57953215e+04f,  8.58181417e+04f,  8.58409634e+04f
,	 8.58637866e+04f,  8.58866114e+04f,  8.59094376e+04f,  8.59322654e+04f
,	 8.59550946e+04f,  8.59779254e+04f,  8.60007578e+04f,  8.60235916e+04f
,	 8.60464269e+04f,  8.60692638e+04f,  8.60921022e+04f,  8.61149420e+04f
,	 8.61377834e+04f,  8.61606264e+04f,  8.61834708e+04f,  8.62063167e+04f
,	 8.62291642e+04f,  8.62520132e+04f,  8.62748637e+04f,  8.62977157e+04f
,	 8.63205692e+04f,  8.63434242e+04f,  8.63662807e+04f,  8.63891388e+04f
,	 8.64119983e+04f,  8.64348594e+04f,  8.64577220e+04f,  8.64805861e+04f
,	 8.65034517e+04f,  8.65263188e+04f,  8.65491874e+04f,  8.65720576e+04f
,	 8.65949292e+04f,  8.66178024e+04f,  8.66406771e+04f,  8.66635532e+04f
,	 8.66864309e+04f,  8.67093101e+04f,  8.67321908e+04f,  8.67550731e+04f
,	 8.67779568e+04f,  8.68008420e+04f,  8.68237288e+04f,  8.68466170e+04f
,	 8.68695068e+04f,  8.68923981e+04f,  8.69152908e+04f,  8.69381851e+04f
,	 8.69610809e+04f,  8.69839782e+04f,  8.70068770e+04f,  8.70297773e+04f
,	 8.70526792e+04f,  8.70755825e+04f,  8.70984873e+04f,  8.71213937e+04f
,	 8.71443015e+04f,  8.71672108e+04f,  8.71901217e+04f,  8.72130341e+04f
,	 8.72359479e+04f,  8.72588633e+04f,  8.72817802e+04f,  8.73046985e+04f
,	 8.73276184e+04f,  8.73505398e+04f,  8.73734627e+04f,  8.73963871e+04f
,	 8.74193130e+04f,  8.74422404e+04f,  8.74651693e+04f,  8.74880997e+04f
,	 8.75110316e+04f,  8.75339650e+04f,  8.75568999e+04f,  8.75798364e+04f
,	 8.76027743e+04f,  8.76257137e+04f,  8.76486546e+04f,  8.76715970e+04f
,	 8.76945410e+04f,  8.77174864e+04f,  8.77404333e+04f,  8.77633817e+04f
,	 8.77863317e+04f,  8.78092831e+04f,  8.78322360e+04f,  8.78551904e+04f
,	 8.78781464e+04f,  8.79011038e+04f,  8.79240627e+04f,  8.79470231e+04f
,	 8.79699850e+04f,  8.79929485e+04f,  8.80159134e+04f,  8.80388798e+04f
,	 8.80618477e+04f,  8.80848171e+04f,  8.81077880e+04f,  8.81307604e+04f
,	 8.81537343e+04f,  8.81767097e+04f,  8.81996866e+04f,  8.82226650e+04f
,	 8.82456449e+04f,  8.82686263e+04f,  8.82916092e+04f,  8.83145935e+04f
,	 8.83375794e+04f,  8.83605668e+04f,  8.83835556e+04f,  8.84065460e+04f
,	 8.84295379e+04f,  8.84525312e+04f,  8.84755260e+04f,  8.84985224e+04f
,	 8.85215202e+04f,  8.85445195e+04f,  8.85675203e+04f,  8.85905227e+04f
,	 8.86135265e+04f,  8.86365318e+04f,  8.86595385e+04f,  8.86825468e+04f
,	 8.87055566e+04f,  8.87285679e+04f,  8.87515806e+04f,  8.87745949e+04f
,	 8.87976106e+04f,  8.88206279e+04f,  8.88436466e+04f,  8.88666668e+04f
,	 8.88896885e+04f,  8.89127117e+04f,  8.89357364e+04f,  8.89587626e+04f
,	 8.89817902e+04f,  8.90048194e+04f,  8.90278500e+04f,  8.90508822e+04f
,	 8.90739158e+04f,  8.90969509e+04f,  8.91199875e+04f,  8.91430256e+04f
,	 8.91660652e+04f,  8.91891063e+04f,  8.92121488e+04f,  8.92351929e+04f
,	 8.92582384e+04f,  8.92812854e+04f,  8.93043340e+04f,  8.93273840e+04f
,	 8.93504354e+04f,  8.93734884e+04f,  8.93965429e+04f,  8.94195988e+04f
,	 8.94426562e+04f,  8.94657152e+04f,  8.94887756e+04f,  8.95118374e+04f
,	 8.95349008e+04f,  8.95579657e+04f,  8.95810320e+04f,  8.96040999e+04f
,	 8.96271692e+04f,  8.96502400e+04f,  8.96733123e+04f,  8.96963860e+04f
,	 8.97194613e+04f,  8.97425380e+04f,  8.97656162e+04f,  8.97886959e+04f
,	 8.98117771e+04f,  8.98348598e+04f,  8.98579439e+04f,  8.98810296e+04f
,	 8.99041167e+04f,  8.99272053e+04f,  8.99502954e+04f,  8.99733869e+04f
,	 8.99964800e+04f,  9.00195745e+04f,  9.00426705e+04f,  9.00657680e+04f
,	 9.00888670e+04f,  9.01119674e+04f,  9.01350693e+04f,  9.01581727e+04f
,	 9.01812776e+04f,  9.02043840e+04f,  9.02274919e+04f,  9.02506012e+04f
,	 9.02737120e+04f,  9.02968243e+04f,  9.03199381e+04f,  9.03430533e+04f
,	 9.03661700e+04f,  9.03892882e+04f,  9.04124079e+04f,  9.04355291e+04f
,	 9.04586517e+04f,  9.04817758e+04f,  9.05049014e+04f,  9.05280285e+04f
,	 9.05511570e+04f,  9.05742871e+04f,  9.05974186e+04f,  9.06205515e+04f
,	 9.06436860e+04f,  9.06668219e+04f,  9.06899593e+04f,  9.07130982e+04f
,	 9.07362386e+04f,  9.07593804e+04f,  9.07825237e+04f,  9.08056685e+04f
,	 9.08288148e+04f,  9.08519625e+04f,  9.08751117e+04f,  9.08982624e+04f
,	 9.09214146e+04f,  9.09445682e+04f,  9.09677233e+04f,  9.09908799e+04f
,	 9.10140379e+04f,  9.10371974e+04f,  9.10603584e+04f,  9.10835209e+04f
,	 9.11066849e+04f,  9.11298503e+04f,  9.11530172e+04f,  9.11761855e+04f
,	 9.11993553e+04f,  9.12225267e+04f,  9.12456994e+04f,  9.12688737e+04f
,	 9.12920494e+04f,  9.13152266e+04f,  9.13384052e+04f,  9.13615854e+04f
,	 9.13847670e+04f,  9.14079500e+04f,  9.14311346e+04f,  9.14543206e+04f
,	 9.14775081e+04f,  9.15006970e+04f,  9.15238874e+04f,  9.15470793e+04f
,	 9.15702727e+04f,  9.15934675e+04f,  9.16166638e+04f,  9.16398616e+04f
,	 9.16630608e+04f,  9.16862615e+04f,  9.17094637e+04f,  9.17326673e+04f
,	 9.17558724e+04f,  9.17790790e+04f,  9.18022870e+04f,  9.18254965e+04f
,	 9.18487075e+04f,  9.18719199e+04f,  9.18951338e+04f,  9.19183492e+04f
,	 9.19415660e+04f,  9.19647843e+04f,  9.19880041e+04f,  9.20112253e+04f
,	 9.20344480e+04f,  9.20576722e+04f,  9.20808978e+04f,  9.21041249e+04f
,	 9.21273534e+04f,  9.21505835e+04f,  9.21738149e+04f,  9.21970479e+04f
,	 9.22202823e+04f,  9.22435182e+04f,  9.22667555e+04f,  9.22899943e+04f
,	 9.23132346e+04f,  9.23364763e+04f,  9.23597195e+04f,  9.23829642e+04f
,	 9.24062103e+04f,  9.24294578e+04f,  9.24527069e+04f,  9.24759574e+04f
,	 9.24992093e+04f,  9.25224628e+04f,  9.25457176e+04f,  9.25689740e+04f
,	 9.25922318e+04f,  9.26154911e+04f,  9.26387518e+04f,  9.26620140e+04f
,	 9.26852776e+04f,  9.27085427e+04f,  9.27318093e+04f,  9.27550773e+04f
,	 9.27783468e+04f,  9.28016178e+04f,  9.28248902e+04f,  9.28481640e+04f
,	 9.28714393e+04f,  9.28947161e+04f,  9.29179944e+04f,  9.29412741e+04f
,	 9.29645552e+04f,  9.29878378e+04f,  9.30111219e+04f,  9.30344074e+04f
,	 9.30576944e+04f,  9.30809828e+04f,  9.31042727e+04f,  9.31275641e+04f
,	 9.31508569e+04f,  9.31741512e+04f,  9.31974469e+04f,  9.32207441e+04f
,	 9.32440427e+04f,  9.32673428e+04f,  9.32906443e+04f,  9.33139473e+04f
,	 9.33372518e+04f,  9.33605577e+04f,  9.33838651e+04f,  9.34071739e+04f
,	 9.34304841e+04f,  9.34537959e+04f,  9.34771090e+04f,  9.35004237e+04f
,	 9.35237398e+04f,  9.35470573e+04f,  9.35703763e+04f,  9.35936967e+04f
,	 9.36170186e+04f,  9.36403420e+04f,  9.36636668e+04f,  9.36869931e+04f
,	 9.37103208e+04f,  9.37336499e+04f,  9.37569805e+04f,  9.37803126e+04f
,	 9.38036461e+04f,  9.38269811e+04f,  9.38503175e+04f,  9.38736554e+04f
,	 9.38969947e+04f,  9.39203355e+04f,  9.39436777e+04f,  9.39670213e+04f
,	 9.39903665e+04f,  9.40137130e+04f,  9.40370610e+04f,  9.40604105e+04f
,	 9.40837614e+04f,  9.41071138e+04f,  9.41304676e+04f,  9.41538229e+04f
,	 9.41771796e+04f,  9.42005377e+04f,  9.42238974e+04f,  9.42472584e+04f
,	 9.42706209e+04f,  9.42939849e+04f,  9.43173503e+04f,  9.43407171e+04f
,	 9.43640854e+04f,  9.43874551e+04f,  9.44108263e+04f,  9.44341990e+04f
,	 9.44575730e+04f,  9.44809486e+04f,  9.45043255e+04f,  9.45277039e+04f
,	 9.45510838e+04f,  9.45744651e+04f,  9.45978479e+04f,  9.46212321e+04f
,	 9.46446177e+04f,  9.46680048e+04f,  9.46913933e+04f,  9.47147833e+04f
,	 9.47381747e+04f,  9.47615676e+04f,  9.47849619e+04f,  9.48083576e+04f
,	 9.48317548e+04f,  9.48551535e+04f,  9.48785536e+04f,  9.49019551e+04f
,	 9.49253580e+04f,  9.49487625e+04f,  9.49721683e+04f,  9.49955756e+04f
,	 9.50189843e+04f,  9.50423945e+04f,  9.50658061e+04f,  9.50892192e+04f
,	 9.51126337e+04f,  9.51360496e+04f,  9.51594670e+04f,  9.51828858e+04f
,	 9.52063061e+04f,  9.52297278e+04f,  9.52531510e+04f,  9.52765755e+04f
,	 9.53000016e+04f,  9.53234290e+04f,  9.53468579e+04f,  9.53702883e+04f
,	 9.53937201e+04f,  9.54171533e+04f,  9.54405880e+04f,  9.54640241e+04f
,	 9.54874616e+04f,  9.55109006e+04f,  9.55343410e+04f,  9.55577828e+04f
,	 9.55812261e+04f,  9.56046709e+04f,  9.56281170e+04f,  9.56515646e+04f
,	 9.56750137e+04f,  9.56984641e+04f,  9.57219161e+04f,  9.57453694e+04f
,	 9.57688242e+04f,  9.57922804e+04f,  9.58157381e+04f,  9.58391972e+04f
,	 9.58626577e+04f,  9.58861197e+04f,  9.59095831e+04f,  9.59330479e+04f
,	 9.59565142e+04f,  9.59799819e+04f,  9.60034510e+04f,  9.60269216e+04f
,	 9.60503936e+04f,  9.60738670e+04f,  9.60973419e+04f,  9.61208182e+04f
,	 9.61442960e+04f,  9.61677751e+04f,  9.61912558e+04f,  9.62147378e+04f
,	 9.62382213e+04f,  9.62617062e+04f,  9.62851925e+04f,  9.63086803e+04f
,	 9.63321695e+04f,  9.63556601e+04f,  9.63791522e+04f,  9.64026457e+04f
,	 9.64261406e+04f,  9.64496370e+04f,  9.64731348e+04f,  9.64966340e+04f
,	 9.65201347e+04f,  9.65436368e+04f,  9.65671403e+04f,  9.65906452e+04f
,	 9.66141516e+04f,  9.66376594e+04f,  9.66611687e+04f,  9.66846793e+04f
,	 9.67081914e+04f,  9.67317050e+04f,  9.67552199e+04f,  9.67787363e+04f
,	 9.68022541e+04f,  9.68257733e+04f,  9.68492940e+04f,  9.68728161e+04f
,	 9.68963396e+04f,  9.69198646e+04f,  9.69433910e+04f,  9.69669188e+04f
,	 9.69904480e+04f,  9.70139787e+04f,  9.70375108e+04f,  9.70610443e+04f
,	 9.70845792e+04f,  9.71081156e+04f,  9.71316534e+04f,  9.71551926e+04f
,	 9.71787333e+04f,  9.72022753e+04f,  9.72258188e+04f,  9.72493637e+04f
,	 9.72729101e+04f,  9.72964579e+04f,  9.73200071e+04f,  9.73435577e+04f
,	 9.73671097e+04f,  9.73906632e+04f,  9.74142181e+04f,  9.74377744e+04f
,	 9.74613322e+04f,  9.74848913e+04f,  9.75084519e+04f,  9.75320139e+04f
,	 9.75555774e+04f,  9.75791422e+04f,  9.76027085e+04f,  9.76262762e+04f
,	 9.76498454e+04f,  9.76734159e+04f,  9.76969879e+04f,  9.77205613e+04f
,	 9.77441361e+04f,  9.77677123e+04f,  9.77912900e+04f,  9.78148691e+04f
,	 9.78384496e+04f,  9.78620315e+04f,  9.78856148e+04f,  9.79091996e+04f
,	 9.79327858e+04f,  9.79563734e+04f,  9.79799624e+04f,  9.80035529e+04f
,	 9.80271447e+04f,  9.80507380e+04f,  9.80743327e+04f,  9.80979288e+04f
,	 9.81215264e+04f,  9.81451253e+04f,  9.81687257e+04f,  9.81923275e+04f
,	 9.82159307e+04f,  9.82395354e+04f,  9.82631414e+04f,  9.82867489e+04f
,	 9.83103578e+04f,  9.83339681e+04f,  9.83575798e+04f,  9.83811929e+04f
,	 9.84048075e+04f,  9.84284235e+04f,  9.84520409e+04f,  9.84756597e+04f
,	 9.84992799e+04f,  9.85229015e+04f,  9.85465246e+04f,  9.85701490e+04f
,	 9.85937749e+04f,  9.86174022e+04f,  9.86410310e+04f,  9.86646611e+04f
,	 9.86882926e+04f,  9.87119256e+04f,  9.87355600e+04f,  9.87591958e+04f
,	 9.87828330e+04f,  9.88064716e+04f,  9.88301116e+04f,  9.88537531e+04f
,	 9.88773959e+04f,  9.89010402e+04f,  9.89246859e+04f,  9.89483330e+04f
,	 9.89719815e+04f,  9.89956314e+04f,  9.90192828e+04f,  9.90429355e+04f
,	 9.90665897e+04f,  9.90902452e+04f,  9.91139022e+04f,  9.91375606e+04f
,	 9.91612204e+04f,  9.91848817e+04f,  9.92085443e+04f,  9.92322083e+04f
,	 9.92558738e+04f,  9.92795407e+04f,  9.93032089e+04f,  9.93268786e+04f
,	 9.93505497e+04f,  9.93742222e+04f,  9.93978961e+04f,  9.94215715e+04f
,	 9.94452482e+04f,  9.94689263e+04f,  9.94926059e+04f,  9.95162869e+04f
,	 9.95399692e+04f,  9.95636530e+04f,  9.95873382e+04f,  9.96110248e+04f
,	 9.96347128e+04f,  9.96584022e+04f,  9.96820930e+04f,  9.97057853e+04f
,	 9.97294789e+04f,  9.97531739e+04f,  9.97768704e+04f,  9.98005683e+04f
,	 9.98242675e+04f,  9.98479682e+04f,  9.98716703e+04f,  9.98953738e+04f
,	 9.99190786e+04f,  9.99427849e+04f,  9.99664926e+04f,  9.99902018e+04f
,	 1.00013912e+05f,  1.00037624e+05f,  1.00061338e+05f,  1.00085052e+05f
,	 1.00108768e+05f,  1.00132486e+05f,  1.00156205e+05f,  1.00179925e+05f
,	 1.00203647e+05f,  1.00227370e+05f,  1.00251095e+05f,  1.00274821e+05f
,	 1.00298548e+05f,  1.00322277e+05f,  1.00346007e+05f,  1.00369739e+05f
,	 1.00393472e+05f,  1.00417206e+05f,  1.00440942e+05f,  1.00464679e+05f
,	 1.00488417e+05f,  1.00512157e+05f,  1.00535899e+05f,  1.00559642e+05f
,	 1.00583386e+05f,  1.00607131e+05f,  1.00630878e+05f,  1.00654627e+05f
,	 1.00678377e+05f,  1.00702128e+05f,  1.00725880e+05f,  1.00749634e+05f
,	 1.00773390e+05f,  1.00797147e+05f,  1.00820905e+05f,  1.00844664e+05f
,	 1.00868425e+05f,  1.00892188e+05f,  1.00915952e+05f,  1.00939717e+05f
,	 1.00963483e+05f,  1.00987251e+05f,  1.01011021e+05f,  1.01034792e+05f
,	 1.01058564e+05f,  1.01082337e+05f,  1.01106112e+05f,  1.01129889e+05f
,	 1.01153667e+05f,  1.01177446e+05f,  1.01201226e+05f,  1.01225008e+05f
,	 1.01248792e+05f,  1.01272576e+05f,  1.01296363e+05f,  1.01320150e+05f
,	 1.01343939e+05f,  1.01367730e+05f,  1.01391521e+05f,  1.01415314e+05f
,	 1.01439109e+05f,  1.01462905e+05f,  1.01486702e+05f,  1.01510501e+05f
,	 1.01534301e+05f,  1.01558103e+05f,  1.01581906e+05f,  1.01605710e+05f
,	 1.01629516e+05f,  1.01653323e+05f,  1.01677131e+05f,  1.01700941e+05f
,	 1.01724752e+05f,  1.01748565e+05f,  1.01772379e+05f,  1.01796194e+05f
,	 1.01820011e+05f,  1.01843830e+05f,  1.01867649e+05f,  1.01891470e+05f
,	 1.01915293e+05f,  1.01939116e+05f,  1.01962942e+05f,  1.01986768e+05f
,	 1.02010596e+05f,  1.02034426e+05f,  1.02058256e+05f,  1.02082089e+05f
,	 1.02105922e+05f,  1.02129757e+05f,  1.02153593e+05f,  1.02177431e+05f
,	 1.02201270e+05f,  1.02225111e+05f,  1.02248953e+05f,  1.02272796e+05f
,	 1.02296641e+05f,  1.02320487e+05f,  1.02344334e+05f,  1.02368183e+05f
,	 1.02392033e+05f,  1.02415885e+05f,  1.02439738e+05f,  1.02463592e+05f
,	 1.02487448e+05f,  1.02511305e+05f,  1.02535164e+05f,  1.02559024e+05f
,	 1.02582885e+05f,  1.02606748e+05f,  1.02630612e+05f,  1.02654477e+05f
,	 1.02678344e+05f,  1.02702213e+05f,  1.02726082e+05f,  1.02749953e+05f
,	 1.02773826e+05f,  1.02797700e+05f,  1.02821575e+05f,  1.02845451e+05f
,	 1.02869329e+05f,  1.02893209e+05f,  1.02917089e+05f,  1.02940972e+05f
,	 1.02964855e+05f,  1.02988740e+05f,  1.03012626e+05f,  1.03036514e+05f
,	 1.03060403e+05f,  1.03084293e+05f,  1.03108185e+05f,  1.03132079e+05f
,	 1.03155973e+05f,  1.03179869e+05f,  1.03203766e+05f,  1.03227665e+05f
,	 1.03251565e+05f,  1.03275467e+05f,  1.03299370e+05f,  1.03323274e+05f
,	 1.03347180e+05f,  1.03371087e+05f,  1.03394995e+05f,  1.03418905e+05f
,	 1.03442816e+05f,  1.03466729e+05f,  1.03490643e+05f,  1.03514558e+05f
,	 1.03538475e+05f,  1.03562393e+05f,  1.03586312e+05f,  1.03610233e+05f
,	 1.03634155e+05f,  1.03658079e+05f,  1.03682004e+05f,  1.03705931e+05f
,	 1.03729858e+05f,  1.03753787e+05f,  1.03777718e+05f,  1.03801650e+05f
,	 1.03825583e+05f,  1.03849518e+05f,  1.03873454e+05f,  1.03897391e+05f
,	 1.03921330e+05f,  1.03945270e+05f,  1.03969212e+05f,  1.03993155e+05f
,	 1.04017099e+05f,  1.04041045e+05f,  1.04064992e+05f,  1.04088940e+05f
,	 1.04112890e+05f,  1.04136841e+05f,  1.04160794e+05f,  1.04184748e+05f
,	 1.04208703e+05f,  1.04232660e+05f,  1.04256618e+05f,  1.04280577e+05f
,	 1.04304538e+05f,  1.04328501e+05f,  1.04352464e+05f,  1.04376429e+05f
,	 1.04400395e+05f,  1.04424363e+05f,  1.04448332e+05f,  1.04472303e+05f
,	 1.04496275e+05f,  1.04520248e+05f,  1.04544222e+05f,  1.04568198e+05f
,	 1.04592176e+05f,  1.04616154e+05f,  1.04640135e+05f,  1.04664116e+05f
,	 1.04688099e+05f,  1.04712083e+05f,  1.04736069e+05f,  1.04760056e+05f
,	 1.04784044e+05f,  1.04808034e+05f,  1.04832025e+05f,  1.04856017e+05f
,	 1.04880011e+05f,  1.04904006e+05f,  1.04928003e+05f,  1.04952001e+05f
,	 1.04976000e+05f,  1.05000001e+05f,  1.05024003e+05f,  1.05048006e+05f
,	 1.05072011e+05f,  1.05096017e+05f,  1.05120025e+05f,  1.05144034e+05f
,	 1.05168044e+05f,  1.05192056e+05f,  1.05216069e+05f,  1.05240083e+05f
,	 1.05264099e+05f,  1.05288116e+05f,  1.05312134e+05f,  1.05336154e+05f
,	 1.05360175e+05f,  1.05384198e+05f,  1.05408222e+05f,  1.05432247e+05f
,	 1.05456274e+05f,  1.05480302e+05f,  1.05504332e+05f,  1.05528363e+05f
,	 1.05552395e+05f,  1.05576428e+05f,  1.05600463e+05f,  1.05624499e+05f
,	 1.05648537e+05f,  1.05672576e+05f,  1.05696617e+05f,  1.05720658e+05f
,	 1.05744701e+05f,  1.05768746e+05f,  1.05792792e+05f,  1.05816839e+05f
,	 1.05840888e+05f,  1.05864938e+05f,  1.05888989e+05f,  1.05913042e+05f
,	 1.05937096e+05f,  1.05961151e+05f,  1.05985208e+05f,  1.06009266e+05f
,	 1.06033326e+05f,  1.06057387e+05f,  1.06081449e+05f,  1.06105512e+05f
,	 1.06129577e+05f,  1.06153644e+05f,  1.06177711e+05f,  1.06201780e+05f
,	 1.06225851e+05f,  1.06249923e+05f,  1.06273996e+05f,  1.06298070e+05f
,	 1.06322146e+05f,  1.06346224e+05f,  1.06370302e+05f,  1.06394382e+05f
,	 1.06418464e+05f,  1.06442546e+05f,  1.06466630e+05f,  1.06490716e+05f
,	 1.06514803e+05f,  1.06538891e+05f,  1.06562980e+05f,  1.06587071e+05f
,	 1.06611163e+05f,  1.06635257e+05f,  1.06659352e+05f,  1.06683448e+05f
,	 1.06707546e+05f,  1.06731645e+05f,  1.06755745e+05f,  1.06779847e+05f
,	 1.06803950e+05f,  1.06828055e+05f,  1.06852161e+05f,  1.06876268e+05f
,	 1.06900376e+05f,  1.06924486e+05f,  1.06948597e+05f,  1.06972710e+05f
,	 1.06996824e+05f,  1.07020939e+05f,  1.07045056e+05f,  1.07069174e+05f
,	 1.07093294e+05f,  1.07117414e+05f,  1.07141537e+05f,  1.07165660e+05f
,	 1.07189785e+05f,  1.07213911e+05f,  1.07238039e+05f,  1.07262168e+05f
,	 1.07286298e+05f,  1.07310430e+05f,  1.07334563e+05f,  1.07358697e+05f
,	 1.07382833e+05f,  1.07406970e+05f,  1.07431108e+05f,  1.07455248e+05f
,	 1.07479389e+05f,  1.07503532e+05f,  1.07527676e+05f,  1.07551821e+05f
,	 1.07575967e+05f,  1.07600115e+05f,  1.07624265e+05f,  1.07648415e+05f
,	 1.07672567e+05f,  1.07696720e+05f,  1.07720875e+05f,  1.07745031e+05f
,	 1.07769189e+05f,  1.07793347e+05f,  1.07817507e+05f,  1.07841669e+05f
,	 1.07865832e+05f,  1.07889996e+05f,  1.07914161e+05f,  1.07938328e+05f
,	 1.07962497e+05f,  1.07986666e+05f,  1.08010837e+05f,  1.08035009e+05f
,	 1.08059183e+05f,  1.08083358e+05f,  1.08107534e+05f,  1.08131712e+05f
,	 1.08155891e+05f,  1.08180071e+05f,  1.08204253e+05f,  1.08228436e+05f
,	 1.08252621e+05f,  1.08276807e+05f,  1.08300994e+05f,  1.08325182e+05f
,	 1.08349372e+05f,  1.08373563e+05f,  1.08397756e+05f,  1.08421950e+05f
,	 1.08446145e+05f,  1.08470342e+05f,  1.08494540e+05f,  1.08518739e+05f
,	 1.08542939e+05f,  1.08567141e+05f,  1.08591345e+05f,  1.08615550e+05f
,	 1.08639756e+05f,  1.08663963e+05f,  1.08688172e+05f,  1.08712382e+05f
,	 1.08736593e+05f,  1.08760806e+05f,  1.08785020e+05f,  1.08809236e+05f
,	 1.08833452e+05f,  1.08857671e+05f,  1.08881890e+05f,  1.08906111e+05f
,	 1.08930333e+05f,  1.08954557e+05f,  1.08978782e+05f,  1.09003008e+05f
,	 1.09027236e+05f,  1.09051465e+05f,  1.09075695e+05f,  1.09099926e+05f
,	 1.09124159e+05f,  1.09148394e+05f,  1.09172629e+05f,  1.09196866e+05f
,	 1.09221105e+05f,  1.09245345e+05f,  1.09269586e+05f,  1.09293828e+05f
,	 1.09318072e+05f,  1.09342317e+05f,  1.09366563e+05f,  1.09390811e+05f
,	 1.09415060e+05f,  1.09439311e+05f,  1.09463562e+05f,  1.09487816e+05f
,	 1.09512070e+05f,  1.09536326e+05f,  1.09560583e+05f,  1.09584842e+05f
,	 1.09609101e+05f,  1.09633363e+05f,  1.09657625e+05f,  1.09681889e+05f
,	 1.09706154e+05f,  1.09730421e+05f,  1.09754689e+05f,  1.09778958e+05f
,	 1.09803229e+05f,  1.09827501e+05f,  1.09851774e+05f,  1.09876049e+05f
,	 1.09900325e+05f,  1.09924602e+05f,  1.09948880e+05f,  1.09973160e+05f
,	 1.09997442e+05f,  1.10021724e+05f,  1.10046008e+05f,  1.10070294e+05f
,	 1.10094580e+05f,  1.10118869e+05f,  1.10143158e+05f,  1.10167449e+05f
,	 1.10191741e+05f,  1.10216034e+05f,  1.10240329e+05f,  1.10264625e+05f
,	 1.10288922e+05f,  1.10313221e+05f,  1.10337521e+05f,  1.10361822e+05f
,	 1.10386125e+05f,  1.10410429e+05f,  1.10434735e+05f,  1.10459041e+05f
,	 1.10483350e+05f,  1.10507659e+05f,  1.10531970e+05f,  1.10556282e+05f
,	 1.10580595e+05f,  1.10604910e+05f,  1.10629226e+05f,  1.10653544e+05f
,	 1.10677862e+05f,  1.10702183e+05f,  1.10726504e+05f,  1.10750827e+05f
,	 1.10775151e+05f,  1.10799476e+05f,  1.10823803e+05f,  1.10848131e+05f
,	 1.10872461e+05f,  1.10896792e+05f,  1.10921124e+05f,  1.10945457e+05f
,	 1.10969792e+05f,  1.10994128e+05f,  1.11018466e+05f,  1.11042805e+05f
,	 1.11067145e+05f,  1.11091486e+05f,  1.11115829e+05f,  1.11140173e+05f
,	 1.11164519e+05f,  1.11188865e+05f,  1.11213214e+05f,  1.11237563e+05f
,	 1.11261914e+05f,  1.11286266e+05f,  1.11310620e+05f,  1.11334974e+05f
,	 1.11359330e+05f,  1.11383688e+05f,  1.11408047e+05f,  1.11432407e+05f
,	 1.11456768e+05f,  1.11481131e+05f,  1.11505495e+05f,  1.11529861e+05f
,	 1.11554228e+05f,  1.11578596e+05f,  1.11602965e+05f,  1.11627336e+05f
,	 1.11651708e+05f,  1.11676081e+05f,  1.11700456e+05f,  1.11724832e+05f
,	 1.11749210e+05f,  1.11773589e+05f,  1.11797969e+05f,  1.11822350e+05f
,	 1.11846733e+05f,  1.11871117e+05f,  1.11895502e+05f,  1.11919889e+05f
,	 1.11944277e+05f,  1.11968667e+05f,  1.11993057e+05f,  1.12017449e+05f
,	 1.12041843e+05f,  1.12066237e+05f,  1.12090633e+05f,  1.12115031e+05f
,	 1.12139429e+05f,  1.12163829e+05f,  1.12188231e+05f,  1.12212633e+05f
,	 1.12237037e+05f,  1.12261443e+05f,  1.12285849e+05f,  1.12310257e+05f
,	 1.12334667e+05f,  1.12359077e+05f,  1.12383489e+05f,  1.12407903e+05f
,	 1.12432317e+05f,  1.12456733e+05f,  1.12481150e+05f,  1.12505569e+05f
,	 1.12529989e+05f,  1.12554410e+05f,  1.12578833e+05f,  1.12603257e+05f
,	 1.12627682e+05f,  1.12652108e+05f,  1.12676536e+05f,  1.12700965e+05f
,	 1.12725396e+05f,  1.12749828e+05f,  1.12774261e+05f,  1.12798695e+05f
,	 1.12823131e+05f,  1.12847568e+05f,  1.12872007e+05f,  1.12896446e+05f
,	 1.12920888e+05f,  1.12945330e+05f,  1.12969774e+05f,  1.12994219e+05f
,	 1.13018665e+05f,  1.13043113e+05f,  1.13067562e+05f,  1.13092012e+05f
,	 1.13116464e+05f,  1.13140917e+05f,  1.13165371e+05f,  1.13189827e+05f
,	 1.13214284e+05f,  1.13238742e+05f,  1.13263202e+05f,  1.13287662e+05f
,	 1.13312125e+05f,  1.13336588e+05f,  1.13361053e+05f,  1.13385519e+05f
,	 1.13409987e+05f,  1.13434456e+05f,  1.13458926e+05f,  1.13483397e+05f
,	 1.13507870e+05f,  1.13532344e+05f,  1.13556820e+05f,  1.13581296e+05f
,	 1.13605774e+05f,  1.13630254e+05f,  1.13654735e+05f,  1.13679217e+05f
,	 1.13703700e+05f,  1.13728185e+05f,  1.13752671e+05f,  1.13777158e+05f
,	 1.13801646e+05f,  1.13826136e+05f,  1.13850628e+05f,  1.13875120e+05f
,	 1.13899614e+05f,  1.13924109e+05f,  1.13948606e+05f,  1.13973104e+05f
,	 1.13997603e+05f,  1.14022103e+05f,  1.14046605e+05f,  1.14071108e+05f
,	 1.14095613e+05f,  1.14120118e+05f,  1.14144625e+05f,  1.14169134e+05f
,	 1.14193643e+05f,  1.14218154e+05f,  1.14242667e+05f,  1.14267180e+05f
,	 1.14291695e+05f,  1.14316211e+05f,  1.14340729e+05f,  1.14365248e+05f
,	 1.14389768e+05f,  1.14414290e+05f,  1.14438812e+05f,  1.14463337e+05f
,	 1.14487862e+05f,  1.14512389e+05f,  1.14536917e+05f,  1.14561446e+05f
,	 1.14585977e+05f,  1.14610509e+05f,  1.14635042e+05f,  1.14659577e+05f
,	 1.14684113e+05f,  1.14708650e+05f,  1.14733189e+05f,  1.14757729e+05f
,	 1.14782270e+05f,  1.14806812e+05f,  1.14831356e+05f,  1.14855901e+05f
,	 1.14880448e+05f,  1.14904996e+05f,  1.14929545e+05f,  1.14954095e+05f
,	 1.14978647e+05f,  1.15003200e+05f,  1.15027754e+05f,  1.15052310e+05f
,	 1.15076867e+05f,  1.15101425e+05f,  1.15125984e+05f,  1.15150545e+05f
,	 1.15175107e+05f,  1.15199671e+05f,  1.15224236e+05f,  1.15248802e+05f
,	 1.15273369e+05f,  1.15297938e+05f,  1.15322508e+05f,  1.15347079e+05f
,	 1.15371652e+05f,  1.15396226e+05f,  1.15420801e+05f,  1.15445378e+05f
,	 1.15469956e+05f,  1.15494535e+05f,  1.15519115e+05f,  1.15543697e+05f
,	 1.15568280e+05f,  1.15592865e+05f,  1.15617450e+05f,  1.15642037e+05f
,	 1.15666626e+05f,  1.15691215e+05f,  1.15715806e+05f,  1.15740399e+05f
,	 1.15764992e+05f,  1.15789587e+05f,  1.15814183e+05f,  1.15838781e+05f
,	 1.15863379e+05f,  1.15887980e+05f,  1.15912581e+05f,  1.15937184e+05f
,	 1.15961788e+05f,  1.15986393e+05f,  1.16011000e+05f,  1.16035608e+05f
,	 1.16060217e+05f,  1.16084827e+05f,  1.16109439e+05f,  1.16134052e+05f
,	 1.16158667e+05f,  1.16183282e+05f,  1.16207900e+05f,  1.16232518e+05f
,	 1.16257138e+05f,  1.16281759e+05f,  1.16306381e+05f,  1.16331004e+05f
,	 1.16355629e+05f,  1.16380255e+05f,  1.16404883e+05f,  1.16429512e+05f
,	 1.16454142e+05f,  1.16478773e+05f,  1.16503406e+05f,  1.16528040e+05f
,	 1.16552675e+05f,  1.16577312e+05f,  1.16601950e+05f,  1.16626589e+05f
,	 1.16651229e+05f,  1.16675871e+05f,  1.16700514e+05f,  1.16725159e+05f
,	 1.16749804e+05f,  1.16774451e+05f,  1.16799100e+05f,  1.16823749e+05f
,	 1.16848400e+05f,  1.16873052e+05f,  1.16897706e+05f,  1.16922361e+05f
,	 1.16947017e+05f,  1.16971674e+05f,  1.16996333e+05f,  1.17020993e+05f
,	 1.17045654e+05f,  1.17070317e+05f,  1.17094981e+05f,  1.17119646e+05f
,	 1.17144313e+05f,  1.17168980e+05f,  1.17193649e+05f,  1.17218320e+05f
,	 1.17242992e+05f,  1.17267665e+05f,  1.17292339e+05f,  1.17317014e+05f
,	 1.17341691e+05f,  1.17366370e+05f,  1.17391049e+05f,  1.17415730e+05f
,	 1.17440412e+05f,  1.17465095e+05f,  1.17489780e+05f,  1.17514466e+05f
,	 1.17539153e+05f,  1.17563842e+05f,  1.17588532e+05f,  1.17613223e+05f
,	 1.17637915e+05f,  1.17662609e+05f,  1.17687304e+05f,  1.17712000e+05f
,	 1.17736698e+05f,  1.17761397e+05f,  1.17786097e+05f,  1.17810799e+05f
,	 1.17835501e+05f,  1.17860206e+05f,  1.17884911e+05f,  1.17909618e+05f
,	 1.17934326e+05f,  1.17959035e+05f,  1.17983745e+05f,  1.18008457e+05f
,	 1.18033171e+05f,  1.18057885e+05f,  1.18082601e+05f,  1.18107318e+05f
,	 1.18132036e+05f,  1.18156756e+05f,  1.18181477e+05f,  1.18206199e+05f
,	 1.18230922e+05f,  1.18255647e+05f,  1.18280373e+05f,  1.18305101e+05f
,	 1.18329829e+05f,  1.18354559e+05f,  1.18379291e+05f,  1.18404023e+05f
,	 1.18428757e+05f,  1.18453492e+05f,  1.18478229e+05f,  1.18502966e+05f
,	 1.18527705e+05f,  1.18552446e+05f,  1.18577187e+05f,  1.18601930e+05f
,	 1.18626674e+05f,  1.18651420e+05f,  1.18676167e+05f,  1.18700915e+05f
,	 1.18725664e+05f,  1.18750415e+05f,  1.18775166e+05f,  1.18799920e+05f
,	 1.18824674e+05f,  1.18849430e+05f,  1.18874187e+05f,  1.18898945e+05f
,	 1.18923705e+05f,  1.18948466e+05f,  1.18973228e+05f,  1.18997992e+05f
,	 1.19022757e+05f,  1.19047523e+05f,  1.19072290e+05f,  1.19097059e+05f
,	 1.19121829e+05f,  1.19146600e+05f,  1.19171372e+05f,  1.19196146e+05f
,	 1.19220921e+05f,  1.19245698e+05f,  1.19270475e+05f,  1.19295254e+05f
,	 1.19320035e+05f,  1.19344816e+05f,  1.19369599e+05f,  1.19394383e+05f
,	 1.19419169e+05f,  1.19443955e+05f,  1.19468743e+05f,  1.19493532e+05f
,	 1.19518323e+05f,  1.19543115e+05f,  1.19567908e+05f,  1.19592702e+05f
,	 1.19617498e+05f,  1.19642295e+05f,  1.19667093e+05f,  1.19691893e+05f
,	 1.19716694e+05f,  1.19741496e+05f,  1.19766299e+05f,  1.19791104e+05f
,	 1.19815910e+05f,  1.19840717e+05f,  1.19865526e+05f,  1.19890335e+05f
,	 1.19915146e+05f,  1.19939959e+05f,  1.19964773e+05f,  1.19989587e+05f
,	 1.20014404e+05f,  1.20039221e+05f,  1.20064040e+05f,  1.20088860e+05f
,	 1.20113681e+05f,  1.20138504e+05f,  1.20163328e+05f,  1.20188153e+05f
,	 1.20212980e+05f,  1.20237808e+05f,  1.20262637e+05f,  1.20287467e+05f
,	 1.20312299e+05f,  1.20337131e+05f,  1.20361966e+05f,  1.20386801e+05f
,	 1.20411638e+05f,  1.20436476e+05f,  1.20461315e+05f,  1.20486156e+05f
,	 1.20510998e+05f,  1.20535841e+05f,  1.20560685e+05f,  1.20585531e+05f
,	 1.20610378e+05f,  1.20635226e+05f,  1.20660076e+05f,  1.20684927e+05f
,	 1.20709779e+05f,  1.20734632e+05f,  1.20759487e+05f,  1.20784343e+05f
,	 1.20809200e+05f,  1.20834058e+05f,  1.20858918e+05f,  1.20883779e+05f
,	 1.20908641e+05f,  1.20933505e+05f,  1.20958370e+05f,  1.20983236e+05f
,	 1.21008104e+05f,  1.21032972e+05f,  1.21057842e+05f,  1.21082714e+05f
,	 1.21107586e+05f,  1.21132460e+05f,  1.21157335e+05f,  1.21182212e+05f
,	 1.21207089e+05f,  1.21231968e+05f,  1.21256848e+05f,  1.21281730e+05f
,	 1.21306613e+05f,  1.21331497e+05f,  1.21356382e+05f,  1.21381269e+05f
,	 1.21406156e+05f,  1.21431046e+05f,  1.21455936e+05f,  1.21480828e+05f
,	 1.21505721e+05f,  1.21530615e+05f,  1.21555510e+05f,  1.21580407e+05f
,	 1.21605305e+05f,  1.21630205e+05f,  1.21655105e+05f,  1.21680007e+05f
,	 1.21704910e+05f,  1.21729815e+05f,  1.21754721e+05f,  1.21779628e+05f
,	 1.21804536e+05f,  1.21829445e+05f,  1.21854356e+05f,  1.21879268e+05f
,	 1.21904182e+05f,  1.21929096e+05f,  1.21954012e+05f,  1.21978929e+05f
,	 1.22003848e+05f,  1.22028767e+05f,  1.22053688e+05f,  1.22078611e+05f
,	 1.22103534e+05f,  1.22128459e+05f,  1.22153385e+05f,  1.22178313e+05f
,	 1.22203241e+05f,  1.22228171e+05f,  1.22253102e+05f,  1.22278035e+05f
,	 1.22302968e+05f,  1.22327903e+05f,  1.22352840e+05f,  1.22377777e+05f
,	 1.22402716e+05f,  1.22427656e+05f,  1.22452597e+05f,  1.22477540e+05f
,	 1.22502484e+05f,  1.22527429e+05f,  1.22552375e+05f,  1.22577323e+05f
,	 1.22602272e+05f,  1.22627222e+05f,  1.22652174e+05f,  1.22677126e+05f
,	 1.22702080e+05f,  1.22727036e+05f,  1.22751992e+05f,  1.22776950e+05f
,	 1.22801909e+05f,  1.22826870e+05f,  1.22851831e+05f,  1.22876794e+05f
,	 1.22901758e+05f,  1.22926724e+05f,  1.22951691e+05f,  1.22976659e+05f
,	 1.23001628e+05f,  1.23026598e+05f,  1.23051570e+05f,  1.23076543e+05f
,	 1.23101517e+05f,  1.23126493e+05f,  1.23151470e+05f,  1.23176448e+05f
,	 1.23201427e+05f,  1.23226408e+05f,  1.23251390e+05f,  1.23276373e+05f
,	 1.23301358e+05f,  1.23326343e+05f,  1.23351330e+05f,  1.23376318e+05f
,	 1.23401308e+05f,  1.23426299e+05f,  1.23451291e+05f,  1.23476284e+05f
,	 1.23501279e+05f,  1.23526274e+05f,  1.23551272e+05f,  1.23576270e+05f
,	 1.23601270e+05f,  1.23626270e+05f,  1.23651273e+05f,  1.23676276e+05f
,	 1.23701281e+05f,  1.23726287e+05f,  1.23751294e+05f,  1.23776302e+05f
,	 1.23801312e+05f,  1.23826323e+05f,  1.23851335e+05f,  1.23876349e+05f
,	 1.23901364e+05f,  1.23926380e+05f,  1.23951397e+05f,  1.23976416e+05f
,	 1.24001435e+05f,  1.24026456e+05f,  1.24051479e+05f,  1.24076502e+05f
,	 1.24101527e+05f,  1.24126554e+05f,  1.24151581e+05f,  1.24176610e+05f
,	 1.24201640e+05f,  1.24226671e+05f,  1.24251703e+05f,  1.24276737e+05f
,	 1.24301772e+05f,  1.24326808e+05f,  1.24351846e+05f,  1.24376884e+05f
,	 1.24401924e+05f,  1.24426966e+05f,  1.24452008e+05f,  1.24477052e+05f
,	 1.24502097e+05f,  1.24527143e+05f,  1.24552191e+05f,  1.24577240e+05f
,	 1.24602290e+05f,  1.24627341e+05f,  1.24652394e+05f,  1.24677448e+05f
,	 1.24702503e+05f,  1.24727559e+05f,  1.24752617e+05f,  1.24777676e+05f
,	 1.24802736e+05f,  1.24827797e+05f,  1.24852860e+05f,  1.24877924e+05f
,	 1.24902989e+05f,  1.24928056e+05f,  1.24953123e+05f,  1.24978192e+05f
,	 1.25003262e+05f,  1.25028334e+05f,  1.25053407e+05f,  1.25078481e+05f
,	 1.25103556e+05f,  1.25128632e+05f,  1.25153710e+05f,  1.25178789e+05f
,	 1.25203869e+05f,  1.25228951e+05f,  1.25254034e+05f,  1.25279118e+05f
,	 1.25304203e+05f,  1.25329290e+05f,  1.25354377e+05f,  1.25379467e+05f
,	 1.25404557e+05f,  1.25429648e+05f,  1.25454741e+05f,  1.25479835e+05f
,	 1.25504931e+05f,  1.25530027e+05f,  1.25555125e+05f,  1.25580224e+05f
,	 1.25605325e+05f,  1.25630426e+05f,  1.25655529e+05f,  1.25680633e+05f
,	 1.25705739e+05f,  1.25730845e+05f,  1.25755953e+05f,  1.25781062e+05f
,	 1.25806173e+05f,  1.25831284e+05f,  1.25856397e+05f,  1.25881511e+05f
,	 1.25906627e+05f,  1.25931743e+05f,  1.25956861e+05f,  1.25981980e+05f
,	 1.26007101e+05f,  1.26032222e+05f,  1.26057345e+05f,  1.26082470e+05f
,	 1.26107595e+05f,  1.26132722e+05f,  1.26157850e+05f,  1.26182979e+05f
,	 1.26208109e+05f,  1.26233241e+05f,  1.26258374e+05f,  1.26283508e+05f
,	 1.26308643e+05f,  1.26333780e+05f,  1.26358918e+05f,  1.26384057e+05f
,	 1.26409197e+05f,  1.26434339e+05f,  1.26459482e+05f,  1.26484626e+05f
,	 1.26509772e+05f,  1.26534918e+05f,  1.26560066e+05f,  1.26585215e+05f
,	 1.26610366e+05f,  1.26635518e+05f,  1.26660670e+05f,  1.26685825e+05f
,	 1.26710980e+05f,  1.26736137e+05f,  1.26761295e+05f,  1.26786454e+05f
,	 1.26811614e+05f,  1.26836776e+05f,  1.26861939e+05f,  1.26887103e+05f
,	 1.26912268e+05f,  1.26937435e+05f,  1.26962603e+05f,  1.26987772e+05f
,	 1.27012942e+05f,  1.27038114e+05f,  1.27063287e+05f,  1.27088461e+05f
,	 1.27113636e+05f,  1.27138813e+05f,  1.27163991e+05f,  1.27189170e+05f
,	 1.27214350e+05f,  1.27239532e+05f,  1.27264715e+05f,  1.27289899e+05f
,	 1.27315084e+05f,  1.27340271e+05f,  1.27365459e+05f,  1.27390648e+05f
,	 1.27415838e+05f,  1.27441030e+05f,  1.27466223e+05f,  1.27491417e+05f
,	 1.27516612e+05f,  1.27541809e+05f,  1.27567006e+05f,  1.27592205e+05f
,	 1.27617406e+05f,  1.27642607e+05f,  1.27667810e+05f,  1.27693014e+05f
,	 1.27718219e+05f,  1.27743426e+05f,  1.27768633e+05f,  1.27793842e+05f
,	 1.27819053e+05f,  1.27844264e+05f,  1.27869477e+05f,  1.27894691e+05f
,	 1.27919906e+05f,  1.27945123e+05f,  1.27970340e+05f,  1.27995559e+05f
,	 1.28020779e+05f,  1.28046001e+05f,  1.28071223e+05f,  1.28096447e+05f
,	 1.28121672e+05f,  1.28146899e+05f,  1.28172127e+05f,  1.28197355e+05f
,	 1.28222585e+05f,  1.28247817e+05f,  1.28273049e+05f,  1.28298283e+05f
,	 1.28323518e+05f,  1.28348755e+05f,  1.28373992e+05f,  1.28399231e+05f
,	 1.28424471e+05f,  1.28449712e+05f,  1.28474955e+05f,  1.28500199e+05f
,	 1.28525444e+05f,  1.28550690e+05f,  1.28575937e+05f,  1.28601186e+05f
,	 1.28626436e+05f,  1.28651687e+05f,  1.28676940e+05f,  1.28702193e+05f
,	 1.28727448e+05f,  1.28752704e+05f,  1.28777962e+05f,  1.28803220e+05f
,	 1.28828480e+05f,  1.28853741e+05f,  1.28879004e+05f,  1.28904267e+05f
,	 1.28929532e+05f,  1.28954798e+05f,  1.28980065e+05f,  1.29005334e+05f
,	 1.29030604e+05f,  1.29055875e+05f,  1.29081147e+05f,  1.29106420e+05f
,	 1.29131695e+05f,  1.29156971e+05f,  1.29182248e+05f,  1.29207527e+05f
,	 1.29232806e+05f,  1.29258087e+05f,  1.29283369e+05f,  1.29308653e+05f
,	 1.29333937e+05f,  1.29359223e+05f,  1.29384510e+05f,  1.29409799e+05f
,	 1.29435088e+05f,  1.29460379e+05f,  1.29485671e+05f,  1.29510964e+05f
,	 1.29536259e+05f,  1.29561555e+05f,  1.29586852e+05f,  1.29612150e+05f
,	 1.29637449e+05f,  1.29662750e+05f,  1.29688052e+05f,  1.29713355e+05f
,	 1.29738659e+05f,  1.29763965e+05f,  1.29789272e+05f,  1.29814580e+05f
,	 1.29839889e+05f,  1.29865200e+05f,  1.29890511e+05f,  1.29915824e+05f
,	 1.29941139e+05f,  1.29966454e+05f,  1.29991771e+05f,  1.30017089e+05f
,	 1.30042408e+05f,  1.30067728e+05f,  1.30093050e+05f,  1.30118373e+05f
,	 1.30143697e+05f,  1.30169022e+05f,  1.30194349e+05f,  1.30219677e+05f
,	 1.30245006e+05f,  1.30270336e+05f,  1.30295667e+05f,  1.30321000e+05f
,	 1.30346334e+05f,  1.30371669e+05f,  1.30397006e+05f,  1.30422343e+05f
,	 1.30447682e+05f,  1.30473022e+05f,  1.30498363e+05f,  1.30523706e+05f
,	 1.30549050e+05f,  1.30574395e+05f,  1.30599741e+05f,  1.30625089e+05f
,	 1.30650437e+05f,  1.30675787e+05f,  1.30701138e+05f,  1.30726491e+05f
,	 1.30751844e+05f,  1.30777199e+05f,  1.30802555e+05f,  1.30827913e+05f
,	 1.30853271e+05f,  1.30878631e+05f,  1.30903992e+05f,  1.30929354e+05f
,	 1.30954718e+05f,  1.30980082e+05f,  1.31005448e+05f,  1.31030816e+05f
,	 1.31056184e+05f,  1.31081553e+05f,  1.31106924e+05f,  1.31132296e+05f
,	 1.31157670e+05f,  1.31183044e+05f,  1.31208420e+05f,  1.31233797e+05f
,	 1.31259175e+05f,  1.31284554e+05f,  1.31309935e+05f,  1.31335317e+05f
,	 1.31360700e+05f,  1.31386084e+05f,  1.31411470e+05f,  1.31436857e+05f
,	 1.31462245e+05f,  1.31487634e+05f,  1.31513024e+05f,  1.31538416e+05f
,	 1.31563809e+05f,  1.31589203e+05f,  1.31614598e+05f,  1.31639995e+05f
,	 1.31665393e+05f,  1.31690792e+05f,  1.31716192e+05f,  1.31741594e+05f
,	 1.31766996e+05f,  1.31792400e+05f,  1.31817805e+05f,  1.31843212e+05f
,	 1.31868619e+05f,  1.31894028e+05f,  1.31919438e+05f,  1.31944850e+05f
,	 1.31970262e+05f,  1.31995676e+05f,  1.32021091e+05f,  1.32046507e+05f
,	 1.32071924e+05f,  1.32097343e+05f,  1.32122763e+05f,  1.32148184e+05f
,	 1.32173606e+05f,  1.32199030e+05f,  1.32224454e+05f,  1.32249880e+05f
,	 1.32275307e+05f,  1.32300736e+05f,  1.32326165e+05f,  1.32351596e+05f
,	 1.32377028e+05f,  1.32402462e+05f,  1.32427896e+05f,  1.32453332e+05f
,	 1.32478769e+05f,  1.32504207e+05f,  1.32529646e+05f,  1.32555087e+05f
,	 1.32580529e+05f,  1.32605972e+05f,  1.32631416e+05f,  1.32656861e+05f
,	 1.32682308e+05f,  1.32707756e+05f,  1.32733205e+05f,  1.32758656e+05f
,	 1.32784107e+05f,  1.32809560e+05f,  1.32835014e+05f,  1.32860469e+05f
,	 1.32885926e+05f,  1.32911383e+05f,  1.32936842e+05f,  1.32962302e+05f
,	 1.32987764e+05f,  1.33013226e+05f,  1.33038690e+05f,  1.33064155e+05f
,	 1.33089621e+05f,  1.33115089e+05f,  1.33140557e+05f,  1.33166027e+05f
,	 1.33191498e+05f,  1.33216971e+05f,  1.33242444e+05f,  1.33267919e+05f
,	 1.33293395e+05f,  1.33318872e+05f,  1.33344350e+05f,  1.33369830e+05f
,	 1.33395311e+05f,  1.33420793e+05f,  1.33446276e+05f,  1.33471761e+05f
,	 1.33497246e+05f,  1.33522733e+05f,  1.33548221e+05f,  1.33573711e+05f
,	 1.33599201e+05f,  1.33624693e+05f,  1.33650186e+05f,  1.33675680e+05f
,	 1.33701176e+05f,  1.33726672e+05f,  1.33752170e+05f,  1.33777669e+05f
,	 1.33803170e+05f,  1.33828671e+05f,  1.33854174e+05f,  1.33879678e+05f
,	 1.33905183e+05f,  1.33930689e+05f,  1.33956197e+05f,  1.33981706e+05f
,	 1.34007216e+05f,  1.34032727e+05f,  1.34058239e+05f,  1.34083753e+05f
,	 1.34109268e+05f,  1.34134784e+05f,  1.34160301e+05f,  1.34185819e+05f
,	 1.34211339e+05f,  1.34236860e+05f,  1.34262382e+05f,  1.34287906e+05f
,	 1.34313430e+05f,  1.34338956e+05f,  1.34364483e+05f,  1.34390011e+05f
,	 1.34415541e+05f,  1.34441071e+05f,  1.34466603e+05f,  1.34492136e+05f
,	 1.34517670e+05f,  1.34543206e+05f,  1.34568742e+05f,  1.34594280e+05f
,	 1.34619819e+05f,  1.34645360e+05f,  1.34670901e+05f,  1.34696444e+05f
,	 1.34721988e+05f,  1.34747533e+05f,  1.34773080e+05f,  1.34798627e+05f
,	 1.34824176e+05f,  1.34849726e+05f,  1.34875277e+05f,  1.34900830e+05f
,	 1.34926383e+05f,  1.34951938e+05f,  1.34977494e+05f,  1.35003051e+05f
,	 1.35028610e+05f,  1.35054169e+05f,  1.35079730e+05f,  1.35105292e+05f
,	 1.35130856e+05f,  1.35156420e+05f,  1.35181986e+05f,  1.35207553e+05f
,	 1.35233121e+05f,  1.35258690e+05f,  1.35284261e+05f,  1.35309833e+05f
,	 1.35335406e+05f,  1.35360980e+05f,  1.35386555e+05f,  1.35412132e+05f
,	 1.35437710e+05f,  1.35463289e+05f,  1.35488869e+05f,  1.35514450e+05f
,	 1.35540033e+05f,  1.35565617e+05f,  1.35591202e+05f,  1.35616788e+05f
,	 1.35642376e+05f,  1.35667964e+05f,  1.35693554e+05f,  1.35719145e+05f
,	 1.35744738e+05f,  1.35770331e+05f,  1.35795926e+05f,  1.35821522e+05f
,	 1.35847119e+05f,  1.35872717e+05f,  1.35898317e+05f,  1.35923918e+05f
,	 1.35949519e+05f,  1.35975123e+05f,  1.36000727e+05f,  1.36026333e+05f
,	 1.36051939e+05f,  1.36077547e+05f,  1.36103156e+05f,  1.36128767e+05f
,	 1.36154378e+05f,  1.36179991e+05f,  1.36205605e+05f,  1.36231220e+05f
,	 1.36256837e+05f,  1.36282454e+05f,  1.36308073e+05f,  1.36333693e+05f
,	 1.36359314e+05f,  1.36384937e+05f,  1.36410560e+05f,  1.36436185e+05f
,	 1.36461811e+05f,  1.36487439e+05f,  1.36513067e+05f,  1.36538697e+05f
,	 1.36564327e+05f,  1.36589960e+05f,  1.36615593e+05f,  1.36641227e+05f
,	 1.36666863e+05f,  1.36692500e+05f,  1.36718138e+05f,  1.36743777e+05f
,	 1.36769418e+05f,  1.36795059e+05f,  1.36820702e+05f,  1.36846346e+05f
,	 1.36871991e+05f,  1.36897638e+05f,  1.36923285e+05f,  1.36948934e+05f
,	 1.36974584e+05f,  1.37000236e+05f,  1.37025888e+05f,  1.37051542e+05f
,	 1.37077197e+05f,  1.37102853e+05f,  1.37128510e+05f,  1.37154169e+05f
,	 1.37179828e+05f,  1.37205489e+05f,  1.37231151e+05f,  1.37256814e+05f
,	 1.37282479e+05f,  1.37308145e+05f,  1.37333811e+05f,  1.37359480e+05f
,	 1.37385149e+05f,  1.37410819e+05f,  1.37436491e+05f,  1.37462164e+05f
,	 1.37487838e+05f,  1.37513513e+05f,  1.37539190e+05f,  1.37564867e+05f
,	 1.37590546e+05f,  1.37616226e+05f,  1.37641907e+05f,  1.37667590e+05f
,	 1.37693274e+05f,  1.37718958e+05f,  1.37744644e+05f,  1.37770332e+05f
,	 1.37796020e+05f,  1.37821710e+05f,  1.37847401e+05f,  1.37873093e+05f
,	 1.37898786e+05f,  1.37924480e+05f,  1.37950176e+05f,  1.37975873e+05f
,	 1.38001571e+05f,  1.38027270e+05f,  1.38052970e+05f,  1.38078672e+05f
,	 1.38104375e+05f,  1.38130079e+05f,  1.38155784e+05f,  1.38181490e+05f
,	 1.38207198e+05f,  1.38232907e+05f,  1.38258617e+05f,  1.38284328e+05f
,	 1.38310040e+05f,  1.38335754e+05f,  1.38361469e+05f,  1.38387185e+05f
,	 1.38412902e+05f,  1.38438620e+05f,  1.38464340e+05f,  1.38490060e+05f
,	 1.38515782e+05f,  1.38541505e+05f,  1.38567230e+05f,  1.38592955e+05f
,	 1.38618682e+05f,  1.38644410e+05f,  1.38670139e+05f,  1.38695869e+05f
,	 1.38721601e+05f,  1.38747333e+05f,  1.38773067e+05f,  1.38798802e+05f
,	 1.38824538e+05f,  1.38850276e+05f,  1.38876015e+05f,  1.38901754e+05f
,	 1.38927495e+05f,  1.38953238e+05f,  1.38978981e+05f,  1.39004726e+05f
,	 1.39030471e+05f,  1.39056218e+05f,  1.39081967e+05f,  1.39107716e+05f
,	 1.39133466e+05f,  1.39159218e+05f,  1.39184971e+05f,  1.39210725e+05f
,	 1.39236481e+05f,  1.39262237e+05f,  1.39287995e+05f,  1.39313754e+05f
,	 1.39339514e+05f,  1.39365275e+05f,  1.39391038e+05f,  1.39416801e+05f
,	 1.39442566e+05f,  1.39468332e+05f,  1.39494099e+05f,  1.39519868e+05f
,	 1.39545637e+05f,  1.39571408e+05f,  1.39597180e+05f,  1.39622953e+05f
,	 1.39648728e+05f,  1.39674503e+05f,  1.39700280e+05f,  1.39726058e+05f
,	 1.39751837e+05f,  1.39777617e+05f,  1.39803399e+05f,  1.39829181e+05f
,	 1.39854965e+05f,  1.39880750e+05f,  1.39906537e+05f,  1.39932324e+05f
,	 1.39958113e+05f,  1.39983903e+05f,  1.40009694e+05f,  1.40035486e+05f
,	 1.40061279e+05f,  1.40087074e+05f,  1.40112869e+05f,  1.40138666e+05f
,	 1.40164465e+05f,  1.40190264e+05f,  1.40216064e+05f,  1.40241866e+05f
,	 1.40267669e+05f,  1.40293473e+05f,  1.40319278e+05f,  1.40345085e+05f
,	 1.40370892e+05f,  1.40396701e+05f,  1.40422511e+05f,  1.40448322e+05f
,	 1.40474135e+05f,  1.40499948e+05f,  1.40525763e+05f,  1.40551579e+05f
,	 1.40577396e+05f,  1.40603214e+05f,  1.40629034e+05f,  1.40654854e+05f
,	 1.40680676e+05f,  1.40706499e+05f,  1.40732324e+05f,  1.40758149e+05f
,	 1.40783976e+05f,  1.40809803e+05f,  1.40835632e+05f,  1.40861462e+05f
,	 1.40887294e+05f,  1.40913126e+05f,  1.40938960e+05f,  1.40964795e+05f
,	 1.40990631e+05f,  1.41016468e+05f,  1.41042307e+05f,  1.41068146e+05f
,	 1.41093987e+05f,  1.41119829e+05f,  1.41145672e+05f,  1.41171516e+05f
,	 1.41197362e+05f,  1.41223209e+05f,  1.41249057e+05f,  1.41274906e+05f
,	 1.41300756e+05f,  1.41326607e+05f,  1.41352460e+05f,  1.41378314e+05f
,	 1.41404169e+05f,  1.41430025e+05f,  1.41455882e+05f,  1.41481741e+05f
,	 1.41507601e+05f,  1.41533461e+05f,  1.41559324e+05f,  1.41585187e+05f
,	 1.41611051e+05f,  1.41636917e+05f,  1.41662784e+05f,  1.41688652e+05f
,	 1.41714521e+05f,  1.41740391e+05f,  1.41766263e+05f,  1.41792135e+05f
,	 1.41818009e+05f,  1.41843884e+05f,  1.41869761e+05f,  1.41895638e+05f
,	 1.41921517e+05f,  1.41947396e+05f,  1.41973277e+05f,  1.41999160e+05f
,	 1.42025043e+05f,  1.42050927e+05f,  1.42076813e+05f,  1.42102700e+05f
,	 1.42128588e+05f,  1.42154477e+05f,  1.42180368e+05f,  1.42206259e+05f
,	 1.42232152e+05f,  1.42258046e+05f,  1.42283941e+05f,  1.42309837e+05f
,	 1.42335735e+05f,  1.42361633e+05f,  1.42387533e+05f,  1.42413434e+05f
,	 1.42439336e+05f,  1.42465240e+05f,  1.42491144e+05f,  1.42517050e+05f
,	 1.42542957e+05f,  1.42568865e+05f,  1.42594774e+05f,  1.42620685e+05f
,	 1.42646596e+05f,  1.42672509e+05f,  1.42698423e+05f,  1.42724338e+05f
,	 1.42750254e+05f,  1.42776172e+05f,  1.42802091e+05f,  1.42828010e+05f
,	 1.42853931e+05f,  1.42879854e+05f,  1.42905777e+05f,  1.42931701e+05f
,	 1.42957627e+05f,  1.42983554e+05f,  1.43009482e+05f,  1.43035411e+05f
,	 1.43061342e+05f,  1.43087273e+05f,  1.43113206e+05f,  1.43139140e+05f
,	 1.43165075e+05f,  1.43191012e+05f,  1.43216949e+05f,  1.43242888e+05f
,	 1.43268827e+05f,  1.43294768e+05f,  1.43320711e+05f,  1.43346654e+05f
,	 1.43372598e+05f,  1.43398544e+05f,  1.43424491e+05f,  1.43450439e+05f
,	 1.43476388e+05f,  1.43502339e+05f,  1.43528290e+05f,  1.43554243e+05f
,	 1.43580197e+05f,  1.43606152e+05f,  1.43632108e+05f,  1.43658065e+05f
,	 1.43684024e+05f,  1.43709984e+05f,  1.43735945e+05f,  1.43761907e+05f
,	 1.43787870e+05f,  1.43813835e+05f,  1.43839800e+05f,  1.43865767e+05f
,	 1.43891735e+05f,  1.43917704e+05f,  1.43943674e+05f,  1.43969646e+05f
,	 1.43995619e+05f,  1.44021592e+05f,  1.44047567e+05f,  1.44073543e+05f
,	 1.44099521e+05f,  1.44125499e+05f,  1.44151479e+05f,  1.44177460e+05f
,	 1.44203442e+05f,  1.44229425e+05f,  1.44255409e+05f,  1.44281395e+05f
,	 1.44307382e+05f,  1.44333370e+05f,  1.44359359e+05f,  1.44385349e+05f
,	 1.44411340e+05f,  1.44437333e+05f,  1.44463326e+05f,  1.44489321e+05f
,	 1.44515317e+05f,  1.44541315e+05f,  1.44567313e+05f,  1.44593313e+05f
,	 1.44619313e+05f,  1.44645315e+05f,  1.44671318e+05f,  1.44697322e+05f
,	 1.44723328e+05f,  1.44749334e+05f,  1.44775342e+05f,  1.44801351e+05f
,	 1.44827361e+05f,  1.44853372e+05f,  1.44879385e+05f,  1.44905398e+05f
,	 1.44931413e+05f,  1.44957429e+05f,  1.44983446e+05f,  1.45009464e+05f
,	 1.45035484e+05f,  1.45061504e+05f,  1.45087526e+05f,  1.45113549e+05f
,	 1.45139573e+05f,  1.45165598e+05f,  1.45191625e+05f,  1.45217652e+05f
,	 1.45243681e+05f,  1.45269711e+05f,  1.45295742e+05f,  1.45321774e+05f
,	 1.45347808e+05f,  1.45373842e+05f,  1.45399878e+05f,  1.45425915e+05f
,	 1.45451953e+05f,  1.45477992e+05f,  1.45504033e+05f,  1.45530074e+05f
,	 1.45556117e+05f,  1.45582161e+05f,  1.45608206e+05f,  1.45634252e+05f
,	 1.45660300e+05f,  1.45686348e+05f,  1.45712398e+05f,  1.45738449e+05f
,	 1.45764501e+05f,  1.45790554e+05f,  1.45816609e+05f,  1.45842664e+05f
,	 1.45868721e+05f,  1.45894779e+05f,  1.45920838e+05f,  1.45946898e+05f
,	 1.45972959e+05f,  1.45999022e+05f,  1.46025085e+05f,  1.46051150e+05f
,	 1.46077216e+05f,  1.46103284e+05f,  1.46129352e+05f,  1.46155421e+05f
,	 1.46181492e+05f,  1.46207564e+05f,  1.46233637e+05f,  1.46259711e+05f
,	 1.46285786e+05f,  1.46311863e+05f,  1.46337940e+05f,  1.46364019e+05f
,	 1.46390099e+05f,  1.46416180e+05f,  1.46442263e+05f,  1.46468346e+05f
,	 1.46494431e+05f,  1.46520516e+05f,  1.46546603e+05f,  1.46572691e+05f
,	 1.46598781e+05f,  1.46624871e+05f,  1.46650963e+05f,  1.46677055e+05f
,	 1.46703149e+05f,  1.46729244e+05f,  1.46755341e+05f,  1.46781438e+05f
,	 1.46807537e+05f,  1.46833636e+05f,  1.46859737e+05f,  1.46885839e+05f
,	 1.46911942e+05f,  1.46938047e+05f,  1.46964152e+05f,  1.46990259e+05f
,	 1.47016367e+05f,  1.47042476e+05f,  1.47068586e+05f,  1.47094697e+05f
,	 1.47120809e+05f,  1.47146923e+05f,  1.47173038e+05f,  1.47199154e+05f
,	 1.47225271e+05f,  1.47251389e+05f,  1.47277508e+05f,  1.47303629e+05f
,	 1.47329751e+05f,  1.47355874e+05f,  1.47381998e+05f,  1.47408123e+05f
,	 1.47434249e+05f,  1.47460377e+05f,  1.47486505e+05f,  1.47512635e+05f
,	 1.47538766e+05f,  1.47564898e+05f,  1.47591032e+05f,  1.47617166e+05f
,	 1.47643302e+05f,  1.47669438e+05f,  1.47695576e+05f,  1.47721715e+05f
,	 1.47747856e+05f,  1.47773997e+05f,  1.47800140e+05f,  1.47826283e+05f
,	 1.47852428e+05f,  1.47878574e+05f,  1.47904721e+05f,  1.47930870e+05f
,	 1.47957019e+05f,  1.47983170e+05f,  1.48009322e+05f,  1.48035474e+05f
,	 1.48061629e+05f,  1.48087784e+05f,  1.48113940e+05f,  1.48140098e+05f
,	 1.48166257e+05f,  1.48192416e+05f,  1.48218577e+05f,  1.48244740e+05f
,	 1.48270903e+05f,  1.48297067e+05f,  1.48323233e+05f,  1.48349400e+05f
,	 1.48375568e+05f,  1.48401737e+05f,  1.48427907e+05f,  1.48454079e+05f
,	 1.48480251e+05f,  1.48506425e+05f,  1.48532600e+05f,  1.48558776e+05f
,	 1.48584953e+05f,  1.48611131e+05f,  1.48637311e+05f,  1.48663491e+05f
,	 1.48689673e+05f,  1.48715856e+05f,  1.48742040e+05f,  1.48768226e+05f
,	 1.48794412e+05f,  1.48820599e+05f,  1.48846788e+05f,  1.48872978e+05f
,	 1.48899169e+05f,  1.48925361e+05f,  1.48951555e+05f,  1.48977749e+05f
,	 1.49003945e+05f,  1.49030141e+05f,  1.49056339e+05f,  1.49082538e+05f
,	 1.49108739e+05f,  1.49134940e+05f,  1.49161143e+05f,  1.49187346e+05f
,	 1.49213551e+05f,  1.49239757e+05f,  1.49265964e+05f,  1.49292172e+05f
,	 1.49318382e+05f,  1.49344592e+05f,  1.49370804e+05f,  1.49397017e+05f
,	 1.49423231e+05f,  1.49449446e+05f,  1.49475663e+05f,  1.49501880e+05f
,	 1.49528099e+05f,  1.49554318e+05f,  1.49580539e+05f,  1.49606761e+05f
,	 1.49632985e+05f,  1.49659209e+05f,  1.49685435e+05f,  1.49711661e+05f
,	 1.49737889e+05f,  1.49764118e+05f,  1.49790348e+05f,  1.49816579e+05f
,	 1.49842812e+05f,  1.49869045e+05f,  1.49895280e+05f,  1.49921516e+05f
,	 1.49947753e+05f,  1.49973991e+05f,  1.50000230e+05f,  1.50026471e+05f
,	 1.50052712e+05f,  1.50078955e+05f,  1.50105199e+05f,  1.50131444e+05f
,	 1.50157690e+05f,  1.50183938e+05f,  1.50210186e+05f,  1.50236436e+05f
,	 1.50262686e+05f,  1.50288938e+05f,  1.50315191e+05f,  1.50341446e+05f
,	 1.50367701e+05f,  1.50393957e+05f,  1.50420215e+05f,  1.50446474e+05f
,	 1.50472734e+05f,  1.50498995e+05f,  1.50525257e+05f,  1.50551521e+05f
,	 1.50577785e+05f,  1.50604051e+05f,  1.50630318e+05f,  1.50656585e+05f
,	 1.50682855e+05f,  1.50709125e+05f,  1.50735396e+05f,  1.50761669e+05f
,	 1.50787942e+05f,  1.50814217e+05f,  1.50840493e+05f,  1.50866770e+05f
,	 1.50893049e+05f,  1.50919328e+05f,  1.50945609e+05f,  1.50971890e+05f
,	 1.50998173e+05f,  1.51024457e+05f,  1.51050742e+05f,  1.51077028e+05f
,	 1.51103316e+05f,  1.51129604e+05f,  1.51155894e+05f,  1.51182185e+05f
,	 1.51208477e+05f,  1.51234770e+05f,  1.51261064e+05f,  1.51287360e+05f
,	 1.51313656e+05f,  1.51339954e+05f,  1.51366253e+05f,  1.51392553e+05f
,	 1.51418854e+05f,  1.51445156e+05f,  1.51471460e+05f,  1.51497764e+05f
,	 1.51524070e+05f,  1.51550377e+05f,  1.51576685e+05f,  1.51602994e+05f
,	 1.51629304e+05f,  1.51655615e+05f,  1.51681928e+05f,  1.51708242e+05f
,	 1.51734556e+05f,  1.51760872e+05f,  1.51787190e+05f,  1.51813508e+05f
,	 1.51839827e+05f,  1.51866148e+05f,  1.51892469e+05f,  1.51918792e+05f
,	 1.51945116e+05f,  1.51971441e+05f,  1.51997767e+05f,  1.52024095e+05f
,	 1.52050423e+05f,  1.52076753e+05f,  1.52103084e+05f,  1.52129416e+05f
,	 1.52155749e+05f,  1.52182083e+05f,  1.52208418e+05f,  1.52234755e+05f
,	 1.52261092e+05f,  1.52287431e+05f,  1.52313771e+05f,  1.52340112e+05f
,	 1.52366454e+05f,  1.52392798e+05f,  1.52419142e+05f,  1.52445488e+05f
,	 1.52471834e+05f,  1.52498182e+05f,  1.52524531e+05f,  1.52550881e+05f
,	 1.52577233e+05f,  1.52603585e+05f,  1.52629939e+05f,  1.52656293e+05f
,	 1.52682649e+05f,  1.52709006e+05f,  1.52735364e+05f,  1.52761724e+05f
,	 1.52788084e+05f,  1.52814445e+05f,  1.52840808e+05f,  1.52867172e+05f
,	 1.52893537e+05f,  1.52919903e+05f,  1.52946270e+05f,  1.52972638e+05f
,	 1.52999008e+05f,  1.53025379e+05f,  1.53051750e+05f,  1.53078123e+05f
,	 1.53104497e+05f,  1.53130872e+05f,  1.53157249e+05f,  1.53183626e+05f
,	 1.53210005e+05f,  1.53236384e+05f,  1.53262765e+05f,  1.53289147e+05f
,	 1.53315530e+05f,  1.53341914e+05f,  1.53368300e+05f,  1.53394686e+05f
,	 1.53421074e+05f,  1.53447463e+05f,  1.53473853e+05f,  1.53500244e+05f
,	 1.53526636e+05f,  1.53553029e+05f,  1.53579424e+05f,  1.53605819e+05f
,	 1.53632216e+05f,  1.53658614e+05f,  1.53685013e+05f,  1.53711413e+05f
,	 1.53737814e+05f,  1.53764217e+05f,  1.53790620e+05f,  1.53817025e+05f
,	 1.53843431e+05f,  1.53869838e+05f,  1.53896246e+05f,  1.53922655e+05f
,	 1.53949065e+05f,  1.53975477e+05f,  1.54001889e+05f,  1.54028303e+05f
,	 1.54054718e+05f,  1.54081134e+05f,  1.54107551e+05f,  1.54133969e+05f
,	 1.54160388e+05f,  1.54186809e+05f,  1.54213231e+05f,  1.54239653e+05f
,	 1.54266077e+05f,  1.54292502e+05f,  1.54318929e+05f,  1.54345356e+05f
,	 1.54371784e+05f,  1.54398214e+05f,  1.54424645e+05f,  1.54451076e+05f
,	 1.54477509e+05f,  1.54503943e+05f,  1.54530379e+05f,  1.54556815e+05f
,	 1.54583252e+05f,  1.54609691e+05f,  1.54636131e+05f,  1.54662572e+05f
,	 1.54689014e+05f,  1.54715457e+05f,  1.54741901e+05f,  1.54768346e+05f
,	 1.54794793e+05f,  1.54821241e+05f,  1.54847689e+05f,  1.54874139e+05f
,	 1.54900590e+05f,  1.54927043e+05f,  1.54953496e+05f,  1.54979950e+05f
,	 1.55006406e+05f,  1.55032862e+05f,  1.55059320e+05f,  1.55085779e+05f
,	 1.55112239e+05f,  1.55138700e+05f,  1.55165163e+05f,  1.55191626e+05f
,	 1.55218091e+05f,  1.55244557e+05f,  1.55271023e+05f,  1.55297491e+05f
,	 1.55323960e+05f,  1.55350431e+05f,  1.55376902e+05f,  1.55403375e+05f
,	 1.55429848e+05f,  1.55456323e+05f,  1.55482799e+05f,  1.55509276e+05f
,	 1.55535754e+05f,  1.55562233e+05f,  1.55588713e+05f,  1.55615195e+05f
,	 1.55641678e+05f,  1.55668161e+05f,  1.55694646e+05f,  1.55721132e+05f
,	 1.55747619e+05f,  1.55774108e+05f,  1.55800597e+05f,  1.55827087e+05f
,	 1.55853579e+05f,  1.55880072e+05f,  1.55906566e+05f,  1.55933061e+05f
,	 1.55959557e+05f,  1.55986054e+05f,  1.56012552e+05f,  1.56039052e+05f
,	 1.56065553e+05f,  1.56092054e+05f,  1.56118557e+05f,  1.56145061e+05f
,	 1.56171566e+05f,  1.56198073e+05f,  1.56224580e+05f,  1.56251089e+05f
,	 1.56277598e+05f,  1.56304109e+05f,  1.56330621e+05f,  1.56357134e+05f
,	 1.56383648e+05f,  1.56410163e+05f,  1.56436680e+05f,  1.56463197e+05f
,	 1.56489716e+05f,  1.56516235e+05f,  1.56542756e+05f,  1.56569278e+05f
,	 1.56595801e+05f,  1.56622326e+05f,  1.56648851e+05f,  1.56675378e+05f
,	 1.56701905e+05f,  1.56728434e+05f,  1.56754964e+05f,  1.56781495e+05f
,	 1.56808027e+05f,  1.56834560e+05f,  1.56861094e+05f,  1.56887630e+05f
,	 1.56914166e+05f,  1.56940704e+05f,  1.56967243e+05f,  1.56993783e+05f
,	 1.57020324e+05f,  1.57046866e+05f,  1.57073410e+05f,  1.57099954e+05f
,	 1.57126500e+05f,  1.57153046e+05f,  1.57179594e+05f,  1.57206143e+05f
,	 1.57232693e+05f,  1.57259244e+05f,  1.57285796e+05f,  1.57312350e+05f
,	 1.57338904e+05f,  1.57365460e+05f,  1.57392017e+05f,  1.57418575e+05f
,	 1.57445134e+05f,  1.57471694e+05f,  1.57498255e+05f,  1.57524817e+05f
,	 1.57551381e+05f,  1.57577946e+05f,  1.57604511e+05f,  1.57631078e+05f
,	 1.57657646e+05f,  1.57684215e+05f,  1.57710785e+05f,  1.57737357e+05f
,	 1.57763929e+05f,  1.57790503e+05f,  1.57817077e+05f,  1.57843653e+05f
,	 1.57870230e+05f,  1.57896808e+05f,  1.57923387e+05f,  1.57949968e+05f
,	 1.57976549e+05f,  1.58003132e+05f,  1.58029715e+05f,  1.58056300e+05f
,	 1.58082886e+05f,  1.58109473e+05f,  1.58136061e+05f,  1.58162650e+05f
,	 1.58189240e+05f,  1.58215832e+05f,  1.58242424e+05f,  1.58269018e+05f
,	 1.58295613e+05f,  1.58322209e+05f,  1.58348806e+05f,  1.58375404e+05f
,	 1.58402003e+05f,  1.58428604e+05f,  1.58455205e+05f,  1.58481808e+05f
,	 1.58508412e+05f,  1.58535016e+05f,  1.58561622e+05f,  1.58588230e+05f
,	 1.58614838e+05f,  1.58641447e+05f,  1.58668057e+05f,  1.58694669e+05f
,	 1.58721282e+05f,  1.58747895e+05f,  1.58774510e+05f,  1.58801126e+05f
,	 1.58827744e+05f,  1.58854362e+05f,  1.58880981e+05f,  1.58907602e+05f
,	 1.58934223e+05f,  1.58960846e+05f,  1.58987470e+05f,  1.59014095e+05f
,	 1.59040721e+05f,  1.59067348e+05f,  1.59093976e+05f,  1.59120606e+05f
,	 1.59147236e+05f,  1.59173868e+05f,  1.59200500e+05f,  1.59227134e+05f
,	 1.59253769e+05f,  1.59280405e+05f,  1.59307042e+05f,  1.59333681e+05f
,	 1.59360320e+05f,  1.59386961e+05f,  1.59413602e+05f,  1.59440245e+05f
,	 1.59466889e+05f,  1.59493534e+05f,  1.59520180e+05f,  1.59546827e+05f
,	 1.59573476e+05f,  1.59600125e+05f,  1.59626776e+05f,  1.59653427e+05f
,	 1.59680080e+05f,  1.59706734e+05f,  1.59733389e+05f,  1.59760045e+05f
,	 1.59786702e+05f,  1.59813361e+05f,  1.59840020e+05f,  1.59866681e+05f
,	 1.59893342e+05f,  1.59920005e+05f,  1.59946669e+05f,  1.59973334e+05f
,	 1.60000000e+05f,  1.60026667e+05f,  1.60053336e+05f,  1.60080005e+05f
,	 1.60106676e+05f,  1.60133347e+05f,  1.60160020e+05f,  1.60186694e+05f
,	 1.60213369e+05f,  1.60240045e+05f,  1.60266722e+05f,  1.60293401e+05f
,	 1.60320080e+05f,  1.60346761e+05f,  1.60373442e+05f,  1.60400125e+05f
,	 1.60426809e+05f,  1.60453494e+05f,  1.60480180e+05f,  1.60506867e+05f
,	 1.60533555e+05f,  1.60560245e+05f,  1.60586935e+05f,  1.60613627e+05f
,	 1.60640320e+05f,  1.60667014e+05f,  1.60693709e+05f,  1.60720405e+05f
,	 1.60747102e+05f,  1.60773800e+05f,  1.60800500e+05f,  1.60827200e+05f
,	 1.60853902e+05f,  1.60880604e+05f,  1.60907308e+05f,  1.60934013e+05f
,	 1.60960719e+05f,  1.60987426e+05f,  1.61014135e+05f,  1.61040844e+05f
,	 1.61067555e+05f,  1.61094266e+05f,  1.61120979e+05f,  1.61147693e+05f
,	 1.61174408e+05f,  1.61201124e+05f,  1.61227841e+05f,  1.61254559e+05f
,	 1.61281278e+05f,  1.61307999e+05f,  1.61334720e+05f,  1.61361443e+05f
,	 1.61388167e+05f,  1.61414892e+05f,  1.61441618e+05f,  1.61468345e+05f
,	 1.61495073e+05f,  1.61521802e+05f,  1.61548533e+05f,  1.61575264e+05f
,	 1.61601997e+05f,  1.61628730e+05f,  1.61655465e+05f,  1.61682201e+05f
,	 1.61708938e+05f,  1.61735676e+05f,  1.61762416e+05f,  1.61789156e+05f
,	 1.61815897e+05f,  1.61842640e+05f,  1.61869384e+05f,  1.61896128e+05f
,	 1.61922874e+05f,  1.61949621e+05f,  1.61976369e+05f,  1.62003119e+05f
,	 1.62029869e+05f,  1.62056620e+05f,  1.62083373e+05f,  1.62110126e+05f
,	 1.62136881e+05f,  1.62163637e+05f,  1.62190394e+05f,  1.62217152e+05f
,	 1.62243911e+05f,  1.62270671e+05f,  1.62297432e+05f,  1.62324195e+05f
,	 1.62350958e+05f,  1.62377723e+05f,  1.62404489e+05f,  1.62431256e+05f
,	 1.62458024e+05f,  1.62484793e+05f,  1.62511563e+05f,  1.62538334e+05f
,	 1.62565106e+05f,  1.62591880e+05f,  1.62618654e+05f,  1.62645430e+05f
,	 1.62672207e+05f,  1.62698985e+05f,  1.62725764e+05f,  1.62752544e+05f
,	 1.62779325e+05f,  1.62806107e+05f,  1.62832891e+05f,  1.62859675e+05f
,	 1.62886461e+05f,  1.62913247e+05f,  1.62940035e+05f,  1.62966824e+05f
,	 1.62993614e+05f,  1.63020405e+05f,  1.63047197e+05f,  1.63073991e+05f
,	 1.63100785e+05f,  1.63127580e+05f,  1.63154377e+05f,  1.63181175e+05f
,	 1.63207973e+05f,  1.63234773e+05f,  1.63261574e+05f,  1.63288376e+05f
,	 1.63315180e+05f,  1.63341984e+05f,  1.63368789e+05f,  1.63395596e+05f
,	 1.63422403e+05f,  1.63449212e+05f,  1.63476022e+05f,  1.63502833e+05f
,	 1.63529645e+05f,  1.63556458e+05f,  1.63583272e+05f,  1.63610087e+05f
,	 1.63636904e+05f,  1.63663721e+05f,  1.63690540e+05f,  1.63717359e+05f
,	 1.63744180e+05f,  1.63771002e+05f,  1.63797825e+05f,  1.63824649e+05f
,	 1.63851474e+05f,  1.63878301e+05f,  1.63905128e+05f,  1.63931956e+05f
,	 1.63958786e+05f,  1.63985617e+05f,  1.64012448e+05f,  1.64039281e+05f
,	 1.64066115e+05f,  1.64092950e+05f,  1.64119786e+05f,  1.64146624e+05f
,	 1.64173462e+05f,  1.64200301e+05f,  1.64227142e+05f,  1.64253983e+05f
,	 1.64280826e+05f,  1.64307670e+05f,  1.64334515e+05f,  1.64361361e+05f
,	 1.64388208e+05f,  1.64415056e+05f,  1.64441906e+05f,  1.64468756e+05f
,	 1.64495607e+05f,  1.64522460e+05f,  1.64549314e+05f,  1.64576169e+05f
,	 1.64603024e+05f,  1.64629881e+05f,  1.64656739e+05f,  1.64683599e+05f
,	 1.64710459e+05f,  1.64737320e+05f,  1.64764183e+05f,  1.64791046e+05f
,	 1.64817911e+05f,  1.64844777e+05f,  1.64871643e+05f,  1.64898511e+05f
,	 1.64925380e+05f,  1.64952250e+05f,  1.64979122e+05f,  1.65005994e+05f
,	 1.65032867e+05f,  1.65059742e+05f,  1.65086617e+05f,  1.65113494e+05f
,	 1.65140372e+05f,  1.65167251e+05f,  1.65194131e+05f,  1.65221012e+05f
,	 1.65247894e+05f,  1.65274777e+05f,  1.65301661e+05f,  1.65328547e+05f
,	 1.65355433e+05f,  1.65382321e+05f,  1.65409210e+05f,  1.65436099e+05f
,	 1.65462990e+05f,  1.65489882e+05f,  1.65516775e+05f
};
static const ALIGNED(16) real aa_ca[8] = 
{
	-5.14495755e-01f, -4.71731969e-01f, -3.13377454e-01f, -1.81913200e-01f
,	-9.45741925e-02f, -4.09655829e-02f, -1.41985686e-02f, -3.69997467e-03f
};
static const ALIGNED(16) real aa_cs[8] = 
{
	 8.57492926e-01f,  8.81741997e-01f,  9.49628649e-01f,  9.83314592e-01f
,	 9.95517816e-01f,  9.99160558e-01f,  9.99899195e-01f,  9.99993155e-01f
};
static const ALIGNED(16) real win[4][36] = 
{
	{
		 3.22824301e-02f,  1.07206359e-01f,  2.01414267e-01f,  3.25616354e-01f
	,	 5.00000000e-01f,  7.67774705e-01f,  1.24122289e+00f,  2.33195123e+00f
	,	 7.74415058e+00f, -8.45125736e+00f, -3.03905801e+00f, -1.94832968e+00f
	,	-1.47488149e+00f, -1.20710678e+00f, -1.03272313e+00f, -9.08521049e-01f
	,	-8.14313140e-01f, -7.39389211e-01f, -6.77525384e-01f, -6.24844449e-01f
	,	-5.78791741e-01f, -5.37601636e-01f, -5.00000000e-01f, -4.65028346e-01f
	,	-4.31934290e-01f, -4.00099577e-01f, -3.68989865e-01f, -3.38116916e-01f
	,	-3.07007204e-01f, -2.75172491e-01f, -2.42078435e-01f, -2.07106781e-01f
	,	-1.69505145e-01f, -1.28315040e-01f, -8.22623323e-02f, -2.95813971e-02f
	}
,	{
		 3.22824301e-02f,  1.07206359e-01f,  2.01414267e-01f,  3.25616354e-01f
	,	 5.00000000e-01f,  7.67774705e-01f,  1.24122289e+00f,  2.33195123e+00f
	,	 7.74415058e+00f, -8.45125736e+00f, -3.03905801e+00f, -1.94832968e+00f
	,	-1.47488149e+00f, -1.20710678e+00f, -1.03272313e+00f, -9.08521049e-01f
	,	-8.14313140e-01f, -7.39389211e-01f, -6.78170852e-01f, -6.30236207e-01f
	,	-5.92844524e-01f, -5.63690973e-01f, -5.41196100e-01f, -5.24264563e-01f
	,	-5.07758331e-01f, -4.65925826e-01f, -3.97054578e-01f, -3.04670693e-01f
	,	-1.92992796e-01f, -6.68476524e-02f,  0.00000000e+00f,  0.00000000e+00f
	,	 0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f
	}
,	{
		 1.07206359e-01f,  5.00000000e-01f,  2.33195123e+00f, -3.03905801e+00f
	,	-1.20710678e+00f, -8.14313140e-01f, -6.24844449e-01f, -5.00000000e-01f
	,	-4.00099577e-01f, -3.07007204e-01f, -2.07106781e-01f, -8.22623323e-02f
	,	 0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f
	,	 0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f
	,	 0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f
	,	 0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f
	,	 0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f
	,	 0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f
	}
,	{
		 0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f
	,	 0.00000000e+00f,  0.00000000e+00f,  3.01530274e-01f,  1.46592583e+00f
	,	 6.97810613e+00f, -9.09404497e+00f, -3.53905801e+00f, -2.29034982e+00f
	,	-1.66275476e+00f, -1.30656296e+00f, -1.08284029e+00f, -9.30579498e-01f
	,	-8.21339816e-01f, -7.40093616e-01f, -6.77525384e-01f, -6.24844449e-01f
	,	-5.78791741e-01f, -5.37601636e-01f, -5.00000000e-01f, -4.65028346e-01f
	,	-4.31934290e-01f, -4.00099577e-01f, -3.68989865e-01f, -3.38116916e-01f
	,	-3.07007204e-01f, -2.75172491e-01f, -2.42078435e-01f, -2.07106781e-01f
	,	-1.69505145e-01f, -1.28315040e-01f, -8.22623323e-02f, -2.95813971e-02f
	}
};
static const ALIGNED(16) real win1[4][36] = 
{
	{
		 3.22824301e-02f, -1.07206359e-01f,  2.01414267e-01f, -3.25616354e-01f
	,	 5.00000000e-01f, -7.67774705e-01f,  1.24122289e+00f, -2.33195123e+00f
	,	 7.74415058e+00f,  8.45125736e+00f, -3.03905801e+00f,  1.94832968e+00f
	,	-1.47488149e+00f,  1.20710678e+00f, -1.03272313e+00f,  9.08521049e-01f
	,	-8.14313140e-01f,  7.39389211e-01f, -6.77525384e-01f,  6.24844449e-01f
	,	-5.78791741e-01f,  5.37601636e-01f, -5.00000000e-01f,  4.65028346e-01f
	,	-4.31934290e-01f,  4.00099577e-01f, -3.68989865e-01f,  3.38116916e-01f
	,	-3.07007204e-01f,  2.75172491e-01f, -2.42078435e-01f,  2.07106781e-01f
	,	-1.69505145e-01f,  1.28315040e-01f, -8.22623323e-02f,  2.95813971e-02f
	}
,	{
		 3.22824301e-02f, -1.07206359e-01f,  2.01414267e-01f, -3.25616354e-01f
	,	 5.00000000e-01f, -7.67774705e-01f,  1.24122289e+00f, -2.33195123e+00f
	,	 7.74415058e+00f,  8.45125736e+00f, -3.03905801e+00f,  1.94832968e+00f
	,	-1.47488149e+00f,  1.20710678e+00f, -1.03272313e+00f,  9.08521049e-01f
	,	-8.14313140e-01f,  7.39389211e-01f, -6.78170852e-01f,  6.30236207e-01f
	,	-5.92844524e-01f,  5.63690973e-01f, -5.41196100e-01f,  5.24264563e-01f
	,	-5.07758331e-01f,  4.65925826e-01f, -3.97054578e-01f,  3.04670693e-01f
	,	-1.92992796e-01f,  6.68476524e-02f,  0.00000000e+00f, -0.00000000e+00f
	,	 0.00000000e+00f, -0.00000000e+00f,  0.00000000e+00f, -0.00000000e+00f
	}
,	{
		 1.07206359e-01f, -5.00000000e-01f,  2.33195123e+00f,  3.03905801e+00f
	,	-1.20710678e+00f,  8.14313140e-01f, -6.24844449e-01f,  5.00000000e-01f
	,	-4.00099577e-01f,  3.07007204e-01f, -2.07106781e-01f,  8.22623323e-02f
	,	 0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f
	,	 0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f
	,	 0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f
	,	 0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f
	,	 0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f
	,	 0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f,  0.00000000e+00f
	}
,	{
		 0.00000000e+00f, -0.00000000e+00f,  0.00000000e+00f, -0.00000000e+00f
	,	 0.00000000e+00f, -0.00000000e+00f,  3.01530274e-01f, -1.46592583e+00f
	,	 6.97810613e+00f,  9.09404497e+00f, -3.53905801e+00f,  2.29034982e+00f
	,	-1.66275476e+00f,  1.30656296e+00f, -1.08284029e+00f,  9.30579498e-01f
	,	-8.21339816e-01f,  7.40093616e-01f, -6.77525384e-01f,  6.24844449e-01f
	,	-5.78791741e-01f,  5.37601636e-01f, -5.00000000e-01f,  4.65028346e-01f
	,	-4.31934290e-01f,  4.00099577e-01f, -3.68989865e-01f,  3.38116916e-01f
	,	-3.07007204e-01f,  2.75172491e-01f, -2.42078435e-01f,  2.07106781e-01f
	,	-1.69505145e-01f,  1.28315040e-01f, -8.22623323e-02f,  2.95813971e-02f
	}
};
const ALIGNED(16) real INT123_COS9[9] = 
{
	 1.00000000e+00f,  9.84807753e-01f,  9.39692621e-01f,  8.66025404e-01f
,	 7.66044443e-01f,  6.42787610e-01f,  5.00000000e-01f,  3.42020143e-01f
,	 1.73648178e-01f
};
static const real COS6_1 =  8.66025404e-01f;
static const real COS6_2 =  5.00000000e-01f;
const ALIGNED(16) real INT123_tfcos36[9] = 
{
	 5.01909919e-01f,  5.17638090e-01f,  5.51688959e-01f,  6.10387294e-01f
,	 7.07106781e-01f,  8.71723398e-01f,  1.18310079e+00f,  1.93185165e+00f
,	 5.73685662e+00f
};
static const ALIGNED(16) real tfcos12[3] = 
{
	 5.17638090e-01f,  7.07106781e-01f,  1.93185165e+00f
};
static const ALIGNED(16) real cos9[3] = 
{
	 9.39692621e-01f, -1.73648178e-01f, -7.66044443e-01f
};
static const ALIGNED(16) real cos18[3] = 
{
	 9.84807753e-01f, -3.42020143e-01f, -6.42787610e-01f
};
static const ALIGNED(16) real tan1_1[16] = 
{
	 0.00000000e+00f,  2.11324865e-01f,  3.66025404e-01f,  5.00000000e-01f
,	 6.33974596e-01f,  7.88675135e-01f,  1.00000000e+00f,  1.36602540e+00f
,	 2.36602540e+00f, -1.00000000e+38f, -1.36602540e+00f, -3.66025404e-01f
,	 0.00000000e+00f,  2.11324865e-01f,  3.66025404e-01f,  5.00000000e-01f
};
static const ALIGNED(16) real tan2_1[16] = 
{
	 1.00000000e+00f,  7.88675135e-01f,  6.33974596e-01f,  5.00000000e-01f
,	 3.66025404e-01f,  2.11324865e-01f,  0.00000000e+00f, -3.66025404e-01f
,	-1.36602540e+00f,  1.00000000e+38f,  2.36602540e+00f,  1.36602540e+00f
,	 1.00000000e+00f,  7.88675135e-01f,  6.33974596e-01f,  5.00000000e-01f
};
static const ALIGNED(16) real tan1_2[16] = 
{
	 0.00000000e+00f,  2.98858491e-01f,  5.17638090e-01f,  7.07106781e-01f
,	 8.96575472e-01f,  1.11535507e+00f,  1.41421356e+00f,  1.93185165e+00f
,	 3.34606521e+00f, -1.00000000e+38f, -1.93185165e+00f, -5.17638090e-01f
,	 0.00000000e+00f,  2.98858491e-01f,  5.17638090e-01f,  7.07106781e-01f
};
static const ALIGNED(16) real tan2_2[16] = 
{
	 1.41421356e+00f,  1.11535507e+00f,  8.96575472e-01f,  7.07106781e-01f
,	 5.17638090e-01f,  2.98858491e-01f,  0.00000000e+00f, -5.17638090e-01f
,	-1.93185165e+00f,  1.00000000e+38f,  3.34606521e+00f,  1.93185165e+00f
,	 1.41421356e+00f,  1.11535507e+00f,  8.96575472e-01f,  7.07106781e-01f
};
static const ALIGNED(16) real pow1_1[2][32] = 
{
	{
		 1.00000000e+00f,  8.40896415e-01f,  1.00000000e+00f,  7.07106781e-01f
	,	 1.00000000e+00f,  5.94603558e-01f,  1.00000000e+00f,  5.00000000e-01f
	,	 1.00000000e+00f,  4.20448208e-01f,  1.00000000e+00f,  3.53553391e-01f
	,	 1.00000000e+00f,  2.97301779e-01f,  1.00000000e+00f,  2.50000000e-01f
	,	 1.00000000e+00f,  2.10224104e-01f,  1.00000000e+00f,  1.76776695e-01f
	,	 1.00000000e+00f,  1.48650889e-01f,  1.00000000e+00f,  1.25000000e-01f
	,	 1.00000000e+00f,  1.05112052e-01f,  1.00000000e+00f,  8.83883476e-02f
	,	 1.00000000e+00f,  7.43254447e-02f,  1.00000000e+00f,  6.25000000e-02f
	}
,	{
		 1.00000000e+00f,  7.07106781e-01f,  1.00000000e+00f,  5.00000000e-01f
	,	 1.00000000e+00f,  3.53553391e-01f,  1.00000000e+00f,  2.50000000e-01f
	,	 1.00000000e+00f,  1.76776695e-01f,  1.00000000e+00f,  1.25000000e-01f
	,	 1.00000000e+00f,  8.83883476e-02f,  1.00000000e+00f,  6.25000000e-02f
	,	 1.00000000e+00f,  4.41941738e-02f,  1.00000000e+00f,  3.12500000e-02f
	,	 1.00000000e+00f,  2.20970869e-02f,  1.00000000e+00f,  1.56250000e-02f
	,	 1.00000000e+00f,  1.10485435e-02f,  1.00000000e+00f,  7.81250000e-03f
	,	 1.00000000e+00f,  5.52427173e-03f,  1.00000000e+00f,  3.90625000e-03f
	}
};
static const ALIGNED(16) real pow2_1[2][32] = 
{
	{
		 1.00000000e+00f,  1.00000000e+00f,  8.40896415e-01f,  1.00000000e+00f
	,	 7.07106781e-01f,  1.00000000e+00f,  5.94603558e-01f,  1.00000000e+00f
	,	 5.00000000e-01f,  1.00000000e+00f,  4.20448208e-01f,  1.00000000e+00f
	,	 3.53553391e-01f,  1.00000000e+00f,  2.97301779e-01f,  1.00000000e+00f
	,	 2.50000000e-01f,  1.00000000e+00f,  2.10224104e-01f,  1.00000000e+00f
	,	 1.76776695e-01f,  1.00000000e+00f,  1.48650889e-01f,  1.00000000e+00f
	,	 1.25000000e-01f,  1.00000000e+00f,  1.05112052e-01f,  1.00000000e+00f
	,	 8.83883476e-02f,  1.00000000e+00f,  7.43254447e-02f,  1.00000000e+00f
	}
,	{
		 1.00000000e+00f,  1.00000000e+00f,  7.07106781e-01f,  1.00000000e+00f
	,	 5.00000000e-01f,  1.00000000e+00f,  3.53553391e-01f,  1.00000000e+00f
	,	 2.50000000e-01f,  1.00000000e+00f,  1.76776695e-01f,  1.00000000e+00f
	,	 1.25000000e-01f,  1.00000000e+00f,  8.83883476e-02f,  1.00000000e+00f
	,	 6.25000000e-02f,  1.00000000e+00f,  4.41941738e-02f,  1.00000000e+00f
	,	 3.12500000e-02f,  1.00000000e+00f,  2.20970869e-02f,  1.00000000e+00f
	,	 1.56250000e-02f,  1.00000000e+00f,  1.10485435e-02f,  1.00000000e+00f
	,	 7.81250000e-03f,  1.00000000e+00f,  5.52427173e-03f,  1.00000000e+00f
	}
};
static const ALIGNED(16) real pow1_2[2][32] = 
{
	{
		 1.41421356e+00f,  1.18920712e+00f,  1.41421356e+00f,  1.00000000e+00f
	,	 1.41421356e+00f,  8.40896415e-01f,  1.41421356e+00f,  7.07106781e-01f
	,	 1.41421356e+00f,  5.94603558e-01f,  1.41421356e+00f,  5.00000000e-01f
	,	 1.41421356e+00f,  4.20448208e-01f,  1.41421356e+00f,  3.53553391e-01f
	,	 1.41421356e+00f,  2.97301779e-01f,  1.41421356e+00f,  2.50000000e-01f
	,	 1.41421356e+00f,  2.10224104e-01f,  1.41421356e+00f,  1.76776695e-01f
	,	 1.41421356e+00f,  1.48650889e-01f,  1.41421356e+00f,  1.25000000e-01f
	,	 1.41421356e+00f,  1.05112052e-01f,  1.41421356e+00f,  8.83883476e-02f
	}
,	{
		 1.41421356e+00f,  1.00000000e+00f,  1.41421356e+00f,  7.07106781e-01f
	,	 1.41421356e+00f,  5.00000000e-01f,  1.41421356e+00f,  3.53553391e-01f
	,	 1.41421356e+00f,  2.50000000e-01f,  1.41421356e+00f,  1.76776695e-01f
	,	 1.41421356e+00f,  1.25000000e-01f,  1.41421356e+00f,  8.83883476e-02f
	,	 1.41421356e+00f,  6.25000000e-02f,  1.41421356e+00f,  4.41941738e-02f
	,	 1.41421356e+00f,  3.12500000e-02f,  1.41421356e+00f,  2.20970869e-02f
	,	 1.41421356e+00f,  1.56250000e-02f,  1.41421356e+00f,  1.10485435e-02f
	,	 1.41421356e+00f,  7.81250000e-03f,  1.41421356e+00f,  5.52427173e-03f
	}
};
static const ALIGNED(16) real pow2_2[2][32] = 
{
	{
		 1.41421356e+00f,  1.41421356e+00f,  1.18920712e+00f,  1.41421356e+00f
	,	 1.00000000e+00f,  1.41421356e+00f,  8.40896415e-01f,  1.41421356e+00f
	,	 7.07106781e-01f,  1.41421356e+00f,  5.94603558e-01f,  1.41421356e+00f
	,	 5.00000000e-01f,  1.41421356e+00f,  4.20448208e-01f,  1.41421356e+00f
	,	 3.53553391e-01f,  1.41421356e+00f,  2.97301779e-01f,  1.41421356e+00f
	,	 2.50000000e-01f,  1.41421356e+00f,  2.10224104e-01f,  1.41421356e+00f
	,	 1.76776695e-01f,  1.41421356e+00f,  1.48650889e-01f,  1.41421356e+00f
	,	 1.25000000e-01f,  1.41421356e+00f,  1.05112052e-01f,  1.41421356e+00f
	}
,	{
		 1.41421356e+00f,  1.41421356e+00f,  1.00000000e+00f,  1.41421356e+00f
	,	 7.07106781e-01f,  1.41421356e+00f,  5.00000000e-01f,  1.41421356e+00f
	,	 3.53553391e-01f,  1.41421356e+00f,  2.50000000e-01f,  1.41421356e+00f
	,	 1.76776695e-01f,  1.41421356e+00f,  1.25000000e-01f,  1.41421356e+00f
	,	 8.83883476e-02f,  1.41421356e+00f,  6.25000000e-02f,  1.41421356e+00f
	,	 4.41941738e-02f,  1.41421356e+00f,  3.12500000e-02f,  1.41421356e+00f
	,	 2.20970869e-02f,  1.41421356e+00f,  1.56250000e-02f,  1.41421356e+00f
	,	 1.10485435e-02f,  1.41421356e+00f,  7.81250000e-03f,  1.41421356e+00f
	}
};

#endif

#ifdef REAL_IS_FIXED

static const real ispow[8207] = 
{
	          0,        8192,       20643,       35445
,	      52016,       70041,       89315,      109695
,	     131072,      153360,      176491,      200407
,	     225060,      250408,      276414,      303048
,	     330281,      358087,      386444,      415331
,	     444730,      474623,      504995,      535830
,	     567116,      598839,      630988,      663552
,	     696521,      729884,      763633,      797760
,	     832255,      867112,      902323,      937880
,	     973778,     1010010,     1046569,     1083451
,	    1120650,     1158160,     1195976,     1234093
,	    1272507,     1311213,     1350207,     1389485
,	    1429042,     1468875,     1508979,     1549352
,	    1589990,     1630889,     1672046,     1713458
,	    1755122,     1797035,     1839193,     1881594
,	    1924236,     1967115,     2010229,     2053576
,	    2097152,     2140956,     2184985,     2229238
,	    2273710,     2318402,     2363310,     2408432
,	    2453767,     2499312,     2545065,     2591025
,	    2637190,     2683558,     2730126,     2776895
,	    2823861,     2871023,     2918379,     2965929
,	    3013670,     3061600,     3109719,     3158025
,	    3206517,     3255192,     3304050,     3353089
,	    3402309,     3451707,     3501282,     3551033
,	    3600960,     3651060,     3701332,     3751776
,	    3802390,     3853172,     3904123,     3955241
,	    4006524,     4057972,     4109583,     4161357
,	    4213293,     4265389,     4317644,     4370058
,	    4422630,     4475359,     4528243,     4581282
,	    4634476,     4687822,     4741320,     4794970
,	    4848770,     4902720,     4956819,     5011066
,	    5065460,     5120000,     5174686,     5229517
,	    5284492,     5339610,     5394871,     5450274
,	    5505818,     5561502,     5617327,     5673290
,	    5729391,     5785631,     5842007,     5898519
,	    5955168,     6011951,     6068869,     6125920
,	    6183105,     6240422,     6297871,     6355451
,	    6413162,     6471004,     6528974,     6587074
,	    6645302,     6703658,     6762141,     6820751
,	    6879487,     6938349,     6997336,     7056447
,	    7115683,     7175042,     7234524,     7294129
,	    7353855,     7413703,     7473672,     7533762
,	    7593972,     7654301,     7714750,     7775317
,	    7836002,     7896805,     7957725,     8018762
,	    8079916,     8141185,     8202570,     8264070
,	    8325685,     8387413,     8449256,     8511212
,	    8573281,     8635462,     8697756,     8760161
,	    8822678,     8885305,     8948043,     9010892
,	    9073850,     9136917,     9200094,     9263379
,	    9326772,     9390274,     9453882,     9517598
,	    9581421,     9645351,     9709386,     9773527
,	    9837774,     9902125,     9966582,    10031143
,	   10095807,    10160576,    10225448,    10290423
,	   10355500,    10420681,    10485963,    10551347
,	   10616832,    10682419,    10748106,    10813894
,	   10879782,    10945770,    11011857,    11078044
,	   11144330,    11210715,    11277198,    11343779
,	   11410458,    11477234,    11544108,    11611079
,	   11678147,    11745311,    11812571,    11879927
,	   11947378,    12014925,    12082567,    12150304
,	   12218135,    12286061,    12354081,    12422194
,	   12490401,    12558701,    12627094,    12695580
,	   12764158,    12832829,    12901592,    12970446
,	   13039392,    13108429,    13177557,    13246776
,	   13316085,    13385485,    13454975,    13524554
,	   13594224,    13663982,    13733830,    13803767
,	   13873792,    13943906,    14014108,    14084398
,	   14154776,    14225242,    14295794,    14366435
,	   14437162,    14507975,    14578876,    14649862
,	   14720935,    14792093,    14863337,    14934667
,	   15006082,    15077582,    15149167,    15220837
,	   15292591,    15364429,    15436351,    15508358
,	   15580448,    15652621,    15724878,    15797217
,	   15869640,    15942146,    16014734,    16087404
,	   16160156,    16232991,    16305907,    16378905
,	   16451984,    16525145,    16598386,    16671709
,	   16745112,    16818596,    16892160,    16965804
,	   17039528,    17113332,    17187216,    17261179
,	   17335222,    17409343,    17483544,    17557824
,	   17632182,    17706618,    17781133,    17855726
,	   17930397,    18005146,    18079973,    18154877
,	   18229858,    18304917,    18380052,    18455265
,	   18530554,    18605920,    18681362,    18756880
,	   18832475,    18908145,    18983891,    19059713
,	   19135610,    19211583,    19287630,    19363753
,	   19439951,    19516223,    19592571,    19668992
,	   19745488,    19822058,    19898702,    19975420
,	   20052211,    20129076,    20206015,    20283027
,	   20360112,    20437270,    20514501,    20591805
,	   20669181,    20746630,    20824151,    20901745
,	   20979410,    21057148,    21134957,    21212838
,	   21290791,    21368815,    21446910,    21525076
,	   21603314,    21681622,    21760001,    21838451
,	   21916971,    21995561,    22074222,    22152953
,	   22231754,    22310625,    22389566,    22468576
,	   22547656,    22626806,    22706024,    22785312
,	   22864669,    22944094,    23023589,    23103152
,	   23182783,    23262484,    23342252,    23422089
,	   23501993,    23581966,    23662007,    23742115
,	   23822291,    23902534,    23982845,    24063223
,	   24143669,    24224181,    24304761,    24385407
,	   24466120,    24546899,    24627745,    24708658
,	   24789637,    24870682,    24951793,    25032970
,	   25114213,    25195521,    25276895,    25358335
,	   25439841,    25521411,    25603047,    25684748
,	   25766514,    25848345,    25930241,    26012201
,	   26094226,    26176316,    26258469,    26340688
,	   26422970,    26505317,    26587727,    26670202
,	   26752740,    26835342,    26918008,    27000737
,	   27083530,    27166386,    27249305,    27332287
,	   27415332,    27498440,    27581611,    27664845
,	   27748142,    27831501,    27914922,    27998406
,	   28081952,    28165561,    28249231,    28332963
,	   28416758,    28500614,    28584532,    28668511
,	   28752552,    28836655,    28920819,    29005044
,	   29089330,    29173677,    29258086,    29342555
,	   29427085,    29511676,    29596328,    29681040
,	   29765813,    29850646,    29935539,    30020493
,	   30105507,    30190581,    30275714,    30360908
,	   30446162,    30531475,    30616848,    30702280
,	   30787772,    30873323,    30958934,    31044604
,	   31130332,    31216120,    31301967,    31387873
,	   31473838,    31559862,    31645944,    31732084
,	   31818284,    31904541,    31990857,    32077231
,	   32163664,    32250154,    32336703,    32423309
,	   32509974,    32596696,    32683476,    32770313
,	   32857208,    32944161,    33031171,    33118238
,	   33205363,    33292544,    33379783,    33467079
,	   33554432,    33641842,    33729308,    33816832
,	   33904412,    33992048,    34079741,    34167491
,	   34255297,    34343159,    34431078,    34519052
,	   34607083,    34695170,    34783312,    34871511
,	   34959765,    35048075,    35136441,    35224862
,	   35313339,    35401872,    35490459,    35579102
,	   35667801,    35756554,    35845363,    35934226
,	   36023145,    36112118,    36201147,    36290230
,	   36379367,    36468560,    36557807,    36647108
,	   36736464,    36825875,    36915339,    37004858
,	   37094431,    37184058,    37273739,    37363474
,	   37453263,    37543106,    37633003,    37722953
,	   37812957,    37903015,    37993126,    38083291
,	   38173509,    38263780,    38354105,    38444483
,	   38534914,    38625398,    38715935,    38806525
,	   38897168,    38987864,    39078612,    39169414
,	   39260268,    39351174,    39442133,    39533145
,	   39624209,    39715325,    39806494,    39897714
,	   39988987,    40080312,    40171690,    40263119
,	   40354600,    40446133,    40537718,    40629354
,	   40721042,    40812782,    40904574,    40996417
,	   41088311,    41180257,    41272254,    41364303
,	   41456402,    41548553,    41640755,    41733008
,	   41825313,    41917668,    42010074,    42102530
,	   42195038,    42287596,    42380205,    42472865
,	   42565575,    42658336,    42751147,    42844009
,	   42936921,    43029883,    43122895,    43215958
,	   43309070,    43402233,    43495446,    43588709
,	   43682022,    43775384,    43868797,    43962259
,	   44055771,    44149332,    44242943,    44336604
,	   44430314,    44524073,    44617882,    44711741
,	   44805648,    44899605,    44993611,    45087666
,	   45181770,    45275923,    45370126,    45464377
,	   45558677,    45653025,    45747423,    45841869
,	   45936364,    46030908,    46125500,    46220141
,	   46314830,    46409567,    46504353,    46599187
,	   46694070,    46789001,    46883980,    46979007
,	   47074082,    47169205,    47264376,    47359595
,	   47454862,    47550177,    47645540,    47740950
,	   47836408,    47931914,    48027467,    48123068
,	   48218716,    48314412,    48410155,    48505945
,	   48601783,    48697668,    48793601,    48889580
,	   48985607,    49081681,    49177802,    49273969
,	   49370184,    49466446,    49562754,    49659109
,	   49755511,    49851960,    49948456,    50044998
,	   50141586,    50238222,    50334903,    50431631
,	   50528406,    50625227,    50722094,    50819007
,	   50915967,    51012973,    51110025,    51207123
,	   51304267,    51401457,    51498694,    51595976
,	   51693304,    51790677,    51888097,    51985562
,	   52083073,    52180630,    52278232,    52375880
,	   52473573,    52571312,    52669097,    52766926
,	   52864801,    52962722,    53060688,    53158699
,	   53256755,    53354856,    53453002,    53551194
,	   53649430,    53747712,    53846038,    53944410
,	   54042826,    54141287,    54239793,    54338344
,	   54436939,    54535579,    54634263,    54732993
,	   54831766,    54930585,    55029447,    55128354
,	   55227306,    55326302,    55425342,    55524426
,	   55623555,    55722728,    55821945,    55921206
,	   56020511,    56119860,    56219253,    56318690
,	   56418171,    56517696,    56617265,    56716877
,	   56816534,    56916234,    57015977,    57115764
,	   57215595,    57315470,    57415388,    57515349
,	   57615354,    57715403,    57815494,    57915629
,	   58015808,    58116029,    58216294,    58316602
,	   58416954,    58517348,    58617785,    58718266
,	   58818789,    58919356,    59019965,    59120617
,	   59221312,    59322050,    59422831,    59523654
,	   59624521,    59725429,    59826381,    59927375
,	   60028412,    60129491,    60230613,    60331777
,	   60432983,    60534232,    60635524,    60736857
,	   60838233,    60939651,    61041112,    61142614
,	   61244159,    61345746,    61447375,    61549046
,	   61650759,    61752513,    61854310,    61956149
,	   62058030,    62159952,    62261916,    62363922
,	   62465970,    62568059,    62670191,    62772363
,	   62874578,    62976833,    63079131,    63181470
,	   63283850,    63386272,    63488735,    63591239
,	   63693785,    63796372,    63899001,    64001670
,	   64104381,    64207133,    64309926,    64412760
,	   64515636,    64618552,    64721509,    64824507
,	   64927546,    65030627,    65133747,    65236909
,	   65340112,    65443355,    65546639,    65649964
,	   65753329,    65856735,    65960182,    66063669
,	   66167197,    66270765,    66374374,    66478023
,	   66581713,    66685443,    66789213,    66893024
,	   66996875,    67100766,    67204698,    67308669
,	   67412681,    67516733,    67620825,    67724957
,	   67829130,    67933342,    68037594,    68141886
,	   68246218,    68350590,    68455002,    68559454
,	   68663945,    68768476,    68873047,    68977658
,	   69082308,    69186998,    69291728,    69396497
,	   69501306,    69606154,    69711042,    69815969
,	   69920936,    70025942,    70130987,    70236072
,	   70341196,    70446360,    70551562,    70656804
,	   70762085,    70867406,    70972765,    71078164
,	   71183601,    71289078,    71394594,    71500149
,	   71605742,    71711375,    71817046,    71922757
,	   72028506,    72134294,    72240121,    72345987
,	   72451891,    72557835,    72663817,    72769837
,	   72875896,    72981994,    73088130,    73194305
,	   73300519,    73406770,    73513061,    73619389
,	   73725757,    73832162,    73938606,    74045088
,	   74151609,    74258168,    74364765,    74471400
,	   74578073,    74684785,    74791535,    74898323
,	   75005149,    75112012,    75218914,    75325854
,	   75432832,    75539848,    75646902,    75753994
,	   75861123,    75968291,    76075496,    76182739
,	   76290020,    76397338,    76504694,    76612088
,	   76719520,    76826989,    76934495,    77042040
,	   77149622,    77257241,    77364898,    77472592
,	   77580324,    77688093,    77795899,    77903743
,	   78011625,    78119543,    78227499,    78335492
,	   78443522,    78551590,    78659695,    78767836
,	   78876015,    78984232,    79092485,    79200775
,	   79309102,    79417467,    79525868,    79634306
,	   79742781,    79851293,    79959842,    80068428
,	   80177050,    80285710,    80394406,    80503139
,	   80611908,    80720715,    80829558,    80938438
,	   81047354,    81156307,    81265296,    81374322
,	   81483385,    81592484,    81701620,    81810792
,	   81920000,    82029245,    82138526,    82247844
,	   82357198,    82466588,    82576014,    82685477
,	   82794976,    82904512,    83014083,    83123691
,	   83233334,    83343014,    83452730,    83562482
,	   83672271,    83782095,    83891955,    84001851
,	   84111783,    84221751,    84331755,    84441795
,	   84551870,    84661982,    84772129,    84882312
,	   84992531,    85102786,    85213076,    85323402
,	   85433764,    85544161,    85654594,    85765063
,	   85875567,    85986107,    86096682,    86207293
,	   86317939,    86428621,    86539338,    86650091
,	   86760879,    86871702,    86982561,    87093455
,	   87204384,    87315349,    87426349,    87537384
,	   87648455,    87759560,    87870701,    87981877
,	   88093088,    88204334,    88315616,    88426932
,	   88538283,    88649670,    88761091,    88872548
,	   88984039,    89095565,    89207126,    89318723
,	   89430353,    89542019,    89653720,    89765455
,	   89877226,    89989030,    90100870,    90212745
,	   90324654,    90436598,    90548576,    90660589
,	   90772637,    90884719,    90996836,    91108987
,	   91221173,    91333394,    91445648,    91557938
,	   91670262,    91782620,    91895012,    92007439
,	   92119901,    92232396,    92344926,    92457491
,	   92570089,    92682722,    92795389,    92908090
,	   93020826,    93133595,    93246399,    93359237
,	   93472109,    93585015,    93697955,    93810929
,	   93923937,    94036980,    94150056,    94263166
,	   94376310,    94489488,    94602700,    94715946
,	   94829225,    94942539,    95055886,    95169267
,	   95282682,    95396131,    95509613,    95623129
,	   95736679,    95850263,    95963880,    96077530
,	   96191215,    96304933,    96418684,    96532470
,	   96646288,    96760140,    96874026,    96987945
,	   97101898,    97215884,    97329904,    97443956
,	   97558043,    97672162,    97786315,    97900502
,	   98014721,    98128974,    98243260,    98357580
,	   98471933,    98586318,    98700737,    98815190
,	   98929675,    99044194,    99158745,    99273330
,	   99387948,    99502598,    99617282,    99731999
,	   99846749,    99961532,   100076348,   100191197
,	  100306078,   100420993,   100535940,   100650921
,	  100765934,   100880980,   100996059,   101111170
,	  101226315,   101341492,   101456702,   101571944
,	  101687220,   101802528,   101917868,   102033241
,	  102148647,   102264086,   102379557,   102495061
,	  102610597,   102726166,   102841767,   102957401
,	  103073067,   103188765,   103304497,   103420260
,	  103536056,   103651884,   103767745,   103883638
,	  103999563,   104115521,   104231511,   104347533
,	  104463588,   104579675,   104695794,   104811945
,	  104928128,   105044344,   105160592,   105276871
,	  105393183,   105509527,   105625904,   105742312
,	  105858752,   105975224,   106091729,   106208265
,	  106324833,   106441433,   106558066,   106674730
,	  106791426,   106908154,   107024913,   107141705
,	  107258528,   107375384,   107492271,   107609190
,	  107726140,   107843123,   107960137,   108077182
,	  108194260,   108311369,   108428510,   108545683
,	  108662887,   108780122,   108897390,   109014689
,	  109132019,   109249381,   109366775,   109484200
,	  109601656,   109719144,   109836664,   109954215
,	  110071797,   110189411,   110307056,   110424733
,	  110542441,   110660180,   110777950,   110895752
,	  111013585,   111131450,   111249346,   111367273
,	  111485231,   111603220,   111721241,   111839292
,	  111957375,   112075489,   112193635,   112311811
,	  112430018,   112548257,   112666526,   112784827
,	  112903159,   113021521,   113139915,   113258339
,	  113376795,   113495282,   113613799,   113732347
,	  113850927,   113969537,   114088178,   114206850
,	  114325552,   114444286,   114563050,   114681845
,	  114800671,   114919528,   115038415,   115157333
,	  115276282,   115395262,   115514272,   115633313
,	  115752384,   115871486,   115990619,   116109783
,	  116228976,   116348201,   116467456,   116586742
,	  116706058,   116825404,   116944781,   117064189
,	  117183627,   117303095,   117422594,   117542124
,	  117661683,   117781273,   117900894,   118020545
,	  118140226,   118259937,   118379679,   118499451
,	  118619253,   118739086,   118858948,   118978842
,	  119098765,   119218718,   119338702,   119458716
,	  119578759,   119698834,   119818938,   119939072
,	  120059236,   120179431,   120299655,   120419910
,	  120540194,   120660509,   120780854,   120901228
,	  121021633,   121142067,   121262532,   121383026
,	  121503550,   121624105,   121744689,   121865303
,	  121985946,   122106620,   122227323,   122348057
,	  122468820,   122589613,   122710435,   122831287
,	  122952170,   123073081,   123194023,   123314994
,	  123435995,   123557025,   123678085,   123799175
,	  123920295,   124041444,   124162622,   124283830
,	  124405068,   124526335,   124647632,   124768959
,	  124890314,   125011700,   125133114,   125254559
,	  125376032,   125497536,   125619068,   125740630
,	  125862221,   125983842,   126105492,   126227171
,	  126348880,   126470618,   126592386,   126714182
,	  126836008,   126957863,   127079748,   127201661
,	  127323604,   127445576,   127567578,   127689608
,	  127811668,   127933756,   128055874,   128178021
,	  128300197,   128422403,   128544637,   128666900
,	  128789193,   128911514,   129033865,   129156244
,	  129278652,   129401090,   129523556,   129646052
,	  129768576,   129891129,   130013711,   130136323
,	  130258963,   130381631,   130504329,   130627056
,	  130749811,   130872595,   130995408,   131118250
,	  131241120,   131364020,   131486948,   131609905
,	  131732890,   131855904,   131978947,   132102019
,	  132225119,   132348248,   132471406,   132594592
,	  132717807,   132841050,   132964323,   133087623
,	  133210952,   133334310,   133457696,   133581111
,	  133704554,   133828026,   133951527,   134075055
,	  134198613,   134322198,   134445812,   134569455
,	  134693126,   134816825,   134940553,   135064309
,	  135188094,   135311906,   135435747,   135559617
,	  135683515,   135807441,   135931395,   136055378
,	  136179388,   136303427,   136427495,   136551590
,	  136675714,   136799866,   136924046,   137048254
,	  137172490,   137296755,   137421048,   137545368
,	  137669717,   137794094,   137918499,   138042932
,	  138167393,   138291882,   138416400,   138540945
,	  138665518,   138790119,   138914748,   139039405
,	  139164090,   139288803,   139413544,   139538313
,	  139663110,   139787934,   139912787,   140037667
,	  140162575,   140287511,   140412475,   140537467
,	  140662486,   140787533,   140912608,   141037711
,	  141162842,   141288000,   141413186,   141538399
,	  141663641,   141788910,   141914207,   142039531
,	  142164883,   142290263,   142415670,   142541105
,	  142666567,   142792057,   142917575,   143043120
,	  143168693,   143294294,   143419921,   143545577
,	  143671260,   143796970,   143922708,   144048473
,	  144174266,   144300086,   144425934,   144551809
,	  144677712,   144803641,   144929599,   145055583
,	  145181595,   145307635,   145433701,   145559795
,	  145685917,   145812065,   145938241,   146064445
,	  146190675,   146316933,   146443218,   146569530
,	  146695869,   146822236,   146948630,   147075051
,	  147201499,   147327974,   147454477,   147581007
,	  147707563,   147834147,   147960758,   148087396
,	  148214061,   148340754,   148467473,   148594219
,	  148720993,   148847793,   148974620,   149101475
,	  149228356,   149355264,   149482200,   149609162
,	  149736151,   149863167,   149990210,   150117280
,	  150244377,   150371501,   150498652,   150625829
,	  150753033,   150880265,   151007523,   151134807
,	  151262119,   151389457,   151516823,   151644215
,	  151771633,   151899079,   152026551,   152154050
,	  152281576,   152409128,   152536707,   152664313
,	  152791945,   152919604,   153047290,   153175002
,	  153302741,   153430507,   153558299,   153686118
,	  153813963,   153941835,   154069734,   154197659
,	  154325610,   154453588,   154581593,   154709624
,	  154837682,   154965766,   155093876,   155222013
,	  155350177,   155478367,   155606583,   155734826
,	  155863095,   155991391,   156119713,   156248061
,	  156376436,   156504837,   156633264,   156761718
,	  156890198,   157018704,   157147237,   157275796
,	  157404381,   157532993,   157661630,   157790294
,	  157918985,   158047701,   158176444,   158305212
,	  158434008,   158562829,   158691676,   158820550
,	  158949449,   159078375,   159207327,   159336305
,	  159465310,   159594340,   159723396,   159852479
,	  159981587,   160110722,   160239882,   160369069
,	  160498282,   160627520,   160756785,   160886076
,	  161015392,   161144735,   161274103,   161403498
,	  161532918,   161662365,   161791837,   161921335
,	  162050859,   162180409,   162309985,   162439587
,	  162569215,   162698868,   162828547,   162958252
,	  163087983,   163217740,   163347523,   163477331
,	  163607165,   163737025,   163866910,   163996822
,	  164126759,   164256722,   164386710,   164516724
,	  164646764,   164776830,   164906921,   165037038
,	  165167181,   165297349,   165427543,   165557762
,	  165688007,   165818278,   165948574,   166078896
,	  166209243,   166339616,   166470015,   166600439
,	  166730888,   166861363,   166991864,   167122390
,	  167252942,   167383519,   167514122,   167644750
,	  167775403,   167906082,   168036786,   168167516
,	  168298271,   168429052,   168559858,   168690689
,	  168821546,   168952428,   169083335,   169214268
,	  169345226,   169476210,   169607219,   169738253
,	  169869312,   170000397,   170131507,   170262642
,	  170393802,   170524988,   170656199,   170787435
,	  170918696,   171049983,   171181295,   171312632
,	  171443994,   171575381,   171706793,   171838231
,	  171969694,   172101182,   172232695,   172364233
,	  172495796,   172627384,   172758997,   172890636
,	  173022299,   173153988,   173285702,   173417440
,	  173549204,   173680993,   173812806,   173944645
,	  174076509,   174208397,   174340311,   174472249
,	  174604213,   174736201,   174868215,   175000253
,	  175132316,   175264404,   175396517,   175528655
,	  175660818,   175793005,   175925218,   176057455
,	  176189717,   176322004,   176454316,   176586653
,	  176719014,   176851400,   176983811,   177116247
,	  177248708,   177381193,   177513703,   177646237
,	  177778797,   177911381,   178043990,   178176624
,	  178309282,   178441965,   178574672,   178707405
,	  178840162,   178972943,   179105749,   179238580
,	  179371435,   179504316,   179637220,   179770149
,	  179903103,   180036082,   180169084,   180302112
,	  180435164,   180568240,   180701342,   180834467
,	  180967617,   181100792,   181233991,   181367214
,	  181500462,   181633735,   181767032,   181900353
,	  182033699,   182167069,   182300464,   182433883
,	  182567326,   182700794,   182834286,   182967803
,	  183101344,   183234909,   183368499,   183502113
,	  183635751,   183769414,   183903101,   184036812
,	  184170548,   184304307,   184438092,   184571900
,	  184705732,   184839589,   184973470,   185107376
,	  185241305,   185375259,   185509237,   185643239
,	  185777266,   185911316,   186045391,   186179490
,	  186313613,   186447760,   186581931,   186716126
,	  186850346,   186984590,   187118857,   187253149
,	  187387465,   187521805,   187656169,   187790557
,	  187924969,   188059405,   188193866,   188328350
,	  188462858,   188597390,   188731946,   188866527
,	  189001131,   189135759,   189270411,   189405087
,	  189539787,   189674511,   189809259,   189944031
,	  190078827,   190213646,   190348490,   190483357
,	  190618249,   190753164,   190888103,   191023066
,	  191158052,   191293063,   191428097,   191563155
,	  191698237,   191833343,   191968473,   192103626
,	  192238803,   192374004,   192509229,   192644477
,	  192779749,   192915045,   193050365,   193185708
,	  193321075,   193456466,   193591881,   193727319
,	  193862781,   193998266,   194133775,   194269308
,	  194404864,   194540444,   194676048,   194811675
,	  194947326,   195083001,   195218699,   195354421
,	  195490166,   195625935,   195761727,   195897543
,	  196033383,   196169246,   196305132,   196441042
,	  196576976,   196712933,   196848914,   196984918
,	  197120945,   197256996,   197393071,   197529169
,	  197665290,   197801435,   197937603,   198073795
,	  198210010,   198346249,   198482510,   198618796
,	  198755104,   198891437,   199027792,   199164171
,	  199300573,   199436998,   199573447,   199709919
,	  199846415,   199982934,   200119476,   200256041
,	  200392630,   200529242,   200665877,   200802535
,	  200939217,   201075922,   201212650,   201349402
,	  201486176,   201622974,   201759795,   201896639
,	  202033507,   202170398,   202307311,   202444248
,	  202581209,   202718192,   202855198,   202992228
,	  203129281,   203266357,   203403456,   203540578
,	  203677723,   203814891,   203952082,   204089297
,	  204226534,   204363795,   204501078,   204638385
,	  204775715,   204913067,   205050443,   205187842
,	  205325264,   205462708,   205600176,   205737667
,	  205875180,   206012717,   206150277,   206287859
,	  206425465,   206563093,   206700745,   206838419
,	  206976116,   207113836,   207251579,   207389345
,	  207527134,   207664946,   207802780,   207940638
,	  208078518,   208216421,   208354347,   208492295
,	  208630267,   208768261,   208906279,   209044319
,	  209182381,   209320467,   209458575,   209596706
,	  209734860,   209873037,   210011236,   210149458
,	  210287703,   210425971,   210564261,   210702574
,	  210840910,   210979268,   211117649,   211256053
,	  211394480,   211532929,   211671400,   211809895
,	  211948412,   212086952,   212225514,   212364099
,	  212502706,   212641337,   212779989,   212918665
,	  213057363,   213196083,   213334826,   213473592
,	  213612380,   213751191,   213890024,   214028880
,	  214167758,   214306659,   214445582,   214584528
,	  214723497,   214862488,   215001501,   215140537
,	  215279595,   215418676,   215557779,   215696904
,	  215836053,   215975223,   216114416,   216253631
,	  216392869,   216532129,   216671412,   216810717
,	  216950044,   217089394,   217228766,   217368160
,	  217507577,   217647016,   217786477,   217925961
,	  218065467,   218204996,   218344546,   218484119
,	  218623715,   218763332,   218902972,   219042634
,	  219182319,   219322026,   219461754,   219601506
,	  219741279,   219881075,   220020893,   220160733
,	  220300595,   220440479,   220580386,   220720315
,	  220860266,   221000239,   221140235,   221280252
,	  221420292,   221560354,   221700438,   221840544
,	  221980672,   222120823,   222260995,   222401190
,	  222541406,   222681645,   222821906,   222962189
,	  223102494,   223242821,   223383170,   223523541
,	  223663934,   223804350,   223944787,   224085246
,	  224225728,   224366231,   224506756,   224647303
,	  224787873,   224928464,   225069077,   225209712
,	  225350370,   225491049,   225631750,   225772473
,	  225913218,   226053985,   226194773,   226335584
,	  226476417,   226617271,   226758148,   226899046
,	  227039966,   227180908,   227321872,   227462858
,	  227603865,   227744895,   227885946,   228027019
,	  228168114,   228309231,   228450369,   228591529
,	  228732712,   228873916,   229015141,   229156389
,	  229297658,   229438949,   229580262,   229721596
,	  229862953,   230004331,   230145730,   230287152
,	  230428595,   230570060,   230711546,   230853055
,	  230994585,   231136136,   231277709,   231419304
,	  231560921,   231702559,   231844219,   231985901
,	  232127604,   232269329,   232411076,   232552844
,	  232694633,   232836445,   232978278,   233120132
,	  233262008,   233403906,   233545825,   233687766
,	  233829728,   233971712,   234113717,   234255744
,	  234397793,   234539863,   234681954,   234824068
,	  234966202,   235108358,   235250536,   235392735
,	  235534955,   235677197,   235819461,   235961746
,	  236104052,   236246380,   236388729,   236531100
,	  236673492,   236815905,   236958340,   237100797
,	  237243274,   237385774,   237528294,   237670836
,	  237813399,   237955984,   238098590,   238241217
,	  238383866,   238526536,   238669228,   238811940
,	  238954674,   239097430,   239240207,   239383005
,	  239525824,   239668664,   239811526,   239954409
,	  240097314,   240240240,   240383187,   240526155
,	  240669144,   240812155,   240955187,   241098240
,	  241241314,   241384410,   241527527,   241670665
,	  241813824,   241957005,   242100206,   242243429
,	  242386673,   242529938,   242673224,   242816532
,	  242959860,   243103210,   243246581,   243389973
,	  243533386,   243676820,   243820276,   243963752
,	  244107249,   244250768,   244394308,   244537869
,	  244681450,   244825053,   244968677,   245112322
,	  245255989,   245399676,   245543384,   245687113
,	  245830863,   245974635,   246118427,   246262240
,	  246406074,   246549930,   246693806,   246837703
,	  246981621,   247125560,   247269521,   247413502
,	  247557504,   247701527,   247845571,   247989635
,	  248133721,   248277828,   248421956,   248566104
,	  248710273,   248854464,   248998675,   249142907
,	  249287160,   249431434,   249575729,   249720044
,	  249864381,   250008738,   250153116,   250297515
,	  250441935,   250586375,   250730837,   250875319
,	  251019822,   251164346,   251308890,   251453456
,	  251598042,   251742649,   251887277,   252031925
,	  252176594,   252321284,   252465995,   252610727
,	  252755479,   252900252,   253045045,   253189860
,	  253334695,   253479551,   253624427,   253769324
,	  253914242,   254059181,   254204140,   254349120
,	  254494121,   254639142,   254784184,   254929246
,	  255074329,   255219433,   255364558,   255509703
,	  255654868,   255800054,   255945261,   256090489
,	  256235737,   256381006,   256526295,   256671605
,	  256816935,   256962286,   257107657,   257253049
,	  257398462,   257543895,   257689349,   257834823
,	  257980318,   258125833,   258271369,   258416925
,	  258562502,   258708099,   258853717,   258999355
,	  259145014,   259290693,   259436392,   259582112
,	  259727853,   259873614,   260019395,   260165197
,	  260311019,   260456862,   260602725,   260748609
,	  260894513,   261040437,   261186382,   261332347
,	  261478333,   261624339,   261770365,   261916411
,	  262062478,   262208566,   262354674,   262500802
,	  262646950,   262793119,   262939308,   263085517
,	  263231747,   263377997,   263524267,   263670558
,	  263816869,   263963200,   264109551,   264255923
,	  264402315,   264548728,   264695160,   264841613
,	  264988086,   265134579,   265281093,   265427627
,	  265574181,   265720755,   265867349,   266013964
,	  266160599,   266307254,   266453929,   266600625
,	  266747340,   266894076,   267040832,   267187608
,	  267334404,   267481221,   267628057,   267774914
,	  267921791,   268068688,   268215605,   268362542
,	  268509500,   268656477,   268803475,   268950493
,	  269097530,   269244588,   269391666,   269538764
,	  269685882,   269833021,   269980179,   270127357
,	  270274555,   270421774,   270569012,   270716271
,	  270863549,   271010848,   271158166,   271305505
,	  271452863,   271600242,   271747640,   271895059
,	  272042497,   272189956,   272337434,   272484933
,	  272632451,   272779990,   272927548,   273075126
,	  273222724,   273370342,   273517981,   273665639
,	  273813316,   273961014,   274108732,   274256470
,	  274404227,   274552005,   274699802,   274847619
,	  274995456,   275143313,   275291190,   275439087
,	  275587003,   275734940,   275882896,   276030872
,	  276178868,   276326884,   276474919,   276622975
,	  276771050,   276919145,   277067260,   277215394
,	  277363549,   277511723,   277659917,   277808130
,	  277956364,   278104617,   278252890,   278401183
,	  278549496,   278697828,   278846180,   278994552
,	  279142943,   279291354,   279439785,   279588236
,	  279736706,   279885196,   280033706,   280182236
,	  280330785,   280479353,   280627942,   280776550
,	  280925178,   281073825,   281222493,   281371179
,	  281519886,   281668612,   281817358,   281966123
,	  282114908,   282263713,   282412537,   282561381
,	  282710244,   282859127,   283008030,   283156952
,	  283305894,   283454855,   283603836,   283752836
,	  283901856,   284050896,   284199955,   284349034
,	  284498132,   284647250,   284796387,   284945544
,	  285094721,   285243917,   285393132,   285542367
,	  285691621,   285840895,   285990189,   286139502
,	  286288834,   286438186,   286587557,   286736948
,	  286886358,   287035788,   287185237,   287334706
,	  287484194,   287633701,   287783228,   287932774
,	  288082340,   288231925,   288381530,   288531154
,	  288680797,   288830460,   288980142,   289129844
,	  289279565,   289429305,   289579065,   289728844
,	  289878642,   290028460,   290178297,   290328153
,	  290478029,   290627924,   290777839,   290927773
,	  291077726,   291227698,   291377690,   291527701
,	  291677731,   291827781,   291977850,   292127938
,	  292278045,   292428172,   292578318,   292728484
,	  292878668,   293028872,   293179095,   293329337
,	  293479599,   293629880,   293780180,   293930499
,	  294080837,   294231195,   294381572,   294531968
,	  294682383,   294832818,   294983272,   295133744
,	  295284237,   295434748,   295585278,   295735828
,	  295886396,   296036984,   296187591,   296338218
,	  296488863,   296639527,   296790211,   296940914
,	  297091636,   297242377,   297393137,   297543916
,	  297694714,   297845532,   297996368,   298147224
,	  298298098,   298448992,   298599905,   298750837
,	  298901788,   299052758,   299203747,   299354755
,	  299505782,   299656829,   299807894,   299958978
,	  300110081,   300261204,   300412345,   300563505
,	  300714685,   300865883,   301017101,   301168337
,	  301319592,   301470867,   301622160,   301773472
,	  301924804,   302076154,   302227523,   302378911
,	  302530318,   302681744,   302833189,   302984653
,	  303136136,   303287638,   303439159,   303590698
,	  303742257,   303893834,   304045431,   304197046
,	  304348680,   304500333,   304652005,   304803696
,	  304955405,   305107134,   305258881,   305410648
,	  305562433,   305714237,   305866060,   306017901
,	  306169762,   306321641,   306473539,   306625456
,	  306777392,   306929347,   307081320,   307233312
,	  307385323,   307537353,   307689402,   307841469
,	  307993555,   308145660,   308297784,   308449927
,	  308602088,   308754268,   308906467,   309058684
,	  309210921,   309363176,   309515449,   309667742
,	  309820053,   309972383,   310124732,   310277099
,	  310429485,   310581890,   310734313,   310886755
,	  311039216,   311191696,   311344194,   311496711
,	  311649247,   311801801,   311954374,   312106965
,	  312259575,   312412204,   312564852,   312717518
,	  312870203,   313022906,   313175628,   313328369
,	  313481128,   313633906,   313786703,   313939518
,	  314092351,   314245204,   314398074,   314550964
,	  314703872,   314856799,   315009744,   315162708
,	  315315690,   315468691,   315621710,   315774748
,	  315927805,   316080880,   316233973,   316387086
,	  316540216,   316693365,   316846533,   316999719
,	  317152924,   317306147,   317459389,   317612649
,	  317765928,   317919225,   318072541,   318225875
,	  318379228,   318532599,   318685988,   318839396
,	  318992823,   319146268,   319299731,   319453213
,	  319606713,   319760232,   319913769,   320067324
,	  320220898,   320374491,   320528101,   320681731
,	  320835378,   320989044,   321142729,   321296431
,	  321450153,   321603892,   321757650,   321911426
,	  322065221,   322219034,   322372865,   322526715
,	  322680583,   322834470,   322988374,   323142297
,	  323296239,   323450199,   323604177,   323758173
,	  323912188,   324066221,   324220272,   324374342
,	  324528430,   324682536,   324836660,   324990803
,	  325144964,   325299144,   325453341,   325607557
,	  325761791,   325916044,   326070314,   326224603
,	  326378910,   326533236,   326687579,   326841941
,	  326996321,   327150720,   327305136,   327459571
,	  327614024,   327768495,   327922984,   328077492
,	  328232018,   328386562,   328541124,   328695704
,	  328850302,   329004919,   329159554,   329314207
,	  329468878,   329623567,   329778275,   329933000
,	  330087744,   330242506,   330397286,   330552084
,	  330706900,   330861735,   331016587,   331171458
,	  331326347,   331481254,   331636178,   331791121
,	  331946083,   332101062,   332256059,   332411074
,	  332566108,   332721159,   332876229,   333031317
,	  333186422,   333341546,   333496688,   333651848
,	  333807026,   333962221,   334117435,   334272667
,	  334427917,   334583185,   334738471,   334893776
,	  335049098,   335204438,   335359796,   335515172
,	  335670566,   335825978,   335981408,   336136856
,	  336292322,   336447806,   336603308,   336758828
,	  336914365,   337069921,   337225495,   337381087
,	  337536696,   337692324,   337847969,   338003633
,	  338159314,   338315013,   338470730,   338626465
,	  338782218,   338937989,   339093778,   339249585
,	  339405409,   339561252,   339717112,   339872990
,	  340028886,   340184800,   340340732,   340496682
,	  340652650,   340808635,   340964638,   341120659
,	  341276698,   341432755,   341588830,   341744922
,	  341901032,   342057161,   342213306,   342369470
,	  342525652,   342681851,   342838068,   342994303
,	  343150556,   343306826,   343463115,   343619421
,	  343775745,   343932086,   344088446,   344244823
,	  344401218,   344557631,   344714061,   344870509
,	  345026975,   345183459,   345339960,   345496480
,	  345653016,   345809571,   345966143,   346122733
,	  346279341,   346435967,   346592610,   346749271
,	  346905949,   347062646,   347219359,   347376091
,	  347532840,   347689607,   347846392,   348003194
,	  348160014,   348316852,   348473707,   348630580
,	  348787471,   348944379,   349101305,   349258249
,	  349415210,   349572189,   349729185,   349886199
,	  350043231,   350200280,   350357347,   350514432
,	  350671534,   350828653,   350985791,   351142946
,	  351300118,   351457308,   351614516,   351771741
,	  351928984,   352086244,   352243522,   352400817
,	  352558130,   352715461,   352872809,   353030175
,	  353187558,   353344959,   353502377,   353659813
,	  353817266,   353974737,   354132225,   354289731
,	  354447254,   354604795,   354762354,   354919929
,	  355077523,   355235134,   355392762,   355550408
,	  355708071,   355865752,   356023450,   356181166
,	  356338899,   356496649,   356654418,   356812203
,	  356970006,   357127826,   357285664,   357443520
,	  357601392,   357759282,   357917190,   358075115
,	  358233057,   358391017,   358548994,   358706989
,	  358865001,   359023030,   359181077,   359339141
,	  359497223,   359655322,   359813438,   359971572
,	  360129723,   360287891,   360446077,   360604280
,	  360762501,   360920738,   361078994,   361237266
,	  361395556,   361553863,   361712188,   361870530
,	  362028889,   362187265,   362345659,   362504070
,	  362662499,   362820944,   362979407,   363137888
,	  363296385,   363454900,   363613432,   363771982
,	  363930549,   364089133,   364247734,   364406353
,	  364564988,   364723642,   364882312,   365041000
,	  365199704,   365358426,   365517166,   365675922
,	  365834696,   365993487,   366152296,   366311121
,	  366469964,   366628824,   366787701,   366946595
,	  367105507,   367264435,   367423381,   367582344
,	  367741325,   367900322,   368059337,   368218369
,	  368377418,   368536484,   368695567,   368854668
,	  369013785,   369172920,   369332072,   369491241
,	  369650428,   369809631,   369968852,   370128089
,	  370287344,   370446616,   370605905,   370765211
,	  370924535,   371083875,   371243232,   371402607
,	  371561999,   371721408,   371880833,   372040276
,	  372199737,   372359214,   372518708,   372678219
,	  372837748,   372997293,   373156856,   373316435
,	  373476032,   373635645,   373795276,   373954924
,	  374114589,   374274270,   374433969,   374593685
,	  374753418,   374913168,   375072935,   375232719
,	  375392520,   375552338,   375712173,   375872025
,	  376031894,   376191780,   376351683,   376511603
,	  376671540,   376831494,   376991465,   377151453
,	  377311458,   377471479,   377631518,   377791574
,	  377951647,   378111736,   378271843,   378431966
,	  378592107,   378752264,   378912439,   379072630
,	  379232838,   379393063,   379553305,   379713564
,	  379873840,   380034133,   380194443,   380354769
,	  380515113,   380675473,   380835850,   380996244
,	  381156655,   381317083,   381477528,   381637990
,	  381798468,   381958964,   382119476,   382280005
,	  382440551,   382601114,   382761694,   382922290
,	  383082903,   383243534,   383404181,   383564844
,	  383725525,   383886223,   384046937,   384207668
,	  384368416,   384529181,   384689962,   384850761
,	  385011576,   385172408,   385333256,   385494122
,	  385655004,   385815903,   385976819,   386137752
,	  386298701,   386459667,   386620650,   386781650
,	  386942667,   387103700,   387264750,   387425816
,	  387586900,   387748000,   387909117,   388070251
,	  388231401,   388392568,   388553752,   388714952
,	  388876170,   389037404,   389198654,   389359922
,	  389521206,   389682507,   389843824,   390005158
,	  390166509,   390327877,   390489261,   390650662
,	  390812079,   390973513,   391134964,   391296432
,	  391457916,   391619417,   391780934,   391942469
,	  392104019,   392265587,   392427171,   392588772
,	  392750389,   392912023,   393073674,   393235341
,	  393397025,   393558725,   393720442,   393882176
,	  394043926,   394205693,   394367477,   394529277
,	  394691093,   394852927,   395014776,   395176643
,	  395338526,   395500425,   395662342,   395824274
,	  395986224,   396148189,   396310172,   396472171
,	  396634186,   396796218,   396958267,   397120332
,	  397282414,   397444512,   397606627,   397768758
,	  397930906,   398093070,   398255251,   398417448
,	  398579662,   398741892,   398904139,   399066402
,	  399228682,   399390979,   399553291,   399715621
,	  399877966,   400040329,   400202707,   400365103
,	  400527514,   400689943,   400852387,   401014848
,	  401177326,   401339820,   401502330,   401664857
,	  401827400,   401989960,   402152536,   402315129
,	  402477738,   402640363,   402803005,   402965664
,	  403128338,   403291030,   403453737,   403616461
,	  403779201,   403941958,   404104731,   404267521
,	  404430327,   404593149,   404755988,   404918843
,	  405081715,   405244602,   405407507,   405570427
,	  405733364,   405896317,   406059287,   406222273
,	  406385275,   406548294,   406711329,   406874381
,	  407037448,   407200532,   407363633,   407526750
,	  407689883,   407853032,   408016198,   408179380
,	  408342578,   408505793,   408669024,   408832271
,	  408995534,   409158814,   409322110,   409485423
,	  409648751,   409812096,   409975457,   410138835
,	  410302229,   410465639,   410629065,   410792508
,	  410955967,   411119442,   411282933,   411446441
,	  411609964,   411773505,   411937061,   412100633
,	  412264222,   412427827,   412591449,   412755086
,	  412918740,   413082410,   413246096,   413409798
,	  413573517,   413737251,   413901002,   414064769
,	  414228553,   414392352,   414556168,   414720000
,	  414883848,   415047712,   415211593,   415375489
,	  415539402,   415703331,   415867276,   416031238
,	  416195215,   416359209,   416523218,   416687244
,	  416851286,   417015344,   417179419,   417343509
,	  417507616,   417671738,   417835877,   418000032
,	  418164203,   418328390,   418492594,   418656813
,	  418821048,   418985300,   419149568,   419313852
,	  419478151,   419642467,   419806800,   419971148
,	  420135512,   420299892,   420464289,   420628701
,	  420793130,   420957574,   421122035,   421286511
,	  421451004,   421615513,   421780038,   421944579
,	  422109136,   422273709,   422438298,   422602903
,	  422767524,   422932161,   423096814,   423261483
,	  423426168,   423590870,   423755587,   423920320
,	  424085069,   424249834,   424414616,   424579413
,	  424744226,   424909055,   425073900,   425238762
,	  425403639,   425568532,   425733441,   425898366
,	  426063307,   426228264,   426393237,   426558226
,	  426723231,   426888252,   427053288,   427218341
,	  427383410,   427548494,   427713595,   427878711
,	  428043844,   428208992,   428374156,   428539337
,	  428704533,   428869745,   429034973,   429200217
,	  429365476,   429530752,   429696043,   429861351
,	  430026674,   430192013,   430357369,   430522740
,	  430688126,   430853529,   431018948,   431184382
,	  431349833,   431515299,   431680781,   431846279
,	  432011793,   432177323,   432342868,   432508430
,	  432674007,   432839600,   433005209,   433170834
,	  433336474,   433502131,   433667803,   433833491
,	  433999195,   434164914,   434330650,   434496401
,	  434662168,   434827951,   434993750,   435159565
,	  435325395,   435491241,   435657103,   435822981
,	  435988874,   436154784,   436320709,   436486650
,	  436652606,   436818579,   436984567,   437150571
,	  437316590,   437482626,   437648677,   437814744
,	  437980827,   438146925,   438313039,   438479169
,	  438645315,   438811476,   438977653,   439143846
,	  439310055,   439476279,   439642519,   439808775
,	  439975046,   440141333,   440307636,   440473955
,	  440640289,   440806639,   440973005,   441139386
,	  441305783,   441472196,   441638624,   441805068
,	  441971528,   442138004,   442304495,   442471002
,	  442637524,   442804062,   442970616,   443137185
,	  443303770,   443470371,   443636988,   443803620
,	  443970267,   444136931,   444303610,   444470304
,	  444637014,   444803740,   444970482,   445137239
,	  445304012,   445470800,   445637604,   445804423
,	  445971259,   446138109,   446304976,   446471858
,	  446638755,   446805668,   446972597,   447139542
,	  447306501,   447473477,   447640468,   447807475
,	  447974497,   448141535,   448308588,   448475657
,	  448642742,   448809842,   448976957,   449144088
,	  449311235,   449478397,   449645575,   449812768
,	  449979977,   450147202,   450314442,   450481697
,	  450648968,   450816255,   450983557,   451150874
,	  451318207,   451485556,   451652920,   451820300
,	  451987695,   452155105,   452322531,   452489973
,	  452657430,   452824903,   452992391,   453159894
,	  453327413,   453494948,   453662498,   453830063
,	  453997644,   454165240,   454332852,   454500480
,	  454668122,   454835781,   455003454,   455171143
,	  455338848,   455506568,   455674303,   455842054
,	  456009821,   456177602,   456345399,   456513212
,	  456681040,   456848884,   457016742,   457184617
,	  457352506,   457520411,   457688332,   457856268
,	  458024219,   458192186,   458360168,   458528165
,	  458696178,   458864207,   459032250,   459200309
,	  459368384,   459536474,   459704579,   459872699
,	  460040835,   460208986,   460377153,   460545335
,	  460713532,   460881745,   461049973,   461218216
,	  461386475,   461554749,   461723039,   461891343
,	  462059663,   462227999,   462396350,   462564716
,	  462733097,   462901494,   463069906,   463238333
,	  463406776,   463575234,   463743707,   463912196
,	  464080699,   464249219,   464417753,   464586303
,	  464754868,   464923448,   465092044,   465260655
,	  465429281,   465597922,   465766579,   465935251
,	  466103938,   466272641,   466441358,   466610091
,	  466778840,   466947603,   467116382,   467285176
,	  467453985,   467622810,   467791650,   467960505
,	  468129375,   468298260,   468467161,   468636077
,	  468805008,   468973954,   469142916,   469311893
,	  469480885,   469649892,   469818914,   469987952
,	  470157005,   470326073,   470495156,   470664254
,	  470833368,   471002497,   471171641,   471340800
,	  471509974,   471679164,   471848368,   472017588
,	  472186823,   472356073,   472525339,   472694619
,	  472863915,   473033226,   473202552,   473371893
,	  473541249,   473710620,   473880007,   474049409
,	  474218825,   474388257,   474557704,   474727167
,	  474896644,   475066136,   475235644,   475405167
,	  475574704,   475744257,   475913825,   476083408
,	  476253007,   476422620,   476592248,   476761892
,	  476931550,   477101224,   477270913,   477440617
,	  477610336,   477780070,   477949819,   478119583
,	  478289362,   478459157,   478628966,   478798790
,	  478968630,   479138484,   479308354,   479478239
,	  479648138,   479818053,   479987983,   480157928
,	  480327888,   480497863,   480667853,   480837858
,	  481007878,   481177913,   481347963,   481518028
,	  481688108,   481858203,   482028313,   482198438
,	  482368578,   482538734,   482708904,   482879089
,	  483049289,   483219504,   483389734,   483559979
,	  483730240,   483900515,   484070805,   484241110
,	  484411430,   484581765,   484752115,   484922480
,	  485092860,   485263254,   485433664,   485604089
,	  485774529,   485944983,   486115453,   486285938
,	  486456437,   486626952,   486797481,   486968025
,	  487138585,   487309159,   487479748,   487650352
,	  487820971,   487991605,   488162254,   488332917
,	  488503596,   488674290,   488844998,   489015721
,	  489186460,   489357213,   489527981,   489698764
,	  489869562,   490040374,   490211202,   490382044
,	  490552902,   490723774,   490894661,   491065563
,	  491236480,   491407412,   491578358,   491749320
,	  491920296,   492091287,   492262294,   492433314
,	  492604350,   492775401,   492946466,   493117547
,	  493288642,   493459752,   493630876,   493802016
,	  493973171,   494144340,   494315524,   494486723
,	  494657937,   494829165,   495000409,   495171667
,	  495342940,   495514228,   495685530,   495856848
,	  496028180,   496199527,   496370889,   496542265
,	  496713657,   496885063,   497056484,   497227919
,	  497399370,   497570835,   497742315,   497913810
,	  498085320,   498256844,   498428383,   498599937
,	  498771506,   498943089,   499114687,   499286300
,	  499457928,   499629570,   499801227,   499972899
,	  500144586,   500316287,   500488003,   500659734
,	  500831480,   501003240,   501175015,   501346805
,	  501518609,   501690428,   501862262,   502034111
,	  502205974,   502377852,   502549745,   502721652
,	  502893574,   503065511,   503237462,   503409429
,	  503581409,   503753405,   503925415,   504097440
,	  504269480,   504441534,   504613603,   504785686
,	  504957785,   505129897,   505302025,   505474167
,	  505646324,   505818496,   505990682,   506162883
,	  506335098,   506507328,   506679573,   506851833
,	  507024107,   507196395,   507368699,   507541017
,	  507713349,   507885697,   508058058,   508230435
,	  508402826,   508575232,   508747652,   508920087
,	  509092536,   509265000,   509437479,   509609972
,	  509782480,   509955003,   510127540,   510300092
,	  510472658,   510645239,   510817834,   510990444
,	  511163069,   511335708,   511508362,   511681030
,	  511853713,   512026411,   512199123,   512371849
,	  512544590,   512717346,   512890116,   513062901
,	  513235701,   513408514,   513581343,   513754186
,	  513927043,   514099916,   514272802,   514445703
,	  514618619,   514791549,   514964494,   515137453
,	  515310427,   515483415,   515656418,   515829435
,	  516002467,   516175513,   516348574,   516521649
,	  516694739,   516867844,   517040962,   517214096
,	  517387243,   517560406,   517733582,   517906774
,	  518079979,   518253200,   518426434,   518599683
,	  518772947,   518946225,   519119518,   519292825
,	  519466146,   519639482,   519812833,   519986197
,	  520159577,   520332970,   520506379,   520679801
,	  520853238,   521026690,   521200156,   521373636
,	  521547131,   521720640,   521894164,   522067702
,	  522241255,   522414822,   522588403,   522761999
,	  522935609,   523109234,   523282873,   523456526
,	  523630194,   523803876,   523977573,   524151284
,	  524325009,   524498749,   524672503,   524846272
,	  525020055,   525193852,   525367664,   525541490
,	  525715330,   525889185,   526063054,   526236938
,	  526410836,   526584748,   526758675,   526932616
,	  527106571,   527280541,   527454525,   527628524
,	  527802536,   527976563,   528150605,   528324661
,	  528498731,   528672815,   528846914,   529021027
,	  529195155,   529369297,   529543453,   529717623
,	  529891808,   530066007,   530240220,   530414448
,	  530588690,   530762946,   530937217,   531111502
,	  531285801,   531460115,   531634442,   531808785
,	  531983141,   532157512,   532331897,   532506296
,	  532680709,   532855137,   533029579,   533204036
,	  533378506,   533552991,   533727490,   533902004
,	  534076531,   534251073,   534425630,   534600200
,	  534774785,   534949384,   535123997,   535298624
,	  535473266,   535647922,   535822592,   535997276
,	  536171975,   536346688,   536521415,   536696156
,	  536870912,   537045682,   537220466,   537395264
,	  537570076,   537744903,   537919744,   538094599
,	  538269468,   538444352,   538619249,   538794161
,	  538969087,   539144028,   539318982,   539493951
,	  539668934,   539843931,   540018942,   540193967
,	  540369007,   540544060,   540719128,   540894210
,	  541069307,   541244417,   541419542,   541594680
,	  541769833,   541945000,   542120182,   542295377
,	  542470587,   542645810,   542821048,   542996300
,	  543171566,   543346846,   543522141,   543697449
,	  543872772,   544048109,   544223460,   544398825
,	  544574204,   544749597,   544925004,   545100426
,	  545275862,   545451311,   545626775,   545802253
,	  545977745,   546153251,   546328772,   546504306
,	  546679854,   546855417,   547030994,   547206584
,	  547382189,   547557808,   547733441,   547909088
,	  548084749,   548260425,   548436114,   548611817
,	  548787535,   548963266,   549139012,   549314771
,	  549490545,   549666333,   549842135,   550017950
,	  550193780,   550369624,   550545482,   550721354
,	  550897241,   551073141,   551249055,   551424983
,	  551600925,   551776882,   551952852,   552128836
,	  552304835,   552480847,   552656873,   552832914
,	  553008968,   553185037,   553361119,   553537215
,	  553713326,   553889450,   554065589,   554241741
,	  554417908,   554594088,   554770283,   554946491
,	  555122714,   555298950,   555475201,   555651465
,	  555827743,   556004036,   556180342,   556356662
,	  556532997,   556709345,   556885707,   557062083
,	  557238473,   557414877,   557591295,   557767727
,	  557944173,   558120633,   558297107,   558473595
,	  558650097,   558826612,   559003142,   559179686
,	  559356243,   559532814,   559709400,   559885999
,	  560062612,   560239240,   560415881,   560592536
,	  560769205,   560945887,   561122584,   561299295
,	  561476019,   561652758,   561829510,   562006276
,	  562183057,   562359851,   562536659,   562713480
,	  562890316,   563067166,   563244029,   563420907
,	  563597798,   563774703,   563951622,   564128555
,	  564305502,   564482463,   564659437,   564836426
,	  565013428,   565190444,   565367474,   565544518
,	  565721576,   565898647,   566075733,   566252832
,	  566429945,   566607072,   566784213,   566961368
,	  567138536,   567315719,   567492915,   567670125
,	  567847349,   568024586,   568201838,   568379103
,	  568556382,   568733675,   568910982,   569088303
,	  569265637,   569442985,   569620347,   569797723
,	  569975113,   570152516,   570329933,   570507365
,	  570684809,   570862268,   571039740,   571217227
,	  571394727,   571572240,   571749768,   571927309
,	  572104865,   572282433,   572460016,   572637613
,	  572815223,   572992847,   573170485,   573348136
,	  573525802,   573703481,   573881173,   574058880
,	  574236600,   574414334,   574592082,   574769844
,	  574947619,   575125408,   575303211,   575481028
,	  575658858,   575836702,   576014560,   576192431
,	  576370316,   576548215,   576726128,   576904054
,	  577081994,   577259948,   577437916,   577615897
,	  577793892,   577971901,   578149923,   578327959
,	  578506009,   578684072,   578862149,   579040240
,	  579218345,   579396463,   579574595,   579752741
,	  579930900,   580109073,   580287260,   580465460
,	  580643674,   580821902,   581000143,   581178399
,	  581356667,   581534950,   581713246,   581891555
,	  582069879,   582248216,   582426567,   582604931
,	  582783309,   582961701,   583140106,   583318525
,	  583496958,   583675404,   583853864,   584032337
,	  584210825,   584389325,   584567840,   584746368
,	  584924910,   585103465,   585282034,   585460616
,	  585639213,   585817822,   585996446,   586175083
,	  586353733,   586532398,   586711076,   586889767
,	  587068472,   587247191,   587425923,   587604669
,	  587783428,   587962201,   588140988,   588319788
,	  588498602,   588677429,   588856270,   589035125
,	  589213993,   589392875,   589571770,   589750679
,	  589929601,   590108537,   590287487,   590466450
,	  590645427,   590824417,   591003421,   591182438
,	  591361469,   591540513,   591719571,   591898643
,	  592077728,   592256827,   592435939,   592615065
,	  592794204,   592973357,   593152523,   593331703
,	  593510896,   593690103,   593869324,   594048558
,	  594227805,   594407066,   594586341,   594765629
,	  594944930,   595124245,   595303574,   595482916
,	  595662271,   595841640,   596021023,   596200419
,	  596379829,   596559252,   596738688,   596918138
,	  597097602,   597277079,   597456569,   597636073
,	  597815591,   597995122,   598174666,   598354224
,	  598533795,   598713380,   598892979,   599072590
,	  599252216,   599431854,   599611506,   599791172
,	  599970851,   600150544,   600330250,   600509969
,	  600689702,   600869448,   601049208,   601228981
,	  601408768,   601588568,   601768381,   601948208
,	  602128049,   602307902,   602487770,   602667650
,	  602847544,   603027452,   603207373,   603387307
,	  603567255,   603747216,   603927191,   604107179
,	  604287180,   604467195,   604647223,   604827265
,	  605007320,   605187388,   605367470,   605547565
,	  605727674,   605907796,   606087931,   606268080
,	  606448242,   606628417,   606808606,   606988808
,	  607169024,   607349253,   607529496,   607709751
,	  607890020,   608070303,   608250599,   608430908
,	  608611231,   608791566,   608971916,   609152278
,	  609332654,   609513044,   609693446,   609873862
,	  610054292,   610234735,   610415191,   610595660
,	  610776143,   610956639,   611137148,   611317671
,	  611498207,   611678756,   611859319,   612039895
,	  612220484,   612401087,   612581703,   612762332
,	  612942975,   613123631,   613304300,   613484983
,	  613665679,   613846388,   614027110,   614207846
,	  614388595,   614569357,   614750133,   614930922
,	  615111724,   615292540,   615473368,   615654210
,	  615835066,   616015934,   616196816,   616377712
,	  616558620,   616739542,   616920477,   617101425
,	  617282386,   617463361,   617644349,   617825351
,	  618006365,   618187393,   618368434,   618549488
,	  618730556,   618911637,   619092731,   619273838
,	  619454959,   619636093,   619817240,   619998400
,	  620179573,   620360760,   620541960,   620723173
,	  620904400,   621085639,   621266892,   621448158
,	  621629438,   621810730,   621992036,   622173355
,	  622354687,   622536032,   622717391,   622898763
,	  623080148,   623261546,   623442957,   623624382
,	  623805820,   623987271,   624168735,   624350212
,	  624531703,   624713207,   624894724,   625076254
,	  625257797,   625439354,   625620923,   625802506
,	  625984102,   626165711,   626347334,   626528969
,	  626710618,   626892280,   627073955,   627255643
,	  627437344,   627619058,   627800786,   627982527
,	  628164281,   628346048,   628527828,   628709621
,	  628891428,   629073248,   629255080,   629436926
,	  629618785,   629800658,   629982543,   630164441
,	  630346353,   630528278,   630710215,   630892166
,	  631074130,   631256108,   631438098,   631620101
,	  631802118,   631984147,   632166190,   632348246
,	  632530315,   632712397,   632894492,   633076600
,	  633258722,   633440856,   633623004,   633805164
,	  633987338,   634169525,   634351725,   634533938
,	  634716164,   634898403,   635080655,   635262921
,	  635445199,   635627490,   635809795,   635992113
,	  636174443,   636356787,   636539144,   636721514
,	  636903896,   637086292,   637268701,   637451123
,	  637633559,   637816007,   637998468,   638180942
,	  638363430,   638545930,   638728443,   638910970
,	  639093509,   639276062,   639458627,   639641206
,	  639823797,   640006402,   640189020,   640371650
,	  640554294,   640736951,   640919621,   641102303
,	  641284999,   641467708,   641650430,   641833165
,	  642015912,   642198673,   642381447,   642564234
,	  642747034,   642929846,   643112672,   643295511
,	  643478363,   643661228,   643844105,   644026996
,	  644209900,   644392817,   644575746,   644758689
,	  644941645,   645124613,   645307595,   645490590
,	  645673597,   645856618,   646039651,   646222698
,	  646405757,   646588830,   646771915,   646955013
,	  647138125,   647321249,   647504386,   647687536
,	  647870699,   648053875,   648237064,   648420266
,	  648603481,   648786709,   648969949,   649153203
,	  649336470,   649519749,   649703042,   649886347
,	  650069665,   650252997,   650436341,   650619698
,	  650803068,   650986451,   651169847,   651353255
,	  651536677,   651720112,   651903559,   652087020
,	  652270493,   652453979,   652637478,   652820990
,	  653004515,   653188053,   653371604,   653555167
,	  653738744,   653922333,   654105935,   654289550
,	  654473178,   654656819,   654840473,   655024140
,	  655207819,   655391512,   655575217,   655758935
,	  655942666,   656126410,   656310167,   656493936
,	  656677719,   656861514,   657045322,   657229143
,	  657412977,   657596824,   657780683,   657964556
,	  658148441,   658332339,   658516250,   658700174
,	  658884111,   659068060,   659252023,   659435998
,	  659619986,   659803987,   659988000,   660172027
,	  660356066,   660540118,   660724183,   660908261
,	  661092351,   661276455,   661460571,   661644700
,	  661828842,   662012997,   662197164,   662381344
,	  662565538,   662749743,   662933962,   663118194
,	  663302438,   663486695,   663670965,   663855247
,	  664039543,   664223851,   664408172,   664592506
,	  664776853,   664961212,   665145584,   665329969
,	  665514367,   665698777,   665883200,   666067636
,	  666252085,   666436547,   666621021,   666805508
,	  666990008,   667174521,   667359046,   667543584
,	  667728135,   667912699,   668097275,   668281864
,	  668466466,   668651081,   668835708,   669020348
,	  669205001,   669389667,   669574345,   669759036
,	  669943740,   670128456,   670313185,   670497927
,	  670682682,   670867450,   671052230,   671237023
,	  671421828,   671606647,   671791478,   671976321
,	  672161178,   672346047,   672530929,   672715823
,	  672900731,   673085651,   673270583,   673455529
,	  673640487,   673825458,   674010441,   674195437
,	  674380446,   674565468,   674750502,   674935549
,	  675120609,   675305681,   675490766,   675675863
,	  675860974,   676046097,   676231232,   676416381
,	  676601542,   676786716,   676971902,   677157101
,	  677342313,   677527537,   677712774,   677898024
,	  678083286,   678268561,   678453849,   678639149
,	  678824462,   679009787,   679195126,   679380477
,	  679565840,   679751216,   679936605,   680122006
,	  680307421,   680492847,   680678287,   680863739
,	  681049203,   681234680,   681420170,   681605673
,	  681791188,   681976716,   682162256,   682347809
,	  682533374,   682718953,   682904543,   683090147
,	  683275763,   683461391,   683647033,   683832687
,	  684018353,   684204032,   684389724,   684575428
,	  684761145,   684946874,   685132616,   685318371
,	  685504138,   685689918,   685875710,   686061515
,	  686247332,   686433163,   686619005,   686804861
,	  686990728,   687176609,   687362502,   687548407
,	  687734325,   687920256,   688106199,   688292155
,	  688478123,   688664104,   688850098,   689036104
,	  689222122,   689408154,   689594197,   689780254
,	  689966322,   690152404,   690338498,   690524604
,	  690710723,   690896854,   691082998,   691269155
,	  691455324,   691641506,   691827700,   692013907
,	  692200126,   692386358,   692572602,   692758859
,	  692945128,   693131410,   693317704,   693504011
,	  693690330,   693876662,   694063007,   694249364
,	  694435733,   694622115,   694808509,   694994916
,	  695181336,   695367768,   695554212,   695740669
,	  695927138,   696113620,   696300115,   696486621
,	  696673141,   696859673,   697046217,   697232774
,	  697419343,   697605925,   697792519,   697979126
,	  698165745,   698352377,   698539021,   698725677
,	  698912347,   699099028,   699285722,   699472429
,	  699659147,   699845879,   700032623,   700219379
,	  700406148,   700592929,   700779723,   700966529
,	  701153347,   701340178,   701527022,   701713878
,	  701900746,   702087627,   702274520,   702461425
,	  702648343,   702835274,   703022217,   703209172
,	  703396140,   703583120,   703770113,   703957118
,	  704144135,   704331165,   704518208,   704705262
,	  704892329,   705079409,   705266501,   705453605
,	  705640722,   705827851,   706014993,   706202147
,	  706389313,   706576492,   706763683,   706950887
,	  707138103,   707325331,   707512572,   707699825
,	  707887090,   708074368,   708261659,   708448961
,	  708636276,   708823604,   709010944,   709198296
,	  709385660,   709573037,   709760427,   709947828
,	  710135242,   710322669,   710510107,   710697559
,	  710885022,   711072498,   711259986,   711447487
,	  711635000,   711822525,   712010063,   712197613
,	  712385175,   712572750,   712760337,   712947936
,	  713135548,   713323172,   713510808,   713698457
,	  713886118,   714073791,   714261477,   714449175
,	  714636885,   714824608,   715012343,   715200090
,	  715387850,   715575622,   715763406,   715951203
,	  716139012,   716326833,   716514667,   716702513
,	  716890371,   717078242,   717266124,   717454019
,	  717641927,   717829847,   718017779,   718205723
,	  718393680,   718581648,   718769630,   718957623
,	  719145629,   719333647,   719521677,   719709720
,	  719897775,   720085842,   720273922,   720462013
,	  720650117,   720838234,   721026362,   721214503
,	  721402656,   721590822,   721778999,   721967189
,	  722155392,   722343606,   722531833,   722720072
,	  722908323,   723096587,   723284862,   723473150
,	  723661451,   723849763,   724038088,   724226425
,	  724414774,   724603136,   724791509,   724979895
,	  725168294,   725356704,   725545127,   725733562
,	  725922009,   726110468,   726298940,   726487424
,	  726675920,   726864428,   727052949,   727241481
,	  727430026,   727618583,   727807153,   727995734
,	  728184328,   728372934,   728561553,   728750183
,	  728938826,   729127480,   729316148,   729504827
,	  729693518,   729882222,   730070938,   730259666
,	  730448406,   730637159,   730825923,   731014700
,	  731203489,   731392290,   731581104,   731769929
,	  731958767,   732147617,   732336479,   732525353
,	  732714240,   732903139,   733092049,   733280972
,	  733469908,   733658855,   733847814,   734036786
,	  734225770,   734414766,   734603774,   734792794
,	  734981827,   735170871,   735359928,   735548997
,	  735738078,   735927171,   736116277,   736305394
,	  736494524,   736683666,   736872820,   737061986
,	  737251164,   737440354,   737629557,   737818771
,	  738007998,   738197237,   738386488,   738575751
,	  738765026,   738954314,   739143613,   739332925
,	  739522249,   739711585,   739900933,   740090293
,	  740279665,   740469049,   740658446,   740847854
,	  741037275,   741226708,   741416152,   741605609
,	  741795078,   741984560,   742174053,   742363558
,	  742553076,   742742605,   742932147,   743121701
,	  743311266,   743500844,   743690434,   743880036
,	  744069651,   744259277,   744448915,   744638566
,	  744828228,   745017903,   745207589,   745397288
,	  745586999,   745776721,   745966456,   746156203
,	  746345962,   746535733,   746725517,   746915312
,	  747105119,   747294938,   747484770,   747674613
,	  747864469,   748054336,   748244216,   748434107
,	  748624011,   748813927,   749003855,   749193794
,	  749383746,   749573710,   749763686,   749953674
,	  750143674,   750333686,   750523710,   750713746
,	  750903794,   751093854,   751283926,   751474011
,	  751664107,   751854215,   752044335,   752234467
,	  752424612,   752614768,   752804936,   752995117
,	  753185309,   753375513,   753565729,   753755958
,	  753946198,   754136450,   754326715,   754516991
,	  754707279,   754897580,   755087892,   755278216
,	  755468553,   755658901,   755849261,   756039633
,	  756230018,   756420414,   756610822,   756801242
,	  756991675,   757182119,   757372575,   757563043
,	  757753523,   757944015,   758134519,   758325035
,	  758515563,   758706103,   758896655,   759087219
,	  759277794,   759468382,   759658982,   759849593
,	  760040217,   760230853,   760421500,   760612160
,	  760802831,   760993514,   761184210,   761374917
,	  761565636,   761756367,   761947110,   762137866
,	  762328632,   762519411,   762710202,   762901005
,	  763091820,   763282646,   763473485,   763664335
,	  763855198,   764046072,   764236958,   764427856
,	  764618767,   764809689,   765000622,   765191568
,	  765382526,   765573496,   765764477,   765955471
,	  766146476,   766337493,   766528523,   766719564
,	  766910617,   767101682,   767292758,   767483847
,	  767674948,   767866060,   768057185,   768248321
,	  768439469,   768630629,   768821801,   769012985
,	  769204180,   769395388,   769586607,   769777839
,	  769969082,   770160337,   770351604,   770542883
,	  770734174,   770925476,   771116791,   771308117
,	  771499455,   771690805,   771882167,   772073541
,	  772264926,   772456324,   772647733,   772839155
,	  773030588,   773222032,   773413489,   773604958
,	  773796438,   773987931,   774179435,   774370951
,	  774562479,   774754018,   774945570,   775137133
,	  775328708,   775520295,   775711894,   775903505
,	  776095127,   776286762,   776478408,   776670066
,	  776861736,   777053417,   777245111,   777436816
,	  777628533,   777820262,   778012003,   778203755
,	  778395520,   778587296,   778779084,   778970884
,	  779162695,   779354519,   779546354,   779738201
,	  779930060,   780121930,   780313813,   780505707
,	  780697613,   780889531,   781081460,   781273402
,	  781465355,   781657320,   781849297,   782041285
,	  782233285,   782425297,   782617321,   782809357
,	  783001404,   783193464,   783385535,   783577617
,	  783769712,   783961818,   784153936,   784346066
,	  784538208,   784730361,   784922526,   785114703
,	  785306892,   785499092,   785691304,   785883528
,	  786075764,   786268012,   786460271,   786652542
,	  786844824,   787037119,   787229425,   787421743
,	  787614073,   787806414,   787998767,   788191132
,	  788383509,   788575897,   788768297,   788960709
,	  789153133,   789345568,   789538015,   789730474
,	  789922944,   790115426,   790307920,   790500426
,	  790692943,   790885472,   791078013,   791270566
,	  791463130,   791655706,   791848294,   792040893
,	  792233504,   792426127,   792618762,   792811408
,	  793004066,   793196735,   793389417,   793582110
,	  793774814,   793967531,   794160259,   794352999
,	  794545750,   794738513,   794931288,   795124075
,	  795316873,   795509683,   795702505,   795895338
,	  796088183,   796281039,   796473908,   796666788
,	  796859680,   797052583,   797245498,   797438425
,	  797631363,   797824313,   798017275,   798210248
,	  798403233,   798596230,   798789238,   798982258
,	  799175290,   799368333,   799561388,   799754455
,	  799947533,   800140623,   800333725,   800526838
,	  800719963,   800913099,   801106248,   801299407
,	  801492579,   801685762,   801878957,   802072163
,	  802265381,   802458611,   802651852,   802845105
,	  803038370,   803231646,   803424934,   803618233
,	  803811544,   804004867,   804198201,   804391547
,	  804584905,   804778274,   804971654,   805165047
,	  805358451,   805551866,   805745294,   805938733
,	  806132183,   806325645,   806519119,   806712604
,	  806906101,   807099609,   807293129,   807486661
,	  807680204,   807873759,   808067326,   808260904
,	  808454493,   808648094,   808841707,   809035332
,	  809228968,   809422615,   809616274,   809809945
,	  810003627,   810197321,   810391027,   810584744
,	  810778472,   810972213,   811165964,   811359728
,	  811553503,   811747289,   811941087,   812134897
,	  812328718,   812522551,   812716395,   812910251
,	  813104118,   813297997,   813491888,   813685790
,	  813879703,   814073628,   814267565,   814461513
,	  814655473,   814849445,   815043427,   815237422
,	  815431428,   815625445,   815819475,   816013515
,	  816207567,   816401631,   816595706,   816789793
,	  816983891,   817178001,   817372122,   817566255
,	  817760400,   817954555,   818148723,   818342902
,	  818537092,   818731294,   818925508,   819119733
,	  819313969,   819508217,   819702477,   819896748
,	  820091031,   820285325,   820479630,   820673947
,	  820868276,   821062616,   821256968,   821451331
,	  821645705,   821840091,   822034489,   822228898
,	  822423319,   822617751,   822812194,   823006649
,	  823201116,   823395594,   823590083,   823784584
,	  823979097,   824173621,   824368156,   824562703
,	  824757261,   824951831,   825146413,   825341005
,	  825535610,   825730225,   825924853,   826119491
,	  826314141,   826508803,   826703476,   826898160
,	  827092856,   827287564,   827482283,   827677013
,	  827871755,   828066508,   828261273,   828456049
,	  828650837,   828845636,   829040446,   829235268
,	  829430102,   829624946,   829819803,   830014670
,	  830209550,   830404440,   830599342,   830794256
,	  830989181,   831184117,   831379065,   831574024
,	  831768994,   831963976,   832158970,   832353975
,	  832548991,   832744019,   832939058,   833134109
,	  833329170,   833524244,   833719329,   833914425
,	  834109533,   834304652,   834499782,   834694924
,	  834890077,   835085242,   835280418,   835475605
,	  835670804,   835866015,   836061236,   836256469
,	  836451714,   836646970,   836842237,   837037516
,	  837232806,   837428107,   837623420,   837818744
,	  838014080,   838209427,   838404785,   838600155
,	  838795536,   838990928,   839186332,   839381747
,	  839577174,   839772612,   839968061,   840163522
,	  840358994,   840554478,   840749972,   840945479
,	  841140996,   841336525,   841532065,   841727617
,	  841923180,   842118754,   842314340,   842509937
,	  842705546,   842901165,   843096797,   843292439
,	  843488093,   843683758,   843879435,   844075122
,	  844270822,   844466532,   844662254,   844857987
,	  845053732,   845249488,   845445255,   845641034
,	  845836823,   846032625,   846228437,   846424261
,	  846620096,   846815943,   847011801,   847207670
,	  847403550,   847599442,   847795345,   847991260
,	  848187186,   848383123,   848579071,   848775031
,	  848971002,   849166984,   849362978,   849558983
,	  849754999,   849951027,   850147065,   850343116
,	  850539177,   850735250,   850931334,   851127429
,	  851323536,   851519654,   851715783,   851911924
,	  852108076,   852304239,   852500413,   852696599
,	  852892796,   853089004,   853285224,   853481454
,	  853677697,   853873950,   854070215,   854266491
,	  854462778,   854659076,   854855386,   855051707
,	  855248039,   855444383,   855640738,   855837104
,	  856033481,   856229870,   856426270,   856622681
,	  856819103,   857015537,   857211982,   857408438
,	  857604905,   857801384,   857997874,   858194375
,	  858390888,   858587411,   858783946,   858980492
,	  859177050,   859373619,   859570198,   859766790
,	  859963392,   860160006,   860356630,   860553267
,	  860749914,   860946572,   861143242,   861339923
,	  861536615,   861733319,   861930034,   862126760
,	  862323497,   862520245,   862717005,   862913775
,	  863110557,   863307351,   863504155,   863700971
,	  863897798,   864094636,   864291485,   864488346
,	  864685217,   864882100,   865078994,   865275900
,	  865472816,   865669744,   865866683,   866063633
,	  866260595,   866457567,   866654551,   866851546
,	  867048552,   867245569,   867442598,   867639637
,	  867836688,   868033750,   868230823,   868427908
,	  868625004,   868822110,   869019228,   869216357
,	  869413498,   869610649,   869807812,   870004986
,	  870202171,   870399367,   870596574,   870793793
,	  870991023,   871188264,   871385516,   871582779
,	  871780053,   871977339,   872174635,   872371943
,	  872569262,   872766592,   872963934,   873161286
,	  873358650,   873556024,   873753410,   873950807
,	  874148216,   874345635,   874543065,   874740507
,	  874937960,   875135424,   875332899,   875530385
,	  875727882,   875925391,   876122910,   876320441
,	  876517983,   876715536,   876913100,   877110675
,	  877308262,   877505859,   877703468,   877901088
,	  878098719,   878296361,   878494014,   878691678
,	  878889353,   879087040,   879284737,   879482446
,	  879680166,   879877897,   880075639,   880273392
,	  880471156,   880668932,   880866718,   881064516
,	  881262324,   881460144,   881657975,   881855817
,	  882053670,   882251534,   882449409,   882647296
,	  882845193,   883043102,   883241021,   883438952
,	  883636894,   883834847,   884032811,   884230786
,	  884428772,   884626769,   884824777,   885022797
,	  885220827,   885418869,   885616921,   885814985
,	  886013060,   886211145,   886409242,   886607350
,	  886805469,   887003599,   887201741,   887399893
,	  887598056,   887796230,   887994416,   888192612
,	  888390820,   888589038,   888787268,   888985509
,	  889183760,   889382023,   889580297,   889778582
,	  889976878,   890175185,   890373503,   890571832
,	  890770172,   890968523,   891166885,   891365258
,	  891563643,   891762038,   891960444,   892158862
,	  892357290,   892555729,   892754180,   892952641
,	  893151114,   893349597,   893548092,   893746597
,	  893945114,   894143642,   894342180,   894540730
,	  894739291,   894937862,   895136445,   895335039
,	  895533644,   895732259,   895930886,   896129524
,	  896328173,   896526833,   896725503,   896924185
,	  897122878,   897321582,   897520297,   897719022
,	  897917759,   898116507,   898315266,   898514036
,	  898712816,   898911608,   899110411,   899309225
,	  899508050,   899706885,   899905732,   900104590
,	  900303458,   900502338,   900701229,   900900130
,	  901099043,   901297967,   901496901,   901695847
,	  901894803,   902093771,   902292749,   902491739
,	  902690739,   902889750,   903088773,   903287806
,	  903486850,   903685906,   903884972,   904084049
,	  904283137,   904482236,   904681346,   904880467
,	  905079599,   905278742,   905477896,   905677061
,	  905876237,   906075423,   906274621,   906473829
,	  906673049,   906872279,   907071521,   907270773
,	  907470037,   907669311,   907868596,   908067892
,	  908267199,   908466517,   908665846,   908865186
,	  909064537,   909263899,   909463271,   909662655
,	  909862049,   910061455,   910260871,   910460298
,	  910659737,   910859186,   911058646,   911258117
,	  911457599,   911657091,   911856595,   912056110
,	  912255635,   912455172,   912654719,   912854277
,	  913053846,   913253426,   913453017,   913652619
,	  913852232,   914051856,   914251490,   914451136
,	  914650792,   914850459,   915050138,   915249827
,	  915449527,   915649237,   915848959,   916048692
,	  916248435,   916448190,   916647955,   916847731
,	  917047518,   917247316,   917447125,   917646945
,	  917846775,   918046617,   918246469,   918446332
,	  918646206,   918846091,   919045987,   919245894
,	  919445811,   919645740,   919845679,   920045629
,	  920245590,   920445562,   920645545,   920845538
,	  921045543,   921245558,   921445584,   921645621
,	  921845669,   922045728,   922245797,   922445878
,	  922645969,   922846071,   923046184,   923246308
,	  923446443,   923646588,   923846745,   924046912
,	  924247090,   924447279,   924647479,   924847689
,	  925047911,   925248143,   925448386,   925648640
,	  925848904,   926049180,   926249466,   926449764
,	  926650072,   926850391,   927050720,   927251061
,	  927451412,   927651774,   927852147,   928052531
,	  928252926,   928453331,   928653747,   928854174
,	  929054612,   929255061,   929455521,   929655991
,	  929856472,   930056964,   930257467,   930457980
,	  930658504,   930859040,   931059586,   931260142
,	  931460710,   931661288,   931861877,   932062477
,	  932263088,   932463709,   932664342,   932864985
,	  933065639,   933266303,   933466979,   933667665
,	  933868362,   934069070,   934269789,   934470518
,	  934671258,   934872009,   935072771,   935273543
,	  935474326,   935675120,   935875925,   936076741
,	  936277567,   936478404,   936679252,   936880111
,	  937080980,   937281861,   937482751,   937683653
,	  937884566,   938085489,   938286423,   938487368
,	  938688323,   938889289,   939090266,   939291254
,	  939492253,   939693262,   939894282,   940095313
,	  940296354,   940497407,   940698470,   940899543
,	  941100628,   941301723,   941502829,   941703946
,	  941905073,   942106212,   942307361,   942508520
,	  942709691,   942910872,   943112064,   943313266
,	  943514480,   943715704,   943916938,   944118184
,	  944319440,   944520707,   944721985,   944923273
,	  945124572,   945325882,   945527203,   945728534
,	  945929876,   946131229,   946332592,   946533966
,	  946735351,   946936747,   947138153,   947339570
,	  947540998,   947742436,   947943885,   948145345
,	  948346815,   948548297,   948749789,   948951291
,	  949152804,   949354328,   949555863,   949757409
,	  949958965,   950160531,   950362109,   950563697
,	  950765296,   950966905,   951168526,   951370156
,	  951571798,   951773450,   951975113,   952176787
,	  952378471,   952580166,   952781872,   952983588
,	  953185315,   953387053,   953588801,   953790560
,	  953992330,   954194110,   954395901,   954597703
,	  954799515,   955001338,   955203172,   955405016
,	  955606871,   955808737,   956010613,   956212500
,	  956414398,   956616306,   956818225,   957020155
,	  957222095,   957424046,   957626008,   957827980
,	  958029963,   958231956,   958433960,   958635975
,	  958838001,   959040037,   959242083,   959444141
,	  959646209,   959848287,   960050377,   960252477
,	  960454587,   960656708,   960858840,   961060983
,	  961263136,   961465299,   961667474,   961869659
,	  962071854,   962274060,   962476277,   962678505
,	  962880743,   963082991,   963285251,   963487521
,	  963689801,   963892092,   964094394,   964296707
,	  964499030,   964701363,   964903707,   965106062
,	  965308428,   965510804,   965713190,   965915588
,	  966117995,   966320414,   966522843,   966725283
,	  966927733,   967130194,   967332665,   967535147
,	  967737640,   967940143,   968142657,   968345181
,	  968547716,   968750262,   968952818,   969155385
,	  969357962,   969560550,   969763149,   969965758
,	  970168378,   970371008,   970573649,   970776300
,	  970978962,   971181635,   971384318,   971587011
,	  971789716,   971992431,   972195156,   972397892
,	  972600639,   972803396,   973006163,   973208942
,	  973411731,   973614530,   973817340,   974020160
,	  974222991,   974425833,   974628685,   974831548
,	  975034421,   975237305,   975440200,   975643105
,	  975846020,   976048946,   976251883,   976454830
,	  976657788,   976860756,   977063735,   977266724
,	  977469724,   977672734,   977875755,   978078787
,	  978281829,   978484881,   978687944,   978891018
,	  979094102,   979297197,   979500302,   979703418
,	  979906544,   980109681,   980312828,   980515986
,	  980719154,   980922333,   981125523,   981328723
,	  981531933,   981735154,   981938386,   982141628
,	  982344880,   982548143,   982751417,   982954701
,	  983157995,   983361300,   983564616,   983767942
,	  983971279,   984174626,   984377983,   984581352
,	  984784730,   984988119,   985191519,   985394929
,	  985598350,   985801781,   986005222,   986208675
,	  986412137,   986615610,   986819094,   987022588
,	  987226092,   987429608,   987633133,   987836669
,	  988040216,   988243773,   988447340,   988650918
,	  988854506,   989058105,   989261715,   989465335
,	  989668965,   989872606,   990076257,   990279919
,	  990483591,   990687274,   990890967,   991094671
,	  991298385,   991502109,   991705844,   991909590
,	  992113346,   992317112,   992520889,   992724677
,	  992928475,   993132283,   993336102,   993539931
,	  993743770,   993947620,   994151481,   994355352
,	  994559234,   994763125,   994967028,   995170941
,	  995374864,   995578798,   995782742,   995986696
,	  996190661,   996394637,   996598623,   996802619
,	  997006626,   997210643,   997414671,   997618709
,	  997822757,   998026816,   998230886,   998434965
,	  998639056,   998843156,   999047267,   999251389
,	  999455521,   999659663,   999863816,  1000067979
,	 1000272153,  1000476337,  1000680531,  1000884736
,	 1001088952,  1001293177,  1001497413,  1001701660
,	 1001905917,  1002110184,  1002314462,  1002518750
,	 1002723049,  1002927358,  1003131677,  1003336007
,	 1003540347,  1003744698,  1003949059,  1004153430
,	 1004357812,  1004562204,  1004766607,  1004971020
,	 1005175443,  1005379877,  1005584321,  1005788776
,	 1005993241,  1006197716,  1006402202,  1006606698
,	 1006811205,  1007015722,  1007220249,  1007424787
,	 1007629335,  1007833893,  1008038462,  1008243041
,	 1008447631,  1008652231,  1008856841,  1009061462
,	 1009266093,  1009470734,  1009675386,  1009880048
,	 1010084721,  1010289404,  1010494097,  1010698801
,	 1010903515,  1011108239,  1011312974,  1011517719
,	 1011722475,  1011927241,  1012132017,  1012336803
,	 1012541600,  1012746407,  1012951225,  1013156053
,	 1013360891,  1013565740,  1013770599,  1013975469
,	 1014180348,  1014385238,  1014590139,  1014795050
,	 1014999971,  1015204902,  1015409844,  1015614796
,	 1015819759,  1016024732,  1016229715,  1016434708
,	 1016639712,  1016844726,  1017049751,  1017254786
,	 1017459831,  1017664886,  1017869952,  1018075028
,	 1018280115,  1018485212,  1018690319,  1018895436
,	 1019100564,  1019305702,  1019510851,  1019716009
,	 1019921179,  1020126358,  1020331548,  1020536748
,	 1020741958,  1020947179,  1021152410,  1021357651
,	 1021562903,  1021768165,  1021973437,  1022178719
,	 1022384012,  1022589315,  1022794629,  1022999953
,	 1023205287,  1023410631,  1023615986,  1023821351
,	 1024026726,  1024232111,  1024437507,  1024642913
,	 1024848330,  1025053757,  1025259194,  1025464641
,	 1025670099,  1025875566,  1026081045,  1026286533
,	 1026492032,  1026697541,  1026903060,  1027108590
,	 1027314130,  1027519680,  1027725240,  1027930811
,	 1028136392,  1028341984,  1028547585,  1028753197
,	 1028958819,  1029164451,  1029370094,  1029575747
,	 1029781410,  1029987084,  1030192768,  1030398462
,	 1030604166,  1030809880,  1031015605,  1031221340
,	 1031427086,  1031632841,  1031838607,  1032044383
,	 1032250170,  1032455966,  1032661773,  1032867590
,	 1033073418,  1033279255,  1033485103,  1033690961
,	 1033896830,  1034102708,  1034308597,  1034514496
,	 1034720406,  1034926325,  1035132255,  1035338195
,	 1035544146,  1035750106,  1035956077,  1036162058
,	 1036368050,  1036574051,  1036780063,  1036986085
,	 1037192117,  1037398160,  1037604212,  1037810275
,	 1038016348,  1038222432,  1038428526,  1038634629
,	 1038840743,  1039046868,  1039253002,  1039459147
,	 1039665302,  1039871467,  1040077643,  1040283828
,	 1040490024,  1040696230,  1040902446,  1041108673
,	 1041314910,  1041521157,  1041727414,  1041933681
,	 1042139959,  1042346246,  1042552544,  1042758852
,	 1042965171,  1043171499,  1043377838,  1043584187
,	 1043790546,  1043996916,  1044203295,  1044409685
,	 1044616085,  1044822495,  1045028916,  1045235346
,	 1045441787,  1045648238,  1045854699,  1046061170
,	 1046267652,  1046474144,  1046680645,  1046887158
,	 1047093680,  1047300212,  1047506755,  1047713308
,	 1047919871,  1048126444,  1048333027,  1048539621
,	 1048746224,  1048952838,  1049159462,  1049366097
,	 1049572741,  1049779396,  1049986060,  1050192735
,	 1050399420,  1050606116,  1050812821,  1051019537
,	 1051226262,  1051432998,  1051639744,  1051846500
,	 1052053267,  1052260043,  1052466830,  1052673627
,	 1052880434,  1053087251,  1053294079,  1053500916
,	 1053707764,  1053914622,  1054121489,  1054328368
,	 1054535256,  1054742154,  1054949063,  1055155981
,	 1055362910,  1055569849,  1055776798,  1055983758
,	 1056190727,  1056397707,  1056604696,  1056811696
,	 1057018706,  1057225726,  1057432756,  1057639797
,	 1057846847,  1058053908,  1058260979,  1058468059
,	 1058675150,  1058882252,  1059089363,  1059296484
,	 1059503616,  1059710757,  1059917909,  1060125071
,	 1060332243,  1060539425,  1060746617,  1060953820
,	 1061161032,  1061368255,  1061575488,  1061782730
,	 1061989983,  1062197246,  1062404520,  1062611803
,	 1062819096,  1063026400,  1063233713,  1063441037
,	 1063648371,  1063855715,  1064063069,  1064270433
,	 1064477807,  1064685192,  1064892586,  1065099990
,	 1065307405,  1065514830,  1065722265,  1065929709
,	 1066137164,  1066344630,  1066552105,  1066759590
,	 1066967085,  1067174591,  1067382106,  1067589632
,	 1067797168,  1068004714,  1068212269,  1068419835
,	 1068627411,  1068834998,  1069042594,  1069250200
,	 1069457816,  1069665443,  1069873079,  1070080726
,	 1070288383,  1070496049,  1070703726,  1070911413
,	 1071119110,  1071326817,  1071534534,  1071742261
,	 1071949998,  1072157746,  1072365503,  1072573270
,	 1072781048,  1072988835,  1073196633,  1073404441
,	 1073612258,  1073820086,  1074027924,  1074235772
,	 1074443630,  1074651498,  1074859376,  1075067264
,	 1075275162,  1075483070,  1075690988,  1075898917
,	 1076106855,  1076314803,  1076522762,  1076730730
,	 1076938709,  1077146697,  1077354696,  1077562705
,	 1077770723,  1077978752,  1078186791,  1078394839
,	 1078602898,  1078810967,  1079019046,  1079227135
,	 1079435234,  1079643343,  1079851462,  1080059591
,	 1080267730,  1080475879,  1080684038,  1080892207
,	 1081100386,  1081308576,  1081516775,  1081724984
,	 1081933203,  1082141432,  1082349672,  1082557921
,	 1082766180,  1082974450,  1083182729,  1083391018
,	 1083599318,  1083807627,  1084015947,  1084224276
,	 1084432615,  1084640965,  1084849324,  1085057694
,	 1085266073,  1085474462,  1085682862,  1085891271
,	 1086099691,  1086308120,  1086516560,  1086725009
,	 1086933468,  1087141938,  1087350417,  1087558907
,	 1087767406,  1087975915,  1088184435,  1088392964
,	 1088601503,  1088810053,  1089018612,  1089227181
,	 1089435761,  1089644350,  1089852949,  1090061559
,	 1090270178,  1090478807,  1090687446,  1090896095
,	 1091104754,  1091313424,  1091522103,  1091730792
,	 1091939491,  1092148200,  1092356919,  1092565648
,	 1092774387,  1092983136,  1093191894,  1093400663
,	 1093609442,  1093818231,  1094027030,  1094235838
,	 1094444657,  1094653486,  1094862324,  1095071173
,	 1095280031,  1095488900,  1095697778,  1095906666
,	 1096115565,  1096324473,  1096533391,  1096742319
,	 1096951257,  1097160206,  1097369164,  1097578132
,	 1097787109,  1097996097,  1098205095,  1098414103
,	 1098623121,  1098832148,  1099041186,  1099250233
,	 1099459291,  1099668358,  1099877435,  1100086523
,	 1100295620,  1100504727,  1100713844,  1100922971
,	 1101132108,  1101341255,  1101550412,  1101759578
,	 1101968755,  1102177942,  1102387138,  1102596345
,	 1102805561,  1103014787,  1103224023,  1103433270
,	 1103642526,  1103851792,  1104061067,  1104270353
,	 1104479649,  1104688955,  1104898270,  1105107596
,	 1105316931,  1105526276,  1105735631,  1105944997
,	 1106154372,  1106363756,  1106573151,  1106782556
,	 1106991971,  1107201395,  1107410830,  1107620274
,	 1107829728,  1108039192,  1108248667,  1108458150
,	 1108667644,  1108877148,  1109086662,  1109296185
,	 1109505719,  1109715262,  1109924815,  1110134378
,	 1110343951,  1110553534,  1110763127,  1110972730
,	 1111182342,  1111391965,  1111601597,  1111811239
,	 1112020891,  1112230553,  1112440225,  1112649907
,	 1112859598,  1113069300,  1113279011,  1113488733
,	 1113698464,  1113908205,  1114117956,  1114327716
,	 1114537487,  1114747267,  1114957058,  1115166858
,	 1115376668,  1115586488,  1115796318,  1116006157
,	 1116216007,  1116425866,  1116635736,  1116845615
,	 1117055504,  1117265403,  1117475311,  1117685230
,	 1117895158,  1118105097,  1118315045,  1118525003
,	 1118734971,  1118944948,  1119154936,  1119364933
,	 1119574941,  1119784958,  1119994985,  1120205022
,	 1120415068,  1120625125,  1120835191,  1121045267
,	 1121255353,  1121465449,  1121675555,  1121885670
,	 1122095796,  1122305931,  1122516076,  1122726231
,	 1122936396,  1123146570,  1123356755,  1123566949
,	 1123777153,  1123987367,  1124197590,  1124407824
,	 1124618067,  1124828321,  1125038584,  1125248856
,	 1125459139,  1125669432,  1125879734,  1126090046
,	 1126300368,  1126510700,  1126721041,  1126931393
,	 1127141754,  1127352125,  1127562506,  1127772897
,	 1127983297,  1128193707,  1128404127,  1128614557
,	 1128824997,  1129035447,  1129245906,  1129456375
,	 1129666854,  1129877343,  1130087841,  1130298350
,	 1130508868,  1130719396,  1130929934,  1131140481
,	 1131351039,  1131561606,  1131772183,  1131982769
,	 1132193366,  1132403972,  1132614588,  1132825214
,	 1133035850,  1133246496,  1133457151,  1133667816
,	 1133878491,  1134089176,  1134299870,  1134510574
,	 1134721288,  1134932012,  1135142746,  1135353489
,	 1135564242,  1135775005,  1135985778,  1136196560
,	 1136407352,  1136618154,  1136828966,  1137039788
,	 1137250619,  1137461460,  1137672311,  1137883172
,	 1138094042,  1138304922,  1138515812,  1138726712
,	 1138937622,  1139148541,  1139359470,  1139570409
,	 1139781357,  1139992315,  1140203284,  1140414261
,	 1140625249,  1140836246,  1141047253,  1141258270
,	 1141469297,  1141680333,  1141891379,  1142102435
,	 1142313501,  1142524576,  1142735661,  1142946756
,	 1143157861,  1143368975,  1143580099,  1143791233
,	 1144002377,  1144213530,  1144424693,  1144635866
,	 1144847048,  1145058241,  1145269443,  1145480655
,	 1145691876,  1145903107,  1146114348,  1146325599
,	 1146536859,  1146748130,  1146959410,  1147170699
,	 1147381999,  1147593308,  1147804626,  1148015955
,	 1148227293,  1148438641,  1148649999,  1148861367
,	 1149072744,  1149284131,  1149495527,  1149706934
,	 1149918350,  1150129775,  1150341211,  1150552656
,	 1150764111,  1150975576,  1151187050,  1151398534
,	 1151610028,  1151821531,  1152033044,  1152244567
,	 1152456100,  1152667642,  1152879194,  1153090756
,	 1153302327,  1153513909,  1153725499,  1153937100
,	 1154148710,  1154360330,  1154571960,  1154783599
,	 1154995248,  1155206907,  1155418575,  1155630253
,	 1155841941,  1156053639,  1156265346,  1156477063
,	 1156688789,  1156900526,  1157112272,  1157324027
,	 1157535793,  1157747568,  1157959352,  1158171147
,	 1158382951,  1158594765,  1158806588,  1159018421
,	 1159230264,  1159442116,  1159653979,  1159865850
,	 1160077732,  1160289623,  1160501524,  1160713435
,	 1160925355,  1161137285,  1161349224,  1161561173
,	 1161773132,  1161985101,  1162197079,  1162409067
,	 1162621064,  1162833072,  1163045089,  1163257115
,	 1163469151,  1163681197,  1163893253,  1164105318
,	 1164317393,  1164529477,  1164741571,  1164953675
,	 1165165789,  1165377912,  1165590045,  1165802187
,	 1166014339,  1166226501,  1166438672,  1166650853
,	 1166863044,  1167075244,  1167287454,  1167499674
,	 1167711903,  1167924142,  1168136390,  1168348649
,	 1168560916,  1168773194,  1168985481,  1169197778
,	 1169410084,  1169622400,  1169834726,  1170047061
,	 1170259406,  1170471761,  1170684125,  1170896499
,	 1171108882,  1171321275,  1171533678,  1171746090
,	 1171958512,  1172170944,  1172383385,  1172595836
,	 1172808296,  1173020766,  1173233246,  1173445735
,	 1173658234,  1173870743,  1174083261,  1174295789
,	 1174508326,  1174720873,  1174933430,  1175145996
,	 1175358572,  1175571158,  1175783753,  1175996357
,	 1176208972,  1176421596,  1176634229,  1176846872
,	 1177059525,  1177272187,  1177484859,  1177697541
,	 1177910232,  1178122933,  1178335643,  1178548363
,	 1178761093,  1178973832,  1179186581,  1179399339
,	 1179612107,  1179824884,  1180037672,  1180250468
,	 1180463275,  1180676090,  1180888916,  1181101751
,	 1181314596,  1181527450,  1181740314,  1181953187
,	 1182166070,  1182378963,  1182591865,  1182804777
,	 1183017698,  1183230629,  1183443570,  1183656520
,	 1183869480,  1184082449,  1184295428,  1184508416
,	 1184721414,  1184934422,  1185147439,  1185360465
,	 1185573502,  1185786548,  1185999603,  1186212668
,	 1186425743,  1186638827,  1186851920,  1187065024
,	 1187278136,  1187491259,  1187704391,  1187917532
,	 1188130683,  1188343844,  1188557014,  1188770194
,	 1188983383,  1189196582,  1189409790,  1189623008
,	 1189836236,  1190049473,  1190262720,  1190475976
,	 1190689242,  1190902517,  1191115802,  1191329096
,	 1191542400,  1191755713,  1191969036,  1192182369
,	 1192395711,  1192609063,  1192822424,  1193035795
,	 1193249175,  1193462565,  1193675964,  1193889373
,	 1194102791,  1194316219,  1194529657,  1194743104
,	 1194956561,  1195170027,  1195383502,  1195596987
,	 1195810482,  1196023986,  1196237500,  1196451023
,	 1196664556,  1196878099,  1197091650,  1197305212
,	 1197518783,  1197732363,  1197945953,  1198159553
,	 1198373162,  1198586780,  1198800408,  1199014046
,	 1199227693,  1199441349,  1199655015,  1199868691
,	 1200082376,  1200296071,  1200509775,  1200723489
,	 1200937212,  1201150944,  1201364687,  1201578438
,	 1201792200,  1202005970,  1202219750,  1202433540
,	 1202647339,  1202861148,  1203074966,  1203288794
,	 1203502631,  1203716478,  1203930334,  1204144200
,	 1204358075,  1204571960,  1204785854,  1204999758
,	 1205213671,  1205427594,  1205641526,  1205855467
,	 1206069419,  1206283379,  1206497349,  1206711329
,	 1206925318,  1207139317,  1207353325,  1207567342
,	 1207781369,  1207995406,  1208209452,  1208423507
,	 1208637572,  1208851647,  1209065731,  1209279824
,	 1209493927,  1209708039,  1209922161,  1210136293
,	 1210350433,  1210564584,  1210778743,  1210992912
,	 1211207091,  1211421279,  1211635477,  1211849684
,	 1212063900,  1212278126,  1212492362,  1212706607
,	 1212920861,  1213135125,  1213349398,  1213563681
,	 1213777973,  1213992275,  1214206586,  1214420907
,	 1214635237,  1214849576,  1215063925,  1215278284
,	 1215492652,  1215707029,  1215921416,  1216135812
,	 1216350218,  1216564633,  1216779057,  1216993491
,	 1217207935,  1217422388,  1217636850,  1217851322
,	 1218065803,  1218280294,  1218494794,  1218709304
,	 1218923823,  1219138351,  1219352889,  1219567436
,	 1219781993,  1219996559,  1220211135,  1220425720
,	 1220640314,  1220854918,  1221069532,  1221284154
,	 1221498787,  1221713428,  1221928079,  1222142740
,	 1222357410,  1222572089,  1222786778,  1223001476
,	 1223216184,  1223430901,  1223645627,  1223860363
,	 1224075109,  1224289863,  1224504627,  1224719401
,	 1224934184,  1225148976,  1225363778,  1225578589
,	 1225793410,  1226008240,  1226223080,  1226437928
,	 1226652787,  1226867654,  1227082531,  1227297418
,	 1227512314,  1227727219,  1227942134,  1228157058
,	 1228371992,  1228586934,  1228801887,  1229016849
,	 1229231820,  1229446800,  1229661790,  1229876789
,	 1230091798,  1230306816,  1230521844,  1230736881
,	 1230951927,  1231166983,  1231382048,  1231597122
,	 1231812206,  1232027299,  1232242402,  1232457514
,	 1232672636,  1232887766,  1233102907,  1233318056
,	 1233533215,  1233748383,  1233963561,  1234178748
,	 1234393945,  1234609151,  1234824366,  1235039590
,	 1235254824,  1235470068,  1235685321,  1235900583
,	 1236115854,  1236331135,  1236546425,  1236761725
,	 1236977034,  1237192352,  1237407680,  1237623017
,	 1237838364,  1238053719,  1238269085,  1238484459
,	 1238699843,  1238915236,  1239130639,  1239346051
,	 1239561472,  1239776903,  1239992343,  1240207793
,	 1240423251,  1240638720,  1240854197,  1241069684
,	 1241285180,  1241500686,  1241716201,  1241931725
,	 1242147259,  1242362802,  1242578354,  1242793916
,	 1243009487,  1243225067,  1243440657,  1243656256
,	 1243871864,  1244087482,  1244303109,  1244518745
,	 1244734391,  1244950046,  1245165711,  1245381385
,	 1245597068,  1245812760,  1246028462,  1246244173
,	 1246459894,  1246675623,  1246891363,  1247107111
,	 1247322869,  1247538636,  1247754413,  1247970198
,	 1248185993,  1248401798,  1248617612,  1248833435
,	 1249049267,  1249265109,  1249480960,  1249696820
,	 1249912690,  1250128569,  1250344458,  1250560355
,	 1250776262,  1250992179,  1251208104,  1251424039
,	 1251639983,  1251855937,  1252071900,  1252287872
,	 1252503854,  1252719845,  1252935845,  1253151854
,	 1253367873,  1253583901,  1253799938,  1254015985
,	 1254232041,  1254448106,  1254664181,  1254880265
,	 1255096358,  1255312461,  1255528572,  1255744693
,	 1255960824,  1256176964,  1256393113,  1256609271
,	 1256825438,  1257041615,  1257257802,  1257473997
,	 1257690202,  1257906416,  1258122639,  1258338872
,	 1258555114,  1258771365,  1258987626,  1259203895
,	 1259420174,  1259636463,  1259852760,  1260069067
,	 1260285384,  1260501709,  1260718044,  1260934388
,	 1261150741,  1261367104,  1261583476,  1261799857
,	 1262016248,  1262232647,  1262449056,  1262665475
,	 1262881902,  1263098339,  1263314785,  1263531241
,	 1263747705,  1263964179,  1264180662,  1264397155
,	 1264613657,  1264830168,  1265046688,  1265263217
,	 1265479756,  1265696304,  1265912861,  1266129428
,	 1266346004,  1266562589,  1266779183,  1266995787
,	 1267212400,  1267429022,  1267645653,  1267862294
,	 1268078944,  1268295603,  1268512271,  1268728949
,	 1268945636,  1269162332,  1269379038,  1269595752
,	 1269812476,  1270029209,  1270245952,  1270462703
,	 1270679464,  1270896234,  1271113014,  1271329802
,	 1271546600,  1271763407,  1271980224,  1272197049
,	 1272413884,  1272630728,  1272847582,  1273064444
,	 1273281316,  1273498197,  1273715087,  1273931987
,	 1274148895,  1274365813,  1274582740,  1274799677
,	 1275016622,  1275233577,  1275450541,  1275667515
,	 1275884497,  1276101489,  1276318490,  1276535500
,	 1276752520,  1276969548,  1277186586,  1277403633
,	 1277620690,  1277837755,  1278054830,  1278271914
,	 1278489007,  1278706110,  1278923221,  1279140342
,	 1279357472,  1279574611,  1279791760,  1280008918
,	 1280226085,  1280443261,  1280660446,  1280877641
,	 1281094844,  1281312057,  1281529279,  1281746511
,	 1281963751,  1282181001,  1282398260,  1282615528
,	 1282832806,  1283050092,  1283267388,  1283484693
,	 1283702007,  1283919331,  1284136663,  1284354005
,	 1284571356,  1284788716,  1285006085,  1285223464
,	 1285440852,  1285658249,  1285875655,  1286093070
,	 1286310494,  1286527928,  1286745371,  1286962823
,	 1287180284,  1287397755,  1287615234,  1287832723
,	 1288050221,  1288267728,  1288485245,  1288702770
,	 1288920305,  1289137849,  1289355402,  1289572964
,	 1289790535,  1290008116,  1290225706,  1290443305
,	 1290660913,  1290878530,  1291096157,  1291313792
,	 1291531437,  1291749091,  1291966754,  1292184426
,	 1292402108,  1292619799,  1292837498,  1293055207
,	 1293272925,  1293490653,  1293708389,  1293926135
,	 1294143890,  1294361654,  1294579427,  1294797209
,	 1295015000,  1295232801,  1295450611,  1295668430
,	 1295886258,  1296104095,  1296321941,  1296539797
,	 1296757661,  1296975535,  1297193418,  1297411310
,	 1297629211,  1297847122,  1298065041,  1298282970
,	 1298500908,  1298718855,  1298936811,  1299154776
,	 1299372751,  1299590734,  1299808727,  1300026729
,	 1300244740,  1300462760,  1300680789,  1300898828
,	 1301116875,  1301334932,  1301552998,  1301771072
,	 1301989157,  1302207250,  1302425352,  1302643464
,	 1302861584,  1303079714,  1303297853,  1303516001
,	 1303734158,  1303952324,  1304170499,  1304388684
,	 1304606878,  1304825080,  1305043292,  1305261513
,	 1305479743,  1305697982,  1305916231,  1306134488
,	 1306352755,  1306571030,  1306789315,  1307007609
,	 1307225912,  1307444224,  1307662546,  1307880876
,	 1308099216,  1308317564,  1308535922,  1308754289
,	 1308972665,  1309191050,  1309409444,  1309627847
,	 1309846259,  1310064681,  1310283112,  1310501551
,	 1310720000,  1310938458,  1311156925,  1311375401
,	 1311593886,  1311812380,  1312030884,  1312249396
,	 1312467918,  1312686449,  1312904988,  1313123537
,	 1313342095,  1313560662,  1313779238,  1313997824
,	 1314216418,  1314435021,  1314653634,  1314872255
,	 1315090886,  1315309526,  1315528175,  1315746833
,	 1315965500,  1316184176,  1316402861,  1316621555
,	 1316840259,  1317058971,  1317277693,  1317496423
,	 1317715163,  1317933912,  1318152669,  1318371436
,	 1318590212,  1318808997,  1319027792,  1319246595
,	 1319465407,  1319684228,  1319903059,  1320121898
,	 1320340747,  1320559605,  1320778471,  1320997347
,	 1321216232,  1321435126,  1321654029,  1321872941
,	 1322091862,  1322310792,  1322529731,  1322748679
,	 1322967637,  1323186603,  1323405579,  1323624563
,	 1323843557,  1324062559,  1324281571,  1324500592
,	 1324719622,  1324938661,  1325157708,  1325376765
,	 1325595831,  1325814906,  1326033991,  1326253084
,	 1326472186,  1326691297,  1326910418,  1327129547
,	 1327348685,  1327567833,  1327786989,  1328006155
,	 1328225329,  1328444513,  1328663706,  1328882907
,	 1329102118,  1329321338,  1329540567,  1329759804
,	 1329979051,  1330198307,  1330417572,  1330636846
,	 1330856129,  1331075421,  1331294722,  1331514033
,	 1331733352,  1331952680,  1332172017,  1332391363
,	 1332610719,  1332830083,  1333049456,  1333268839
,	 1333488230,  1333707630,  1333927040,  1334146458
,	 1334365886,  1334585322,  1334804768,  1335024222
,	 1335243686,  1335463158,  1335682640,  1335902131
,	 1336121630,  1336341139,  1336560657,  1336780183
,	 1336999719,  1337219264,  1337438817,  1337658380
,	 1337877952,  1338097532,  1338317122,  1338536721
,	 1338756329,  1338975945,  1339195571,  1339415206
,	 1339634850,  1339854503,  1340074164,  1340293835
,	 1340513515,  1340733204,  1340952901,  1341172608
,	 1341392324,  1341612049,  1341831783,  1342051525
,	 1342271277,  1342491038,  1342710808,  1342930586
,	 1343150374,  1343370171,  1343589977,  1343809791
,	 1344029615,  1344249448,  1344469289,  1344689140
,	 1344909000,  1345128868,  1345348746,  1345568633
,	 1345788528,  1346008433,  1346228346,  1346448269
,	 1346668200,  1346888141,  1347108090,  1347328049
,	 1347548016,  1347767993,  1347987978,  1348207972
,	 1348427976,  1348647988,  1348868009,  1349088040
,	 1349308079,  1349528127,  1349748184,  1349968250
,	 1350188326,  1350408410,  1350628503,  1350848605
,	 1351068716,  1351288836,  1351508965,  1351729102
,	 1351949249,  1352169405,  1352389570,  1352609744
,	 1352829926,  1353050118,  1353270318,  1353490528
,	 1353710747,  1353930974,  1354151210,  1354371456
,	 1354591710,  1354811973,  1355032246,  1355252527
,	 1355472817,  1355693116,  1355913424
};
static const real aa_ca[8] = 
{
	   -8631806,    -7914349,    -5257601,    -3051997
,	   -1586692,     -687288,     -238212,      -62075
};
static const real aa_cs[8] = 
{
	   14386344,    14793176,    15932125,    16497281
,	   16702017,    16763133,    16775525,    16777101
};
static const real win[4][36] = 
{
	{
		     541609,     1798624,     3379171,     5462936
	,	    8388608,    12881122,    20824265,    39123649
	,	  129925287,  -141788570,   -50986933,   -32687548
	,	  -24744405,   -20251891,   -17326219,   -15242454
	,	  -13661907,   -12404893,   -11366990,   -10483150
	,	   -9710514,    -9019459,    -8388608,    -7801881
	,	   -7246655,    -6712557,    -6190623,    -5672661
	,	   -5150726,    -4616628,    -4061402,    -3474675
	,	   -2843824,    -2152769,    -1380133,     -496293
	}
,	{
		     541609,     1798624,     3379171,     5462936
	,	    8388608,    12881122,    20824265,    39123649
	,	  129925287,  -141788570,   -50986933,   -32687548
	,	  -24744405,   -20251891,   -17326219,   -15242454
	,	  -13661907,   -12404893,   -11377819,   -10573609
	,	   -9946281,    -9457165,    -9079764,    -8795700
	,	   -8518771,    -7816938,    -6661470,    -5111526
	,	   -3237882,    -1121518,           0,           0
	,	          0,           0,           0,           0
	}
,	{
		    1798624,     8388608,    39123649,   -50986933
	,	  -20251891,   -13661907,   -10483150,    -8388608
	,	   -6712557,    -5150726,    -3474675,    -1380133
	,	          0,           0,           0,           0
	,	          0,           0,           0,           0
	,	          0,           0,           0,           0
	,	          0,           0,           0,           0
	,	          0,           0,           0,           0
	,	          0,           0,           0,           0
	}
,	{
		          0,           0,           0,           0
	,	          0,           0,     5058839,    24594154
	,	  117073194,  -152572757,   -59375541,   -38425694
	,	  -27896396,   -21920489,   -18167045,   -15612533
	,	  -13779795,   -12416710,   -11366990,   -10483150
	,	   -9710514,    -9019459,    -8388608,    -7801881
	,	   -7246655,    -6712557,    -6190623,    -5672661
	,	   -5150726,    -4616628,    -4061402,    -3474675
	,	   -2843824,    -2152769,    -1380133,     -496293
	}
};
static const real win1[4][36] = 
{
	{
		     541609,    -1798624,     3379171,    -5462936
	,	    8388608,   -12881122,    20824265,   -39123649
	,	  129925287,   141788570,   -50986933,    32687548
	,	  -24744405,    20251891,   -17326219,    15242454
	,	  -13661907,    12404893,   -11366990,    10483150
	,	   -9710514,     9019459,    -8388608,     7801881
	,	   -7246655,     6712557,    -6190623,     5672661
	,	   -5150726,     4616628,    -4061402,     3474675
	,	   -2843824,     2152769,    -1380133,      496293
	}
,	{
		     541609,    -1798624,     3379171,    -5462936
	,	    8388608,   -12881122,    20824265,   -39123649
	,	  129925287,   141788570,   -50986933,    32687548
	,	  -24744405,    20251891,   -17326219,    15242454
	,	  -13661907,    12404893,   -11377819,    10573609
	,	   -9946281,     9457165,    -9079764,     8795700
	,	   -8518771,     7816938,    -6661470,     5111526
	,	   -3237882,     1121518,           0,           0
	,	          0,           0,           0,           0
	}
,	{
		    1798624,    -8388608,    39123649,    50986933
	,	  -20251891,    13661907,   -10483150,     8388608
	,	   -6712557,     5150726,    -3474675,     1380133
	,	          0,           0,           0,           0
	,	          0,           0,           0,           0
	,	          0,           0,           0,           0
	,	          0,           0,           0,           0
	,	          0,           0,           0,           0
	,	          0,           0,           0,           0
	}
,	{
		          0,           0,           0,           0
	,	          0,           0,     5058839,   -24594154
	,	  117073194,   152572757,   -59375541,    38425694
	,	  -27896396,    21920489,   -18167045,    15612533
	,	  -13779795,    12416710,   -11366990,    10483150
	,	   -9710514,     9019459,    -8388608,     7801881
	,	   -7246655,     6712557,    -6190623,     5672661
	,	   -5150726,     4616628,    -4061402,     3474675
	,	   -2843824,     2152769,    -1380133,      496293
	}
};
const real INT123_COS9[9] = 
{
	   16777216,    16522332,    15765426,    14529495
,	   12852093,    10784187,     8388608,     5738146
,	    2913333
};
static const real COS6_1 = 14529495;
static const real COS6_2 = 8388608;
const real INT123_tfcos36[9] = 
{
	    8420651,     8684526,     9255805,    10240599
,	   11863283,    14625092,    19849138,    32411092
,	   96248483
};
static const real tfcos12[3] = 
{
	    8684526,    11863283,    32411092
};
static const real cos9[3] = 
{
	   15765426,    -2913333,   -12852093
};
static const real cos18[3] = 
{
	   16522332,    -5738146,   -10784187
};
static const real tan1_1[16] = 
{
	          0,        6925,       11994,       16384
,	      20774,       25843,       32768,       44762
,	      77530, -2147483648,      -44762,      -11994
,	          0,        6925,       11994,       16384
};
static const real tan2_1[16] = 
{
	      32768,       25843,       20774,       16384
,	      11994,        6925,           0,      -11994
,	     -44762, -2147483648,       77530,       44762
,	      32768,       25843,       20774,       16384
};
static const real tan1_2[16] = 
{
	          0,        9793,       16962,       23170
,	      29379,       36548,       46341,       63303
,	     109644, -2147483648,      -63303,      -16962
,	          0,        9793,       16962,       23170
};
static const real tan2_2[16] = 
{
	      46341,       36548,       29379,       23170
,	      16962,        9793,           0,      -16962
,	     -63303, -2147483648,      109644,       63303
,	      46341,       36548,       29379,       23170
};
static const real pow1_1[2][32] = 
{
	{
		      32768,       27554,       32768,       23170
	,	      32768,       19484,       32768,       16384
	,	      32768,       13777,       32768,       11585
	,	      32768,        9742,       32768,        8192
	,	      32768,        6889,       32768,        5793
	,	      32768,        4871,       32768,        4096
	,	      32768,        3444,       32768,        2896
	,	      32768,        2435,       32768,        2048
	}
,	{
		      32768,       23170,       32768,       16384
	,	      32768,       11585,       32768,        8192
	,	      32768,        5793,       32768,        4096
	,	      32768,        2896,       32768,        2048
	,	      32768,        1448,       32768,        1024
	,	      32768,         724,       32768,         512
	,	      32768,         362,       32768,         256
	,	      32768,         181,       32768,         128
	}
};
static const real pow2_1[2][32] = 
{
	{
		      32768,       32768,       27554,       32768
	,	      23170,       32768,       19484,       32768
	,	      16384,       32768,       13777,       32768
	,	      11585,       32768,        9742,       32768
	,	       8192,       32768,        6889,       32768
	,	       5793,       32768,        4871,       32768
	,	       4096,       32768,        3444,       32768
	,	       2896,       32768,        2435,       32768
	}
,	{
		      32768,       32768,       23170,       32768
	,	      16384,       32768,       11585,       32768
	,	       8192,       32768,        5793,       32768
	,	       4096,       32768,        2896,       32768
	,	       2048,       32768,        1448,       32768
	,	       1024,       32768,         724,       32768
	,	        512,       32768,         362,       32768
	,	        256,       32768,         181,       32768
	}
};
static const real pow1_2[2][32] = 
{
	{
		      46341,       38968,       46341,       32768
	,	      46341,       27554,       46341,       23170
	,	      46341,       19484,       46341,       16384
	,	      46341,       13777,       46341,       11585
	,	      46341,        9742,       46341,        8192
	,	      46341,        6889,       46341,        5793
	,	      46341,        4871,       46341,        4096
	,	      46341,        3444,       46341,        2896
	}
,	{
		      46341,       32768,       46341,       23170
	,	      46341,       16384,       46341,       11585
	,	      46341,        8192,       46341,        5793
	,	      46341,        4096,       46341,        2896
	,	      46341,        2048,       46341,        1448
	,	      46341,        1024,       46341,         724
	,	      46341,         512,       46341,         362
	,	      46341,         256,       46341,         181
	}
};
static const real pow2_2[2][32] = 
{
	{
		      46341,       46341,       38968,       46341
	,	      32768,       46341,       27554,       46341
	,	      23170,       46341,       19484,       46341
	,	      16384,       46341,       13777,       46341
	,	      11585,       46341,        9742,       46341
	,	       8192,       46341,        6889,       46341
	,	       5793,       46341,        4871,       46341
	,	       4096,       46341,        3444,       46341
	}
,	{
		      46341,       46341,       32768,       46341
	,	      23170,       46341,       16384,       46341
	,	      11585,       46341,        8192,       46341
	,	       5793,       46341,        4096,       46341
	,	       2896,       46341,        2048,       46341
	,	       1448,       46341,        1024,       46341
	,	        724,       46341,         512,       46341
	,	        362,       46341,         256,       46341
	}
};
static const real gainpow2[378] = 
{
	 1518500250,  1276901417,  1073741824,  1805811301,  1518500250
,	 1276901417,  1073741824,  1805811301,  1518500250,  1276901417
,	 1073741824,  1805811301,  1518500250,  1276901417,  1073741824
,	 1805811301,  1518500250,  1276901417,  1073741824,  1805811301
,	 1518500250,  1276901417,  1073741824,  1805811301,  1518500250
,	 1276901417,  1073741824,  1805811301,  1518500250,  1276901417
,	 1073741824,  1805811301,  1518500250,  1276901417,  1073741824
,	 1805811301,  1518500250,  1276901417,  1073741824,  1805811301
,	 1518500250,  1276901417,  1073741824,  1805811301,  1518500250
,	 1276901417,  1073741824,  1805811301,  1518500250,  1276901417
,	 1073741824,  1805811301,  1518500250,  1276901417,  1073741824
,	 1805811301,  1518500250,  1276901417,  1073741824,  1805811301
,	 1518500250,  1276901417,  1073741824,   902905651,   759250125
,	  638450708,   536870912,   451452825,   379625062,   319225354
,	  268435456,   225726413,   189812531,   159612677,   134217728
,	  112863206,    94906266,    79806339,    67108864,    56431603
,	   47453133,    39903169,    33554432,    28215802,    23726566
,	   19951585,    16777216,    14107901,    11863283,     9975792
,	    8388608,     7053950,     5931642,     4987896,     4194304
,	    3526975,     2965821,     2493948,     2097152,     1763488
,	    1482910,     1246974,     1048576,      881744,      741455
,	     623487,      524288,      440872,      370728,      311744
,	     262144,      220436,      185364,      155872,      131072
,	     110218,       92682,       77936,       65536,       55109
,	      46341,       38968,       32768,       27554,       23170
,	      19484,       16384,       13777,       11585,        9742
,	       8192,        6889,        5793,        4871,        4096
,	       3444,        2896,        2435,        2048,        1722
,	       1448,        1218,        1024,         861,         724
,	        609,         512,         431,         362,         304
,	        256,         215,         181,         152,         128
,	        108,          91,          76,          64,          54
,	         45,          38,          32,          27,          23
,	         19,          16,          13,          11,          10
,	          8,           7,           6,           5,           4
,	          3,           3,           2,           2,           2
,	          1,           1,           1,           1,           1
,	          1,           1,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0,           0,           0
,	          0,           0,           0
};

#endif

static const short mapbuf0[9][152] =
{
	{
		     2,      0,      3,      0,      2,      4,      3,      1,      2
	,	     8,      3,      2,      2,     12,      3,      3,      2,     16
	,	     3,      4,      2,     20,      3,      5,      3,     24,      3
	,	     6,      3,     30,      3,      7,      2,     36,      0,      3
	,	     2,     37,      1,      3,      2,     38,      2,      3,      3
	,	    48,      0,      4,      3,     49,      1,      4,      3,     50
	,	     2,      4,      4,     66,      0,      5,      4,     67,      1
	,	     5,      4,     68,      2,      5,      5,     90,      0,      6
	,	     5,     91,      1,      6,      5,     92,      2,      6,      6
	,	   120,      0,      7,      6,    121,      1,      7,      6,    122
	,	     2,      7,      7,    156,      0,      8,      7,    157,      1
	,	     8,      7,    158,      2,      8,      9,    198,      0,      9
	,	     9,    199,      1,      9,      9,    200,      2,      9,     11
	,	   252,      0,     10,     11,    253,      1,     10,     11,    254
	,	     2,     10,     15,    318,      0,     11,     15,    319,      1
	,	    11,     15,    320,      2,     11,     28,    408,      0,     12
	,	    28,    409,      1,     12,     28,    410,      2,     12
	}
,	{
		     2,      0,      3,      0,      2,      4,      3,      1,      2
	,	     8,      3,      2,      2,     12,      3,      3,      2,     16
	,	     3,      4,      2,     20,      3,      5,      3,     24,      3
	,	     6,      3,     30,      3,      7,      2,     36,      0,      3
	,	     2,     37,      1,      3,      2,     38,      2,      3,      3
	,	    48,      0,      4,      3,     49,      1,      4,      3,     50
	,	     2,      4,      3,     66,      0,      5,      3,     67,      1
	,	     5,      3,     68,      2,      5,      5,     84,      0,      6
	,	     5,     85,      1,      6,      5,     86,      2,      6,      6
	,	   114,      0,      7,      6,    115,      1,      7,      6,    116
	,	     2,      7,      7,    150,      0,      8,      7,    151,      1
	,	     8,      7,    152,      2,      8,      8,    192,      0,      9
	,	     8,    193,      1,      9,      8,    194,      2,      9,     10
	,	   240,      0,     10,     10,    241,      1,     10,     10,    242
	,	     2,     10,     13,    300,      0,     11,     13,    301,      1
	,	    11,     13,    302,      2,     11,     33,    378,      0,     12
	,	    33,    379,      1,     12,     33,    380,      2,     12
	}
,	{
		     2,      0,      3,      0,      2,      4,      3,      1,      2
	,	     8,      3,      2,      2,     12,      3,      3,      2,     16
	,	     3,      4,      2,     20,      3,      5,      3,     24,      3
	,	     6,      3,     30,      3,      7,      2,     36,      0,      3
	,	     2,     37,      1,      3,      2,     38,      2,      3,      3
	,	    48,      0,      4,      3,     49,      1,      4,      3,     50
	,	     2,      4,      4,     66,      0,      5,      4,     67,      1
	,	     5,      4,     68,      2,      5,      6,     90,      0,      6
	,	     6,     91,      1,      6,      6,     92,      2,      6,      8
	,	   126,      0,      7,      8,    127,      1,      7,      8,    128
	,	     2,      7,     10,    174,      0,      8,     10,    175,      1
	,	     8,     10,    176,      2,      8,     13,    234,      0,      9
	,	    13,    235,      1,      9,     13,    236,      2,      9,     17
	,	   312,      0,     10,     17,    313,      1,     10,     17,    314
	,	     2,     10,     21,    414,      0,     11,     21,    415,      1
	,	    11,     21,    416,      2,     11,      6,    540,      0,     12
	,	     6,    541,      1,     12,      6,    542,      2,     12
	}
,	{
		     3,      0,      3,      0,      3,      6,      3,      1,      3
	,	    12,      3,      2,      3,     18,      3,      3,      3,     24
	,	     3,      4,      3,     30,      3,      5,      3,     36,      0
	,	     3,      3,     37,      1,      3,      3,     38,      2,      3
	,	     3,     54,      0,      4,      3,     55,      1,      4,      3
	,	    56,      2,      4,      4,     72,      0,      5,      4,     73
	,	     1,      5,      4,     74,      2,      5,      5,     96,      0
	,	     6,      5,     97,      1,      6,      5,     98,      2,      6
	,	     7,    126,      0,      7,      7,    127,      1,      7,      7
	,	   128,      2,      7,      9,    168,      0,      8,      9,    169
	,	     1,      8,      9,    170,      2,      8,     13,    222,      0
	,	     9,     13,    223,      1,      9,     13,    224,      2,      9
	,	    16,    300,      0,     10,     16,    301,      1,     10,     16
	,	   302,      2,     10,     21,    396,      0,     11,     21,    397
	,	     1,     11,     21,    398,      2,     11,      9,    522,      0
	,	    12,      9,    523,      1,     12,      9,    524,      2,     12
	,	     0,      0,      0,      0,      0,      0,      0,      0
	}
,	{
		     3,      0,      3,      0,      3,      6,      3,      1,      3
	,	    12,      3,      2,      3,     18,      3,      3,      3,     24
	,	     3,      4,      3,     30,      3,      5,      3,     36,      0
	,	     3,      3,     37,      1,      3,      3,     38,      2,      3
	,	     4,     54,      0,      4,      4,     55,      1,      4,      4
	,	    56,      2,      4,      5,     78,      0,      5,      5,     79
	,	     1,      5,      5,     80,      2,      5,      6,    108,      0
	,	     6,      6,    109,      1,      6,      6,    110,      2,      6
	,	     7,    144,      0,      7,      7,    145,      1,      7,      7
	,	   146,      2,      7,      9,    186,      0,      8,      9,    187
	,	     1,      8,      9,    188,      2,      8,     12,    240,      0
	,	     9,     12,    241,      1,      9,     12,    242,      2,      9
	,	    16,    312,      0,     10,     16,    313,      1,     10,     16
	,	   314,      2,     10,     22,    408,      0,     11,     22,    409
	,	     1,     11,     22,    410,      2,     11,      6,    540,      0
	,	    12,      6,    541,      1,     12,      6,    542,      2,     12
	,	     0,      0,      0,      0,      0,      0,      0,      0
	}
,	{
		     3,      0,      3,      0,      3,      6,      3,      1,      3
	,	    12,      3,      2,      3,     18,      3,      3,      3,     24
	,	     3,      4,      3,     30,      3,      5,      3,     36,      0
	,	     3,      3,     37,      1,      3,      3,     38,      2,      3
	,	     4,     54,      0,      4,      4,     55,      1,      4,      4
	,	    56,      2,      4,      5,     78,      0,      5,      5,     79
	,	     1,      5,      5,     80,      2,      5,      6,    108,      0
	,	     6,      6,    109,      1,      6,      6,    110,      2,      6
	,	     7,    144,      0,      7,      7,    145,      1,      7,      7
	,	   146,      2,      7,      9,    186,      0,      8,      9,    187
	,	     1,      8,      9,    188,      2,      8,     12,    240,      0
	,	     9,     12,    241,      1,      9,     12,    242,      2,      9
	,	    15,    312,      0,     10,     15,    313,      1,     10,     15
	,	   314,      2,     10,     20,    402,      0,     11,     20,    403
	,	     1,     11,     20,    404,      2,     11,      9,    522,      0
	,	    12,      9,    523,      1,     12,      9,    524,      2,     12
	,	     0,      0,      0,      0,      0,      0,      0,      0
	}
,	{
		     3,      0,      3,      0,      3,      6,      3,      1,      3
	,	    12,      3,      2,      3,     18,      3,      3,      3,     24
	,	     3,      4,      3,     30,      3,      5,      3,     36,      0
	,	     3,      3,     37,      1,      3,      3,     38,      2,      3
	,	     4,     54,      0,      4,      4,     55,      1,      4,      4
	,	    56,      2,      4,      5,     78,      0,      5,      5,     79
	,	     1,      5,      5,     80,      2,      5,      6,    108,      0
	,	     6,      6,    109,      1,      6,      6,    110,      2,      6
	,	     7,    144,      0,      7,      7,    145,      1,      7,      7
	,	   146,      2,      7,      9,    186,      0,      8,      9,    187
	,	     1,      8,      9,    188,      2,      8,     12,    240,      0
	,	     9,     12,    241,      1,      9,     12,    242,      2,      9
	,	    15,    312,      0,     10,     15,    313,      1,     10,     15
	,	   314,      2,     10,     20,    402,      0,     11,     20,    403
	,	     1,     11,     20,    404,      2,     11,      9,    522,      0
	,	    12,      9,    523,      1,     12,      9,    524,      2,     12
	,	     0,      0,      0,      0,      0,      0,      0,      0
	}
,	{
		     3,      0,      3,      0,      3,      6,      3,      1,      3
	,	    12,      3,      2,      3,     18,      3,      3,      3,     24
	,	     3,      4,      3,     30,      3,      5,      3,     36,      0
	,	     3,      3,     37,      1,      3,      3,     38,      2,      3
	,	     4,     54,      0,      4,      4,     55,      1,      4,      4
	,	    56,      2,      4,      5,     78,      0,      5,      5,     79
	,	     1,      5,      5,     80,      2,      5,      6,    108,      0
	,	     6,      6,    109,      1,      6,      6,    110,      2,      6
	,	     7,    144,      0,      7,      7,    145,      1,      7,      7
	,	   146,      2,      7,      9,    186,      0,      8,      9,    187
	,	     1,      8,      9,    188,      2,      8,     12,    240,      0
	,	     9,     12,    241,      1,      9,     12,    242,      2,      9
	,	    15,    312,      0,     10,     15,    313,      1,     10,     15
	,	   314,      2,     10,     20,    402,      0,     11,     20,    403
	,	     1,     11,     20,    404,      2,     11,      9,    522,      0
	,	    12,      9,    523,      1,     12,      9,    524,      2,     12
	,	     0,      0,      0,      0,      0,      0,      0,      0
	}
,	{
		     6,      0,      3,      0,      6,     12,      3,      1,      6
	,	    24,      3,      2,      6,     36,      3,      3,      6,     48
	,	     3,      4,      6,     60,      3,      5,      6,     72,      0
	,	     3,      6,     73,      1,      3,      6,     74,      2,      3
	,	     8,    108,      0,      4,      8,    109,      1,      4,      8
	,	   110,      2,      4,     10,    156,      0,      5,     10,    157
	,	     1,      5,     10,    158,      2,      5,     12,    216,      0
	,	     6,     12,    217,      1,      6,     12,    218,      2,      6
	,	    14,    288,      0,      7,     14,    289,      1,      7,     14
	,	   290,      2,      7,     18,    372,      0,      8,     18,    373
	,	     1,      8,     18,    374,      2,      8,      1,    480,      0
	,	     9,      1,    481,      1,      9,      1,    482,      2,      9
	,	     1,    486,      0,     10,      1,    487,      1,     10,      1
	,	   488,      2,     10,      1,    492,      0,     11,      1,    493
	,	     1,     11,      1,    494,      2,     11,     13,    498,      0
	,	    12,     13,    499,      1,     12,     13,    500,      2,     12
	,	     0,      0,      0,      0,      0,      0,      0,      0
	}
};
static const short mapbuf1[9][156] =
{
	{
		     2,      0,      0,      0,      2,      1,      1,      0,      2
	,	     2,      2,      0,      2,     12,      0,      1,      2,     13
	,	     1,      1,      2,     14,      2,      1,      2,     24,      0
	,	     2,      2,     25,      1,      2,      2,     26,      2,      2
	,	     2,     36,      0,      3,      2,     37,      1,      3,      2
	,	    38,      2,      3,      3,     48,      0,      4,      3,     49
	,	     1,      4,      3,     50,      2,      4,      4,     66,      0
	,	     5,      4,     67,      1,      5,      4,     68,      2,      5
	,	     5,     90,      0,      6,      5,     91,      1,      6,      5
	,	    92,      2,      6,      6,    120,      0,      7,      6,    121
	,	     1,      7,      6,    122,      2,      7,      7,    156,      0
	,	     8,      7,    157,      1,      8,      7,    158,      2,      8
	,	     9,    198,      0,      9,      9,    199,      1,      9,      9
	,	   200,      2,      9,     11,    252,      0,     10,     11,    253
	,	     1,     10,     11,    254,      2,     10,     15,    318,      0
	,	    11,     15,    319,      1,     11,     15,    320,      2,     11
	,	    28,    408,      0,     12,     28,    409,      1,     12,     28
	,	   410,      2,     12
	}
,	{
		     2,      0,      0,      0,      2,      1,      1,      0,      2
	,	     2,      2,      0,      2,     12,      0,      1,      2,     13
	,	     1,      1,      2,     14,      2,      1,      2,     24,      0
	,	     2,      2,     25,      1,      2,      2,     26,      2,      2
	,	     2,     36,      0,      3,      2,     37,      1,      3,      2
	,	    38,      2,      3,      3,     48,      0,      4,      3,     49
	,	     1,      4,      3,     50,      2,      4,      3,     66,      0
	,	     5,      3,     67,      1,      5,      3,     68,      2,      5
	,	     5,     84,      0,      6,      5,     85,      1,      6,      5
	,	    86,      2,      6,      6,    114,      0,      7,      6,    115
	,	     1,      7,      6,    116,      2,      7,      7,    150,      0
	,	     8,      7,    151,      1,      8,      7,    152,      2,      8
	,	     8,    192,      0,      9,      8,    193,      1,      9,      8
	,	   194,      2,      9,     10,    240,      0,     10,     10,    241
	,	     1,     10,     10,    242,      2,     10,     13,    300,      0
	,	    11,     13,    301,      1,     11,     13,    302,      2,     11
	,	    33,    378,      0,     12,     33,    379,      1,     12,     33
	,	   380,      2,     12
	}
,	{
		     2,      0,      0,      0,      2,      1,      1,      0,      2
	,	     2,      2,      0,      2,     12,      0,      1,      2,     13
	,	     1,      1,      2,     14,      2,      1,      2,     24,      0
	,	     2,      2,     25,      1,      2,      2,     26,      2,      2
	,	     2,     36,      0,      3,      2,     37,      1,      3,      2
	,	    38,      2,      3,      3,     48,      0,      4,      3,     49
	,	     1,      4,      3,     50,      2,      4,      4,     66,      0
	,	     5,      4,     67,      1,      5,      4,     68,      2,      5
	,	     6,     90,      0,      6,      6,     91,      1,      6,      6
	,	    92,      2,      6,      8,    126,      0,      7,      8,    127
	,	     1,      7,      8,    128,      2,      7,     10,    174,      0
	,	     8,     10,    175,      1,      8,     10,    176,      2,      8
	,	    13,    234,      0,      9,     13,    235,      1,      9,     13
	,	   236,      2,      9,     17,    312,      0,     10,     17,    313
	,	     1,     10,     17,    314,      2,     10,     21,    414,      0
	,	    11,     21,    415,      1,     11,     21,    416,      2,     11
	,	     6,    540,      0,     12,      6,    541,      1,     12,      6
	,	   542,      2,     12
	}
,	{
		     2,      0,      0,      0,      2,      1,      1,      0,      2
	,	     2,      2,      0,      2,     12,      0,      1,      2,     13
	,	     1,      1,      2,     14,      2,      1,      2,     24,      0
	,	     2,      2,     25,      1,      2,      2,     26,      2,      2
	,	     3,     36,      0,      3,      3,     37,      1,      3,      3
	,	    38,      2,      3,      3,     54,      0,      4,      3,     55
	,	     1,      4,      3,     56,      2,      4,      4,     72,      0
	,	     5,      4,     73,      1,      5,      4,     74,      2,      5
	,	     5,     96,      0,      6,      5,     97,      1,      6,      5
	,	    98,      2,      6,      7,    126,      0,      7,      7,    127
	,	     1,      7,      7,    128,      2,      7,      9,    168,      0
	,	     8,      9,    169,      1,      8,      9,    170,      2,      8
	,	    13,    222,      0,      9,     13,    223,      1,      9,     13
	,	   224,      2,      9,     16,    300,      0,     10,     16,    301
	,	     1,     10,     16,    302,      2,     10,     21,    396,      0
	,	    11,     21,    397,      1,     11,     21,    398,      2,     11
	,	     9,    522,      0,     12,      9,    523,      1,     12,      9
	,	   524,      2,     12
	}
,	{
		     2,      0,      0,      0,      2,      1,      1,      0,      2
	,	     2,      2,      0,      2,     12,      0,      1,      2,     13
	,	     1,      1,      2,     14,      2,      1,      2,     24,      0
	,	     2,      2,     25,      1,      2,      2,     26,      2,      2
	,	     3,     36,      0,      3,      3,     37,      1,      3,      3
	,	    38,      2,      3,      4,     54,      0,      4,      4,     55
	,	     1,      4,      4,     56,      2,      4,      5,     78,      0
	,	     5,      5,     79,      1,      5,      5,     80,      2,      5
	,	     6,    108,      0,      6,      6,    109,      1,      6,      6
	,	   110,      2,      6,      7,    144,      0,      7,      7,    145
	,	     1,      7,      7,    146,      2,      7,      9,    186,      0
	,	     8,      9,    187,      1,      8,      9,    188,      2,      8
	,	    12,    240,      0,      9,     12,    241,      1,      9,     12
	,	   242,      2,      9,     16,    312,      0,     10,     16,    313
	,	     1,     10,     16,    314,      2,     10,     22,    408,      0
	,	    11,     22,    409,      1,     11,     22,    410,      2,     11
	,	     6,    540,      0,     12,      6,    541,      1,     12,      6
	,	   542,      2,     12
	}
,	{
		     2,      0,      0,      0,      2,      1,      1,      0,      2
	,	     2,      2,      0,      2,     12,      0,      1,      2,     13
	,	     1,      1,      2,     14,      2,      1,      2,     24,      0
	,	     2,      2,     25,      1,      2,      2,     26,      2,      2
	,	     3,     36,      0,      3,      3,     37,      1,      3,      3
	,	    38,      2,      3,      4,     54,      0,      4,      4,     55
	,	     1,      4,      4,     56,      2,      4,      5,     78,      0
	,	     5,      5,     79,      1,      5,      5,     80,      2,      5
	,	     6,    108,      0,      6,      6,    109,      1,      6,      6
	,	   110,      2,      6,      7,    144,      0,      7,      7,    145
	,	     1,      7,      7,    146,      2,      7,      9,    186,      0
	,	     8,      9,    187,      1,      8,      9,    188,      2,      8
	,	    12,    240,      0,      9,     12,    241,      1,      9,     12
	,	   242,      2,      9,     15,    312,      0,     10,     15,    313
	,	     1,     10,     15,    314,      2,     10,     20,    402,      0
	,	    11,     20,    403,      1,     11,     20,    404,      2,     11
	,	     9,    522,      0,     12,      9,    523,      1,     12,      9
	,	   524,      2,     12
	}
,	{
		     2,      0,      0,      0,      2,      1,      1,      0,      2
	,	     2,      2,      0,      2,     12,      0,      1,      2,     13
	,	     1,      1,      2,     14,      2,      1,      2,     24,      0
	,	     2,      2,     25,      1,      2,      2,     26,      2,      2
	,	     3,     36,      0,      3,      3,     37,      1,      3,      3
	,	    38,      2,      3,      4,     54,      0,      4,      4,     55
	,	     1,      4,      4,     56,      2,      4,      5,     78,      0
	,	     5,      5,     79,      1,      5,      5,     80,      2,      5
	,	     6,    108,      0,      6,      6,    109,      1,      6,      6
	,	   110,      2,      6,      7,    144,      0,      7,      7,    145
	,	     1,      7,      7,    146,      2,      7,      9,    186,      0
	,	     8,      9,    187,      1,      8,      9,    188,      2,      8
	,	    12,    240,      0,      9,     12,    241,      1,      9,     12
	,	   242,      2,      9,     15,    312,      0,     10,     15,    313
	,	     1,     10,     15,    314,      2,     10,     20,    402,      0
	,	    11,     20,    403,      1,     11,     20,    404,      2,     11
	,	     9,    522,      0,     12,      9,    523,      1,     12,      9
	,	   524,      2,     12
	}
,	{
		     2,      0,      0,      0,      2,      1,      1,      0,      2
	,	     2,      2,      0,      2,     12,      0,      1,      2,     13
	,	     1,      1,      2,     14,      2,      1,      2,     24,      0
	,	     2,      2,     25,      1,      2,      2,     26,      2,      2
	,	     3,     36,      0,      3,      3,     37,      1,      3,      3
	,	    38,      2,      3,      4,     54,      0,      4,      4,     55
	,	     1,      4,      4,     56,      2,      4,      5,     78,      0
	,	     5,      5,     79,      1,      5,      5,     80,      2,      5
	,	     6,    108,      0,      6,      6,    109,      1,      6,      6
	,	   110,      2,      6,      7,    144,      0,      7,      7,    145
	,	     1,      7,      7,    146,      2,      7,      9,    186,      0
	,	     8,      9,    187,      1,      8,      9,    188,      2,      8
	,	    12,    240,      0,      9,     12,    241,      1,      9,     12
	,	   242,      2,      9,     15,    312,      0,     10,     15,    313
	,	     1,     10,     15,    314,      2,     10,     20,    402,      0
	,	    11,     20,    403,      1,     11,     20,    404,      2,     11
	,	     9,    522,      0,     12,      9,    523,      1,     12,      9
	,	   524,      2,     12
	}
,	{
		     4,      0,      0,      0,      4,      1,      1,      0,      4
	,	     2,      2,      0,      4,     24,      0,      1,      4,     25
	,	     1,      1,      4,     26,      2,      1,      4,     48,      0
	,	     2,      4,     49,      1,      2,      4,     50,      2,      2
	,	     6,     72,      0,      3,      6,     73,      1,      3,      6
	,	    74,      2,      3,      8,    108,      0,      4,      8,    109
	,	     1,      4,      8,    110,      2,      4,     10,    156,      0
	,	     5,     10,    157,      1,      5,     10,    158,      2,      5
	,	    12,    216,      0,      6,     12,    217,      1,      6,     12
	,	   218,      2,      6,     14,    288,      0,      7,     14,    289
	,	     1,      7,     14,    290,      2,      7,     18,    372,      0
	,	     8,     18,    373,      1,      8,     18,    374,      2,      8
	,	     1,    480,      0,      9,      1,    481,      1,      9,      1
	,	   482,      2,      9,      1,    486,      0,     10,      1,    487
	,	     1,     10,      1,    488,      2,     10,      1,    492,      0
	,	    11,      1,    493,      1,     11,      1,    494,      2,     11
	,	    13,    498,      0,     12,     13,    499,      1,     12,     13
	,	   500,      2,     12
	}
};
static const short mapbuf2[9][44] =
{
	{
		     2,      0,      2,      1,      2,      2,      2,      3,      2
	,	     4,      2,      5,      3,      6,      3,      7,      4,      8
	,	     4,      9,      5,     10,      6,     11,      8,     12,     10
	,	    13,     12,     14,     14,     15,     17,     16,     21,     17
	,	    25,     18,     27,     19,     38,     20,     79,     21
	}
,	{
		     2,      0,      2,      1,      2,      2,      2,      3,      2
	,	     4,      2,      5,      3,      6,      3,      7,      3,      8
	,	     4,      9,      5,     10,      6,     11,      8,     12,      9
	,	    13,     11,     14,     14,     15,     17,     16,     20,     17
	,	    23,     18,     27,     19,     27,     20,     96,     21
	}
,	{
		     2,      0,      2,      1,      2,      2,      2,      3,      2
	,	     4,      2,      5,      3,      6,      3,      7,      4,      8
	,	     5,      9,      6,     10,      8,     11,     10,     12,     12
	,	    13,     15,     14,     19,     15,     23,     16,     28,     17
	,	    34,     18,     42,     19,     51,     20,     13,     21
	}
,	{
		     3,      0,      3,      1,      3,      2,      3,      3,      3
	,	     4,      3,      5,      4,      6,      5,      7,      6,      8
	,	     7,      9,      8,     10,     10,     11,     12,     12,     14
	,	    13,     16,     14,     19,     15,     23,     16,     26,     17
	,	    30,     18,     34,     19,     29,     20,     27,     21
	}
,	{
		     3,      0,      3,      1,      3,      2,      3,      3,      3
	,	     4,      3,      5,      4,      6,      5,      7,      6,      8
	,	     7,      9,      8,     10,      9,     11,     11,     12,     13
	,	    13,     16,     14,     19,     15,     23,     16,     27,     17
	,	    31,     18,     35,     19,     38,     20,     18,     21
	}
,	{
		     3,      0,      3,      1,      3,      2,      3,      3,      3
	,	     4,      3,      5,      4,      6,      5,      7,      6,      8
	,	     7,      9,      8,     10,     10,     11,     12,     12,     14
	,	    13,     16,     14,     19,     15,     23,     16,     26,     17
	,	    30,     18,     34,     19,     29,     20,     27,     21
	}
,	{
		     3,      0,      3,      1,      3,      2,      3,      3,      3
	,	     4,      3,      5,      4,      6,      5,      7,      6,      8
	,	     7,      9,      8,     10,     10,     11,     12,     12,     14
	,	    13,     16,     14,     19,     15,     23,     16,     26,     17
	,	    30,     18,     34,     19,     29,     20,     27,     21
	}
,	{
		     3,      0,      3,      1,      3,      2,      3,      3,      3
	,	     4,      3,      5,      4,      6,      5,      7,      6,      8
	,	     7,      9,      8,     10,     10,     11,     12,     12,     14
	,	    13,     16,     14,     19,     15,     23,     16,     26,     17
	,	    30,     18,     34,     19,     29,     20,     27,     21
	}
,	{
		     6,      0,      6,      1,      6,      2,      6,      3,      6
	,	     4,      6,      5,      8,      6,     10,      7,     12,      8
	,	    14,      9,     16,     10,     20,     11,     24,     12,     28
	,	    13,     32,     14,     38,     15,     45,     16,      1,     17
	,	     1,     18,      1,     19,      1,     20,      1,     21
	}
};
static const short *map[9][3] =
{
	{ mapbuf0[0], mapbuf1[0], mapbuf2[0] }
,	{ mapbuf0[1], mapbuf1[1], mapbuf2[1] }
,	{ mapbuf0[2], mapbuf1[2], mapbuf2[2] }
,	{ mapbuf0[3], mapbuf1[3], mapbuf2[3] }
,	{ mapbuf0[4], mapbuf1[4], mapbuf2[4] }
,	{ mapbuf0[5], mapbuf1[5], mapbuf2[5] }
,	{ mapbuf0[6], mapbuf1[6], mapbuf2[6] }
,	{ mapbuf0[7], mapbuf1[7], mapbuf2[7] }
,	{ mapbuf0[8], mapbuf1[8], mapbuf2[8] }
};
static const short *mapend[9][3] =
{
	{ mapbuf0[0]+152, mapbuf1[0]+156, mapbuf2[0]+44 }
,	{ mapbuf0[1]+152, mapbuf1[1]+156, mapbuf2[1]+44 }
,	{ mapbuf0[2]+152, mapbuf1[2]+156, mapbuf2[2]+44 }
,	{ mapbuf0[3]+144, mapbuf1[3]+156, mapbuf2[3]+44 }
,	{ mapbuf0[4]+144, mapbuf1[4]+156, mapbuf2[4]+44 }
,	{ mapbuf0[5]+144, mapbuf1[5]+156, mapbuf2[5]+44 }
,	{ mapbuf0[6]+144, mapbuf1[6]+156, mapbuf2[6]+44 }
,	{ mapbuf0[7]+144, mapbuf1[7]+156, mapbuf2[7]+44 }
,	{ mapbuf0[8]+144, mapbuf1[8]+156, mapbuf2[8]+44 }
};
static const unsigned short n_slen2[512] =
{
	       0,      512,     1024,     1536,       64,      576,     1088,     1600,      128
,	     640,     1152,     1664,      192,      704,     1216,     1728,        8,      520
,	    1032,     1544,       72,      584,     1096,     1608,      136,      648,     1160
,	    1672,      200,      712,     1224,     1736,       16,      528,     1040,     1552
,	      80,      592,     1104,     1616,      144,      656,     1168,     1680,      208
,	     720,     1232,     1744,       24,      536,     1048,     1560,       88,      600
,	    1112,     1624,      152,      664,     1176,     1688,      216,      728,     1240
,	    1752,       32,      544,     1056,     1568,       96,      608,     1120,     1632
,	     160,      672,     1184,     1696,      224,      736,     1248,     1760,        1
,	     513,     1025,     1537,       65,      577,     1089,     1601,      129,      641
,	    1153,     1665,      193,      705,     1217,     1729,        9,      521,     1033
,	    1545,       73,      585,     1097,     1609,      137,      649,     1161,     1673
,	     201,      713,     1225,     1737,       17,      529,     1041,     1553,       81
,	     593,     1105,     1617,      145,      657,     1169,     1681,      209,      721
,	    1233,     1745,       25,      537,     1049,     1561,       89,      601,     1113
,	    1625,      153,      665,     1177,     1689,      217,      729,     1241,     1753
,	      33,      545,     1057,     1569,       97,      609,     1121,     1633,      161
,	     673,     1185,     1697,      225,      737,     1249,     1761,        2,      514
,	    1026,     1538,       66,      578,     1090,     1602,      130,      642,     1154
,	    1666,      194,      706,     1218,     1730,       10,      522,     1034,     1546
,	      74,      586,     1098,     1610,      138,      650,     1162,     1674,      202
,	     714,     1226,     1738,       18,      530,     1042,     1554,       82,      594
,	    1106,     1618,      146,      658,     1170,     1682,      210,      722,     1234
,	    1746,       26,      538,     1050,     1562,       90,      602,     1114,     1626
,	     154,      666,     1178,     1690,      218,      730,     1242,     1754,       34
,	     546,     1058,     1570,       98,      610,     1122,     1634,      162,      674
,	    1186,     1698,      226,      738,     1250,     1762,        3,      515,     1027
,	    1539,       67,      579,     1091,     1603,      131,      643,     1155,     1667
,	     195,      707,     1219,     1731,       11,      523,     1035,     1547,       75
,	     587,     1099,     1611,      139,      651,     1163,     1675,      203,      715
,	    1227,     1739,       19,      531,     1043,     1555,       83,      595,     1107
,	    1619,      147,      659,     1171,     1683,      211,      723,     1235,     1747
,	      27,      539,     1051,     1563,       91,      603,     1115,     1627,      155
,	     667,     1179,     1691,      219,      731,     1243,     1755,       35,      547
,	    1059,     1571,       99,      611,     1123,     1635,      163,      675,     1187
,	    1699,      227,      739,     1251,     1763,        4,      516,     1028,     1540
,	      68,      580,     1092,     1604,      132,      644,     1156,     1668,      196
,	     708,     1220,     1732,       12,      524,     1036,     1548,       76,      588
,	    1100,     1612,      140,      652,     1164,     1676,      204,      716,     1228
,	    1740,       20,      532,     1044,     1556,       84,      596,     1108,     1620
,	     148,      660,     1172,     1684,      212,      724,     1236,     1748,       28
,	     540,     1052,     1564,       92,      604,     1116,     1628,      156,      668
,	    1180,     1692,      220,      732,     1244,     1756,       36,      548,     1060
,	    1572,      100,      612,     1124,     1636,      164,      676,     1188,     1700
,	     228,      740,     1252,     1764,     4096,     4160,     4224,     4288,     4104
,	    4168,     4232,     4296,     4112,     4176,     4240,     4304,     4120,     4184
,	    4248,     4312,     4128,     4192,     4256,     4320,     4097,     4161,     4225
,	    4289,     4105,     4169,     4233,     4297,     4113,     4177,     4241,     4305
,	    4121,     4185,     4249,     4313,     4129,     4193,     4257,     4321,     4098
,	    4162,     4226,     4290,     4106,     4170,     4234,     4298,     4114,     4178
,	    4242,     4306,     4122,     4186,     4250,     4314,     4130,     4194,     4258
,	    4322,     4099,     4163,     4227,     4291,     4107,     4171,     4235,     4299
,	    4115,     4179,     4243,     4307,     4123,     4187,     4251,     4315,     4131
,	    4195,     4259,     4323,     4100,     4164,     4228,     4292,     4108,     4172
,	    4236,     4300,     4116,     4180,     4244,     4308,     4124,     4188,     4252
,	    4316,     4132,     4196,     4260,     4324,    40960,    40968,    40976,    40961
,	   40969,    40977,    40962,    40970,    40978,    40963,    40971,    40979
};
static const unsigned short i_slen2[256] =
{
	   12288,    12352,    12416,    12480,    12544,    12608,    12296,    12360,    12424
,	   12488,    12552,    12616,    12304,    12368,    12432,    12496,    12560,    12624
,	   12312,    12376,    12440,    12504,    12568,    12632,    12320,    12384,    12448
,	   12512,    12576,    12640,    12328,    12392,    12456,    12520,    12584,    12648
,	   12289,    12353,    12417,    12481,    12545,    12609,    12297,    12361,    12425
,	   12489,    12553,    12617,    12305,    12369,    12433,    12497,    12561,    12625
,	   12313,    12377,    12441,    12505,    12569,    12633,    12321,    12385,    12449
,	   12513,    12577,    12641,    12329,    12393,    12457,    12521,    12585,    12649
,	   12290,    12354,    12418,    12482,    12546,    12610,    12298,    12362,    12426
,	   12490,    12554,    12618,    12306,    12370,    12434,    12498,    12562,    12626
,	   12314,    12378,    12442,    12506,    12570,    12634,    12322,    12386,    12450
,	   12514,    12578,    12642,    12330,    12394,    12458,    12522,    12586,    12650
,	   12291,    12355,    12419,    12483,    12547,    12611,    12299,    12363,    12427
,	   12491,    12555,    12619,    12307,    12371,    12435,    12499,    12563,    12627
,	   12315,    12379,    12443,    12507,    12571,    12635,    12323,    12387,    12451
,	   12515,    12579,    12643,    12331,    12395,    12459,    12523,    12587,    12651
,	   12292,    12356,    12420,    12484,    12548,    12612,    12300,    12364,    12428
,	   12492,    12556,    12620,    12308,    12372,    12436,    12500,    12564,    12628
,	   12316,    12380,    12444,    12508,    12572,    12636,    12324,    12388,    12452
,	   12516,    12580,    12644,    12332,    12396,    12460,    12524,    12588,    12652
,	   16384,    16448,    16512,    16576,    16392,    16456,    16520,    16584,    16400
,	   16464,    16528,    16592,    16408,    16472,    16536,    16600,    16385,    16449
,	   16513,    16577,    16393,    16457,    16521,    16585,    16401,    16465,    16529
,	   16593,    16409,    16473,    16537,    16601,    16386,    16450,    16514,    16578
,	   16394,    16458,    16522,    16586,    16402,    16466,    16530,    16594,    16410
,	   16474,    16538,    16602,    16387,    16451,    16515,    16579,    16395,    16459
,	   16523,    16587,    16403,    16467,    16531,    16595,    16411,    16475,    16539
,	   16603,    20480,    20488,    20496,    20481,    20489,    20497,    20482,    20490
,	   20498,    20483,    20491,    20499
};

#endif
