.\" Copyright (c) 1993, 1994  X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
.\" OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall not
.\" be used in advertising or otherwise to promote the sale, use or other
.\" dealing in this Software without prior written authorization from the
.\" X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtCreate-Selection-Request XtSend-Selection-Request
.hw XtCancel-Selection-Request wid-get
.na
.TH XtCreateSelectionRequest __libmansuffix__ __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtCreateSelectionRequest, XtSendSelectionRequest, XtCancelSelectionRequest \- bundle multiple selection conversion requests into a single request using MULTIPLE target
.SH SYNTAX
#include <X11/Intrinsic.h>
.HP
void XtCreateSelectionRequest(Widget \fIrequestor\fP, Atom \fIselection\fP);
.HP
void XtSendSelectionRequest(Widget \fIrequestor\fP, Atom \fIselection\fP, Time
\fItime\fP);
.HP
void XtCancelSelectionRequest(Widget \fIrequestor\fP, Atom \fIselection\fP);
.SH ARGUMENTS
.IP \fIrequestor\fP 1i
Specifies the widget making the request.
Must be of class Core or a
subclass thereof.
.IP \fIselection\fP 1i
Specifies the particular selection desired.
.IP \fItime\fP 1i
Specifies the timestamp to be used in making the request.
.SH DESCRIPTION
When
.B XtCreateSelectionRequest
is called, subsequent calls to
.B XtGetSelectionValue
and
.B XtGetSelectionValueIncremental
with the requestor and selection as specified to
.B XtCreateSelectionRequest
will be bundled into a single selection conversion request with
multiple targets.
The request is actually initiated by calling
.BR XtSendSelectionRequest .
.LP
When
.B XtSendSelectionRequest
is called with a value of \fIrequestor\fP and \fIselection\fP matching
a previous call to
.BR XtCreateSelectionRequest ,
a selection conversion request is actually sent to the selection owner.
If a single target request is queued, that request is made.
If multiple
targets are queued they are bundled into a single request with the
target MULTIPLE using the specified timestamp.
As the conversions are
made, the callbacks associated with each
.B XtGetSelectionValue
and
.B XtGetSelectionValueIncremental
are invoked in turn.
.LP
Multi-threaded applications should lock the application context before
calling
.B XtCreateSelectionRequest
and release the lock after calling
.B XtSendSelectionRequest
to ensure that the thread assembling the request is safe from interference
by another thread assembling a different request naming the same widget
and selection.
.LP
When
.B XtCancelSelectionRequest
is called, any requests queued since the last call to
.B XtCreateSelectionRequest
are cleaned up.
Subsequent calls to
.BR XtGetSelectionValue ,
.BR XtGetSelectionValues ,
.BR XtGetSelectionValueIncremental ,
and
.B XtGetSelectionValuesIncremental
will not be deferred.
.SH "SEE ALSO"
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
