/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef EBOOKMEMORYSTREAM_H_INCLUDED
#define EBOOKMEMORYSTREAM_H_INCLUDED

#include <libwpd-stream/libwpd-stream.h>

namespace libebook
{

class EBOOKMemoryStream : public WPXInputStream
{
// disable copying
  EBOOKMemoryStream(const EBOOKMemoryStream &other);
  EBOOKMemoryStream &operator=(const EBOOKMemoryStream &other);

public:
  EBOOKMemoryStream(const unsigned char *data, unsigned length);
  virtual ~EBOOKMemoryStream();

  virtual bool isOLEStream();
  virtual WPXInputStream *getDocumentOLEStream(const char *name);

  virtual const unsigned char *read(unsigned long numBytes, unsigned long &numBytesRead);
  virtual int seek(long offset, WPX_SEEK_TYPE seekType);
  virtual long tell();
  virtual bool atEOS();

private:
  const unsigned char *m_data;
  const long m_length;
  long m_pos;
};

}

#endif // EBOOKMEMORYSTREAM_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
