/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfxml.xmlinput;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEvents;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFErrorHandler;
import org.apache.jena.rdf.model.RDFReader;
import org.apache.jena.rdf.model.impl.RDFDefaultErrorHandler;
import org.apache.jena.rdfxml.xmlinput.ALiteral;
import org.apache.jena.rdfxml.xmlinput.ARPErrorNumbers;
import org.apache.jena.rdfxml.xmlinput.ARPOptions;
import org.apache.jena.rdfxml.xmlinput.AResource;
import org.apache.jena.rdfxml.xmlinput.JenaHandler;
import org.apache.jena.rdfxml.xmlinput.ParseException;
import org.apache.jena.rdfxml.xmlinput.impl.RDFXMLParser;
import org.apache.jena.shared.DoesNotExistException;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.UnknownPropertyException;
import org.apache.jena.shared.WrappedIOException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class JenaReader
implements RDFReader,
ARPErrorNumbers {
    private static final String saxFeaturesURL = "http://xml.org/sax/features/";
    private static final String saxPropertiesURL = "http://xml.org/sax/properties/";
    private static final String apacheFeaturesURL = "http://apache.org/xml/features/";
    private static final String apachePropertiesURL = "http://apache.org/xml/properties/";
    static final String arpPropertiesURL = "http://jena.hpl.hp.com/arp/properties/";
    static final int arpPropertiesURLLength = "http://jena.hpl.hp.com/arp/properties/".length();
    private final RDFXMLParser arpf;
    private Model model;
    private JenaHandler handler;
    private RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();

    public JenaReader() {
        this.arpf = RDFXMLParser.create();
    }

    @Override
    public void read(Model m, String url) throws JenaException {
        try {
            URLConnection conn = new URL(url).openConnection();
            conn.setRequestProperty("accept", "application/rdf+xml, application/xml; q=0.8, text/xml; q=0.7, application/rss+xml; q=0.3, */*; q=0.2");
            String encoding = conn.getContentEncoding();
            if (encoding == null) {
                this.read(m, conn.getInputStream(), url);
            } else {
                this.read(m, (Reader)new InputStreamReader(conn.getInputStream(), encoding), url);
            }
        }
        catch (FileNotFoundException e) {
            throw new DoesNotExistException(url);
        }
        catch (IOException e) {
            throw new JenaException(e);
        }
    }

    private static Node convert(ALiteral lit) {
        String dtURI = lit.getDatatypeURI();
        if (dtURI == null) {
            return NodeFactory.createLiteral(lit.toString(), lit.getLang());
        }
        if (lit.isWellFormedXML()) {
            return NodeFactory.createLiteral(lit.toString(), null, true);
        }
        RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(dtURI);
        return NodeFactory.createLiteral(lit.toString(), dt);
    }

    private static Node convert(AResource r) {
        if (!r.isAnonymous()) {
            return NodeFactory.createURI(r.getURI());
        }
        Node rr = (Node)r.getUserData();
        if (rr == null) {
            rr = NodeFactory.createBlankNode();
            r.setUserData(rr);
        }
        return rr;
    }

    static Triple convert(AResource s, AResource p, AResource o) {
        return Triple.create(JenaReader.convert(s), JenaReader.convert(p), JenaReader.convert(o));
    }

    static Triple convert(AResource s, AResource p, ALiteral o) {
        return Triple.create(JenaReader.convert(s), JenaReader.convert(p), JenaReader.convert(o));
    }

    private void read(Model m, InputSource inputS, String xmlBase) throws JenaException {
        this.model = m;
        this.read(this.model.getGraph(), inputS, xmlBase, this.model);
    }

    private synchronized void read(Graph g, InputSource inputS, String xmlBase, Model m) {
        try {
            g.getEventManager().notifyEvent(g, GraphEvents.startRead);
            inputS.setSystemId(xmlBase);
            this.handler = new JenaHandler(g, m, this.errorHandler);
            this.handler.useWith(this.arpf.getHandlers());
            this.arpf.parse(inputS, xmlBase);
        }
        catch (IOException e) {
            throw new WrappedIOException(e);
        }
        catch (SAXException e) {
            throw new JenaException(e);
        }
        finally {
            g.getEventManager().notifyEvent(g, GraphEvents.finishRead);
            this.handler = null;
        }
    }

    @Override
    public void read(Model m, Reader reader, String xmlBase) throws JenaException {
        this.read(m, new InputSource(reader), xmlBase);
    }

    public void read(Graph g, Reader reader, String xmlBase) throws JenaException {
        this.read(g, new InputSource(reader), xmlBase, null);
    }

    @Override
    public void read(Model m, InputStream in, String xmlBase) throws JenaException {
        this.read(m, new InputSource(in), xmlBase);
    }

    public void read(Graph g, InputStream in, String xmlBase) {
        this.read(g, new InputSource(in), xmlBase, null);
    }

    @Override
    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.errorHandler;
        this.errorHandler = errHandler;
        JenaHandler h = this.handler;
        if (h != null) {
            h.setErrorHandler(errHandler);
        }
        return old;
    }

    @Override
    public Object setProperty(String str, Object value) throws JenaException {
        Object obj = value;
        if (str.startsWith("http:")) {
            if (str.startsWith(arpPropertiesURL)) {
                return this.setArpProperty(str.substring(arpPropertiesURLLength), obj);
            }
            if (str.startsWith(saxPropertiesURL) || str.startsWith(apachePropertiesURL)) {
                Object old;
                try {
                    old = this.arpf.getSAXParser().getProperty(str);
                }
                catch (SAXNotSupportedException ns) {
                    old = null;
                }
                catch (SAXNotRecognizedException nr) {
                    this.errorHandler.error(new UnknownPropertyException(str));
                    return null;
                }
                try {
                    this.arpf.getSAXParser().setProperty(str, obj);
                }
                catch (SAXNotSupportedException ns) {
                    this.errorHandler.error(new JenaException(ns));
                }
                catch (SAXNotRecognizedException nr) {
                    this.errorHandler.error(new UnknownPropertyException(str));
                    return null;
                }
                return old;
            }
            if (str.startsWith(saxFeaturesURL) || str.startsWith(apacheFeaturesURL)) {
                Boolean old;
                try {
                    old = this.arpf.getSAXParser().getFeature(str);
                }
                catch (SAXNotSupportedException ns) {
                    old = null;
                }
                catch (SAXNotRecognizedException nr) {
                    this.errorHandler.error(new UnknownPropertyException(str));
                    return null;
                }
                try {
                    this.arpf.getSAXParser().setFeature(str, (Boolean)obj);
                }
                catch (SAXNotSupportedException ns) {
                    this.errorHandler.error(new JenaException(ns));
                }
                catch (SAXNotRecognizedException nr) {
                    this.errorHandler.error(new UnknownPropertyException(str));
                    return null;
                }
                catch (ClassCastException cc) {
                    this.errorHandler.error(new JenaException(new SAXNotSupportedException("Feature: '" + str + "' can only have a boolean value.")));
                }
                return old;
            }
        }
        return this.setArpProperty(str, obj);
    }

    private Object setArpProperty(String str, Object v) {
        return JenaReader.processArpOptions(this.getOptions(), str, v, this.errorHandler);
    }

    public ARPOptions getOptions() {
        return this.arpf.getOptions();
    }

    public void setOptionsWith(ARPOptions opts) {
        this.arpf.setOptionsWith(opts);
    }

    static Object processArpOptions(ARPOptions options, String str, Object v, RDFErrorHandler eh) {
        int cond;
        str = str.toUpperCase();
        if (v == null) {
            v = "";
        }
        if (v instanceof String) {
            v = ((String)v).toUpperCase(Locale.ENGLISH);
        }
        if (str.equals("ERROR-MODE")) {
            if (v instanceof String) {
                String val = (String)v;
                if (val.equals("LAX")) {
                    options.setLaxErrorMode();
                    return null;
                }
                if (val.equals("DEFAULT")) {
                    options.setDefaultErrorMode();
                    return null;
                }
                if (val.equals("STRICT")) {
                    options.setStrictErrorMode();
                    return null;
                }
                if (val.equals("STRICT-WARNING")) {
                    options.setStrictErrorMode(1);
                    return null;
                }
                if (val.equals("STRICT-FATAL")) {
                    options.setStrictErrorMode(3);
                    return null;
                }
                if (val.equals("STRICT-IGNORE")) {
                    options.setStrictErrorMode(0);
                    return null;
                }
                if (val.equals("STRICT-ERROR")) {
                    options.setStrictErrorMode(2);
                    return null;
                }
            }
            eh.error(new IllegalArgumentException("Property \"ERROR-MODE\" takes the following values: \"default\", \"lax\", \"strict\", \"strict-ignore\", \"strict-warning\", \"strict-error\", \"strict.error\"."));
            return null;
        }
        if (str.equals("EMBEDDING")) {
            if (v instanceof String) {
                v = Boolean.valueOf((String)v);
            }
            if (v instanceof Boolean) {
                return options.setEmbedding((Boolean)v);
            }
            eh.error(new IllegalArgumentException("Property \"EMBEDDING\" requires a boolean value."));
            boolean old = options.setEmbedding(false);
            options.setEmbedding(old);
            return old;
        }
        if ((str.startsWith("ERR_") || str.startsWith("IGN_") || str.startsWith("WARN_")) && (cond = ParseException.errorCode(str)) != -1) {
            int val;
            if (v instanceof String) {
                if (((String)v).startsWith("EM_") && (val = ParseException.errorCode((String)v)) != -1) {
                    int rslt = options.setErrorMode(cond, val);
                    return rslt;
                }
            } else if (v instanceof Integer) {
                val = (Integer)v;
                switch (val) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        int rslt = options.setErrorMode(cond, val);
                        return rslt;
                    }
                }
            }
            eh.error(new IllegalArgumentException("Property \"" + str + "\" cannot have value: " + v.toString()));
            int old = options.setErrorMode(cond, 2);
            options.setErrorMode(cond, old);
            return old;
        }
        if (str.equals("IRI-RULES")) {
            IRIFactory old = options.getIRIFactory();
            if (v.equals("STRICT")) {
                options.setIRIFactory(IRIFactory.semanticWebImplementation());
            } else if (v.equals("IRI")) {
                options.setIRIFactory(IRIFactory.iriImplementation());
            } else if (v.equals("LAX")) {
                options.setIRIFactory(IRIFactory.jenaImplementation());
            } else {
                eh.error(new IllegalArgumentException("Property \"IRI-RULES\" requires one of 'STRICT', 'IRI' or 'LAX'"));
            }
            return old;
        }
        eh.error(new UnknownPropertyException(str));
        return null;
    }
}

