// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/genomics/v1alpha2/pipelines.proto

/*
Package genomics is a generated protocol buffer package.

It is generated from these files:
	google/genomics/v1alpha2/pipelines.proto

It has these top-level messages:
	ComputeEngine
	RuntimeMetadata
	Pipeline
	CreatePipelineRequest
	RunPipelineArgs
	RunPipelineRequest
	GetPipelineRequest
	ListPipelinesRequest
	ListPipelinesResponse
	DeletePipelineRequest
	GetControllerConfigRequest
	ControllerConfig
	TimestampEvent
	SetOperationStatusRequest
	ServiceAccount
	LoggingOptions
	PipelineResources
	PipelineParameter
	DockerExecutor
*/
package genomics

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf3 "github.com/golang/protobuf/ptypes/duration"
import google_protobuf2 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf4 "github.com/golang/protobuf/ptypes/timestamp"
import google_rpc1 "google.golang.org/genproto/googleapis/rpc/code"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The types of disks that may be attached to VMs.
type PipelineResources_Disk_Type int32

const (
	// Default disk type. Use one of the other options below.
	PipelineResources_Disk_TYPE_UNSPECIFIED PipelineResources_Disk_Type = 0
	// Specifies a Google Compute Engine persistent hard disk. See
	// https://cloud.google.com/compute/docs/disks/#pdspecs for details.
	PipelineResources_Disk_PERSISTENT_HDD PipelineResources_Disk_Type = 1
	// Specifies a Google Compute Engine persistent solid-state disk. See
	// https://cloud.google.com/compute/docs/disks/#pdspecs for details.
	PipelineResources_Disk_PERSISTENT_SSD PipelineResources_Disk_Type = 2
	// Specifies a Google Compute Engine local SSD.
	// See https://cloud.google.com/compute/docs/disks/local-ssd for details.
	PipelineResources_Disk_LOCAL_SSD PipelineResources_Disk_Type = 3
)

var PipelineResources_Disk_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "PERSISTENT_HDD",
	2: "PERSISTENT_SSD",
	3: "LOCAL_SSD",
}
var PipelineResources_Disk_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"PERSISTENT_HDD":   1,
	"PERSISTENT_SSD":   2,
	"LOCAL_SSD":        3,
}

func (x PipelineResources_Disk_Type) String() string {
	return proto.EnumName(PipelineResources_Disk_Type_name, int32(x))
}
func (PipelineResources_Disk_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{16, 0, 0}
}

// Describes a Compute Engine resource that is being managed by a running
// [pipeline][google.genomics.v1alpha2.Pipeline].
type ComputeEngine struct {
	// The instance on which the operation is running.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName" json:"instance_name,omitempty"`
	// The availability zone in which the instance resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The machine type of the instance.
	MachineType string `protobuf:"bytes,3,opt,name=machine_type,json=machineType" json:"machine_type,omitempty"`
	// The names of the disks that were created for this pipeline.
	DiskNames []string `protobuf:"bytes,4,rep,name=disk_names,json=diskNames" json:"disk_names,omitempty"`
}

func (m *ComputeEngine) Reset()                    { *m = ComputeEngine{} }
func (m *ComputeEngine) String() string            { return proto.CompactTextString(m) }
func (*ComputeEngine) ProtoMessage()               {}
func (*ComputeEngine) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *ComputeEngine) GetInstanceName() string {
	if m != nil {
		return m.InstanceName
	}
	return ""
}

func (m *ComputeEngine) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *ComputeEngine) GetMachineType() string {
	if m != nil {
		return m.MachineType
	}
	return ""
}

func (m *ComputeEngine) GetDiskNames() []string {
	if m != nil {
		return m.DiskNames
	}
	return nil
}

// Runtime metadata that will be populated in the
// [runtimeMetadata][google.genomics.v1.OperationMetadata.runtime_metadata]
// field of the Operation associated with a RunPipeline execution.
type RuntimeMetadata struct {
	// Execution information specific to Google Compute Engine.
	ComputeEngine *ComputeEngine `protobuf:"bytes,1,opt,name=compute_engine,json=computeEngine" json:"compute_engine,omitempty"`
}

func (m *RuntimeMetadata) Reset()                    { *m = RuntimeMetadata{} }
func (m *RuntimeMetadata) String() string            { return proto.CompactTextString(m) }
func (*RuntimeMetadata) ProtoMessage()               {}
func (*RuntimeMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *RuntimeMetadata) GetComputeEngine() *ComputeEngine {
	if m != nil {
		return m.ComputeEngine
	}
	return nil
}

// The pipeline object. Represents a transformation from a set of input
// parameters to a set of output parameters. The transformation is defined
// as a docker image and command to run within that image. Each pipeline
// is run on a Google Compute Engine VM. A pipeline can be created with the
// `create` method and then later run with the `run` method, or a pipeline can
// be defined and run all at once with the `run` method.
type Pipeline struct {
	// Required. The project in which to create the pipeline. The caller must have
	// WRITE access.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Required. A user specified pipeline name that does not have to be unique.
	// This name can be used for filtering Pipelines in ListPipelines.
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	// User-specified description.
	Description string `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
	// Input parameters of the pipeline.
	InputParameters []*PipelineParameter `protobuf:"bytes,8,rep,name=input_parameters,json=inputParameters" json:"input_parameters,omitempty"`
	// Output parameters of the pipeline.
	OutputParameters []*PipelineParameter `protobuf:"bytes,9,rep,name=output_parameters,json=outputParameters" json:"output_parameters,omitempty"`
	// Required. The executor indicates in which environment the pipeline runs.
	//
	// Types that are valid to be assigned to Executor:
	//	*Pipeline_Docker
	Executor isPipeline_Executor `protobuf_oneof:"executor"`
	// Required. Specifies resource requirements for the pipeline run.
	// Required fields:
	//
	// *
	// [minimumCpuCores][google.genomics.v1alpha2.PipelineResources.minimum_cpu_cores]
	//
	// *
	// [minimumRamGb][google.genomics.v1alpha2.PipelineResources.minimum_ram_gb]
	Resources *PipelineResources `protobuf:"bytes,6,opt,name=resources" json:"resources,omitempty"`
	// Unique pipeline id that is generated by the service when CreatePipeline
	// is called. Cannot be specified in the Pipeline used in the
	// CreatePipelineRequest, and will be populated in the response to
	// CreatePipeline and all subsequent Get and List calls. Indicates that the
	// service has registered this pipeline.
	PipelineId string `protobuf:"bytes,7,opt,name=pipeline_id,json=pipelineId" json:"pipeline_id,omitempty"`
}

func (m *Pipeline) Reset()                    { *m = Pipeline{} }
func (m *Pipeline) String() string            { return proto.CompactTextString(m) }
func (*Pipeline) ProtoMessage()               {}
func (*Pipeline) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

type isPipeline_Executor interface {
	isPipeline_Executor()
}

type Pipeline_Docker struct {
	Docker *DockerExecutor `protobuf:"bytes,5,opt,name=docker,oneof"`
}

func (*Pipeline_Docker) isPipeline_Executor() {}

func (m *Pipeline) GetExecutor() isPipeline_Executor {
	if m != nil {
		return m.Executor
	}
	return nil
}

func (m *Pipeline) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *Pipeline) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Pipeline) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Pipeline) GetInputParameters() []*PipelineParameter {
	if m != nil {
		return m.InputParameters
	}
	return nil
}

func (m *Pipeline) GetOutputParameters() []*PipelineParameter {
	if m != nil {
		return m.OutputParameters
	}
	return nil
}

func (m *Pipeline) GetDocker() *DockerExecutor {
	if x, ok := m.GetExecutor().(*Pipeline_Docker); ok {
		return x.Docker
	}
	return nil
}

func (m *Pipeline) GetResources() *PipelineResources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *Pipeline) GetPipelineId() string {
	if m != nil {
		return m.PipelineId
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Pipeline) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Pipeline_OneofMarshaler, _Pipeline_OneofUnmarshaler, _Pipeline_OneofSizer, []interface{}{
		(*Pipeline_Docker)(nil),
	}
}

func _Pipeline_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Pipeline)
	// executor
	switch x := m.Executor.(type) {
	case *Pipeline_Docker:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Docker); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Pipeline.Executor has unexpected type %T", x)
	}
	return nil
}

func _Pipeline_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Pipeline)
	switch tag {
	case 5: // executor.docker
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DockerExecutor)
		err := b.DecodeMessage(msg)
		m.Executor = &Pipeline_Docker{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Pipeline_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Pipeline)
	// executor
	switch x := m.Executor.(type) {
	case *Pipeline_Docker:
		s := proto.Size(x.Docker)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The request to create a pipeline. The pipeline field here should not have
// `pipelineId` populated, as that will be populated by the server.
type CreatePipelineRequest struct {
	// The pipeline to create. Should not have `pipelineId` populated.
	Pipeline *Pipeline `protobuf:"bytes,1,opt,name=pipeline" json:"pipeline,omitempty"`
}

func (m *CreatePipelineRequest) Reset()                    { *m = CreatePipelineRequest{} }
func (m *CreatePipelineRequest) String() string            { return proto.CompactTextString(m) }
func (*CreatePipelineRequest) ProtoMessage()               {}
func (*CreatePipelineRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *CreatePipelineRequest) GetPipeline() *Pipeline {
	if m != nil {
		return m.Pipeline
	}
	return nil
}

// The pipeline run arguments.
type RunPipelineArgs struct {
	// Required. The project in which to run the pipeline. The caller must have
	// WRITER access to all Google Cloud services and resources (e.g. Google
	// Compute Engine) will be used.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Pipeline input arguments; keys are defined in the pipeline documentation.
	// All input parameters that do not have default values  must be specified.
	// If parameters with defaults are specified here, the defaults will be
	// overridden.
	Inputs map[string]string `protobuf:"bytes,2,rep,name=inputs" json:"inputs,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Pipeline output arguments; keys are defined in the pipeline
	// documentation.  All output parameters of without default values
	// must be specified.  If parameters with defaults are specified
	// here, the defaults will be overridden.
	Outputs map[string]string `protobuf:"bytes,3,rep,name=outputs" json:"outputs,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The Google Cloud Service Account that will be used to access data and
	// services. By default, the compute service account associated with
	// `projectId` is used.
	ServiceAccount *ServiceAccount `protobuf:"bytes,4,opt,name=service_account,json=serviceAccount" json:"service_account,omitempty"`
	// This field is deprecated. Use `labels` instead. Client-specified pipeline
	// operation identifier.
	ClientId string `protobuf:"bytes,5,opt,name=client_id,json=clientId" json:"client_id,omitempty"`
	// Specifies resource requirements/overrides for the pipeline run.
	Resources *PipelineResources `protobuf:"bytes,6,opt,name=resources" json:"resources,omitempty"`
	// Required. Logging options. Used by the service to communicate results
	// to the user.
	Logging *LoggingOptions `protobuf:"bytes,7,opt,name=logging" json:"logging,omitempty"`
	// How long to keep the VM up after a failure (for example docker command
	// failed, copying input or output files failed, etc). While the VM is up, one
	// can ssh into the VM to debug. Default is 0; maximum allowed value is 1 day.
	KeepVmAliveOnFailureDuration *google_protobuf3.Duration `protobuf:"bytes,8,opt,name=keep_vm_alive_on_failure_duration,json=keepVmAliveOnFailureDuration" json:"keep_vm_alive_on_failure_duration,omitempty"`
	// Labels to apply to this pipeline run. Labels will also be applied to
	// compute resources (VM, disks) created by this pipeline run. When listing
	// operations, operations can [filtered by labels]
	// [google.longrunning.ListOperationsRequest.filter].
	// Label keys may not be empty; label values may be empty. Non-empty labels
	// must be 1-63 characters long, and comply with [RFC1035]
	// (https://www.ietf.org/rfc/rfc1035.txt).
	// Specifically, the name must be 1-63 characters long and match the regular
	// expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
	// character must be a lowercase letter, and all following characters must be
	// a dash, lowercase letter, or digit, except the last character, which cannot
	// be a dash.
	Labels map[string]string `protobuf:"bytes,9,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *RunPipelineArgs) Reset()                    { *m = RunPipelineArgs{} }
func (m *RunPipelineArgs) String() string            { return proto.CompactTextString(m) }
func (*RunPipelineArgs) ProtoMessage()               {}
func (*RunPipelineArgs) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *RunPipelineArgs) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *RunPipelineArgs) GetInputs() map[string]string {
	if m != nil {
		return m.Inputs
	}
	return nil
}

func (m *RunPipelineArgs) GetOutputs() map[string]string {
	if m != nil {
		return m.Outputs
	}
	return nil
}

func (m *RunPipelineArgs) GetServiceAccount() *ServiceAccount {
	if m != nil {
		return m.ServiceAccount
	}
	return nil
}

func (m *RunPipelineArgs) GetClientId() string {
	if m != nil {
		return m.ClientId
	}
	return ""
}

func (m *RunPipelineArgs) GetResources() *PipelineResources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *RunPipelineArgs) GetLogging() *LoggingOptions {
	if m != nil {
		return m.Logging
	}
	return nil
}

func (m *RunPipelineArgs) GetKeepVmAliveOnFailureDuration() *google_protobuf3.Duration {
	if m != nil {
		return m.KeepVmAliveOnFailureDuration
	}
	return nil
}

func (m *RunPipelineArgs) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// The request to run a pipeline. If `pipelineId` is specified, it
// refers to a saved pipeline created with CreatePipeline and set as
// the `pipelineId` of the returned Pipeline object. If
// `ephemeralPipeline` is specified, that pipeline is run once
// with the given args and not saved. It is an error to specify both
// `pipelineId` and `ephemeralPipeline`. `pipelineArgs`
// must be specified.
type RunPipelineRequest struct {
	// Types that are valid to be assigned to Pipeline:
	//	*RunPipelineRequest_PipelineId
	//	*RunPipelineRequest_EphemeralPipeline
	Pipeline isRunPipelineRequest_Pipeline `protobuf_oneof:"pipeline"`
	// The arguments to use when running this pipeline.
	PipelineArgs *RunPipelineArgs `protobuf:"bytes,3,opt,name=pipeline_args,json=pipelineArgs" json:"pipeline_args,omitempty"`
}

func (m *RunPipelineRequest) Reset()                    { *m = RunPipelineRequest{} }
func (m *RunPipelineRequest) String() string            { return proto.CompactTextString(m) }
func (*RunPipelineRequest) ProtoMessage()               {}
func (*RunPipelineRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

type isRunPipelineRequest_Pipeline interface {
	isRunPipelineRequest_Pipeline()
}

type RunPipelineRequest_PipelineId struct {
	PipelineId string `protobuf:"bytes,1,opt,name=pipeline_id,json=pipelineId,oneof"`
}
type RunPipelineRequest_EphemeralPipeline struct {
	EphemeralPipeline *Pipeline `protobuf:"bytes,2,opt,name=ephemeral_pipeline,json=ephemeralPipeline,oneof"`
}

func (*RunPipelineRequest_PipelineId) isRunPipelineRequest_Pipeline()        {}
func (*RunPipelineRequest_EphemeralPipeline) isRunPipelineRequest_Pipeline() {}

func (m *RunPipelineRequest) GetPipeline() isRunPipelineRequest_Pipeline {
	if m != nil {
		return m.Pipeline
	}
	return nil
}

func (m *RunPipelineRequest) GetPipelineId() string {
	if x, ok := m.GetPipeline().(*RunPipelineRequest_PipelineId); ok {
		return x.PipelineId
	}
	return ""
}

func (m *RunPipelineRequest) GetEphemeralPipeline() *Pipeline {
	if x, ok := m.GetPipeline().(*RunPipelineRequest_EphemeralPipeline); ok {
		return x.EphemeralPipeline
	}
	return nil
}

func (m *RunPipelineRequest) GetPipelineArgs() *RunPipelineArgs {
	if m != nil {
		return m.PipelineArgs
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RunPipelineRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RunPipelineRequest_OneofMarshaler, _RunPipelineRequest_OneofUnmarshaler, _RunPipelineRequest_OneofSizer, []interface{}{
		(*RunPipelineRequest_PipelineId)(nil),
		(*RunPipelineRequest_EphemeralPipeline)(nil),
	}
}

func _RunPipelineRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RunPipelineRequest)
	// pipeline
	switch x := m.Pipeline.(type) {
	case *RunPipelineRequest_PipelineId:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.PipelineId)
	case *RunPipelineRequest_EphemeralPipeline:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.EphemeralPipeline); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RunPipelineRequest.Pipeline has unexpected type %T", x)
	}
	return nil
}

func _RunPipelineRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RunPipelineRequest)
	switch tag {
	case 1: // pipeline.pipeline_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Pipeline = &RunPipelineRequest_PipelineId{x}
		return true, err
	case 2: // pipeline.ephemeral_pipeline
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Pipeline)
		err := b.DecodeMessage(msg)
		m.Pipeline = &RunPipelineRequest_EphemeralPipeline{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RunPipelineRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RunPipelineRequest)
	// pipeline
	switch x := m.Pipeline.(type) {
	case *RunPipelineRequest_PipelineId:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.PipelineId)))
		n += len(x.PipelineId)
	case *RunPipelineRequest_EphemeralPipeline:
		s := proto.Size(x.EphemeralPipeline)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A request to get a saved pipeline by id.
type GetPipelineRequest struct {
	// Caller must have READ access to the project in which this pipeline
	// is defined.
	PipelineId string `protobuf:"bytes,1,opt,name=pipeline_id,json=pipelineId" json:"pipeline_id,omitempty"`
}

func (m *GetPipelineRequest) Reset()                    { *m = GetPipelineRequest{} }
func (m *GetPipelineRequest) String() string            { return proto.CompactTextString(m) }
func (*GetPipelineRequest) ProtoMessage()               {}
func (*GetPipelineRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *GetPipelineRequest) GetPipelineId() string {
	if m != nil {
		return m.PipelineId
	}
	return ""
}

// A request to list pipelines in a given project. Pipelines can be
// filtered by name using `namePrefix`: all pipelines with names that
// begin with `namePrefix` will be returned. Uses standard pagination:
// `pageSize` indicates how many pipelines to return, and
// `pageToken` comes from a previous ListPipelinesResponse to
// indicate offset.
type ListPipelinesRequest struct {
	// Required. The name of the project to search for pipelines. Caller
	// must have READ access to this project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Pipelines with names that match this prefix should be
	// returned.  If unspecified, all pipelines in the project, up to
	// `pageSize`, will be returned.
	NamePrefix string `protobuf:"bytes,2,opt,name=name_prefix,json=namePrefix" json:"name_prefix,omitempty"`
	// Number of pipelines to return at once. Defaults to 256, and max
	// is 2048.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Token to use to indicate where to start getting results.
	// If unspecified, returns the first page of results.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListPipelinesRequest) Reset()                    { *m = ListPipelinesRequest{} }
func (m *ListPipelinesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListPipelinesRequest) ProtoMessage()               {}
func (*ListPipelinesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *ListPipelinesRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListPipelinesRequest) GetNamePrefix() string {
	if m != nil {
		return m.NamePrefix
	}
	return ""
}

func (m *ListPipelinesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListPipelinesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response of ListPipelines. Contains at most `pageSize`
// pipelines. If it contains `pageSize` pipelines, and more pipelines
// exist, then `nextPageToken` will be populated and should be
// used as the `pageToken` argument to a subsequent ListPipelines
// request.
type ListPipelinesResponse struct {
	// The matched pipelines.
	Pipelines []*Pipeline `protobuf:"bytes,1,rep,name=pipelines" json:"pipelines,omitempty"`
	// The token to use to get the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListPipelinesResponse) Reset()                    { *m = ListPipelinesResponse{} }
func (m *ListPipelinesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListPipelinesResponse) ProtoMessage()               {}
func (*ListPipelinesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *ListPipelinesResponse) GetPipelines() []*Pipeline {
	if m != nil {
		return m.Pipelines
	}
	return nil
}

func (m *ListPipelinesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request to delete a saved pipeline by ID.
type DeletePipelineRequest struct {
	// Caller must have WRITE access to the project in which this pipeline
	// is defined.
	PipelineId string `protobuf:"bytes,1,opt,name=pipeline_id,json=pipelineId" json:"pipeline_id,omitempty"`
}

func (m *DeletePipelineRequest) Reset()                    { *m = DeletePipelineRequest{} }
func (m *DeletePipelineRequest) String() string            { return proto.CompactTextString(m) }
func (*DeletePipelineRequest) ProtoMessage()               {}
func (*DeletePipelineRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *DeletePipelineRequest) GetPipelineId() string {
	if m != nil {
		return m.PipelineId
	}
	return ""
}

// Request to get controller configuation.  Should only be used
// by VMs created by the Pipelines Service and not by end users.
type GetControllerConfigRequest struct {
	// The operation to retrieve controller configuration for.
	OperationId     string `protobuf:"bytes,1,opt,name=operation_id,json=operationId" json:"operation_id,omitempty"`
	ValidationToken uint64 `protobuf:"varint,2,opt,name=validation_token,json=validationToken" json:"validation_token,omitempty"`
}

func (m *GetControllerConfigRequest) Reset()                    { *m = GetControllerConfigRequest{} }
func (m *GetControllerConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*GetControllerConfigRequest) ProtoMessage()               {}
func (*GetControllerConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *GetControllerConfigRequest) GetOperationId() string {
	if m != nil {
		return m.OperationId
	}
	return ""
}

func (m *GetControllerConfigRequest) GetValidationToken() uint64 {
	if m != nil {
		return m.ValidationToken
	}
	return 0
}

// Stores the information that the controller will fetch from the
// server in order to run. Should only be used by VMs created by the
// Pipelines Service and not by end users.
type ControllerConfig struct {
	Image       string                                      `protobuf:"bytes,1,opt,name=image" json:"image,omitempty"`
	Cmd         string                                      `protobuf:"bytes,2,opt,name=cmd" json:"cmd,omitempty"`
	GcsLogPath  string                                      `protobuf:"bytes,3,opt,name=gcs_log_path,json=gcsLogPath" json:"gcs_log_path,omitempty"`
	MachineType string                                      `protobuf:"bytes,4,opt,name=machine_type,json=machineType" json:"machine_type,omitempty"`
	Vars        map[string]string                           `protobuf:"bytes,5,rep,name=vars" json:"vars,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Disks       map[string]string                           `protobuf:"bytes,6,rep,name=disks" json:"disks,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	GcsSources  map[string]*ControllerConfig_RepeatedString `protobuf:"bytes,7,rep,name=gcs_sources,json=gcsSources" json:"gcs_sources,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	GcsSinks    map[string]*ControllerConfig_RepeatedString `protobuf:"bytes,8,rep,name=gcs_sinks,json=gcsSinks" json:"gcs_sinks,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ControllerConfig) Reset()                    { *m = ControllerConfig{} }
func (m *ControllerConfig) String() string            { return proto.CompactTextString(m) }
func (*ControllerConfig) ProtoMessage()               {}
func (*ControllerConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *ControllerConfig) GetImage() string {
	if m != nil {
		return m.Image
	}
	return ""
}

func (m *ControllerConfig) GetCmd() string {
	if m != nil {
		return m.Cmd
	}
	return ""
}

func (m *ControllerConfig) GetGcsLogPath() string {
	if m != nil {
		return m.GcsLogPath
	}
	return ""
}

func (m *ControllerConfig) GetMachineType() string {
	if m != nil {
		return m.MachineType
	}
	return ""
}

func (m *ControllerConfig) GetVars() map[string]string {
	if m != nil {
		return m.Vars
	}
	return nil
}

func (m *ControllerConfig) GetDisks() map[string]string {
	if m != nil {
		return m.Disks
	}
	return nil
}

func (m *ControllerConfig) GetGcsSources() map[string]*ControllerConfig_RepeatedString {
	if m != nil {
		return m.GcsSources
	}
	return nil
}

func (m *ControllerConfig) GetGcsSinks() map[string]*ControllerConfig_RepeatedString {
	if m != nil {
		return m.GcsSinks
	}
	return nil
}

type ControllerConfig_RepeatedString struct {
	Values []string `protobuf:"bytes,1,rep,name=values" json:"values,omitempty"`
}

func (m *ControllerConfig_RepeatedString) Reset()         { *m = ControllerConfig_RepeatedString{} }
func (m *ControllerConfig_RepeatedString) String() string { return proto.CompactTextString(m) }
func (*ControllerConfig_RepeatedString) ProtoMessage()    {}
func (*ControllerConfig_RepeatedString) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{11, 0}
}

func (m *ControllerConfig_RepeatedString) GetValues() []string {
	if m != nil {
		return m.Values
	}
	return nil
}

// Stores the list of events and times they occured for major events in job
// execution.
type TimestampEvent struct {
	// String indicating the type of event
	Description string `protobuf:"bytes,1,opt,name=description" json:"description,omitempty"`
	// The time this event occured.
	Timestamp *google_protobuf4.Timestamp `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp,omitempty"`
}

func (m *TimestampEvent) Reset()                    { *m = TimestampEvent{} }
func (m *TimestampEvent) String() string            { return proto.CompactTextString(m) }
func (*TimestampEvent) ProtoMessage()               {}
func (*TimestampEvent) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *TimestampEvent) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *TimestampEvent) GetTimestamp() *google_protobuf4.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

// Request to set operation status. Should only be used by VMs
// created by the Pipelines Service and not by end users.
type SetOperationStatusRequest struct {
	OperationId     string            `protobuf:"bytes,1,opt,name=operation_id,json=operationId" json:"operation_id,omitempty"`
	TimestampEvents []*TimestampEvent `protobuf:"bytes,2,rep,name=timestamp_events,json=timestampEvents" json:"timestamp_events,omitempty"`
	ErrorCode       google_rpc1.Code  `protobuf:"varint,3,opt,name=error_code,json=errorCode,enum=google.rpc.Code" json:"error_code,omitempty"`
	ErrorMessage    string            `protobuf:"bytes,4,opt,name=error_message,json=errorMessage" json:"error_message,omitempty"`
	ValidationToken uint64            `protobuf:"varint,5,opt,name=validation_token,json=validationToken" json:"validation_token,omitempty"`
}

func (m *SetOperationStatusRequest) Reset()                    { *m = SetOperationStatusRequest{} }
func (m *SetOperationStatusRequest) String() string            { return proto.CompactTextString(m) }
func (*SetOperationStatusRequest) ProtoMessage()               {}
func (*SetOperationStatusRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *SetOperationStatusRequest) GetOperationId() string {
	if m != nil {
		return m.OperationId
	}
	return ""
}

func (m *SetOperationStatusRequest) GetTimestampEvents() []*TimestampEvent {
	if m != nil {
		return m.TimestampEvents
	}
	return nil
}

func (m *SetOperationStatusRequest) GetErrorCode() google_rpc1.Code {
	if m != nil {
		return m.ErrorCode
	}
	return google_rpc1.Code_OK
}

func (m *SetOperationStatusRequest) GetErrorMessage() string {
	if m != nil {
		return m.ErrorMessage
	}
	return ""
}

func (m *SetOperationStatusRequest) GetValidationToken() uint64 {
	if m != nil {
		return m.ValidationToken
	}
	return 0
}

// A Google Cloud Service Account.
type ServiceAccount struct {
	// Email address of the service account. Defaults to `default`,
	// which uses the compute service account associated with the project.
	Email string `protobuf:"bytes,1,opt,name=email" json:"email,omitempty"`
	// List of scopes to be enabled for this service account on the VM.
	// The following scopes are automatically included:
	//
	// * https://www.googleapis.com/auth/compute
	// * https://www.googleapis.com/auth/devstorage.full_control
	// * https://www.googleapis.com/auth/genomics
	// * https://www.googleapis.com/auth/logging.write
	// * https://www.googleapis.com/auth/monitoring.write
	Scopes []string `protobuf:"bytes,2,rep,name=scopes" json:"scopes,omitempty"`
}

func (m *ServiceAccount) Reset()                    { *m = ServiceAccount{} }
func (m *ServiceAccount) String() string            { return proto.CompactTextString(m) }
func (*ServiceAccount) ProtoMessage()               {}
func (*ServiceAccount) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *ServiceAccount) GetEmail() string {
	if m != nil {
		return m.Email
	}
	return ""
}

func (m *ServiceAccount) GetScopes() []string {
	if m != nil {
		return m.Scopes
	}
	return nil
}

// The logging options for the pipeline run.
type LoggingOptions struct {
	// The location in Google Cloud Storage to which the pipeline logs
	// will be copied. Can be specified as a fully qualified directory
	// path, in which case logs will be output with a unique identifier
	// as the filename in that directory, or as a fully specified path,
	// which must end in `.log`, in which case that path will be
	// used, and the user must ensure that logs are not
	// overwritten. Stdout and stderr logs from the run are also
	// generated and output as `-stdout.log` and `-stderr.log`.
	GcsPath string `protobuf:"bytes,1,opt,name=gcs_path,json=gcsPath" json:"gcs_path,omitempty"`
}

func (m *LoggingOptions) Reset()                    { *m = LoggingOptions{} }
func (m *LoggingOptions) String() string            { return proto.CompactTextString(m) }
func (*LoggingOptions) ProtoMessage()               {}
func (*LoggingOptions) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *LoggingOptions) GetGcsPath() string {
	if m != nil {
		return m.GcsPath
	}
	return ""
}

// The system resources for the pipeline run.
type PipelineResources struct {
	// The minimum number of cores to use. Defaults to 1.
	MinimumCpuCores int32 `protobuf:"varint,1,opt,name=minimum_cpu_cores,json=minimumCpuCores" json:"minimum_cpu_cores,omitempty"`
	// Whether to use preemptible VMs. Defaults to `false`. In order to use this,
	// must be true for both create time and run time. Cannot be true at run time
	// if false at create time.
	Preemptible bool `protobuf:"varint,2,opt,name=preemptible" json:"preemptible,omitempty"`
	// The minimum amount of RAM to use. Defaults to 3.75 (GB)
	MinimumRamGb float64 `protobuf:"fixed64,3,opt,name=minimum_ram_gb,json=minimumRamGb" json:"minimum_ram_gb,omitempty"`
	// Disks to attach.
	Disks []*PipelineResources_Disk `protobuf:"bytes,4,rep,name=disks" json:"disks,omitempty"`
	// List of Google Compute Engine availability zones to which resource
	// creation will restricted. If empty, any zone may be chosen.
	Zones []string `protobuf:"bytes,5,rep,name=zones" json:"zones,omitempty"`
	// The size of the boot disk. Defaults to 10 (GB).
	BootDiskSizeGb int32 `protobuf:"varint,6,opt,name=boot_disk_size_gb,json=bootDiskSizeGb" json:"boot_disk_size_gb,omitempty"`
	// Whether to assign an external IP to the instance. This is an experimental
	// feature that may go away. Defaults to false.
	// Corresponds to `--no_address` flag for [gcloud compute instances create]
	// (https://cloud.google.com/sdk/gcloud/reference/compute/instances/create).
	// In order to use this, must be true for both create time and run time.
	// Cannot be true at run time if false at create time. If you need to ssh into
	// a private IP VM for debugging, you can ssh to a public VM and then ssh into
	// the private VM's Internal IP.  If noAddress is set, this pipeline run may
	// only load docker images from Google Container Registry and not Docker Hub.
	// ** Note: To use this option, your project must be in Google Access for
	// Private IPs Early Access Program.**
	NoAddress bool `protobuf:"varint,7,opt,name=no_address,json=noAddress" json:"no_address,omitempty"`
}

func (m *PipelineResources) Reset()                    { *m = PipelineResources{} }
func (m *PipelineResources) String() string            { return proto.CompactTextString(m) }
func (*PipelineResources) ProtoMessage()               {}
func (*PipelineResources) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *PipelineResources) GetMinimumCpuCores() int32 {
	if m != nil {
		return m.MinimumCpuCores
	}
	return 0
}

func (m *PipelineResources) GetPreemptible() bool {
	if m != nil {
		return m.Preemptible
	}
	return false
}

func (m *PipelineResources) GetMinimumRamGb() float64 {
	if m != nil {
		return m.MinimumRamGb
	}
	return 0
}

func (m *PipelineResources) GetDisks() []*PipelineResources_Disk {
	if m != nil {
		return m.Disks
	}
	return nil
}

func (m *PipelineResources) GetZones() []string {
	if m != nil {
		return m.Zones
	}
	return nil
}

func (m *PipelineResources) GetBootDiskSizeGb() int32 {
	if m != nil {
		return m.BootDiskSizeGb
	}
	return 0
}

func (m *PipelineResources) GetNoAddress() bool {
	if m != nil {
		return m.NoAddress
	}
	return false
}

// A Google Compute Engine disk resource specification.
type PipelineResources_Disk struct {
	// Required. The name of the disk that can be used in the pipeline
	// parameters. Must be 1 - 63 characters.
	// The name "boot" is reserved for system use.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Required. The type of the disk to create.
	Type PipelineResources_Disk_Type `protobuf:"varint,2,opt,name=type,enum=google.genomics.v1alpha2.PipelineResources_Disk_Type" json:"type,omitempty"`
	// The size of the disk. Defaults to 500 (GB).
	// This field is not applicable for local SSD.
	SizeGb int32 `protobuf:"varint,3,opt,name=size_gb,json=sizeGb" json:"size_gb,omitempty"`
	// The full or partial URL of the persistent disk to attach. See
	// https://cloud.google.com/compute/docs/reference/latest/instances#resource
	// and
	// https://cloud.google.com/compute/docs/disks/persistent-disks#snapshots
	// for more details.
	Source string `protobuf:"bytes,4,opt,name=source" json:"source,omitempty"`
	// Deprecated. Disks created by the Pipelines API will be deleted at the end
	// of the pipeline run, regardless of what this field is set to.
	AutoDelete bool `protobuf:"varint,6,opt,name=auto_delete,json=autoDelete" json:"auto_delete,omitempty"`
	// Required at create time and cannot be overridden at run time.
	// Specifies the path in the docker container where files on
	// this disk should be located. For example, if `mountPoint`
	// is `/mnt/disk`, and the parameter has `localPath`
	// `inputs/file.txt`, the docker container can access the data at
	// `/mnt/disk/inputs/file.txt`.
	MountPoint string `protobuf:"bytes,8,opt,name=mount_point,json=mountPoint" json:"mount_point,omitempty"`
}

func (m *PipelineResources_Disk) Reset()                    { *m = PipelineResources_Disk{} }
func (m *PipelineResources_Disk) String() string            { return proto.CompactTextString(m) }
func (*PipelineResources_Disk) ProtoMessage()               {}
func (*PipelineResources_Disk) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16, 0} }

func (m *PipelineResources_Disk) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PipelineResources_Disk) GetType() PipelineResources_Disk_Type {
	if m != nil {
		return m.Type
	}
	return PipelineResources_Disk_TYPE_UNSPECIFIED
}

func (m *PipelineResources_Disk) GetSizeGb() int32 {
	if m != nil {
		return m.SizeGb
	}
	return 0
}

func (m *PipelineResources_Disk) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

func (m *PipelineResources_Disk) GetAutoDelete() bool {
	if m != nil {
		return m.AutoDelete
	}
	return false
}

func (m *PipelineResources_Disk) GetMountPoint() string {
	if m != nil {
		return m.MountPoint
	}
	return ""
}

// Parameters facilitate setting and delivering data into the
// pipeline's execution environment. They are defined at create time,
// with optional defaults, and can be overridden at run time.
//
// If `localCopy` is unset, then the parameter specifies a string that
// is passed as-is into the pipeline, as the value of the environment
// variable with the given name.  A default value can be optionally
// specified at create time. The default can be overridden at run time
// using the inputs map. If no default is given, a value must be
// supplied at runtime.
//
// If `localCopy` is defined, then the parameter specifies a data
// source or sink, both in Google Cloud Storage and on the Docker container
// where the pipeline computation is run. The [service account associated with
// the Pipeline][google.genomics.v1alpha2.RunPipelineArgs.service_account] (by
// default the project's Compute Engine service account) must have access to the
// Google Cloud Storage paths.
//
// At run time, the Google Cloud Storage paths can be overridden if a default
// was provided at create time, or must be set otherwise. The pipeline runner
// should add a key/value pair to either the inputs or outputs map. The
// indicated data copies will be carried out before/after pipeline execution,
// just as if the corresponding arguments were provided to `gsutil cp`.
//
// For example: Given the following `PipelineParameter`, specified
// in the `inputParameters` list:
//
// ```
// {name: "input_file", localCopy: {path: "file.txt", disk: "pd1"}}
// ```
//
// where `disk` is defined in the `PipelineResources` object as:
//
// ```
// {name: "pd1", mountPoint: "/mnt/disk/"}
// ```
//
// We create a disk named `pd1`, mount it on the host VM, and map
// `/mnt/pd1` to `/mnt/disk` in the docker container.  At
// runtime, an entry for `input_file` would be required in the inputs
// map, such as:
//
// ```
//   inputs["input_file"] = "gs://my-bucket/bar.txt"
// ```
//
// This would generate the following gsutil call:
//
// ```
//   gsutil cp gs://my-bucket/bar.txt /mnt/pd1/file.txt
// ```
//
// The file `/mnt/pd1/file.txt` maps to `/mnt/disk/file.txt` in the
// Docker container. Acceptable paths are:
//
// <table>
//   <thead>
//     <tr><th>Google Cloud storage path</th><th>Local path</th></tr>
//   </thead>
//   <tbody>
//     <tr><td>file</td><td>file</td></tr>
//     <tr><td>glob</td><td>directory</td></tr>
//   </tbody>
// </table>
//
// For outputs, the direction of the copy is reversed:
//
// ```
//   gsutil cp /mnt/disk/file.txt gs://my-bucket/bar.txt
// ```
//
// Acceptable paths are:
//
// <table>
//   <thead>
//     <tr><th>Local path</th><th>Google Cloud Storage path</th></tr>
//   </thead>
//   <tbody>
//     <tr><td>file</td><td>file</td></tr>
//     <tr>
//       <td>file</td>
//       <td>directory - directory must already exist</td>
//     </tr>
//     <tr>
//       <td>glob</td>
//       <td>directory - directory will be created if it doesn't exist</td></tr>
//   </tbody>
// </table>
//
// One restriction due to docker limitations, is that for outputs that are found
// on the boot disk, the local path cannot be a glob and must be a file.
type PipelineParameter struct {
	// Required. Name of the parameter - the pipeline runner uses this string
	// as the key to the input and output maps in RunPipeline.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Human-readable description.
	Description string `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
	// The default value for this parameter. Can be overridden at runtime.
	// If `localCopy` is present, then this must be a Google Cloud Storage path
	// beginning with `gs://`.
	DefaultValue string `protobuf:"bytes,5,opt,name=default_value,json=defaultValue" json:"default_value,omitempty"`
	// If present, this parameter is marked for copying to and from the VM.
	// `LocalCopy` indicates where on the VM the file should be. The value
	// given to this parameter (either at runtime or using `defaultValue`)
	// must be the remote path where the file should be.
	LocalCopy *PipelineParameter_LocalCopy `protobuf:"bytes,6,opt,name=local_copy,json=localCopy" json:"local_copy,omitempty"`
}

func (m *PipelineParameter) Reset()                    { *m = PipelineParameter{} }
func (m *PipelineParameter) String() string            { return proto.CompactTextString(m) }
func (*PipelineParameter) ProtoMessage()               {}
func (*PipelineParameter) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *PipelineParameter) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PipelineParameter) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *PipelineParameter) GetDefaultValue() string {
	if m != nil {
		return m.DefaultValue
	}
	return ""
}

func (m *PipelineParameter) GetLocalCopy() *PipelineParameter_LocalCopy {
	if m != nil {
		return m.LocalCopy
	}
	return nil
}

// LocalCopy defines how a remote file should be copied to and from the VM.
type PipelineParameter_LocalCopy struct {
	// Required. The path within the user's docker container where
	// this input should be localized to and from, relative to the specified
	// disk's mount point. For example: file.txt,
	Path string `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	// Required. The name of the disk where this parameter is
	// located. Can be the name of one of the disks specified in the
	// Resources field, or "boot", which represents the Docker
	// instance's boot disk and has a mount point of `/`.
	Disk string `protobuf:"bytes,2,opt,name=disk" json:"disk,omitempty"`
}

func (m *PipelineParameter_LocalCopy) Reset()                    { *m = PipelineParameter_LocalCopy{} }
func (m *PipelineParameter_LocalCopy) String() string            { return proto.CompactTextString(m) }
func (*PipelineParameter_LocalCopy) ProtoMessage()               {}
func (*PipelineParameter_LocalCopy) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17, 0} }

func (m *PipelineParameter_LocalCopy) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *PipelineParameter_LocalCopy) GetDisk() string {
	if m != nil {
		return m.Disk
	}
	return ""
}

// The Docker execuctor specification.
type DockerExecutor struct {
	// Required. Image name from either Docker Hub or Google Container Registry.
	// Users that run pipelines must have READ access to the image.
	ImageName string `protobuf:"bytes,1,opt,name=image_name,json=imageName" json:"image_name,omitempty"`
	// Required. The command or newline delimited script to run. The command
	// string will be executed within a bash shell.
	//
	// If the command exits with a non-zero exit code, output parameter
	// de-localization will be skipped and the pipeline operation's
	// [`error`][google.longrunning.Operation.error] field will be populated.
	//
	// Maximum command string length is 16384.
	Cmd string `protobuf:"bytes,2,opt,name=cmd" json:"cmd,omitempty"`
}

func (m *DockerExecutor) Reset()                    { *m = DockerExecutor{} }
func (m *DockerExecutor) String() string            { return proto.CompactTextString(m) }
func (*DockerExecutor) ProtoMessage()               {}
func (*DockerExecutor) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *DockerExecutor) GetImageName() string {
	if m != nil {
		return m.ImageName
	}
	return ""
}

func (m *DockerExecutor) GetCmd() string {
	if m != nil {
		return m.Cmd
	}
	return ""
}

func init() {
	proto.RegisterType((*ComputeEngine)(nil), "google.genomics.v1alpha2.ComputeEngine")
	proto.RegisterType((*RuntimeMetadata)(nil), "google.genomics.v1alpha2.RuntimeMetadata")
	proto.RegisterType((*Pipeline)(nil), "google.genomics.v1alpha2.Pipeline")
	proto.RegisterType((*CreatePipelineRequest)(nil), "google.genomics.v1alpha2.CreatePipelineRequest")
	proto.RegisterType((*RunPipelineArgs)(nil), "google.genomics.v1alpha2.RunPipelineArgs")
	proto.RegisterType((*RunPipelineRequest)(nil), "google.genomics.v1alpha2.RunPipelineRequest")
	proto.RegisterType((*GetPipelineRequest)(nil), "google.genomics.v1alpha2.GetPipelineRequest")
	proto.RegisterType((*ListPipelinesRequest)(nil), "google.genomics.v1alpha2.ListPipelinesRequest")
	proto.RegisterType((*ListPipelinesResponse)(nil), "google.genomics.v1alpha2.ListPipelinesResponse")
	proto.RegisterType((*DeletePipelineRequest)(nil), "google.genomics.v1alpha2.DeletePipelineRequest")
	proto.RegisterType((*GetControllerConfigRequest)(nil), "google.genomics.v1alpha2.GetControllerConfigRequest")
	proto.RegisterType((*ControllerConfig)(nil), "google.genomics.v1alpha2.ControllerConfig")
	proto.RegisterType((*ControllerConfig_RepeatedString)(nil), "google.genomics.v1alpha2.ControllerConfig.RepeatedString")
	proto.RegisterType((*TimestampEvent)(nil), "google.genomics.v1alpha2.TimestampEvent")
	proto.RegisterType((*SetOperationStatusRequest)(nil), "google.genomics.v1alpha2.SetOperationStatusRequest")
	proto.RegisterType((*ServiceAccount)(nil), "google.genomics.v1alpha2.ServiceAccount")
	proto.RegisterType((*LoggingOptions)(nil), "google.genomics.v1alpha2.LoggingOptions")
	proto.RegisterType((*PipelineResources)(nil), "google.genomics.v1alpha2.PipelineResources")
	proto.RegisterType((*PipelineResources_Disk)(nil), "google.genomics.v1alpha2.PipelineResources.Disk")
	proto.RegisterType((*PipelineParameter)(nil), "google.genomics.v1alpha2.PipelineParameter")
	proto.RegisterType((*PipelineParameter_LocalCopy)(nil), "google.genomics.v1alpha2.PipelineParameter.LocalCopy")
	proto.RegisterType((*DockerExecutor)(nil), "google.genomics.v1alpha2.DockerExecutor")
	proto.RegisterEnum("google.genomics.v1alpha2.PipelineResources_Disk_Type", PipelineResources_Disk_Type_name, PipelineResources_Disk_Type_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for PipelinesV1Alpha2 service

type PipelinesV1Alpha2Client interface {
	// Creates a pipeline that can be run later. Create takes a Pipeline that
	// has all fields other than `pipelineId` populated, and then returns
	// the same pipeline with `pipelineId` populated. This id can be used
	// to run the pipeline.
	//
	// Caller must have WRITE permission to the project.
	CreatePipeline(ctx context.Context, in *CreatePipelineRequest, opts ...grpc.CallOption) (*Pipeline, error)
	// Runs a pipeline. If `pipelineId` is specified in the request, then
	// run a saved pipeline. If `ephemeralPipeline` is specified, then run
	// that pipeline once without saving a copy.
	//
	// The caller must have READ permission to the project where the pipeline
	// is stored and WRITE permission to the project where the pipeline will be
	// run, as VMs will be created and storage will be used.
	RunPipeline(ctx context.Context, in *RunPipelineRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Retrieves a pipeline based on ID.
	//
	// Caller must have READ permission to the project.
	GetPipeline(ctx context.Context, in *GetPipelineRequest, opts ...grpc.CallOption) (*Pipeline, error)
	// Lists pipelines.
	//
	// Caller must have READ permission to the project.
	ListPipelines(ctx context.Context, in *ListPipelinesRequest, opts ...grpc.CallOption) (*ListPipelinesResponse, error)
	// Deletes a pipeline based on ID.
	//
	// Caller must have WRITE permission to the project.
	DeletePipeline(ctx context.Context, in *DeletePipelineRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error)
	// Gets controller configuration information. Should only be called
	// by VMs created by the Pipelines Service and not by end users.
	GetControllerConfig(ctx context.Context, in *GetControllerConfigRequest, opts ...grpc.CallOption) (*ControllerConfig, error)
	// Sets status of a given operation. Any new timestamps (as determined by
	// description) are appended to TimestampEvents. Should only be called by VMs
	// created by the Pipelines Service and not by end users.
	SetOperationStatus(ctx context.Context, in *SetOperationStatusRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error)
}

type pipelinesV1Alpha2Client struct {
	cc *grpc.ClientConn
}

func NewPipelinesV1Alpha2Client(cc *grpc.ClientConn) PipelinesV1Alpha2Client {
	return &pipelinesV1Alpha2Client{cc}
}

func (c *pipelinesV1Alpha2Client) CreatePipeline(ctx context.Context, in *CreatePipelineRequest, opts ...grpc.CallOption) (*Pipeline, error) {
	out := new(Pipeline)
	err := grpc.Invoke(ctx, "/google.genomics.v1alpha2.PipelinesV1Alpha2/CreatePipeline", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelinesV1Alpha2Client) RunPipeline(ctx context.Context, in *RunPipelineRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.genomics.v1alpha2.PipelinesV1Alpha2/RunPipeline", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelinesV1Alpha2Client) GetPipeline(ctx context.Context, in *GetPipelineRequest, opts ...grpc.CallOption) (*Pipeline, error) {
	out := new(Pipeline)
	err := grpc.Invoke(ctx, "/google.genomics.v1alpha2.PipelinesV1Alpha2/GetPipeline", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelinesV1Alpha2Client) ListPipelines(ctx context.Context, in *ListPipelinesRequest, opts ...grpc.CallOption) (*ListPipelinesResponse, error) {
	out := new(ListPipelinesResponse)
	err := grpc.Invoke(ctx, "/google.genomics.v1alpha2.PipelinesV1Alpha2/ListPipelines", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelinesV1Alpha2Client) DeletePipeline(ctx context.Context, in *DeletePipelineRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error) {
	out := new(google_protobuf2.Empty)
	err := grpc.Invoke(ctx, "/google.genomics.v1alpha2.PipelinesV1Alpha2/DeletePipeline", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelinesV1Alpha2Client) GetControllerConfig(ctx context.Context, in *GetControllerConfigRequest, opts ...grpc.CallOption) (*ControllerConfig, error) {
	out := new(ControllerConfig)
	err := grpc.Invoke(ctx, "/google.genomics.v1alpha2.PipelinesV1Alpha2/GetControllerConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelinesV1Alpha2Client) SetOperationStatus(ctx context.Context, in *SetOperationStatusRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error) {
	out := new(google_protobuf2.Empty)
	err := grpc.Invoke(ctx, "/google.genomics.v1alpha2.PipelinesV1Alpha2/SetOperationStatus", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for PipelinesV1Alpha2 service

type PipelinesV1Alpha2Server interface {
	// Creates a pipeline that can be run later. Create takes a Pipeline that
	// has all fields other than `pipelineId` populated, and then returns
	// the same pipeline with `pipelineId` populated. This id can be used
	// to run the pipeline.
	//
	// Caller must have WRITE permission to the project.
	CreatePipeline(context.Context, *CreatePipelineRequest) (*Pipeline, error)
	// Runs a pipeline. If `pipelineId` is specified in the request, then
	// run a saved pipeline. If `ephemeralPipeline` is specified, then run
	// that pipeline once without saving a copy.
	//
	// The caller must have READ permission to the project where the pipeline
	// is stored and WRITE permission to the project where the pipeline will be
	// run, as VMs will be created and storage will be used.
	RunPipeline(context.Context, *RunPipelineRequest) (*google_longrunning.Operation, error)
	// Retrieves a pipeline based on ID.
	//
	// Caller must have READ permission to the project.
	GetPipeline(context.Context, *GetPipelineRequest) (*Pipeline, error)
	// Lists pipelines.
	//
	// Caller must have READ permission to the project.
	ListPipelines(context.Context, *ListPipelinesRequest) (*ListPipelinesResponse, error)
	// Deletes a pipeline based on ID.
	//
	// Caller must have WRITE permission to the project.
	DeletePipeline(context.Context, *DeletePipelineRequest) (*google_protobuf2.Empty, error)
	// Gets controller configuration information. Should only be called
	// by VMs created by the Pipelines Service and not by end users.
	GetControllerConfig(context.Context, *GetControllerConfigRequest) (*ControllerConfig, error)
	// Sets status of a given operation. Any new timestamps (as determined by
	// description) are appended to TimestampEvents. Should only be called by VMs
	// created by the Pipelines Service and not by end users.
	SetOperationStatus(context.Context, *SetOperationStatusRequest) (*google_protobuf2.Empty, error)
}

func RegisterPipelinesV1Alpha2Server(s *grpc.Server, srv PipelinesV1Alpha2Server) {
	s.RegisterService(&_PipelinesV1Alpha2_serviceDesc, srv)
}

func _PipelinesV1Alpha2_CreatePipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelinesV1Alpha2Server).CreatePipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1alpha2.PipelinesV1Alpha2/CreatePipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelinesV1Alpha2Server).CreatePipeline(ctx, req.(*CreatePipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelinesV1Alpha2_RunPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelinesV1Alpha2Server).RunPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1alpha2.PipelinesV1Alpha2/RunPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelinesV1Alpha2Server).RunPipeline(ctx, req.(*RunPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelinesV1Alpha2_GetPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelinesV1Alpha2Server).GetPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1alpha2.PipelinesV1Alpha2/GetPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelinesV1Alpha2Server).GetPipeline(ctx, req.(*GetPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelinesV1Alpha2_ListPipelines_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPipelinesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelinesV1Alpha2Server).ListPipelines(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1alpha2.PipelinesV1Alpha2/ListPipelines",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelinesV1Alpha2Server).ListPipelines(ctx, req.(*ListPipelinesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelinesV1Alpha2_DeletePipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelinesV1Alpha2Server).DeletePipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1alpha2.PipelinesV1Alpha2/DeletePipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelinesV1Alpha2Server).DeletePipeline(ctx, req.(*DeletePipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelinesV1Alpha2_GetControllerConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetControllerConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelinesV1Alpha2Server).GetControllerConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1alpha2.PipelinesV1Alpha2/GetControllerConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelinesV1Alpha2Server).GetControllerConfig(ctx, req.(*GetControllerConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelinesV1Alpha2_SetOperationStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetOperationStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelinesV1Alpha2Server).SetOperationStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1alpha2.PipelinesV1Alpha2/SetOperationStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelinesV1Alpha2Server).SetOperationStatus(ctx, req.(*SetOperationStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _PipelinesV1Alpha2_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.genomics.v1alpha2.PipelinesV1Alpha2",
	HandlerType: (*PipelinesV1Alpha2Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreatePipeline",
			Handler:    _PipelinesV1Alpha2_CreatePipeline_Handler,
		},
		{
			MethodName: "RunPipeline",
			Handler:    _PipelinesV1Alpha2_RunPipeline_Handler,
		},
		{
			MethodName: "GetPipeline",
			Handler:    _PipelinesV1Alpha2_GetPipeline_Handler,
		},
		{
			MethodName: "ListPipelines",
			Handler:    _PipelinesV1Alpha2_ListPipelines_Handler,
		},
		{
			MethodName: "DeletePipeline",
			Handler:    _PipelinesV1Alpha2_DeletePipeline_Handler,
		},
		{
			MethodName: "GetControllerConfig",
			Handler:    _PipelinesV1Alpha2_GetControllerConfig_Handler,
		},
		{
			MethodName: "SetOperationStatus",
			Handler:    _PipelinesV1Alpha2_SetOperationStatus_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/genomics/v1alpha2/pipelines.proto",
}

func init() { proto.RegisterFile("google/genomics/v1alpha2/pipelines.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 2065 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0x4d, 0x73, 0xdb, 0xc8,
	0xd1, 0x36, 0x28, 0x4a, 0x22, 0x9a, 0x12, 0x45, 0xcf, 0xda, 0x6b, 0x9a, 0xf6, 0xbe, 0xb6, 0xe1,
	0x37, 0xbb, 0xb2, 0x9c, 0x22, 0x63, 0x79, 0x9d, 0xc8, 0x4a, 0xd5, 0xd6, 0x4a, 0x14, 0x2d, 0xb1,
	0x22, 0x4b, 0x0c, 0xa8, 0x55, 0xbe, 0x0e, 0xa8, 0x11, 0x38, 0x82, 0xb0, 0x02, 0x30, 0x08, 0x06,
	0x50, 0x59, 0x4e, 0x25, 0x55, 0x49, 0xe5, 0x90, 0xda, 0x4a, 0x2e, 0xc9, 0xfe, 0x88, 0x5c, 0x72,
	0xcc, 0xcf, 0xc8, 0x29, 0xa7, 0x9c, 0x72, 0xc9, 0x21, 0x3f, 0x21, 0xb9, 0xa5, 0x66, 0x06, 0x03,
	0x82, 0x1f, 0x92, 0xc8, 0xaa, 0x54, 0x6e, 0x33, 0x3d, 0xdd, 0x0f, 0x9e, 0xe9, 0xe9, 0xe9, 0xe9,
	0x06, 0xac, 0x3a, 0x94, 0x3a, 0x1e, 0x69, 0x3a, 0x24, 0xa0, 0xbe, 0x6b, 0xb3, 0xe6, 0xc5, 0x0b,
	0xec, 0x85, 0x67, 0x78, 0xbd, 0x19, 0xba, 0x21, 0xf1, 0xdc, 0x80, 0xb0, 0x46, 0x18, 0xd1, 0x98,
	0xa2, 0x9a, 0xd4, 0x6c, 0x28, 0xcd, 0x86, 0xd2, 0xac, 0x3f, 0x4c, 0x31, 0x70, 0xe8, 0x36, 0x71,
	0x10, 0xd0, 0x18, 0xc7, 0x2e, 0x0d, 0x52, 0xbb, 0xfa, 0xd3, 0x74, 0xd5, 0xa3, 0x81, 0x13, 0x25,
	0x41, 0xe0, 0x06, 0x4e, 0x93, 0x86, 0x24, 0x1a, 0x52, 0xfa, 0xbf, 0x54, 0x49, 0xcc, 0x4e, 0x92,
	0xd3, 0x66, 0x3f, 0x91, 0x0a, 0xe9, 0xfa, 0x83, 0xd1, 0x75, 0xe2, 0x87, 0xf1, 0x65, 0xba, 0xf8,
	0x68, 0x74, 0x31, 0x76, 0x7d, 0xc2, 0x62, 0xec, 0x87, 0xa9, 0xc2, 0xdd, 0x54, 0x21, 0x0a, 0xed,
	0xa6, 0x4d, 0xfb, 0x44, 0x8a, 0x8d, 0xaf, 0x34, 0x58, 0x6e, 0x51, 0x3f, 0x4c, 0x62, 0xd2, 0x0e,
	0x1c, 0x37, 0x20, 0xe8, 0x29, 0x2c, 0xbb, 0x01, 0x8b, 0x71, 0x60, 0x13, 0x2b, 0xc0, 0x3e, 0xa9,
	0x69, 0x8f, 0xb5, 0x55, 0xdd, 0x5c, 0x52, 0xc2, 0x03, 0xec, 0x13, 0x84, 0xa0, 0xf8, 0x9e, 0x06,
	0xa4, 0x56, 0x10, 0x6b, 0x62, 0x8c, 0x9e, 0xc0, 0x92, 0x8f, 0xed, 0x33, 0x37, 0x20, 0x56, 0x7c,
	0x19, 0x92, 0xda, 0x9c, 0x58, 0x2b, 0xa7, 0xb2, 0xa3, 0xcb, 0x90, 0xa0, 0x8f, 0x00, 0xfa, 0x2e,
	0x3b, 0x17, 0xb8, 0xac, 0x56, 0x7c, 0x3c, 0xb7, 0xaa, 0x9b, 0x3a, 0x97, 0x70, 0x50, 0x66, 0x60,
	0x58, 0x31, 0x93, 0x80, 0x33, 0x7f, 0x4b, 0x62, 0xdc, 0xc7, 0x31, 0x46, 0x07, 0x50, 0xb1, 0x25,
	0x3d, 0x8b, 0x08, 0x7e, 0x82, 0x4e, 0x79, 0xfd, 0x93, 0xc6, 0x55, 0x47, 0xd1, 0x18, 0xda, 0x8e,
	0xb9, 0x6c, 0xe7, 0xa7, 0xc6, 0x5f, 0xe6, 0xa0, 0xd4, 0x4d, 0x4f, 0x95, 0xd3, 0x09, 0x23, 0xfa,
	0x25, 0xb1, 0x63, 0xcb, 0xed, 0xa7, 0xfb, 0xd4, 0x53, 0x49, 0xa7, 0xcf, 0x37, 0x29, 0x1c, 0x90,
	0x6e, 0x92, 0x8f, 0xd1, 0x63, 0x28, 0xf7, 0x09, 0xb3, 0x23, 0x37, 0xe4, 0x27, 0xa3, 0xf6, 0x98,
	0x13, 0xa1, 0x63, 0xa8, 0xba, 0x41, 0x98, 0xc4, 0x56, 0x88, 0x23, 0xec, 0x93, 0x98, 0x44, 0xac,
	0x56, 0x7a, 0x3c, 0xb7, 0x5a, 0x5e, 0x7f, 0x7e, 0x35, 0x67, 0x45, 0xa9, 0xab, 0x6c, 0xcc, 0x15,
	0x01, 0x92, 0xcd, 0x19, 0xfa, 0x21, 0xdc, 0xa6, 0x49, 0x3c, 0x02, 0xac, 0xcf, 0x0e, 0x5c, 0x95,
	0x28, 0x39, 0xe4, 0x6d, 0x58, 0xe8, 0x53, 0xfb, 0x9c, 0x44, 0xb5, 0x79, 0xe1, 0xdb, 0xd5, 0xab,
	0xe1, 0x76, 0x84, 0x5e, 0xfb, 0x1d, 0xb1, 0x93, 0x98, 0x46, 0x7b, 0xb7, 0xcc, 0xd4, 0x12, 0x75,
	0x40, 0x8f, 0x08, 0xa3, 0x49, 0x64, 0x13, 0x56, 0x5b, 0x10, 0x30, 0x53, 0xb0, 0x32, 0x95, 0x89,
	0x39, 0xb0, 0x46, 0x8f, 0xa0, 0xac, 0xee, 0x1d, 0x3f, 0x96, 0x45, 0xe1, 0x62, 0x50, 0xa2, 0x4e,
	0x7f, 0x1b, 0xa0, 0x44, 0x52, 0x06, 0xc6, 0x0f, 0xe0, 0x6e, 0x2b, 0x22, 0x38, 0x26, 0x03, 0xc8,
	0x9f, 0x26, 0x84, 0xc5, 0xe8, 0x33, 0x28, 0x29, 0x93, 0x34, 0x64, 0x8c, 0x29, 0xf8, 0x64, 0x36,
	0xc6, 0x9f, 0x17, 0x44, 0x30, 0xaa, 0x95, 0xad, 0xc8, 0x61, 0x37, 0xc5, 0xcb, 0x5b, 0x58, 0x10,
	0x87, 0xc6, 0x6a, 0x05, 0x71, 0x2c, 0xaf, 0xae, 0xfe, 0xe0, 0x08, 0x72, 0xa3, 0x23, 0xec, 0xda,
	0x41, 0x1c, 0x5d, 0x9a, 0x29, 0x08, 0xea, 0xc2, 0xa2, 0x3c, 0x2a, 0x56, 0x9b, 0x13, 0x78, 0xdf,
	0x9e, 0x1e, 0xef, 0x50, 0x1a, 0x4a, 0x40, 0x05, 0x83, 0xbe, 0x0f, 0x2b, 0x8c, 0x44, 0x17, 0xae,
	0x4d, 0x2c, 0x6c, 0xdb, 0x34, 0x09, 0xe2, 0x5a, 0xf1, 0xa6, 0x13, 0xef, 0x49, 0x83, 0x2d, 0xa9,
	0x6f, 0x56, 0xd8, 0xd0, 0x1c, 0x3d, 0x00, 0xdd, 0xf6, 0x5c, 0x12, 0x08, 0x8f, 0xcc, 0x0b, 0x8f,
	0x94, 0xa4, 0xa0, 0xd3, 0xff, 0x6f, 0x06, 0xc5, 0x36, 0x2c, 0x7a, 0xd4, 0x71, 0xdc, 0xc0, 0x11,
	0x01, 0x71, 0x2d, 0xe5, 0x7d, 0xa9, 0x78, 0x28, 0xee, 0x23, 0x33, 0x95, 0x21, 0x3a, 0x81, 0x27,
	0xe7, 0x84, 0x84, 0xd6, 0x85, 0x6f, 0x61, 0xcf, 0xbd, 0x20, 0x16, 0x0d, 0xac, 0x53, 0xec, 0x7a,
	0x49, 0x44, 0x2c, 0x95, 0x6b, 0x6b, 0x25, 0x81, 0x7e, 0x5f, 0xa1, 0xab, 0x7c, 0xda, 0xd8, 0x49,
	0x15, 0xcc, 0x87, 0x1c, 0xe3, 0xd8, 0xdf, 0xe2, 0x08, 0x87, 0xc1, 0x1b, 0x69, 0xaf, 0x56, 0x79,
	0x0c, 0x78, 0xf8, 0x84, 0x78, 0xea, 0x6a, 0xce, 0x10, 0x03, 0xfb, 0xc2, 0x2e, 0x8d, 0x01, 0x09,
	0x52, 0x7f, 0x0d, 0xe5, 0x5c, 0x68, 0xa0, 0x2a, 0xcc, 0x9d, 0x93, 0xcb, 0x34, 0xf2, 0xf8, 0x10,
	0xdd, 0x81, 0xf9, 0x0b, 0xec, 0x25, 0x2a, 0x49, 0xc9, 0xc9, 0x66, 0x61, 0x43, 0xab, 0x6f, 0xc2,
	0x52, 0x3e, 0x0a, 0x66, 0xb2, 0x7d, 0x0d, 0xe5, 0x1c, 0x9b, 0x59, 0x4c, 0x8d, 0x7f, 0x6a, 0x80,
	0x72, 0x3b, 0x53, 0xd7, 0xf1, 0xc9, 0xf0, 0xa5, 0x16, 0x50, 0x7b, 0xb7, 0xf2, 0xd7, 0x1a, 0xf5,
	0x00, 0x91, 0xf0, 0x8c, 0xf8, 0x24, 0xc2, 0x9e, 0x95, 0xdd, 0xdd, 0xc2, 0xb4, 0x77, 0x77, 0xef,
	0x96, 0x79, 0x3b, 0xb3, 0xcf, 0x52, 0xfc, 0x01, 0x2c, 0x67, 0xdf, 0xc5, 0x91, 0xc3, 0x44, 0xc6,
	0x2e, 0xaf, 0x3f, 0x9b, 0xfa, 0x58, 0xcc, 0xa5, 0x30, 0x37, 0xe3, 0xb9, 0x27, 0x4b, 0x11, 0xaf,
	0x00, 0xed, 0x92, 0x78, 0x74, 0xa7, 0x8f, 0x26, 0xec, 0x34, 0xbf, 0x4f, 0xe3, 0xf7, 0x1a, 0xdc,
	0xd9, 0x77, 0x59, 0x66, 0xc8, 0x94, 0xe5, 0x0d, 0xe9, 0xe5, 0x11, 0x94, 0xf9, 0x13, 0x64, 0x85,
	0x11, 0x39, 0x75, 0xdf, 0xa5, 0x9e, 0x07, 0x2e, 0xea, 0x0a, 0x09, 0xbf, 0x8b, 0x21, 0x76, 0x88,
	0xc5, 0xdc, 0xf7, 0xf2, 0xf5, 0x9d, 0x37, 0x4b, 0x5c, 0xd0, 0x73, 0xdf, 0xcb, 0xb7, 0x8e, 0x2f,
	0xc6, 0xf4, 0x9c, 0x04, 0xe2, 0xda, 0x73, 0x70, 0xec, 0x90, 0x23, 0x2e, 0x30, 0x7e, 0xa9, 0xc1,
	0xdd, 0x11, 0x52, 0x2c, 0xa4, 0x01, 0x23, 0xe8, 0x73, 0xd0, 0xb3, 0x32, 0xa8, 0xa6, 0x89, 0xa0,
	0x9e, 0x26, 0x93, 0x0e, 0x8c, 0xd0, 0xc7, 0xb0, 0x12, 0x90, 0x77, 0xfc, 0xdd, 0xca, 0xbe, 0x2f,
	0xc9, 0x2f, 0x73, 0x71, 0x37, 0xe3, 0xb0, 0x01, 0x77, 0x77, 0x88, 0x47, 0xc6, 0x73, 0xf9, 0x8d,
	0x2e, 0xfd, 0x12, 0xea, 0xbb, 0x24, 0x6e, 0xd1, 0x20, 0x8e, 0xa8, 0xe7, 0x91, 0xa8, 0x45, 0x83,
	0x53, 0xd7, 0x19, 0xc4, 0xde, 0x52, 0x56, 0x6c, 0x0d, 0xec, 0xcb, 0x99, 0xac, 0xd3, 0x47, 0xcf,
	0xa0, 0x7a, 0x81, 0x3d, 0xb7, 0x2f, 0x75, 0x06, 0x1c, 0x8b, 0xe6, 0xca, 0x40, 0x2e, 0x59, 0xfe,
	0x6d, 0x01, 0xaa, 0xa3, 0x5f, 0xe2, 0xf7, 0xc1, 0xf5, 0xb1, 0xa3, 0x8a, 0x25, 0x39, 0xe1, 0xf7,
	0xc6, 0xf6, 0xfb, 0xe9, 0x66, 0xf9, 0x10, 0x3d, 0x86, 0x25, 0xc7, 0x66, 0x96, 0x47, 0x1d, 0x2b,
	0xc4, 0xf1, 0x59, 0x5a, 0x3f, 0x80, 0x63, 0xb3, 0x7d, 0xea, 0x74, 0x71, 0x7c, 0x36, 0x56, 0x45,
	0x15, 0xc7, 0xab, 0xa8, 0x3d, 0x28, 0x5e, 0xe0, 0x88, 0xd5, 0xe6, 0xc5, 0x61, 0x7c, 0x7a, 0x5d,
	0x25, 0x34, 0x4c, 0xb3, 0x71, 0x8c, 0xa3, 0x34, 0xc1, 0x08, 0x04, 0xf4, 0x3d, 0x98, 0xe7, 0xd5,
	0x17, 0x4f, 0xce, 0x37, 0x24, 0xab, 0x31, 0xa8, 0x1d, 0x6e, 0x27, 0xb1, 0x24, 0x06, 0xfa, 0x09,
	0x94, 0xf9, 0xde, 0x54, 0xbe, 0x5f, 0x14, 0x90, 0x9b, 0x33, 0x40, 0xee, 0xda, 0xac, 0x27, 0x8d,
	0x25, 0x2e, 0x77, 0x4b, 0x2a, 0x40, 0x5f, 0x80, 0x2e, 0xc0, 0xdd, 0xe0, 0x5c, 0x95, 0x53, 0x1b,
	0x33, 0x42, 0x73, 0x53, 0x09, 0x5c, 0x72, 0xd2, 0x69, 0x7d, 0x15, 0x2a, 0x26, 0x09, 0x79, 0xfd,
	0xd0, 0xef, 0xc5, 0x11, 0x7f, 0x24, 0x3e, 0x84, 0x05, 0x91, 0xcc, 0x64, 0xac, 0xeb, 0x66, 0x3a,
	0xab, 0x7f, 0x07, 0xf4, 0xcc, 0x7b, 0x33, 0xe5, 0xd2, 0x0d, 0x80, 0x81, 0xaf, 0x66, 0xb2, 0x7c,
	0x07, 0x2b, 0x23, 0x2e, 0x99, 0x60, 0x7e, 0x98, 0x37, 0x2f, 0xaf, 0xbf, 0x9e, 0xc1, 0x29, 0xc3,
	0x3b, 0xcf, 0x7f, 0xf9, 0x02, 0x96, 0x87, 0x3c, 0xf6, 0x3f, 0xfa, 0xae, 0xe1, 0x41, 0xe5, 0x48,
	0xf5, 0x2d, 0xed, 0x0b, 0x12, 0xc4, 0xa3, 0xf5, 0xb6, 0x36, 0x5e, 0x6f, 0x6f, 0x80, 0x9e, 0xf5,
	0x3a, 0x29, 0x99, 0xfa, 0xd8, 0xeb, 0x9d, 0xa1, 0x9a, 0x03, 0x65, 0xe3, 0xeb, 0x02, 0xdc, 0xef,
	0x91, 0xf8, 0x50, 0xe5, 0x81, 0x5e, 0x8c, 0xe3, 0x84, 0xcd, 0x90, 0x35, 0x7a, 0x50, 0xcd, 0xd0,
	0x2c, 0xc2, 0xf9, 0xaa, 0xd2, 0xef, 0x9a, 0xea, 0x64, 0x78, 0x83, 0xe6, 0x4a, 0x3c, 0x34, 0x67,
	0xa8, 0x09, 0x40, 0xa2, 0x88, 0x46, 0x16, 0xef, 0xd2, 0x44, 0x82, 0xa8, 0xac, 0x57, 0x15, 0x5c,
	0x14, 0xda, 0x8d, 0x16, 0xed, 0x13, 0x53, 0x17, 0x3a, 0x7c, 0xc8, 0x1b, 0x36, 0x69, 0xe0, 0x13,
	0xc6, 0x78, 0x0e, 0x92, 0x29, 0x63, 0x49, 0x08, 0xdf, 0x4a, 0xd9, 0xc4, 0x04, 0x37, 0x3f, 0x39,
	0xc1, 0x7d, 0x06, 0x95, 0xe1, 0xa2, 0x8f, 0x87, 0x28, 0xf1, 0xb1, 0xeb, 0xa9, 0xec, 0x26, 0x26,
	0xfc, 0xa6, 0x30, 0x9b, 0x86, 0x44, 0xee, 0x59, 0x37, 0xd3, 0x99, 0xf1, 0x1c, 0x2a, 0xc3, 0x15,
	0x18, 0xba, 0x0f, 0xfc, 0xc6, 0xc9, 0x8c, 0x27, 0x21, 0x16, 0x1d, 0x9b, 0xf1, 0x74, 0x67, 0xfc,
	0xbd, 0x08, 0xb7, 0xc7, 0x0a, 0x3f, 0xb4, 0x06, 0xb7, 0x7d, 0x37, 0x70, 0xfd, 0xc4, 0xb7, 0xec,
	0x30, 0xb1, 0x6c, 0x1a, 0x89, 0xfb, 0xc8, 0x5f, 0xb4, 0x95, 0x74, 0xa1, 0x15, 0x26, 0x2d, 0x2e,
	0xe6, 0x11, 0x12, 0x46, 0x84, 0xf7, 0xc2, 0xee, 0x89, 0x27, 0xc3, 0xb1, 0x64, 0xe6, 0x45, 0xe8,
	0xff, 0xa1, 0xa2, 0xd0, 0x22, 0xec, 0x5b, 0xce, 0x89, 0xf0, 0xaa, 0x66, 0x2e, 0xa5, 0x52, 0x13,
	0xfb, 0xbb, 0x27, 0xe8, 0x8d, 0xca, 0x85, 0x45, 0x71, 0x82, 0xdf, 0x9a, 0xa1, 0x50, 0x15, 0xc9,
	0x50, 0xa5, 0xc1, 0x3b, 0x30, 0xcf, 0xdb, 0x61, 0x99, 0x9e, 0x75, 0x53, 0x4e, 0xd0, 0x33, 0xb8,
	0x7d, 0x42, 0x69, 0x6c, 0x89, 0xf6, 0x97, 0x3f, 0xd0, 0x9c, 0xc6, 0x82, 0xd8, 0x51, 0x85, 0x2f,
	0x70, 0x04, 0xfe, 0x4e, 0xef, 0x9e, 0xf0, 0x97, 0x3a, 0xa0, 0x16, 0xee, 0xf7, 0x23, 0xc2, 0x98,
	0xa8, 0x76, 0x4b, 0xa6, 0x1e, 0xd0, 0x2d, 0x29, 0xa8, 0xff, 0xa9, 0x00, 0x45, 0xae, 0x9d, 0xb5,
	0xa7, 0x5a, 0xae, 0x3d, 0xed, 0x40, 0x51, 0xbc, 0x1a, 0x05, 0x11, 0x36, 0xaf, 0x66, 0xdd, 0x43,
	0x83, 0xbf, 0x2f, 0xa6, 0x80, 0x40, 0xf7, 0x60, 0x51, 0xf1, 0x94, 0xb5, 0xc4, 0x02, 0x93, 0xfc,
	0xf8, 0xb9, 0x0b, 0x9b, 0x34, 0xd0, 0xd2, 0x19, 0x7f, 0xa5, 0x71, 0x12, 0x53, 0xab, 0x2f, 0xde,
	0x70, 0xb1, 0xb9, 0x92, 0x09, 0x5c, 0x24, 0x5f, 0x75, 0xae, 0xe0, 0xf3, 0x78, 0xb2, 0x42, 0xea,
	0x06, 0xb1, 0xa8, 0xb4, 0x75, 0x13, 0x84, 0xa8, 0xcb, 0x25, 0x46, 0x0f, 0x8a, 0xe2, 0x81, 0xbb,
	0x03, 0xd5, 0xa3, 0x1f, 0x75, 0xdb, 0xd6, 0x17, 0x07, 0xbd, 0x6e, 0xbb, 0xd5, 0x79, 0xd3, 0x69,
	0xef, 0x54, 0x6f, 0x21, 0x04, 0x95, 0x6e, 0xdb, 0xec, 0x75, 0x7a, 0x47, 0xed, 0x83, 0x23, 0x6b,
	0x6f, 0x67, 0xa7, 0xaa, 0x8d, 0xc8, 0x7a, 0xbd, 0x9d, 0x6a, 0x01, 0x2d, 0x83, 0xbe, 0x7f, 0xd8,
	0xda, 0xda, 0x17, 0xd3, 0x39, 0xe3, 0xdf, 0xda, 0x20, 0xc2, 0xb2, 0xa6, 0x77, 0xa2, 0xf3, 0x46,
	0x72, 0x4d, 0x61, 0x3c, 0xd7, 0x3c, 0x85, 0xe5, 0x3e, 0x39, 0xc5, 0x89, 0x17, 0x5b, 0x32, 0xf9,
	0xc9, 0x8e, 0x67, 0x29, 0x15, 0x1e, 0x73, 0x19, 0x3a, 0x02, 0xf0, 0xa8, 0x8d, 0x3d, 0xcb, 0xa6,
	0xe1, 0x65, 0xda, 0xf6, 0xbc, 0x9a, 0xa1, 0x43, 0x6f, 0xec, 0x73, 0xeb, 0x16, 0x0d, 0x2f, 0x4d,
	0xdd, 0x53, 0xc3, 0xfa, 0x4b, 0xd0, 0x33, 0x39, 0x67, 0x9f, 0xbb, 0x4c, 0x62, 0xcc, 0x65, 0x3c,
	0xb8, 0xd4, 0xdf, 0x0a, 0x3e, 0x36, 0xb6, 0xa0, 0x32, 0xdc, 0xb1, 0xf3, 0xe0, 0x12, 0xb5, 0x49,
	0xfe, 0xd7, 0x8e, 0x2e, 0x24, 0xe2, 0xbf, 0xce, 0x58, 0xc5, 0xb2, 0xfe, 0x9b, 0xd2, 0xc0, 0x7d,
	0xec, 0xf8, 0xc5, 0x96, 0x20, 0x8d, 0x7e, 0xab, 0x41, 0x65, 0xb8, 0xef, 0x46, 0xcd, 0x6b, 0x5e,
	0x80, 0x49, 0x1d, 0x7a, 0x7d, 0x8a, 0x2a, 0xd2, 0xf8, 0xc6, 0xaf, 0xfe, 0xfa, 0x8f, 0x3f, 0x14,
	0x1e, 0x19, 0x1f, 0x4c, 0xf8, 0x27, 0xb7, 0x99, 0x55, 0xe2, 0xe8, 0x17, 0x50, 0xce, 0x95, 0xed,
	0xe8, 0x9b, 0x53, 0x55, 0xf7, 0x8a, 0xc7, 0x47, 0x4a, 0x3b, 0xf7, 0x77, 0xae, 0x91, 0x3d, 0x0a,
	0x86, 0x21, 0x28, 0x3c, 0x34, 0xee, 0x4d, 0xa2, 0x10, 0x25, 0xc1, 0xa6, 0xb6, 0x86, 0xbe, 0xd2,
	0xa0, 0x9c, 0x6b, 0x05, 0xae, 0x23, 0x30, 0xde, 0x31, 0x4c, 0xe5, 0x88, 0x67, 0x82, 0xc5, 0x53,
	0xf4, 0x64, 0x02, 0x8b, 0xe6, 0xcf, 0x72, 0xd5, 0xf1, 0xcf, 0xd1, 0xef, 0x34, 0x58, 0x1e, 0x2a,
	0xe5, 0x51, 0xe3, 0x9a, 0x5e, 0x79, 0x42, 0x23, 0x52, 0x6f, 0x4e, 0xad, 0x2f, 0x7b, 0x04, 0xe3,
	0x81, 0x60, 0x77, 0x17, 0x4d, 0x3a, 0x26, 0xf4, 0x6b, 0x0d, 0x2a, 0xc3, 0x75, 0xfd, 0x75, 0xb1,
	0x32, 0xb1, 0x03, 0xa8, 0x7f, 0x38, 0xf6, 0xa2, 0xb7, 0xfd, 0x30, 0xbe, 0x54, 0x6e, 0x59, 0x9b,
	0xc2, 0x2d, 0x7f, 0xd4, 0xe0, 0x83, 0x09, 0x4d, 0x02, 0xfa, 0xf4, 0xda, 0xb3, 0xba, 0xa2, 0xa7,
	0xa8, 0xaf, 0x4d, 0x5f, 0xef, 0x18, 0x4d, 0x41, 0xf2, 0x19, 0xfa, 0x64, 0x52, 0x04, 0x39, 0x13,
	0x28, 0x7d, 0xad, 0x01, 0x1a, 0x2f, 0x4c, 0xd0, 0xcb, 0xeb, 0xfe, 0xd2, 0x5c, 0x51, 0xc6, 0x5c,
	0xe9, 0xb9, 0x17, 0x82, 0xd4, 0xf3, 0xfa, 0xc7, 0x93, 0x48, 0xb1, 0x31, 0xb8, 0x4d, 0x6d, 0x6d,
	0x3b, 0x84, 0x7b, 0x36, 0xf5, 0x27, 0x91, 0xd8, 0xae, 0x64, 0x31, 0xd1, 0xe5, 0x9f, 0xe9, 0x6a,
	0x3f, 0xfe, 0x5c, 0xa9, 0x51, 0x0f, 0x07, 0x4e, 0x83, 0x46, 0x4e, 0xd3, 0x21, 0x81, 0x20, 0xd1,
	0x94, 0x4b, 0x38, 0x74, 0xd9, 0xf8, 0x3f, 0xf7, 0xef, 0x2a, 0xc9, 0xbf, 0x34, 0xed, 0x64, 0x41,
	0xe8, 0xbf, 0xfc, 0x4f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x13, 0x10, 0x96, 0x1d, 0xa2, 0x17, 0x00,
	0x00,
}
