; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+experimental-zfh -verify-machineinstrs \
; RUN:   -target-abi ilp32f < %s | FileCheck -check-prefix=RV32IZFH %s
; RUN: llc -mtriple=riscv32 -mattr=+d -mattr=+experimental-zfh -verify-machineinstrs \
; RUN:   -target-abi ilp32d < %s | FileCheck -check-prefix=RV32IDZFH %s
; RUN: llc -mtriple=riscv64 -mattr=+experimental-zfh -verify-machineinstrs \
; RUN:   -target-abi lp64f < %s | FileCheck -check-prefix=RV64IZFH %s
; RUN: llc -mtriple=riscv64 -mattr=+d -mattr=+experimental-zfh -verify-machineinstrs \
; RUN:   -target-abi lp64d < %s | FileCheck -check-prefix=RV64IDZFH %s

declare half @llvm.sqrt.f16(half)

define half @sqrt_f16(half %a) nounwind {
; RV32IZFH-LABEL: sqrt_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fsqrt.h fa0, fa0
; RV32IZFH-NEXT:    ret
;
; RV32IDZFH-LABEL: sqrt_f16:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fsqrt.h fa0, fa0
; RV32IDZFH-NEXT:    ret
;
; RV64IZFH-LABEL: sqrt_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fsqrt.h fa0, fa0
; RV64IZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: sqrt_f16:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fsqrt.h fa0, fa0
; RV64IDZFH-NEXT:    ret
  %1 = call half @llvm.sqrt.f16(half %a)
  ret half %1
}

declare half @llvm.fma.f16(half, half, half)

define half @fma_f16(half %a, half %b, half %c) nounwind {
; RV32IZFH-LABEL: fma_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fmadd.h fa0, fa0, fa1, fa2
; RV32IZFH-NEXT:    ret
;
; RV32IDZFH-LABEL: fma_f16:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fmadd.h fa0, fa0, fa1, fa2
; RV32IDZFH-NEXT:    ret
;
; RV64IZFH-LABEL: fma_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fmadd.h fa0, fa0, fa1, fa2
; RV64IZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fma_f16:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fmadd.h fa0, fa0, fa1, fa2
; RV64IDZFH-NEXT:    ret
  %1 = call half @llvm.fma.f16(half %a, half %b, half %c)
  ret half %1
}

declare half @llvm.fmuladd.f16(half, half, half)

define half @fmuladd_f16(half %a, half %b, half %c) nounwind {
; RV32IZFH-LABEL: fmuladd_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fmadd.h fa0, fa0, fa1, fa2
; RV32IZFH-NEXT:    ret
;
; RV32IDZFH-LABEL: fmuladd_f16:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fmadd.h fa0, fa0, fa1, fa2
; RV32IDZFH-NEXT:    ret
;
; RV64IZFH-LABEL: fmuladd_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fmadd.h fa0, fa0, fa1, fa2
; RV64IZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fmuladd_f16:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fmadd.h fa0, fa0, fa1, fa2
; RV64IDZFH-NEXT:    ret
  %1 = call half @llvm.fmuladd.f16(half %a, half %b, half %c)
  ret half %1
}

declare half @llvm.fabs.f16(half)

define half @fabs_f16(half %a) nounwind {
; RV32IZFH-LABEL: fabs_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fabs.h fa0, fa0
; RV32IZFH-NEXT:    ret
;
; RV32IDZFH-LABEL: fabs_f16:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fabs.h fa0, fa0
; RV32IDZFH-NEXT:    ret
;
; RV64IZFH-LABEL: fabs_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fabs.h fa0, fa0
; RV64IZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fabs_f16:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fabs.h fa0, fa0
; RV64IDZFH-NEXT:    ret
  %1 = call half @llvm.fabs.f16(half %a)
  ret half %1
}

declare half @llvm.minnum.f16(half, half)

define half @minnum_f16(half %a, half %b) nounwind {
; RV32IZFH-LABEL: minnum_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fmin.h fa0, fa0, fa1
; RV32IZFH-NEXT:    ret
;
; RV32IDZFH-LABEL: minnum_f16:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fmin.h fa0, fa0, fa1
; RV32IDZFH-NEXT:    ret
;
; RV64IZFH-LABEL: minnum_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fmin.h fa0, fa0, fa1
; RV64IZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: minnum_f16:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fmin.h fa0, fa0, fa1
; RV64IDZFH-NEXT:    ret
  %1 = call half @llvm.minnum.f16(half %a, half %b)
  ret half %1
}

declare half @llvm.maxnum.f16(half, half)

define half @maxnum_f16(half %a, half %b) nounwind {
; RV32IZFH-LABEL: maxnum_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fmax.h fa0, fa0, fa1
; RV32IZFH-NEXT:    ret
;
; RV32IDZFH-LABEL: maxnum_f16:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fmax.h fa0, fa0, fa1
; RV32IDZFH-NEXT:    ret
;
; RV64IZFH-LABEL: maxnum_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fmax.h fa0, fa0, fa1
; RV64IZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: maxnum_f16:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fmax.h fa0, fa0, fa1
; RV64IDZFH-NEXT:    ret
  %1 = call half @llvm.maxnum.f16(half %a, half %b)
  ret half %1
}

declare half @llvm.copysign.f16(half, half)

define half @copysign_f16(half %a, half %b) nounwind {
; RV32IZFH-LABEL: copysign_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fsgnj.h fa0, fa0, fa1
; RV32IZFH-NEXT:    ret
;
; RV32IDZFH-LABEL: copysign_f16:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fsgnj.h fa0, fa0, fa1
; RV32IDZFH-NEXT:    ret
;
; RV64IZFH-LABEL: copysign_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fsgnj.h fa0, fa0, fa1
; RV64IZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: copysign_f16:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fsgnj.h fa0, fa0, fa1
; RV64IDZFH-NEXT:    ret
  %1 = call half @llvm.copysign.f16(half %a, half %b)
  ret half %1
}
