#! /usr/bin/env python

import io
import glob
import re
import sys
import six

if len(sys.argv) == 2:
    srcdir = sys.argv[1]
else:
    srcdir = '.'


fd = io.StringIO()

six.print_(u"/* This file has been autogenerated; changes will be lost */", file=fd)
six.print_(u"", file=fd)
six.print_(u"typedef GType (*type_function) ();", file=fd)
six.print_(u"", file=fd)

header_files = []
for header_file in sorted(glob.glob('%s/*/*.h' % srcdir) + glob.glob('%s/*/*/*.h' % srcdir)):
    assert not ('/id-wsf/' in header_file or '/id-wsf-2.0' in header_file)
    header_files.append(header_file)
    try:
        type = re.findall('lasso_.*get_type', io.open(header_file, encoding='utf-8').read())[0]
    except IndexError:
        continue
    six.print_("extern GType %s();" % type, file=fd)

six.print_(u"", file=fd)
six.print_(u"type_function functions[] = {", file=fd)
for header_file in header_files:
    try:
        type = re.findall('lasso_.*get_type', io.open(header_file, encoding='utf-8').read())[0]
    except IndexError:
        continue
    six.print_(u"\t%s," % type, file=fd)
six.print_(u"\tNULL", file=fd)
six.print_(u"};", file=fd)

io.open('types.c', 'w', encoding='utf-8').write(fd.getvalue())
