/* math-display.c generated by valac 0.24.0, the Vala compiler
 * generated from math-display.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <pango/pango.h>
#include <atk/atk.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_MATH_DISPLAY (math_display_get_type ())
#define MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_DISPLAY, MathDisplay))
#define MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_DISPLAY, MathDisplayClass))
#define IS_MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_DISPLAY))
#define IS_MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_DISPLAY))
#define MATH_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_DISPLAY, MathDisplayClass))

typedef struct _MathDisplay MathDisplay;
typedef struct _MathDisplayClass MathDisplayClass;
typedef struct _MathDisplayPrivate MathDisplayPrivate;

#define TYPE_MATH_EQUATION (math_equation_get_type ())
#define MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_EQUATION, MathEquation))
#define MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_EQUATION, MathEquationClass))
#define IS_MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_EQUATION))
#define IS_MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_EQUATION))
#define MATH_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_EQUATION, MathEquationClass))

typedef struct _MathEquation MathEquation;
typedef struct _MathEquationClass MathEquationClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define __vala_GdkEventKey_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEventKey_free (var), NULL)))

#define TYPE_NUMBER_MODE (number_mode_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

struct _MathDisplay {
	GtkViewport parent_instance;
	MathDisplayPrivate * priv;
};

struct _MathDisplayClass {
	GtkViewportClass parent_class;
};

struct _MathDisplayPrivate {
	MathEquation* _equation;
	GtkTextView* text_view;
	GtkTextBuffer* info_buffer;
	GtkSpinner* spinner;
};

typedef enum  {
	NUMBER_MODE_NORMAL,
	NUMBER_MODE_SUPERSCRIPT,
	NUMBER_MODE_SUBSCRIPT
} NumberMode;


static gpointer math_display_parent_class = NULL;

GType math_display_get_type (void) G_GNUC_CONST;
GType math_equation_get_type (void) G_GNUC_CONST;
#define MATH_DISPLAY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_DISPLAY, MathDisplayPrivate))
enum  {
	MATH_DISPLAY_DUMMY_PROPERTY,
	MATH_DISPLAY_EQUATION
};
MathDisplay* math_display_new (MathEquation* equation);
MathDisplay* math_display_construct (GType object_type, MathEquation* equation);
static gboolean math_display_key_press_cb (MathDisplay* self, GdkEventKey* event);
static gboolean _math_display_key_press_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void __lambda10_ (MathDisplay* self, GParamSpec* pspec);
static void math_display_status_changed_cb (MathDisplay* self);
static void ___lambda10__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda11_ (MathDisplay* self, GParamSpec* pspec);
static void math_display_error_status_changed_cb (MathDisplay* self);
static void ___lambda11__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static gboolean math_display_real_key_press_event (GtkWidget* base, GdkEventKey* event);
static GdkEventKey* _vala_GdkEventKey_copy (GdkEventKey* self);
static void _vala_GdkEventKey_free (GdkEventKey* self);
MathEquation* math_display_get_equation (MathDisplay* self);
void math_equation_solve (MathEquation* self);
void math_equation_clear (MathEquation* self);
void math_equation_insert_numeric_point (MathEquation* self);
void math_equation_insert (MathEquation* self, const gchar* text);
void math_equation_insert_subtract (MathEquation* self);
void math_equation_insert_exponent (MathEquation* self);
void math_equation_factorize (MathEquation* self);
GType number_mode_get_type (void) G_GNUC_CONST;
NumberMode math_equation_get_number_mode (MathEquation* self);
gchar* math_equation_get_status (MathEquation* self);
gboolean math_equation_get_in_solve (MathEquation* self);
guint math_equation_get_error_token_end (MathEquation* self);
guint math_equation_get_error_token_start (MathEquation* self);
static void math_display_finalize (GObject* obj);
static void _vala_math_display_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _math_display_key_press_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = math_display_key_press_cb ((MathDisplay*) self, event);
	return result;
}


static void __lambda10_ (MathDisplay* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_display_status_changed_cb (self);
}


static void ___lambda10__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda10_ ((MathDisplay*) self, pspec);
}


static void __lambda11_ (MathDisplay* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_display_error_status_changed_cb (self);
}


static void ___lambda11__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda11_ ((MathDisplay*) self, pspec);
}


static void _vala_PangoFontDescription_free (PangoFontDescription* self) {
	g_boxed_free (pango_font_description_get_type (), self);
}


MathDisplay* math_display_construct (GType object_type, MathEquation* equation) {
	MathDisplay * self = NULL;
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	GtkBox* main_box = NULL;
	GtkBox* _tmp2_ = NULL;
	GtkBox* _tmp3_ = NULL;
	MathEquation* _tmp4_ = NULL;
	GtkTextView* _tmp5_ = NULL;
	GtkTextView* _tmp6_ = NULL;
	GtkTextView* _tmp7_ = NULL;
	GtkTextView* _tmp8_ = NULL;
	GtkTextView* _tmp9_ = NULL;
	GtkTextView* _tmp10_ = NULL;
	PangoFontDescription* font_desc = NULL;
	GtkTextView* _tmp11_ = NULL;
	GtkStyle* _tmp12_ = NULL;
	PangoFontDescription* _tmp13_ = NULL;
	PangoFontDescription* _tmp14_ = NULL;
	PangoFontDescription* _tmp15_ = NULL;
	GtkTextView* _tmp16_ = NULL;
	PangoFontDescription* _tmp17_ = NULL;
	GtkTextView* _tmp18_ = NULL;
	GtkTextView* _tmp19_ = NULL;
	AtkObject* _tmp20_ = NULL;
	GtkTextView* _tmp21_ = NULL;
	GtkBox* _tmp22_ = NULL;
	GtkTextView* _tmp23_ = NULL;
	GtkBox* info_box = NULL;
	GtkBox* _tmp24_ = NULL;
	GtkBox* _tmp25_ = NULL;
	GtkBox* _tmp26_ = NULL;
	GtkTextView* info_view = NULL;
	GtkTextView* _tmp27_ = NULL;
	GtkTextView* _tmp28_ = NULL;
	GtkTextView* _tmp29_ = NULL;
	GtkTextView* _tmp30_ = NULL;
	GtkTextView* _tmp31_ = NULL;
	GtkTextView* _tmp32_ = NULL;
	GtkBox* _tmp33_ = NULL;
	GtkTextView* _tmp34_ = NULL;
	GtkTextView* _tmp35_ = NULL;
	GtkTextBuffer* _tmp36_ = NULL;
	GtkTextBuffer* _tmp37_ = NULL;
	GtkSpinner* _tmp38_ = NULL;
	GtkBox* _tmp39_ = NULL;
	GtkSpinner* _tmp40_ = NULL;
	GtkTextView* _tmp41_ = NULL;
	GtkStyle* _tmp42_ = NULL;
	GtkBox* _tmp52_ = NULL;
	GtkTextView* _tmp53_ = NULL;
	GtkTextView* _tmp54_ = NULL;
	GtkBox* _tmp55_ = NULL;
	MathEquation* _tmp56_ = NULL;
	MathEquation* _tmp57_ = NULL;
	g_return_val_if_fail (equation != NULL, NULL);
	self = (MathDisplay*) g_object_new (object_type, NULL);
	_tmp0_ = equation;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_equation);
	self->priv->_equation = _tmp1_;
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp2_);
	main_box = _tmp2_;
	_tmp3_ = main_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
	_tmp4_ = equation;
	_tmp5_ = (GtkTextView*) gtk_text_view_new_with_buffer ((GtkTextBuffer*) _tmp4_);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->text_view);
	self->priv->text_view = _tmp5_;
	_tmp6_ = self->priv->text_view;
	gtk_text_view_set_accepts_tab (_tmp6_, FALSE);
	_tmp7_ = self->priv->text_view;
	gtk_text_view_set_pixels_above_lines (_tmp7_, 8);
	_tmp8_ = self->priv->text_view;
	gtk_text_view_set_pixels_below_lines (_tmp8_, 2);
	_tmp9_ = self->priv->text_view;
	gtk_text_view_set_justification (_tmp9_, GTK_JUSTIFY_RIGHT);
	_tmp10_ = self->priv->text_view;
	gtk_widget_ensure_style ((GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->text_view;
	_tmp12_ = gtk_widget_get_style ((GtkWidget*) _tmp11_);
	_tmp13_ = _tmp12_->font_desc;
	_tmp14_ = pango_font_description_copy (_tmp13_);
	font_desc = _tmp14_;
	_tmp15_ = font_desc;
	pango_font_description_set_size (_tmp15_, 16 * PANGO_SCALE);
	_tmp16_ = self->priv->text_view;
	_tmp17_ = font_desc;
	gtk_widget_modify_font ((GtkWidget*) _tmp16_, _tmp17_);
	_tmp18_ = self->priv->text_view;
	gtk_buildable_set_name ((GtkBuildable*) _tmp18_, "displayitem");
	_tmp19_ = self->priv->text_view;
	_tmp20_ = gtk_widget_get_accessible ((GtkWidget*) _tmp19_);
	atk_object_set_role (_tmp20_, ATK_ROLE_EDITBAR);
	_tmp21_ = self->priv->text_view;
	g_signal_connect_object ((GtkWidget*) _tmp21_, "key-press-event", (GCallback) _math_display_key_press_cb_gtk_widget_key_press_event, self, 0);
	_tmp22_ = main_box;
	_tmp23_ = self->priv->text_view;
	gtk_box_pack_start (_tmp22_, (GtkWidget*) _tmp23_, TRUE, TRUE, (guint) 0);
	_tmp24_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp24_);
	info_box = _tmp24_;
	_tmp25_ = main_box;
	_tmp26_ = info_box;
	gtk_box_pack_start (_tmp25_, (GtkWidget*) _tmp26_, FALSE, TRUE, (guint) 0);
	_tmp27_ = (GtkTextView*) gtk_text_view_new ();
	g_object_ref_sink (_tmp27_);
	info_view = _tmp27_;
	_tmp28_ = info_view;
	gtk_text_view_set_wrap_mode (_tmp28_, GTK_WRAP_WORD);
	_tmp29_ = info_view;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp29_, TRUE);
	_tmp30_ = info_view;
	gtk_text_view_set_cursor_visible (_tmp30_, FALSE);
	_tmp31_ = info_view;
	gtk_text_view_set_editable (_tmp31_, FALSE);
	_tmp32_ = info_view;
	gtk_text_view_set_justification (_tmp32_, GTK_JUSTIFY_RIGHT);
	_tmp33_ = info_box;
	_tmp34_ = info_view;
	gtk_box_pack_start (_tmp33_, (GtkWidget*) _tmp34_, TRUE, TRUE, (guint) 0);
	_tmp35_ = info_view;
	_tmp36_ = gtk_text_view_get_buffer (_tmp35_);
	_tmp37_ = _g_object_ref0 (_tmp36_);
	_g_object_unref0 (self->priv->info_buffer);
	self->priv->info_buffer = _tmp37_;
	_tmp38_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp38_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp38_;
	_tmp39_ = info_box;
	_tmp40_ = self->priv->spinner;
	gtk_box_pack_end (_tmp39_, (GtkWidget*) _tmp40_, FALSE, FALSE, (guint) 0);
	_tmp41_ = info_view;
	_tmp42_ = gtk_widget_get_style ((GtkWidget*) _tmp41_);
	gtk_widget_set_style ((GtkWidget*) self, _tmp42_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp43_ = FALSE;
			_tmp43_ = TRUE;
			while (TRUE) {
				gint _tmp45_ = 0;
				gint _tmp46_ = 0;
				GtkStyle* _tmp47_ = NULL;
				GtkStyle* _tmp48_ = NULL;
				GdkColor* _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				gint _tmp50_ = 0;
				GdkColor _tmp51_ = {0};
				if (!_tmp43_) {
					gint _tmp44_ = 0;
					_tmp44_ = i;
					i = _tmp44_ + 1;
				}
				_tmp43_ = FALSE;
				_tmp45_ = i;
				if (!(_tmp45_ < 5)) {
					break;
				}
				_tmp46_ = i;
				_tmp47_ = gtk_widget_get_style ((GtkWidget*) self);
				_tmp48_ = _tmp47_;
				_tmp49_ = _tmp48_->base;
				_tmp49__length1 = -1;
				_tmp50_ = i;
				_tmp51_ = _tmp49_[_tmp50_];
				gtk_widget_modify_bg ((GtkWidget*) self, _tmp46_, &_tmp51_);
			}
		}
	}
	_tmp52_ = info_box;
	gtk_widget_show ((GtkWidget*) _tmp52_);
	_tmp53_ = info_view;
	gtk_widget_show ((GtkWidget*) _tmp53_);
	_tmp54_ = self->priv->text_view;
	gtk_widget_show ((GtkWidget*) _tmp54_);
	_tmp55_ = main_box;
	gtk_widget_show ((GtkWidget*) _tmp55_);
	_tmp56_ = equation;
	g_signal_connect_object ((GObject*) _tmp56_, "notify::status", (GCallback) ___lambda10__g_object_notify, self, 0);
	math_display_status_changed_cb (self);
	_tmp57_ = equation;
	g_signal_connect_object ((GObject*) _tmp57_, "notify::error-token-end", (GCallback) ___lambda11__g_object_notify, self, 0);
	_g_object_unref0 (info_view);
	_g_object_unref0 (info_box);
	__vala_PangoFontDescription_free0 (font_desc);
	_g_object_unref0 (main_box);
	return self;
}


MathDisplay* math_display_new (MathEquation* equation) {
	return math_display_construct (TYPE_MATH_DISPLAY, equation);
}


static gboolean math_display_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	MathDisplay * self;
	gboolean result = FALSE;
	GtkTextView* _tmp0_ = NULL;
	GdkEventKey* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	self = (MathDisplay*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->text_view;
	_tmp1_ = event;
	g_signal_emit_by_name ((GtkWidget*) _tmp0_, "key-press-event", _tmp1_, &_tmp2_);
	result = _tmp2_;
	return result;
}


static GdkEventKey* _vala_GdkEventKey_copy (GdkEventKey* self) {
	return g_boxed_copy (gdk_event_get_type (), self);
}


static gpointer __vala_GdkEventKey_copy0 (gpointer self) {
	return self ? _vala_GdkEventKey_copy (self) : NULL;
}


static void _vala_GdkEventKey_free (GdkEventKey* self) {
	g_boxed_free (gdk_event_get_type (), self);
}


static gboolean math_display_key_press_cb (MathDisplay* self, GdkEventKey* event) {
	gboolean result = FALSE;
	guint new_keyval = 0U;
	GdkEventKey* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	GdkModifierType state = 0;
	GdkEventKey* _tmp9_ = NULL;
	GdkModifierType _tmp10_ = 0;
	guint32 c = 0U;
	GdkEventKey* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	guint32 _tmp13_ = 0U;
	gboolean _tmp14_ = FALSE;
	GdkEventKey* _tmp15_ = NULL;
	guint _tmp16_ = 0U;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	GdkEventKey* _tmp24_ = NULL;
	guint _tmp25_ = 0U;
	GdkEventKey* _tmp37_ = NULL;
	guint _tmp38_ = 0U;
	GdkModifierType _tmp41_ = 0;
	GdkModifierType _tmp51_ = 0;
	GdkModifierType _tmp74_ = 0;
	gboolean _tmp81_ = FALSE;
	GdkModifierType _tmp82_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	new_keyval = (guint) 0;
	_tmp0_ = event;
	_tmp1_ = _tmp0_->keyval;
	switch (_tmp1_) {
		case GDK_KEY_KP_Insert:
		{
			new_keyval = (guint) GDK_KEY_0;
			break;
		}
		case GDK_KEY_KP_End:
		{
			new_keyval = (guint) GDK_KEY_1;
			break;
		}
		case GDK_KEY_KP_Down:
		{
			new_keyval = (guint) GDK_KEY_2;
			break;
		}
		case GDK_KEY_KP_Page_Down:
		{
			new_keyval = (guint) GDK_KEY_3;
			break;
		}
		case GDK_KEY_KP_Left:
		{
			new_keyval = (guint) GDK_KEY_4;
			break;
		}
		case GDK_KEY_KP_Begin:
		{
			new_keyval = (guint) GDK_KEY_5;
			break;
		}
		case GDK_KEY_KP_Right:
		{
			new_keyval = (guint) GDK_KEY_6;
			break;
		}
		case GDK_KEY_KP_Home:
		{
			new_keyval = (guint) GDK_KEY_7;
			break;
		}
		case GDK_KEY_KP_Up:
		{
			new_keyval = (guint) GDK_KEY_8;
			break;
		}
		case GDK_KEY_KP_Page_Up:
		{
			new_keyval = (guint) GDK_KEY_9;
			break;
		}
		default:
		break;
	}
	_tmp2_ = new_keyval;
	if (_tmp2_ != ((guint) 0)) {
		GdkEventKey* new_event = NULL;
		GdkEventKey* _tmp3_ = NULL;
		GdkEventKey* _tmp4_ = NULL;
		GdkEventKey* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		GdkEventKey* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp3_ = event;
		_tmp4_ = __vala_GdkEventKey_copy0 (_tmp3_);
		new_event = _tmp4_;
		_tmp5_ = new_event;
		_tmp6_ = new_keyval;
		_tmp5_->keyval = _tmp6_;
		_tmp7_ = new_event;
		g_signal_emit_by_name ((GtkWidget*) self, "key-press-event", _tmp7_, &_tmp8_);
		result = _tmp8_;
		__vala_GdkEventKey_free0 (new_event);
		return result;
	}
	_tmp9_ = event;
	_tmp10_ = _tmp9_->state;
	state = _tmp10_ & (GDK_CONTROL_MASK | GDK_MOD1_MASK);
	_tmp11_ = event;
	_tmp12_ = _tmp11_->keyval;
	_tmp13_ = gdk_keyval_to_unicode (_tmp12_);
	c = _tmp13_;
	_tmp15_ = event;
	_tmp16_ = _tmp15_->keyval;
	if (_tmp16_ == ((guint) GDK_KEY_Return)) {
		_tmp14_ = TRUE;
	} else {
		GdkEventKey* _tmp17_ = NULL;
		guint _tmp18_ = 0U;
		_tmp17_ = event;
		_tmp18_ = _tmp17_->keyval;
		_tmp14_ = _tmp18_ == ((guint) GDK_KEY_KP_Enter);
	}
	if (_tmp14_) {
		MathEquation* _tmp19_ = NULL;
		MathEquation* _tmp20_ = NULL;
		_tmp19_ = math_display_get_equation (self);
		_tmp20_ = _tmp19_;
		math_equation_solve (_tmp20_);
		result = TRUE;
		return result;
	}
	_tmp24_ = event;
	_tmp25_ = _tmp24_->keyval;
	if (_tmp25_ == ((guint) GDK_KEY_Escape)) {
		GdkModifierType _tmp26_ = 0;
		_tmp26_ = state;
		_tmp23_ = _tmp26_ == 0;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		_tmp22_ = TRUE;
	} else {
		gboolean _tmp27_ = FALSE;
		GdkEventKey* _tmp28_ = NULL;
		guint _tmp29_ = 0U;
		_tmp28_ = event;
		_tmp29_ = _tmp28_->keyval;
		if (_tmp29_ == ((guint) GDK_KEY_BackSpace)) {
			GdkModifierType _tmp30_ = 0;
			_tmp30_ = state;
			_tmp27_ = _tmp30_ == GDK_CONTROL_MASK;
		} else {
			_tmp27_ = FALSE;
		}
		_tmp22_ = _tmp27_;
	}
	if (_tmp22_) {
		_tmp21_ = TRUE;
	} else {
		gboolean _tmp31_ = FALSE;
		GdkEventKey* _tmp32_ = NULL;
		guint _tmp33_ = 0U;
		_tmp32_ = event;
		_tmp33_ = _tmp32_->keyval;
		if (_tmp33_ == ((guint) GDK_KEY_Delete)) {
			GdkModifierType _tmp34_ = 0;
			_tmp34_ = state;
			_tmp31_ = _tmp34_ == GDK_SHIFT_MASK;
		} else {
			_tmp31_ = FALSE;
		}
		_tmp21_ = _tmp31_;
	}
	if (_tmp21_) {
		MathEquation* _tmp35_ = NULL;
		MathEquation* _tmp36_ = NULL;
		_tmp35_ = math_display_get_equation (self);
		_tmp36_ = _tmp35_;
		math_equation_clear (_tmp36_);
		result = TRUE;
		return result;
	}
	_tmp37_ = event;
	_tmp38_ = _tmp37_->keyval;
	if (_tmp38_ == ((guint) GDK_KEY_KP_Decimal)) {
		MathEquation* _tmp39_ = NULL;
		MathEquation* _tmp40_ = NULL;
		_tmp39_ = math_display_get_equation (self);
		_tmp40_ = _tmp39_;
		math_equation_insert_numeric_point (_tmp40_);
		result = TRUE;
		return result;
	}
	_tmp41_ = state;
	if (_tmp41_ == 0) {
		guint32 _tmp42_ = 0U;
		guint32 _tmp45_ = 0U;
		guint32 _tmp48_ = 0U;
		_tmp42_ = c;
		if (_tmp42_ == ((guint32) '*')) {
			MathEquation* _tmp43_ = NULL;
			MathEquation* _tmp44_ = NULL;
			_tmp43_ = math_display_get_equation (self);
			_tmp44_ = _tmp43_;
			math_equation_insert (_tmp44_, "×");
			result = TRUE;
			return result;
		}
		_tmp45_ = c;
		if (_tmp45_ == ((guint32) '/')) {
			MathEquation* _tmp46_ = NULL;
			MathEquation* _tmp47_ = NULL;
			_tmp46_ = math_display_get_equation (self);
			_tmp47_ = _tmp46_;
			math_equation_insert (_tmp47_, "÷");
			result = TRUE;
			return result;
		}
		_tmp48_ = c;
		if (_tmp48_ == ((guint32) '-')) {
			MathEquation* _tmp49_ = NULL;
			MathEquation* _tmp50_ = NULL;
			_tmp49_ = math_display_get_equation (self);
			_tmp50_ = _tmp49_;
			math_equation_insert_subtract (_tmp50_);
			result = TRUE;
			return result;
		}
	}
	_tmp51_ = state;
	if (_tmp51_ == GDK_CONTROL_MASK) {
		GdkEventKey* _tmp52_ = NULL;
		guint _tmp53_ = 0U;
		_tmp52_ = event;
		_tmp53_ = _tmp52_->keyval;
		switch (_tmp53_) {
			case GDK_KEY_bracketleft:
			{
				MathEquation* _tmp54_ = NULL;
				MathEquation* _tmp55_ = NULL;
				_tmp54_ = math_display_get_equation (self);
				_tmp55_ = _tmp54_;
				math_equation_insert (_tmp55_, "⌈");
				result = TRUE;
				return result;
			}
			case GDK_KEY_bracketright:
			{
				MathEquation* _tmp56_ = NULL;
				MathEquation* _tmp57_ = NULL;
				_tmp56_ = math_display_get_equation (self);
				_tmp57_ = _tmp56_;
				math_equation_insert (_tmp57_, "⌉");
				result = TRUE;
				return result;
			}
			case GDK_KEY_e:
			{
				MathEquation* _tmp58_ = NULL;
				MathEquation* _tmp59_ = NULL;
				_tmp58_ = math_display_get_equation (self);
				_tmp59_ = _tmp58_;
				math_equation_insert_exponent (_tmp59_);
				result = TRUE;
				return result;
			}
			case GDK_KEY_f:
			{
				MathEquation* _tmp60_ = NULL;
				MathEquation* _tmp61_ = NULL;
				_tmp60_ = math_display_get_equation (self);
				_tmp61_ = _tmp60_;
				math_equation_factorize (_tmp61_);
				result = TRUE;
				return result;
			}
			case GDK_KEY_i:
			{
				MathEquation* _tmp62_ = NULL;
				MathEquation* _tmp63_ = NULL;
				_tmp62_ = math_display_get_equation (self);
				_tmp63_ = _tmp62_;
				math_equation_insert (_tmp63_, "⁻¹");
				result = TRUE;
				return result;
			}
			case GDK_KEY_p:
			{
				MathEquation* _tmp64_ = NULL;
				MathEquation* _tmp65_ = NULL;
				_tmp64_ = math_display_get_equation (self);
				_tmp65_ = _tmp64_;
				math_equation_insert (_tmp65_, "π");
				result = TRUE;
				return result;
			}
			case GDK_KEY_r:
			{
				MathEquation* _tmp66_ = NULL;
				MathEquation* _tmp67_ = NULL;
				_tmp66_ = math_display_get_equation (self);
				_tmp67_ = _tmp66_;
				math_equation_insert (_tmp67_, "√");
				result = TRUE;
				return result;
			}
			case GDK_KEY_u:
			{
				MathEquation* _tmp68_ = NULL;
				MathEquation* _tmp69_ = NULL;
				_tmp68_ = math_display_get_equation (self);
				_tmp69_ = _tmp68_;
				math_equation_insert (_tmp69_, "µ");
				result = TRUE;
				return result;
			}
			case GDK_KEY_minus:
			{
				MathEquation* _tmp70_ = NULL;
				MathEquation* _tmp71_ = NULL;
				_tmp70_ = math_display_get_equation (self);
				_tmp71_ = _tmp70_;
				math_equation_insert (_tmp71_, "⁻");
				result = TRUE;
				return result;
			}
			case GDK_KEY_apostrophe:
			{
				MathEquation* _tmp72_ = NULL;
				MathEquation* _tmp73_ = NULL;
				_tmp72_ = math_display_get_equation (self);
				_tmp73_ = _tmp72_;
				math_equation_insert (_tmp73_, "°");
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	}
	_tmp74_ = state;
	if (_tmp74_ == GDK_MOD1_MASK) {
		GdkEventKey* _tmp75_ = NULL;
		guint _tmp76_ = 0U;
		_tmp75_ = event;
		_tmp76_ = _tmp75_->keyval;
		switch (_tmp76_) {
			case GDK_KEY_bracketleft:
			{
				MathEquation* _tmp77_ = NULL;
				MathEquation* _tmp78_ = NULL;
				_tmp77_ = math_display_get_equation (self);
				_tmp78_ = _tmp77_;
				math_equation_insert (_tmp78_, "⌊");
				result = TRUE;
				return result;
			}
			case GDK_KEY_bracketright:
			{
				MathEquation* _tmp79_ = NULL;
				MathEquation* _tmp80_ = NULL;
				_tmp79_ = math_display_get_equation (self);
				_tmp80_ = _tmp79_;
				math_equation_insert (_tmp80_, "⌋");
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	}
	_tmp82_ = state;
	if (_tmp82_ == GDK_CONTROL_MASK) {
		_tmp81_ = TRUE;
	} else {
		MathEquation* _tmp83_ = NULL;
		MathEquation* _tmp84_ = NULL;
		NumberMode _tmp85_ = 0;
		NumberMode _tmp86_ = 0;
		_tmp83_ = math_display_get_equation (self);
		_tmp84_ = _tmp83_;
		_tmp85_ = math_equation_get_number_mode (_tmp84_);
		_tmp86_ = _tmp85_;
		_tmp81_ = _tmp86_ == NUMBER_MODE_SUPERSCRIPT;
	}
	if (_tmp81_) {
		GdkEventKey* _tmp87_ = NULL;
		guint _tmp88_ = 0U;
		_tmp87_ = event;
		_tmp88_ = _tmp87_->keyval;
		switch (_tmp88_) {
			case GDK_KEY_0:
			case GDK_KEY_KP_0:
			{
				MathEquation* _tmp89_ = NULL;
				MathEquation* _tmp90_ = NULL;
				_tmp89_ = math_display_get_equation (self);
				_tmp90_ = _tmp89_;
				math_equation_insert (_tmp90_, "⁰");
				result = TRUE;
				return result;
			}
			case GDK_KEY_1:
			case GDK_KEY_KP_1:
			{
				MathEquation* _tmp91_ = NULL;
				MathEquation* _tmp92_ = NULL;
				_tmp91_ = math_display_get_equation (self);
				_tmp92_ = _tmp91_;
				math_equation_insert (_tmp92_, "¹");
				result = TRUE;
				return result;
			}
			case GDK_KEY_2:
			case GDK_KEY_KP_2:
			{
				MathEquation* _tmp93_ = NULL;
				MathEquation* _tmp94_ = NULL;
				_tmp93_ = math_display_get_equation (self);
				_tmp94_ = _tmp93_;
				math_equation_insert (_tmp94_, "²");
				result = TRUE;
				return result;
			}
			case GDK_KEY_3:
			case GDK_KEY_KP_3:
			{
				MathEquation* _tmp95_ = NULL;
				MathEquation* _tmp96_ = NULL;
				_tmp95_ = math_display_get_equation (self);
				_tmp96_ = _tmp95_;
				math_equation_insert (_tmp96_, "³");
				result = TRUE;
				return result;
			}
			case GDK_KEY_4:
			case GDK_KEY_KP_4:
			{
				MathEquation* _tmp97_ = NULL;
				MathEquation* _tmp98_ = NULL;
				_tmp97_ = math_display_get_equation (self);
				_tmp98_ = _tmp97_;
				math_equation_insert (_tmp98_, "⁴");
				result = TRUE;
				return result;
			}
			case GDK_KEY_5:
			case GDK_KEY_KP_5:
			{
				MathEquation* _tmp99_ = NULL;
				MathEquation* _tmp100_ = NULL;
				_tmp99_ = math_display_get_equation (self);
				_tmp100_ = _tmp99_;
				math_equation_insert (_tmp100_, "⁵");
				result = TRUE;
				return result;
			}
			case GDK_KEY_6:
			case GDK_KEY_KP_6:
			{
				MathEquation* _tmp101_ = NULL;
				MathEquation* _tmp102_ = NULL;
				_tmp101_ = math_display_get_equation (self);
				_tmp102_ = _tmp101_;
				math_equation_insert (_tmp102_, "⁶");
				result = TRUE;
				return result;
			}
			case GDK_KEY_7:
			case GDK_KEY_KP_7:
			{
				MathEquation* _tmp103_ = NULL;
				MathEquation* _tmp104_ = NULL;
				_tmp103_ = math_display_get_equation (self);
				_tmp104_ = _tmp103_;
				math_equation_insert (_tmp104_, "⁷");
				result = TRUE;
				return result;
			}
			case GDK_KEY_8:
			case GDK_KEY_KP_8:
			{
				MathEquation* _tmp105_ = NULL;
				MathEquation* _tmp106_ = NULL;
				_tmp105_ = math_display_get_equation (self);
				_tmp106_ = _tmp105_;
				math_equation_insert (_tmp106_, "⁸");
				result = TRUE;
				return result;
			}
			case GDK_KEY_9:
			case GDK_KEY_KP_9:
			{
				MathEquation* _tmp107_ = NULL;
				MathEquation* _tmp108_ = NULL;
				_tmp107_ = math_display_get_equation (self);
				_tmp108_ = _tmp107_;
				math_equation_insert (_tmp108_, "⁹");
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	} else {
		gboolean _tmp109_ = FALSE;
		GdkModifierType _tmp110_ = 0;
		_tmp110_ = state;
		if (_tmp110_ == GDK_MOD1_MASK) {
			_tmp109_ = TRUE;
		} else {
			MathEquation* _tmp111_ = NULL;
			MathEquation* _tmp112_ = NULL;
			NumberMode _tmp113_ = 0;
			NumberMode _tmp114_ = 0;
			_tmp111_ = math_display_get_equation (self);
			_tmp112_ = _tmp111_;
			_tmp113_ = math_equation_get_number_mode (_tmp112_);
			_tmp114_ = _tmp113_;
			_tmp109_ = _tmp114_ == NUMBER_MODE_SUBSCRIPT;
		}
		if (_tmp109_) {
			GdkEventKey* _tmp115_ = NULL;
			guint _tmp116_ = 0U;
			_tmp115_ = event;
			_tmp116_ = _tmp115_->keyval;
			switch (_tmp116_) {
				case GDK_KEY_0:
				case GDK_KEY_KP_0:
				{
					MathEquation* _tmp117_ = NULL;
					MathEquation* _tmp118_ = NULL;
					_tmp117_ = math_display_get_equation (self);
					_tmp118_ = _tmp117_;
					math_equation_insert (_tmp118_, "₀");
					result = TRUE;
					return result;
				}
				case GDK_KEY_1:
				case GDK_KEY_KP_1:
				{
					MathEquation* _tmp119_ = NULL;
					MathEquation* _tmp120_ = NULL;
					_tmp119_ = math_display_get_equation (self);
					_tmp120_ = _tmp119_;
					math_equation_insert (_tmp120_, "₁");
					result = TRUE;
					return result;
				}
				case GDK_KEY_2:
				case GDK_KEY_KP_2:
				{
					MathEquation* _tmp121_ = NULL;
					MathEquation* _tmp122_ = NULL;
					_tmp121_ = math_display_get_equation (self);
					_tmp122_ = _tmp121_;
					math_equation_insert (_tmp122_, "₂");
					result = TRUE;
					return result;
				}
				case GDK_KEY_3:
				case GDK_KEY_KP_3:
				{
					MathEquation* _tmp123_ = NULL;
					MathEquation* _tmp124_ = NULL;
					_tmp123_ = math_display_get_equation (self);
					_tmp124_ = _tmp123_;
					math_equation_insert (_tmp124_, "₃");
					result = TRUE;
					return result;
				}
				case GDK_KEY_4:
				case GDK_KEY_KP_4:
				{
					MathEquation* _tmp125_ = NULL;
					MathEquation* _tmp126_ = NULL;
					_tmp125_ = math_display_get_equation (self);
					_tmp126_ = _tmp125_;
					math_equation_insert (_tmp126_, "₄");
					result = TRUE;
					return result;
				}
				case GDK_KEY_5:
				case GDK_KEY_KP_5:
				{
					MathEquation* _tmp127_ = NULL;
					MathEquation* _tmp128_ = NULL;
					_tmp127_ = math_display_get_equation (self);
					_tmp128_ = _tmp127_;
					math_equation_insert (_tmp128_, "₅");
					result = TRUE;
					return result;
				}
				case GDK_KEY_6:
				case GDK_KEY_KP_6:
				{
					MathEquation* _tmp129_ = NULL;
					MathEquation* _tmp130_ = NULL;
					_tmp129_ = math_display_get_equation (self);
					_tmp130_ = _tmp129_;
					math_equation_insert (_tmp130_, "₆");
					result = TRUE;
					return result;
				}
				case GDK_KEY_7:
				case GDK_KEY_KP_7:
				{
					MathEquation* _tmp131_ = NULL;
					MathEquation* _tmp132_ = NULL;
					_tmp131_ = math_display_get_equation (self);
					_tmp132_ = _tmp131_;
					math_equation_insert (_tmp132_, "₇");
					result = TRUE;
					return result;
				}
				case GDK_KEY_8:
				case GDK_KEY_KP_8:
				{
					MathEquation* _tmp133_ = NULL;
					MathEquation* _tmp134_ = NULL;
					_tmp133_ = math_display_get_equation (self);
					_tmp134_ = _tmp133_;
					math_equation_insert (_tmp134_, "₈");
					result = TRUE;
					return result;
				}
				case GDK_KEY_9:
				case GDK_KEY_KP_9:
				{
					MathEquation* _tmp135_ = NULL;
					MathEquation* _tmp136_ = NULL;
					_tmp135_ = math_display_get_equation (self);
					_tmp136_ = _tmp135_;
					math_equation_insert (_tmp136_, "₉");
					result = TRUE;
					return result;
				}
				default:
				break;
			}
		}
	}
	result = FALSE;
	return result;
}


static void math_display_status_changed_cb (MathDisplay* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	MathEquation* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	MathEquation* _tmp7_ = NULL;
	MathEquation* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->info_buffer;
	_tmp1_ = math_display_get_equation (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = math_equation_get_status (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	gtk_text_buffer_set_text (_tmp0_, _tmp5_, -1);
	_g_free0 (_tmp5_);
	_tmp7_ = math_display_get_equation (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = math_equation_get_in_solve (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		GtkSpinner* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		_tmp11_ = self->priv->spinner;
		_tmp12_ = gtk_widget_get_visible ((GtkWidget*) _tmp11_);
		_tmp6_ = !_tmp12_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GtkSpinner* _tmp13_ = NULL;
		GtkSpinner* _tmp14_ = NULL;
		_tmp13_ = self->priv->spinner;
		gtk_widget_show ((GtkWidget*) _tmp13_);
		_tmp14_ = self->priv->spinner;
		gtk_spinner_start (_tmp14_);
	} else {
		gboolean _tmp15_ = FALSE;
		MathEquation* _tmp16_ = NULL;
		MathEquation* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		_tmp16_ = math_display_get_equation (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = math_equation_get_in_solve (_tmp17_);
		_tmp19_ = _tmp18_;
		if (!_tmp19_) {
			GtkSpinner* _tmp20_ = NULL;
			gboolean _tmp21_ = FALSE;
			_tmp20_ = self->priv->spinner;
			_tmp21_ = gtk_widget_get_visible ((GtkWidget*) _tmp20_);
			_tmp15_ = _tmp21_;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			GtkSpinner* _tmp22_ = NULL;
			GtkSpinner* _tmp23_ = NULL;
			_tmp22_ = self->priv->spinner;
			gtk_widget_hide ((GtkWidget*) _tmp22_);
			_tmp23_ = self->priv->spinner;
			gtk_spinner_stop (_tmp23_);
		}
	}
}


static void math_display_error_status_changed_cb (MathDisplay* self) {
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	MathEquation* _tmp4_ = NULL;
	MathEquation* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	MathEquation* _tmp8_ = NULL;
	MathEquation* _tmp9_ = NULL;
	GtkTextIter _tmp10_ = {0};
	MathEquation* _tmp11_ = NULL;
	MathEquation* _tmp12_ = NULL;
	GtkTextIter _tmp13_ = {0};
	MathEquation* _tmp14_ = NULL;
	MathEquation* _tmp15_ = NULL;
	guint _tmp16_ = 0U;
	guint _tmp17_ = 0U;
	MathEquation* _tmp18_ = NULL;
	MathEquation* _tmp19_ = NULL;
	guint _tmp20_ = 0U;
	guint _tmp21_ = 0U;
	MathEquation* _tmp22_ = NULL;
	MathEquation* _tmp23_ = NULL;
	GtkTextIter _tmp24_ = {0};
	GtkTextIter _tmp25_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = math_display_get_equation (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = math_equation_get_error_token_end (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = math_display_get_equation (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = math_equation_get_error_token_start (_tmp5_);
	_tmp7_ = _tmp6_;
	if ((_tmp3_ - _tmp7_) == ((guint) 0)) {
		return;
	}
	_tmp8_ = math_display_get_equation (self);
	_tmp9_ = _tmp8_;
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) _tmp9_, &_tmp10_);
	start = _tmp10_;
	_tmp11_ = math_display_get_equation (self);
	_tmp12_ = _tmp11_;
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) _tmp12_, &_tmp13_);
	end = _tmp13_;
	_tmp14_ = math_display_get_equation (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = math_equation_get_error_token_start (_tmp15_);
	_tmp17_ = _tmp16_;
	gtk_text_iter_set_offset (&start, (gint) _tmp17_);
	_tmp18_ = math_display_get_equation (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = math_equation_get_error_token_end (_tmp19_);
	_tmp21_ = _tmp20_;
	gtk_text_iter_set_offset (&end, (gint) _tmp21_);
	_tmp22_ = math_display_get_equation (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = start;
	_tmp25_ = end;
	gtk_text_buffer_select_range ((GtkTextBuffer*) _tmp23_, &_tmp24_, &_tmp25_);
}


MathEquation* math_display_get_equation (MathDisplay* self) {
	MathEquation* result;
	MathEquation* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equation;
	result = _tmp0_;
	return result;
}


static void math_display_class_init (MathDisplayClass * klass) {
	math_display_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MathDisplayPrivate));
	GTK_WIDGET_CLASS (klass)->key_press_event = math_display_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_math_display_get_property;
	G_OBJECT_CLASS (klass)->finalize = math_display_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_DISPLAY_EQUATION, g_param_spec_object ("equation", "equation", "equation", TYPE_MATH_EQUATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void math_display_instance_init (MathDisplay * self) {
	self->priv = MATH_DISPLAY_GET_PRIVATE (self);
}


static void math_display_finalize (GObject* obj) {
	MathDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_DISPLAY, MathDisplay);
	_g_object_unref0 (self->priv->_equation);
	_g_object_unref0 (self->priv->text_view);
	_g_object_unref0 (self->priv->info_buffer);
	_g_object_unref0 (self->priv->spinner);
	G_OBJECT_CLASS (math_display_parent_class)->finalize (obj);
}


GType math_display_get_type (void) {
	static volatile gsize math_display_type_id__volatile = 0;
	if (g_once_init_enter (&math_display_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathDisplay), 0, (GInstanceInitFunc) math_display_instance_init, NULL };
		GType math_display_type_id;
		math_display_type_id = g_type_register_static (GTK_TYPE_VIEWPORT, "MathDisplay", &g_define_type_info, 0);
		g_once_init_leave (&math_display_type_id__volatile, math_display_type_id);
	}
	return math_display_type_id__volatile;
}


static void _vala_math_display_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MathDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_DISPLAY, MathDisplay);
	switch (property_id) {
		case MATH_DISPLAY_EQUATION:
		g_value_set_object (value, math_display_get_equation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



