
#include <winpr/crt.h>
#include <winpr/sysinfo.h>
#include <winpr/platform.h>

#define TEST_FEATURE(feature) \
	printf("\t" #feature ":  %s\n", IsProcessorFeaturePresent(feature) ? "yes" : "no")
#define TEST_FEATURE_EX(feature) \
	printf("\t" #feature ":  %s\n", IsProcessorFeaturePresentEx(feature) ? "yes" : "no")
int TestCPUFeatures(int argc, char* argv[])
{

	WINPR_UNUSED(argc);
	WINPR_UNUSED(argv);

	printf("Base CPU Flags:\n");
#ifdef _M_IX86_AMD64
	TEST_FEATURE(PF_MMX_INSTRUCTIONS_AVAILABLE);
	TEST_FEATURE(PF_XMMI_INSTRUCTIONS_AVAILABLE);
	TEST_FEATURE(PF_XMMI64_INSTRUCTIONS_AVAILABLE);
	TEST_FEATURE(PF_3DNOW_INSTRUCTIONS_AVAILABLE);
	TEST_FEATURE(PF_SSE3_INSTRUCTIONS_AVAILABLE);
	printf("\n");
	printf("Extended CPU Flags (not found in windows API):\n");
	TEST_FEATURE_EX(PF_EX_3DNOW_PREFETCH);
	TEST_FEATURE_EX(PF_EX_SSSE3);
	TEST_FEATURE_EX(PF_EX_SSE41);
	TEST_FEATURE_EX(PF_EX_SSE42);
	TEST_FEATURE_EX(PF_EX_AVX);
	TEST_FEATURE_EX(PF_EX_FMA);
	TEST_FEATURE_EX(PF_EX_AVX_AES);
	TEST_FEATURE_EX(PF_EX_AVX_PCLMULQDQ);
#elif defined(_M_ARM)
	TEST_FEATURE(PF_ARM_NEON_INSTRUCTIONS_AVAILABLE);
	TEST_FEATURE(PF_ARM_THUMB);
	TEST_FEATURE(PF_ARM_VFP_32_REGISTERS_AVAILABLE);
	TEST_FEATURE(PF_ARM_DIVIDE_INSTRUCTION_AVAILABLE);
	TEST_FEATURE(PF_ARM_VFP3);
	TEST_FEATURE(PF_ARM_THUMB);
	TEST_FEATURE(PF_ARM_JAZELLE);
	TEST_FEATURE(PF_ARM_DSP);
	TEST_FEATURE(PF_ARM_THUMB2);
	TEST_FEATURE(PF_ARM_T2EE);
	TEST_FEATURE(PF_ARM_INTEL_WMMX);
	printf("Extended CPU Flags (not found in windows API):\n");
	TEST_FEATURE_EX(PF_EX_ARM_VFP1);
	TEST_FEATURE_EX(PF_EX_ARM_VFP3D16);
	TEST_FEATURE_EX(PF_EX_ARM_VFP4);
	TEST_FEATURE_EX(PF_EX_ARM_IDIVA);
	TEST_FEATURE_EX(PF_EX_ARM_IDIVT);
#elif defined(_M_E2K)
	TEST_FEATURE(PF_MMX_INSTRUCTIONS_AVAILABLE);
	TEST_FEATURE(PF_3DNOW_INSTRUCTIONS_AVAILABLE);
	TEST_FEATURE(PF_SSE3_INSTRUCTIONS_AVAILABLE);
	printf("\n");
	printf("Extended CPU Flags (not found in windows API):\n");
	TEST_FEATURE_EX(PF_EX_SSSE3);
	TEST_FEATURE_EX(PF_EX_SSE41);
	TEST_FEATURE_EX(PF_EX_SSE42);
	TEST_FEATURE_EX(PF_EX_AVX);
	TEST_FEATURE_EX(PF_EX_FMA);
#endif
	printf("\n");
	return 0;
}
