/*
 *  The 32-bit integer parsing in duk_hstring arridx check needs careful
 *  overflow handling, especially for 10-digit values which can either be
 *  valid, or overflow.
 *
 *  A string can be determined to have the internal 'arridx' flag if it
 *  affects an array length when used as a write index.
 */

/*===
0 true 1 1
123 true 124 124
100000 true 100001 100001
4294967294 true 4294967295 4294967295
4294967168 true 4294967169 4294967169
4294967169 true 4294967170 4294967170
4294967170 true 4294967171 4294967171
4294967171 true 4294967172 4294967172
4294967172 true 4294967173 4294967173
4294967173 true 4294967174 4294967174
4294967174 true 4294967175 4294967175
4294967175 true 4294967176 4294967176
4294967176 true 4294967177 4294967177
4294967177 true 4294967178 4294967178
4294967178 true 4294967179 4294967179
4294967179 true 4294967180 4294967180
4294967180 true 4294967181 4294967181
4294967181 true 4294967182 4294967182
4294967182 true 4294967183 4294967183
4294967183 true 4294967184 4294967184
4294967184 true 4294967185 4294967185
4294967185 true 4294967186 4294967186
4294967186 true 4294967187 4294967187
4294967187 true 4294967188 4294967188
4294967188 true 4294967189 4294967189
4294967189 true 4294967190 4294967190
4294967190 true 4294967191 4294967191
4294967191 true 4294967192 4294967192
4294967192 true 4294967193 4294967193
4294967193 true 4294967194 4294967194
4294967194 true 4294967195 4294967195
4294967195 true 4294967196 4294967196
4294967196 true 4294967197 4294967197
4294967197 true 4294967198 4294967198
4294967198 true 4294967199 4294967199
4294967199 true 4294967200 4294967200
4294967200 true 4294967201 4294967201
4294967201 true 4294967202 4294967202
4294967202 true 4294967203 4294967203
4294967203 true 4294967204 4294967204
4294967204 true 4294967205 4294967205
4294967205 true 4294967206 4294967206
4294967206 true 4294967207 4294967207
4294967207 true 4294967208 4294967208
4294967208 true 4294967209 4294967209
4294967209 true 4294967210 4294967210
4294967210 true 4294967211 4294967211
4294967211 true 4294967212 4294967212
4294967212 true 4294967213 4294967213
4294967213 true 4294967214 4294967214
4294967214 true 4294967215 4294967215
4294967215 true 4294967216 4294967216
4294967216 true 4294967217 4294967217
4294967217 true 4294967218 4294967218
4294967218 true 4294967219 4294967219
4294967219 true 4294967220 4294967220
4294967220 true 4294967221 4294967221
4294967221 true 4294967222 4294967222
4294967222 true 4294967223 4294967223
4294967223 true 4294967224 4294967224
4294967224 true 4294967225 4294967225
4294967225 true 4294967226 4294967226
4294967226 true 4294967227 4294967227
4294967227 true 4294967228 4294967228
4294967228 true 4294967229 4294967229
4294967229 true 4294967230 4294967230
4294967230 true 4294967231 4294967231
4294967231 true 4294967232 4294967232
4294967232 true 4294967233 4294967233
4294967233 true 4294967234 4294967234
4294967234 true 4294967235 4294967235
4294967235 true 4294967236 4294967236
4294967236 true 4294967237 4294967237
4294967237 true 4294967238 4294967238
4294967238 true 4294967239 4294967239
4294967239 true 4294967240 4294967240
4294967240 true 4294967241 4294967241
4294967241 true 4294967242 4294967242
4294967242 true 4294967243 4294967243
4294967243 true 4294967244 4294967244
4294967244 true 4294967245 4294967245
4294967245 true 4294967246 4294967246
4294967246 true 4294967247 4294967247
4294967247 true 4294967248 4294967248
4294967248 true 4294967249 4294967249
4294967249 true 4294967250 4294967250
4294967250 true 4294967251 4294967251
4294967251 true 4294967252 4294967252
4294967252 true 4294967253 4294967253
4294967253 true 4294967254 4294967254
4294967254 true 4294967255 4294967255
4294967255 true 4294967256 4294967256
4294967256 true 4294967257 4294967257
4294967257 true 4294967258 4294967258
4294967258 true 4294967259 4294967259
4294967259 true 4294967260 4294967260
4294967260 true 4294967261 4294967261
4294967261 true 4294967262 4294967262
4294967262 true 4294967263 4294967263
4294967263 true 4294967264 4294967264
4294967264 true 4294967265 4294967265
4294967265 true 4294967266 4294967266
4294967266 true 4294967267 4294967267
4294967267 true 4294967268 4294967268
4294967268 true 4294967269 4294967269
4294967269 true 4294967270 4294967270
4294967270 true 4294967271 4294967271
4294967271 true 4294967272 4294967272
4294967272 true 4294967273 4294967273
4294967273 true 4294967274 4294967274
4294967274 true 4294967275 4294967275
4294967275 true 4294967276 4294967276
4294967276 true 4294967277 4294967277
4294967277 true 4294967278 4294967278
4294967278 true 4294967279 4294967279
4294967279 true 4294967280 4294967280
4294967280 true 4294967281 4294967281
4294967281 true 4294967282 4294967282
4294967282 true 4294967283 4294967283
4294967283 true 4294967284 4294967284
4294967284 true 4294967285 4294967285
4294967285 true 4294967286 4294967286
4294967286 true 4294967287 4294967287
4294967287 true 4294967288 4294967288
4294967288 true 4294967289 4294967289
4294967289 true 4294967290 4294967290
4294967290 true 4294967291 4294967291
4294967291 true 4294967292 4294967292
4294967292 true 4294967293 4294967293
4294967293 true 4294967294 4294967294
4294967294 true 4294967295 4294967295
4294961234 true 4294961235 4294961235
===*/

function test() {
    var i;

    function f(str) {
        var arridx = false;
        var arr1, arr2;

        arr1 = []; arr1[str] = 1;
        if (arr1.length !== 0) { arridx = true; }
        arr2 = [ 1 ]; arr2[str] = 1;
        if (arr2.length !== 1) { arridx = true; }

        if (arridx) {
            print(str, arridx, arr1.length, arr2.length);
        }
    }

    vals = [
        // Basic cases
        '', '0', '+0', '-0',
        '123',
        '100000',

        // Valid 32-bit boundary
        '4294967294',  // highest arridx
        '4294967295',  // 32-bit, no longer arridx
        '4294967296'   // not 32-bit
    ];

    // Transition to overflow
    for (i = 0xffffff80; i <= 0x100000080; i++) {
        vals.push(String(i));
    }

    // 10-digit values above overflow
    for (i = 429496; i <= 1000000; i++) {
        vals.push(String(i) + '1234');
    }

    vals.forEach(function (v) {
        f(v);
    });
}

try {
    test();
} catch (e) {
    print(e.stack || e);
}
