/* -*- Mode: vala; tab-width: 4; intend-tabs-mode: t -*- */
/* alm
 *
 * Copyright (C) 2012 Seif Lotfy <seif@lotfy.com>
 * Copyright (C) 2012 Manish Sinha <manishsinha@ubuntu.com>
 * Copyright (C) 2012 Intel Corp.
 *               Authored by: Seif Lotfy <seif.lotfy@collabora.co.uk>
 *
alm is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * alm is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

using Gtk;
using Zeitgeist;

namespace Alm {

	public class CalendarDialog : Gtk.Dialog {
		private Calendar calendar;
		public CalendarDialog () {
			Object();
			this.calendar = new Calendar();
			((Gtk.Container) this.get_content_area ()).add(this.calendar);
			this.set_decorated(false);
			this.set_position(0);
			this.set_property("skip-taskbar-hint", true);
		}
		public Calendar get_calendar_widget () {
			return calendar;
		}
	
	}
	
	public class CalendarWidget : Gtk.Grid {
		
		private Entry start_entry;
		private Entry end_entry;
		private CalendarDialog start_dialog;
		private CalendarDialog end_dialog;
		private Gtk.Button button;
		private Label invalid_label;
		
		public CalendarWidget (Gtk.Button button) {
			Object ();
			
			this.button = button;
			start_dialog = new CalendarDialog();
			end_dialog = new CalendarDialog();
			
			this.set_row_spacing(10);
			this.set_column_spacing(15);
			
			var box1 = new Box(Orientation.HORIZONTAL, 0);
			start_entry = new Entry();
			var start_button = new Button();
			var arrow1 = new Arrow(Gtk.ArrowType.DOWN, 0);
			start_button.add(arrow1);
			start_entry.set_editable(false);
			start_entry.set_size_request(100, -1);
			box1.pack_start(start_entry, true, true, 0);
			box1.pack_start(start_button, true, true, 0);
			start_button.clicked.connect(() => {
				on_clicked (start_button, start_entry, start_dialog);
				});
			
			var box2 = new Box(Orientation.HORIZONTAL, 0);
			end_entry = new Entry();
			var end_button = new Button();
			var arrow2 = new Arrow(Gtk.ArrowType.DOWN, 0);
			end_button.add(arrow2);
			end_entry.set_editable(false);
			end_entry.set_size_request(100, -1);
			box2.pack_start(end_entry, true, true, 0);
			box2.pack_start(end_button, true, true, 0);
			end_button.clicked.connect(() => {
				on_clicked (end_button, end_entry, end_dialog);
				});
			
			//this.pack_start(label_box, true, true, 0);
			//this.pack_start(combo_box_box, false, false, 9);
			
			var start_label = new Label("");
			start_label.set_markup(_("From:"));
			start_label.set_alignment(1, 0/5);
			
			var end_label = new Label("");
			end_label.set_markup(_("To:"));
			//end_label.set_alignment(1, 0/5);
			
			//combo_box_box.pack_start(start_entry, true, true, 0);
			//combo_box_box.pack_start(end_entry, true, true, 0);
			//this.add(start_label);
			this.attach(box1, 1, 0, 1, 1);
			this.attach(end_label, 2, 0, 1, 1);
			this.attach(box2, 3, 0, 1, 1);
			
			this.invalid_label = new Gtk.Label("");
			invalid_label.set_markup("<span color='red'><b>%s</b></span>".printf(_("Invalid Timerange")));
			
			this.set_up_calendar(start_button, start_entry, start_dialog);
			this.set_up_calendar(end_button, end_entry, end_dialog);
			
			this.show_all();
		}
		
		public TimeRange get_range() {
			var calendar = start_dialog.get_calendar_widget();
			uint year;
			uint month;
			uint day;
			calendar.get_date(out year, out month, out day);
			DateTime date = new DateTime.local((int)year, (int)month+1, (int)day, 0, 0 ,0);
			var start = date.to_unix()*1000;
			
			calendar = end_dialog.get_calendar_widget();
			calendar.get_date(out year, out month, out day);
			date = new DateTime.local((int)year, (int)month+1, (int)day, 0, 0 ,0);
			var end = date.to_unix()*1000;
				
			
			//
			if (start > end) {
				this.button.set_sensitive(false);
				if (this.invalid_label.get_parent() == null)
					this.attach(this.invalid_label, 2, 0, 1, 2);
				this.invalid_label.show();
			}
			else {
				this.button.set_sensitive(true);
				this.invalid_label.hide();
			}
			
			return new TimeRange(start, end);
		}
		
		public void set_up_calendar(Button widget, Entry entry, CalendarDialog dialog) {
			var calendar = dialog.get_calendar_widget();
			uint year;
			uint month;
			uint day;
			calendar.get_date(out year, out month, out day);
		
			DateTime date = new DateTime.local((int)year, (int)month+1, (int)day, 0, 0 ,0);
			var date_string = date.format(_("%d %B %Y"));
			entry.set_text(date_string);
			widget.set_sensitive(true);
			dialog.hide();
		}
		
		public void on_clicked(Widget widget, Entry entry, CalendarDialog dialog) {
			dialog.show_all();
			var parent_window = this.get_parent_window();
			int window_x;
			int window_y;
			parent_window.get_position(out window_x, out window_y);
			Allocation allocation;
			entry.get_allocation(out allocation);
			dialog.move(window_x + allocation.x,
				window_y + allocation.y + allocation.height);
			dialog.set_size_request(allocation.width, -1);
			dialog.resizable = false;
			widget.set_sensitive(false);
			dialog.focus_out_event.connect_after((w, e) => {
				dialog.hide();
				widget.set_sensitive(true);
				return false;
			});
			var cal = dialog.get_calendar_widget();
			cal.day_selected_double_click.connect(() => {
				var calendar = dialog.get_calendar_widget();
				uint year;
				uint month;
				uint day;
				calendar.get_date(out year, out month, out day);
				
				DateTime date = new DateTime.local((int)year, (int)month+1, (int)day, 0, 0 ,0);
				var date_string = date.format(_("%d %B %Y"));
				entry.set_text(date_string);
				widget.set_sensitive(true);
				dialog.hide();
				var range = get_range();
			});
		}
	}
}
