/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.DNSTask;

public interface DNSStatefulObject {
    public JmDNSImpl getDns();

    public void associateWithTask(DNSTask var1, DNSState var2);

    public void removeAssociationWithTask(DNSTask var1);

    public boolean isAssociatedWithTask(DNSTask var1, DNSState var2);

    public boolean advanceState(DNSTask var1);

    public boolean revertState();

    public boolean cancelState();

    public boolean closeState();

    public boolean recoverState();

    public boolean isProbing();

    public boolean isAnnouncing();

    public boolean isAnnounced();

    public boolean isCanceling();

    public boolean isCanceled();

    public boolean isClosing();

    public boolean isClosed();

    public boolean waitForAnnounced(long var1);

    public boolean waitForCanceled(long var1);

    public static class DefaultImplementation
    extends ReentrantLock
    implements DNSStatefulObject {
        private static Logger logger = Logger.getLogger(DefaultImplementation.class.getName());
        private static final long serialVersionUID = -3264781576883412227L;
        private volatile JmDNSImpl _dns = null;
        protected volatile DNSTask _task = null;
        protected volatile DNSState _state = DNSState.PROBING_1;
        private final DNSStatefulObjectSemaphore _announcing = new DNSStatefulObjectSemaphore("Announce");
        private final DNSStatefulObjectSemaphore _canceling = new DNSStatefulObjectSemaphore("Cancel");

        @Override
        public JmDNSImpl getDns() {
            return this._dns;
        }

        protected void setDns(JmDNSImpl dns) {
            this._dns = dns;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void associateWithTask(DNSTask task, DNSState state) {
            if (this._task == null && this._state == state) {
                this.lock();
                try {
                    if (this._task == null && this._state == state) {
                        this.setTask(task);
                    }
                }
                finally {
                    this.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAssociationWithTask(DNSTask task) {
            if (this._task == task) {
                this.lock();
                try {
                    if (this._task == task) {
                        this.setTask(null);
                    }
                }
                finally {
                    this.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isAssociatedWithTask(DNSTask task, DNSState state) {
            this.lock();
            try {
                boolean bl = this._task == task && this._state == state;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        protected void setTask(DNSTask task) {
            this._task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setState(DNSState state) {
            this.lock();
            try {
                this._state = state;
                if (this.isAnnounced()) {
                    this._announcing.signalEvent();
                }
                if (this.isCanceled()) {
                    this._canceling.signalEvent();
                    this._announcing.signalEvent();
                }
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean advanceState(DNSTask task) {
            boolean result = true;
            if (this._task == task) {
                this.lock();
                try {
                    if (this._task == task) {
                        this.setState(this._state.advance());
                    } else {
                        logger.warning("Trying to advance state whhen not the owner. owner: " + this._task + " perpetrator: " + task);
                    }
                }
                finally {
                    this.unlock();
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean revertState() {
            boolean result = true;
            if (!this.willCancel()) {
                this.lock();
                try {
                    if (!this.willCancel()) {
                        this.setState(this._state.revert());
                        this.setTask(null);
                    }
                }
                finally {
                    this.unlock();
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancelState() {
            boolean result = false;
            if (!this.willCancel()) {
                this.lock();
                try {
                    if (!this.willCancel()) {
                        this.setState(DNSState.CANCELING_1);
                        this.setTask(null);
                        result = true;
                    }
                }
                finally {
                    this.unlock();
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean closeState() {
            boolean result = false;
            if (!this.willClose()) {
                this.lock();
                try {
                    if (!this.willClose()) {
                        this.setState(DNSState.CLOSING);
                        this.setTask(null);
                        result = true;
                    }
                }
                finally {
                    this.unlock();
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean recoverState() {
            boolean result = false;
            this.lock();
            try {
                this.setState(DNSState.PROBING_1);
                this.setTask(null);
            }
            finally {
                this.unlock();
            }
            return result;
        }

        @Override
        public boolean isProbing() {
            return this._state.isProbing();
        }

        @Override
        public boolean isAnnouncing() {
            return this._state.isAnnouncing();
        }

        @Override
        public boolean isAnnounced() {
            return this._state.isAnnounced();
        }

        @Override
        public boolean isCanceling() {
            return this._state.isCanceling();
        }

        @Override
        public boolean isCanceled() {
            return this._state.isCanceled();
        }

        @Override
        public boolean isClosing() {
            return this._state.isClosing();
        }

        @Override
        public boolean isClosed() {
            return this._state.isClosed();
        }

        private boolean willCancel() {
            return this._state.isCanceled() || this._state.isCanceling();
        }

        private boolean willClose() {
            return this._state.isClosed() || this._state.isClosing();
        }

        @Override
        public boolean waitForAnnounced(long timeout) {
            if (!this.isAnnounced() && !this.willCancel()) {
                this._announcing.waitForEvent(timeout);
            }
            if (!this.isAnnounced()) {
                if (this.willCancel() || this.willClose()) {
                    logger.warning("Wait for announced cancelled: " + this);
                } else {
                    logger.warning("Wait for announced timed out: " + this);
                }
            }
            return this.isAnnounced();
        }

        @Override
        public boolean waitForCanceled(long timeout) {
            if (!this.isCanceled()) {
                this._canceling.waitForEvent(timeout);
            }
            if (!this.isCanceled() && !this.willClose()) {
                logger.warning("Wait for canceled timed out: " + this);
            }
            return this.isCanceled();
        }

        @Override
        public String toString() {
            return (this._dns != null ? "DNS: " + this._dns.getName() : "NO DNS") + " state: " + (Object)((Object)this._state) + " task: " + this._task;
        }
    }

    public static final class DNSStatefulObjectSemaphore {
        private static Logger logger = Logger.getLogger(DNSStatefulObjectSemaphore.class.getName());
        private final String _name;
        private final ConcurrentMap<Thread, Semaphore> _semaphores;

        public DNSStatefulObjectSemaphore(String name) {
            this._name = name;
            this._semaphores = new ConcurrentHashMap<Thread, Semaphore>(50);
        }

        public void waitForEvent(long timeout) {
            Thread thread = Thread.currentThread();
            Semaphore semaphore = (Semaphore)this._semaphores.get(thread);
            if (semaphore == null) {
                semaphore = new Semaphore(1, true);
                semaphore.drainPermits();
                this._semaphores.putIfAbsent(thread, semaphore);
            }
            semaphore = (Semaphore)this._semaphores.get(thread);
            try {
                semaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException exception) {
                logger.log(Level.FINER, "Exception ", exception);
            }
        }

        public void signalEvent() {
            Collection semaphores = this._semaphores.values();
            for (Semaphore semaphore : semaphores) {
                semaphore.release();
                semaphores.remove(semaphore);
            }
        }

        public String toString() {
            StringBuilder aLog = new StringBuilder(1000);
            aLog.append("Semaphore: ");
            aLog.append(this._name);
            if (this._semaphores.size() == 0) {
                aLog.append(" no semaphores.");
            } else {
                aLog.append(" semaphores:\n");
                for (Thread thread : this._semaphores.keySet()) {
                    aLog.append("\tThread: ");
                    aLog.append(thread.getName());
                    aLog.append(' ');
                    aLog.append(this._semaphores.get(thread));
                    aLog.append('\n');
                }
            }
            return aLog.toString();
        }
    }
}

