#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Anna Lea
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Leisure Suit Larry 1
# send your bug reports to contact@dotslashplay.it
###

script_version=20231002.1

PLAYIT_COMPATIBILITY_LEVEL='2.26'

GAME_ID='leisure-suit-larry-1'
GAME_NAME='Leisure Suit Larry 1: In the Land of the Lounge Lizards'

ARCHIVE_BASE_AGI_0='leisure_suit_larry_en_gog_2_20270.sh'
ARCHIVE_BASE_AGI_0_MD5='bfd706b6e10333f538e30df3ccc572a4'
ARCHIVE_BASE_AGI_0_SIZE='94000'
ARCHIVE_BASE_AGI_0_VERSION='2-gog20270'
ARCHIVE_BASE_AGI_0_URL='https://www.gog.com/game/leisure_suit_larry'

ARCHIVE_BASE_SCI_0='leisure_suit_larry_vga_en_gog_2_20240.sh'
ARCHIVE_BASE_SCI_0_MD5='40b241062ea3945e20e2d3c8fc811e0c'
ARCHIVE_BASE_SCI_0_SIZE='97000'
ARCHIVE_BASE_SCI_0_VERSION='2-gog20240'
ARCHIVE_BASE_SCI_0_URL='https://www.gog.com/game/leisure_suit_larry'

CONTENT_PATH_DEFAULT='data/noarch/data'
CONTENT_GAME_MAIN_FILES_AGI='
vol.*
object
*dir
words.tok'
CONTENT_GAME_MAIN_FILES_SCI='
*.bat
*.drv
*.exe
*.hlp
*.txt
resource.*
version'
CONTENT_DOC_MAIN_PATH='data/noarch/docs'
CONTENT_DOC_MAIN_FILES='
*.pdf
lsl1?answers.txt
lsl1?vga?answers.txt'

APP_MAIN_SCUMMID_AGI='lsl1'
APP_MAIN_SCUMMID_SCI='lsl1sci'
APP_MAIN_ICON='../support/icon.png'

PKG_MAIN_ID="$GAME_ID"
PKG_MAIN_PROVIDES="
$PKG_MAIN_ID"
PKG_MAIN_ID_AGI="${PKG_MAIN_ID}-agi"
PKG_MAIN_ID_SCI="${PKG_MAIN_ID}-sci"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

icons_inclusion
content_inclusion_default

# Write launchers

launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
