/*###############################################################################
# Linux Management Providers (LMP), System Memory provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_MEMORYCAPABILITIESACCESS_H_
#define OPENDRIM_MEMORYCAPABILITIESACCESS_H_

#include "SystemMemory_Common.h"

#include "OpenDRIM_MemoryCapabilities.h"
#include "assocOpenDRIM_MemoryCapabilities.h"

int SystemMemory_OpenDRIM_MemoryCapabilities_load(const CMPIBroker* broker, string& errorMessage);

int SystemMemory_OpenDRIM_MemoryCapabilities_unload(string& errorMessage);

int SystemMemory_OpenDRIM_MemoryCapabilities_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_MemoryCapabilities>& instances, const char** properties, string& errorMessage, const string& discriminant);

int SystemMemory_OpenDRIM_MemoryCapabilities_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_MemoryCapabilities& instance, const char** properties, string& errorMessage);

int SystemMemory_OpenDRIM_MemoryCapabilities_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_MemoryCapabilities& newInstance, const OpenDRIM_MemoryCapabilities& oldInstance, const char** properties, string& errorMessage);

int SystemMemory_OpenDRIM_MemoryCapabilities_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_MemoryCapabilities& instance, string& errorMessage);

int SystemMemory_OpenDRIM_MemoryCapabilities_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_MemoryCapabilities& instance, string& errorMessage);

int SystemMemory_OpenDRIM_MemoryCapabilities_associatorCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int SystemMemory_OpenDRIM_MemoryCapabilities_associatorManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& Capabilities_associatedInstances, string& errorMessage, const string& discriminant);

int SystemMemory_OpenDRIM_MemoryCapabilities_referenceCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_MemoryCapabilities>& OpenDRIM_MemoryCapabilities_instances, const char** properties, string& errorMessage, const string& discriminant);

int SystemMemory_OpenDRIM_MemoryCapabilities_referenceManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& Capabilities_instances, vector<OpenDRIM_MemoryCapabilities>& OpenDRIM_MemoryCapabilities_instances, const char** properties, string& errorMessage, const string& discriminant);

int SystemMemory_OpenDRIM_MemoryCapabilities_populate(OpenDRIM_MemoryCapabilities& instance, string& errorMessage);

#endif /*OPENDRIM_MEMORYCAPABILITIESACCESS_H_*/
