#!/bin/sh

BASEDIR="."
OUTFILE="${BASEDIR}/htmlstrings.h"

echo "/*********************************************************/" > ${OUTFILE}
echo "/* This file is automatically generated by running the   */" >> ${OUTFILE}
echo "/* buildhtmlstrings.sh script which parses translatable  */" >> ${OUTFILE}
echo "/* strings from .qsp and .qjs files under the html       */" >> ${OUTFILE}
echo "/* subdirectory using getTransStringsFromFile.pl.  This  */" >> ${OUTFILE}
echo "/* file should be regenerated before running lupdate in  */" >> ${OUTFILE}
echo "/* the i18n directory to regenerate the i18n/*.ts files. */" >> ${OUTFILE}
echo "/*********************************************************/" >> ${OUTFILE}
echo >> ${OUTFILE}
echo "void html_strings_null() {" >> ${OUTFILE}

find ${BASEDIR}/ -type f | egrep "\.(qsp|qjs)$" | sort | while read FILE
do
    echo "Checking: ${FILE}"
    ${BASEDIR}/getTransStringsFromFile.pl ${BASEDIR}/${FILE} ${FILE} >> ${OUTFILE}
done

echo "    QString()" >> ${OUTFILE}
echo "}" >> ${OUTFILE}

echo "================================================================="
cat ${OUTFILE}
