/* ASN1Codes.h

   Copyright (C)  David C. J. Matthews 2004  dm at prolingua.co.uk

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
   Or, point your browser to http://www.gnu.org/copyleft/gpl.html

*/
#ifndef ASN1CODES_H
#define ASN1CODES_H

// Universal codes _ standard across all ASN1 definitions
enum UNIVERSAL_CODES {
    U_BOOL      = 1,
    U_INT       = 2,
    U_STRING    = 4,
    U_NULL      = 5,
    U_ENUM      = 10,
    U_SEQUENCE  = 16,
};

// Context_specific codes _ defined for MHEG 5
enum SPECIFIC_CODES {
    C_APPLICATION               = 0,
    C_SCENE                     = 1,
    C_STANDARD_IDENTIFIER       = 2,
    C_STANDARD_VERSION          = 3,
    C_OBJECT_INFORMATION        = 4,
    C_ON_START_UP               = 5,
    C_ON_CLOSE_DOWN             = 6,
    C_ORIGINAL_GC_PRIORITY      = 7,
    C_ITEMS                     = 8,
    C_RESIDENT_PROGRAM          = 9,
    C_REMOTE_PROGRAM            = 10,
    C_INTERCHANGED_PROGRAM      = 11,
    C_PALETTE                   = 12,
    C_FONT                      = 13,
    C_CURSOR_SHAPE              = 14,
    C_BOOLEAN_VARIABLE          = 15,
    C_INTEGER_VARIABLE          = 16,
    C_OCTET_STRING_VARIABLE     = 17,
    C_OBJECT_REF_VARIABLE       = 18,
    C_CONTENT_REF_VARIABLE      = 19,
    C_LINK                      = 20,
    C_STREAM                    = 21,
    C_BITMAP                    = 22,
    C_LINE_ART                  = 23,
    C_DYNAMIC_LINE_ART          = 24,
    C_RECTANGLE                 = 25,
    C_HOTSPOT                   = 26,
    C_SWITCH_BUTTON             = 27,
    C_PUSH_BUTTON               = 28,
    C_TEXT                      = 29,
    C_ENTRY_FIELD               = 30,
    C_HYPER_TEXT                = 31,
    C_SLIDER                    = 32,
    C_TOKEN_GROUP               = 33,
    C_LIST_GROUP                = 34,
    C_ON_SPAWN_CLOSE_DOWN       = 35,
    C_ON_RESTART                = 36,
    C_DEFAULT_ATTRIBUTES        = 37,
    C_CHARACTER_SET             = 38,
    C_BACKGROUND_COLOUR         = 39,
    C_TEXT_CONTENT_HOOK         = 40,
    C_TEXT_COLOUR               = 41,
    C_FONT2                     = 42,
    C_FONT_ATTRIBUTES           = 43,
    C_IP_CONTENT_HOOK           = 44,
    C_STREAM_CONTENT_HOOK       = 45,
    C_BITMAP_CONTENT_HOOK       = 46,
    C_LINE_ART_CONTENT_HOOK     = 47,
    C_BUTTON_REF_COLOUR         = 48,
    C_HIGHLIGHT_REF_COLOUR      = 49,
    C_SLIDER_REF_COLOUR         = 50,
    C_INPUT_EVENT_REGISTER      = 51,
    C_SCENE_COORDINATE_SYSTEM   = 52,
    C_ASPECT_RATIO              = 53,
    C_MOVING_CURSOR             = 54,
    C_NEXT_SCENES               = 55,
    C_INITIALLY_ACTIVE          = 56,
    C_CONTENT_HOOK              = 57,
    C_ORIGINAL_CONTENT          = 58,
    C_SHARED                    = 59,
    C_CONTENT_SIZE              = 60,
    C_CONTENT_CACHE_PRIORITY    = 61,
    C_LINK_CONDITION            = 62,
    C_LINK_EFFECT               = 63,
    C_NAME                      = 64,
    C_INITIALLY_AVAILABLE       = 65,
    C_PROGRAM_CONNECTION_TAG    = 66,
    C_ORIGINAL_VALUE            = 67,
    C_OBJECT_REFERENCE          = 68,
    C_CONTENT_REFERENCE         = 69,
    C_MOVEMENT_TABLE            = 70,
    C_TOKEN_GROUP_ITEMS         = 71,
    C_NO_TOKEN_ACTION_SLOTS     = 72,
    C_POSITIONS                 = 73,
    C_WRAP_AROUND               = 74,
    C_MULTIPLE_SELECTION        = 75,
    C_ORIGINAL_BOX_SIZE         = 76,
    C_ORIGINAL_POSITION         = 77,
    C_ORIGINAL_PALETTE_REF      = 78,
    C_TILING                    = 79,
    C_ORIGINAL_TRANSPARENCY     = 80,
    C_BORDERED_BOUNDING_BOX     = 81,
    C_ORIGINAL_LINE_WIDTH       = 82,
    C_ORIGINAL_LINE_STYLE       = 83,
    C_ORIGINAL_REF_LINE_COLOUR  = 84,
    C_ORIGINAL_REF_FILL_COLOUR  = 85,
    C_ORIGINAL_FONT             = 86,
    C_HORIZONTAL_JUSTIFICATION  = 87,
    C_VERTICAL_JUSTIFICATION    = 88,
    C_LINE_ORIENTATION          = 89,
    C_START_CORNER              = 90,
    C_TEXT_WRAPPING             = 91,
    C_MULTIPLEX                 = 92,
    C_STORAGE                   = 93,
    C_LOOPING                   = 94,
    C_AUDIO                     = 95,
    C_VIDEO                     = 96,
    C_RTGRAPHICS                = 97,
    C_COMPONENT_TAG             = 98,
    C_ORIGINAL_VOLUME           = 99,
    C_TERMINATION               = 100,
    C_ENGINE_RESP               = 101,
    C_ORIENTATION               = 102,
    C_MAX_VALUE                 = 103,
    C_MIN_VALUE                 = 104,
    C_INITIAL_VALUE             = 105,
    C_INITIAL_PORTION           = 106,
    C_STEP_SIZE                 = 107,
    C_SLIDER_STYLE              = 108,
    C_INPUT_TYPE                = 109,
    C_CHAR_LIST                 = 110,
    C_OBSCURED_INPUT            = 111,
    C_MAX_LENGTH                = 112,
    C_ORIGINAL_LABEL            = 113,
    C_BUTTON_STYLE              = 114,
    C_ACTIVATE                  = 115,
    C_ADD                       = 116,
    C_ADD_ITEM                  = 117,
    C_APPEND                    = 118,
    C_BRING_TO_FRONT            = 119,
    C_CALL                      = 120,
    C_CALL_ACTION_SLOT          = 121,
    C_CLEAR                     = 122,
    C_CLONE                     = 123,
    C_CLOSE_CONNECTION          = 124,
    C_DEACTIVATE                = 125,
    C_DEL_ITEM                  = 126,
    C_DESELECT                  = 127,
    C_DESELECT_ITEM             = 128,
    C_DIVIDE                    = 129,
    C_DRAW_ARC                  = 130,
    C_DRAW_LINE                 = 131,
    C_DRAW_OVAL                 = 132,
    C_DRAW_POLYGON              = 133,
    C_DRAW_POLYLINE             = 134,
    C_DRAW_RECTANGLE            = 135,
    C_DRAW_SECTOR               = 136,
    C_FORK                      = 137,
    C_GET_AVAILABILITY_STATUS   = 138,
    C_GET_BOX_SIZE              = 139,
    C_GET_CELL_ITEM             = 140,
    C_GET_CURSOR_POSITION       = 141,
    C_GET_ENGINE_SUPPORT        = 142,
    C_GET_ENTRY_POINT           = 143,
    C_GET_FILL_COLOUR           = 144,
    C_GET_FIRST_ITEM            = 145,
    C_GET_HIGHLIGHT_STATUS      = 146,
    C_GET_INTERACTION_STATUS    = 147,
    C_GET_ITEM_STATUS           = 148,
    C_GET_LABEL                 = 149,
    C_GET_LAST_ANCHOR_FIRED     = 150,
    C_GET_LINE_COLOUR           = 151,
    C_GET_LINE_STYLE            = 152,
    C_GET_LINE_WIDTH            = 153,
    C_GET_LIST_ITEM             = 154,
    C_GET_LIST_SIZE             = 155,
    C_GET_OVERWRITE_MODE        = 156,
    C_GET_PORTION               = 157,
    C_GET_POSITION              = 158,
    C_GET_RUNNING_STATUS        = 159,
    C_GET_SELECTION_STATUS      = 160,
    C_GET_SLIDER_VALUE          = 161,
    C_GET_TEXT_CONTENT          = 162,
    C_GET_TEXT_DATA             = 163,
    C_GET_TOKEN_POSITION        = 164,
    C_GET_VOLUME                = 165,
    C_LAUNCH                    = 166,
    C_LOCK_SCREEN               = 167,
    C_MODULO                    = 168,
    C_MOVE                      = 169,
    C_MOVE_TO                   = 170,
    C_MULTIPLY                  = 171,
    C_OPEN_CONNECTION           = 172,
    C_PRELOAD                   = 173,
    C_PUT_BEFORE                = 174,
    C_PUT_BEHIND                = 175,
    C_QUIT                      = 176,
    C_READ_PERSISTENT           = 177,
    C_RUN                       = 178,
    C_SCALE_BITMAP              = 179,
    C_SCALE_VIDEO               = 180,
    C_SCROLL_ITEMS              = 181,
    C_SELECT                    = 182,
    C_SELECT_ITEM               = 183,
    C_SEND_EVENT                = 184,
    C_SEND_TO_BACK              = 185,
    C_SET_BOX_SIZE              = 186,
    C_SET_CACHE_PRIORITY        = 187,
    C_SET_COUNTER_END_POSITION  = 188,
    C_SET_COUNTER_POSITION      = 189,
    C_SET_COUNTER_TRIGGER       = 190,
    C_SET_CURSOR_POSITION       = 191,
    C_SET_CURSOR_SHAPE          = 192,
    C_SET_DATA                  = 193,
    C_SET_ENTRY_POINT           = 194,
    C_SET_FILL_COLOUR           = 195,
    C_SET_FIRST_ITEM            = 196,
    C_SET_FONT_REF              = 197,
    C_SET_HIGHLIGHT_STATUS      = 198,
    C_SET_INTERACTION_STATUS    = 199,
    C_SET_LABEL                 = 200,
    C_SET_LINE_COLOUR           = 201,
    C_SET_LINE_STYLE            = 202,
    C_SET_LINE_WIDTH            = 203,
    C_SET_OVERWRITE_MODE        = 204,
    C_SET_PALETTE_REF           = 205,
    C_SET_PORTION               = 206,
    C_SET_POSITION              = 207,
    C_SET_SLIDER_VALUE          = 208,
    C_SET_SPEED                 = 209,
    C_SET_TIMER                 = 210,
    C_SET_TRANSPARENCY          = 211,
    C_SET_VARIABLE              = 212,
    C_SET_VOLUME                = 213,
    C_SPAWN                     = 214,
    C_STEP                      = 215,
    C_STOP                      = 216,
    C_STORE_PERSISTENT          = 217,
    C_SUBTRACT                  = 218,
    C_TEST_VARIABLE             = 219,
    C_TOGGLE                    = 220,
    C_TOGGLE_ITEM               = 221,
    C_TRANSITION_TO             = 222,
    C_UNLOAD                    = 223,
    C_UNLOCK_SCREEN             = 224,
    C_NEW_GENERIC_BOOLEAN       = 225,
    C_NEW_GENERIC_INTEGER       = 226,
    C_NEW_GENERIC_OCTETSTRING   = 227,
    C_NEW_GENERIC_OBJECT_REF    = 228,
    C_NEW_GENERIC_CONTENT_REF   = 229,
    C_NEW_COLOUR_INDEX          = 230,
    C_NEW_ABSOLUTE_COLOUR       = 231,
    C_NEW_FONT_NAME             = 232,
    C_NEW_FONT_REFERENCE        = 233,
    C_NEW_CONTENT_SIZE          = 234,
    C_NEW_CONTENT_CACHE_PRIO    = 235,
    C_INDIRECTREFERENCE         = 236,
/* UK MHEG */
    C_SET_BACKGROUND_COLOUR     = 237,
    C_SET_CELL_POSITION         = 238,
    C_SET_INPUT_REGISTER        = 239,
    C_SET_TEXT_COLOUR           = 240,
    C_SET_FONT_ATTRIBUTES       = 241,
    C_SET_VIDEO_DECODE_OFFSET   = 242,
    C_GET_VIDEO_DECODE_OFFSET   = 243,
    C_GET_FOCUS_POSITION        = 244,
    C_SET_FOCUS_POSITION        = 245,
    C_SET_BITMAP_DECODE_OFFSET  = 246,
    C_GET_BITMAP_DECODE_OFFSET  = 247,
    C_SET_SLIDER_PARAMETERS     = 248,
// Added in ETSI ES 202 184 V2.1.1 (2010-01)
    C_GET_DESKTOP_COLOUR        = 249,
    C_SET_DESKTOP_COLOUR        = 250,
    C_GET_COUNTER_POSITION      = 251,
    C_GET_COUNTER_MAX_POSITION  = 252,
};

// Pseudo-codes.  These are encoded into the link condition in binary but it's convenient
// to give them codes here since that way we can include them in the same lookup table.
enum PSEUDO_CODES {
    P_EVENT_SOURCE              = 249,
    P_EVENT_TYPE                = 250,
    P_EVENT_DATA                = 251,
// The :ActionSlots tag appears in the textual form but not in binary.
    P_ACTION_SLOTS              = 252,
};

#endif
