/*****************************************************************************/
/*                             ______________________                        */
/*                            / _ _ _ _ _ _ _ _ _ _ _)                       */
/*            ____  ____  _  / /__  __  _____  __                            */
/*           (_  _)( ___)( \/ /(  \/  )(  _  )(  )                           */
/*             )(   )__)  )  (  )    (  )(_)(  )(__                          */
/*            (__) (____)/ /\_)(_/\/\_)(_____)(____)                         */
/*            _ _ _ _ __/ /                                                  */
/*           (___________/                     ___  ___                      */
/*                                      \  )| |   ) _ _|\   )                */
/*                                 ---   \/ | |  / |___| \_/                 */
/*                                                       _/                  */
/*                                                                           */
/*   Copyright (C) The University of Texas at Austin                         */
/*                                                                           */
/*     Authors:    Vinay Siddavanahalli <skvinay@cs.utexas.edu>   2004-2005  */
/*     Authors:     Anthony Thane        <thanea@ices.utexas.edu> 2003-2003  */
/*                                                                           */
/*     Principal Investigator: Chandrajit Bajaj <bajaj@ices.utexas.edu>      */
/*                                                                           */
/*         Professor of Computer Sciences,                                   */
/*         Computational and Applied Mathematics Chair in Visualization,     */
/*         Director, Computational Visualization Center (CVC),               */
/*         Institute of Computational Engineering and Sciences (ICES)        */
/*         The University of Texas at Austin,                                */
/*         201 East 24th Street, ACES 2.324A,                                */
/*         1 University Station, C0200                                       */
/*         Austin, TX 78712-0027                                             */
/*         http://www.cs.utexas.edu/~bajaj                                   */
/*                                                                           */
/*         http://www.ices.utexas.edu/CVC                                    */
/*  This software comes with a license. Using this code implies that you     */
/*  read, understood and agreed to all the terms and conditions in that      */
/*  license.                                                                 */
/*                                                                           */
/*  We request that you agree to acknowledge the use of the software that    */
/*  results in any published work, including scientific papers, films and    */
/*  videotapes by citing the reference listed below                          */
/*                                                                           */
/*    C. Bajaj, P. Djeu, V. Siddavanahalli, A. Thane,                        */
/*    Interactive Visual Exploration of Large Flexible Multi-component       */
/*    Molecular Complexes,                                                   */
/*    Proc. of the Annual IEEE Visualization Conference, October 2004,       */
/*    Austin, Texas, IEEE Computer Society Press, pp. 243-250.               */
/*                                                                           */
/*****************************************************************************/

// Quaternion.h: interface for the Quaternion class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_QUATERNION_H__4A5485F3_5ADE_437D_A2C9_6D864A63C23B__INCLUDED_)
#define AFX_QUATERNION_H__4A5485F3_5ADE_437D_A2C9_6D864A63C23B__INCLUDED_

#include "Tuple.h"

namespace CCVOpenGLMath {

class Vector;
class Matrix;
class Ray;

class Quaternion : public Tuple  
{
public:
	Quaternion();
	virtual ~Quaternion();
	Quaternion(const Quaternion& copy);
	Quaternion& operator=(const Quaternion& copy);
	Quaternion(float w, float x, float y, float z);

	Quaternion& set(float w, float x, float y, float z);
	Quaternion& set(float* array);
	Quaternion& set(const Quaternion& copy);

	Quaternion operator*(const Quaternion& quat) const;
	Quaternion operator*(float scalar) const;
	Quaternion& operator*=(float scalar);
	Quaternion operator/(float scalar) const;
	Quaternion& operator/=(float scalar);

	Quaternion& preMultiply(const Quaternion& quat);
	Quaternion& postMultiply(const Quaternion& quat);
	Quaternion& rotate(float angle, float x, float y, float z);
	Quaternion& normalize();

	Quaternion conjugate() const;
	Quaternion inverse() const;
	float norm() const;

	Vector applyRotation(const Vector& vec) const;
	Ray applyRotation(const Ray& ray) const;
	Matrix buildMatrix() const;
	Quaternion power(double scalar);

        Quaternion slerp(const Quaternion& rhs, const float t) {
                Quaternion lhs = *this;
                Quaternion rv = lhs * ((lhs.inverse() * rhs).power(t));
                return rv;
        }
        // Quaternion operator+(const Quaternion& rhs);
        // Quaternion operator-(const Quaternion& rhs);
        // Quaternion slerp(const Quaternion& rhs, const float t);

        static Quaternion rotation(float angle, float x, float y, float z);
	static Quaternion rotation(float angle, const Vector& axis);
protected:
	explicit Quaternion(const Vector& vec);

};

};

#endif // !defined(AFX_QUATERNION_H__4A5485F3_5ADE_437D_A2C9_6D864A63C23B__INCLUDED_)
